/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I2DFieldI;
import igeo.I3DFieldI;
import igeo.IAgent;
import igeo.IColor;
import igeo.IConfig;
import igeo.IDynamics;
import igeo.IFieldI;
import igeo.IG;
import igeo.ILayer;
import igeo.IVec;
import igeo.IVectorObject;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFieldVisualizer
extends IAgent {
    public static int defaultNum = 10;
    public static IColor defaultMinColor = new IColor(0, 128, 255);
    public static IColor defaultMaxColor = new IColor(255, 0, 0);
    public IVec min;
    public IVec max;
    public int xnum;
    public int ynum;
    public int znum;
    public IVectorObject[][][] arrows;
    public IVec[][][] vectors;
    public float arrowSize = IConfig.arrowSize;
    public float arrowWeight = IConfig.strokeWeight;
    public boolean autoSizeAdjust = true;
    public float arrowSizeRatio = 0.5f;
    public double scale = 1.0;
    public boolean fixLength = true;
    public double fixedLength = 10.0;
    public boolean autoLengthAdjust = true;
    public static double minAutoLengthRatio = 0.05;
    public double minLength = 0.0;
    public double maxLength = 10.0;
    public IColor minColor = defaultMinColor;
    public IColor maxColor = defaultMaxColor;
    public boolean autoColorAdjust = true;
    public double spacing;
    public float alpha = 1.0f;
    public boolean fieldSet = false;
    public boolean updateAlways = false;

    public IFieldVisualizer(IVec iVec, IVec iVec2) {
        this.min = iVec;
        this.max = iVec2;
        this.xnum = iVec.eqX(iVec2) ? 1 : defaultNum;
        this.ynum = iVec.eqY(iVec2) ? 1 : defaultNum;
        this.znum = iVec.eqZ(iVec2) ? 1 : defaultNum;
        this.initVisualizer();
    }

    public IFieldVisualizer(IVec iVec, IVec iVec2, int n, int n2, int n3) {
        this.min = iVec;
        this.max = iVec2;
        this.xnum = n;
        this.ynum = n2;
        this.znum = n3;
        this.initVisualizer();
    }

    public IFieldVisualizer(IVec iVec, double d, double d2, double d3) {
        this(iVec, iVec.cp(d, d2, d3));
    }

    public IFieldVisualizer(IVec iVec, double d, double d2, double d3, int n, int n2, int n3) {
        this(iVec, iVec.cp(d, d2, d3), n, n2, n3);
    }

    public IFieldVisualizer(double d, double d2, double d3, double d4, double d5, double d6) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6));
    }

    public IFieldVisualizer(double d, double d2, double d3, double d4, double d5, double d6, int n, int n2, int n3) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6), n, n2, n3);
    }

    public IFieldVisualizer(IVec iVec, double d, double d2) {
        this(iVec, d, d2, 0.0);
    }

    public IFieldVisualizer(IVec iVec, double d, double d2, int n, int n2) {
        this(iVec, d, d2, 0.0, n, n2, 1);
    }

    public IFieldVisualizer(double d, double d2, double d3, double d4) {
        this(new IVec(d, d2, 0.0), new IVec(d3, d4, 0.0));
    }

    public IFieldVisualizer(double d, double d2) {
        this(new IVec(d, d, d), new IVec(d2, d2, d2));
    }

    public IFieldVisualizer colorRange(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.colorRange(new IColor(n, n2, n3), new IColor(n4, n5, n6));
    }

    public IFieldVisualizer colorRange(int n, int n2, int n3, double d, int n4, int n5, int n6, double d2) {
        return this.colorRange(new IColor(n, n2, n3), d, new IColor(n4, n5, n6), d2);
    }

    public IFieldVisualizer colorRange(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.colorRange(new IColor(f, f2, f3), new IColor(f4, f5, f6));
    }

    public IFieldVisualizer colorRange(float f, float f2, float f3, double d, float f4, float f5, float f6, double d2) {
        return this.colorRange(new IColor(f, f2, f3), d, new IColor(f4, f5, f6), d2);
    }

    public IFieldVisualizer colorRange(Color color, double d, Color color2, double d2) {
        return this.colorRange(new IColor(color), d, new IColor(color2), d2);
    }

    public IFieldVisualizer colorRange(IColor iColor, double d, IColor iColor2, double d2) {
        this.minColor = iColor;
        this.maxColor = iColor2;
        this.autoColorAdjust = false;
        if (this.alpha != 1.0f) {
            iColor = new IColor(iColor.getRed(), iColor.getGreen(), iColor.getBlue(), (int)(this.alpha * 255.0f));
            iColor2 = new IColor(iColor2.getRed(), iColor2.getGreen(), iColor2.getBlue(), (int)(this.alpha * 255.0f));
        }
        return this;
    }

    public IFieldVisualizer colorRange(Color color, Color color2) {
        return this.colorRange(new IColor(color), new IColor(color2));
    }

    public IFieldVisualizer colorRange(IColor iColor, IColor iColor2) {
        this.minColor = iColor;
        this.maxColor = iColor2;
        this.autoColorAdjust = true;
        if (this.alpha != 1.0f) {
            this.minColor = new IColor(this.minColor.getRed(), this.minColor.getGreen(), this.minColor.getBlue(), (int)(this.alpha * 255.0f));
            this.maxColor = new IColor(this.maxColor.getRed(), this.maxColor.getGreen(), this.maxColor.getBlue(), (int)(this.alpha * 255.0f));
        }
        return this;
    }

    public IFieldVisualizer alpha(float f) {
        this.alpha = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        this.minColor = new IColor(this.minColor.getRed(), this.minColor.getGreen(), this.minColor.getBlue(), (int)(this.alpha * 255.0f));
        this.maxColor = new IColor(this.maxColor.getRed(), this.maxColor.getGreen(), this.maxColor.getBlue(), (int)(this.alpha * 255.0f));
        return this;
    }

    public IFieldVisualizer alpha(int n) {
        return this.alpha((float)n / 255.0f);
    }

    public IColor minColor() {
        return this.minColor;
    }

    public IColor maxColor() {
        return this.maxColor;
    }

    public double minLength() {
        return this.minLength;
    }

    public double maxLength() {
        return this.maxLength;
    }

    public IFieldVisualizer adjustColorAuto(boolean bl) {
        this.autoColorAdjust = bl;
        return this;
    }

    public IFieldVisualizer adjustLengthAuto(boolean bl) {
        this.autoLengthAdjust = bl;
        return this;
    }

    public IFieldVisualizer adjustColorAutomatically(boolean bl) {
        return this.adjustColorAuto(bl);
    }

    public IFieldVisualizer adjustLengthAutomatically(boolean bl) {
        return this.adjustLengthAuto(bl);
    }

    public IFieldVisualizer adjustSizeAuto(boolean bl) {
        this.autoSizeAdjust = bl;
        if (bl) {
            this.scale = 1.0;
        }
        return this;
    }

    public IFieldVisualizer adjustSizeAutomatically(boolean bl) {
        return this.adjustSizeAuto(bl);
    }

    public IFieldVisualizer adjustSizeAuto(float f) {
        this.autoSizeAdjust = true;
        this.arrowSizeRatio = f;
        return this;
    }

    public IFieldVisualizer adjustSizeAutomatically(float f) {
        return this.adjustSizeAuto(f);
    }

    public IFieldVisualizer arrowSizeRatio(float f) {
        this.arrowSizeRatio = f;
        return this;
    }

    public IFieldVisualizer fixLength(double d) {
        this.fixedLength = d;
        this.fixLength = true;
        return this;
    }

    public IFieldVisualizer fixLength() {
        this.fixLength = true;
        return this;
    }

    public IFieldVisualizer fixLength(boolean bl) {
        this.fixLength = bl;
        return this;
    }

    public IFieldVisualizer scale(double d) {
        this.scale = d;
        return this;
    }

    public IFieldVisualizer scaleLength(double d) {
        return this.scale(d);
    }

    public double scale() {
        return this.scale;
    }

    public double scaleLength() {
        return this.scale();
    }

    public IFieldVisualizer arrowSize(float f) {
        return this.size(f);
    }

    public IFieldVisualizer size(float f) {
        this.arrowSize = f;
        if (this.arrows != null) {
            for (int i = 0; i < this.arrows.length; ++i) {
                for (int j = 0; j < this.arrows[i].length; ++j) {
                    for (int k = 0; k < this.arrows[i][j].length; ++k) {
                        this.arrows[i][j][k].size(this.arrowSize);
                    }
                }
            }
        }
        return this;
    }

    public IFieldVisualizer arrowWeight(float f) {
        return this.weight(f);
    }

    @Override
    public IFieldVisualizer weight(float f) {
        this.arrowWeight = f;
        if (this.arrows != null) {
            for (int i = 0; i < this.arrows.length; ++i) {
                for (int j = 0; j < this.arrows[i].length; ++j) {
                    for (int k = 0; k < this.arrows[i][j].length; ++k) {
                        this.arrows[i][j][k].weight(this.arrowWeight);
                    }
                }
            }
        }
        return this;
    }

    public IFieldVisualizer updateAlways(boolean bl) {
        this.updateAlways = bl;
        return this;
    }

    public synchronized void initVisualizer() {
        int n;
        int n2;
        int n3;
        if (this.xnum < 1) {
            this.xnum = 1;
        }
        if (this.ynum < 1) {
            this.ynum = 1;
        }
        if (this.znum < 1) {
            this.znum = 1;
        }
        if (this.arrows != null) {
            for (n3 = 0; n3 < this.arrows.length; ++n3) {
                for (n2 = 0; n2 < this.arrows[n3].length; ++n2) {
                    for (n = 0; n < this.arrows[n3][n2].length; ++n) {
                        this.arrows[n3][n2][n].del();
                        this.arrows[n3][n2][n] = null;
                    }
                }
            }
        }
        this.arrows = new IVectorObject[this.xnum][this.ynum][this.znum];
        this.vectors = new IVec[this.xnum][this.ynum][this.znum];
        for (n3 = 0; n3 < this.arrows.length; ++n3) {
            for (n2 = 0; n2 < this.arrows[n3].length; ++n2) {
                for (n = 0; n < this.arrows[n3][n2].length; ++n) {
                    IVec iVec = this.gridPos(n3, n2, n);
                    this.arrows[n3][n2][n] = new IVectorObject(this.server(), new IVec(), iVec);
                    this.arrows[n3][n2][n].size(this.arrowSize);
                    this.arrows[n3][n2][n].weight(this.arrowWeight);
                    this.vectors[n3][n2][n] = new IVec();
                }
            }
        }
        this.spacing = -1.0;
        if (this.xnum >= 2) {
            this.spacing = this.arrows[0][0][0].root().dist(this.arrows[1][0][0].root());
        }
        if (this.ynum >= 2) {
            double d = this.arrows[0][0][0].root().dist(this.arrows[0][1][0].root());
            if (this.spacing < 0.0 || d < this.spacing) {
                this.spacing = d;
            }
        }
        if (this.znum >= 2) {
            double d = this.arrows[0][0][0].root().dist(this.arrows[0][0][1].root());
            if (this.spacing < 0.0 || d < this.spacing) {
                this.spacing = d;
            }
        }
        if (this.spacing < 0.0) {
            this.spacing = 10.0;
        }
    }

    public IVec gridPos(int n, int n2, int n3) {
        IVec iVec = this.max.dif(this.min);
        iVec.x = this.xnum > 1 ? (iVec.x *= (double)n / (double)(this.xnum - 1)) : 0.0;
        iVec.y = this.ynum > 1 ? (iVec.y *= (double)n2 / (double)(this.ynum - 1)) : 0.0;
        iVec.z = this.znum > 1 ? (iVec.z *= (double)n3 / (double)(this.znum - 1)) : 0.0;
        return iVec.add(this.min);
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        if (!this.fieldSet || this.updateAlways) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.vectors.length; ++n2) {
                for (int i = 0; i < this.vectors[n2].length; ++i) {
                    for (n = 0; n < this.vectors[n2][i].length; ++n) {
                        this.vectors[n2][i][n].zero();
                    }
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                int n3;
                int n4;
                IFieldI iFieldI;
                if (arrayList.get(n2) instanceof I3DFieldI) {
                    iFieldI = (I3DFieldI)((Object)arrayList.get(n2));
                    for (n = 0; n < this.vectors.length; ++n) {
                        for (n4 = 0; n4 < this.vectors[n].length; ++n4) {
                            for (n3 = 0; n3 < this.vectors[n][n4].length; ++n3) {
                                this.vectors[n][n4][n3].add(iFieldI.get(this.arrows[n][n4][n3].root()));
                            }
                        }
                    }
                    continue;
                }
                if (!(arrayList.get(n2) instanceof I2DFieldI)) continue;
                iFieldI = (I2DFieldI)((Object)arrayList.get(n2));
                for (n = 0; n < this.vectors.length; ++n) {
                    for (n4 = 0; n4 < this.vectors[n].length; ++n4) {
                        for (n3 = 0; n3 < this.vectors[n][n4].length; ++n3) {
                            this.vectors[n][n4][n3].add(iFieldI.get(this.arrows[n][n4][n3].root()).to3d());
                        }
                    }
                }
            }
            if (this.autoColorAdjust || this.autoLengthAdjust) {
                for (n2 = 0; n2 < this.vectors.length; ++n2) {
                    for (int i = 0; i < this.vectors[n2].length; ++i) {
                        for (n = 0; n < this.vectors[n2][i].length; ++n) {
                            double d = this.vectors[n2][i][n].len();
                            if (n2 == 0 && i == 0 && n == 0) {
                                this.minLength = this.maxLength = d;
                                continue;
                            }
                            if (d < this.minLength) {
                                this.minLength = d;
                            }
                            if (!(d > this.maxLength)) continue;
                            this.maxLength = d;
                        }
                    }
                }
            }
            for (n2 = 0; n2 < this.arrows.length; ++n2) {
                for (int i = 0; i < this.arrows[n2].length; ++i) {
                    for (n = 0; n < this.arrows[n2][i].length; ++n) {
                        double d;
                        double d2;
                        if (this.minColor != null && this.maxColor != null) {
                            d2 = this.vectors[n2][i][n].len();
                            if (IG.eq(this.minLength, this.maxLength)) {
                                this.arrows[n2][i][n].clr(this.maxColor);
                            } else if (d2 <= this.minLength) {
                                this.arrows[n2][i][n].clr(this.minColor);
                            } else if (d2 >= this.maxLength) {
                                this.arrows[n2][i][n].clr(this.maxColor);
                            } else {
                                d = (d2 - this.minLength) / (this.maxLength - this.minLength);
                                int n5 = (int)((double)(this.maxColor.getRed() - this.minColor.getRed()) * d + (double)this.minColor.getRed());
                                int n6 = (int)((double)(this.maxColor.getGreen() - this.minColor.getGreen()) * d + (double)this.minColor.getGreen());
                                int n7 = (int)((double)(this.maxColor.getBlue() - this.minColor.getBlue()) * d + (double)this.minColor.getBlue());
                                int n8 = (int)((double)(this.maxColor.getAlpha() - this.minColor.getAlpha()) * d + (double)this.minColor.getAlpha());
                                this.arrows[n2][i][n].clr(n5, n6, n7, n8);
                            }
                        }
                        if (this.vectors[n2][i][n].len() > IConfig.tolerance) {
                            if (this.fixLength) {
                                if (this.autoLengthAdjust) {
                                    this.vectors[n2][i][n].len(this.spacing * this.scale);
                                } else {
                                    this.vectors[n2][i][n].len(this.fixedLength);
                                }
                            } else if (this.autoLengthAdjust) {
                                d2 = 1.0;
                                if (!IG.eq(this.minLength, this.maxLength)) {
                                    d = this.vectors[n2][i][n].len();
                                    d2 = (d - this.minLength) / (this.maxLength - this.minLength);
                                }
                                if ((d2 *= this.scale) < minAutoLengthRatio) {
                                    d2 = minAutoLengthRatio;
                                }
                                this.vectors[n2][i][n].len(d2 * this.spacing);
                            } else {
                                this.vectors[n2][i][n].mul(this.scale);
                            }
                            if (this.autoSizeAdjust) {
                                this.arrows[n2][i][n].size(this.vectors[n2][i][n].len() * (double)this.arrowSizeRatio);
                            }
                            this.arrows[n2][i][n].vector().set(this.vectors[n2][i][n]);
                            this.arrows[n2][i][n].updateGraphic();
                            if (this.arrows[n2][i][n].visible()) continue;
                            this.arrows[n2][i][n].show();
                            continue;
                        }
                        this.arrows[n2][i][n].hide();
                    }
                }
            }
            this.fieldSet = true;
        }
    }

    public IFieldVisualizer updateFiled() {
        this.fieldSet = false;
        return this;
    }

    @Override
    public IFieldVisualizer name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IFieldVisualizer layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IFieldVisualizer hide() {
        super.hide();
        return this;
    }

    @Override
    public IFieldVisualizer show() {
        super.show();
        return this;
    }
}

