/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDoubleI;
import igeo.IMatrix;
import igeo.IMatrix3I;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVecI;

public class IMatrix3
extends IMatrix
implements IMatrix3I {
    public IMatrix3() {
        super(3, 3);
        this.setZero();
    }

    public IMatrix3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super(3, 3);
        this.set(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public IMatrix3(IMatrix3 iMatrix3) {
        super(3, 3);
        this.set(iMatrix3.val);
    }

    public IMatrix3 get() {
        return this;
    }

    public IMatrix3 set(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.val[0][0] = d;
        this.val[0][1] = d2;
        this.val[0][2] = d3;
        this.val[1][0] = d4;
        this.val[1][1] = d5;
        this.val[1][2] = d6;
        this.val[2][0] = d7;
        this.val[2][1] = d8;
        this.val[2][2] = d9;
        return this;
    }

    public IMatrix3 set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6, IDoubleI iDoubleI7, IDoubleI iDoubleI8, IDoubleI iDoubleI9) {
        return this.set(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x(), iDoubleI4.x(), iDoubleI5.x(), iDoubleI6.x(), iDoubleI7.x(), iDoubleI8.x(), iDoubleI9.x());
    }

    public IMatrix3 dup() {
        return new IMatrix3(this);
    }

    public IMatrix3 cp() {
        return this.dup();
    }

    public double determinant() {
        return this.val[0][0] * IMatrix3.det(this.val[1][1], this.val[1][2], this.val[2][1], this.val[2][2]) + this.val[0][1] * IMatrix3.det(this.val[1][2], this.val[1][0], this.val[2][2], this.val[2][0]) + this.val[0][2] * IMatrix3.det(this.val[1][0], this.val[1][1], this.val[2][0], this.val[2][1]);
    }

    public IMatrix3 invert() {
        double d = this.determinant();
        this.set(this.val[1][1] * this.val[2][2] - this.val[1][2] * this.val[2][1], this.val[0][2] * this.val[2][1] - this.val[0][1] * this.val[2][2], this.val[0][1] * this.val[1][2] - this.val[0][2] * this.val[1][1], this.val[1][2] * this.val[2][0] - this.val[1][0] * this.val[2][2], this.val[0][0] * this.val[2][2] - this.val[0][2] * this.val[2][0], this.val[0][2] * this.val[1][0] - this.val[0][0] * this.val[1][2], this.val[1][0] * this.val[2][1] - this.val[1][1] * this.val[2][0], this.val[0][1] * this.val[2][0] - this.val[0][0] * this.val[2][1], this.val[0][0] * this.val[1][1] - this.val[0][1] * this.val[1][0]);
        this.div(d);
        return this;
    }

    public IMatrix3 mul(IMatrix3 iMatrix3) {
        for (int i = 0; i < 3; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < 3; ++j) {
                d += this.val[i][j] * iMatrix3.val[j][0];
                d2 += this.val[i][j] * iMatrix3.val[j][1];
                d3 += this.val[i][j] * iMatrix3.val[j][2];
            }
            this.val[i][0] = d;
            this.val[i][1] = d2;
            this.val[i][2] = d3;
        }
        return this;
    }

    public IMatrix3 mul(IMatrix3I iMatrix3I) {
        return this.mul(iMatrix3I.get());
    }

    public IVec mul(IVecI iVecI) {
        return this.mul(iVecI.get());
    }

    public IVec mul(IVec iVec) {
        IVec iVec2 = new IVec();
        iVec2.x = this.val[0][0] * iVec.x + this.val[0][1] * iVec.y + this.val[0][2] * iVec.z;
        iVec2.y = this.val[1][0] * iVec.x + this.val[1][1] * iVec.y + this.val[1][2] * iVec.z;
        iVec2.z = this.val[2][0] * iVec.x + this.val[2][1] * iVec.y + this.val[2][2] * iVec.z;
        return iVec2;
    }

    public IVec2 mul(IVec2I iVec2I) {
        return this.mul(iVec2I.get());
    }

    public IVec2 mul(IVec2 iVec2) {
        IVec2 iVec22 = new IVec2();
        iVec22.x = this.val[0][0] * iVec2.x + this.val[0][1] * iVec2.y + this.val[0][2];
        iVec22.y = this.val[1][0] * iVec2.x + this.val[1][1] * iVec2.y + this.val[1][2];
        return iVec22;
    }

    public static IMatrix3 getXRotation(double d) {
        return new IMatrix3(1.0, 0.0, 0.0, 0.0, Math.cos(d), -Math.sin(d), 0.0, Math.sin(d), Math.cos(d));
    }

    public static IMatrix3 getYRotation(double d) {
        return new IMatrix3(Math.cos(d), 0.0, Math.sin(d), 0.0, 1.0, 0.0, -Math.sin(d), 0.0, Math.cos(d));
    }

    public static IMatrix3 getZRotation(double d) {
        return new IMatrix3(Math.cos(d), -Math.sin(d), 0.0, Math.sin(d), Math.cos(d), 0.0, 0.0, 0.0, 1.0);
    }

    public static IMatrix3 getRotation(IVec iVec, double d) {
        IVec iVec2 = iVec.dup().unit();
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0 - d3;
        return new IMatrix3(d4 * iVec2.x * iVec2.x + d3, iVec2.x * iVec2.y * d4 - iVec2.z * d2, iVec2.x * iVec2.z * d4 + iVec2.y * d2, iVec2.x * iVec2.y * d4 + iVec2.z * d2, iVec2.y * iVec2.y * d4 + d3, iVec2.y * iVec2.z * d4 - iVec2.x * d2, iVec2.x * iVec2.z * d4 - iVec2.y * d2, iVec2.y * iVec2.z * d4 + iVec2.x * d2, iVec2.z * iVec2.z * d4 + d3);
    }
}

