/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IConfig;
import igeo.IFieldGeo;
import igeo.IObject;
import igeo.ISurfaceI;
import igeo.IVec;
import igeo.IVec2I;
import igeo.IVecI;

public class ISurfaceFieldGeo
extends IFieldGeo
implements I3DFieldI {
    public ISurfaceI surface;
    public ISurfaceI fieldSurface;

    public ISurfaceFieldGeo(ISurfaceI iSurfaceI, ISurfaceI iSurfaceI2) {
        this.surface = iSurfaceI;
        this.fieldSurface = iSurfaceI2;
    }

    public IVecI get(IVecI iVecI, IVec2I iVec2I) {
        return this.fieldSurface.pt(iVec2I);
    }

    public IVecI get(IVecI iVecI) {
        double d;
        IVec2I iVec2I = this.surface.uv(iVecI);
        double d2 = this.intensity;
        if (this.decay == IFieldGeo.Decay.Linear) {
            d = this.surface.pt(iVec2I).dist(iVecI);
            if (d >= this.threshold) {
                return new IVec();
            }
            if (this.threshold > 0.0) {
                d2 *= (this.threshold - d) / this.threshold;
            }
        } else if (this.decay == IFieldGeo.Decay.Gaussian) {
            d = this.surface.pt(iVec2I).dist(iVecI);
            if (this.threshold > 0.0) {
                d2 *= Math.exp(-2.0 * d * d / (this.threshold * this.threshold));
            }
        }
        IVecI iVecI2 = this.get(iVecI, iVec2I);
        if (this.constantIntensity) {
            double d3 = iVecI2.len();
            if (d3 < IConfig.tolerance) {
                return iVecI2.zero();
            }
            return iVecI2.len(d2);
        }
        return iVecI2.mul(d2);
    }

    public ISurfaceFieldGeo constantIntensity(boolean bl) {
        super.constantIntensity(bl);
        return this;
    }

    public ISurfaceFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    public ISurfaceFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    public ISurfaceFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    public ISurfaceFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    public ISurfaceFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    public ISurfaceFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    public ISurfaceFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    public void del() {
        if (this.surface != null && this.surface == this.fieldSurface) {
            if (this.surface instanceof IObject) {
                ((IObject)((Object)this.surface)).del();
            }
        } else {
            if (this.surface != null && this.surface instanceof IObject) {
                ((IObject)((Object)this.surface)).del();
            }
            if (this.fieldSurface != null && this.fieldSurface instanceof IObject) {
                ((IObject)((Object)this.fieldSurface)).del();
            }
        }
    }
}

