/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I2DFieldI;
import igeo.IConfig;
import igeo.ICurveI;
import igeo.IFieldGeo;
import igeo.IObject;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVecI;

public class I2DCurveFieldGeo
extends IFieldGeo
implements I2DFieldI {
    public ICurveI curve;
    public ICurveI fieldCurve;

    public I2DCurveFieldGeo(ICurveI iCurveI, ICurveI iCurveI2) {
        this.curve = iCurveI;
        this.fieldCurve = iCurveI2;
    }

    public IVec2I get(IVecI iVecI, double d) {
        return this.fieldCurve.pt(d).to2d();
    }

    @Override
    public IVec2I get(IVecI iVecI) {
        double d;
        double d2 = this.curve.u(iVecI.to2d());
        double d3 = this.intensity;
        if (this.decay == IFieldGeo.Decay.Linear) {
            d = this.curve.pt(d2).to2d().dist(iVecI.to2d());
            if (d >= this.threshold) {
                return new IVec2();
            }
            if (this.threshold > 0.0) {
                d3 *= (this.threshold - d) / this.threshold;
            }
        } else if (this.decay == IFieldGeo.Decay.Gaussian) {
            d = this.curve.pt(d2).to2d().dist(iVecI.to2d());
            if (this.threshold > 0.0) {
                d3 *= Math.exp(-2.0 * d * d / (this.threshold * this.threshold));
            }
        }
        IVec2I iVec2I = this.get(iVecI, d2);
        if (this.constantIntensity) {
            double d4 = iVec2I.len();
            if (d4 < IConfig.tolerance) {
                return iVec2I.zero();
            }
            return iVec2I.len(d3);
        }
        return iVec2I.mul(d3);
    }

    @Override
    public I2DCurveFieldGeo constantIntensity(boolean bl) {
        super.constantIntensity(bl);
        return this;
    }

    @Override
    public I2DCurveFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    @Override
    public I2DCurveFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    @Override
    public I2DCurveFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    @Override
    public I2DCurveFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    @Override
    public I2DCurveFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    @Override
    public I2DCurveFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    @Override
    public I2DCurveFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    @Override
    public void del() {
        if (this.curve != null && this.curve == this.fieldCurve) {
            if (this.curve instanceof IObject) {
                ((IObject)((Object)this.curve)).del();
            }
        } else {
            if (this.curve != null && this.curve instanceof IObject) {
                ((IObject)((Object)this.curve)).del();
            }
            if (this.fieldCurve != null && this.fieldCurve instanceof IObject) {
                ((IObject)((Object)this.fieldCurve)).del();
            }
        }
    }
}

