/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IFunction;

public class IPiecewiseFunction
implements IFunction {
    public double[] domains;
    public IFunction[] functions;

    public IPiecewiseFunction(double[] dArray, IFunction[] iFunctionArray) {
        this.domains = dArray;
        this.functions = iFunctionArray;
    }

    public IPiecewiseFunction(int n) {
        this.domains = new double[n + 1];
        this.functions = new IFunction[n + 2];
    }

    public IPiecewiseFunction(double[] dArray) {
        this.domains = dArray;
        this.functions = new IFunction[this.domains.length + 1];
    }

    public IPiecewiseFunction(IPiecewiseFunction iPiecewiseFunction) {
        this.init(iPiecewiseFunction);
    }

    public IPiecewiseFunction() {
    }

    @Override
    public IPiecewiseFunction dup() {
        return new IPiecewiseFunction(this);
    }

    public void init(int n) {
        this.domains = new double[n + 1];
        this.functions = new IFunction[n + 2];
    }

    public void init(double[] dArray, IFunction[] iFunctionArray) {
        this.domains = dArray;
        this.functions = iFunctionArray;
    }

    public void init(double[] dArray) {
        this.domains = dArray;
        this.functions = new IFunction[this.domains.length + 1];
    }

    public void init(IPiecewiseFunction iPiecewiseFunction) {
        int n;
        this.domains = new double[iPiecewiseFunction.domains.length];
        for (n = 0; n < this.domains.length; ++n) {
            this.domains[n] = iPiecewiseFunction.domains[n];
        }
        this.functions = new IFunction[iPiecewiseFunction.functions.length];
        for (n = 0; n < this.functions.length; ++n) {
            this.functions[n] = iPiecewiseFunction.functions[n] != null ? iPiecewiseFunction.functions[n].dup() : null;
        }
    }

    public void setDomain(int n, double d) {
        this.domains[n] = d;
    }

    public void setFunction(int n, IFunction iFunction) {
        this.functions[n + 1] = iFunction;
    }

    public int getNumberOfDomains() {
        return this.domains.length;
    }

    public int getIndexOfDomain(double d) {
        return IPiecewiseFunction.getIndexOfDomain(d, this.domains);
    }

    public static int getIndexOfDomain(double d, double[] dArray) {
        if (d < dArray[0]) {
            return -1;
        }
        if (d >= dArray[dArray.length - 1]) {
            return dArray.length - 1;
        }
        int n = 0;
        int n2 = dArray.length - 1;
        int n3 = (n + n2) / 2;
        while (n < n2 && (d < dArray[n3] || d >= dArray[n3 + 1])) {
            if (d < dArray[n3]) {
                n2 = n3;
            } else {
                n = n3;
            }
            n3 = (n + n2) / 2;
        }
        return n3;
    }

    public double upperBoundOfDomain(int n) {
        if (n == this.domains.length - 1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.domains[n + 1];
    }

    public double lowerBoundOfDomain(int n) {
        if (n == -1) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.domains[n];
    }

    @Override
    public double eval(double d) {
        int n = this.getIndexOfDomain(d);
        return this.functions[n + 1].eval(d);
    }
}

