/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IBoolI;
import igeo.IBoolOp;
import igeo.IBoolR;
import igeo.IColor;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IDoubleR;
import igeo.IGraphicObject;
import igeo.IIntegerI;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IParameterObject;
import igeo.IServerI;
import igeo.ISurfaceGeo;
import igeo.ISurfaceI;
import igeo.ISurfaceOp;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.ITrimCurveI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec2Op;
import igeo.IVec2R;
import igeo.IVecI;
import igeo.IVecOp;
import igeo.IVecR;
import igeo.gui.IGraphicMode;
import igeo.gui.ISurfaceGraphicGL;
import java.awt.Color;

public class ISurfaceR
extends IObject
implements ISurfaceI {
    public ISurfaceI surface;

    public ISurfaceR() {
    }

    public ISurfaceR(ISurfaceI iSurfaceI) {
        this.surface = iSurfaceI;
        this.initSurface(null);
    }

    public ISurfaceR(IServerI iServerI) {
        super(iServerI);
    }

    public ISurfaceR(IServerI iServerI, ISurfaceI iSurfaceI) {
        super(iServerI);
        this.surface = iSurfaceI;
        this.initSurface(iServerI);
    }

    public ISurfaceR(ISurfaceR iSurfaceR) {
        super(iSurfaceR);
        this.surface = iSurfaceR.surface.dup();
        this.initSurface(iSurfaceR.server);
        this.setColor(iSurfaceR.getColor());
    }

    public ISurfaceR(IServerI iServerI, ISurfaceR iSurfaceR) {
        super(iServerI, iSurfaceR);
        this.surface = iSurfaceR.surface.dup();
        this.initSurface(iServerI);
        this.setColor(iSurfaceR.getColor());
    }

    public void initSurface(IServerI iServerI) {
        if (this.surface instanceof ISurfaceGeo) {
            this.parameter = (ISurfaceGeo)this.surface;
        }
        if (this.graphics == null) {
            this.initGraphic(iServerI);
        }
    }

    @Override
    public IGraphicObject createGraphic(IGraphicMode iGraphicMode) {
        if (iGraphicMode.isGL()) {
            return new ISurfaceGraphicGL(this);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.surface == null) {
            return false;
        }
        return this.surface.isValid();
    }

    @Override
    public ISurfaceGeo get() {
        return this.surface.get();
    }

    @Override
    public ISurfaceR dup() {
        return new ISurfaceR(this);
    }

    @Override
    public IVecR pt(IVec2I iVec2I) {
        return new IVecR(new Pt(this.surface, iVec2I));
    }

    @Override
    public IVecR pt(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVecR(new Pt(this.surface, new IVec2R(iDoubleI, iDoubleI2)));
    }

    @Override
    public IVecR pt(double d, double d2) {
        return new IVecR(new Pt(this.surface, new IVec2(d, d2)));
    }

    @Override
    public IVecR pt(double d, double d2, double d3) {
        return this.pt(d, d2).add(this.nml(d, d2).len(d3));
    }

    @Override
    public IVecR pt(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.pt(iDoubleI, iDoubleI2).add(this.nml(iDoubleI, iDoubleI2).len(iDoubleI3));
    }

    @Override
    public IVecR pt(IVecI iVecI) {
        IDoubleI iDoubleI = iVecI.x((ISwitchR)null);
        IDoubleI iDoubleI2 = iVecI.y((ISwitchR)null);
        return this.pt(iDoubleI, iDoubleI2).add(this.nml(iDoubleI, iDoubleI2).len(iVecI.z((ISwitchR)null)));
    }

    @Override
    public IVecR utan(IVec2I iVec2I) {
        return new IVecR(new UTan(this.surface, iVec2I));
    }

    @Override
    public IVecR utan(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVecR(new UTan(this.surface, new IVec2R(iDoubleI, iDoubleI2)));
    }

    @Override
    public IVecR utan(double d, double d2) {
        return new IVecR(new UTan(this.surface, new IVec2(d, d2)));
    }

    @Override
    public IVecR vtan(IVec2I iVec2I) {
        return new IVecR(new VTan(this.surface, iVec2I));
    }

    @Override
    public IVecR vtan(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVecR(new VTan(this.surface, new IVec2R(iDoubleI, iDoubleI2)));
    }

    @Override
    public IVecR vtan(double d, double d2) {
        return new IVecR(new VTan(this.surface, new IVec2(d, d2)));
    }

    @Override
    public IVecR normal(IVec2I iVec2I) {
        return this.nml(iVec2I);
    }

    @Override
    public IVecR normal(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.nml(iDoubleI, iDoubleI2);
    }

    @Override
    public IVecR normal(double d, double d2) {
        return this.nml(d, d2);
    }

    @Override
    public IVecR nrml(IVec2I iVec2I) {
        return this.nml(iVec2I);
    }

    @Override
    public IVecR nrml(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.nml(iDoubleI, iDoubleI2);
    }

    @Override
    public IVecR nrml(double d, double d2) {
        return this.nml(d, d2);
    }

    @Override
    public IVecR nml(IVec2I iVec2I) {
        return new IVecR(new Normal(this.surface, iVec2I));
    }

    @Override
    public IVecR nml(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVecR(new Normal(this.surface, new IVec2R(iDoubleI, iDoubleI2)));
    }

    @Override
    public IVecR nml(double d, double d2) {
        return new IVecR(new Normal(this.surface, new IVec2(d, d2)));
    }

    @Override
    public IVecI cp(int n, int n2) {
        return this.surface.cp(n, n2);
    }

    @Override
    public IVecI cp(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.surface.cp(iIntegerI, iIntegerI2);
    }

    @Override
    public IVecI[][] cps() {
        return this.surface.cps();
    }

    @Override
    public IVecR ep(int n, int n2) {
        return this.pt(this.uknot(n + this.udeg()), this.vknot(n2 + this.vdeg()));
    }

    @Override
    public IVecR ep(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.pt(this.uknot(iIntegerI.cp(this.udeg((ISwitchR)null))), this.vknot(iIntegerI2.cp(this.vdeg((ISwitchR)null))));
    }

    @Override
    public IVecR corner(int n, int n2) {
        if (n != 0) {
            n = 1;
        }
        if (n2 != 0) {
            n2 = 1;
        }
        return this.pt(n, n2);
    }

    @Override
    public IVecR corner(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.pt(new IDoubleR(iIntegerI), new IDoubleR(iIntegerI2));
    }

    @Override
    public IVecI cornerCP(int n, int n2) {
        return this.surface.cornerCP(n, n2);
    }

    @Override
    public IVecI cornerCP(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.surface.cornerCP(iIntegerI, iIntegerI2);
    }

    @Override
    public IVecR mid() {
        return this.pt(0.5, 0.5);
    }

    @Override
    public IVecI center() {
        return this.surface.center();
    }

    @Override
    public IVec2R uv(IVecI iVecI) {
        return new IVec2R(new UV(this, iVecI));
    }

    @Override
    public IVec2R uv(IVec2I iVec2I) {
        return new IVec2R(new UV2(this, iVec2I));
    }

    @Override
    public IVecR closePt(IVecI iVecI) {
        return this.pt(this.uv(iVecI));
    }

    @Override
    public IVecR closePt(IVec2I iVec2I) {
        return this.pt(this.uv(iVec2I));
    }

    @Override
    public double dist(IVecI iVecI) {
        return this.surface.dist(iVecI);
    }

    @Override
    public double dist(IVec2I iVec2I) {
        return this.surface.dist(iVec2I);
    }

    @Override
    public double uknot(int n) {
        return this.surface.uknot(n);
    }

    @Override
    public IDoubleI uknot(IIntegerI iIntegerI) {
        return this.surface.uknot(iIntegerI);
    }

    @Override
    public double vknot(int n) {
        return this.surface.vknot(n);
    }

    @Override
    public IDoubleI vknot(IIntegerI iIntegerI) {
        return this.surface.vknot(iIntegerI);
    }

    @Override
    public double[] uknots() {
        return this.surface.uknots();
    }

    @Override
    public double[] vknots() {
        return this.surface.vknots();
    }

    @Override
    public double[] uknots(ISwitchE iSwitchE) {
        return this.uknots();
    }

    @Override
    public double[] vknots(ISwitchE iSwitchE) {
        return this.vknots();
    }

    @Override
    public IDoubleI[] uknots(ISwitchR iSwitchR) {
        return this.surface.uknots(iSwitchR);
    }

    @Override
    public IDoubleI[] vknots(ISwitchR iSwitchR) {
        return this.surface.vknots(iSwitchR);
    }

    @Override
    public int uknotNum() {
        return this.surface.uknotNum();
    }

    @Override
    public int vknotNum() {
        return this.surface.vknotNum();
    }

    @Override
    public int uknotNum(ISwitchE iSwitchE) {
        return this.uknotNum();
    }

    @Override
    public int vknotNum(ISwitchE iSwitchE) {
        return this.vknotNum();
    }

    @Override
    public IIntegerI uknotNum(ISwitchR iSwitchR) {
        return this.surface.uknotNum(iSwitchR);
    }

    @Override
    public IIntegerI vknotNum(ISwitchR iSwitchR) {
        return this.surface.vknotNum(iSwitchR);
    }

    @Override
    public boolean isRational() {
        return this.surface.isRational();
    }

    @Override
    public boolean isRational(ISwitchE iSwitchE) {
        return this.surface.isRational();
    }

    @Override
    public IBoolI isRational(ISwitchR iSwitchR) {
        return this.surface.isRational(iSwitchR);
    }

    @Override
    public int udeg() {
        return this.surface.udeg();
    }

    @Override
    public int vdeg() {
        return this.surface.vdeg();
    }

    @Override
    public int udeg(ISwitchE iSwitchE) {
        return this.udeg();
    }

    @Override
    public int vdeg(ISwitchE iSwitchE) {
        return this.vdeg();
    }

    @Override
    public IIntegerI udeg(ISwitchR iSwitchR) {
        return this.surface.udeg(iSwitchR);
    }

    @Override
    public IIntegerI vdeg(ISwitchR iSwitchR) {
        return this.surface.vdeg(iSwitchR);
    }

    @Override
    public int unum() {
        return this.surface.unum();
    }

    @Override
    public int vnum() {
        return this.surface.vnum();
    }

    @Override
    public int unum(ISwitchE iSwitchE) {
        return this.unum();
    }

    @Override
    public int vnum(ISwitchE iSwitchE) {
        return this.vnum();
    }

    @Override
    public IIntegerI unum(ISwitchR iSwitchR) {
        return this.surface.unum(iSwitchR);
    }

    @Override
    public IIntegerI vnum(ISwitchR iSwitchR) {
        return this.surface.vnum(iSwitchR);
    }

    @Override
    public int ucpNum() {
        return this.surface.ucpNum();
    }

    @Override
    public int vcpNum() {
        return this.surface.vcpNum();
    }

    @Override
    public int ucpNum(ISwitchE iSwitchE) {
        return this.ucpNum();
    }

    @Override
    public int vcpNum(ISwitchE iSwitchE) {
        return this.vcpNum();
    }

    @Override
    public IIntegerI ucpNum(ISwitchR iSwitchR) {
        return this.surface.ucpNum(iSwitchR);
    }

    @Override
    public IIntegerI vcpNum(ISwitchR iSwitchR) {
        return this.surface.vcpNum(iSwitchR);
    }

    @Override
    public int uepNum() {
        return this.surface.uepNum();
    }

    @Override
    public int vepNum() {
        return this.surface.vepNum();
    }

    @Override
    public int uepNum(ISwitchE iSwitchE) {
        return this.uepNum();
    }

    @Override
    public int vepNum(ISwitchE iSwitchE) {
        return this.vepNum();
    }

    @Override
    public IIntegerI uepNum(ISwitchR iSwitchR) {
        return this.surface.uepNum(iSwitchR);
    }

    @Override
    public IIntegerI vepNum(ISwitchR iSwitchR) {
        return this.surface.vepNum(iSwitchR);
    }

    @Override
    public double u(int n, double d) {
        return this.surface.u(n, d);
    }

    @Override
    public IDoubleI u(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return this.surface.u(iIntegerI, iDoubleI);
    }

    @Override
    public double v(int n, double d) {
        return this.surface.v(n, d);
    }

    @Override
    public IDoubleI v(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return this.surface.v(iIntegerI, iDoubleI);
    }

    @Override
    public double ustart() {
        return this.surface.ustart();
    }

    @Override
    public double uend() {
        return this.surface.uend();
    }

    @Override
    public double vstart() {
        return this.surface.vstart();
    }

    @Override
    public double vend() {
        return this.surface.vend();
    }

    @Override
    public double ustart(ISwitchE iSwitchE) {
        return this.ustart();
    }

    @Override
    public double uend(ISwitchE iSwitchE) {
        return this.uend();
    }

    @Override
    public double vstart(ISwitchE iSwitchE) {
        return this.vstart();
    }

    @Override
    public double vend(ISwitchE iSwitchE) {
        return this.vend();
    }

    @Override
    public IDoubleI ustart(ISwitchR iSwitchR) {
        return this.surface.ustart(iSwitchR);
    }

    @Override
    public IDoubleI uend(ISwitchR iSwitchR) {
        return this.surface.uend(iSwitchR);
    }

    @Override
    public IDoubleI vstart(ISwitchR iSwitchR) {
        return this.surface.vstart(iSwitchR);
    }

    @Override
    public IDoubleI vend(ISwitchR iSwitchR) {
        return this.surface.vend(iSwitchR);
    }

    @Override
    public ISurfaceR revU() {
        this.surface.revU();
        return this;
    }

    @Override
    public ISurfaceR revV() {
        this.surface.revV();
        return this;
    }

    @Override
    public ISurfaceR revUV() {
        this.surface.revUV();
        return this;
    }

    @Override
    public ISurfaceR revN() {
        this.surface.revN();
        return this;
    }

    @Override
    public ISurfaceR flipU() {
        return this.revU();
    }

    @Override
    public ISurfaceR flipV() {
        return this.revV();
    }

    @Override
    public ISurfaceR flipUV() {
        return this.revUV();
    }

    @Override
    public ISurfaceR flipN() {
        return this.revN();
    }

    @Override
    public ISurfaceR swapUV() {
        this.surface.swapUV();
        return this;
    }

    @Override
    public boolean hasTrim() {
        return this.surface.hasTrim();
    }

    @Override
    public boolean hasTrim(ISwitchE iSwitchE) {
        return this.hasTrim();
    }

    @Override
    public IBoolI hasTrim(ISwitchR iSwitchR) {
        return this.surface.hasTrim(iSwitchR);
    }

    @Override
    public boolean hasInnerTrim() {
        return this.surface.hasInnerTrim();
    }

    @Override
    public boolean hasInnerTrim(ISwitchE iSwitchE) {
        return this.hasInnerTrim();
    }

    @Override
    public IBoolI hasInnerTrim(ISwitchR iSwitchR) {
        return this.surface.hasInnerTrim(iSwitchR);
    }

    @Override
    public boolean hasOuterTrim() {
        return this.surface.hasOuterTrim();
    }

    @Override
    public boolean hasOuterTrim(ISwitchE iSwitchE) {
        return this.hasOuterTrim();
    }

    @Override
    public IBoolI hasOuterTrim(ISwitchR iSwitchR) {
        return this.surface.hasOuterTrim(iSwitchR);
    }

    @Override
    public int innerTrimLoopNum() {
        return this.surface.innerTrimLoopNum();
    }

    @Override
    public int innerTrimLoopNum(ISwitchE iSwitchE) {
        return this.innerTrimLoopNum();
    }

    @Override
    public IIntegerI innerTrimLoopNum(ISwitchR iSwitchR) {
        return this.surface.innerTrimLoopNum(iSwitchR);
    }

    @Override
    public int innerTrimNum(int n) {
        return this.surface.innerTrimNum(n);
    }

    @Override
    public IIntegerI innerTrimNum(IIntegerI iIntegerI) {
        return this.surface.innerTrimNum(iIntegerI);
    }

    @Override
    public ITrimCurveI[] innerTrimLoop(int n) {
        return this.surface.innerTrimLoop(n);
    }

    @Override
    public ITrimCurveI[] innerTrimLoop(IIntegerI iIntegerI) {
        return this.surface.innerTrimLoop(iIntegerI);
    }

    @Override
    public ITrimCurveI innerTrim(int n, int n2) {
        return this.surface.innerTrim(n, n2);
    }

    @Override
    public ITrimCurveI innerTrim(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.surface.innerTrim(iIntegerI, iIntegerI2);
    }

    @Override
    public int outerTrimLoopNum() {
        return this.surface.outerTrimLoopNum();
    }

    @Override
    public int outerTrimLoopNum(ISwitchE iSwitchE) {
        return this.outerTrimLoopNum();
    }

    @Override
    public IIntegerI outerTrimLoopNum(ISwitchR iSwitchR) {
        return this.surface.outerTrimLoopNum(iSwitchR);
    }

    @Override
    public int outerTrimNum(int n) {
        return this.surface.outerTrimNum(n);
    }

    @Override
    public IIntegerI outerTrimNum(IIntegerI iIntegerI) {
        return this.surface.outerTrimNum(iIntegerI);
    }

    @Override
    public ITrimCurveI[] outerTrimLoop(int n) {
        return this.surface.outerTrimLoop(n);
    }

    @Override
    public ITrimCurveI[] outerTrimLoop(IIntegerI iIntegerI) {
        return this.surface.outerTrimLoop(iIntegerI);
    }

    @Override
    public ITrimCurveI outerTrim(int n, int n2) {
        return this.surface.outerTrim(n, n2);
    }

    @Override
    public ITrimCurveI outerTrim(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.surface.outerTrim(iIntegerI, iIntegerI2);
    }

    @Override
    public boolean hasDefaultTrim() {
        return this.surface.hasDefaultTrim();
    }

    @Override
    public boolean hasDefaultTrim(ISwitchE iSwitchE) {
        return this.hasDefaultTrim();
    }

    @Override
    public IBoolI hasDefaultTrim(ISwitchR iSwitchR) {
        return this.surface.hasDefaultTrim(iSwitchR);
    }

    @Override
    public ISurfaceR addInnerTrimLoop(ITrimCurveI iTrimCurveI) {
        this.surface.addInnerTrimLoop(iTrimCurveI);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addOuterTrimLoop(ITrimCurveI iTrimCurveI) {
        this.surface.addOuterTrimLoop(iTrimCurveI);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addInnerTrimLoop(ITrimCurveI[] iTrimCurveIArray) {
        this.surface.addInnerTrimLoop(iTrimCurveIArray);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addOuterTrimLoop(ITrimCurveI[] iTrimCurveIArray) {
        this.surface.addOuterTrimLoop(iTrimCurveIArray);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addInnerTrimLoop(ICurveI iCurveI) {
        this.surface.addInnerTrimLoop(iCurveI);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addOuterTrimLoop(ICurveI iCurveI) {
        this.surface.addOuterTrimLoop(iCurveI);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addInnerTrimLoop(ICurveI iCurveI, boolean bl) {
        this.surface.addInnerTrimLoop(iCurveI, bl);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addOuterTrimLoop(ICurveI iCurveI, boolean bl) {
        this.surface.addOuterTrimLoop(iCurveI, bl);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addInnerTrimLoop(ICurveI[] iCurveIArray) {
        this.surface.addInnerTrimLoop(iCurveIArray);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addOuterTrimLoop(ICurveI[] iCurveIArray) {
        this.surface.addOuterTrimLoop(iCurveIArray);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addInnerTrimLoop(ICurveI[] iCurveIArray, boolean bl) {
        this.surface.addInnerTrimLoop(iCurveIArray, bl);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR addOuterTrimLoop(ICurveI[] iCurveIArray, boolean bl) {
        this.surface.addOuterTrimLoop(iCurveIArray, bl);
        this.updateGraphic();
        return this;
    }

    @Override
    public ISurfaceR clearInnerTrim() {
        this.surface.clearInnerTrim();
        return this;
    }

    @Override
    public ISurfaceR clearOuterTrim() {
        this.surface.clearOuterTrim();
        return this;
    }

    @Override
    public ISurfaceR clearTrim() {
        this.surface.clearTrim();
        return this;
    }

    @Override
    public boolean isFlat() {
        return this.surface.isFlat();
    }

    @Override
    public boolean isFlat(ISwitchE iSwitchE) {
        return this.surface.isFlat();
    }

    @Override
    public IBoolI isFlat(ISwitchR iSwitchR) {
        return new IBoolR(new IsFlat(this.surface));
    }

    @Override
    public boolean isUClosed() {
        return this.surface.isUClosed();
    }

    @Override
    public boolean isUClosed(ISwitchE iSwitchE) {
        return this.surface.isUClosed();
    }

    @Override
    public IBoolI isUClosed(ISwitchR iSwitchR) {
        return new IBoolR(new IsUClosed(this.surface));
    }

    @Override
    public boolean isVClosed() {
        return this.surface.isVClosed();
    }

    @Override
    public boolean isVClosed(ISwitchE iSwitchE) {
        return this.surface.isVClosed();
    }

    @Override
    public IBoolI isVClosed(ISwitchR iSwitchR) {
        return new IBoolR(new IsVClosed(this.surface));
    }

    @Override
    public ISurfaceR add(double d, double d2, double d3) {
        this.surface.add(d, d2, d3);
        return this;
    }

    @Override
    public ISurfaceR add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.surface.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public ISurfaceR add(IVecI iVecI) {
        this.surface.add(iVecI);
        return this;
    }

    @Override
    public ISurfaceR sub(double d, double d2, double d3) {
        this.surface.sub(d, d2, d3);
        return this;
    }

    @Override
    public ISurfaceR sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.surface.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public ISurfaceR sub(IVecI iVecI) {
        this.surface.sub(iVecI);
        return this;
    }

    @Override
    public ISurfaceR mul(IDoubleI iDoubleI) {
        this.surface.mul(iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR mul(double d) {
        this.surface.mul(d);
        return this;
    }

    @Override
    public ISurfaceR div(IDoubleI iDoubleI) {
        this.surface.div(iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR div(double d) {
        this.surface.div(d);
        return this;
    }

    @Override
    public ISurfaceR neg() {
        this.surface.neg();
        return this;
    }

    @Override
    public ISurfaceR flip() {
        return this.neg();
    }

    @Override
    public ISurfaceR add(IVecI iVecI, double d) {
        this.surface.add(iVecI, d);
        return this;
    }

    @Override
    public ISurfaceR add(IVecI iVecI, IDoubleI iDoubleI) {
        this.surface.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public ISurfaceR add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public ISurfaceR rot(IDoubleI iDoubleI) {
        this.surface.rot(iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR rot(double d) {
        this.surface.rot(d);
        return this;
    }

    @Override
    public ISurfaceR rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.surface.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR rot(IVecI iVecI, double d) {
        this.surface.rot(iVecI, d);
        return this;
    }

    @Override
    public ISurfaceR rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.surface.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.surface.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public ISurfaceR rot(IVecI iVecI, IVecI iVecI2) {
        this.surface.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public ISurfaceR rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.surface.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public ISurfaceR rot2(IDoubleI iDoubleI) {
        this.surface.rot(iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR rot2(double d) {
        this.surface.rot(d);
        return this;
    }

    @Override
    public ISurfaceR rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.surface.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR rot2(IVecI iVecI, double d) {
        this.surface.rot2(iVecI, d);
        return this;
    }

    @Override
    public ISurfaceR rot2(IVecI iVecI) {
        this.surface.rot2(iVecI);
        return this;
    }

    @Override
    public ISurfaceR rot2(IVecI iVecI, IVecI iVecI2) {
        this.surface.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public ISurfaceR scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public ISurfaceR scale(double d) {
        return this.mul(d);
    }

    @Override
    public ISurfaceR scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.surface.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR scale(IVecI iVecI, double d) {
        this.surface.scale(iVecI, d);
        return this;
    }

    @Override
    public ISurfaceR scale1d(IVecI iVecI, double d) {
        this.surface.scale1d(iVecI, d);
        return this;
    }

    @Override
    public ISurfaceR scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.surface.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.surface.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public ISurfaceR scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.surface.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public ISurfaceR ref(IVecI iVecI) {
        this.surface.ref(iVecI);
        return this;
    }

    @Override
    public ISurfaceR ref(IVecI iVecI, IVecI iVecI2) {
        this.surface.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public ISurfaceR mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public ISurfaceR mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public ISurfaceR shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.surface.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public ISurfaceR shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.surface.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public ISurfaceR shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.surface.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public ISurfaceR shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.surface.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public ISurfaceR shearXY(double d, double d2) {
        this.surface.shearXY(d, d2);
        return this;
    }

    @Override
    public ISurfaceR shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.surface.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ISurfaceR shearXY(IVecI iVecI, double d, double d2) {
        this.surface.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public ISurfaceR shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.surface.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ISurfaceR shearYZ(double d, double d2) {
        this.surface.shearYZ(d, d2);
        return this;
    }

    @Override
    public ISurfaceR shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.surface.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ISurfaceR shearYZ(IVecI iVecI, double d, double d2) {
        this.surface.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public ISurfaceR shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.surface.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ISurfaceR shearZX(double d, double d2) {
        this.surface.shearZX(d, d2);
        return this;
    }

    @Override
    public ISurfaceR shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.surface.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ISurfaceR shearZX(IVecI iVecI, double d, double d2) {
        this.surface.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public ISurfaceR shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.surface.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public ISurfaceR mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ISurfaceR mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ISurfaceR mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ISurfaceR cp() {
        return this.dup();
    }

    @Override
    public ISurfaceR cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public ISurfaceR cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ISurfaceR cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public ISurfaceR translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public ISurfaceR translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public ISurfaceR translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public ISurfaceR transform(IMatrix3I iMatrix3I) {
        this.surface.transform(iMatrix3I);
        return this;
    }

    @Override
    public ISurfaceR transform(IMatrix4I iMatrix4I) {
        this.surface.transform(iMatrix4I);
        return this;
    }

    @Override
    public ISurfaceR transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.surface.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public ISurfaceR transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.surface.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public ISurfaceR name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public ISurfaceR layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public ISurfaceR hide() {
        super.hide();
        return this;
    }

    @Override
    public ISurfaceR show() {
        super.show();
        return this;
    }

    @Override
    public ISurfaceR clr(IColor iColor) {
        super.clr(iColor);
        return this;
    }

    @Override
    public ISurfaceR clr(IColor iColor, int n) {
        super.clr(iColor, n);
        return this;
    }

    @Override
    public ISurfaceR clr(IColor iColor, float f) {
        super.clr(iColor, f);
        return this;
    }

    @Override
    public ISurfaceR clr(IColor iColor, double d) {
        super.clr(iColor, d);
        return this;
    }

    @Override
    public ISurfaceR clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public ISurfaceR clr(Color color, int n) {
        super.clr(color, n);
        return this;
    }

    @Override
    public ISurfaceR clr(Color color, float f) {
        super.clr(color, f);
        return this;
    }

    @Override
    public ISurfaceR clr(Color color, double d) {
        super.clr(color, d);
        return this;
    }

    @Override
    public ISurfaceR clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public ISurfaceR clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public ISurfaceR clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public ISurfaceR clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public ISurfaceR clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public ISurfaceR clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public ISurfaceR clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public ISurfaceR clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public ISurfaceR clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public ISurfaceR clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public ISurfaceR clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public ISurfaceR clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public ISurfaceR hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public ISurfaceR hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public ISurfaceR hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public ISurfaceR hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public ISurfaceR setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public ISurfaceR setColor(Color color, int n) {
        super.setColor(color, n);
        return this;
    }

    @Override
    public ISurfaceR setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public ISurfaceR setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public ISurfaceR setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public ISurfaceR setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public ISurfaceR setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public ISurfaceR setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public ISurfaceR setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public ISurfaceR setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public ISurfaceR setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public ISurfaceR setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public ISurfaceR setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public ISurfaceR setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public ISurfaceR setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public ISurfaceR setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public ISurfaceR setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public ISurfaceR setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }

    @Override
    public ISurfaceR weight(double d) {
        super.weight(d);
        return this;
    }

    @Override
    public ISurfaceR weight(float f) {
        super.weight(f);
        return this;
    }

    public static class Normal
    extends IParameterObject
    implements IVecOp {
        public ISurfaceOp srf;
        public IVec2Op uv;

        public Normal(ISurfaceOp iSurfaceOp, IVec2Op iVec2Op) {
            this.srf = iSurfaceOp;
            this.uv = iVec2Op;
        }

        @Override
        public IVec get() {
            return this.srf.get().nml(this.uv.get());
        }
    }

    public static class VTan
    extends IParameterObject
    implements IVecOp {
        public ISurfaceOp srf;
        public IVec2Op uv;

        public VTan(ISurfaceOp iSurfaceOp, IVec2Op iVec2Op) {
            this.srf = iSurfaceOp;
            this.uv = iVec2Op;
        }

        @Override
        public IVec get() {
            return this.srf.get().vtan(this.uv.get());
        }
    }

    public static class UTan
    extends IParameterObject
    implements IVecOp {
        public ISurfaceOp srf;
        public IVec2Op uv;

        public UTan(ISurfaceOp iSurfaceOp, IVec2Op iVec2Op) {
            this.srf = iSurfaceOp;
            this.uv = iVec2Op;
        }

        @Override
        public IVec get() {
            return this.srf.get().utan(this.uv.get());
        }
    }

    public static class Pt
    extends IParameterObject
    implements IVecOp {
        public ISurfaceOp srf;
        public IVec2Op uv;

        public Pt(ISurfaceOp iSurfaceOp, IVec2Op iVec2Op) {
            this.srf = iSurfaceOp;
            this.uv = iVec2Op;
        }

        @Override
        public IVec get() {
            return this.srf.get().pt(this.uv.get());
        }
    }

    public static class UV2
    extends IParameterObject
    implements IVec2Op {
        public ISurfaceOp srf;
        public IVec2I pt;

        public UV2(ISurfaceOp iSurfaceOp, IVec2I iVec2I) {
            this.srf = iSurfaceOp;
            this.pt = iVec2I;
        }

        @Override
        public IVec2 get() {
            return this.srf.get().uv(this.pt);
        }
    }

    public static class UV
    extends IParameterObject
    implements IVec2Op {
        public ISurfaceOp srf;
        public IVecI pt;

        public UV(ISurfaceOp iSurfaceOp, IVecI iVecI) {
            this.srf = iSurfaceOp;
            this.pt = iVecI;
        }

        @Override
        public IVec2 get() {
            return this.srf.get().uv(this.pt);
        }
    }

    public static class IsVClosed
    extends IParameterObject
    implements IBoolOp {
        public ISurfaceOp srf;

        public IsVClosed(ISurfaceOp iSurfaceOp) {
            this.srf = iSurfaceOp;
        }

        @Override
        public boolean x() {
            return this.srf.get().isVClosed();
        }

        @Override
        public IBool get() {
            return this.srf.get().isVClosed((ISwitchR)null);
        }
    }

    public static class IsUClosed
    extends IParameterObject
    implements IBoolOp {
        public ISurfaceOp srf;

        public IsUClosed(ISurfaceOp iSurfaceOp) {
            this.srf = iSurfaceOp;
        }

        @Override
        public boolean x() {
            return this.srf.get().isUClosed();
        }

        @Override
        public IBool get() {
            return this.srf.get().isUClosed((ISwitchR)null);
        }
    }

    public static class IsFlat
    extends IParameterObject
    implements IBoolOp {
        public ISurfaceOp srf;

        public IsFlat(ISurfaceOp iSurfaceOp) {
            this.srf = iSurfaceOp;
        }

        @Override
        public boolean x() {
            return this.srf.get().isFlat();
        }

        @Override
        public IBool get() {
            return this.srf.get().isFlat((ISwitchR)null);
        }
    }
}

