/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IConfig;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IVecI;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;

public class IPointGraphic
extends IGraphicObject {
    public IVecI pt = null;
    public float weight = IConfig.pointSize;

    public IPointGraphic(IPoint iPoint) {
        super(iPoint);
        this.initPoint(iPoint.pos);
    }

    public IPointGraphic(IPointR iPointR) {
        super(iPointR);
        this.initPoint(iPointR.pos);
    }

    public void initPoint(IVecI iVecI) {
        this.pt = iVecI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initPoint() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            if (this.parent instanceof IPoint) {
                this.pt = ((IPoint)this.parent).pos;
            } else if (this.parent instanceof IPointR) {
                this.pt = ((IPointR)this.parent).pos;
            }
        }
    }

    public void size(float f) {
        this.weight(f);
    }

    public double size() {
        return this.weight();
    }

    public void weight(float f) {
        this.weight = f;
    }

    public float weight() {
        return this.weight;
    }

    @Override
    public void setWeight(float f) {
        this.weight(f);
    }

    @Override
    public float getWeight() {
        return this.weight();
    }

    @Override
    public synchronized void draw(IGraphics iGraphics) {
        if (this.pt == null) {
            this.initPoint();
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            iGraphics3D.pointSize(this.weight);
            float[] fArray = null;
            fArray = this.color != null ? this.color.rgba() : IConfig.objectColor.rgba();
            if (iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe()) {
                fArray = new float[]{fArray[0], fArray[1], fArray[2], (float)IConfig.transparentModeAlpha / 255.0f};
            }
            if (iGraphics3D.view().mode().isLight() && iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(fArray);
                iGraphics3D.diffuse(fArray);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.clr(fArray[0] * 255.0f, fArray[1] * 255.0f, fArray[2] * 255.0f, 0.0f);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            iGraphics3D.stroke(fArray);
            iGraphics3D.drawPoint(this.pt.get());
            if (iGraphics3D.view().mode().isLight() && !iGraphics.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        } else if (iGraphics.view().mode().isJ2D()) {
            // empty if block
        }
    }

    @Override
    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D();
    }
}

