/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IConfig;
import igeo.ICurveI;
import igeo.IFieldGeo;
import igeo.IObject;
import igeo.IVec;
import igeo.IVecI;

public class ICurveFieldGeo
extends IFieldGeo
implements I3DFieldI {
    public ICurveI curve;
    public ICurveI fieldCurve;

    public ICurveFieldGeo(ICurveI iCurveI, ICurveI iCurveI2) {
        this.curve = iCurveI;
        this.fieldCurve = iCurveI2;
    }

    public IVecI get(IVecI iVecI, double d) {
        return this.fieldCurve.pt(d);
    }

    public IVecI get(IVecI iVecI, IVecI iVecI2, double d) {
        return this.get(iVecI, d);
    }

    @Override
    public IVecI get(IVecI iVecI) {
        return this.get(iVecI, null);
    }

    @Override
    public IVecI get(IVecI iVecI, IVecI iVecI2) {
        double d;
        double d2 = this.curve.u(iVecI);
        double d3 = this.intensity;
        if (this.decay == IFieldGeo.Decay.Linear) {
            d = this.curve.pt(d2).dist(iVecI);
            if (d >= this.threshold) {
                return new IVec();
            }
            if (this.threshold > 0.0) {
                d3 *= (this.threshold - d) / this.threshold;
            }
        } else if (this.decay == IFieldGeo.Decay.Gaussian) {
            d = this.curve.pt(d2).dist(iVecI);
            if (this.threshold > 0.0) {
                d3 *= Math.exp(-2.0 * d * d / (this.threshold * this.threshold));
            }
        }
        IVecI iVecI3 = this.get(iVecI, iVecI2, d2);
        if (this.bidirectional && iVecI3.get().dot(iVecI2) < 0.0) {
            d3 = -d3;
        }
        if (this.constantIntensity) {
            double d4 = iVecI3.len();
            if (d4 < IConfig.tolerance) {
                return iVecI3.zero();
            }
            return iVecI3.len(d3);
        }
        return iVecI3.mul(d3);
    }

    @Override
    public ICurveFieldGeo constantIntensity(boolean bl) {
        super.constantIntensity(bl);
        return this;
    }

    @Override
    public ICurveFieldGeo bidirectional(boolean bl) {
        super.bidirectional(bl);
        return this;
    }

    @Override
    public ICurveFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    @Override
    public ICurveFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    @Override
    public ICurveFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    @Override
    public ICurveFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    @Override
    public ICurveFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    @Override
    public ICurveFieldGeo gauss(double d) {
        super.gauss(d);
        return this;
    }

    @Override
    public ICurveFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    @Override
    public ICurveFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    @Override
    public void del() {
        if (this.curve != null && this.curve == this.fieldCurve) {
            if (this.curve instanceof IObject) {
                ((IObject)((Object)this.curve)).del();
            }
        } else {
            if (this.curve != null && this.curve instanceof IObject) {
                ((IObject)((Object)this.curve)).del();
            }
            if (this.fieldCurve != null && this.fieldCurve instanceof IObject) {
                ((IObject)((Object)this.fieldCurve)).del();
            }
        }
    }
}

