/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAgentTracker;
import igeo.IColor;
import igeo.IDoubleI;
import igeo.IGeometry;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IParticleGeo;
import igeo.IParticleI;
import igeo.IPointAgent;
import igeo.IVec;
import igeo.IVecI;

public class IParticle
extends IPointAgent
implements IParticleI {
    public IParticleGeo particle;
    public IVec vel;
    public IVec frc;

    public IParticle() {
        this.initParticleAgent();
    }

    public IParticle(double d, double d2, double d3) {
        super(d, d2, d3);
        this.initParticleAgent();
    }

    public IParticle(IVec iVec) {
        super(iVec);
        this.initParticleAgent();
    }

    public IParticle(IVecI iVecI) {
        super(iVecI);
        this.initParticleAgent();
    }

    public IParticle(IParticleGeo iParticleGeo) {
        super(iParticleGeo.pos);
        this.initParticleAgent(iParticleGeo);
    }

    public IParticle(IParticle iParticle) {
        super(iParticle);
        this.initParticleAgent(iParticle);
    }

    public IParticle(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3);
        this.initParticleAgent(new IVec(d4, d5, d6));
    }

    public IParticle(IVec iVec, IVec iVec2) {
        super(iVec);
        this.initParticleAgent(iVec2);
    }

    public IParticle(IVecI iVecI, IVecI iVecI2) {
        super(iVecI);
        this.initParticleAgent(iVecI2);
    }

    public IParticle(IParticleGeo iParticleGeo, IVecI iVecI) {
        super(iParticleGeo.pos);
        this.initParticleAgent(iParticleGeo, iVecI);
    }

    public IParticle(IParticle iParticle, IVecI iVecI) {
        super(iParticle);
        this.initParticleAgent(iVecI);
    }

    public IParticle(IGeometry ... iGeometryArray) {
        this();
        if (iGeometryArray == null || iGeometryArray.length == 0) {
            this.pos = new IVec();
        } else {
            IVec iVec = new IVec();
            for (int i = 0; i < iGeometryArray.length; ++i) {
                iVec.add(iGeometryArray[i].center());
            }
            iVec.div(iGeometryArray.length);
            this.pos(iVec);
            this.attach((IVecI)iVec, iGeometryArray);
        }
        if (this.point != null) {
            this.point.hide();
        }
    }

    public IParticle(IVecI iVecI, IGeometry ... iGeometryArray) {
        this();
        this.pos(iVecI);
        this.attach(iVecI, iGeometryArray);
        if (this.point != null) {
            this.point.hide();
        }
    }

    public IParticle(IVecI iVecI, IVecI iVecI2, IGeometry ... iGeometryArray) {
        this();
        this.pos(iVecI);
        this.attach(iVecI, iVecI2, iGeometryArray);
        if (this.point != null) {
            this.point.hide();
        }
    }

    public void initParticleAgent() {
        this.particle = new IParticleGeo(this.pos, (IObject)this);
        this.vel = this.particle.vel;
        this.frc = this.particle.frc;
        this.addDynamics(this.particle);
    }

    public void initParticleAgent(IParticleGeo iParticleGeo) {
        this.particle = iParticleGeo;
        this.pos = this.particle.pos;
        this.vel = this.particle.vel;
        this.frc = this.particle.frc;
        this.addDynamics(this.particle);
    }

    public void initParticleAgent(IParticle iParticle) {
        this.particle = new IParticleGeo(this.pos, iParticle.vel().dup(), (IObject)this);
        this.pos = this.particle.pos;
        this.vel = this.particle.vel;
        this.frc = this.particle.frc;
        this.addDynamics(this.particle);
    }

    public void initParticleAgent(IVecI iVecI) {
        this.particle = new IParticleGeo((IVecI)this.pos, iVecI, (IObject)this);
        this.vel = this.particle.vel;
        this.frc = this.particle.frc;
        this.addDynamics(this.particle);
    }

    public void initParticleAgent(IParticleGeo iParticleGeo, IVecI iVecI) {
        this.particle = iParticleGeo;
        this.particle.vel(iVecI);
        this.pos = this.particle.pos;
        this.vel = this.particle.vel;
        this.frc = this.particle.frc;
        this.addDynamics(this.particle);
    }

    @Override
    public synchronized IParticle fix() {
        this.particle.fix();
        return this;
    }

    @Override
    public synchronized IParticle unfix() {
        this.particle.unfix();
        return this;
    }

    @Override
    public boolean fixed() {
        return this.particle.fixed();
    }

    @Override
    public IParticle skipUpdateOnce(boolean bl) {
        this.particle.skipUpdateOnce(bl);
        return this;
    }

    @Override
    public boolean skipUpdateOnce() {
        return this.particle.skipUpdateOnce;
    }

    @Override
    public synchronized double mass() {
        return this.particle.mass();
    }

    @Override
    public synchronized IParticle mass(double d) {
        this.particle.mass(d);
        return this;
    }

    @Override
    public synchronized IVec position() {
        return this.particle.position();
    }

    @Override
    public synchronized IParticle position(IVecI iVecI) {
        this.particle.position(iVecI);
        return this;
    }

    @Override
    public synchronized IVec pos() {
        return this.particle.pos();
    }

    @Override
    public synchronized IParticle pos(IVecI iVecI) {
        this.particle.pos(iVecI);
        return this;
    }

    @Override
    public synchronized IVec velocity() {
        return this.particle.velocity();
    }

    @Override
    public synchronized IParticle velocity(IVecI iVecI) {
        this.particle.velocity(iVecI);
        return this;
    }

    @Override
    public synchronized IVec vel() {
        return this.particle.vel();
    }

    @Override
    public synchronized IParticle vel(IVecI iVecI) {
        this.particle.vel(iVecI);
        return this;
    }

    @Override
    public synchronized IVec acceleration() {
        return this.particle.acceleration();
    }

    @Override
    public synchronized IVec acc() {
        return this.particle.acc();
    }

    @Override
    public synchronized IVec force() {
        return this.particle.force();
    }

    @Override
    public synchronized IParticle force(IVecI iVecI) {
        this.particle.force(iVecI);
        return this;
    }

    @Override
    public synchronized IVec frc() {
        return this.particle.frc();
    }

    @Override
    public synchronized IParticle frc(IVecI iVecI) {
        this.particle.frc(iVecI);
        return this;
    }

    @Override
    public synchronized double friction() {
        return this.particle.friction();
    }

    @Override
    public synchronized IParticle friction(double d) {
        this.particle.friction(d);
        return this;
    }

    @Override
    public synchronized double fric() {
        return this.particle.fric();
    }

    @Override
    public synchronized IParticle fric(double d) {
        this.particle.fric(d);
        return this;
    }

    @Override
    public synchronized double decay() {
        return this.fric();
    }

    @Override
    public synchronized IParticle decay(double d) {
        return this.fric(d);
    }

    @Override
    public synchronized IParticle push(IVecI iVecI) {
        this.particle.push(iVecI);
        return this;
    }

    @Override
    public synchronized IParticle push(double d, double d2, double d3) {
        this.particle.push(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IParticle pull(IVecI iVecI) {
        this.particle.pull(iVecI);
        return this;
    }

    @Override
    public synchronized IParticle pull(double d, double d2, double d3) {
        this.particle.pull(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IParticle addForce(IVecI iVecI) {
        this.particle.addForce(iVecI);
        return this;
    }

    @Override
    public synchronized IParticle addForce(double d, double d2, double d3) {
        this.particle.addForce(d, d2, d3);
        return this;
    }

    @Override
    public synchronized IParticle reset() {
        this.particle.reset();
        return this;
    }

    @Override
    public synchronized IParticle resetForce() {
        this.particle.resetForce();
        return this;
    }

    @Override
    public IParticle attach(IGeometry ... iGeometryArray) {
        super.attach(iGeometryArray);
        return this;
    }

    @Override
    public IParticle attach(IVecI iVecI, IGeometry ... iGeometryArray) {
        super.attach(iVecI, iGeometryArray);
        return this;
    }

    public IParticle attach(IVecI iVecI, IVecI iVecI2, IGeometry ... iGeometryArray) {
        if (this.tracker != null) {
            this.tracker.del();
        }
        this.tracker = new IAgentTracker((IPointAgent)this, iVecI, iVecI2, iGeometryArray);
        return this;
    }

    @Override
    public IParticle x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IParticle y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IParticle z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IParticle x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IParticle y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IParticle z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IParticle dup() {
        return new IParticle(this);
    }

    @Override
    public IParticle set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IParticle set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IParticle set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IParticle add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IParticle sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IParticle sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IParticle mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IParticle mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IParticle div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IParticle div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IParticle neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IParticle rev() {
        return this.neg();
    }

    @Override
    public IParticle flip() {
        return this.neg();
    }

    @Override
    public IParticle zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IParticle add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IParticle add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IParticle add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public IParticle len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    @Override
    public IParticle len(double d) {
        this.pos.len(d);
        return this;
    }

    @Override
    public IParticle unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public IParticle rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IParticle rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IParticle rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticle rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticle rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticle rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IParticle rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IParticle rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IParticle rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IParticle rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IParticle rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticle scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IParticle scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IParticle scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IParticle scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticle scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticle scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticle scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticle ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticle ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticle ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticle ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticle mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticle mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticle mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticle mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticle shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticle shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticle shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticle shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticle shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IParticle shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticle shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IParticle shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticle shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IParticle shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticle shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticle translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IParticle translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticle translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IParticle transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IParticle transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IParticle transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticle transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IParticle mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IParticle mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticle mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IParticle cp() {
        return this.dup();
    }

    @Override
    public IParticle cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IParticle cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticle cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IParticle setSize(double d) {
        return this.size(d);
    }

    @Override
    public IParticle size(double d) {
        this.point.size(d);
        return this;
    }

    @Override
    public IParticle name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public IParticle layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public IParticle show() {
        super.show();
        return this;
    }

    @Override
    public IParticle hide() {
        super.hide();
        return this;
    }

    @Override
    public IParticle showPoint() {
        super.showPoint();
        return this;
    }

    @Override
    public IParticle hidePoint() {
        super.hidePoint();
        return this;
    }

    @Override
    public IParticle showGeometry() {
        super.showGeometry();
        return this;
    }

    @Override
    public IParticle hideGeometry() {
        super.hideGeometry();
        return this;
    }

    @Override
    public IParticle clr(IColor iColor) {
        super.clr(iColor);
        return this;
    }

    @Override
    public IParticle clr(IColor iColor, int n) {
        super.clr(iColor, n);
        return this;
    }

    @Override
    public IParticle clr(IColor iColor, float f) {
        super.clr(iColor, f);
        return this;
    }

    @Override
    public IParticle clr(IColor iColor, double d) {
        super.clr(iColor, d);
        return this;
    }

    @Override
    public IParticle clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public IParticle clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public IParticle clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public IParticle clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public IParticle clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public IParticle clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public IParticle clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public IParticle clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public IParticle clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public IParticle clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public IParticle clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public IParticle clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticle hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public IParticle hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticle hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public IParticle hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public IParticle setColor(IColor iColor) {
        super.setColor(iColor);
        return this;
    }

    @Override
    public IParticle setColor(IColor iColor, int n) {
        super.setColor(iColor, n);
        return this;
    }

    @Override
    public IParticle setColor(IColor iColor, float f) {
        super.setColor(iColor, f);
        return this;
    }

    @Override
    public IParticle setColor(IColor iColor, double d) {
        super.setColor(iColor, d);
        return this;
    }

    @Override
    public IParticle setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public IParticle setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public IParticle setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public IParticle setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public IParticle setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public IParticle setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public IParticle setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public IParticle setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public IParticle setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public IParticle setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public IParticle setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IParticle setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticle setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public IParticle setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticle setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public IParticle setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }

    @Override
    public IParticle weight(double d) {
        super.weight(d);
        return this;
    }

    @Override
    public IParticle weight(float f) {
        super.weight(f);
        return this;
    }

    @Override
    public IParticle target(IObject iObject) {
        super.target(iObject);
        return this;
    }

    @Override
    public IParticle removeTarget(int n) {
        super.removeTarget(n);
        return this;
    }

    @Override
    public IParticle removeTarget(IObject iObject) {
        super.removeTarget(iObject);
        return this;
    }
}

