/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IOut;
import igeo.IVec2;
import java.util.ArrayList;

public class IDelaunay2D {
    public static double maxDistToCheck = -1.0;

    public static IVec2[][] getTriangles(IVec2[] iVec2Array, IVec2[][] iVec2Array2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        if (iVec2Array != null) {
            n6 = iVec2Array.length;
        }
        if (iVec2Array2 != null) {
            for (int i = 0; i < iVec2Array2.length; ++i) {
                n7 += iVec2Array2[i].length;
            }
        }
        IVec2[] iVec2Array3 = new IVec2[n6 + n7];
        if (iVec2Array != null) {
            for (int i = 0; i < iVec2Array.length; ++i) {
                iVec2Array3[i] = iVec2Array[i];
            }
        }
        Object object = null;
        if (iVec2Array2 != null) {
            object = new int[iVec2Array2.length][];
            int n8 = n6;
            for (int i = 0; i < iVec2Array2.length; ++i) {
                object[i] = new int[iVec2Array2[i].length];
                for (int j = 0; j < iVec2Array2[i].length; ++j) {
                    iVec2Array3[n8] = iVec2Array2[i][j];
                    object[i][j] = n8++;
                }
            }
        }
        if (iVec2Array3.length == 3) {
            if (IDelaunay2D.isClockwise(iVec2Array3[0], iVec2Array3[1], iVec2Array3[2])) {
                return new IVec2[][]{{iVec2Array3[0], iVec2Array3[2], iVec2Array3[1]}};
            }
            return new IVec2[][]{{iVec2Array3[0], iVec2Array3[1], iVec2Array3[2]}};
        }
        ArrayList<IVec2[]> arrayList = new ArrayList<IVec2[]>();
        ArrayList<FaceIndex> arrayList2 = new ArrayList<FaceIndex>();
        EdgeCounter edgeCounter = new EdgeCounter(iVec2Array3.length);
        for (n5 = 0; n5 < ((int[][])object).length; ++n5) {
            for (n4 = 0; n4 < object[n5].length; ++n4) {
                edgeCounter.addEdge(object[n5][n4], object[n5][(n4 + 1) % object[n5].length]);
            }
        }
        for (n5 = 0; n5 < ((int[][])object).length; ++n5) {
            for (n4 = 0; n4 < object[n5].length; ++n4) {
                n3 = object[n5][n4];
                n2 = object[n5][(n4 + 1) % object[n5].length];
                for (n = 0; n < ((int[][])object).length; ++n) {
                    if (n == n5) continue;
                    for (int i = 0; i < object[n].length; ++i) {
                        if (!iVec2Array3[object[n][i]].isStraight(iVec2Array3[n3], iVec2Array3[n2]) || !iVec2Array3[object[n][i]].isBetween(iVec2Array3[n3], iVec2Array3[n2])) continue;
                        edgeCounter.addEdge(n3, object[n][i]);
                        edgeCounter.addEdge(n2, object[n][i]);
                    }
                }
            }
        }
        for (n5 = 0; n5 < iVec2Array3.length - 2; ++n5) {
            for (n4 = n5 + 1; n4 < iVec2Array3.length - 1; ++n4) {
                for (n3 = n4 + 1; n3 < iVec2Array3.length && edgeCounter.isEdgeOpen(n5, n4); ++n3) {
                    n2 = 0;
                    if (!edgeCounter.isEdgeOpen(n5, n3) || !edgeCounter.isEdgeOpen(n4, n3) || IDelaunay2D.isFaceCrossing(iVec2Array3, edgeCounter, n5, n4, n3) || !IDelaunay2D.checkDirectionOnEdgePoints(iVec2Array3, iVec2Array2, n5, n4, n3, n6) || iVec2Array3[n5].isStraight(iVec2Array3[n4], iVec2Array3[n3])) continue;
                    for (n = 0; n < iVec2Array3.length && n2 == 0; ++n) {
                        if (n == n5 || n == n4 || n == n3 || !IDelaunay2D.isInsideCircumcircle(iVec2Array3[n], iVec2Array3[n5], iVec2Array3[n4], iVec2Array3[n3]) || !IDelaunay2D.checkDirectionOfInnerCircumcirclePoint(iVec2Array3, iVec2Array2, n5, n4, n3, n, n6)) continue;
                        n2 = 1;
                    }
                    if (n2 != 0) continue;
                    if (IDelaunay2D.isClockwise(iVec2Array3[n5], iVec2Array3[n4], iVec2Array3[n3])) {
                        arrayList.add(new IVec2[]{iVec2Array3[n5], iVec2Array3[n3], iVec2Array3[n4]});
                        arrayList2.add(new FaceIndex(n5, n3, n4));
                    } else {
                        arrayList.add(new IVec2[]{iVec2Array3[n5], iVec2Array3[n4], iVec2Array3[n3]});
                        arrayList2.add(new FaceIndex(n5, n4, n3));
                    }
                    edgeCounter.addFace(n5, n4, n3);
                }
            }
        }
        IDelaunay2D.checkNakedEdge(iVec2Array3, arrayList2, arrayList, edgeCounter);
        return (IVec2[][])arrayList.toArray((T[])new IVec2[arrayList.size()][]);
    }

    public static IVec2[][] getTriangles(IVec2[] iVec2Array) {
        if (iVec2Array.length == 3) {
            if (IDelaunay2D.isClockwise(iVec2Array[0], iVec2Array[1], iVec2Array[2])) {
                return new IVec2[][]{{iVec2Array[0], iVec2Array[2], iVec2Array[1]}};
            }
            return new IVec2[][]{{iVec2Array[0], iVec2Array[1], iVec2Array[2]}};
        }
        ArrayList<IVec2[]> arrayList = new ArrayList<IVec2[]>();
        for (int i = 0; i < iVec2Array.length - 2; ++i) {
            IOut.debug(40, i + 1 + "/" + (iVec2Array.length - 2));
            for (int j = i + 1; j < iVec2Array.length - 1; ++j) {
                if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVec2Array[i].dist(iVec2Array[j]) <= maxDistToCheck))) continue;
                for (int k = j + 1; k < iVec2Array.length; ++k) {
                    if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVec2Array[i].dist(iVec2Array[k]) <= maxDistToCheck))) continue;
                    boolean bl = false;
                    for (int i2 = 0; i2 < iVec2Array.length && !bl; ++i2) {
                        if (i2 == i || i2 == j || i2 == k || !IDelaunay2D.isInsideCircumcircle(iVec2Array[i2], iVec2Array[i], iVec2Array[j], iVec2Array[k])) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    if (IDelaunay2D.isClockwise(iVec2Array[i], iVec2Array[j], iVec2Array[k])) {
                        arrayList.add(new IVec2[]{iVec2Array[i], iVec2Array[k], iVec2Array[j]});
                        continue;
                    }
                    arrayList.add(new IVec2[]{iVec2Array[i], iVec2Array[j], iVec2Array[k]});
                }
            }
        }
        return (IVec2[][])arrayList.toArray((T[])new IVec2[arrayList.size()][]);
    }

    public static boolean isInsideCircumcircle(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
        IVec2 iVec25 = null;
        IVec2 iVec26 = null;
        IVec2 iVec27 = null;
        if (IDelaunay2D.isClockwise(iVec22, iVec23, iVec24)) {
            iVec25 = iVec22;
            iVec26 = iVec24;
            iVec27 = iVec23;
        } else {
            iVec25 = iVec22;
            iVec26 = iVec23;
            iVec27 = iVec24;
        }
        double d = IDelaunay2D.determinant(iVec25.x - iVec2.x, iVec25.y - iVec2.y, iVec25.x * iVec25.x - iVec2.x * iVec2.x + (iVec25.y * iVec25.y - iVec2.y * iVec2.y), iVec26.x - iVec2.x, iVec26.y - iVec2.y, iVec26.x * iVec26.x - iVec2.x * iVec2.x + (iVec26.y * iVec26.y - iVec2.y * iVec2.y), iVec27.x - iVec2.x, iVec27.y - iVec2.y, iVec27.x * iVec27.x - iVec2.x * iVec2.x + (iVec27.y * iVec27.y - iVec2.y * iVec2.y));
        return d > 0.0;
    }

    public static boolean isClockwise(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        return iVec22.diff((IVec2)iVec2).cross((IVec2)iVec23.diff((IVec2)iVec22)).z < 0.0;
    }

    public static double determinant(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return d * d5 * d9 + d2 * d6 * d7 + d3 * d4 * d8 - d * d6 * d8 - d2 * d4 * d9 - d3 * d5 * d7;
    }

    public static boolean isFaceCrossing(IVec2[] iVec2Array, EdgeCounter edgeCounter, int n, int n2, int n3) {
        if (edgeCounter.hasOneFace(n, n2) && IDelaunay2D.isVertexOnSameSide(iVec2Array[n], iVec2Array[n2], iVec2Array[n3], iVec2Array[edgeCounter.getFaceVertexIndex(n, n2)])) {
            return true;
        }
        if (edgeCounter.hasOneFace(n, n3) && IDelaunay2D.isVertexOnSameSide(iVec2Array[n], iVec2Array[n3], iVec2Array[n2], iVec2Array[edgeCounter.getFaceVertexIndex(n, n3)])) {
            return true;
        }
        return edgeCounter.hasOneFace(n2, n3) && IDelaunay2D.isVertexOnSameSide(iVec2Array[n2], iVec2Array[n3], iVec2Array[n], iVec2Array[edgeCounter.getFaceVertexIndex(n2, n3)]);
    }

    public static boolean isVertexOnSameSide(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
        IVec2 iVec25 = iVec22.diff(iVec2);
        return iVec25.cross((IVec2)iVec23.diff((IVec2)iVec2)).z * iVec25.cross((IVec2)iVec24.diff((IVec2)iVec2)).z >= 0.0;
    }

    public static boolean isFaceDirectionOnEdgeCorrect(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        double d = iVec22.diff((IVec2)iVec2).cross((IVec2)iVec23.diff((IVec2)iVec2)).z;
        return d >= 0.0;
    }

    public static boolean isFaceDirectionOnEdgeCorrect(IVec2[][] iVec2Array, IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        IVec2[] iVec2Array2 = IDelaunay2D.getAdjacentPointsOnEdgeLoop(iVec2Array, iVec2);
        if (iVec2Array2 == null) {
            return false;
        }
        if (iVec2Array2[0] == iVec22) {
            return IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec22, iVec2, iVec23);
        }
        if (iVec2Array2[0] == iVec23) {
            return IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec23, iVec2, iVec22);
        }
        if (iVec2Array2[1] == iVec22) {
            return IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2, iVec22, iVec23);
        }
        if (iVec2Array2[1] == iVec23) {
            return IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2, iVec23, iVec22);
        }
        if (!IDelaunay2D.isPointInsideEdge(iVec22, iVec2Array2[0], iVec2, iVec2Array2[1])) {
            return false;
        }
        if (!IDelaunay2D.isPointInsideEdge(iVec23, iVec2Array2[0], iVec2, iVec2Array2[1])) {
            return false;
        }
        return !IDelaunay2D.isPointsIntersectiongWithEdge(iVec22, iVec23, iVec2Array2[0], iVec2, iVec2Array2[1]);
    }

    public static boolean isPointsIntersectiongWithEdge(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24, IVec2 iVec25) {
        IVec2 iVec26;
        IVec2 iVec27 = iVec24.diff(iVec23);
        IVec2 iVec28 = iVec25.diff(iVec24);
        if (iVec27.cross((IVec2)iVec28).z >= 0.0) {
            return false;
        }
        if (IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec23, iVec24, iVec2) && IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec23, iVec24, iVec22)) {
            return false;
        }
        if (IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec24, iVec25, iVec2) && IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec24, iVec25, iVec22)) {
            return false;
        }
        IVec2 iVec29 = iVec27.neg().bisect(iVec28);
        return iVec29.dot(iVec26 = iVec2.diff(iVec24).bisect(iVec22.diff(iVec24))) > 0.0;
    }

    public static boolean isPointInsideEdge(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
        IVec2 iVec25 = iVec23.diff(iVec22);
        IVec2 iVec26 = iVec24.diff(iVec23);
        if (iVec25.cross((IVec2)iVec26).z >= 0.0) {
            return IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec22, iVec23, iVec2) && IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec23, iVec24, iVec2);
        }
        return IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec22, iVec23, iVec2) || IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec23, iVec24, iVec2);
    }

    public static boolean checkFaceDirection(IVec2[] iVec2Array, EdgeCounter edgeCounter, int n, int n2, int n3) {
        int n4;
        if (edgeCounter.isEdgeOnOutline(n, n2)) {
            if (n2 - n != 1) {
                n4 = n2;
                n2 = n;
                n = n4;
            }
            if (!IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n], iVec2Array[n2], iVec2Array[n3])) {
                return false;
            }
        }
        if (edgeCounter.isEdgeOnOutline(n, n3)) {
            if (n3 - n != 1) {
                n4 = n;
                n = n3;
                n3 = n4;
            }
            if (!IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n], iVec2Array[n3], iVec2Array[n2])) {
                return false;
            }
        }
        if (edgeCounter.isEdgeOnOutline(n2, n3)) {
            if (n3 - n2 != 1) {
                n4 = n3;
                n3 = n2;
                n2 = n4;
            }
            if (!IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n2], iVec2Array[n3], iVec2Array[n])) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkDirectionOnEdgePoints(IVec2[] iVec2Array, IVec2[][] iVec2Array2, int n, int n2, int n3, int n4) {
        if (n >= n4 && !IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array2, iVec2Array[n], iVec2Array[n2], iVec2Array[n3])) {
            return false;
        }
        if (n2 >= n4 && !IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array2, iVec2Array[n2], iVec2Array[n], iVec2Array[n3])) {
            return false;
        }
        return n3 < n4 || IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array2, iVec2Array[n3], iVec2Array[n], iVec2Array[n2]);
    }

    public static IVec2[] getAdjacentPointsOnEdgeLoop(IVec2[][] iVec2Array, IVec2 iVec2) {
        for (int i = 0; i < iVec2Array.length; ++i) {
            for (int j = 0; j < iVec2Array[i].length; ++j) {
                if (iVec2Array[i][j] != iVec2) continue;
                return new IVec2[]{iVec2Array[i][(j - 1 + iVec2Array[i].length) % iVec2Array[i].length], iVec2Array[i][(j + 1) % iVec2Array[i].length]};
            }
        }
        IOut.err("no point found in edgePts : pt = " + iVec2);
        return null;
    }

    public static boolean checkDirectionOfInnerCircumcirclePoint(IVec2[] iVec2Array, IVec2[][] iVec2Array2, int n, int n2, int n3, int n4, int n5) {
        IVec2[] iVec2Array3;
        IVec2[] iVec2Array4 = null;
        if (n >= n5 && n2 >= n5 && ((iVec2Array4 = IDelaunay2D.getAdjacentPointsOnEdgeLoop(iVec2Array2, iVec2Array[n]))[1] == iVec2Array[n2] && !IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n], iVec2Array[n2], iVec2Array[n4]) || iVec2Array4[0] == iVec2Array[n2] && !IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n2], iVec2Array[n], iVec2Array[n4]))) {
            return false;
        }
        if (n >= n5 && n3 >= n5) {
            if (iVec2Array4 == null) {
                iVec2Array4 = IDelaunay2D.getAdjacentPointsOnEdgeLoop(iVec2Array2, iVec2Array[n]);
            }
            if (iVec2Array4[1] == iVec2Array[n3] && !IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n], iVec2Array[n3], iVec2Array[n4]) || iVec2Array4[0] == iVec2Array[n3] && !IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n3], iVec2Array[n], iVec2Array[n4])) {
                return false;
            }
        }
        return n2 < n5 || n3 < n5 || ((iVec2Array3 = IDelaunay2D.getAdjacentPointsOnEdgeLoop(iVec2Array2, iVec2Array[n2]))[1] != iVec2Array[n3] || IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n2], iVec2Array[n3], iVec2Array[n4])) && (iVec2Array3[0] != iVec2Array[n3] || IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n3], iVec2Array[n2], iVec2Array[n4]));
    }

    public static void checkNakedEdge(IVec2[] iVec2Array, ArrayList<FaceIndex> arrayList, ArrayList<IVec2[]> arrayList2, EdgeCounter edgeCounter) {
        Object object;
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < iVec2Array.length - 1; ++n3) {
            for (n2 = n3 + 1; n2 < iVec2Array.length; ++n2) {
                if (edgeCounter.getEdgeNum(n3, n2) != 1) continue;
                boolean bl = false;
                for (n = 0; n < iVec2Array.length && !bl; ++n) {
                    object = null;
                    boolean bl2 = false;
                    if (n == n3 || n == n2) continue;
                    int n4 = n3;
                    int n5 = n2;
                    int n6 = n;
                    if (n < n3) {
                        n4 = n;
                        n5 = n3;
                        n6 = n2;
                    } else if (n < n2) {
                        n4 = n3;
                        n5 = n;
                        n6 = n2;
                    }
                    if (edgeCounter.isEdgeOnOutline(n4, n5) && edgeCounter.isEdgeOnOutline(n5, n6) && edgeCounter.hasOneFace(n4, n6) && IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n4 == 0 ? n5 : n4], iVec2Array[n4 == 0 ? n4 : n5], iVec2Array[n6])) {
                        bl2 = true;
                    } else if (edgeCounter.isEdgeOnOutline(n4, n6) && edgeCounter.isEdgeOnOutline(n5, n6) && edgeCounter.hasOneFace(n4, n5) && IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n4 == 0 ? n6 : n4], iVec2Array[n4 == 0 ? n4 : n6], iVec2Array[n5])) {
                        bl2 = true;
                    } else if (edgeCounter.isEdgeOnOutline(n4, n6) && edgeCounter.isEdgeOnOutline(n4, n5) && edgeCounter.hasOneFace(n5, n6) && IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n5 == 0 ? n6 : n5], iVec2Array[n5 == 0 ? n5 : n6], iVec2Array[n4])) {
                        bl2 = true;
                    } else if (edgeCounter.isEdgeOnOutline(n4, n5) && edgeCounter.isEdgeOpen(n4, n6) && edgeCounter.isEdgeOpen(n5, n6)) {
                        if (IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n4 == 0 ? n5 : n4], iVec2Array[n4 == 0 ? n4 : n5], iVec2Array[n6]) && !IDelaunay2D.isFaceCrossing(iVec2Array, edgeCounter, n4, n5, n6)) {
                            bl2 = true;
                        }
                    } else if (edgeCounter.isEdgeOnOutline(n4, n6) && edgeCounter.isEdgeOpen(n4, n5) && edgeCounter.isEdgeOpen(n5, n6)) {
                        if (IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n4 == 0 ? n6 : n4], iVec2Array[n4 == 0 ? n4 : n6], iVec2Array[n5]) && !IDelaunay2D.isFaceCrossing(iVec2Array, edgeCounter, n4, n5, n6)) {
                            bl2 = true;
                        }
                    } else if (edgeCounter.isEdgeOnOutline(n5, n6) && edgeCounter.isEdgeOpen(n4, n5) && edgeCounter.isEdgeOpen(n4, n6)) {
                        if (IDelaunay2D.isFaceDirectionOnEdgeCorrect(iVec2Array[n5 == 0 ? n6 : n5], iVec2Array[n5 == 0 ? n5 : n6], iVec2Array[n4]) && !IDelaunay2D.isFaceCrossing(iVec2Array, edgeCounter, n4, n5, n6)) {
                            bl2 = true;
                        }
                    } else if (edgeCounter.getEdgeNum(n4, n5) == 1 && edgeCounter.getEdgeNum(n4, n6) == 1 && edgeCounter.getEdgeNum(n5, n6) == 1 && edgeCounter.getFaceVertexIndex(n4, n5) != -1 && edgeCounter.getFaceVertexIndex(n4, n6) != -1 && edgeCounter.getFaceVertexIndex(n5, n6) != -1 && ((object = IDelaunay2D.findTriangleIndexWithEdge(arrayList, n4, n5)) == null || ((FaceIndex)object).getOtherIndex(n4, n5) != n6)) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    edgeCounter.addFace(n4, n5, n6);
                    arrayList2.add(new IVec2[]{iVec2Array[n4], iVec2Array[n5], iVec2Array[n6]});
                    arrayList.add(new FaceIndex(n4, n5, n6));
                    bl = true;
                }
            }
        }
        for (n3 = 0; n3 < iVec2Array.length - 1; ++n3) {
            for (n2 = n3 + 1; n2 < iVec2Array.length; ++n2) {
                FaceIndex faceIndex;
                if (edgeCounter.getEdgeNum(n3, n2) != 1 || edgeCounter.getFaceVertexIndex(n3, n2) == -1 || (faceIndex = IDelaunay2D.findTriangleIndexWithEdge(arrayList, n3, n2)) == null || (object = IDelaunay2D.findTriangleWithIndex(iVec2Array, arrayList2, n3, n2, n = faceIndex.getOtherIndex(n3, n2))) == null) continue;
                arrayList2.remove(object);
            }
        }
    }

    public static IVec2[] findTriangleWithIndex(IVec2[] iVec2Array, ArrayList<IVec2[]> arrayList, int n, int n2, int n3) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!IDelaunay2D.isSameTriangle(arrayList.get(i), iVec2Array[n], iVec2Array[n2], iVec2Array[n3])) continue;
            return arrayList.get(i);
        }
        return null;
    }

    public static boolean isSameTriangle(IVec2[] iVec2Array, IVec2 iVec2, IVec2 iVec22, IVec2 iVec23) {
        return iVec2Array[0] == iVec2 && iVec2Array[1] == iVec22 && iVec2Array[2] == iVec23 || iVec2Array[0] == iVec22 && iVec2Array[1] == iVec23 && iVec2Array[2] == iVec2 || iVec2Array[0] == iVec23 && iVec2Array[1] == iVec2 && iVec2Array[2] == iVec22 || iVec2Array[0] == iVec2 && iVec2Array[1] == iVec23 && iVec2Array[2] == iVec22 || iVec2Array[0] == iVec22 && iVec2Array[1] == iVec2 && iVec2Array[2] == iVec23 || iVec2Array[0] == iVec23 && iVec2Array[1] == iVec22 && iVec2Array[2] == iVec2;
    }

    public static FaceIndex findTriangleIndexWithEdge(ArrayList<FaceIndex> arrayList, int n, int n2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).contains(n, n2)) continue;
            return arrayList.get(i);
        }
        return null;
    }

    public static class EdgeCounter {
        int[] counter;
        int ptNum;
        int[] faceVertexIndex;

        public EdgeCounter(int n) {
            this.ptNum = n;
            this.counter = new int[n * (n - 1) / 2];
            this.faceVertexIndex = new int[n * (n - 1) / 2];
        }

        public void addEdge(int n, int n2) {
            int n3 = this.getIndex(n, n2);
            this.counter[n3] = this.counter[n3] + 1;
            this.faceVertexIndex[this.getIndex((int)n, (int)n2)] = -1;
        }

        public void addFace(int n, int n2, int n3) {
            int n4 = this.getIndex(n, n2);
            this.counter[n4] = this.counter[n4] + 1;
            int n5 = this.getIndex(n, n3);
            this.counter[n5] = this.counter[n5] + 1;
            int n6 = this.getIndex(n2, n3);
            this.counter[n6] = this.counter[n6] + 1;
            this.faceVertexIndex[this.getIndex((int)n, (int)n2)] = n3;
            this.faceVertexIndex[this.getIndex((int)n, (int)n3)] = n2;
            this.faceVertexIndex[this.getIndex((int)n2, (int)n3)] = n;
        }

        public int getEdgeNum(int n, int n2) {
            return this.counter[this.getIndex(n, n2)];
        }

        public int getFaceVertexIndex(int n, int n2) {
            return this.faceVertexIndex[this.getIndex(n, n2)];
        }

        public boolean isEdgeOpen(int n, int n2) {
            return this.getEdgeNum(n, n2) < 2;
        }

        public boolean hasOneFace(int n, int n2) {
            return this.getEdgeNum(n, n2) == 1 && this.getFaceVertexIndex(n, n2) >= 0;
        }

        public boolean isEdgeOnOutline(int n, int n2) {
            return this.getEdgeNum(n, n2) == 1 && this.getFaceVertexIndex(n, n2) == -1;
        }

        protected int getIndex(int n, int n2) {
            if (n > n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            return n * (this.ptNum - 1) - n * (n - 1) / 2 + (n2 - (n + 1));
        }
    }

    public static class FaceIndex {
        public int index1;
        public int index2;
        public int index3;

        public FaceIndex(int n, int n2, int n3) {
            this.index1 = n;
            this.index2 = n2;
            this.index3 = n3;
        }

        public boolean contains(int n, int n2) {
            return this.index1 == n && this.index2 == n2 || this.index2 == n && this.index1 == n2 || this.index2 == n && this.index3 == n2 || this.index3 == n && this.index2 == n2 || this.index3 == n && this.index1 == n2 || this.index1 == n && this.index3 == n2;
        }

        public int getOtherIndex(int n, int n2) {
            if (this.index1 == n && this.index2 == n2 || this.index2 == n && this.index1 == n2) {
                return this.index3;
            }
            if (this.index2 == n && this.index3 == n2 || this.index3 == n && this.index2 == n2) {
                return this.index1;
            }
            if (this.index3 == n && this.index1 == n2 || this.index1 == n && this.index3 == n2) {
                return this.index2;
            }
            return -1;
        }
    }
}

