/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IFoldable;
import igeo.IG;
import igeo.IOut;
import igeo.ITransformable;
import igeo.IVecI;
import java.util.ArrayList;

public class IFoldableStrip
implements IFoldable {
    ArrayList<IVecI[]> pts;
    ArrayList<ITransformable> faces;

    public IFoldableStrip(IVecI[][] iVecIArray) {
        this.setFold(iVecIArray);
    }

    public IFoldableStrip(ArrayList<IVecI[]> arrayList) {
        this.setFold(arrayList);
    }

    public IFoldableStrip setFold(IVecI[][] iVecIArray) {
        int n;
        if (iVecIArray == null) {
            IOut.err("fold line points are null");
            return this;
        }
        for (n = 0; n < iVecIArray.length; ++n) {
            if (iVecIArray[n].length == 2) continue;
            IOut.err("number of fold line points needs to be 2 (at [" + n + "].length=" + iVecIArray[n].length + ")");
            return this;
        }
        this.pts = new ArrayList();
        for (n = 0; n < iVecIArray.length; ++n) {
            this.pts.add(iVecIArray[n]);
        }
        return this;
    }

    public IFoldableStrip setFold(ArrayList<IVecI[]> arrayList) {
        if (arrayList == null) {
            IOut.err("fold line points are null");
            return this;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i).length == 2) continue;
            IOut.err("number of fold line points needs to be 2 (at [" + i + "].length=" + arrayList.get(i).length + ")");
            return this;
        }
        this.pts = arrayList;
        return this;
    }

    public IFoldableStrip addFold(IVecI iVecI, IVecI iVecI2) {
        return this.addFold(new IVecI[]{iVecI, iVecI2});
    }

    public IFoldableStrip addFold(IVecI[] iVecIArray) {
        if (iVecIArray == null) {
            IOut.err("fold line points are null");
            return this;
        }
        if (iVecIArray.length != 2) {
            IOut.err("number of fold line points needs to be 2 (" + iVecIArray.length + ")");
            return this;
        }
        this.pts.add(iVecIArray);
        return this;
    }

    public IFoldableStrip add(IVecI iVecI) {
        if (this.pts == null) {
            return this;
        }
        for (int i = 0; i < this.pts.size(); ++i) {
            this.pts.get(i)[0].add(iVecI);
            this.pts.get(i)[1].add(iVecI);
        }
        return this;
    }

    public IFoldableStrip rot(IVecI iVecI, double d) {
        if (this.pts == null) {
            return this;
        }
        for (int i = 0; i < this.pts.size(); ++i) {
            this.pts.get(i)[0].rot(iVecI, d);
            this.pts.get(i)[1].rot(iVecI, d);
        }
        return this;
    }

    @Override
    public IFoldableStrip unfold() {
        IVecI iVecI = this.nml(0);
        for (int i = 1; i < this.pts.size() - 1; ++i) {
            IVecI iVecI2 = this.nml(i);
            IVecI iVecI3 = this.pts.get(i)[0];
            IVecI iVecI4 = this.pts.get(i)[1].dif(iVecI3);
            double d = iVecI2.angle(iVecI, iVecI4);
            IG.p("unfold angle = " + d);
            this.fold(i, d);
        }
        return this;
    }

    @Override
    public IFoldableStrip unfold(IVecI iVecI) {
        return this.unfold(iVecI, null);
    }

    @Override
    public IFoldableStrip unfold(IVecI iVecI, IVecI iVecI2) {
        IVecI iVecI3 = this.nml(0);
        IVecI iVecI4 = iVecI3.cross(iVecI);
        double d = iVecI3.angle(iVecI, iVecI4);
        this.rot(iVecI4, d);
        if (this.pts.size() > 0 && iVecI2 != null) {
            IVecI iVecI5 = this.pts.get(1)[0].dif(this.pts.get(0)[0]);
            if (iVecI5.len() < IConfig.tolerance) {
                iVecI5 = this.pts.get(1)[1].dif(this.pts.get(0)[1]);
            }
            double d2 = iVecI5.angle(iVecI2, iVecI);
            this.rot(iVecI, d2);
        }
        return this.unfold();
    }

    public IFoldableStrip unfold(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        if (this.pts == null || this.pts.size() == 0) {
            IOut.err("fold line points are null");
            return this;
        }
        IVecI iVecI4 = iVecI.dif(this.pts.get(0)[0]);
        for (int i = 0; i < this.pts.size(); ++i) {
            this.pts.get(i)[0].add(iVecI4);
            this.pts.get(i)[1].add(iVecI4);
        }
        return this.unfold(iVecI2, iVecI3);
    }

    public IFoldableStrip fold(int n, double d) {
        if (this.pts == null) {
            IOut.err("fold line points are null");
            return this;
        }
        if (n < 0 || n >= this.pts.size() - 1) {
            IOut.err("invalid index(" + n + ") for " + this.pts.size() + " folding lines");
            return null;
        }
        IVecI iVecI = this.pts.get(n)[0];
        IVecI iVecI2 = this.pts.get(n)[1].dif(iVecI);
        for (int i = n + 1; i < this.pts.size(); ++i) {
            this.pts.get(i)[0].rot(iVecI, iVecI2, d);
            this.pts.get(i)[1].rot(iVecI, iVecI2, d);
        }
        return this;
    }

    public IVecI nml(int n) {
        if (n < 0 || n >= this.pts.size() - 1) {
            IOut.err("invalid index(" + n + ") for " + this.pts.size() + " folding lines");
            return null;
        }
        if (this.pts.get(n)[0].eq(this.pts.get(n + 1)[0])) {
            return this.pts.get(n)[0].nml(this.pts.get(n)[1], this.pts.get(n + 1)[1]);
        }
        return this.pts.get(n)[0].nml(this.pts.get(n)[1], this.pts.get(n + 1)[0]);
    }
}

