/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import java.awt.Color;

public class IColor {
    public float[] rgba = new float[4];

    public IColor() {
    }

    public IColor(float f, float f2, float f3, float f4) {
        this();
        this.set(f, f2, f3, f4);
    }

    public IColor(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public IColor(float f, float f2) {
        this(f, f, f, f2);
    }

    public IColor(float f) {
        this(f, f, f);
    }

    public IColor(double d, double d2, double d3, double d4) {
        this();
        this.set(d, d2, d3, d4);
    }

    public IColor(double d, double d2, double d3) {
        this(d, d2, d3, 1.0);
    }

    public IColor(double d, double d2) {
        this(d, d, d, d2);
    }

    public IColor(double d) {
        this(d, d, d);
    }

    public IColor(int n, int n2, int n3, int n4) {
        this();
        this.set((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f);
    }

    public IColor(int n, int n2, int n3) {
        this(n, n2, n3, 255);
    }

    public IColor(int n, int n2) {
        this(n, n, n, n2);
    }

    public IColor(int n) {
        this(n, n, n);
    }

    public IColor(IColor iColor) {
        this(iColor.r(), iColor.g(), iColor.b(), iColor.a());
    }

    public IColor(IColor iColor, float f) {
        this(iColor.r(), iColor.g(), iColor.b(), f);
    }

    public IColor(IColor iColor, double d) {
        this(iColor.r(), iColor.g(), iColor.b(), (float)d);
    }

    public IColor(IColor iColor, int n) {
        this(iColor.r(), iColor.g(), iColor.b(), (float)n / 255.0f);
    }

    public IColor(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public IColor(Color color, float f) {
        this((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, f);
    }

    public IColor(Color color, double d) {
        this(color, (float)d);
    }

    public IColor(Color color, int n) {
        this(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public IColor set(float f, float f2, float f3, float f4) {
        this.rgba[0] = f;
        this.rgba[1] = f2;
        this.rgba[2] = f3;
        this.rgba[3] = f4;
        return this;
    }

    public IColor set(double d, double d2, double d3, double d4) {
        this.rgba[0] = (float)d;
        this.rgba[1] = (float)d2;
        this.rgba[2] = (float)d3;
        this.rgba[3] = (float)d4;
        return this;
    }

    public IColor set(int n, int n2, int n3, int n4) {
        this.rgba[0] = n;
        this.rgba[1] = n2;
        this.rgba[2] = n3;
        this.rgba[3] = n4;
        return this;
    }

    public static IColor hsb(float f, float f2, float f3, float f4) {
        if (f < 0.0f) {
            f += (float)((int)(-f + 1.0f));
        } else if (f > 1.0f) {
            f -= (float)((int)f);
        }
        float f5 = f * 6.0f - (float)((int)(f * 6.0f));
        if (f < 0.16666667f) {
            return new IColor(f3, f3 * (1.0f - f2 * (1.0f - f5)), f3 * (1.0f - f2), f4);
        }
        if (f < 0.33333334f) {
            return new IColor(f3 * (1.0f - f2 * f5), f3, f3 * (1.0f - f2), f4);
        }
        if (f < 0.5f) {
            return new IColor(f3 * (1.0f - f2), f3, f3 * (1.0f - f2 * (1.0f - f5)), f4);
        }
        if (f < 0.6666667f) {
            return new IColor(f3 * (1.0f - f2), f3 * (1.0f - f2 * f5), f3, f4);
        }
        if (f < 0.8333333f) {
            return new IColor(f3 * (1.0f - f2 * (1.0f - f5)), f3 * (1.0f - f2), f3, f4);
        }
        return new IColor(f3, f3 * (1.0f - f2), f3 * (1.0f - f2 * f5), f4);
    }

    public static IColor hsb(float f, float f2, float f3) {
        return IColor.hsb(f, f2, f3, 1.0f);
    }

    public static IColor hsb(double d, double d2, double d3, double d4) {
        return IColor.hsb((float)d, (float)d2, (float)d3, (float)d4);
    }

    public static IColor hsb(double d, double d2, double d3) {
        return IColor.hsb((float)d, (float)d2, (float)d3, 1.0f);
    }

    public float[] rgba() {
        return this.rgba;
    }

    public int argb() {
        int n = (int)(this.rgba[0] * 255.0f);
        int n2 = (int)(this.rgba[1] * 255.0f);
        int n3 = (int)(this.rgba[2] * 255.0f);
        int n4 = (int)(this.rgba[3] * 255.0f);
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        return (n4 << 24) + (n << 16) + (n2 << 8) + n3;
    }

    public int getInt() {
        return this.argb();
    }

    public int i() {
        return this.argb();
    }

    public float r() {
        return this.rgba[0];
    }

    public float g() {
        return this.rgba[1];
    }

    public float b() {
        return this.rgba[2];
    }

    public float a() {
        return this.rgba[3];
    }

    public float red() {
        return this.r();
    }

    public float green() {
        return this.g();
    }

    public float blue() {
        return this.b();
    }

    public float alpha() {
        return this.a();
    }

    public float grey() {
        return (this.r() + this.g() + this.b()) / 3.0f;
    }

    public IColor r(float f) {
        this.rgba[0] = f;
        return this;
    }

    public IColor g(float f) {
        this.rgba[1] = f;
        return this;
    }

    public IColor b(float f) {
        this.rgba[2] = f;
        return this;
    }

    public IColor a(float f) {
        this.rgba[3] = f;
        return this;
    }

    public IColor red(float f) {
        return this.r(f);
    }

    public IColor green(float f) {
        return this.g(f);
    }

    public IColor blue(float f) {
        return this.b(f);
    }

    public IColor alpha(float f) {
        return this.a(f);
    }

    public IColor grey(float f) {
        this.r(f);
        this.g(f);
        this.b(f);
        return this;
    }

    public int getRed() {
        return (int)(this.r() * 255.0f);
    }

    public int getGreen() {
        return (int)(this.g() * 255.0f);
    }

    public int getBlue() {
        return (int)(this.b() * 255.0f);
    }

    public int getAlpha() {
        return (int)(this.a() * 255.0f);
    }

    public int getGrey() {
        return (int)((this.r() + this.g() + this.b()) * 255.0f / 3.0f);
    }

    public Color awt() {
        float f = this.r();
        float f2 = this.g();
        float f3 = this.b();
        float f4 = this.a();
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        return new Color(f, f2, f3, f4);
    }

    public String toString() {
        return "(r=" + String.valueOf(this.rgba[0]) + ",g=" + String.valueOf(this.rgba[1]) + ",b=" + String.valueOf(this.rgba[2]) + ",a=" + String.valueOf(this.rgba[3]) + ")";
    }

    public IColor dup() {
        return new IColor(this);
    }

    public IColor cp() {
        return this.dup();
    }

    public IColor blend(IColor iColor, float f) {
        this.rgba[0] = this.rgba[0] * (1.0f - f) + iColor.r() * f;
        this.rgba[1] = this.rgba[1] * (1.0f - f) + iColor.g() * f;
        this.rgba[2] = this.rgba[2] * (1.0f - f) + iColor.b() * f;
        this.rgba[3] = this.rgba[3] * (1.0f - f) + iColor.a() * f;
        return this;
    }

    public IColor blend(IColor iColor) {
        return this.blend(iColor, 0.5f);
    }

    public boolean eq(IColor iColor) {
        return iColor.r() == this.r() && iColor.g() == this.g() && iColor.b() == this.b() && iColor.a() == this.a();
    }

    public boolean eq(float f, float f2, float f3, float f4) {
        return this.r() == f && this.g() == f2 && this.b() == f3 && this.a() == f4;
    }

    public boolean eq(float f, float f2, float f3) {
        return this.r() == f && this.g() == f2 && this.b() == f3;
    }
}

