/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IParticleGeo;
import igeo.IVec;
import igeo.IVecI;

public class IParticleDistanceLink
extends IDynamicsBase {
    public IParticleGeo particle;
    public IVecI center;
    public double distance;

    public IParticleDistanceLink(IParticleGeo iParticleGeo, IVecI iVecI, IObject iObject) {
        super(iObject);
        this.particle = iParticleGeo;
        this.center = iVecI;
        this.distance = this.center.dist(this.particle);
        this.initParticleDistanceLink();
    }

    public IParticleDistanceLink(IParticleGeo iParticleGeo, IVecI iVecI) {
        this.particle = iParticleGeo;
        this.center = iVecI;
        this.distance = this.center.dist(this.particle);
        this.initParticleDistanceLink();
    }

    public IParticleDistanceLink(IParticleGeo iParticleGeo, IVecI iVecI, double d, IObject iObject) {
        super(iObject);
        this.particle = iParticleGeo;
        this.center = iVecI;
        this.distance = d;
        iParticleGeo.pos.set(iParticleGeo.pos.diff(this.center).len(this.distance).add(this.center));
        if (this.distance < 0.0) {
            this.distance = -this.distance;
        }
        this.initParticleDistanceLink();
    }

    public IParticleDistanceLink(IParticleGeo iParticleGeo, double d, IVecI iVecI) {
        this.particle = iParticleGeo;
        this.center = iVecI;
        this.distance = d;
        iParticleGeo.pos.set(iParticleGeo.pos.diff(this.center).len(this.distance).add(this.center));
        if (this.distance < 0.0) {
            this.distance = -this.distance;
        }
        this.initParticleDistanceLink();
    }

    public void initParticleDistanceLink() {
        this.particle.fix();
    }

    @Override
    public synchronized void update() {
        IVec iVec = this.particle.pos.diff(this.center);
        this.particle.frc.set(this.particle.frc.perpendicularVecToLine(iVec).neg());
        this.particle.frc.mul(IConfig.updateRate / this.particle.mass);
        this.particle.vel.add(this.particle.frc).mul(1.0 - this.particle.friction);
        this.particle.vel.set(this.particle.vel.perpendicularVecToLine(iVec).neg());
        this.particle.pos.add(this.particle.vel.dup().mul(IConfig.updateRate));
        iVec = this.particle.pos.diff(this.center);
        iVec.len(this.distance).add(this.center);
        this.particle.pos.set(iVec);
        this.particle.updateTarget();
    }
}

