/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IColor;
import igeo.IG;
import igeo.IObject;
import igeo.IOut;
import igeo.IServerI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec4;
import igeo.io.IRhino3dm;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class IRhino3dmImporter
extends IRhino3dm {
    public InputStream istream;
    public boolean eof = false;
    public IRhino3dm.Rhino3dmFile file;
    public IServerI server;
    public ArrayList<IObject> objects;

    public IRhino3dmImporter(InputStream inputStream, IServerI iServerI) {
        this.istream = inputStream;
        this.server = iServerI;
    }

    public void readFileHeader() throws IOException {
        byte[] byArray = new byte[24];
        byte[] byArray2 = new byte[8];
        this.istream.read(byArray, 0, 24);
        this.istream.read(byArray2, 0, 8);
        try {
            String string = new String(byArray2);
            String[] stringArray = string.split("\\s+");
            string = stringArray[stringArray.length - 1];
            this.file.version = string.equals("X") ? 2 : Integer.parseInt(string);
            IOut.debug(10, "3DM FILE VERSION = " + this.file.version);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    public static byte[] read(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            if (i > 0) {
                byte[] byArray2 = new byte[i];
                System.arraycopy(byArray, 0, byArray2, 0, i);
                IOut.err("unexpected end of stream : len=" + n + ", ptr=" + i + ", res=" + n2);
                IRhino3dmImporter.printAsciiOrHex(byArray2, IOut.err);
                throw new IOException();
            }
            throw new EOFException();
        }
        return byArray;
    }

    public static char readChar(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (char)n;
    }

    public static byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public static byte[] readBytes(InputStream inputStream, int n) throws IOException {
        return IRhino3dmImporter.read(inputStream, n);
    }

    public static boolean readBool(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readByte(inputStream) != 0;
    }

    public static short readShort(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readInt16(inputStream);
    }

    public static short readInt16(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readInt16(IRhino3dmImporter.read(inputStream, 2));
    }

    public static short readInt16(byte[] byArray) {
        return (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    public static int readInt(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readInt32(inputStream);
    }

    public static int readInt32(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readInt32(IRhino3dmImporter.read(inputStream, 4));
    }

    public static int readInt32(byte[] byArray) {
        return byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    public static long readLong(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readInt64(inputStream);
    }

    public static long readInt64(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readInt64(IRhino3dmImporter.read(inputStream, 8));
    }

    public static long readInt64(byte[] byArray) {
        long l = 0L;
        for (int i = 7; i >= 0; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readFloat(IRhino3dmImporter.read(inputStream, 4));
    }

    public static float readFloat(byte[] byArray) {
        return Float.intBitsToFloat(IRhino3dmImporter.readInt32(byArray));
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readDouble(IRhino3dmImporter.read(inputStream, 8));
    }

    public static double readDouble(byte[] byArray) {
        return Double.longBitsToDouble(IRhino3dmImporter.readInt64(byArray));
    }

    public static IColor readColor(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readColor(IRhino3dmImporter.readInt32(inputStream));
    }

    public static IColor readColor(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return new IColor(n2, n3, n4, 255 - n5);
    }

    public static String readString(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        if (n == 0) {
            return "";
        }
        if (n < 65535) {
            byte[] byArray = IRhino3dmImporter.read(inputStream, n * 2);
            return new String(byArray, 0, n * 2 - 2, "UTF-16LE");
        }
        IOut.err("invalid string length: len = " + n);
        return null;
    }

    public static IRhino3dm.UUID readUUID(IRhino3dm.Chunk chunk) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
        return IRhino3dmImporter.readUUID(byteArrayInputStream);
    }

    public static IRhino3dm.UUID readUUID(InputStream inputStream) throws IOException {
        IRhino3dm.UUID uUID = new IRhino3dm.UUID();
        uUID.data1 = IRhino3dmImporter.readInt(inputStream);
        uUID.data2 = IRhino3dmImporter.readShort(inputStream);
        uUID.data3 = IRhino3dmImporter.readShort(inputStream);
        byte[] byArray = IRhino3dmImporter.read(inputStream, 8);
        uUID.data4 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            uUID.data4[i] = byArray[i];
        }
        return uUID;
    }

    public static IVec2 readPoint2(InputStream inputStream) throws IOException {
        IVec2 iVec2 = new IVec2();
        iVec2.x = IRhino3dmImporter.readDouble(inputStream);
        iVec2.y = IRhino3dmImporter.readDouble(inputStream);
        return iVec2;
    }

    public static IVec2 readPoint2f(InputStream inputStream) throws IOException {
        IVec2 iVec2 = new IVec2();
        iVec2.x = IRhino3dmImporter.readFloat(inputStream);
        iVec2.y = IRhino3dmImporter.readFloat(inputStream);
        return iVec2;
    }

    public static IVec readPoint3(InputStream inputStream) throws IOException {
        IVec iVec = new IVec();
        iVec.x = IRhino3dmImporter.readDouble(inputStream);
        iVec.y = IRhino3dmImporter.readDouble(inputStream);
        iVec.z = IRhino3dmImporter.readDouble(inputStream);
        return iVec;
    }

    public static IVec readPoint3f(InputStream inputStream) throws IOException {
        IVec iVec = new IVec();
        iVec.x = IRhino3dmImporter.readFloat(inputStream);
        iVec.y = IRhino3dmImporter.readFloat(inputStream);
        iVec.z = IRhino3dmImporter.readFloat(inputStream);
        return iVec;
    }

    public static IVec readPoint4(InputStream inputStream) throws IOException {
        IVec4 iVec4 = new IVec4();
        iVec4.x = IRhino3dmImporter.readDouble(inputStream);
        iVec4.y = IRhino3dmImporter.readDouble(inputStream);
        iVec4.z = IRhino3dmImporter.readDouble(inputStream);
        iVec4.w = IRhino3dmImporter.readDouble(inputStream);
        return iVec4;
    }

    public static IRhino3dm.Line readLine(InputStream inputStream) throws IOException {
        IRhino3dm.Line line = new IRhino3dm.Line();
        line.from = IRhino3dmImporter.readPoint3(inputStream);
        line.to = IRhino3dmImporter.readPoint3(inputStream);
        return line;
    }

    public static IRhino3dm.Plane readPlane(InputStream inputStream) throws IOException {
        IRhino3dm.Plane plane = new IRhino3dm.Plane();
        plane.origin = IRhino3dmImporter.readPoint3(inputStream);
        plane.xaxis = IRhino3dmImporter.readPoint3(inputStream);
        plane.yaxis = IRhino3dmImporter.readPoint3(inputStream);
        plane.zaxis = IRhino3dmImporter.readPoint3(inputStream);
        IRhino3dm.PlaneEquation planeEquation = new IRhino3dm.PlaneEquation();
        planeEquation.x = IRhino3dmImporter.readDouble(inputStream);
        planeEquation.y = IRhino3dmImporter.readDouble(inputStream);
        planeEquation.z = IRhino3dmImporter.readDouble(inputStream);
        planeEquation.d = IRhino3dmImporter.readDouble(inputStream);
        plane.planeEquation = planeEquation;
        return plane;
    }

    public static IRhino3dm.SurfaceCurvature readSurfaceCurvature(InputStream inputStream) throws IOException {
        IRhino3dm.SurfaceCurvature surfaceCurvature = new IRhino3dm.SurfaceCurvature();
        surfaceCurvature.k1 = IRhino3dmImporter.readDouble(inputStream);
        surfaceCurvature.k2 = IRhino3dmImporter.readDouble(inputStream);
        return surfaceCurvature;
    }

    public static ArrayList<Integer> readArrayInt(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readInt(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<Double> readArrayDouble(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readDouble(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<IVec> readArrayPoint(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<IVec> arrayList = new ArrayList<IVec>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readPoint3(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<IVec2> readArrayPoint2(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readPoint2(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<IVec2> readArrayPoint2(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readPoint2(byteArrayInputStream));
        }
        return arrayList;
    }

    public static ArrayList<IColor> readArrayColor(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<IColor> arrayList = new ArrayList<IColor>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readColor(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<IColor> readArrayColor(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArrayList<IColor> arrayList = new ArrayList<IColor>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readColor(byteArrayInputStream));
        }
        return arrayList;
    }

    public static ArrayList<IVec2> readArrayPoint2f(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readPoint2f(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<IVec2> readArrayPoint2f(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArrayList<IVec2> arrayList = new ArrayList<IVec2>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readPoint2f(byteArrayInputStream));
        }
        return arrayList;
    }

    public static ArrayList<IVec> readArrayPoint3f(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<IVec> arrayList = new ArrayList<IVec>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readPoint3f(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<IVec> readArrayPoint3f(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArrayList<IVec> arrayList = new ArrayList<IVec>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readPoint3f(byteArrayInputStream));
        }
        return arrayList;
    }

    public static ArrayList<IRhino3dm.SurfaceCurvature> readArraySurfaceCurvature(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<IRhino3dm.SurfaceCurvature> arrayList = new ArrayList<IRhino3dm.SurfaceCurvature>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readSurfaceCurvature(inputStream));
        }
        return arrayList;
    }

    public static ArrayList<IRhino3dm.SurfaceCurvature> readArraySurfaceCurvature(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArrayList<IRhino3dm.SurfaceCurvature> arrayList = new ArrayList<IRhino3dm.SurfaceCurvature>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(IRhino3dmImporter.readSurfaceCurvature(byteArrayInputStream));
        }
        return arrayList;
    }

    public static ArrayList<IRhino3dm.UUIDIndex> readArrayUUIDIndex(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        ArrayList<IRhino3dm.UUIDIndex> arrayList = new ArrayList<IRhino3dm.UUIDIndex>(n);
        for (int i = 0; i < n; ++i) {
            IRhino3dm.UUIDIndex uUIDIndex = new IRhino3dm.UUIDIndex();
            uUIDIndex.id = IRhino3dmImporter.readUUID(inputStream);
            uUIDIndex.i = IRhino3dmImporter.readInt(inputStream);
            arrayList.add(uUIDIndex);
        }
        return arrayList;
    }

    public static ArrayList<IRhino3dm.UUIDIndex> readArrayUUIDIndex(byte[] byArray, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArrayList<IRhino3dm.UUIDIndex> arrayList = new ArrayList<IRhino3dm.UUIDIndex>(n);
        for (int i = 0; i < n; ++i) {
            IRhino3dm.UUIDIndex uUIDIndex = new IRhino3dm.UUIDIndex();
            uUIDIndex.id = IRhino3dmImporter.readUUID(byteArrayInputStream);
            uUIDIndex.i = IRhino3dmImporter.readInt(byteArrayInputStream);
            arrayList.add(uUIDIndex);
        }
        return arrayList;
    }

    public static IRhino3dm.PointArray readPointArray(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        IRhino3dm.PointArray pointArray = new IRhino3dm.PointArray(n);
        for (int i = 0; i < n; ++i) {
            pointArray.add(IRhino3dmImporter.readPoint3(inputStream));
        }
        return pointArray;
    }

    public static IRhino3dm.Polyline readPolyline(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt(inputStream);
        IRhino3dm.Polyline polyline = new IRhino3dm.Polyline(n);
        for (int i = 0; i < n; ++i) {
            polyline.add(IRhino3dmImporter.readPoint3(inputStream));
        }
        return polyline;
    }

    public static IRhino3dm.Circle readCircle(InputStream inputStream) throws IOException {
        IRhino3dm.Circle circle = new IRhino3dm.Circle();
        circle.plane = IRhino3dmImporter.readPlane(inputStream);
        circle.radius = IRhino3dmImporter.readDouble(inputStream);
        IVec iVec = IRhino3dmImporter.readPoint3(inputStream);
        iVec = IRhino3dmImporter.readPoint3(inputStream);
        iVec = IRhino3dmImporter.readPoint3(inputStream);
        return circle;
    }

    public static IRhino3dm.Arc readArc(InputStream inputStream) throws IOException {
        IRhino3dm.Arc arc = new IRhino3dm.Arc();
        arc.plane = IRhino3dmImporter.readPlane(inputStream);
        arc.radius = IRhino3dmImporter.readDouble(inputStream);
        IVec iVec = IRhino3dmImporter.readPoint3(inputStream);
        iVec = IRhino3dmImporter.readPoint3(inputStream);
        iVec = IRhino3dmImporter.readPoint3(inputStream);
        arc.angle = IRhino3dmImporter.readInterval(inputStream);
        return arc;
    }

    public static IRhino3dm.Interval readInterval(InputStream inputStream) throws IOException {
        IRhino3dm.Interval interval = new IRhino3dm.Interval();
        interval.v1 = IRhino3dmImporter.readDouble(inputStream);
        interval.v2 = IRhino3dmImporter.readDouble(inputStream);
        return interval;
    }

    public static IRhino3dm.Xform readXform(InputStream inputStream) throws IOException {
        double[][] dArray = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray[i][j] = IRhino3dmImporter.readDouble(inputStream);
            }
        }
        return new IRhino3dm.Xform(dArray);
    }

    public static IRhino3dm.BoundingBox readBoundingBox(InputStream inputStream) throws IOException {
        IRhino3dm.BoundingBox boundingBox = new IRhino3dm.BoundingBox();
        boundingBox.min.x = IRhino3dmImporter.readDouble(inputStream);
        boundingBox.min.y = IRhino3dmImporter.readDouble(inputStream);
        boundingBox.min.z = IRhino3dmImporter.readDouble(inputStream);
        boundingBox.max.x = IRhino3dmImporter.readDouble(inputStream);
        boundingBox.max.y = IRhino3dmImporter.readDouble(inputStream);
        boundingBox.max.z = IRhino3dmImporter.readDouble(inputStream);
        return boundingBox;
    }

    public static int[] readChunkVersion(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readChunkVersion(IRhino3dmImporter.readByte(inputStream));
    }

    public static int[] readChunkVersion(byte by) {
        int n = by & 0xF;
        int n2 = (by & 0xF0) >> 4;
        return new int[]{n2, n};
    }

    public static boolean isShortChunk(int n) {
        return (n & Integer.MIN_VALUE) != 0;
    }

    public static IRhino3dm.Chunk readChunk(InputStream inputStream) throws IOException {
        int n = IRhino3dmImporter.readInt32(inputStream);
        int n2 = IRhino3dmImporter.readInt32(inputStream);
        if (IRhino3dmImporter.isShortChunk(n) || n2 == 0) {
            return new IRhino3dm.Chunk(n, n2);
        }
        if (n2 < 0) {
            IOut.err("length of content isn't positive: " + n2);
            return null;
        }
        if (n2 > 1000000000) {
            IOut.err("length of content seems too big: " + n2);
            return null;
        }
        byte[] byArray = IRhino3dmImporter.read(inputStream, n2);
        return new IRhino3dm.Chunk(n, n2, byArray);
    }

    public static IRhino3dm.Chunk[] readChunkTable(IRhino3dm.Chunk chunk) {
        return IRhino3dmImporter.readChunkTable(chunk, -1);
    }

    public static IRhino3dm.Chunk[] readChunkTable(IRhino3dm.Chunk chunk, int n) {
        if (chunk == null) {
            IOut.err("input chunk is null");
            return null;
        }
        if (chunk.content == null) {
            IOut.err("no content in the input chunk");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
        IRhino3dm.Chunk chunk2 = null;
        ArrayList<IRhino3dm.Chunk> arrayList = new ArrayList<IRhino3dm.Chunk>();
        int n2 = 1;
        do {
            try {
                chunk2 = IRhino3dmImporter.readChunk(byteArrayInputStream);
                if (chunk2 == null) {
                    IOut.err("no chunk is read");
                    return null;
                }
                if (chunk2.header == n) {
                    chunk2 = null;
                }
                ++n2;
            }
            catch (EOFException eOFException) {
                IOut.err("unexpected EOF of chunk");
                chunk2 = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                chunk2 = null;
            }
            if (chunk2 == null) continue;
            arrayList.add(chunk2);
        } while (chunk2 != null);
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new IRhino3dm.Chunk[arrayList.size()]);
    }

    public static IRhino3dm.Chunk readNestedChunk(IRhino3dm.Chunk chunk) {
        if (chunk == null) {
            IOut.err("input chunk is null");
            return null;
        }
        if (chunk.content == null) {
            IOut.err("no content in the input chunk");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
        try {
            IRhino3dm.Chunk chunk2 = IRhino3dmImporter.readChunk(byteArrayInputStream);
            return chunk2;
        }
        catch (EOFException eOFException) {
            IOut.err("unexpected EOF");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public IRhino3dm.RhinoObject readObject(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readObject(this.file, IRhino3dmImporter.readChunk(inputStream));
    }

    public IRhino3dm.RhinoObject readObject(IRhino3dm.Chunk chunk) {
        return IRhino3dmImporter.readObject(this.file, chunk);
    }

    public static IRhino3dm.RhinoObject readObject(IRhino3dm.Rhino3dmFile rhino3dmFile, InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readObject(rhino3dmFile, IRhino3dmImporter.readChunk(inputStream));
    }

    public static IRhino3dm.RhinoObject readObject(IRhino3dm.Rhino3dmFile rhino3dmFile, IRhino3dm.Chunk chunk) {
        if (chunk == null || chunk.header != 163834) {
            IOut.err("no tcodeOpenNurbsClass block found");
            return null;
        }
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk, -2147319809);
        if (chunkArray == null) {
            IOut.err("chunk table is null");
            return null;
        }
        try {
            for (int i = 0; i < chunkArray.length - 1; ++i) {
                if (chunkArray[i].header == 196603) {
                    IRhino3dm.UUID uUID = IRhino3dmImporter.readUUID(chunkArray[i]);
                    Class<? extends IRhino3dm.RhinoObject> clazz = IRhino3dm.ClassRegistry.get(uUID);
                    IOut.debug(10, "uuid class = " + clazz);
                    if (clazz == null) continue;
                    IRhino3dm.RhinoObject rhinoObject = null;
                    try {
                        rhinoObject = clazz.newInstance();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (rhinoObject == null || chunkArray[i + 1].header != 196604) continue;
                    byte[] byArray = chunkArray[i + 1].content;
                    rhinoObject.read(rhino3dmFile, byArray);
                    return rhinoObject;
                }
                if (chunkArray[i].header != 163837) continue;
                IOut.debug(20, "user data = \n" + chunkArray[i]);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        IOut.err("no UUID or ClassData is found");
        return null;
    }

    public static int readCompressedBufferSize(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readSize(inputStream);
    }

    public static int readSize(InputStream inputStream) throws IOException {
        return IRhino3dmImporter.readInt(inputStream);
    }

    public static byte[] readCompressedBuffer(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        boolean bl = false;
        byte by = 0;
        n2 = IRhino3dmImporter.readInt(inputStream);
        by = IRhino3dmImporter.readByte(inputStream);
        if (by == 0) {
            return IRhino3dmImporter.readBytes(inputStream, n);
        }
        if (by == 1) {
            return IRhino3dmImporter.readInflate(inputStream, n);
        }
        throw new IOException("method is invalid value: " + String.valueOf(by));
    }

    public static byte[] readInflate(InputStream inputStream, int n) throws IOException {
        IRhino3dm.Chunk chunk = IRhino3dmImporter.readChunk(inputStream);
        if (chunk == null) {
            IOut.err("no chunk is read");
            return null;
        }
        if (chunk.header != 0x40008000) {
            throw new IOException("invalid type code = " + IRhino3dmImporter.hex(chunk.header));
        }
        if (chunk.body <= 4) {
            throw new IOException("chunk length is too short = " + chunk.body);
        }
        int n2 = chunk.body - 4;
        Inflater inflater = new Inflater();
        inflater.setInput(chunk.content, 0, n2);
        byte[] byArray = new byte[n];
        try {
            inflater.inflate(byArray, 0, n);
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("DataFormatException:" + dataFormatException.getMessage());
        }
        return byArray;
    }

    public static boolean read(File file, IServerI iServerI) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            boolean bl = IRhino3dmImporter.read((InputStream)fileInputStream, iServerI);
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static boolean read(InputStream inputStream, IServerI iServerI) {
        IRhino3dmImporter iRhino3dmImporter = new IRhino3dmImporter(inputStream, iServerI);
        iRhino3dmImporter.read();
        return true;
    }

    public void read() {
        this.file = new IRhino3dm.Rhino3dmFile();
        this.file.setServer(this.server);
        IRhino3dm.ClassRegistry.init();
        this.objects = new ArrayList();
        try {
            this.readFileHeader();
            IRhino3dm.Chunk chunk = null;
            int n = 0;
            do {
                IOut.debug(10, "chunk #" + ++n);
                try {
                    chunk = IRhino3dmImporter.readChunk(this.istream);
                    if (chunk == null) {
                        IOut.err("chunk is null");
                        continue;
                    }
                    switch (chunk.header) {
                        case 1: {
                            this.readStartSection(chunk);
                            break;
                        }
                        case 0x10000014: {
                            this.readPropertiesTable(chunk);
                            break;
                        }
                        case 0x10000015: {
                            this.readSettingsTable(chunk);
                            break;
                        }
                        case 0x10000016: {
                            this.readBitmapTable(chunk);
                            break;
                        }
                        case 268435493: {
                            this.readTextureMappingTable(chunk);
                            break;
                        }
                        case 0x10000010: {
                            this.readMaterialTable(chunk);
                            break;
                        }
                        case 268435491: {
                            this.readLinetypeTable(chunk);
                            break;
                        }
                        case 0x10000011: {
                            this.readLayerTable(chunk);
                            break;
                        }
                        case 0x10000018: {
                            this.readGroupTable(chunk);
                            break;
                        }
                        case 0x10000019: {
                            this.readFontTable(chunk);
                            break;
                        }
                        case 0x10000020: {
                            this.readDimStyleTable(chunk);
                            break;
                        }
                        case 0x10000012: {
                            this.readLightTable(chunk);
                            break;
                        }
                        case 0x10000022: {
                            this.readHatchPatternTable(chunk);
                            break;
                        }
                        case 0x10000021: {
                            this.readInstanceDefinitionTable(chunk);
                            break;
                        }
                        case 0x10000013: {
                            this.readObjectTable(chunk);
                            break;
                        }
                        case 268435494: {
                            this.readHistoryRecordTable(chunk);
                            break;
                        }
                        case 0x10000017: {
                            this.readUserDataTable(chunk);
                            break;
                        }
                        case 32767: {
                            this.readEndMark(chunk);
                            break;
                        }
                        default: {
                            IOut.err("unknown type code: " + IRhino3dmImporter.hex(chunk.header));
                        }
                    }
                }
                catch (EOFException eOFException) {
                    chunk = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    chunk = null;
                }
            } while (chunk != null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readStartSection(IRhino3dm.Chunk chunk) {
        int n;
        IOut.debug(10, "Rhino3dmImporter.readStartSection");
        for (n = chunk.content.length; n > 0 && (chunk.content[n - 1] == 0 || chunk.content[n - 1] == 26); --n) {
        }
        String string = new String(chunk.content, 0, n);
        this.file.startSection = new IRhino3dm.StartSection(string);
    }

    public void readPropertiesTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readProperties");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            IOut.err("no table item is found");
            return;
        }
        IRhino3dm.Properties properties = new IRhino3dm.Properties();
        block9: for (IRhino3dm.Chunk chunk2 : chunkArray) {
            switch (chunk2.header) {
                case 536903713: {
                    properties.setRevisionHistory(chunk2);
                    continue block9;
                }
                case 0x20008022: {
                    properties.setNotes(chunk2);
                    continue block9;
                }
                case 536903715: {
                    properties.setPreviewImage(chunk2);
                    continue block9;
                }
                case 536903716: {
                    properties.setApplication(chunk2);
                    continue block9;
                }
                case 536903717: {
                    properties.setCompressedPreviewImage(chunk2);
                    continue block9;
                }
                case -1610612698: {
                    properties.setOpenNurbsVersion(chunk2);
                    this.file.openNurbsVersion = properties.openNurbsVersion;
                    continue block9;
                }
                case -1: {
                    chunk2 = null;
                    continue block9;
                }
                default: {
                    IOut.err("unknown type code: " + IRhino3dmImporter.hex(chunk2.header));
                }
            }
        }
        this.file.properties = properties;
    }

    public void readSettingsTable(IRhino3dm.Chunk chunk) throws IOException {
        IOut.debug(10, "Rhino3dmImporter.readSettings");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            IOut.err("no table item is found");
            return;
        }
        IRhino3dm.Settings settings = new IRhino3dm.Settings();
        block21: for (IRhino3dm.Chunk chunk2 : chunkArray) {
            switch (chunk2.header) {
                case 536903989: {
                    settings.setPluginList(this.file, chunk2);
                    continue block21;
                }
                case 536903729: {
                    settings.setUnitsAndTols(this.file, chunk2);
                    continue block21;
                }
                case 536903730: {
                    settings.setRenderMesh(this.file, chunk2);
                    continue block21;
                }
                case 536903731: {
                    settings.setAnalysisMesh(this.file, chunk2);
                    continue block21;
                }
                case 536903732: {
                    settings.setAnnotation(this.file, chunk2);
                    continue block21;
                }
                case 536903733: {
                    settings.setNamedCPlaneList(this.file, chunk2);
                    continue block21;
                }
                case 536903734: {
                    settings.setNamedViewList(this.file, chunk2);
                    continue block21;
                }
                case 536903735: {
                    settings.setViewList(this.file, chunk2);
                    continue block21;
                }
                case 536903742: {
                    continue block21;
                }
                case -1610612680: {
                    settings.setCurrentLayerIndex(this.file, chunk2);
                    continue block21;
                }
                case -1610612430: {
                    settings.setCurrentFontIndex(this.file, chunk2);
                    continue block21;
                }
                case -1610612429: {
                    settings.setCurrentDimStyleIndex(this.file, chunk2);
                    continue block21;
                }
                case 536903737: {
                    settings.setCurrentMaterialIndex(this.file, chunk2);
                    continue block21;
                }
                case 536903738: {
                    settings.setCurrentColor(this.file, chunk2);
                    continue block21;
                }
                case -1610612676: {
                    settings.setCurrentWireDensity(this.file, chunk2);
                    continue block21;
                }
                case 536903741: {
                    settings.setRender(this.file, chunk2);
                    continue block21;
                }
                case 536903743: {
                    settings.setGridDefaults(this.file, chunk2);
                    continue block21;
                }
                case 536903985: {
                    settings.setModelURL(this.file, chunk2);
                    continue block21;
                }
                case 536903988: {
                    settings.setAttributes(this.file, chunk2);
                    continue block21;
                }
                default: {
                    IOut.err("unknown type code: " + IRhino3dmImporter.hex(chunk2.header));
                }
            }
        }
        this.file.settings = settings;
    }

    public void readBitmapTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readBitmapTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.Bitmap> arrayList = new ArrayList<IRhino3dm.Bitmap>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.Bitmap bitmap = this.readBitmap(chunk2);
            if (bitmap == null) continue;
            arrayList.add(bitmap);
        }
        if (arrayList.size() > 0) {
            this.file.bitmaps = arrayList.toArray(new IRhino3dm.Bitmap[arrayList.size()]);
        }
    }

    public IRhino3dm.Bitmap readBitmap(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readBitmap");
        if (this.file.version == 1) {
            return null;
        }
        IRhino3dm.Chunk chunk2 = IRhino3dmImporter.readNestedChunk(chunk);
        if (chunk2.header != 536903824) {
            return null;
        }
        IRhino3dm.RhinoObject rhinoObject = this.readObject(IRhino3dmImporter.readNestedChunk(chunk2));
        if (rhinoObject instanceof IRhino3dm.Bitmap) {
            return (IRhino3dm.Bitmap)rhinoObject;
        }
        IOut.err("got an instance of wrong class : " + rhinoObject);
        return null;
    }

    public void readTextureMappingTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readTextureMappingTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.TextureMapping> arrayList = new ArrayList<IRhino3dm.TextureMapping>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.TextureMapping textureMapping = this.readTextureMapping(chunk2);
            if (textureMapping == null) continue;
            arrayList.add(textureMapping);
        }
        if (arrayList.size() > 0) {
            this.file.textureMappings = arrayList.toArray(new IRhino3dm.TextureMapping[arrayList.size()]);
        }
    }

    public IRhino3dm.TextureMapping readTextureMapping(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readTextureMapping");
        IRhino3dm.Chunk chunk2 = IRhino3dmImporter.readNestedChunk(chunk);
        return null;
    }

    public void readMaterialTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readMaterialTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.Material> arrayList = new ArrayList<IRhino3dm.Material>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.Material material = this.readMaterial(chunk2);
            if (material == null) continue;
            arrayList.add(material);
        }
        IOut.debug(10, arrayList.size() + " materials imported");
        if (arrayList.size() > 0) {
            this.file.materials = arrayList;
        }
    }

    public IRhino3dm.Material readMaterial(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readMaterial");
        if (this.file.version == 1) {
            IOut.err("Material of Rhino version 1 3dm file is not supported");
            return null;
        }
        if (chunk.header != 536903744) {
            IOut.err("wrong header of chunk : " + IRhino3dmImporter.hex(chunk.header));
            return null;
        }
        IRhino3dm.RhinoObject rhinoObject = this.readObject(IRhino3dmImporter.readNestedChunk(chunk));
        if (rhinoObject instanceof IRhino3dm.Material) {
            return (IRhino3dm.Material)rhinoObject;
        }
        IOut.err("wrong type of object found " + rhinoObject);
        return null;
    }

    public void readLinetypeTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readLinetypeTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.Linetype> arrayList = new ArrayList<IRhino3dm.Linetype>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.Linetype linetype = this.readLinetype(chunk2);
            if (linetype == null) continue;
            arrayList.add(linetype);
        }
        if (arrayList.size() > 0) {
            this.file.linetypes = arrayList.toArray(new IRhino3dm.Linetype[arrayList.size()]);
        }
    }

    public IRhino3dm.Linetype readLinetype(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readLinetype");
        IRhino3dm.Chunk chunk2 = IRhino3dmImporter.readNestedChunk(chunk);
        return null;
    }

    public void readLayerTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readLayerTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.Layer> arrayList = new ArrayList<IRhino3dm.Layer>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.Layer layer = this.readLayer(chunk2);
            if (layer == null) continue;
            arrayList.add(layer);
        }
        if (arrayList.size() > 0) {
            this.file.layers = arrayList.toArray(new IRhino3dm.Layer[arrayList.size()]);
        }
    }

    public IRhino3dm.Layer readLayer(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readLayer");
        if (this.file.version == 1) {
            IOut.err("version 1 rhino file is not supported");
            return null;
        }
        if (chunk.header != 536903760) {
            IOut.err("wrong type code : " + IRhino3dmImporter.hex(chunk.header));
            return null;
        }
        IRhino3dm.RhinoObject rhinoObject = this.readObject(IRhino3dmImporter.readNestedChunk(chunk));
        if (rhinoObject instanceof IRhino3dm.Layer) {
            rhinoObject.createIObject(this.file, this.server);
            return (IRhino3dm.Layer)rhinoObject;
        }
        IOut.err("readLayer: got an instance of wrong class : " + rhinoObject);
        return null;
    }

    public void readGroupTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readGroupTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.Group> arrayList = new ArrayList<IRhino3dm.Group>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.Group group = this.readGroup(chunk2);
            if (group == null) continue;
            arrayList.add(group);
        }
        if (arrayList.size() > 0) {
            this.file.groups = arrayList.toArray(new IRhino3dm.Group[arrayList.size()]);
        }
    }

    public IRhino3dm.Group readGroup(IRhino3dm.Chunk chunk) {
        return null;
    }

    public void readFontTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readFontTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.Font> arrayList = new ArrayList<IRhino3dm.Font>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.Font font = this.readFont(chunk2);
            if (font == null) continue;
            arrayList.add(font);
        }
        if (arrayList.size() > 0) {
            this.file.fonts = arrayList.toArray(new IRhino3dm.Font[arrayList.size()]);
        }
    }

    public IRhino3dm.Font readFont(IRhino3dm.Chunk chunk) {
        if (this.file.version <= 2) {
            IOut.err("version is older than 2 : " + this.file.version);
            return null;
        }
        if (this.file.openNurbsVersion < 200109180) {
            IOut.err("Open Nurbs version is older: " + this.file.openNurbsVersion);
            return null;
        }
        if (chunk.header != 536903796) {
            IOut.err("wrong header typecode: " + IRhino3dmImporter.hex(chunk.header));
            return null;
        }
        IRhino3dm.RhinoObject rhinoObject = this.readObject(IRhino3dmImporter.readNestedChunk(chunk));
        if (rhinoObject instanceof IRhino3dm.Font) {
            return (IRhino3dm.Font)rhinoObject;
        }
        IOut.err("got an instance of wrong class : " + rhinoObject);
        return null;
    }

    public void readDimStyleTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readDimStyleTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.DimStyle> arrayList = new ArrayList<IRhino3dm.DimStyle>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.DimStyle dimStyle = this.readDimStyle(chunk2);
            if (dimStyle == null) continue;
            arrayList.add(dimStyle);
        }
        if (arrayList.size() > 0) {
            this.file.dimStyles = arrayList.toArray(new IRhino3dm.DimStyle[arrayList.size()]);
        }
    }

    public IRhino3dm.DimStyle readDimStyle(IRhino3dm.Chunk chunk) {
        return null;
    }

    public void readLightTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readLightTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.Light> arrayList = new ArrayList<IRhino3dm.Light>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.Light light = this.readLight(chunk2);
            if (light == null) continue;
            arrayList.add(light);
        }
        if (arrayList.size() > 0) {
            this.file.lights = arrayList.toArray(new IRhino3dm.Light[arrayList.size()]);
        }
    }

    public IRhino3dm.Light readLight(IRhino3dm.Chunk chunk) {
        return null;
    }

    public void readHatchPatternTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readHatchPatternTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.HatchPattern> arrayList = new ArrayList<IRhino3dm.HatchPattern>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.HatchPattern hatchPattern = this.readHatchPattern(chunk2);
            if (hatchPattern == null) continue;
            arrayList.add(hatchPattern);
        }
        if (arrayList.size() > 0) {
            this.file.hatchPatterns = arrayList.toArray(new IRhino3dm.HatchPattern[arrayList.size()]);
        }
    }

    public IRhino3dm.HatchPattern readHatchPattern(IRhino3dm.Chunk chunk) {
        return null;
    }

    public void readInstanceDefinitionTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readInstanceDefinitionTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.InstanceDefinition> arrayList = new ArrayList<IRhino3dm.InstanceDefinition>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.InstanceDefinition instanceDefinition = this.readInstanceDefinition(chunk2);
            if (instanceDefinition == null) continue;
            arrayList.add(instanceDefinition);
        }
        if (arrayList.size() > 0) {
            this.file.instanceDefinitions = arrayList.toArray(new IRhino3dm.InstanceDefinition[arrayList.size()]);
        }
    }

    public IRhino3dm.InstanceDefinition readInstanceDefinition(IRhino3dm.Chunk chunk) {
        return null;
    }

    public void readObjectTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readObjectTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.RhinoObject> arrayList = new ArrayList<IRhino3dm.RhinoObject>();
        IOut.debug(10, "num of rhino objects : " + chunkArray.length);
        int n = 0;
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.RhinoObject rhinoObject;
            if (n > 0 && n % 100 == 0) {
                IOut.debug(1, ++n + "/" + chunkArray.length);
            }
            if ((rhinoObject = this.readRhinoObject(chunk2)) == null) continue;
            arrayList.add(rhinoObject);
        }
        if (arrayList.size() > 0) {
            this.file.rhinoObjects = arrayList.toArray(new IRhino3dm.RhinoObject[arrayList.size()]);
        }
    }

    public IRhino3dm.RhinoObject readRhinoObject(IRhino3dm.Chunk chunk) {
        IObject iObject;
        if (this.file.version == 1) {
            return null;
        }
        if (chunk.header != 536903792) {
            IOut.err("chunk header is not tcodeObjectRecord\n" + chunk);
            return null;
        }
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk, -2113929089);
        if (chunkArray == null) {
            IOut.err("no table item is found");
            return null;
        }
        if (chunkArray[0].header != -2113929103) {
            IOut.err("chunk header is not tcodeObjectRecordType\n" + chunkArray[0]);
            return null;
        }
        if (chunkArray.length < 2) {
            IOut.err("object data is missing");
            return null;
        }
        IRhino3dm.RhinoObject rhinoObject = this.readObject(chunkArray[1]);
        if (rhinoObject == null) {
            return null;
        }
        if (chunkArray.length >= 3) {
            for (int i = 2; i < chunkArray.length; ++i) {
                if (chunkArray[i].header == 33587314) {
                    IRhino3dm.ObjectAttributes objectAttributes = new IRhino3dm.ObjectAttributes();
                    try {
                        objectAttributes.read(this.file, chunkArray[i].content);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    rhinoObject.setAttributes(objectAttributes);
                    continue;
                }
                if (chunkArray[i].header != 33554547) continue;
                this.readObjectUserData(chunkArray[i]);
            }
        }
        if ((iObject = rhinoObject.createIObject(this.file, this.server)) != null) {
            rhinoObject.setAttributesToIObject(this.file, iObject);
            this.objects.add(iObject);
        }
        return rhinoObject;
    }

    public void readObjectUserData(IRhino3dm.Chunk chunk) {
        try {
            Object object;
            Object object2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
            IRhino3dm.Chunk chunk2 = IRhino3dmImporter.readChunk(byteArrayInputStream);
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(chunk2.content);
            int[] nArray = IRhino3dmImporter.readChunkVersion(byteArrayInputStream2);
            int n = nArray[0];
            int n2 = nArray[1];
            ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream2;
            if (n == 2) {
                object2 = IRhino3dmImporter.readChunk(byteArrayInputStream2);
                byteArrayInputStream3 = new ByteArrayInputStream(((IRhino3dm.Chunk)object2).content);
            }
            object2 = IRhino3dmImporter.readUUID(byteArrayInputStream3);
            IRhino3dm.UUID uUID = IRhino3dmImporter.readUUID(byteArrayInputStream3);
            int n3 = IRhino3dmImporter.readInt(byteArrayInputStream3);
            IRhino3dm.Xform xform = IRhino3dmImporter.readXform(byteArrayInputStream3);
            IOut.err("classID = " + object2);
            IOut.err("itemID = " + uUID);
            IOut.err("copyCount = " + n3);
            IOut.err("xform = " + xform);
            if (n == 2 && n2 >= 1) {
                object = IRhino3dmImporter.readUUID(byteArrayInputStream3);
                IOut.err("appID = " + object);
                if (n2 >= 2) {
                    boolean bl = IRhino3dmImporter.readBool(byteArrayInputStream3);
                    int n4 = IRhino3dmImporter.readInt(byteArrayInputStream3);
                    int n5 = IRhino3dmImporter.readInt(byteArrayInputStream3);
                    IOut.err("unknown data = " + bl);
                    IOut.err("3dm version = " + n4);
                    IOut.err("ON version = " + n5);
                }
            }
            object = IRhino3dmImporter.readChunk(byteArrayInputStream2);
            IOut.err("anonymousDataChunk : " + object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readHistoryRecordTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readHistoryRecordTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        ArrayList<IRhino3dm.HistoryRecord> arrayList = new ArrayList<IRhino3dm.HistoryRecord>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.HistoryRecord historyRecord = this.readHistoryRecord(chunk2);
            if (historyRecord == null) continue;
            arrayList.add(historyRecord);
        }
        if (arrayList.size() > 0) {
            this.file.historyRecords = arrayList.toArray(new IRhino3dm.HistoryRecord[arrayList.size()]);
        }
    }

    public IRhino3dm.HistoryRecord readHistoryRecord(IRhino3dm.Chunk chunk) {
        return null;
    }

    public void readUserDataTable(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readUserDataTable");
        IRhino3dm.Chunk[] chunkArray = IRhino3dmImporter.readChunkTable(chunk);
        if (chunkArray == null) {
            return;
        }
        IOut.debug(10, chunkArray.length + " chunks");
        ArrayList<IRhino3dm.UserData> arrayList = new ArrayList<IRhino3dm.UserData>();
        for (IRhino3dm.Chunk chunk2 : chunkArray) {
            IRhino3dm.UserData userData = this.readUserData(chunk2);
            if (userData == null) continue;
            arrayList.add(userData);
        }
        if (arrayList.size() > 0) {
            this.file.userData = arrayList.toArray(new IRhino3dm.UserData[arrayList.size()]);
        }
    }

    public IRhino3dm.UserData readUserData(IRhino3dm.Chunk chunk) {
        IOut.debug(20, chunk.toString());
        return null;
    }

    public void readEndMark(IRhino3dm.Chunk chunk) {
        IOut.debug(10, "Rhino3dmImporter.readEndMark");
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(chunk.content);
            if (this.file.sizeOfChunkLength() == 4) {
                int n = IRhino3dmImporter.readInt(byteArrayInputStream);
            } else {
                long l = IRhino3dmImporter.readLong(byteArrayInputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        IOut.debugLevel(-1);
        if (stringArray.length > 0) {
            IOut.p("opening " + stringArray[0]);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            IG.init();
            IRhino3dmImporter iRhino3dmImporter = new IRhino3dmImporter(fileInputStream, IG.current());
            iRhino3dmImporter.read();
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

