/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IOut;
import igeo.IVec;
import java.util.ArrayList;
import javax.media.opengl.GL2;

public abstract class IGLElement {
    public IVec[] pts;
    public IVec[] normal;
    public ArrayList<IVec> tmpPts = null;
    public ArrayList<IVec> tmpNormal = null;

    public IGLElement() {
    }

    public IGLElement(int n) {
        this.pts = new IVec[n];
    }

    public IGLElement(IVec[] iVecArray) {
        this.pts = iVecArray;
    }

    public IGLElement(IVec[] iVecArray, IVec[] iVecArray2) {
        this.pts = iVecArray;
        this.normal = iVecArray2;
    }

    public void setPoint(IVec[] iVecArray) {
        this.pts = iVecArray;
    }

    public void setNormal(IVec[] iVecArray) {
        this.normal = iVecArray;
    }

    public void setPointNum(int n) {
        this.pts = new IVec[n];
    }

    public void setNormalNum(int n) {
        this.normal = new IVec[n];
    }

    public void setPoint(int n, IVec iVec) {
        this.pts[n] = iVec;
    }

    public void setNormal(int n, IVec iVec) {
        this.normal[n] = iVec;
    }

    public int getNum() {
        return this.num();
    }

    public int num() {
        if (this.pts != null) {
            return this.pts.length;
        }
        if (this.tmpPts != null) {
            return this.tmpPts.size();
        }
        return 0;
    }

    public void addPoint(IVec iVec) {
        if (this.tmpPts == null) {
            this.tmpPts = new ArrayList();
        }
        this.tmpPts.add(iVec);
    }

    public void addPoint(IVec iVec, IVec iVec2) {
        if (this.tmpPts == null) {
            this.tmpPts = new ArrayList();
            this.tmpNormal = new ArrayList();
        }
        this.tmpPts.add(iVec);
        this.tmpNormal.add(iVec2);
    }

    public void finalizePoint() {
        int n;
        if (this.tmpPts == null) {
            IOut.err("tmpPts == null");
            return;
        }
        this.pts = new IVec[this.tmpPts.size()];
        for (n = 0; n < this.tmpPts.size(); ++n) {
            this.pts[n] = this.tmpPts.get(n);
        }
        this.tmpPts = null;
        if (this.tmpNormal != null) {
            if (this.tmpNormal.size() != this.pts.length) {
                IOut.err("number of normals doesn't match with number of points");
                return;
            }
            this.normal = new IVec[this.tmpNormal.size()];
            for (n = 0; n < this.tmpNormal.size(); ++n) {
                this.normal[n] = this.tmpNormal.get(n);
            }
            this.tmpNormal = null;
        } else {
            this.normal = null;
        }
    }

    public void drawPoints(GL2 gL2) {
        if (this.normal != null) {
            for (int i = 0; i < this.pts.length; ++i) {
                gL2.glNormal3d(this.normal[i].x, this.normal[i].y, this.normal[i].z);
                gL2.glVertex3d(this.pts[i].x, this.pts[i].y, this.pts[i].z);
            }
        } else {
            for (int i = 0; i < this.pts.length; ++i) {
                gL2.glVertex3d(this.pts[i].x, this.pts[i].y, this.pts[i].z);
            }
        }
    }

    public abstract void draw(GL2 var1);
}

