/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IOut;
import igeo.IVec;
import java.util.ArrayList;

public class IDelaunay {
    public static double maxDistToCheck = -1.0;

    public static IVec[][] getTetrahedron(IVec[] iVecArray) {
        if (iVecArray.length <= 4) {
            return new IVec[][]{iVecArray};
        }
        ArrayList<IVec[]> arrayList = new ArrayList<IVec[]>();
        for (int i = 0; i < iVecArray.length - 3; ++i) {
            IOut.debug(40, i + 1 + "/" + (iVecArray.length - 3));
            for (int j = i + 1; j < iVecArray.length - 2; ++j) {
                if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[j]) <= maxDistToCheck))) continue;
                for (int k = j + 1; k < iVecArray.length - 1; ++k) {
                    if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[k]) <= maxDistToCheck))) continue;
                    for (int i2 = k + 1; i2 < iVecArray.length; ++i2) {
                        if (!(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[i2]) <= maxDistToCheck))) continue;
                        boolean bl = false;
                        for (int i3 = 0; i3 < iVecArray.length && !bl; ++i3) {
                            if (i3 == i || i3 == j || i3 == k || i3 == i2 || !(maxDistToCheck < 0.0) && (!(maxDistToCheck >= 0.0) || !(iVecArray[i].dist(iVecArray[i3]) <= maxDistToCheck)) || !IDelaunay.isInsideCircumsphere(iVecArray[i3], iVecArray[i], iVecArray[j], iVecArray[k], iVecArray[i2])) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        arrayList.add(new IVec[]{iVecArray[i], iVecArray[j], iVecArray[k], iVecArray[i2]});
                    }
                }
            }
        }
        return (IVec[][])arrayList.toArray((T[])new IVec[arrayList.size()][]);
    }

    public static IVec circumsphereCenter(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4) {
        IVec iVec5 = iVec2.dif(iVec);
        IVec iVec6 = iVec3.dif(iVec);
        IVec iVec7 = iVec4.dif(iVec);
        IVec iVec8 = iVec2.mid(iVec);
        IVec iVec9 = iVec3.mid(iVec);
        IVec iVec10 = iVec4.mid(iVec);
        IVec[] iVecArray = IVec.intersectPlane(iVec5, iVec8, iVec6, iVec9);
        if (iVecArray == null) {
            IOut.err("plane intersection failed: most likely two edges are parallel");
            return null;
        }
        if (iVec7.dot(iVecArray[0]) == 0.0) {
            IOut.err("plane line intersection failed: most likely fourth point is on a plane of 3 poitns");
            return null;
        }
        return IVec.intersectPlaneAndLine(iVec7, iVec10, iVecArray[0], iVecArray[1]);
    }

    public static boolean isInsideCircumsphere(IVec iVec, IVec iVec2, IVec iVec3, IVec iVec4, IVec iVec5) {
        IVec iVec6 = IDelaunay.circumsphereCenter(iVec2, iVec3, iVec4, iVec5);
        if (iVec6 == null) {
            return true;
        }
        return iVec6.dist(iVec) < iVec6.dist(iVec2);
    }
}

