/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IConfig;
import igeo.IFieldGeo;
import igeo.IObject;
import igeo.IVec;
import igeo.IVecI;

public class IPlaneFieldGeo
extends IFieldGeo
implements I3DFieldI {
    public IVecI pos;
    public IVecI nml;

    public IPlaneFieldGeo(IVecI iVecI, IVecI iVecI2) {
        this.pos = iVecI;
        this.nml = iVecI2;
    }

    public IVecI getForce(IVecI iVecI) {
        return this.nml.dup();
    }

    public IVecI getForce(IVecI iVecI, IVecI iVecI2) {
        return this.getForce(iVecI);
    }

    @Override
    public IVecI get(IVecI iVecI) {
        return this.get(iVecI, null);
    }

    @Override
    public IVecI get(IVecI iVecI, IVecI iVecI2) {
        double d = this.intensity;
        if (this.pos != null) {
            double d2;
            if (this.decay == IFieldGeo.Decay.Linear) {
                d2 = iVecI.get().distToPlane(this.nml, this.pos);
                if (d2 >= this.threshold) {
                    return new IVec();
                }
                if (this.threshold > 0.0) {
                    d *= (this.threshold - d2) / this.threshold;
                }
            } else if (this.decay == IFieldGeo.Decay.Gaussian) {
                d2 = iVecI.get().distToPlane(this.nml, this.pos);
                if (this.threshold > 0.0) {
                    d *= Math.exp(-2.0 * d2 * d2 / (this.threshold * this.threshold));
                }
            }
        }
        IVecI iVecI3 = this.getForce(iVecI, iVecI2);
        if (this.bidirectional && iVecI3.get().dot(iVecI2) < 0.0) {
            d = -d;
        }
        if (this.constantIntensity) {
            double d3 = iVecI3.len();
            if (d3 < IConfig.tolerance) {
                return iVecI3.zero();
            }
            return iVecI3.len(d);
        }
        return iVecI3.mul(d);
    }

    public IVec pos() {
        return this.pos.get();
    }

    public IVec nml() {
        return this.nml.get();
    }

    @Override
    public IPlaneFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    @Override
    public IPlaneFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    @Override
    public IPlaneFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    @Override
    public IPlaneFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    @Override
    public IPlaneFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    @Override
    public IPlaneFieldGeo gauss(double d) {
        super.gauss(d);
        return this;
    }

    @Override
    public IPlaneFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    @Override
    public IPlaneFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    @Override
    public void del() {
        if (this.pos != null && this.pos instanceof IObject) {
            ((IObject)((Object)this.pos)).del();
        }
        if (this.nml != null && this.nml instanceof IObject) {
            ((IObject)((Object)this.nml)).del();
        }
    }
}

