/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.ICurve;
import igeo.IG;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IServerI;
import igeo.IUnit;
import igeo.IVec;
import igeo.IVecI;
import igeo.io.IEsri;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class IShapeFileImporter {
    static Constraint constraint = null;

    public static byte[] copy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i + n];
        }
        return byArray2;
    }

    public static boolean checkBufLen(byte[] byArray, int n, int n2) {
        if (byArray.length - n < n2) {
            IG.err("too short buffer (buf.len=" + byArray.length + ", idx=" + n + ", len=" + n2);
            return false;
        }
        return true;
    }

    public static int readIntBE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            return -1;
        }
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }

    public static int readShortBE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n2 < 0) {
            return -1;
        }
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }

    public static int readIntBE(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 4)) {
            IG.err();
            return 0;
        }
        return byArray[n] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] & 0xFF;
    }

    public static int readIntLE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            return -1;
        }
        return (n4 & 0xFF) << 24 | (n3 & 0xFF) << 16 | (n2 & 0xFF) << 8 | n & 0xFF;
    }

    public static int readShortLE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n2 < 0) {
            return -1;
        }
        return (n2 & 0xFF) << 8 | n & 0xFF;
    }

    public static int readIntLE(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 4)) {
            IG.err();
            return 0;
        }
        return byArray[n + 3] << 24 & 0xFF000000 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
    }

    public static double readDoubleLE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        int n6 = inputStream.read();
        int n7 = inputStream.read();
        int n8 = inputStream.read();
        if (n8 < 0) {
            return 0.0;
        }
        long l = (long)(n8 & 0xFF) << 56 | (long)(n7 & 0xFF) << 48 | (long)(n6 & 0xFF) << 40 | (long)(n5 & 0xFF) << 32 | (long)(n4 & 0xFF) << 24 | (long)(n3 & 0xFF) << 16 | (long)(n2 & 0xFF) << 8 | (long)(n & 0xFF);
        return Double.longBitsToDouble(l);
    }

    public static double readDoubleLE(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 8)) {
            IG.err();
            return 0.0;
        }
        long l = (long)(byArray[n + 7] & 0xFF) << 56 | (long)(byArray[n + 6] & 0xFF) << 48 | (long)(byArray[n + 5] & 0xFF) << 40 | (long)(byArray[n + 4] & 0xFF) << 32 | (long)(byArray[n + 3] & 0xFF) << 24 | (long)(byArray[n + 2] & 0xFF) << 16 | (long)(byArray[n + 1] & 0xFF) << 8 | (long)(byArray[n] & 0xFF);
        return Double.longBitsToDouble(l);
    }

    public static void readSHPHeader(InputStream inputStream) {
        byte[] byArray = new byte[100];
        try {
            inputStream.read(byArray, 0, 100);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = IShapeFileImporter.readIntBE(byArray, 0);
        int n2 = IShapeFileImporter.readIntBE(byArray, 24);
        int n3 = IShapeFileImporter.readIntLE(byArray, 28);
        int n4 = IShapeFileImporter.readIntLE(byArray, 32);
    }

    public static boolean readSHPRecord(InputStream inputStream, boolean bl, ArrayList<IObject[]> arrayList) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = IShapeFileImporter.readIntBE(inputStream);
            if (n < 0) {
                return false;
            }
            n2 = IShapeFileImporter.readIntBE(inputStream);
            if ((n2 *= 2) < 0) {
                IG.err("contentLength is negative " + n2);
                return false;
            }
            if (bl) {
                IShapeFileImporter.skip(inputStream, n2);
                return true;
            }
            n3 = IShapeFileImporter.readIntLE(inputStream);
            n2 -= 4;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n4 = 0;
        switch (n3) {
            case 0: {
                IOut.debug(30, "reading Null Shape");
                break;
            }
            case 1: {
                IOut.debug(30, "reading Point Shape");
                n4 = IShapeFileImporter.makePoint(inputStream, n, arrayList);
                break;
            }
            case 8: {
                IOut.debug(30, "reading MultiPoint Shape");
                n4 = IShapeFileImporter.makeMultiPoint(inputStream, n, arrayList);
                break;
            }
            case 3: {
                IOut.debug(30, "reading Polyline Shape");
                n4 = IShapeFileImporter.makePolyline(inputStream, n, arrayList);
                break;
            }
            case 5: {
                IOut.debug(30, "reading Polygon Shape");
                n4 = IShapeFileImporter.makePolyline(inputStream, n, arrayList);
                break;
            }
            case 21: {
                IOut.debug(30, "reading PointM Shape");
                n4 = IShapeFileImporter.makePoint(inputStream, n, arrayList);
                break;
            }
            case 28: {
                IOut.debug(30, "reading MultiPointM Shape");
                n4 = IShapeFileImporter.makeMultiPoint(inputStream, n, arrayList);
                break;
            }
            case 23: {
                IOut.debug(30, "reading PolylineM Shape");
                n4 = IShapeFileImporter.makePolyline(inputStream, n, arrayList);
                break;
            }
            case 25: {
                IOut.debug(30, "reading PolygonM Shape");
                n4 = IShapeFileImporter.makePolyline(inputStream, n, arrayList);
                break;
            }
            case 11: {
                IOut.debug(30, "reading PointZ Shape");
                n4 = IShapeFileImporter.makePointZ(inputStream, n, arrayList);
                break;
            }
            case 18: {
                IOut.debug(30, "reading MultiPointZ Shape");
                n4 = IShapeFileImporter.makeMultiPointZ(inputStream, n, arrayList);
                break;
            }
            case 13: {
                IOut.debug(30, "reading PolylineZ Shape");
                n4 = IShapeFileImporter.makePolylineZ(inputStream, n, arrayList);
                break;
            }
            case 15: {
                IOut.debug(30, "reading PolygonZ Shape");
                n4 = IShapeFileImporter.makePolylineZ(inputStream, n, arrayList);
                break;
            }
            case 31: {
                IOut.debug(30, "reading MultiPatch Shape");
                n4 = IShapeFileImporter.makeMultiPatch(inputStream, n, arrayList);
                break;
            }
            default: {
                IG.err("unknown shape type " + n3);
            }
        }
        if ((n2 -= n4) > 0) {
            try {
                IShapeFileImporter.skip(inputStream, n2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (n2 < 0) {
            IG.err("over read the stream");
        }
        return true;
    }

    public static void skip(InputStream inputStream, long l) throws IOException {
        inputStream.skip(l);
    }

    public static IVec readPoint(InputStream inputStream) throws IOException {
        double d = IShapeFileImporter.readDoubleLE(inputStream);
        double d2 = IShapeFileImporter.readDoubleLE(inputStream);
        return new IVec(d, d2, 0.0);
    }

    public static IVec readPoint(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 16)) {
            IG.err();
            return new IVec();
        }
        double d = IShapeFileImporter.readDoubleLE(byArray, n);
        double d2 = IShapeFileImporter.readDoubleLE(byArray, n + 8);
        return new IVec(d, d2, 0.0);
    }

    public static IVec readPointZ(InputStream inputStream) throws IOException {
        double d = IShapeFileImporter.readDoubleLE(inputStream);
        double d2 = IShapeFileImporter.readDoubleLE(inputStream);
        double d3 = IShapeFileImporter.readDoubleLE(inputStream);
        double d4 = IShapeFileImporter.readDoubleLE(inputStream);
        return new IVec(d, d2, d3);
    }

    public static IVec readPointZ(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 24)) {
            IG.err();
            return new IVec();
        }
        double d = IShapeFileImporter.readDoubleLE(byArray, n);
        double d2 = IShapeFileImporter.readDoubleLE(byArray, n + 8);
        double d3 = IShapeFileImporter.readDoubleLE(byArray, n + 16);
        return new IVec(d, d2, d3);
    }

    public static IVec[] readPoints(InputStream inputStream, int n) throws IOException {
        IVec[] iVecArray = new IVec[n];
        for (int i = 0; i < n; ++i) {
            iVecArray[i] = IShapeFileImporter.readPoint(inputStream);
        }
        return iVecArray;
    }

    public static IVec[] readPoints(byte[] byArray, int n, int n2) {
        if (!IShapeFileImporter.checkBufLen(byArray, n2, 16 * n)) {
            IG.err();
            return null;
        }
        IVec[] iVecArray = new IVec[n];
        for (int i = 0; i < n; ++i) {
            iVecArray[i] = IShapeFileImporter.readPoint(byArray, n2 + 16 * i);
        }
        return iVecArray;
    }

    public static int[] readIntegers(byte[] byArray, int n, int n2) {
        if (!IShapeFileImporter.checkBufLen(byArray, n2, 4 * n)) {
            IG.err();
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = IShapeFileImporter.readIntLE(byArray, n2 + 4 * i);
        }
        return nArray;
    }

    public static int[] readIntegers(InputStream inputStream, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = IShapeFileImporter.readIntLE(inputStream);
        }
        return nArray;
    }

    public static double[] readDoubles(InputStream inputStream, int n) throws IOException {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = IShapeFileImporter.readDoubleLE(inputStream);
        }
        return dArray;
    }

    public static double[] readDoubles(byte[] byArray, int n, int n2) {
        if (!IShapeFileImporter.checkBufLen(byArray, n2, 8 * n)) {
            IG.err();
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = IShapeFileImporter.readDoubleLE(byArray, n2 + 8 * i);
        }
        return dArray;
    }

    public static void makePoint(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, 0, 20)) {
            IG.err();
            return;
        }
        IVec iVec = IShapeFileImporter.readPoint(byArray, 4);
        IPoint iPoint = new IPoint(iVec);
        iPoint.name(String.valueOf(n));
    }

    public static int makePoint(InputStream inputStream, int n, ArrayList<IObject[]> arrayList) {
        int n2 = 0;
        try {
            IVec iVec = IShapeFileImporter.readPoint(inputStream);
            n2 += 16;
            IPoint iPoint = new IPoint(iVec);
            iPoint.name(String.valueOf(n));
            arrayList.add(new IObject[]{iPoint});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static void makePointZ(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, 0, 36)) {
            IG.err();
            return;
        }
        IVec iVec = IShapeFileImporter.readPointZ(byArray, 4);
        IPoint iPoint = new IPoint(iVec);
        iPoint.name(String.valueOf(n));
    }

    public static int makePointZ(InputStream inputStream, int n, ArrayList<IObject[]> arrayList) {
        int n2 = 0;
        try {
            IVec iVec = IShapeFileImporter.readPointZ(inputStream);
            n2 += 24;
            IPoint iPoint = new IPoint(iVec);
            iPoint.name(String.valueOf(n));
            arrayList.add(new IObject[]{iPoint});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static void makeMultiPoint(byte[] byArray, int n) {
        int n2 = IShapeFileImporter.readIntLE(byArray, 36);
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, n2, 40);
        if (iVecArray == null) {
            IG.err();
            return;
        }
        for (int i = 0; i < n2; ++i) {
            if (iVecArray[i] == null) continue;
            IPoint iPoint = new IPoint(iVecArray[i]);
            iPoint.name(String.valueOf(n));
        }
    }

    public static int makeMultiPoint(InputStream inputStream, int n, ArrayList<IObject[]> arrayList) {
        int n2 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n2 += 32;
            int n3 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, n3);
            n2 += 16 * n3;
            if (iVecArray == null) {
                IG.err();
                return n2;
            }
            ArrayList<IPoint> arrayList2 = new ArrayList<IPoint>();
            for (int i = 0; i < n3; ++i) {
                if (iVecArray[i] == null) continue;
                IPoint iPoint = new IPoint(iVecArray[i]);
                iPoint.name(String.valueOf(n));
                arrayList2.add(iPoint);
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static void makeMultiPointZ(byte[] byArray, int n) {
        int n2 = IShapeFileImporter.readIntLE(byArray, 36);
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, n2, 40);
        if (iVecArray == null) {
            IG.err();
            return;
        }
        double[] dArray = IShapeFileImporter.readDoubles(byArray, n2, 40 + n2 * 16);
        if (dArray == null) {
            IG.err();
            return;
        }
        for (int i = 0; i < n2; ++i) {
            if (iVecArray[i] == null) continue;
            iVecArray[i].z = dArray[i];
            IPoint iPoint = new IPoint(iVecArray[i]);
            iPoint.name(String.valueOf(n));
        }
    }

    public static int makeMultiPointZ(InputStream inputStream, int n, ArrayList<IObject[]> arrayList) {
        int n2 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n2 += 32;
            int n3 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, n3);
            n2 += n3 * 16;
            if (iVecArray == null) {
                IG.err();
                return n2;
            }
            IShapeFileImporter.skip(inputStream, 16L);
            n2 += 16;
            double[] dArray = IShapeFileImporter.readDoubles(inputStream, n3);
            n2 += 8 * n3;
            if (dArray == null) {
                IG.err();
                return n2;
            }
            ArrayList<IPoint> arrayList2 = new ArrayList<IPoint>();
            for (int i = 0; i < n3; ++i) {
                if (iVecArray[i] == null || constraint != null && (constraint == null || !constraint.validate(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z))) continue;
                iVecArray[i].z = dArray[i];
                IPoint iPoint = new IPoint(iVecArray[i]);
                iPoint.name(String.valueOf(n));
                arrayList2.add(iPoint);
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static void makePolyline(byte[] byArray, int n) {
        int n2 = IShapeFileImporter.readIntLE(byArray, 36);
        int n3 = IShapeFileImporter.readIntLE(byArray, 40);
        int[] nArray = IShapeFileImporter.readIntegers(byArray, n2, 44);
        if (nArray == null) {
            IG.err();
            return;
        }
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, n3, 44 + 4 * n2);
        if (iVecArray == null) {
            IG.err();
            return;
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            n4 = nArray[i] < n2 - 1 ? nArray[i + 1] - nArray[i] : n3 - nArray[i];
            if (n4 <= 0 || n4 + nArray[i] >= n3) continue;
            IVecI[] iVecIArray = new IVec[n4];
            for (int j = 0; j < n4; ++j) {
                iVecIArray[j] = iVecArray[nArray[i] + j];
            }
            ICurve iCurve = new ICurve(iVecIArray);
            iCurve.name(String.valueOf(n));
        }
    }

    public static int makePolyline(InputStream inputStream, int n, ArrayList<IObject[]> arrayList) {
        int n2 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n2 += 32;
            int n3 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            int n4 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            int[] nArray = IShapeFileImporter.readIntegers(inputStream, n3);
            n2 += n3 * 4;
            if (nArray == null) {
                IG.err();
                return n2;
            }
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, n4);
            n2 += n4 * 16;
            if (iVecArray == null) {
                IG.err();
                return n2;
            }
            ArrayList<ICurve> arrayList2 = new ArrayList<ICurve>();
            for (int i = 0; i < n3; ++i) {
                int n5 = 0;
                n5 = i < n3 - 1 ? nArray[i + 1] - nArray[i] : n4 - nArray[i];
                if (n5 <= 0 || n5 + nArray[i] > n4) continue;
                IVecI[] iVecIArray = new IVec[n5];
                for (int j = 0; j < n5; ++j) {
                    iVecIArray[j] = iVecArray[nArray[i] + j];
                }
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
                arrayList2.add(iCurve);
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static void makePolylineZ(byte[] byArray, int n) {
        int n2;
        int n3 = IShapeFileImporter.readIntLE(byArray, 36);
        int n4 = IShapeFileImporter.readIntLE(byArray, 40);
        int[] nArray = IShapeFileImporter.readIntegers(byArray, n3, 44);
        if (nArray == null) {
            IG.err();
            return;
        }
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, n4, 44 + 4 * n3);
        if (iVecArray == null) {
            IG.err();
            return;
        }
        double[] dArray = IShapeFileImporter.readDoubles(byArray, n4, 44 + 4 * n3 + 16 * n4 + 16);
        if (dArray == null) {
            IG.err();
            return;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (iVecArray[n2] == null) continue;
            iVecArray[n2].z = dArray[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = 0;
            n5 = nArray[n2] < n3 - 1 ? nArray[n2 + 1] - nArray[n2] : n4 - nArray[n2];
            if (n5 <= 0 || n5 + nArray[n2] >= n4) continue;
            IVecI[] iVecIArray = new IVec[n5];
            for (int i = 0; i < n5; ++i) {
                iVecIArray[i] = iVecArray[nArray[n2] + i];
            }
            ICurve iCurve = new ICurve(iVecIArray);
            iCurve.name(String.valueOf(n));
        }
    }

    public static int makePolylineZ(InputStream inputStream, int n, ArrayList<IObject[]> arrayList) {
        int n2 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n2 += 32;
            int n3 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            int n4 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            int[] nArray = IShapeFileImporter.readIntegers(inputStream, n3);
            n2 += 4 * n3;
            if (nArray == null) {
                IG.err();
                return n2;
            }
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, n4);
            n2 += 16 * n4;
            if (iVecArray == null) {
                IG.err();
                return n2;
            }
            IShapeFileImporter.skip(inputStream, 16L);
            n2 += 16;
            double[] dArray = IShapeFileImporter.readDoubles(inputStream, n4);
            n2 += n4 * 8;
            if (dArray == null) {
                IG.err();
                return n2;
            }
            for (int i = 0; i < n4; ++i) {
                if (iVecArray[i] == null) continue;
                iVecArray[i].z = dArray[i];
            }
            ArrayList<ICurve> arrayList2 = new ArrayList<ICurve>();
            for (int i = 0; i < n3; ++i) {
                int n5 = 0;
                n5 = i < n3 - 1 ? nArray[i + 1] - nArray[i] : n4 - nArray[i];
                if (n5 <= 0 || n5 + nArray[i] > n4) continue;
                IVecI[] iVecIArray = new IVec[n5];
                for (int j = 0; j < n5; ++j) {
                    iVecIArray[j] = iVecArray[nArray[i] + j];
                }
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
                arrayList2.add(iCurve);
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static void makeMultiPatch(byte[] byArray, int n) {
        int n2;
        int n3 = IShapeFileImporter.readIntLE(byArray, 36);
        int n4 = IShapeFileImporter.readIntLE(byArray, 40);
        int[] nArray = IShapeFileImporter.readIntegers(byArray, n3, 44);
        if (nArray == null) {
            IG.err();
            return;
        }
        int[] nArray2 = IShapeFileImporter.readIntegers(byArray, n3, 44 + n3 * 4);
        if (nArray2 == null) {
            IG.err();
            return;
        }
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, n4, 44 + 4 * n3 + 4 * n3);
        if (iVecArray == null) {
            IG.err();
            return;
        }
        double[] dArray = IShapeFileImporter.readDoubles(byArray, n4, 44 + 4 * n3 + 4 * n3 + 16 * n4 + 16);
        if (dArray == null) {
            IG.err();
            return;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (iVecArray[n2] == null) continue;
            iVecArray[n2].z = dArray[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = 0;
            n5 = n2 < n3 - 1 ? nArray[n2 + 1] - nArray[n2] : n4 - nArray[n2];
            if (n5 <= 0 || n5 + nArray[n2] > n4) continue;
            IVecI[] iVecIArray = new IVec[n5];
            for (int i = 0; i < n5; ++i) {
                iVecIArray[i] = iVecArray[nArray[n2] + i];
            }
            if (nArray2[n2] == 0) {
                int n6;
                IVecI[] iVecIArray2 = new IVec[n5 + 1];
                int n7 = 0;
                iVecIArray2[n7] = iVecIArray[0];
                ++n7;
                for (n6 = 1; n6 < n5; n6 += 2) {
                    iVecIArray2[n7] = iVecIArray[n6];
                    ++n7;
                }
                for (n6 = n5 % 2 == 0 ? n5 - 2 : n5 - 1; n6 > 0; n6 -= 2) {
                    iVecIArray2[n7] = iVecIArray[n6];
                }
                iVecIArray2[n5] = iVecIArray[0];
                ICurve iCurve = new ICurve(iVecIArray2);
                iCurve.name(String.valueOf(n));
                continue;
            }
            if (nArray2[n2] == 1) {
                IVecI[] iVecIArray3 = new IVec[n5 + 1];
                for (int i = 0; i < n5; ++i) {
                    iVecIArray3[i] = iVecIArray[i];
                }
                iVecIArray3[n5] = iVecIArray[0];
                ICurve iCurve = new ICurve(iVecIArray3);
                iCurve.name(String.valueOf(n));
                continue;
            }
            if (nArray2[n2] == 2) {
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
                continue;
            }
            if (nArray2[n2] == 3) {
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
                continue;
            }
            if (nArray2[n2] == 4) {
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
                continue;
            }
            if (nArray2[n2] == 5) {
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
                continue;
            }
            IG.err("unknown part type " + nArray2[n2]);
        }
    }

    public static int makeMultiPatch(InputStream inputStream, int n, ArrayList<IObject[]> arrayList) {
        int n2 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n2 += 32;
            int n3 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            int n4 = IShapeFileImporter.readIntLE(inputStream);
            n2 += 4;
            int[] nArray = IShapeFileImporter.readIntegers(inputStream, n3);
            n2 += n3 * 4;
            if (nArray == null) {
                IG.err();
                return n2;
            }
            int[] nArray2 = IShapeFileImporter.readIntegers(inputStream, n3);
            n2 += n3 * 4;
            if (nArray2 == null) {
                IG.err();
                return n2;
            }
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, n4);
            n2 += n4 * 16;
            if (iVecArray == null) {
                IG.err();
                return n2;
            }
            IShapeFileImporter.skip(inputStream, 16L);
            n2 += 16;
            double[] dArray = IShapeFileImporter.readDoubles(inputStream, n4);
            n2 += n4 * 8;
            if (dArray == null) {
                IG.err();
                return n2;
            }
            for (int i = 0; i < n4; ++i) {
                if (iVecArray[i] == null) continue;
                iVecArray[i].z = dArray[i];
            }
            ArrayList<ICurve> arrayList2 = new ArrayList<ICurve>();
            for (int i = 0; i < n3; ++i) {
                int n5 = 0;
                n5 = nArray[i] < n3 - 1 ? nArray[i + 1] - nArray[i] : n4 - nArray[i];
                if (n5 <= 0 || n5 + nArray[i] >= n4) continue;
                IVecI[] iVecIArray = new IVec[n5];
                for (int j = 0; j < n5; ++j) {
                    iVecIArray[j] = iVecArray[nArray[i] + j];
                }
                if (nArray2[i] == 0) {
                    int n6;
                    IVecI[] iVecIArray2 = new IVec[n5 + 1];
                    int n7 = 0;
                    iVecIArray2[n7] = iVecIArray[0];
                    ++n7;
                    for (n6 = 1; n6 < n5; n6 += 2) {
                        iVecIArray2[n7] = iVecIArray[n6];
                        ++n7;
                    }
                    for (n6 = n5 % 2 == 0 ? n5 - 2 : n5 - 1; n6 > 0; n6 -= 2) {
                        iVecIArray2[n7] = iVecIArray[n6];
                    }
                    iVecIArray2[n5] = iVecIArray[0];
                    ICurve iCurve = new ICurve(iVecIArray2);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                    continue;
                }
                if (nArray2[i] == 1) {
                    IVecI[] iVecIArray3 = new IVec[n5 + 1];
                    for (int j = 0; j < n5; ++j) {
                        iVecIArray3[j] = iVecIArray[j];
                    }
                    iVecIArray3[n5] = iVecIArray[0];
                    ICurve iCurve = new ICurve(iVecIArray3);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                    continue;
                }
                if (nArray2[i] == 2) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                    continue;
                }
                if (nArray2[i] == 3) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                    continue;
                }
                if (nArray2[i] == 4) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                    continue;
                }
                if (nArray2[i] == 5) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                    continue;
                }
                IG.err("unknown part type " + nArray2[i]);
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    public static String getFilePrefix(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    public static String getFileNameWithExtension(String string, String string2) {
        return IShapeFileImporter.getFilePrefix(string) + "." + string2;
    }

    public static File getFileWithExtension(File file, String string) {
        String string2 = IShapeFileImporter.getFilePrefix(file.getName());
        return new File(file.getParentFile(), string2 + "." + string);
    }

    public static ArrayList<IObject> read(File file, IServerI iServerI) {
        IObject iObject;
        int n;
        int n2;
        Object object;
        if (!file.exists()) {
            IOut.err("the input file doesn't exist : " + file.getPath());
            return null;
        }
        if (iServerI != null) {
            iServerI.server().unit(IUnit.Meter);
        } else {
            IG.unit(IUnit.Meter);
        }
        String string = IShapeFileImporter.getFilePrefix(file.getName());
        File file2 = new File(file.getParentFile(), string + ".dbf");
        File file3 = new File(file.getParentFile(), string + ".DBF");
        File file4 = new File(file.getParentFile(), string + ".Dbf");
        File file5 = null;
        if (file2.exists()) {
            file5 = file2;
        } else if (file3.exists()) {
            file5 = file3;
        } else if (file4.exists()) {
            file5 = file4;
        } else {
            IG.err("DBF file does not exist : " + file2.getAbsolutePath());
        }
        ArrayList<IObject[]> arrayList = null;
        try {
            arrayList = IShapeFileImporter.readSHP(new FileInputStream(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (file5 != null) {
            object = IShapeFileImporter.readDBF(file5, iServerI);
            if (((IEsri.Attributes[])object).length != arrayList.size()) {
                IG.err("Shape count (" + arrayList.size() + ") and DBF count (" + ((IEsri.Attributes[])object).length + ") does not match");
            }
            for (n2 = 0; n2 < ((IEsri.Attributes[])object).length && n2 < arrayList.size(); ++n2) {
                for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                    iObject = arrayList.get(n2)[n];
                    if (iObject == null) continue;
                    iObject.userData(new Object[]{object[n2]});
                }
            }
        }
        object = new ArrayList();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                iObject = arrayList.get(n2)[n];
                if (iObject == null) continue;
                ((ArrayList)object).add(iObject);
            }
        }
        return object;
    }

    public static ArrayList<IObject> read(InputStream inputStream, InputStream inputStream2, IServerI iServerI) {
        IObject iObject;
        int n;
        int n2;
        Object object;
        if (inputStream == null) {
            IG.err("no SHP file stream found");
        }
        ArrayList<IObject[]> arrayList = null;
        arrayList = IShapeFileImporter.readSHP(inputStream, iServerI);
        if (iServerI != null) {
            iServerI.server().unit(IUnit.Meter);
        } else {
            IG.unit(IUnit.Meter);
        }
        if (inputStream2 != null) {
            object = IShapeFileImporter.readDBF(inputStream2, iServerI);
            if (((IEsri.Attributes[])object).length != arrayList.size()) {
                IG.err("Shape count (" + arrayList.size() + ") and DBF count (" + ((IEsri.Attributes[])object).length + ") does not match");
            }
            for (n2 = 0; n2 < ((IEsri.Attributes[])object).length && n2 < arrayList.size(); ++n2) {
                for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                    iObject = arrayList.get(n2)[n];
                    if (iObject == null) continue;
                    iObject.userData(new Object[]{object[n2]});
                }
            }
        }
        object = new ArrayList();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                iObject = arrayList.get(n2)[n];
                if (iObject == null) continue;
                ((ArrayList)object).add(iObject);
            }
        }
        return object;
    }

    public static ArrayList<IObject> read(String string, IServerI iServerI) {
        return IShapeFileImporter.read(new File(string), iServerI);
    }

    public static ArrayList<IObject[]> readSHP(File file, IServerI iServerI) {
        try {
            return IShapeFileImporter.readSHP(new FileInputStream(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<IObject[]> readSHP(String string, IServerI iServerI) {
        try {
            return IShapeFileImporter.readSHP(new FileInputStream(string), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<IObject[]> readSHP(InputStream inputStream, IServerI iServerI) {
        ArrayList<IObject[]> arrayList = new ArrayList<IObject[]>();
        IShapeFileImporter.readSHPHeader(inputStream);
        boolean bl = false;
        int n = 0;
        do {
            if (n % 100 == 0 && n > 0) {
                IOut.debug(20, n);
            }
            bl = IShapeFileImporter.readSHPRecord(inputStream, false, arrayList);
            ++n;
        } while (bl);
        IOut.debug(20, "SHP import complete");
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            IShapeFileImporter.readSHP(fileInputStream, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static IEsri.Attributes[] readDBF(File file, IServerI iServerI) {
        try {
            return IShapeFileImporter.readDBF(new FileInputStream(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static IEsri.Attributes[] readDBF(String string, IServerI iServerI) {
        try {
            return IShapeFileImporter.readDBF(new FileInputStream(string), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static IEsri.Attributes[] readDBF(InputStream inputStream, IServerI iServerI) {
        IEsri.AttributeHeader attributeHeader = IShapeFileImporter.readDBFHeader(inputStream);
        int n = attributeHeader.recordNum;
        int n2 = attributeHeader.recordLen;
        IEsri.Attributes[] attributesArray = new IEsri.Attributes[n];
        for (int i = 0; i < n; ++i) {
            attributesArray[i] = IShapeFileImporter.readDBFRecord(inputStream, attributeHeader);
            if (i % 100 != 0 || i <= 0) continue;
            IOut.debug(20, i + "/" + n);
        }
        IOut.debug(20, "DBF import complete");
        return attributesArray;
    }

    public static String stringWithoutSpace(byte[] byArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 32; ++n2) {
        }
        for (n = byArray.length - 1; n > n2 && byArray[n] == 32; --n) {
        }
        if (n2 > n) {
            return new String();
        }
        byte[] byArray2 = new byte[n - n2 + 1];
        for (int i = 0; i < n - n2 + 1; ++i) {
            byArray2[i] = byArray[i + n2];
        }
        return new String(byArray2);
    }

    public static IEsri.Attributes readDBFRecord(InputStream inputStream, IEsri.AttributeHeader attributeHeader) {
        IEsri.Attributes attributes = new IEsri.Attributes(attributeHeader.fieldNum);
        attributes.fields = attributeHeader.fields;
        try {
            int n = inputStream.read();
            for (int i = 0; i < attributeHeader.fieldNum; ++i) {
                int n2 = attributeHeader.fields[i].length;
                byte[] byArray = new byte[n2];
                inputStream.read(byArray, 0, n2);
                attributes.text[i] = IShapeFileImporter.stringWithoutSpace(byArray);
                if (attributeHeader.fields[i].type == 'N' || attributeHeader.fields[i].type == 'F') {
                    try {
                        attributes.number[i] = Double.parseDouble(attributes.text[i]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    continue;
                }
                if (attributeHeader.fields[i].type != 'L') continue;
                attributes.number[i] = attributes.text[i].equals("Y") || attributes.text[i].equals("y") || attributes.text[i].equals("T") || attributes.text[i].equals("t") ? 1.0 : 0.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return attributes;
    }

    public static IEsri.AttributeHeader readDBFHeader(InputStream inputStream) {
        IEsri.AttributeHeader attributeHeader = new IEsri.AttributeHeader();
        try {
            int n;
            int n2;
            inputStream.skip(4L);
            attributeHeader.recordNum = IShapeFileImporter.readIntLE(inputStream);
            attributeHeader.firstDataPos = IShapeFileImporter.readShortLE(inputStream);
            attributeHeader.recordLen = IShapeFileImporter.readShortLE(inputStream);
            inputStream.skip(20L);
            attributeHeader.fieldNum = n2 = (attributeHeader.firstDataPos - 32 - 1) / 32;
            attributeHeader.fields = new IEsri.AttributeField[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                String string;
                int n4;
                int n5;
                int n6;
                char c;
                attributeHeader.fields[n] = new IEsri.AttributeField();
                byte[] byArray = new byte[10];
                inputStream.read(byArray, 0, 10);
                inputStream.skip(1L);
                attributeHeader.fields[n].type = c = (char)inputStream.read();
                inputStream.skip(4L);
                attributeHeader.fields[n].length = n6 = inputStream.read();
                n3 += n6;
                attributeHeader.fields[n].fractionLength = n5 = inputStream.read();
                inputStream.skip(2L);
                attributeHeader.fields[n].workspaceID = n4 = inputStream.read();
                inputStream.skip(11L);
                attributeHeader.fields[n].name = string = new String(byArray);
            }
            n = inputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return attributeHeader;
    }

    public static class GridConstraint
    extends Constraint {
        @Override
        public boolean validate(double d, double d2, double d3) {
            double d4 = 501002.66259577964;
            double d5 = 4793122.462032901;
            double d6 = 4.99785186;
            int n = (int)(Math.abs(d - d4) / d6 + 0.5);
            int n2 = (int)(Math.abs(d2 - d5) / d6 + 0.5);
            int n3 = 10;
            return n % n3 == 0 && n2 % n3 == 0;
        }
    }

    public static class Constraint {
        public boolean validate(double d, double d2, double d3) {
            return true;
        }
    }
}

