/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBool;
import igeo.IBoolOp;
import igeo.IBoolR;
import igeo.IDoubleI;
import igeo.IDoubleOp;
import igeo.IInteger;
import igeo.IIntegerI;
import igeo.IIntegerOp;
import igeo.IParameterObject;
import igeo.IReferenceParameter;
import igeo.IServerI;
import igeo.ISwitchE;
import igeo.ISwitchR;

public class IIntegerR
extends IParameterObject
implements IIntegerI,
IReferenceParameter {
    protected IIntegerOp op;

    public IIntegerR(IIntegerOp iIntegerOp) {
        this.op = iIntegerOp;
    }

    public IIntegerR(int n) {
        this.op = new IInteger(n);
    }

    public IIntegerR(IServerI iServerI, IIntegerOp iIntegerOp) {
        super(iServerI);
        this.op = iIntegerOp;
    }

    public IIntegerR(IServerI iServerI, int n) {
        super(iServerI);
        this.op = new IInteger(n);
    }

    @Override
    public int x() {
        return this.op.x();
    }

    @Override
    public IInteger get() {
        return this.op.get();
    }

    @Override
    public IIntegerR getX() {
        return this;
    }

    @Override
    public IIntegerOp operator() {
        return this.op;
    }

    @Override
    public IIntegerR dup() {
        return new IIntegerR(this.op);
    }

    @Override
    public IIntegerR cp() {
        return this.dup();
    }

    @Override
    public IIntegerR cp(int n) {
        return this.dup().add(n);
    }

    @Override
    public IIntegerR cp(IIntegerI iIntegerI) {
        return this.dup().add(iIntegerI);
    }

    @Override
    public IIntegerR set(IIntegerI iIntegerI) {
        this.op = iIntegerI;
        return this;
    }

    @Override
    public IIntegerR set(int n) {
        this.op = new IInteger(n);
        return this;
    }

    @Override
    public IIntegerR set(IDoubleI iDoubleI) {
        this.op = new FromDouble(iDoubleI);
        return this;
    }

    @Override
    public IIntegerR set(double d) {
        this.op = new IInteger((int)d);
        return this;
    }

    @Override
    public IIntegerR add(IIntegerI iIntegerI) {
        this.op = new Add(this.op, iIntegerI);
        return this;
    }

    @Override
    public IIntegerR add(int n) {
        this.op = new Add(this.op, new IInteger(n));
        return this;
    }

    @Override
    public IIntegerR sub(IIntegerI iIntegerI) {
        this.op = new Sub(this.op, iIntegerI);
        return this;
    }

    @Override
    public IIntegerR sub(int n) {
        this.op = new Sub(this.op, new IInteger(n));
        return this;
    }

    @Override
    public IIntegerR mul(IIntegerI iIntegerI) {
        this.op = new Mul(this.op, iIntegerI);
        return this;
    }

    @Override
    public IIntegerR mul(int n) {
        this.op = new Mul(this.op, new IInteger(n));
        return this;
    }

    @Override
    public IIntegerR div(IIntegerI iIntegerI) {
        this.op = new Div(this.op, iIntegerI);
        return this;
    }

    @Override
    public IIntegerR div(int n) {
        this.op = new Div(this.op, new IInteger(n));
        return this;
    }

    @Override
    public IIntegerR neg() {
        this.op = new Neg(this.op);
        return this;
    }

    @Override
    public IIntegerR mod(IIntegerI iIntegerI) {
        this.op = new Mod(this.op, iIntegerI);
        return this;
    }

    @Override
    public IIntegerR mod(int n) {
        this.op = new Mod(this.op, new IInteger(n));
        return this;
    }

    @Override
    public boolean eq(int n) {
        return this.op.get().eq(n);
    }

    @Override
    public boolean eq(IIntegerI iIntegerI) {
        return this.op.get().eq(iIntegerI.get());
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IIntegerI iIntegerI) {
        return this.eq(iIntegerI);
    }

    @Override
    public IBoolR eq(ISwitchR iSwitchR, IIntegerI iIntegerI) {
        return new IBoolR(new Eq(this.op, iIntegerI));
    }

    public static class Eq
    extends IParameterObject
    implements IBoolOp {
        public IIntegerOp v1;
        public IIntegerOp v2;

        public Eq(IIntegerOp iIntegerOp, IIntegerOp iIntegerOp2) {
            this.v1 = iIntegerOp;
            this.v2 = iIntegerOp2;
        }

        @Override
        public boolean x() {
            return this.v1.get().eq(this.v2.get());
        }

        @Override
        public IBool get() {
            return this.v1.get().eq((ISwitchR)null, (IIntegerI)this.v2.get());
        }
    }

    public static class FromDouble
    extends IParameterObject
    implements IIntegerOp {
        public IDoubleOp v;

        public FromDouble(IDoubleOp iDoubleOp) {
            this.v = iDoubleOp;
        }

        @Override
        public int x() {
            return (int)this.v.x();
        }

        @Override
        public IInteger get() {
            return new IInteger(this.v.x());
        }
    }

    public static class Mod
    extends IParameterObject
    implements IIntegerOp {
        public IIntegerOp v1;
        public IIntegerOp v2;

        public Mod(IIntegerOp iIntegerOp, IIntegerOp iIntegerOp2) {
            this.v1 = iIntegerOp;
            this.v2 = iIntegerOp2;
        }

        @Override
        public int x() {
            return this.v1.x() % this.v2.x();
        }

        @Override
        public IInteger get() {
            return this.v1.get().mod(this.v2.get());
        }
    }

    public static class Neg
    extends IParameterObject
    implements IIntegerOp {
        public IIntegerOp v;

        public Neg(IIntegerOp iIntegerOp) {
            this.v = iIntegerOp;
        }

        @Override
        public int x() {
            return -this.v.x();
        }

        @Override
        public IInteger get() {
            return this.v.get().neg();
        }
    }

    public static class Div
    extends IParameterObject
    implements IIntegerOp {
        public IIntegerOp v1;
        public IIntegerOp v2;

        public Div(IIntegerOp iIntegerOp, IIntegerOp iIntegerOp2) {
            this.v1 = iIntegerOp;
            this.v2 = iIntegerOp2;
        }

        @Override
        public int x() {
            return this.v1.x() / this.v2.x();
        }

        @Override
        public IInteger get() {
            return this.v1.get().div(this.v2.get());
        }
    }

    public static class Mul
    extends IParameterObject
    implements IIntegerOp {
        public IIntegerOp v1;
        public IIntegerOp v2;

        public Mul(IIntegerOp iIntegerOp, IIntegerOp iIntegerOp2) {
            this.v1 = iIntegerOp;
            this.v2 = iIntegerOp2;
        }

        @Override
        public int x() {
            return this.v1.x() * this.v2.x();
        }

        @Override
        public IInteger get() {
            return this.v1.get().mul(this.v2.get());
        }
    }

    public static class Sub
    extends IParameterObject
    implements IIntegerOp {
        public IIntegerOp v1;
        public IIntegerOp v2;

        public Sub(IIntegerOp iIntegerOp, IIntegerOp iIntegerOp2) {
            this.v1 = iIntegerOp;
            this.v2 = iIntegerOp2;
        }

        @Override
        public int x() {
            return this.v1.x() - this.v2.x();
        }

        @Override
        public IInteger get() {
            return this.v1.get().sub(this.v2.get());
        }
    }

    public static class Add
    extends IParameterObject
    implements IIntegerOp {
        public IIntegerOp v1;
        public IIntegerOp v2;

        public Add(IIntegerOp iIntegerOp, IIntegerOp iIntegerOp2) {
            this.v1 = iIntegerOp;
            this.v2 = iIntegerOp2;
        }

        @Override
        public int x() {
            return this.v1.x() + this.v2.x();
        }

        @Override
        public IInteger get() {
            return this.v1.get().add(this.v2.get());
        }
    }
}

