/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IConfig;
import igeo.IFieldGeo;
import igeo.IVec;
import igeo.IVecI;

public class IPointCloudFieldGeo
extends IFieldGeo
implements I3DFieldI {
    public IVecI[] points;
    public IVecI[] forceDirs;

    public IPointCloudFieldGeo(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        this.points = iVecIArray;
        this.forceDirs = iVecIArray2;
    }

    @Override
    public IVecI get(IVecI iVecI) {
        return this.get(iVecI, null);
    }

    @Override
    public IVecI get(IVecI iVecI, IVecI iVecI2) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.points.length; ++i) {
            double d2 = this.points[i].get().dist(iVecI);
            if (i != 0 && !(d2 < d)) continue;
            d = d2;
            n = i;
        }
        double d3 = this.intensity;
        if (this.decay == IFieldGeo.Decay.Linear) {
            if (d >= this.threshold) {
                return new IVec();
            }
            if (this.threshold > 0.0) {
                d3 *= (this.threshold - d) / this.threshold;
            }
        } else if (this.decay == IFieldGeo.Decay.Gaussian && this.threshold > 0.0) {
            d3 *= Math.exp(-2.0 * d * d / (this.threshold * this.threshold));
        }
        IVecI iVecI3 = this.forceDirs[n];
        if (this.bidirectional && iVecI3.get().dot(iVecI2) < 0.0) {
            d3 = -d3;
        }
        if (this.constantIntensity) {
            double d4 = iVecI3.len();
            if (d4 < IConfig.tolerance) {
                return iVecI3.zero();
            }
            return iVecI3.len(d3);
        }
        return iVecI3.mul(d3);
    }

    @Override
    public IPointCloudFieldGeo constantIntensity(boolean bl) {
        super.constantIntensity(bl);
        return this;
    }

    @Override
    public IPointCloudFieldGeo bidirectional(boolean bl) {
        super.bidirectional(bl);
        return this;
    }

    @Override
    public IPointCloudFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    @Override
    public IPointCloudFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    @Override
    public IPointCloudFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    @Override
    public IPointCloudFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    @Override
    public IPointCloudFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    @Override
    public IPointCloudFieldGeo gauss(double d) {
        super.gauss(d);
        return this;
    }

    @Override
    public IPointCloudFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    @Override
    public IPointCloudFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    @Override
    public void del() {
    }
}

