/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDynamics;
import igeo.IDynamicsBase;
import igeo.IObject;
import igeo.IParticleGeo;
import igeo.IParticleI;
import igeo.ISpringI;
import igeo.IVec;
import igeo.IVecI;
import java.util.ArrayList;

public class ISpring
extends IDynamicsBase
implements ISpringI {
    public IParticleI pt1;
    public IParticleI pt2;
    public double tension = 1.0;
    public boolean constantTension = false;
    public double maxTension = -1.0;
    public double length;

    public ISpring(IParticleI iParticleI, IParticleI iParticleI2, double d, double d2, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.tension = d;
        this.len(d2);
    }

    public ISpring(IVecI iVecI, IVecI iVecI2, double d, double d2, IObject iObject) {
        super(iObject);
        this.pt1 = new IParticleGeo(iVecI.get());
        this.pt2 = new IParticleGeo(iVecI2.get());
        this.tension = d;
        this.len(d2);
    }

    public ISpring(IParticleI iParticleI, IParticleI iParticleI2, double d, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.tension = d;
        this.len(iParticleI, iParticleI2);
    }

    public ISpring(IVecI iVecI, IVecI iVecI2, double d, IObject iObject) {
        super(iObject);
        this.pt1 = new IParticleGeo(iVecI.get());
        this.pt2 = new IParticleGeo(iVecI2.get());
        this.tension = d;
        this.len(iVecI, iVecI2);
    }

    public ISpring(IParticleI iParticleI, IParticleI iParticleI2, IObject iObject) {
        super(iObject);
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.len(iParticleI, iParticleI2);
    }

    public ISpring(IVecI iVecI, IVecI iVecI2, IObject iObject) {
        super(iObject);
        this.pt1 = new IParticleGeo(iVecI.get());
        this.pt2 = new IParticleGeo(iVecI2.get());
        this.len(iVecI, iVecI2);
    }

    public ISpring(IParticleI iParticleI, IParticleI iParticleI2, double d, double d2) {
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.tension = d;
        this.length = d2;
    }

    public ISpring(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        this.pt1 = new IParticleGeo(iVecI.get());
        this.pt2 = new IParticleGeo(iVecI2.get());
        this.tension = d;
        this.length = d2;
    }

    public ISpring(IParticleI iParticleI, IParticleI iParticleI2, double d) {
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.tension = d;
        this.len(iParticleI, iParticleI2);
    }

    public ISpring(IVecI iVecI, IVecI iVecI2, double d) {
        this.pt1 = new IParticleGeo(iVecI.get());
        this.pt2 = new IParticleGeo(iVecI2.get());
        this.tension = d;
        this.len(iVecI, iVecI2);
    }

    public ISpring(IParticleI iParticleI, IParticleI iParticleI2) {
        this.pt1 = iParticleI;
        this.pt2 = iParticleI2;
        this.len(iParticleI, iParticleI2);
    }

    public ISpring(IVecI iVecI, IVecI iVecI2) {
        this.pt1 = new IParticleGeo(iVecI.get());
        this.pt2 = new IParticleGeo(iVecI2.get());
        this.len(iVecI, iVecI2);
    }

    @Override
    public double tension() {
        return this.tension;
    }

    @Override
    public ISpring tension(double d) {
        this.tension = d;
        return this;
    }

    @Override
    public boolean constant() {
        return this.constantTension;
    }

    @Override
    public ISpring constant(boolean bl) {
        this.constantTension = bl;
        return this;
    }

    @Override
    public double maxTension() {
        return this.maxTension;
    }

    @Override
    public ISpring maxTension(double d) {
        this.maxTension = d;
        return this;
    }

    @Override
    public double len() {
        return this.length;
    }

    @Override
    public ISpring len(double d) {
        this.length = d;
        return this;
    }

    @Override
    public ISpring len(IVecI iVecI, IVecI iVecI2) {
        this.length = iVecI.dist(iVecI2);
        return this;
    }

    @Override
    public double length() {
        return this.len();
    }

    @Override
    public ISpring length(double d) {
        return this.len(d);
    }

    @Override
    public ISpring length(IVecI iVecI, IVecI iVecI2) {
        return this.len(iVecI, iVecI2);
    }

    @Override
    public IParticleI pt(int n) {
        if (n == 1) {
            return this.pt2;
        }
        return this.pt1;
    }

    @Override
    public IParticleI particle(int n) {
        return this.pt(n);
    }

    @Override
    public IVec pos(int n) {
        return this.pt(n).pos();
    }

    @Override
    public IParticleI pt1() {
        return this.pt1;
    }

    @Override
    public IParticleI particle1() {
        return this.pt1();
    }

    @Override
    public IVec pos1() {
        return this.pt1().pos();
    }

    @Override
    public IParticleI pt2() {
        return this.pt2;
    }

    @Override
    public IParticleI particle2() {
        return this.pt2();
    }

    @Override
    public IVec pos2() {
        return this.pt2().pos();
    }

    @Override
    public ISpring parent(IObject iObject) {
        super.parent(iObject);
        return this;
    }

    @Override
    public ISpring target(IObject iObject) {
        super.target(iObject);
        return this;
    }

    @Override
    public ISpring removeTarget(int n) {
        super.removeTarget(n);
        return this;
    }

    @Override
    public ISpring removeTarget(IObject iObject) {
        super.removeTarget(iObject);
        return this;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        IVec iVec = this.pt2.pos().dif(this.pt1.pos());
        double d = iVec.len();
        if (this.constantTension) {
            if (d > this.length) {
                iVec.len(this.tension);
            } else {
                iVec.len(-this.tension);
            }
            this.pt1.push(iVec);
            this.pt2.pull(iVec);
        } else if (d > 0.0) {
            iVec.mul(this.tension * (d - this.length) / d);
            if (this.maxTension >= 0.0 && iVec.len() > this.maxTension) {
                iVec.len(this.maxTension);
            }
            this.pt1.push(iVec);
            this.pt2.pull(iVec);
        }
    }
}

