/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IColor;
import igeo.IConfig;
import igeo.IEdge;
import igeo.IFace;
import igeo.IG;
import igeo.IGraphicObject;
import igeo.IMesh;
import igeo.IMeshI;
import igeo.IMeshR;
import igeo.IObject;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphics3D;

public class IMeshGraphicGL
extends IGraphicObject {
    public static float weight = IConfig.strokeWeight;
    public IMeshI mesh;
    public IVec[][] facePts;
    public IVec[][] faceNormal;
    public IVec[][] edgePts;
    public IColor[][] vertexColor;
    public IMesh meshObj = null;

    public IMeshGraphicGL(IMesh iMesh) {
        super(iMesh);
    }

    public IMeshGraphicGL(IMeshR iMeshR) {
        super(iMeshR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMesh() {
        IObject iObject = this.parent;
        synchronized (iObject) {
            Object object;
            int n;
            if (this.parent instanceof IMesh) {
                this.mesh = ((IMesh)this.parent).mesh;
                this.meshObj = (IMesh)this.parent;
            } else if (this.parent instanceof IMeshR) {
                this.mesh = ((IMeshR)this.parent).mesh;
            }
            this.facePts = new IVec[this.mesh.faceNum()][];
            this.faceNormal = new IVec[this.mesh.faceNum()][];
            if (this.meshObj != null && this.meshObj.enableVertexColor) {
                this.vertexColor = new IColor[this.mesh.faceNum()][];
            }
            for (n = 0; n < this.mesh.faceNum(); ++n) {
                object = this.mesh.face(n);
                this.facePts[n] = new IVec[((IFace)object).vertexNum()];
                this.faceNormal[n] = new IVec[((IFace)object).vertexNum()];
                if (this.meshObj != null && this.meshObj.enableVertexColor) {
                    this.vertexColor[n] = new IColor[((IFace)object).vertexNum()];
                }
                for (int i = 0; i < ((IFace)object).vertexNum(); ++i) {
                    this.facePts[n][i] = ((IFace)object).getVertex(i).get();
                    this.faceNormal[n][i] = ((IFace)object).getVertex(i).normal().get();
                    if (this.meshObj == null || !this.meshObj.enableVertexColor) continue;
                    this.vertexColor[n][i] = ((IFace)object).getVertex(i).clr();
                    IG.p(this.vertexColor[n][i]);
                    if (this.vertexColor[n][i] != null) continue;
                    this.vertexColor[n][i] = this.color;
                    if (this.vertexColor[n][i] != null) continue;
                    this.vertexColor[n][i] = IConfig.objectColor;
                }
            }
            this.edgePts = new IVec[this.mesh.edgeNum()][];
            for (n = 0; n < this.mesh.edgeNum(); ++n) {
                object = this.mesh.edge(n);
                this.edgePts[n] = new IVec[2];
                this.edgePts[n][0] = ((IEdge)object).getVertex(0).get();
                this.edgePts[n][1] = ((IEdge)object).getVertex(1).get();
            }
        }
    }

    @Override
    public void setWeight(float f) {
        weight = f;
    }

    @Override
    public float getWeight() {
        return weight;
    }

    @Override
    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGraphic3D();
    }

    @Override
    public void draw(IGraphics iGraphics) {
        if (this.mesh == null) {
            this.initMesh();
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL || iGraphics.type() == IGraphicMode.GraphicType.P3D) {
            int n;
            IGraphics3D iGraphics3D = (IGraphics3D)iGraphics;
            float[] fArray = null;
            fArray = this.color != null ? this.color.rgba() : IConfig.objectColor.rgba();
            if (iGraphics3D.view().mode().isTransparent()) {
                fArray = new float[]{fArray[0], fArray[1], fArray[2], (float)IConfig.transparentModeAlpha / 255.0f};
            }
            if (iGraphics3D.view().mode().isLight()) {
                iGraphics3D.ambient(fArray);
                iGraphics3D.diffuse(fArray);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.clr(fArray[0] * 255.0f, fArray[1] * 255.0f, fArray[2] * 255.0f, 0.0f);
            }
            iGraphics3D.clr(fArray);
            if (iGraphics3D.view().mode().isFill()) {
                n = 0;
                for (int i = 0; i < this.facePts.length; ++i) {
                    if (this.meshObj != null && this.meshObj.enableFaceColor) {
                        IColor iColor = this.mesh.face(i).clr();
                        if (iColor == null) {
                            iColor = this.color;
                        }
                        if (iColor == null) {
                            iColor = IConfig.objectColor;
                        }
                        float[] fArray2 = null;
                        fArray2 = iGraphics3D.view().mode().isTransparent() ? iColor.rgba((float)IConfig.transparentModeAlpha / 255.0f) : iColor.rgba;
                        iGraphics3D.clr(fArray2);
                        if (this.facePts[i].length == 3) {
                            iGraphics3D.drawTriangles(this.facePts[i], this.faceNormal[i]);
                            continue;
                        }
                        if (this.facePts[i].length == 4) {
                            iGraphics3D.drawQuads(this.facePts[i], this.faceNormal[i]);
                            continue;
                        }
                        iGraphics3D.drawPolygon(this.facePts[i], this.faceNormal[i]);
                        continue;
                    }
                    if (this.meshObj != null && this.meshObj.enableVertexColor) {
                        for (int j = 0; j < this.mesh.face(i).vertexNum(); ++j) {
                            this.vertexColor[i][j] = this.mesh.face(i).getVertex(j).clr();
                            if (this.vertexColor[i][j] != null) continue;
                            this.vertexColor[i][j] = this.color;
                            if (this.vertexColor[i][j] != null) continue;
                            this.vertexColor[i][j] = IConfig.objectColor;
                        }
                        float f = -1.0f;
                        if (iGraphics3D.view().mode().isTransparent()) {
                            f = (float)IConfig.transparentModeAlpha / 255.0f;
                        }
                        if (this.facePts[i].length == 3) {
                            iGraphics3D.drawTriangles(this.facePts[i], this.faceNormal[i], this.vertexColor[i], f, iGraphics3D.view().mode().isLight());
                            continue;
                        }
                        if (this.facePts[i].length == 4) {
                            iGraphics3D.drawQuads(this.facePts[i], this.faceNormal[i], this.vertexColor[i], f, iGraphics3D.view().mode().isLight());
                            continue;
                        }
                        iGraphics3D.drawPolygon(this.facePts[i], this.faceNormal[i], this.vertexColor[i], f, iGraphics3D.view().mode().isLight());
                        continue;
                    }
                    if (this.facePts[i].length == 3) {
                        iGraphics3D.drawTriangles(this.facePts[i], this.faceNormal[i]);
                        continue;
                    }
                    if (this.facePts[i].length == 4) {
                        iGraphics3D.drawQuads(this.facePts[i], this.faceNormal[i]);
                        continue;
                    }
                    iGraphics3D.drawPolygon(this.facePts[i], this.faceNormal[i]);
                }
            }
            if (iGraphics3D.view().mode().isTransparent() && iGraphics3D.view().mode().isTransparentWireframe()) {
                fArray = new float[]{fArray[0], fArray[1], fArray[2], (float)IConfig.transparentModeAlpha / 255.0f};
            } else if (this.color != null) {
                fArray[3] = this.color.a();
            } else {
                fArray = new float[]{fArray[0], fArray[1], fArray[2], IConfig.objectColor.a()};
            }
            if (iGraphics.view().mode().isLight() && iGraphics.view().mode().isLightWireframe()) {
                iGraphics3D.ambient(fArray);
                iGraphics3D.diffuse(fArray);
                iGraphics3D.shininess(IConfig.shininess);
                iGraphics3D.stroke(fArray[0] * 255.0f, fArray[1] * 255.0f, fArray[2] * 255.0f, 0.0f);
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.disableLight();
            }
            if (iGraphics3D.view().mode().isWireframe()) {
                iGraphics3D.weight(weight);
                iGraphics3D.stroke(fArray);
                for (n = 0; n < this.edgePts.length; ++n) {
                    iGraphics3D.drawLines(this.edgePts[n]);
                }
            }
            if (iGraphics3D.view().mode().isLight() && !iGraphics3D.view().mode().isLightWireframe()) {
                iGraphics3D.enableLight();
            }
        }
    }
}

