/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IColor;
import igeo.IConfig;
import igeo.IGraphicI;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphicsGL;
import igeo.gui.IView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.media.opengl.GL;

public class IGraphicsGL1
implements IGraphicsGL {
    public static float[] defaultGLLightPosition = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public static float[] defaultGLAmbientLight = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    public static float[] defaultGLDiffuseLight = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
    public static float[] defaultGLSpecularLight = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static boolean defaultGLTwoSidedLighting = false;
    public GL gl;
    public Graphics2D g;
    public IView view;
    public double[][][] bgColor = new double[2][2][3];
    public boolean firstDraw = true;

    @Override
    public IView view() {
        return this.view;
    }

    @Override
    public void setGL(GL gL) {
        this.gl = gL;
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    @Override
    public GL getGL() {
        return this.gl;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    @Override
    public IGraphicMode.GraphicType type() {
        return IGraphicMode.GraphicType.GL;
    }

    public void drawBG(GL gL, IView iView) {
        if (this.view.bgColor != null) {
            for (int i = 0; i < this.bgColor.length; ++i) {
                for (int j = 0; j < this.bgColor[i].length; ++j) {
                    this.bgColor[i][j][0] = (double)this.view.bgColor[i][j].getRed() / 255.0;
                    this.bgColor[i][j][1] = (double)this.view.bgColor[i][j].getGreen() / 255.0;
                    this.bgColor[i][j][2] = (double)this.view.bgColor[i][j].getBlue() / 255.0;
                }
            }
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            gL.glBegin(7);
            gL.glColor3dv(this.bgColor[0][1], 0);
            gL.glVertex3d(-1.0, -1.0, 0.0);
            gL.glColor3dv(this.bgColor[1][1], 0);
            gL.glVertex3d(1.0, -1.0, 0.0);
            gL.glColor3dv(this.bgColor[1][0], 0);
            gL.glVertex3d(1.0, 1.0, 0.0);
            gL.glColor3dv(this.bgColor[0][0], 0);
            gL.glVertex3d(-1.0, 1.0, 0.0);
            gL.glEnd();
            gL.glMatrixMode(5888);
            gL.glPopMatrix();
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
        }
    }

    @Override
    public void setBGImage(String string) {
    }

    public void drawView(IView iView) {
        this.gl.glViewport(iView.screenX, iView.screenY, iView.screenWidth, iView.screenHeight);
        if (IConfig.clearBG || this.firstDraw) {
            this.gl.glDisable(2929);
            this.drawBG(this.gl, iView);
        }
        if (IConfig.depthSort) {
            this.gl.glEnable(2929);
        }
        if (iView.mode.isLight()) {
            this.gl.glMatrixMode(5888);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            this.gl.glLightfv(16385, 4611, defaultGLLightPosition, 0);
            this.gl.glLightfv(16385, 4608, defaultGLAmbientLight, 0);
            this.gl.glLightfv(16385, 4609, defaultGLDiffuseLight, 0);
            this.gl.glLightfv(16385, 4610, defaultGLSpecularLight, 0);
            if (defaultGLTwoSidedLighting) {
                this.gl.glLightModeli(2898, 1);
            }
            this.gl.glEnable(16385);
            this.gl.glEnable(2896);
            this.gl.glPopMatrix();
        }
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        if (iView.axonometric) {
            double d = (double)iView.screenWidth * iView.axonRatio;
            double d2 = (double)iView.screenHeight * iView.axonRatio;
            this.gl.glOrtho(-d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0, iView.near, iView.far);
        } else {
            double d = iView.near * iView.persRatio * 2.0;
            double d3 = d * (double)iView.screenWidth / (double)iView.screenHeight;
            this.gl.glFrustum(-d3 / 2.0, d3 / 2.0, -d / 2.0, d / 2.0, iView.near, iView.far);
        }
        this.gl.glMatrixMode(5888);
        this.gl.glLoadMatrixd(iView.transformArray, 0);
    }

    @Override
    public void draw(ArrayList<IGraphicI> arrayList, IView iView) {
        this.view = iView;
        if (this.view.hide) {
            return;
        }
        this.drawView(this.view);
        if (arrayList != null) {
            if (IConfig.drawOrderForward) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).isVisible()) continue;
                    arrayList.get(i).draw(this);
                }
            } else {
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    if (!arrayList.get(i).isVisible()) continue;
                    arrayList.get(i).draw(this);
                }
            }
        }
        if (this.view.mode().isLight()) {
            this.gl.glDisable(2896);
            this.gl.glDisable(16385);
        }
        if (this.g != null && this.view.pane != null && this.view.pane.getBorderWidth() > 0.0f && (this.view.pane.getPanel().getWidth() != this.view.pane.getWidth() || this.view.pane.getPanel().getHeight() != this.view.pane.getHeight())) {
            this.g.setColor(new Color(this.view.pane.getBorderColor(), true));
            this.g.setStroke(new BasicStroke(this.view.pane.getBorderWidth()));
            this.g.drawRect((int)this.view.pane.getX(), (int)this.view.pane.getY(), this.view.pane.getWidth(), this.view.pane.getHeight());
        }
    }

    @Override
    public boolean firstDraw() {
        return this.firstDraw;
    }

    @Override
    public void firstDraw(boolean bl) {
        this.firstDraw = bl;
    }

    @Override
    public void clr(IColor iColor) {
        this.gl.glColor4fv(iColor.rgba(), 0);
    }

    @Override
    public void clr(float[] fArray) {
        this.gl.glColor4fv(fArray, 0);
    }

    @Override
    public void clr(float f, float f2, float f3, float f4) {
        this.gl.glColor4f(f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f);
    }

    @Override
    public void clr(float f, float f2, float f3) {
        this.clr(f, f2, f3, 255.0f);
    }

    public void clr(IColor iColor, float f) {
        this.gl.glColor4f(iColor.r(), iColor.g(), iColor.b(), f);
    }

    @Override
    public void stroke(IColor iColor) {
        this.clr(iColor);
    }

    @Override
    public void stroke(float[] fArray) {
        this.clr(fArray);
    }

    @Override
    public void stroke(float f, float f2, float f3, float f4) {
        this.clr(f, f2, f3, f4);
    }

    @Override
    public void stroke(float f, float f2, float f3) {
        this.clr(f, f2, f3);
    }

    public void weight(double d) {
        this.gl.glLineWidth((float)d);
    }

    @Override
    public void weight(float f) {
        this.gl.glLineWidth(f);
    }

    @Override
    public void diffuse(float[] fArray) {
        this.gl.glMaterialfv(1032, 4609, fArray, 0);
    }

    @Override
    public void diffuse(float f, float f2, float f3, float f4) {
        this.diffuse(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void diffuse(float f, float f2, float f3) {
        this.diffuse(f, f2, f3, 255.0f);
    }

    @Override
    public void diffuse(IColor iColor) {
        this.diffuse(iColor.rgba());
    }

    @Override
    public void diffuse(IColor iColor, float f) {
        this.diffuse(new float[]{iColor.r(), iColor.g(), iColor.b(), f});
    }

    @Override
    public void ambient(float[] fArray) {
        this.gl.glMaterialfv(1032, 4608, fArray, 0);
    }

    @Override
    public void ambient(float f, float f2, float f3, float f4) {
        this.ambient(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void ambient(float f, float f2, float f3) {
        this.ambient(f, f2, f3, 255.0f);
    }

    @Override
    public void ambient(IColor iColor) {
        this.ambient(iColor.rgba());
    }

    @Override
    public void ambient(IColor iColor, float f) {
        this.ambient(new float[]{iColor.r(), iColor.g(), iColor.b(), f});
    }

    @Override
    public void specular(float[] fArray) {
        this.gl.glMaterialfv(1032, 4610, fArray, 0);
    }

    @Override
    public void specular(float f, float f2, float f3, float f4) {
        this.specular(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void specular(float f, float f2, float f3) {
        this.specular(f, f2, f3, 255.0f);
    }

    @Override
    public void specular(IColor iColor) {
        this.specular(iColor.rgba());
    }

    @Override
    public void specular(IColor iColor, float f) {
        this.specular(new float[]{iColor.r(), iColor.g(), iColor.b(), f});
    }

    @Override
    public void emissive(float[] fArray) {
        this.gl.glMaterialfv(1032, 5632, fArray, 0);
    }

    @Override
    public void emissive(float f, float f2, float f3, float f4) {
        this.emissive(new float[]{f / 255.0f, f2 / 255.0f, f3 / 255.0f, f4 / 255.0f});
    }

    @Override
    public void emissive(float f, float f2, float f3) {
        this.emissive(f, f2, f3, 255.0f);
    }

    @Override
    public void emissive(IColor iColor) {
        this.emissive(iColor.rgba());
    }

    @Override
    public void emissive(IColor iColor, float f) {
        this.emissive(new float[]{iColor.r(), iColor.b(), iColor.g(), f});
    }

    @Override
    public void shininess(float f) {
        this.gl.glMaterialf(1032, 5633, f);
    }

    @Override
    public void enableLight() {
        this.gl.glEnable(16385);
        this.gl.glEnable(2896);
    }

    @Override
    public void disableLight() {
        this.gl.glDisable(2896);
        this.gl.glDisable(16385);
    }

    @Override
    public void pointSize(float f) {
        this.gl.glPointSize(f);
    }

    @Override
    public void drawPoint(IVec iVec) {
        this.gl.glBegin(0);
        this.gl.glVertex3d(iVec.x, iVec.y, iVec.z);
        this.gl.glEnd();
    }

    @Override
    public void drawPoints(IVec[] iVecArray) {
        this.gl.glBegin(0);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawLines(IVec[] iVecArray) {
        this.gl.glBegin(1);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawLineStrip(IVec[] iVecArray) {
        this.gl.glBegin(3);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawLineLoop(IVec[] iVecArray) {
        this.gl.glBegin(2);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray) {
        this.gl.glBegin(9);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(9);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawPolygon(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(9);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray) {
        this.gl.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl.glBegin(7);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(7);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuads(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(7);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray) {
        this.gl.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl.glBegin(8);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(8);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuadStrip(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(8);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl.glEnd();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2) {
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            this.gl.glBegin(8);
            for (int j = 0; j < iVecArray[i].length; ++j) {
                this.gl.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                this.gl.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
            }
            this.gl.glEnd();
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IColor[][] iColorArray, float f, boolean bl) {
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j]);
                        this.diffuse(iColorArray[i][j]);
                        this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j]);
                        this.diffuse(iColorArray[i + 1][j]);
                        this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl.glEnd();
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j], f);
                        this.diffuse(iColorArray[i][j], f);
                        this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j], f);
                        this.diffuse(iColorArray[i + 1][j], f);
                        this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl.glEnd();
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j]);
                    this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j]);
                    this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl.glEnd();
            }
        } else {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j], f);
                    this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j], f);
                    this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl.glEnd();
            }
        }
    }

    @Override
    public void drawQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2, IColor[][] iColorArray, float f, boolean bl) {
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j]);
                        this.diffuse(iColorArray[i][j]);
                        this.gl.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                        this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j]);
                        this.diffuse(iColorArray[i + 1][j]);
                        this.gl.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                        this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl.glEnd();
                }
            } else {
                for (int i = 0; i < iVecArray.length - 1; ++i) {
                    this.gl.glBegin(8);
                    for (int j = 0; j < iVecArray[i].length; ++j) {
                        this.ambient(iColorArray[i][j], f);
                        this.diffuse(iColorArray[i][j], f);
                        this.gl.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                        this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                        this.ambient(iColorArray[i + 1][j], f);
                        this.diffuse(iColorArray[i + 1][j], f);
                        this.gl.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                        this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                    }
                    this.gl.glEnd();
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j]);
                    this.gl.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                    this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j]);
                    this.gl.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                    this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl.glEnd();
            }
        } else {
            for (int i = 0; i < iVecArray.length - 1; ++i) {
                this.gl.glBegin(8);
                for (int j = 0; j < iVecArray[i].length; ++j) {
                    this.clr(iColorArray[i][j], f);
                    this.gl.glNormal3d(iVecArray2[i][j].x, iVecArray2[i][j].y, iVecArray2[i][j].z);
                    this.gl.glVertex3d(iVecArray[i][j].x, iVecArray[i][j].y, iVecArray[i][j].z);
                    this.clr(iColorArray[i + 1][j], f);
                    this.gl.glNormal3d(iVecArray2[i + 1][j].x, iVecArray2[i + 1][j].y, iVecArray2[i + 1][j].z);
                    this.gl.glVertex3d(iVecArray[i + 1][j].x, iVecArray[i + 1][j].y, iVecArray[i + 1][j].z);
                }
                this.gl.glEnd();
            }
        }
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray) {
        this.gl.glBegin(4);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(4);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
            this.gl.glEnd();
        } else {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i]);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i], f);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
            this.gl.glEnd();
        }
    }

    @Override
    public void drawTriangles(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(4);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray) {
        this.gl.glBegin(5);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(5);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleStrip(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(5);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i]);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.clr(iColorArray[i], f);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.ambient(iColorArray[i]);
                this.diffuse(iColorArray[i]);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.ambient(iColorArray[i], f);
                this.diffuse(iColorArray[i], f);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2) {
        this.gl.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray) {
        this.gl.glBegin(6);
        for (int i = 0; i < iVecArray.length; ++i) {
            this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IVec[] iVecArray2, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(6);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glNormal3d(iVecArray2[i].x, iVecArray2[i].y, iVecArray2[i].z);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }

    @Override
    public void drawTriangleFan(IVec[] iVecArray, IColor[] iColorArray, float f, boolean bl) {
        this.gl.glBegin(6);
        if (bl) {
            if (f < 0.0f) {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i]);
                    this.diffuse(iColorArray[i]);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            } else {
                for (int i = 0; i < iVecArray.length; ++i) {
                    this.ambient(iColorArray[i], f);
                    this.diffuse(iColorArray[i], f);
                    this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
                }
            }
        } else if (f < 0.0f) {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i]);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        } else {
            for (int i = 0; i < iVecArray.length; ++i) {
                this.clr(iColorArray[i], f);
                this.gl.glVertex3d(iVecArray[i].x, iVecArray[i].y, iVecArray[i].z);
            }
        }
        this.gl.glEnd();
    }
}

