/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IVec;
import igeo.gui.IGLElement;
import javax.media.opengl.GL2;

public class IGLQuadMatrix
extends IGLElement {
    public int width;
    public int height;

    private IGLQuadMatrix() {
    }

    private IGLQuadMatrix(int n, int n2) {
        super(n * n2);
        this.width = n;
        this.height = n2;
    }

    private IGLQuadMatrix(IVec[][] iVecArray) {
        super(iVecArray.length * iVecArray[0].length);
        this.width = iVecArray.length;
        this.height = iVecArray[0].length;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pts[i * this.width + j] = iVecArray[j][i];
            }
        }
    }

    private IGLQuadMatrix(IVec[][] iVecArray, IVec[][] iVecArray2) {
        super(iVecArray.length * iVecArray[0].length);
        this.setNormalNum(iVecArray.length * iVecArray[0].length);
        this.width = iVecArray.length;
        this.height = iVecArray[0].length;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pts[i * this.width + j] = iVecArray[j][i];
                this.normal[i * this.width + j] = iVecArray2[j][i];
            }
        }
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void setPoint(int n, int n2, IVec iVec) {
        this.pts[n2 * this.width + n] = iVec;
    }

    public void setPoint(int n, int n2, IVec iVec, IVec iVec2) {
        this.pts[n2 * this.width + n] = iVec;
        if (this.normal == null) {
            this.setNormalNum(this.width * this.height);
        }
        this.normal[n2 * this.width + n] = iVec2;
    }

    @Override
    public void draw(GL2 gL2) {
        if (this.normal != null) {
            for (int i = 0; i < this.height - 1; ++i) {
                gL2.glBegin(8);
                for (int j = 0; j < this.width; ++j) {
                    IVec iVec = this.normal[i * this.width + j];
                    gL2.glNormal3d(iVec.x, iVec.y, iVec.z);
                    IVec iVec2 = this.pts[i * this.width + j];
                    gL2.glVertex3d(iVec2.x, iVec2.y, iVec2.z);
                    IVec iVec3 = this.normal[(i + 1) * this.width + j];
                    gL2.glNormal3d(iVec3.x, iVec3.y, iVec3.z);
                    IVec iVec4 = this.pts[(i + 1) * this.width + j];
                    gL2.glVertex3d(iVec4.x, iVec4.y, iVec4.z);
                }
                gL2.glEnd();
            }
        } else {
            for (int i = 0; i < this.height - 1; ++i) {
                gL2.glBegin(8);
                for (int j = 0; j < this.width; ++j) {
                    IVec iVec = this.pts[i * this.width + j];
                    gL2.glVertex3d(iVec.x, iVec.y, iVec.z);
                    IVec iVec5 = this.pts[(i + 1) * this.width + j];
                    gL2.glVertex3d(iVec5.x, iVec5.y, iVec5.z);
                }
                gL2.glEnd();
            }
        }
    }
}

