/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I2DFieldI;
import igeo.IDoubleMap;
import igeo.IFieldGeo;
import igeo.IImageMap;
import igeo.IMap;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVecI;

public class I2DMapFieldGeo
extends IFieldGeo
implements I2DFieldI {
    public IMap map;
    public IDoubleMap dmap;
    public IVec corner;
    public double width;
    public double height;
    public int mapWidth;
    public int mapHeight;
    public int interpolationRange = 5;

    public I2DMapFieldGeo(IMap iMap, IVec iVec, double d, double d2) {
        this.map = iMap;
        this.corner = iVec;
        this.width = d;
        this.height = d2;
        if (this.map instanceof IDoubleMap) {
            this.dmap = (IDoubleMap)this.map;
            this.mapWidth = this.dmap.getWidth();
            this.mapHeight = this.dmap.getHeight();
            if (this.dmap instanceof IImageMap) {
                this.dmap.flipV();
            }
        } else {
            this.mapWidth = IMap.defaultDensityWidth;
            this.mapHeight = IMap.defaultDensityHeight;
        }
    }

    public double udif(int n, int n2) {
        if (this.dmap != null) {
            return this.dmap.map[n + 1][n2] - this.dmap.map[n][n2];
        }
        return this.map.get((double)(n + 1) / (double)this.mapWidth, (double)n2 / (double)this.mapHeight) - this.map.get((double)n / (double)this.mapWidth, (double)n2 / (double)this.mapHeight);
    }

    public double vdif(int n, int n2) {
        if (this.dmap != null) {
            return this.dmap.map[n + 1][n2] - this.dmap.map[n][n2];
        }
        return this.map.get((double)(n + 1) / (double)this.mapWidth, (double)n2 / (double)this.mapHeight) - this.map.get((double)n / (double)this.mapWidth, (double)n2 / (double)this.mapHeight);
    }

    public IVec2 dif(int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.mapWidth - 1) {
            n = this.mapWidth - 2;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.mapHeight - 1) {
            n2 = this.mapHeight - 2;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.dmap != null) {
            d = this.dmap.map[n + 1][n2] - this.dmap.map[n][n2];
            d2 = this.dmap.map[n + 1][n2 + 1] - this.dmap.map[n][n2 + 1];
            d3 = this.dmap.map[n][n2 + 1] - this.dmap.map[n][n2];
            d4 = this.dmap.map[n + 1][n2 + 1] - this.dmap.map[n + 1][n2];
        } else {
            d = this.map.get((double)(n + 1) / (double)this.mapWidth, (double)n2 / (double)this.mapHeight) - this.map.get((double)n / (double)this.mapWidth, (double)n2 / (double)this.mapHeight);
            d2 = this.map.get((double)(n + 1) / (double)this.mapWidth, (double)(n2 + 1) / (double)this.mapHeight) - this.map.get((double)n / (double)this.mapWidth, (double)(n2 + 1) / (double)this.mapHeight);
            d3 = this.map.get((double)n / (double)this.mapWidth, (double)(n2 + 1) / (double)this.mapHeight) - this.map.get((double)n / (double)this.mapWidth, (double)n2 / (double)this.mapHeight);
            d4 = this.map.get((double)(n + 1) / (double)this.mapWidth, (double)(n2 + 1) / (double)this.mapHeight) - this.map.get((double)(n + 1) / (double)this.mapWidth, (double)n2 / (double)this.mapHeight);
        }
        return new IVec2((d + d2) / 2.0, (d3 + d4) / 2.0);
    }

    IVec2 interpolateDif(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        IVec2 iVec2 = new IVec2();
        for (int i = n - this.interpolationRange; i < n + this.interpolationRange; ++i) {
            for (int j = n2 - this.interpolationRange; j < n2 + this.interpolationRange; ++j) {
                iVec2.add(this.dif(i, j));
                d += (double)(1 - Math.abs(i - n) / (this.interpolationRange + 1));
            }
        }
        iVec2.div(d);
        return iVec2;
    }

    public IVec2I get(IVecI iVecI, double d, double d2) {
        int n = (int)(d * (double)this.mapWidth - 0.5);
        int n2 = (int)(d2 * (double)this.mapHeight - 0.5);
        if (n < 0) {
            n = 0;
        } else if (n >= this.mapWidth - 1) {
            n = this.mapWidth - 2;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.mapHeight - 1) {
            n2 = this.mapHeight - 2;
        }
        return this.interpolateDif(n, n2);
    }

    public IVec2I get(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return this.get(iVecI, d, d2);
    }

    @Override
    public IVec2I get(IVecI iVecI) {
        return this.get(iVecI, null);
    }

    @Override
    public IVec2I get(IVecI iVecI, IVecI iVecI2) {
        double d = (iVecI.x() - this.corner.x) / this.width;
        double d2 = (iVecI.y() - this.corner.y) / this.height;
        if (d < 0.0 || d > 1.0 || d2 < 0.0 || d2 > 1.0) {
            return new IVec2(0.0, 0.0);
        }
        double d3 = this.intensity;
        IVec2I iVec2I = this.get(iVecI, iVecI2, d, d2);
        return iVec2I.mul(d3);
    }

    @Override
    public I2DMapFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    @Override
    public void del() {
    }
}

