/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IColor;
import igeo.IGraphicI;
import igeo.IGraphicObject;
import igeo.IObject;
import igeo.IOut;
import igeo.IServer;
import igeo.gui.IGraphicMode;
import igeo.gui.IPanelI;
import igeo.gui.IView;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGraphicServer {
    public static IGraphicMode defaultMode = new IGraphicMode(IGraphicMode.GraphicType.GL, true, true, true);
    public ArrayList<IGraphicI> graphics3D;
    public HashMap<IView, ArrayList<IGraphicI>> graphics2D;
    public ArrayList<IView> views;
    public IServer server;
    public IPanelI panel;
    public IGraphicMode[] modes = null;
    public boolean useGL;
    public String bgImageFilename;

    public IGraphicServer(IServer iServer, IPanelI iPanelI) {
        this.server = iServer;
        this.panel = iPanelI;
        this.views = new ArrayList();
        for (int i = 0; i < this.panel.paneNum(); ++i) {
            this.views.add(this.panel.pane(i).getView());
        }
    }

    public void addView(IView iView) {
        this.views.add(iView);
    }

    public IView view(int n) {
        return this.views.get(n);
    }

    public int viewNum() {
        return this.views.size();
    }

    public void setMode(IGraphicMode iGraphicMode) {
        if (this.views != null) {
            for (IView iView : this.views) {
                iView.setMode(new IGraphicMode(iGraphicMode));
            }
        }
    }

    public void enableGL() {
        this.useGL = true;
    }

    public void disableGL() {
        this.useGL = false;
    }

    public boolean isGL() {
        return this.useGL;
    }

    public void bg(IColor iColor, IColor iColor2, IColor iColor3, IColor iColor4) {
        if (this.views != null) {
            for (IView iView : this.views) {
                iView.bgColor(iColor, iColor2, iColor3, iColor4);
            }
        }
    }

    public void background(IColor iColor, IColor iColor2, IColor iColor3, IColor iColor4) {
        this.bg(iColor, iColor2, iColor3, iColor4);
    }

    public void bg(String string) {
        this.bgImageFilename = string;
    }

    public void background(String string) {
        this.bg(string);
    }

    public void add(IObject iObject) {
        boolean bl = false;
        for (IView iView : this.views) {
            if (!iView.mode().isGraphic3D()) continue;
            bl = true;
        }
        if (bl) {
            IGraphicObject iGraphicObject = iObject.getGraphic(this.views.get(0).mode());
            if (iGraphicObject != null) {
                this.add(iGraphicObject, this.views.get(0));
            } else {
                IOut.err("graphic of the object is null : " + iObject);
            }
        } else {
            for (IView iView : this.views) {
                IGraphicObject iGraphicObject = iObject.getGraphic(iView.mode());
                if (iGraphicObject != null) {
                    this.add(iGraphicObject, iView);
                    continue;
                }
                IOut.err("graphic of the object is null : " + iObject);
            }
        }
    }

    public void add(IGraphicI iGraphicI, IView iView) {
        if (iView.mode().isGraphic3D()) {
            if (this.graphics3D == null) {
                this.graphics3D = new ArrayList();
            }
            this.graphics3D.add(iGraphicI);
        } else if (iView.mode().isGraphic2D()) {
            ArrayList<IGraphicI> arrayList;
            if (this.graphics2D == null) {
                this.graphics2D = new HashMap();
            }
            if ((arrayList = this.graphics2D.get(iView)) == null) {
                arrayList = new ArrayList();
                this.graphics2D.put(iView, arrayList);
            }
            arrayList.add(iGraphicI);
        }
    }

    public ArrayList<IGraphicI> getObjects(IView iView) {
        if (iView.mode().isGraphic3D()) {
            return this.graphics3D;
        }
        if (iView.mode().isGraphic2D()) {
            return this.graphics2D.get(iView);
        }
        return null;
    }

    public void remove(IGraphicI iGraphicI) {
        if (this.modes == null) {
            this.modes = IGraphicMode.getAllModes();
        }
        for (IGraphicMode iGraphicMode : this.modes) {
            if (!iGraphicI.isDrawable(iGraphicMode)) continue;
            if (iGraphicMode.isGraphic3D()) {
                this.graphics3D.remove(iGraphicI);
                continue;
            }
            if (!iGraphicMode.isGraphic2D()) continue;
            for (IView iView : this.views) {
                if (this.graphics2D.get(iView) == null) continue;
                this.graphics2D.get(iView).remove(iGraphicI);
            }
        }
    }

    public void clearObjects() {
        if (this.graphics3D != null) {
            this.graphics3D.clear();
            this.graphics3D = null;
        }
        if (this.graphics2D != null) {
            for (IView iView : this.views) {
                if (this.graphics2D.get(iView) == null) continue;
                this.graphics2D.get(iView).clear();
            }
            this.graphics2D.clear();
            this.graphics2D = null;
        }
    }

    public void clearViews() {
        this.views.clear();
    }
}

