/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveI;
import igeo.IEdge;
import igeo.IFace;
import igeo.IG;
import igeo.IMesh;
import igeo.IMeshGeo;
import igeo.IMeshI;
import igeo.IMeshType;
import igeo.IObject;
import igeo.IOut;
import igeo.IServerI;
import igeo.ISurfaceCreator;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMeshCreator {
    public static IServerI server = null;
    public static IMeshType type = new IMeshType();

    public static void server(IServerI iServerI) {
        server = iServerI;
    }

    public static IServerI server() {
        return server;
    }

    public static void meshType(IMeshType iMeshType) {
        type = iMeshType;
    }

    public static IMeshType meshType() {
        return type;
    }

    public static IMesh mesh() {
        return new IMesh(server);
    }

    public static IMesh mesh(IMeshGeo iMeshGeo) {
        return new IMesh(server, iMeshGeo);
    }

    public static IMesh mesh(IMesh iMesh) {
        return new IMesh(server, iMesh);
    }

    public static IMesh mesh(ArrayList<ICurveI> arrayList) {
        return new IMesh(server, arrayList.toArray(new ICurve[arrayList.size()]));
    }

    public static IMesh mesh(ICurveI[] iCurveIArray) {
        return new IMesh(server, iCurveIArray);
    }

    public static IMesh mesh(IVec[][] iVecArray) {
        return new IMesh(server, iVecArray);
    }

    public static IMesh mesh(IVec[][] iVecArray, boolean bl) {
        return new IMesh(server, iVecArray, bl, type);
    }

    public static IMesh mesh(IVec[][] iVecArray, int n, int n2, boolean bl) {
        return new IMesh(server, iVecArray, n, n2, bl, type);
    }

    public static IMesh mesh(ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        return new IMesh(server, arrayList, arrayList2, arrayList3);
    }

    public static IMesh mesh(IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        return new IMesh(server, iVertexArray, iEdgeArray, iFaceArray);
    }

    public static IMesh mesh(IVec[] iVecArray) {
        return new IMesh(server, iVecArray);
    }

    public static IMesh mesh(IVertex[] iVertexArray) {
        return new IMesh(server, iVertexArray);
    }

    public static IMesh mesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        return new IMesh(server, iVertex, iVertex2, iVertex3);
    }

    public static IMesh mesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        return new IMesh(server, iVertex, iVertex2, iVertex3, iVertex4);
    }

    public static IMesh mesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return new IMesh(server, iVecI, iVecI2, iVecI3);
    }

    public static IMesh mesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return new IMesh(server, iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IMesh mesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return new IMesh(server, d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static IMesh mesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return new IMesh(server, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static IMesh mesh(IFace[] iFaceArray) {
        return new IMesh(server, iFaceArray);
    }

    public static IMesh meshFromTriangles(IVecI[][] iVecIArray) {
        int n;
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (n = 0; n < iVecIArray[i].length; ++n) {
                if (arrayList.contains(iVecIArray[i][n])) continue;
                arrayList.add(iVecIArray[i][n]);
            }
        }
        IVertex[] iVertexArray = new IVertex[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            iVertexArray[n] = new IVertex((IVecI)arrayList.get(n));
        }
        IFace[] iFaceArray = new IFace[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            IVertex[] iVertexArray2 = new IVertex[iVecIArray[i].length];
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                int n2 = arrayList.indexOf(iVecIArray[i][j]);
                iVertexArray2[j] = iVertexArray[n2];
            }
            iFaceArray[i] = new IFace(iVertexArray2);
        }
        return new IMesh(iFaceArray);
    }

    public static IMesh box(double d, double d2, double d3, double d4) {
        return IMeshCreator.box((IVecI)new IVec(d, d2, d3), d4, d4, d4);
    }

    public static IMesh box(double d, double d2, double d3, double d4, double d5, double d6) {
        return IMeshCreator.box((IVecI)new IVec(d, d2, d3), d4, d5, d6);
    }

    public static IMesh box(IVecI iVecI, double d) {
        return IMeshCreator.box(iVecI, d, d, d);
    }

    public static IMesh box(IVecI iVecI, double d, double d2, double d3) {
        return IMeshCreator.box(iVecI, new IVec(d, 0.0, 0.0), new IVec(0.0, d2, 0.0), new IVec(0.0, 0.0, d3));
    }

    public static IMesh box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][][] iVecIArray = new IVecI[2][2][2];
        IVec iVec = iVecI.get();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    iVecIArray[i][j][k] = iVec.dup();
                    if (i > 0) {
                        iVecIArray[i][j][k].add(iVecI2);
                    }
                    if (j > 0) {
                        iVecIArray[i][j][k].add(iVecI3);
                    }
                    if (k <= 0) continue;
                    iVecIArray[i][j][k].add(iVecI4);
                }
            }
        }
        return IMeshCreator.box(iVecIArray);
    }

    public static IMesh box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6, IVecI iVecI7, IVecI iVecI8) {
        IVecI[][][] iVecIArray = new IVecI[2][2][2];
        iVecIArray[0][0][0] = iVecI;
        iVecIArray[1][0][0] = iVecI2;
        iVecIArray[1][1][0] = iVecI3;
        iVecIArray[0][1][0] = iVecI4;
        iVecIArray[0][0][1] = iVecI5;
        iVecIArray[1][0][1] = iVecI6;
        iVecIArray[1][1][1] = iVecI7;
        iVecIArray[0][1][1] = iVecI8;
        return IMeshCreator.box(iVecIArray);
    }

    public static IMesh box(IVecI[][][] iVecIArray) {
        if (iVecIArray.length < 2 || iVecIArray[0].length < 2 || iVecIArray[1].length < 2 || iVecIArray[0][0].length < 2 || iVecIArray[0][1].length < 2 || iVecIArray[1][0].length < 2 || iVecIArray[1][1].length < 2) {
            return null;
        }
        IVertex[][][] iVertexArray = new IVertex[2][2][2];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    iVertexArray[i][j][k] = type.createVertex(iVecIArray[i][j][k]);
                }
            }
        }
        return IMeshCreator.box(iVertexArray);
    }

    public static IMesh box(IVertex[][][] iVertexArray) {
        int n;
        if (iVertexArray.length < 2 || iVertexArray[0].length < 2 || iVertexArray[1].length < 2 || iVertexArray[0][0].length < 2 || iVertexArray[0][1].length < 2 || iVertexArray[1][0].length < 2 || iVertexArray[1][1].length < 2) {
            return null;
        }
        IEdge[] iEdgeArray = new IEdge[12];
        IFace[] iFaceArray = new IFace[6];
        IVec iVec = iVertexArray[1][0][0].get().dif(iVertexArray[0][0][0]);
        IVec iVec2 = iVertexArray[0][1][0].get().dif(iVertexArray[0][0][0]);
        IVec iVec3 = iVertexArray[0][0][1].get().dif(iVertexArray[0][0][0]);
        if (iVec.cross(iVec2).dot(iVec3) >= 0.0) {
            iEdgeArray[0] = type.createEdge(iVertexArray[0][0][0], iVertexArray[0][1][0]);
            iEdgeArray[1] = type.createEdge(iVertexArray[0][1][0], iVertexArray[1][1][0]);
            iEdgeArray[2] = type.createEdge(iVertexArray[1][1][0], iVertexArray[1][0][0]);
            iEdgeArray[3] = type.createEdge(iVertexArray[1][0][0], iVertexArray[0][0][0]);
            iEdgeArray[4] = type.createEdge(iVertexArray[0][0][1], iVertexArray[0][1][1]);
            iEdgeArray[5] = type.createEdge(iVertexArray[0][1][1], iVertexArray[1][1][1]);
            iEdgeArray[6] = type.createEdge(iVertexArray[1][1][1], iVertexArray[1][0][1]);
            iEdgeArray[7] = type.createEdge(iVertexArray[1][0][1], iVertexArray[0][0][1]);
        } else {
            iEdgeArray[0] = type.createEdge(iVertexArray[0][0][1], iVertexArray[0][1][1]);
            iEdgeArray[1] = type.createEdge(iVertexArray[0][1][1], iVertexArray[1][1][1]);
            iEdgeArray[2] = type.createEdge(iVertexArray[1][1][1], iVertexArray[1][0][1]);
            iEdgeArray[3] = type.createEdge(iVertexArray[1][0][1], iVertexArray[0][0][1]);
            iEdgeArray[4] = type.createEdge(iVertexArray[0][0][0], iVertexArray[0][1][0]);
            iEdgeArray[5] = type.createEdge(iVertexArray[0][1][0], iVertexArray[1][1][0]);
            iEdgeArray[6] = type.createEdge(iVertexArray[1][1][0], iVertexArray[1][0][0]);
            iEdgeArray[7] = type.createEdge(iVertexArray[1][0][0], iVertexArray[0][0][0]);
        }
        iEdgeArray[8] = type.createEdge(iVertexArray[0][0][0], iVertexArray[0][0][1]);
        iEdgeArray[9] = type.createEdge(iVertexArray[0][1][0], iVertexArray[0][1][1]);
        iEdgeArray[10] = type.createEdge(iVertexArray[1][1][0], iVertexArray[1][1][1]);
        iEdgeArray[11] = type.createEdge(iVertexArray[1][0][0], iVertexArray[1][0][1]);
        iFaceArray[0] = type.createFace(iEdgeArray[0], iEdgeArray[1], iEdgeArray[2], iEdgeArray[3]);
        iFaceArray[1] = type.createFace(iEdgeArray[4], iEdgeArray[7], iEdgeArray[6], iEdgeArray[5]);
        iFaceArray[2] = type.createFace(iEdgeArray[8], iEdgeArray[4], iEdgeArray[9], iEdgeArray[0]);
        iFaceArray[3] = type.createFace(iEdgeArray[11], iEdgeArray[2], iEdgeArray[10], iEdgeArray[6]);
        iFaceArray[4] = type.createFace(iEdgeArray[11], iEdgeArray[7], iEdgeArray[8], iEdgeArray[3]);
        iFaceArray[5] = type.createFace(iEdgeArray[9], iEdgeArray[5], iEdgeArray[10], iEdgeArray[1]);
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    arrayList.add(iVertexArray[n][i][j]);
                }
            }
        }
        for (n = 0; n < 12; ++n) {
            arrayList2.add(iEdgeArray[n]);
        }
        for (n = 0; n < 6; ++n) {
            arrayList3.add(iFaceArray[n]);
        }
        IMesh iMesh = new IMesh(arrayList, arrayList2, arrayList3);
        iMesh.close();
        return iMesh;
    }

    public static IMesh tetrahedron(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IMeshCreator.tetrahedron(new IVertex(iVecI), new IVertex(iVecI2), new IVertex(iVecI3), new IVertex(iVecI4));
    }

    public static IMesh tetrahedron(IVecI[] iVecIArray) {
        IVertex[] iVertexArray = new IVertex[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVertexArray[i] = new IVertex(iVecIArray[i]);
        }
        return IMeshCreator.tetrahedron(iVertexArray);
    }

    public static IMesh tetrahedron(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        return IMeshCreator.tetrahedron(new IVertex[]{iVertex, iVertex2, iVertex3, iVertex4});
    }

    public static IMesh tetrahedron(IVertex[] iVertexArray) {
        int n;
        if (iVertexArray == null || iVertexArray.length < 4) {
            IG.err("tetrahedron cannot be generated with less than 4 points");
            return null;
        }
        IEdge[] iEdgeArray = new IEdge[6];
        IFace[] iFaceArray = new IFace[4];
        iEdgeArray[0] = type.createEdge(iVertexArray[0], iVertexArray[1]);
        iEdgeArray[1] = type.createEdge(iVertexArray[0], iVertexArray[2]);
        iEdgeArray[2] = type.createEdge(iVertexArray[0], iVertexArray[3]);
        iEdgeArray[3] = type.createEdge(iVertexArray[1], iVertexArray[2]);
        iEdgeArray[4] = type.createEdge(iVertexArray[1], iVertexArray[3]);
        iEdgeArray[5] = type.createEdge(iVertexArray[2], iVertexArray[3]);
        IVecI[] iVecIArray = new IVecI[]{iVertexArray[0], iVertexArray[1], iVertexArray[2]};
        IVecI[] iVecIArray2 = new IVecI[]{iVertexArray[0], iVertexArray[1], iVertexArray[2], iVertexArray[3]};
        if (IVec.nml(iVertexArray[0], iVertexArray[1], iVertexArray[2]).dot(IVec.center(iVecIArray).dif(IVec.center(iVecIArray2))) > 0.0) {
            iFaceArray[0] = type.createFace(iEdgeArray[0], iEdgeArray[3], iEdgeArray[1]);
            iFaceArray[1] = type.createFace(iEdgeArray[2], iEdgeArray[4], iEdgeArray[0]);
            iFaceArray[2] = type.createFace(iEdgeArray[1], iEdgeArray[5], iEdgeArray[2]);
            iFaceArray[3] = type.createFace(iEdgeArray[3], iEdgeArray[4], iEdgeArray[5]);
        } else {
            iFaceArray[0] = type.createFace(iEdgeArray[1], iEdgeArray[3], iEdgeArray[0]);
            iFaceArray[1] = type.createFace(iEdgeArray[0], iEdgeArray[4], iEdgeArray[2]);
            iFaceArray[2] = type.createFace(iEdgeArray[2], iEdgeArray[5], iEdgeArray[1]);
            iFaceArray[3] = type.createFace(iEdgeArray[5], iEdgeArray[4], iEdgeArray[3]);
        }
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        for (n = 0; n < 4; ++n) {
            arrayList.add(iVertexArray[n]);
        }
        for (n = 0; n < 6; ++n) {
            arrayList2.add(iEdgeArray[n]);
        }
        for (n = 0; n < 4; ++n) {
            arrayList3.add(iFaceArray[n]);
        }
        IMesh iMesh = new IMesh(arrayList, arrayList2, arrayList3);
        iMesh.close();
        return iMesh;
    }

    public static IMesh pipe(IVertex[][] iVertexArray) {
        int n;
        if (iVertexArray == null || iVertexArray.length < 2 || iVertexArray[0].length != 2) {
            IG.err("wrong vertex array");
            return null;
        }
        int n2 = iVertexArray.length;
        IEdge[] iEdgeArray = new IEdge[n2];
        IEdge[] iEdgeArray2 = new IEdge[n2];
        IEdge[] iEdgeArray3 = new IEdge[n2];
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        for (n = 0; n < n2; ++n) {
            arrayList.add(iVertexArray[n][0]);
            arrayList.add(iVertexArray[n][1]);
            iEdgeArray3[n] = type.createEdge(iVertexArray[n][0], iVertexArray[n][1]);
            iEdgeArray[n] = type.createEdge(iVertexArray[n][0], iVertexArray[(n + 1) % n2][0]);
            iEdgeArray2[n] = type.createEdge(iVertexArray[n][1], iVertexArray[(n + 1) % n2][1]);
            arrayList2.add(iEdgeArray3[n]);
            arrayList2.add(iEdgeArray[n]);
            arrayList2.add(iEdgeArray2[n]);
        }
        for (n = 0; n < n2; ++n) {
            IFace iFace = type.createFace(iEdgeArray3[n], iEdgeArray[n], iEdgeArray3[(n + 1) % n2], iEdgeArray2[n]);
            arrayList3.add(iFace);
        }
        return new IMesh(arrayList, arrayList2, arrayList3);
    }

    public static IMesh pipe(IVecI[][] iVecIArray) {
        if (iVecIArray == null || iVecIArray.length < 2 || iVecIArray[0].length != 2) {
            IG.err("wrong point array");
            return null;
        }
        IVertex[][] iVertexArray = new IVertex[iVecIArray.length][2];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVertexArray[i][0] = type.createVertex(iVecIArray[i][0]);
            iVertexArray[i][1] = type.createVertex(iVecIArray[i][1]);
        }
        return IMeshCreator.pipe(iVertexArray);
    }

    public static IMesh rectPipe(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][] iVecIArray = new IVec[4][2];
        IVec iVec = iVecI.get();
        IVec iVec2 = iVecI2.get();
        iVecIArray[0][0] = iVec.dup().add(-0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[1][0] = iVec.dup().add(0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[2][0] = iVec.dup().add(0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[3][0] = iVec.dup().add(-0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[0][1] = iVec2.dup().add(-0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[1][1] = iVec2.dup().add(0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[2][1] = iVec2.dup().add(0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[3][1] = iVec2.dup().add(-0.5, iVecI3).add(0.5, iVecI4);
        return IMeshCreator.pipe(iVecIArray);
    }

    public static IMesh rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2, IVecI iVecI3) {
        IVec iVec = iVecI2.get().dif(iVecI);
        IVec iVec2 = iVec.cross(iVecI3);
        if (iVec2.len2() < IConfig.tolerance && (iVec2 = iVec.cross(IVec.zaxis)).len2() < IConfig.tolerance) {
            iVec2 = iVec.cross(IVec.xaxis);
        }
        IVec iVec3 = iVec2.cross(iVec);
        iVec2.len(d);
        iVec3.len(d2);
        return IMeshCreator.rectPipe(iVecI, iVecI2, iVec2, iVec3);
    }

    public static IMesh rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        IVec iVec = iVecI2.get().dif(iVecI);
        IVec iVec2 = iVec.cross(IVec.zaxis);
        if (iVec2.len2() < IConfig.tolerance) {
            iVec2 = iVec.cross(IVec.xaxis);
        }
        IVec iVec3 = iVec2.cross(iVec);
        iVec2.len(d);
        iVec3.len(d2);
        return IMeshCreator.rectPipe(iVecI, iVecI2, iVec2, iVec3);
    }

    public static IMesh squarePipe(IVecI iVecI, IVecI iVecI2, double d, IVecI iVecI3) {
        return IMeshCreator.rectPipe(iVecI, iVecI2, d, d, iVecI3);
    }

    public static IMesh squarePipe(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.rectPipe(iVecI, iVecI2, d, d);
    }

    public static IMesh rectStick(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][][] iVecIArray = new IVec[2][2][2];
        IVec iVec = iVecI.get();
        IVec iVec2 = iVecI2.get();
        iVecIArray[0][0][0] = iVec.dup().add(-0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[0][0][1] = iVec.dup().add(0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[0][1][0] = iVec.dup().add(-0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[0][1][1] = iVec.dup().add(0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[1][0][0] = iVec2.dup().add(-0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[1][0][1] = iVec2.dup().add(0.5, iVecI3).add(-0.5, iVecI4);
        iVecIArray[1][1][0] = iVec2.dup().add(-0.5, iVecI3).add(0.5, iVecI4);
        iVecIArray[1][1][1] = iVec2.dup().add(0.5, iVecI3).add(0.5, iVecI4);
        return IMeshCreator.box(iVecIArray);
    }

    public static IMesh rectStick(IVecI iVecI, IVecI iVecI2, double d, double d2, IVecI iVecI3) {
        IVec iVec = iVecI2.get().dif(iVecI);
        IVec iVec2 = iVec.cross(iVecI3);
        if (iVec2.len2() < IConfig.tolerance && (iVec2 = iVec.cross(IVec.zaxis)).len2() < IConfig.tolerance) {
            iVec2 = iVec.cross(IVec.xaxis);
        }
        IVec iVec3 = iVec2.cross(iVec);
        iVec2.len(d);
        iVec3.len(d2);
        return IMeshCreator.rectStick(iVecI, iVecI2, iVec2, iVec3);
    }

    public static IMesh rectStick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        IVec iVec = iVecI2.get().dif(iVecI);
        IVec iVec2 = iVec.cross(IVec.zaxis);
        if (iVec2.len2() < IConfig.tolerance) {
            iVec2 = iVec.cross(IVec.xaxis);
        }
        IVec iVec3 = iVec2.cross(iVec);
        iVec2.len(d);
        iVec3.len(d2);
        return IMeshCreator.rectStick(iVecI, iVecI2, iVec2, iVec3);
    }

    public static IMesh squareStick(IVecI iVecI, IVecI iVecI2, double d, IVecI iVecI3) {
        return IMeshCreator.rectStick(iVecI, iVecI2, d, d, iVecI3);
    }

    public static IMesh squareStick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.rectStick(iVecI, iVecI2, d, d);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, int n) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d, n, IG.zaxis);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, int n, IVecI iVecI3) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d, n, iVecI3);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, double d2, int n) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d2, n, IG.zaxis);
    }

    public static IMesh polygonStick(IVecI iVecI, IVecI iVecI2, double d, double d2, int n, IVecI iVecI3) {
        int n2;
        IEdge[] iEdgeArray;
        if (n <= 2) {
            IOut.err("too less vertex number of a polygon. needs to be >= 3");
            return null;
        }
        int n3 = n;
        IVertex[] iVertexArray = new IVertex[n3];
        IVertex[] iVertexArray2 = new IVertex[n3];
        IVec iVec = iVecI.get();
        IVec iVec2 = iVecI2.get();
        IVertex iVertex = type.createVertex(iVec);
        IVertex iVertex2 = type.createVertex(iVec2);
        IVec iVec3 = iVec2.dif(iVec);
        IVec iVec4 = iVecI3.get().cross(iVec3);
        if (iVec4.len2() < IConfig.tolerance && (iVec4 = IVec.zaxis.cross(iVec3)).len2() < IConfig.tolerance) {
            iVec4 = IVec.xaxis.cross(iVec3);
        }
        IVec iVec5 = iVec3.cross(iVec4).len(d);
        double d3 = Math.PI * 2 / (double)n3;
        if (d != d2) {
            iEdgeArray = iVec5.dup().len(d2);
            for (int i = 0; i < n3; ++i) {
                iVertexArray[i] = type.createVertex(iVec.cp(iVec5));
                iVertexArray2[i] = type.createVertex(iVec2.cp((IVec)iEdgeArray));
                iVec5.rot(iVec3, d3);
                iEdgeArray.rot(iVec3, d3);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                iVertexArray[i] = type.createVertex(iVec.cp(iVec5));
                iVertexArray2[i] = type.createVertex(iVec2.cp(iVec5));
                iVec5.rot(iVec3, d3);
            }
        }
        iEdgeArray = new IEdge[n3];
        IEdge[] iEdgeArray2 = new IEdge[n3];
        IEdge[] iEdgeArray3 = new IEdge[n3];
        for (int i = 0; i < n3; ++i) {
            iEdgeArray[i] = type.createEdge(iVertexArray[i], iVertexArray[(i + 1) % n3]);
            iEdgeArray2[i] = type.createEdge(iVertexArray2[i], iVertexArray2[(i + 1) % n3]);
            iEdgeArray3[i] = type.createEdge(iVertexArray[i], iVertexArray2[i]);
        }
        IEdge[] iEdgeArray4 = null;
        IEdge[] iEdgeArray5 = null;
        if (n3 > 4) {
            iEdgeArray4 = new IEdge[n3];
            iEdgeArray5 = new IEdge[n3];
            for (int i = 0; i < n3; ++i) {
                iEdgeArray4[i] = type.createEdge(iVertex, iVertexArray[i]);
                iEdgeArray5[i] = type.createEdge(iVertex2, iVertexArray2[i]);
            }
        }
        IFace[] iFaceArray = null;
        IFace[] iFaceArray2 = null;
        if (n3 == 3) {
            iFaceArray = new IFace[1];
            iFaceArray2 = new IFace[1];
            iFaceArray[0] = type.createFace(iEdgeArray[0], iEdgeArray[2], iEdgeArray[1]);
            iFaceArray2[0] = type.createFace(iEdgeArray2[0], iEdgeArray2[1], iEdgeArray2[2]);
        } else if (n3 == 4) {
            iFaceArray = new IFace[1];
            iFaceArray2 = new IFace[1];
            iFaceArray[0] = type.createFace(iEdgeArray[0], iEdgeArray[3], iEdgeArray[2], iEdgeArray[1]);
            iFaceArray2[0] = type.createFace(iEdgeArray2[0], iEdgeArray2[1], iEdgeArray2[2], iEdgeArray2[3]);
        } else {
            iFaceArray = new IFace[n3];
            iFaceArray2 = new IFace[n3];
            for (int i = 0; i < n3; ++i) {
                iFaceArray[i] = type.createFace(iEdgeArray4[(i + 1) % n3], iEdgeArray[i], iEdgeArray4[i]);
                iFaceArray2[i] = type.createFace(iEdgeArray5[i], iEdgeArray2[i], iEdgeArray5[(i + 1) % n3]);
            }
        }
        IFace[] iFaceArray3 = new IFace[n3];
        for (int i = 0; i < n3; ++i) {
            iFaceArray3[i] = type.createFace(iEdgeArray[i], iEdgeArray3[(i + 1) % n3], iEdgeArray2[i], iEdgeArray3[i]);
        }
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        if (n3 > 4) {
            arrayList.add(iVertex);
        }
        if (n3 > 4) {
            arrayList.add(iVertex2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(iVertexArray[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(iVertexArray2[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList2.add(iEdgeArray[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList2.add(iEdgeArray2[n2]);
        }
        if (n3 > 4) {
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(iEdgeArray4[n2]);
            }
        }
        if (n3 > 4) {
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(iEdgeArray5[n2]);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList2.add(iEdgeArray3[n2]);
        }
        for (n2 = 0; n2 < iFaceArray.length; ++n2) {
            arrayList3.add(iFaceArray[n2]);
        }
        for (n2 = 0; n2 < iFaceArray2.length; ++n2) {
            arrayList3.add(iFaceArray2[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList3.add(iFaceArray3[n2]);
        }
        IMesh iMesh = new IMesh(arrayList, arrayList2, arrayList3);
        iMesh.close();
        return iMesh;
    }

    public static IMesh stick(IVecI[][] iVecIArray) {
        return IMeshCreator.stick(iVecIArray, false);
    }

    public static IMesh stick(IVecI[][] iVecIArray, boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        if (iVecIArray == null) {
            IOut.err("pts is null");
            return null;
        }
        if (iVecIArray.length <= 1) {
            IOut.err("pts unum needs to be more than 2");
            return null;
        }
        if (iVecIArray[0].length <= 2) {
            IOut.err("pts vnum needs to be more than 3");
            return null;
        }
        int n4 = iVecIArray.length;
        int n5 = iVecIArray[0].length;
        IVertex[][] iVertexArray = new IVertex[n4][n5];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                iVertexArray[i][j] = type.createVertex(iVecIArray[i][j]);
            }
        }
        IVertex iVertex = null;
        IVertex iVertex2 = null;
        IEdge[] iEdgeArray = null;
        IEdge[] iEdgeArray2 = null;
        if (!bl && n5 > 4) {
            object2 = new IVec();
            object = new IVec();
            for (n3 = 0; n3 < n5; ++n3) {
                ((IVec)object2).add(iVecIArray[0][n3]);
                ((IVec)object).add(iVecIArray[n4 - 1][n3]);
            }
            ((IVec)object2).div(n5);
            ((IVec)object).div(n5);
            iVertex = type.createVertex((IVec)object2);
            iVertex2 = type.createVertex((IVec)object);
            iEdgeArray = new IEdge[n5];
            iEdgeArray2 = new IEdge[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                iEdgeArray[n3] = type.createEdge(iVertex, iVertexArray[0][n3]);
                iEdgeArray2[n3] = type.createEdge(iVertex2, iVertexArray[n4 - 1][n3]);
            }
        }
        object2 = null;
        object = new IEdge[n4][n5];
        object2 = bl ? new IEdge[n4][n5] : new IEdge[n4 - 1][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            for (int i = 0; i < n5; ++i) {
                if (bl || n3 < n4 - 1) {
                    object2[n3][i] = type.createEdge(iVertexArray[n3][i], iVertexArray[(n3 + 1) % n4][i]);
                }
                object[n3][i] = type.createEdge(iVertexArray[n3][i], iVertexArray[n3][(i + 1) % n5]);
            }
        }
        IFace[] iFaceArray = null;
        IFace[] iFaceArray2 = null;
        if (!bl) {
            if (n5 == 3) {
                iFaceArray = new IFace[1];
                iFaceArray2 = new IFace[1];
                iFaceArray[0] = type.createFace((IEdge)object[0][0], (IEdge)object[0][1], (IEdge)object[0][2]);
                iFaceArray2[0] = type.createFace((IEdge)object[n4 - 1][0], (IEdge)object[n4 - 1][1], (IEdge)object[n4 - 1][2]);
            } else if (n5 == 4) {
                iFaceArray = new IFace[1];
                iFaceArray2 = new IFace[1];
                iFaceArray[0] = type.createFace((IEdge)object[0][0], (IEdge)object[0][1], (IEdge)object[0][2], (IEdge)object[0][3]);
                iFaceArray2[0] = type.createFace((IEdge)object[n4 - 1][0], (IEdge)object[n4 - 1][1], (IEdge)object[n4 - 1][2], (IEdge)object[n4 - 1][3]);
            } else {
                iFaceArray = new IFace[n5];
                iFaceArray2 = new IFace[n5];
                for (int i = 0; i < n5; ++i) {
                    iFaceArray[i] = type.createFace(iEdgeArray[(i + 1) % n5], (IEdge)object[0][i], iEdgeArray[i]);
                    iFaceArray2[i] = type.createFace(iEdgeArray2[i], (IEdge)object[n4 - 1][i], iEdgeArray2[(i + 1) % n5]);
                }
            }
        }
        IFace[][] iFaceArray3 = null;
        iFaceArray3 = bl ? new IFace[n4][n5] : new IFace[n4 - 1][n5];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                if (!bl && i >= n4 - 1) continue;
                iFaceArray3[i][j] = type.createFace((IEdge)object2[i][j], (IEdge)object[i][j], (IEdge)object2[i][(j + 1) % n5], (IEdge)object[(i + 1) % n4][j]);
            }
        }
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        if (iVertex != null) {
            arrayList.add(iVertex);
        }
        if (iVertex2 != null) {
            arrayList.add(iVertex2);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n5; ++n) {
                arrayList.add(iVertexArray[n2][n]);
            }
        }
        for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
            for (n = 0; n < ((Object)object2[n2]).length; ++n) {
                arrayList2.add((IEdge)object2[n2][n]);
            }
        }
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            for (n = 0; n < ((Object)object[n2]).length; ++n) {
                arrayList2.add((IEdge)object[n2][n]);
            }
        }
        if (iEdgeArray != null) {
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList2.add(iEdgeArray[n2]);
            }
        }
        if (iEdgeArray2 != null) {
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList2.add(iEdgeArray2[n2]);
            }
        }
        if (iFaceArray != null) {
            for (n2 = 0; n2 < iFaceArray.length; ++n2) {
                arrayList3.add(iFaceArray[n2]);
            }
        }
        if (iFaceArray2 != null) {
            for (n2 = 0; n2 < iFaceArray2.length; ++n2) {
                arrayList3.add(iFaceArray2[n2]);
            }
        }
        for (n2 = 0; n2 < iFaceArray3.length; ++n2) {
            for (n = 0; n < iFaceArray3[n2].length; ++n) {
                arrayList3.add(iFaceArray3[n2][n]);
            }
        }
        IMesh iMesh = new IMesh(arrayList, arrayList2, arrayList3);
        iMesh.close();
        return iMesh;
    }

    public static IMesh stick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, IConfig.meshCircleResolution);
    }

    public static IMesh stick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d2, IConfig.meshCircleResolution);
    }

    public static IMesh roundStick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.stick(iVecI, iVecI2, d);
    }

    public static IMesh roundStick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.stick(iVecI, iVecI2, d, d2);
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, int n) {
        int n2;
        double d = iVecI2.len();
        double d2 = iVecI3.len();
        IVec iVec = iVecI2.get();
        IVec iVec2 = iVecI2.get().cross(iVecI3);
        IVec iVec3 = iVec2.cross(iVecI2).len(d2);
        int n3 = n;
        int n4 = (n + 1) / 2;
        IVertex[][] iVertexArray = new IVertex[n3][n4 + 1];
        for (int i = 0; i <= n4; ++i) {
            if (i == 0) {
                IVertex iVertex = new IVertex(iVec.cp(iVecI));
                for (n2 = 0; n2 < n3; ++n2) {
                    iVertexArray[n2][i] = iVertex;
                }
                continue;
            }
            if (i == n4) {
                IVertex iVertex = new IVertex(iVec.cp().neg().add(iVecI));
                for (n2 = 0; n2 < n3; ++n2) {
                    iVertexArray[n2][i] = iVertex;
                }
                continue;
            }
            double d3 = Math.PI / (double)n4 * (double)i;
            for (int j = 0; j < n3; ++j) {
                double d4 = Math.PI * 2 / (double)n3 * (double)j;
                iVertexArray[j][i] = new IVertex(iVec.cp().rot(iVec2, d3).scale1d(iVec3, d2 / d).rot(iVec, d4).add(iVecI));
            }
        }
        IMesh iMesh = new IMesh(server);
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (i == 0) {
                    iMesh.addFace(new IFace(iVertexArray[0][i], iVertexArray[n2][i + 1], iVertexArray[(n2 + 1) % n3][i + 1]));
                    continue;
                }
                if (i == n4 - 1) {
                    iMesh.addFace(new IFace(iVertexArray[n2][i], iVertexArray[0][i + 1], iVertexArray[(n2 + 1) % n3][i]));
                    continue;
                }
                iMesh.addFace(new IFace(iVertexArray[n2][i], iVertexArray[n2][i + 1], iVertexArray[(n2 + 1) % n3][i + 1], iVertexArray[(n2 + 1) % n3][i]));
            }
        }
        return iMesh;
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return IMeshCreator.sphere(iVecI, iVecI2, iVecI3, IConfig.meshCircleResolution);
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2, int n) {
        IVec iVec = new IVec(iVecI2.len(), 0.0, 0.0);
        if (iVec.isParallel(iVecI2)) {
            iVec = new IVec(0.0, iVecI2.len(), 0.0);
        }
        return IMeshCreator.sphere(iVecI, iVecI2, iVec, n);
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2) {
        return IMeshCreator.sphere(iVecI, iVecI2, IConfig.meshCircleResolution);
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2, double d, int n) {
        return IMeshCreator.sphere(iVecI, iVecI2, d, d, n);
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2, double d, double d2, int n) {
        IVec iVec = iVecI2.get().cp().len(d);
        IVec iVec2 = new IVec(d2, 0.0, 0.0);
        if (iVec2.isParallel(iVecI2)) {
            iVec2 = new IVec(0.0, d2, 0.0);
        }
        return IMeshCreator.sphere(iVecI, (IVecI)iVec, iVec2, n);
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.sphere(iVecI, iVecI2, d, IConfig.meshCircleResolution);
    }

    public static IMesh sphere(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.sphere(iVecI, iVecI2, d, d2, IConfig.meshCircleResolution);
    }

    public static IMesh sphere(IVecI iVecI, double d, int n) {
        return IMeshCreator.sphere(iVecI, (IVecI)new IVec(0.0, 0.0, d), new IVec(d, 0.0, 0.0), n);
    }

    public static IMesh sphere(IVecI iVecI, double d) {
        return IMeshCreator.sphere(iVecI, d, IConfig.meshCircleResolution);
    }

    public static IMesh sphere(IVecI iVecI, double d, double d2, int n) {
        return IMeshCreator.sphere(iVecI, (IVecI)new IVec(0.0, 0.0, d), new IVec(d2, 0.0, 0.0), n);
    }

    public static IMesh sphere(IVecI iVecI, double d, double d2) {
        return IMeshCreator.sphere(iVecI, d, d2, IConfig.meshCircleResolution);
    }

    public static IVec[] polygonProfile(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, int n) {
        IVec iVec = iVecI3.get().dup().len(d);
        IVec[] iVecArray = new IVec[n];
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            iVecArray[i] = iVec.cp(iVecI);
            iVec.rot(iVecI2, d2);
        }
        return iVecArray;
    }

    public static IMesh polygonStick(ICurveI iCurveI, double d, int n, int n2) {
        int n3;
        IVecI[] iVecIArray = iCurveI.cps();
        IVec iVec = IVec.averageNormal(iVecIArray);
        IVec iVec2 = iVecIArray[1].get().dif(iVecIArray[0]);
        IVec iVec3 = iVecIArray[0].get();
        if (iVec.isParallel(iVec2) && (iVec = IG.zaxis).isParallel(iVec2)) {
            iVec = IG.yaxis;
        }
        IVec iVec4 = iVec2.cross(iVec);
        IVecI[] iVecIArray2 = IMeshCreator.polygonProfile(iVec3, iVec2, iVec4, d, n);
        boolean bl = iCurveI.isClosed();
        IVecI[] iVecIArray3 = null;
        if (iCurveI.deg() == 1) {
            iVecIArray3 = bl ? new IVec[iCurveI.cpNum() - 1] : new IVec[iCurveI.cpNum()];
            for (n3 = 0; n3 < iVecIArray3.length; ++n3) {
                iVecIArray3[n3] = iCurveI.cp(n3);
            }
        } else {
            iVecIArray3 = bl ? new IVec[n2] : new IVec[n2 + 1];
            for (n3 = 0; n3 < iVecIArray3.length; ++n3) {
                iVecIArray3[n3] = iCurveI.pt((double)n3 / (double)n2);
            }
        }
        IVecI[][] iVecIArray4 = ISurfaceCreator.sweepPoints(iVecIArray2, 1, iVec3, iVec4, iVecIArray3, 1);
        return IMeshCreator.stick(iVecIArray4, bl);
    }

    public static IMesh polygonStick(ICurveI iCurveI, double d, int n) {
        int n2 = iCurveI.epNum() * IConfig.segmentResolution;
        return IMeshCreator.polygonStick(iCurveI, d, n, n2);
    }

    public static IMesh roundStick(ICurveI iCurveI, double d, int n) {
        return IMeshCreator.polygonStick(iCurveI, d, IConfig.meshCircleResolution, n);
    }

    public static IMesh roundStick(ICurveI iCurveI, double d) {
        int n = iCurveI.epNum() * IConfig.segmentResolution;
        return IMeshCreator.polygonStick(iCurveI, d, IConfig.meshCircleResolution, n);
    }

    public static IMesh stick(ICurveI iCurveI, double d, int n) {
        return IMeshCreator.roundStick(iCurveI, d, n);
    }

    public static IMesh stick(ICurveI iCurveI, double d) {
        return IMeshCreator.roundStick(iCurveI, d);
    }

    public static IMesh squareStick(ICurveI iCurveI, double d, int n) {
        return IMeshCreator.polygonStick(iCurveI, d, 4, n);
    }

    public static IMesh squareStick(ICurveI iCurveI, double d) {
        int n = iCurveI.epNum() * IConfig.segmentResolution;
        return IMeshCreator.polygonStick(iCurveI, d, 4, n);
    }

    public static IMesh thicken(IMeshI iMeshI, double d, boolean bl, IMeshType iMeshType) {
        if (bl && iMeshI instanceof IMesh) {
            return IMeshCreator.thicken((IMesh)iMeshI, d, null);
        }
        IMesh iMesh = null;
        iMesh = iMeshI instanceof IMesh ? (IMesh)iMeshI.dup() : new IMesh(iMeshI.get());
        return IMeshCreator.thicken(iMesh, d, null, iMeshType);
    }

    public static IMesh thicken(IMeshI iMeshI, double d, IVecI iVecI, boolean bl, IMeshType iMeshType) {
        if (bl && iMeshI instanceof IMesh) {
            return IMeshCreator.thicken((IMesh)iMeshI, d, iVecI, iMeshType);
        }
        IMesh iMesh = null;
        iMesh = iMeshI instanceof IMesh ? (IMesh)iMeshI.dup() : new IMesh(iMeshI.get());
        return IMeshCreator.thicken(iMesh, d, iVecI, iMeshType);
    }

    public static IMesh thicken(IMesh iMesh, double d, IMeshType iMeshType) {
        return IMeshCreator.thicken(iMesh, d, null, iMeshType);
    }

    public static IMesh thicken(IMesh iMesh, double d, IVecI iVecI, IMeshType iMeshType) {
        int n;
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        IMeshCreator.offset(iMesh, d, iVecI, arrayList, arrayList2, arrayList3);
        ArrayList<IEdge> arrayList4 = iMesh.mesh.nakedEdges(true);
        ArrayList<IEdge> arrayList5 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList6 = new ArrayList<IFace>();
        int[] nArray = new int[iMesh.vertexNum()];
        Arrays.fill(nArray, -1);
        for (n = 0; n < arrayList4.size(); ++n) {
            IEdge iEdge = arrayList4.get(n);
            int n2 = iMesh.vertices().indexOf(iEdge.vertex(0));
            IEdge iEdge2 = null;
            if (nArray[n2] < 0) {
                iEdge2 = new IEdge(iEdge.vertex(0), arrayList.get(n2));
                arrayList5.add(iEdge2);
                nArray[n2] = arrayList5.size() - 1;
            } else {
                iEdge2 = (IEdge)arrayList5.get(nArray[n2]);
            }
            int n3 = iMesh.vertices().indexOf(iEdge.vertex(1));
            IEdge iEdge3 = null;
            if (nArray[n3] < 0) {
                iEdge3 = new IEdge(iEdge.vertex(1), arrayList.get(n3));
                arrayList5.add(iEdge3);
                nArray[n3] = arrayList5.size() - 1;
            } else {
                iEdge3 = (IEdge)arrayList5.get(nArray[n3]);
            }
            arrayList6.add(new IFace(iEdge, iEdge3, arrayList2.get(iMesh.edges().indexOf(iEdge)), iEdge2));
        }
        if (d > 0.0) {
            for (n = 0; n < iMesh.vertexNum(); ++n) {
                if (iMesh.vertex((int)n).normal == null) continue;
                iMesh.vertex((int)n).normal.neg();
            }
            for (n = 0; n < iMesh.faceNum(); ++n) {
                iMesh.face(n).flipNormal();
            }
        } else if (d < 0.0) {
            for (n = 0; n < arrayList.size(); ++n) {
                if (arrayList.get((int)n).normal == null) continue;
                arrayList.get((int)n).normal.neg();
            }
            for (n = 0; n < arrayList3.size(); ++n) {
                arrayList3.get(n).flipNormal();
            }
            for (n = 0; n < arrayList6.size(); ++n) {
                ((IFace)arrayList6.get(n)).flipNormal();
            }
        }
        iMesh.vertices().addAll(arrayList);
        iMesh.edges().addAll(arrayList2);
        iMesh.edges().addAll(arrayList5);
        iMesh.faces().addAll(arrayList3);
        iMesh.faces().addAll(arrayList6);
        iMesh.close();
        return iMesh;
    }

    public static IMesh offset(IMeshI iMeshI, double d, IMeshType iMeshType) {
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        ArrayList<IEdge> arrayList2 = new ArrayList<IEdge>();
        ArrayList<IFace> arrayList3 = new ArrayList<IFace>();
        IMeshCreator.offset(iMeshI, d, null, arrayList, arrayList2, arrayList3);
        IMesh iMesh = new IMesh(iMeshType.createMesh(arrayList, arrayList2, arrayList3));
        if (iMeshI instanceof IObject) {
            iMesh.attr((IObject)((Object)iMeshI));
        }
        return iMesh;
    }

    public static void offset(IMeshI iMeshI, double d, IVecI iVecI, ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        int n;
        Object object;
        int n2;
        IVec iVec = null;
        if (iVecI != null) {
            iVec = iVecI.get().dup().len(d);
        }
        for (n2 = 0; n2 < iMeshI.vertexNum(); ++n2) {
            object = iMeshI.vertex(n2).normal().get();
            if (iVecI == null) {
                iVec = ((IVec)object).dup().len(d);
            }
            IVertex iVertex = new IVertex(iMeshI.vertex(n2).get().dup());
            iVertex.add(iVec);
            iVertex.nml((IVecI)object);
            arrayList.add(iVertex);
        }
        for (n2 = 0; n2 < iMeshI.edgeNum(); ++n2) {
            object = iMeshI.edge(n2);
            int n3 = iMeshI.vertices().indexOf(((IEdge)object).vertices[0]);
            n = iMeshI.vertices().indexOf(((IEdge)object).vertices[1]);
            arrayList2.add(new IEdge(arrayList.get(n3), arrayList.get(n)));
        }
        for (n2 = 0; n2 < iMeshI.faceNum(); ++n2) {
            object = iMeshI.face(n2);
            IEdge[] iEdgeArray = new IEdge[((IFace)object).edgeNum()];
            for (n = 0; n < ((IFace)object).edgeNum(); ++n) {
                int n4 = iMeshI.edges().indexOf(((IFace)object).edge(n));
                iEdgeArray[n] = arrayList2.get(n4);
            }
            arrayList3.add(new IFace(iEdgeArray));
        }
    }

    public static IMesh diamondTessellation(IMeshI iMeshI, boolean bl, boolean bl2, IMeshType iMeshType) {
        int n;
        int n2;
        Object object;
        IFace[][] iFaceArrayArray;
        IVertex[] iVertexArray = new IVertex[iMeshI.edgeNum()];
        IEdge[][] iEdgeArray = new IEdge[iMeshI.edgeNum()][2];
        for (int i = 0; i < iMeshI.edgeNum(); ++i) {
            iFaceArrayArray = iMeshI.edge(i);
            iVertexArray[i] = iMeshType.createVertex(iFaceArrayArray.vertex(0).mid(iFaceArrayArray.vertex(1)));
            iEdgeArray[i][0] = iMeshType.createEdge(iFaceArrayArray.vertex(0), iVertexArray[i]);
            iEdgeArray[i][1] = iMeshType.createEdge(iVertexArray[i], iFaceArrayArray.vertex(1));
        }
        IEdge[][] iEdgeArrayArray = new IEdge[iMeshI.faceNum()][];
        iFaceArrayArray = new IFace[iMeshI.faceNum()][];
        IFace[] iFaceArray = null;
        IEdge[] iEdgeArray2 = null;
        IFace[][] iFaceArray2 = null;
        if (bl) {
            iEdgeArray2 = new IEdge[iMeshI.faceNum()];
            iFaceArray2 = new IFace[iMeshI.faceNum()][2];
        } else {
            iFaceArray = new IFace[iMeshI.faceNum()];
        }
        for (int i = 0; i < iMeshI.faceNum(); ++i) {
            object = iMeshI.face(i);
            int n3 = ((IFace)object).edgeNum();
            iEdgeArrayArray[i] = new IEdge[n3];
            iFaceArrayArray[i] = new IFace[n3];
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = iMeshI.edges().indexOf(((IFace)object).edge(n2));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                iEdgeArrayArray[i][n2] = iMeshType.createEdge(iVertexArray[nArray[n2]], iVertexArray[nArray[(n2 + 1) % n3]]);
                iFaceArrayArray[i][n2] = iMeshType.createFace(iEdgeArray[nArray[n2]][1], iEdgeArray[nArray[(n2 + 1) % n3]][0], iEdgeArrayArray[i][n2]);
            }
            if (bl) {
                if (n3 == 4) {
                    if (bl2) {
                        iEdgeArray2[i] = iMeshType.createEdge(iVertexArray[nArray[0]], iVertexArray[nArray[2]]);
                        iFaceArray2[i][0] = iMeshType.createFace(iEdgeArrayArray[i][0], iEdgeArrayArray[i][1], iEdgeArray2[i]);
                        iFaceArray2[i][1] = iMeshType.createFace(iEdgeArrayArray[i][2], iEdgeArrayArray[i][3], iEdgeArray2[i]);
                        continue;
                    }
                    iEdgeArray2[i] = iMeshType.createEdge(iVertexArray[nArray[1]], iVertexArray[nArray[3]]);
                    iFaceArray2[i][0] = iMeshType.createFace(iEdgeArrayArray[i][1], iEdgeArrayArray[i][2], iEdgeArray2[i]);
                    iFaceArray2[i][1] = iMeshType.createFace(iEdgeArrayArray[i][3], iEdgeArrayArray[i][0], iEdgeArray2[i]);
                    continue;
                }
                iEdgeArray2[i] = null;
                iFaceArray2[i][0] = iMeshType.createFace(iEdgeArrayArray[i]);
                iFaceArray2[i][1] = null;
                continue;
            }
            iFaceArray[i] = iMeshType.createFace(iEdgeArrayArray[i]);
        }
        ArrayList<IVertex> arrayList = new ArrayList<IVertex>();
        object = new ArrayList();
        ArrayList<IFace> arrayList2 = new ArrayList<IFace>();
        for (n = 0; n < iMeshI.vertexNum(); ++n) {
            arrayList.add(iMeshI.vertex(n));
        }
        for (n = 0; n < iVertexArray.length; ++n) {
            arrayList.add(iVertexArray[n]);
        }
        for (n = 0; n < iEdgeArray.length; ++n) {
            ((ArrayList)object).add(iEdgeArray[n][0]);
            ((ArrayList)object).add(iEdgeArray[n][1]);
        }
        for (n = 0; n < iEdgeArrayArray.length; ++n) {
            for (n2 = 0; n2 < iEdgeArrayArray[n].length; ++n2) {
                ((ArrayList)object).add(iEdgeArrayArray[n][n2]);
            }
        }
        if (bl) {
            for (n = 0; n < iEdgeArray2.length; ++n) {
                if (iEdgeArray2[n] == null) continue;
                ((ArrayList)object).add(iEdgeArray2[n]);
            }
            for (n = 0; n < iFaceArray2.length; ++n) {
                for (n2 = 0; n2 < iFaceArray2[n].length; ++n2) {
                    if (iFaceArray2[n][n2] == null) continue;
                    arrayList2.add(iFaceArray2[n][n2]);
                }
            }
        } else {
            for (n = 0; n < iFaceArray.length; ++n) {
                arrayList2.add(iFaceArray[n]);
            }
        }
        for (n = 0; n < iFaceArrayArray.length; ++n) {
            for (n2 = 0; n2 < iFaceArrayArray[n].length; ++n2) {
                arrayList2.add(iFaceArrayArray[n][n2]);
            }
        }
        IMesh iMesh = new IMesh(iMeshType.createMesh(arrayList, (ArrayList<IEdge>)object, arrayList2));
        if (iMeshI instanceof IObject) {
            iMesh.attr((IObject)((Object)iMeshI));
        }
        return iMesh;
    }
}

