/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IOut;
import igeo.gui.IPane;
import igeo.gui.IPaneLight;
import igeo.gui.IScreenTogglePanel;
import igeo.gui.IView;

public class IGridPanel
extends IScreenTogglePanel {
    public IPane[][] gridPanes;
    public int xnum;
    public int ynum;
    public double[] widthRatio;
    public double[] heightRatio;

    public IGridPanel(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4);
        this.setupGrid(n5, n6, (IPane[][])null);
        this.currentMousePane = this.gridPanes[1][0];
    }

    public IGridPanel(int n, int n2, int n3, int n4, int n5, int n6, IPane[][] iPaneArray) {
        super(n, n2, n3, n4);
        this.setupGrid(n5, n6, iPaneArray);
        if (this.gridPanes.length > 1 && this.gridPanes[1].length > 0) {
            this.currentMousePane = this.gridPanes[1][0];
        } else if (this.gridPanes.length > 0 && this.gridPanes[0].length > 0) {
            this.currentMousePane = this.gridPanes[0][0];
        } else {
            IOut.err("no panes in IGridPanel.gridPanes[][]");
        }
    }

    public void setupGrid(int n, int n2, IPane[][] iPaneArray) {
        int n3;
        if (n <= 0 || n2 <= 0) {
            IOut.err("xnum and ynum need to be larger than 1");
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n2];
        for (n3 = 0; n3 < n; ++n3) {
            dArray[n3] = 1.0 / (double)n;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dArray2[n3] = 1.0 / (double)n2;
        }
        this.setupGrid(dArray, dArray2, iPaneArray);
    }

    public void setupGrid(double[] dArray, double[] dArray2, IPane[][] iPaneArray) {
        this.widthRatio = dArray;
        this.heightRatio = dArray2;
        if (dArray == null || dArray2 == null) {
            IOut.err("widthRatio or heightRatio is null");
            return;
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            IOut.err("ength of widthRatio or heightRatio is zero");
            return;
        }
        this.xnum = dArray.length;
        this.ynum = dArray2.length;
        int[] nArray = IGridPanel.getPositionArrayFromRatio(dArray, this.width);
        int[] nArray2 = IGridPanel.getPositionArrayFromRatio(dArray2, this.height);
        if (this.gridPanes == null || this.gridPanes.length != this.xnum || this.gridPanes[0].length != this.ynum || iPaneArray != null) {
            int n;
            int n2;
            this.gridPanes = new IPane[this.xnum][this.ynum];
            for (n2 = 0; n2 < this.xnum; ++n2) {
                for (n = 0; n < this.ynum; ++n) {
                    IView iView = null;
                    int n3 = this.x + nArray[n2];
                    int n4 = this.y + nArray2[n];
                    int n5 = nArray[n2 + 1] - nArray[n2];
                    int n6 = nArray2[n + 1] - nArray2[n];
                    boolean bl = false;
                    if (this.xnum == 2 && this.ynum == 2) {
                        if (n2 == 0 && n == 0) {
                            iView = IView.getTopView(n3, n4, n5, n6);
                            bl = true;
                        } else if (n2 == 1 && n == 0) {
                            iView = IView.getDefaultPerspectiveView(n3, n4, n5, n6);
                        } else if (n2 == 0 && n == 1) {
                            iView = IView.getFrontView(n3, n4, n5, n6);
                            bl = true;
                        } else if (n2 == 1 && n == 1) {
                            iView = IView.getRightView(n3, n4, n5, n6);
                            bl = true;
                        }
                    } else {
                        iView = IView.getDefaultAxonometricView(n3, n4, n5, n6);
                    }
                    iView.enableGL();
                    iView.enableRotationAroundTarget();
                    iView.setTarget(0.0, 0.0, 0.0);
                    if (iPaneArray != null && n2 < iPaneArray.length && n < iPaneArray[n2].length && iPaneArray[n2][n] != null) {
                        this.gridPanes[n2][n] = iPaneArray[n2][n];
                        this.gridPanes[n2][n].setBounds(n3, n4, n5, n6);
                        this.gridPanes[n2][n].setPanel(this);
                        this.gridPanes[n2][n].setView(iView);
                    } else {
                        this.gridPanes[n2][n] = new IPaneLight(n3, n4, n5, n6, iView, this);
                    }
                    if (!bl || this.gridPanes[n2][n].navigator() == null) continue;
                    this.gridPanes[n2][n].navigator().setRotateLock(true);
                }
            }
            if (super.paneNum() > 0) {
                super.clearPane();
            }
            for (n2 = 0; n2 < this.xnum; ++n2) {
                for (n = 0; n < this.ynum; ++n) {
                    super.addPane(this.gridPanes[n2][n]);
                }
            }
        } else {
            for (int i = 0; i < this.xnum; ++i) {
                for (int j = 0; j < this.ynum; ++j) {
                    this.gridPanes[i][j].setBounds(this.x + nArray[i], this.y + nArray2[j], nArray[i + 1] - nArray[i], nArray2[j + 1] - nArray2[j]);
                }
            }
        }
    }

    public static int[] getPositionArrayFromRatio(double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        dArray2[0] = dArray[0];
        for (int i = 1; i < n2; ++i) {
            dArray2[i] = dArray2[i - 1] + dArray[i];
        }
        int[] nArray = new int[n2 + 1];
        nArray[0] = 0;
        for (int i = 0; i < n2; ++i) {
            nArray[i + 1] = (int)(dArray2[i] / dArray2[n2 - 1] * (double)n);
        }
        return nArray;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        int[] nArray = IGridPanel.getPositionArrayFromRatio(this.widthRatio, n);
        int[] nArray2 = IGridPanel.getPositionArrayFromRatio(this.heightRatio, n2);
        for (int i = 0; i < this.xnum; ++i) {
            for (int j = 0; j < this.ynum; ++j) {
                if (this.fullScreenPane != this.gridPanes[i][j]) {
                    this.gridPanes[i][j].setBounds(this.x + nArray[i], this.y + nArray2[j], nArray[i + 1] - nArray[i], nArray2[j + 1] - nArray2[j]);
                    continue;
                }
                this.gridPanes[i][j].setBounds(this.x, this.y, this.width, this.height);
                this.fullPaneOrigX = this.x + nArray[i];
                this.fullPaneOrigY = this.y + nArray2[j];
                this.fullPaneOrigWidth = nArray[i + 1] - nArray[i];
                this.fullPaneOrigHeight = nArray2[j + 1] - nArray2[j];
            }
        }
        this.sizeChanged = true;
    }
}

