/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.ICurve;
import igeo.IG;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IServerI;
import igeo.IUnit;
import igeo.IVec;
import igeo.IVecI;
import igeo.io.IEsri;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class IShapeFileImporter {
    static Constraint constraint = null;

    public static byte[] copy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i + n];
        }
        return byArray2;
    }

    public static boolean checkBufLen(byte[] byArray, int n, int n2) {
        if (byArray.length - n < n2) {
            IG.err("too short buffer (buf.len=" + byArray.length + ", idx=" + n + ", len=" + n2);
            return false;
        }
        return true;
    }

    public static long readIntBE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            return -1L;
        }
        return (long)(n & 0xFF) << 24 | (long)(n2 & 0xFF) << 16 | (long)(n3 & 0xFF) << 8 | (long)(n4 & 0xFF);
    }

    public static int readShortBE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n2 < 0) {
            return -1;
        }
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }

    public static long readIntBE(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 4)) {
            IG.err();
            return 0L;
        }
        return (long)(byArray[n] << 24) & 0xFFFFFFFFFF000000L | (long)(byArray[n + 1] << 16) & 0xFF0000L | (long)(byArray[n + 2] << 8) & 0xFF00L | (long)byArray[n + 3] & 0xFFL;
    }

    public static long readIntLE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n4 < 0) {
            return -1L;
        }
        return (long)(n4 & 0xFF) << 24 | (long)(n3 & 0xFF) << 16 | (long)(n2 & 0xFF) << 8 | (long)(n & 0xFF);
    }

    public static int readShortLE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n2 < 0) {
            return -1;
        }
        return (n2 & 0xFF) << 8 | n & 0xFF;
    }

    public static long readIntLE(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 4)) {
            IG.err();
            return 0L;
        }
        return (long)(byArray[n + 3] << 24) & 0xFFFFFFFFFF000000L | (long)byArray[n + 2] << 16 & 0xFF0000L | (long)(byArray[n + 1] << 8) & 0xFF00L | (long)byArray[n] & 0xFFL;
    }

    public static double readDoubleLE(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        int n6 = inputStream.read();
        int n7 = inputStream.read();
        int n8 = inputStream.read();
        if (n8 < 0) {
            return 0.0;
        }
        long l = (long)(n8 & 0xFF) << 56 | (long)(n7 & 0xFF) << 48 | (long)(n6 & 0xFF) << 40 | (long)(n5 & 0xFF) << 32 | (long)(n4 & 0xFF) << 24 | (long)(n3 & 0xFF) << 16 | (long)(n2 & 0xFF) << 8 | (long)(n & 0xFF);
        return Double.longBitsToDouble(l);
    }

    public static double readDoubleLE(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 8)) {
            IG.err();
            return 0.0;
        }
        long l = (long)(byArray[n + 7] & 0xFF) << 56 | (long)(byArray[n + 6] & 0xFF) << 48 | (long)(byArray[n + 5] & 0xFF) << 40 | (long)(byArray[n + 4] & 0xFF) << 32 | (long)(byArray[n + 3] & 0xFF) << 24 | (long)(byArray[n + 2] & 0xFF) << 16 | (long)(byArray[n + 1] & 0xFF) << 8 | (long)(byArray[n] & 0xFF);
        return Double.longBitsToDouble(l);
    }

    public static void readSHPHeader(InputStream inputStream) {
        byte[] byArray = new byte[100];
        try {
            inputStream.read(byArray, 0, 100);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        long l = IShapeFileImporter.readIntBE(byArray, 0);
        long l2 = IShapeFileImporter.readIntBE(byArray, 24);
        long l3 = IShapeFileImporter.readIntLE(byArray, 28);
        long l4 = IShapeFileImporter.readIntLE(byArray, 32);
    }

    public static boolean readSHPRecord(InputStream inputStream, boolean bl, ArrayList<IObject[]> arrayList) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            l = IShapeFileImporter.readIntBE(inputStream);
            if (l < 0L) {
                return false;
            }
            l2 = IShapeFileImporter.readIntBE(inputStream);
            if ((l2 *= 2L) < 0L) {
                IG.err("contentLength is negative " + l2);
                return false;
            }
            if (bl) {
                IShapeFileImporter.skip(inputStream, l2);
                return true;
            }
            IOut.debug(30, "recordNumber = " + l);
            IOut.debug(30, "contentLength = " + l2);
            l3 = IShapeFileImporter.readIntLE(inputStream);
            l2 -= 4L;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = 0;
        switch ((int)l3) {
            case 0: {
                IOut.debug(30, "reading Null Shape");
                break;
            }
            case 1: {
                IOut.debug(30, "reading Point Shape");
                n = IShapeFileImporter.makePoint(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 8: {
                IOut.debug(30, "reading MultiPoint Shape");
                n = IShapeFileImporter.makeMultiPoint(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 3: {
                IOut.debug(30, "reading Polyline Shape");
                n = IShapeFileImporter.makePolyline(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 5: {
                IOut.debug(30, "reading Polygon Shape");
                n = IShapeFileImporter.makePolyline(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 21: {
                IOut.debug(30, "reading PointM Shape");
                n = IShapeFileImporter.makePoint(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 28: {
                IOut.debug(30, "reading MultiPointM Shape");
                n = IShapeFileImporter.makeMultiPoint(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 23: {
                IOut.debug(30, "reading PolylineM Shape");
                n = IShapeFileImporter.makePolyline(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 25: {
                IOut.debug(30, "reading PolygonM Shape");
                n = IShapeFileImporter.makePolyline(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 11: {
                IOut.debug(30, "reading PointZ Shape");
                n = IShapeFileImporter.makePointZ(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 18: {
                IOut.debug(30, "reading MultiPointZ Shape");
                n = IShapeFileImporter.makeMultiPointZ(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 13: {
                IOut.debug(30, "reading PolylineZ Shape");
                n = IShapeFileImporter.makePolylineZ(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 15: {
                IOut.debug(30, "reading PolygonZ Shape");
                n = IShapeFileImporter.makePolylineZ(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            case 31: {
                IOut.debug(30, "reading MultiPatch Shape");
                n = IShapeFileImporter.makeMultiPatch(inputStream, (int)l, (int)l2, arrayList);
                break;
            }
            default: {
                IG.err("unknown shape type " + l3);
            }
        }
        if ((l2 -= (long)n) > 0L) {
            try {
                IShapeFileImporter.skip(inputStream, l2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (l2 < 0L) {
            IG.err("over read the stream");
        }
        return true;
    }

    public static void skip(InputStream inputStream, long l) throws IOException {
        inputStream.skip(l);
    }

    public static IVec readPoint(InputStream inputStream) throws IOException {
        double d = IShapeFileImporter.readDoubleLE(inputStream);
        double d2 = IShapeFileImporter.readDoubleLE(inputStream);
        return new IVec(d, d2, 0.0);
    }

    public static IVec readPoint(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 16)) {
            IG.err();
            return new IVec();
        }
        double d = IShapeFileImporter.readDoubleLE(byArray, n);
        double d2 = IShapeFileImporter.readDoubleLE(byArray, n + 8);
        return new IVec(d, d2, 0.0);
    }

    public static IVec readPointZ(InputStream inputStream, int n) throws IOException {
        double d = IShapeFileImporter.readDoubleLE(inputStream);
        double d2 = IShapeFileImporter.readDoubleLE(inputStream);
        double d3 = IShapeFileImporter.readDoubleLE(inputStream);
        if (n > 24) {
            double d4 = IShapeFileImporter.readDoubleLE(inputStream);
        }
        return new IVec(d, d2, d3);
    }

    public static IVec readPointZ(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, n, 24)) {
            IG.err();
            return new IVec();
        }
        double d = IShapeFileImporter.readDoubleLE(byArray, n);
        double d2 = IShapeFileImporter.readDoubleLE(byArray, n + 8);
        double d3 = IShapeFileImporter.readDoubleLE(byArray, n + 16);
        return new IVec(d, d2, d3);
    }

    public static IVec[] readPoints(InputStream inputStream, int n) throws IOException {
        IVec[] iVecArray = new IVec[n];
        for (int i = 0; i < n; ++i) {
            iVecArray[i] = IShapeFileImporter.readPoint(inputStream);
        }
        return iVecArray;
    }

    public static IVec[] readPoints(byte[] byArray, int n, int n2) {
        if (!IShapeFileImporter.checkBufLen(byArray, n2, 16 * n)) {
            IG.err();
            return null;
        }
        IVec[] iVecArray = new IVec[n];
        for (int i = 0; i < n; ++i) {
            iVecArray[i] = IShapeFileImporter.readPoint(byArray, n2 + 16 * i);
        }
        return iVecArray;
    }

    public static int[] readIntegers(byte[] byArray, int n, int n2) {
        if (!IShapeFileImporter.checkBufLen(byArray, n2, 4 * n)) {
            IG.err();
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)IShapeFileImporter.readIntLE(byArray, n2 + 4 * i);
        }
        return nArray;
    }

    public static int[] readIntegers(InputStream inputStream, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)IShapeFileImporter.readIntLE(inputStream);
        }
        return nArray;
    }

    public static double[] readDoubles(InputStream inputStream, int n) throws IOException {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = IShapeFileImporter.readDoubleLE(inputStream);
        }
        return dArray;
    }

    public static double[] readDoubles(byte[] byArray, int n, int n2) {
        if (!IShapeFileImporter.checkBufLen(byArray, n2, 8 * n)) {
            IG.err();
            return null;
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = IShapeFileImporter.readDoubleLE(byArray, n2 + 8 * i);
        }
        return dArray;
    }

    public static void makePoint(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, 0, 20)) {
            IG.err();
            return;
        }
        IVec iVec = IShapeFileImporter.readPoint(byArray, 4);
        IPoint iPoint = new IPoint(iVec);
        iPoint.name(String.valueOf(n));
    }

    public static int makePoint(InputStream inputStream, int n, int n2, ArrayList<IObject[]> arrayList) {
        int n3 = 0;
        try {
            IVec iVec = IShapeFileImporter.readPoint(inputStream);
            n3 += 16;
            IPoint iPoint = new IPoint(iVec);
            iPoint.name(String.valueOf(n));
            arrayList.add(new IObject[]{iPoint});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static void makePointZ(byte[] byArray, int n) {
        if (!IShapeFileImporter.checkBufLen(byArray, 0, 36)) {
            IG.err();
            return;
        }
        IVec iVec = IShapeFileImporter.readPointZ(byArray, 4);
        IPoint iPoint = new IPoint(iVec);
        iPoint.name(String.valueOf(n));
    }

    public static int makePointZ(InputStream inputStream, int n, int n2, ArrayList<IObject[]> arrayList) {
        int n3 = 0;
        try {
            IVec iVec = IShapeFileImporter.readPointZ(inputStream, n2);
            n3 = n2 > 24 ? (n3 += 32) : (n3 += 24);
            IPoint iPoint = new IPoint(iVec);
            iPoint.name(String.valueOf(n));
            arrayList.add(new IObject[]{iPoint});
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static void makeMultiPoint(byte[] byArray, int n) {
        long l = IShapeFileImporter.readIntLE(byArray, 36);
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, (int)l, 40);
        if (iVecArray == null) {
            IG.err();
            return;
        }
        int n2 = 0;
        while ((long)n2 < l) {
            if (iVecArray[n2] != null) {
                IPoint iPoint = new IPoint(iVecArray[n2]);
                iPoint.name(String.valueOf(n));
            }
            ++n2;
        }
    }

    public static int makeMultiPoint(InputStream inputStream, int n, int n2, ArrayList<IObject[]> arrayList) {
        int n3 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n3 += 32;
            long l = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, (int)l);
            n3 = (int)((long)n3 + 16L * l);
            if (iVecArray == null) {
                IG.err();
                return n3;
            }
            ArrayList<IPoint> arrayList2 = new ArrayList<IPoint>();
            int n4 = 0;
            while ((long)n4 < l) {
                if (iVecArray[n4] != null) {
                    IPoint iPoint = new IPoint(iVecArray[n4]);
                    iPoint.name(String.valueOf(n));
                    arrayList2.add(iPoint);
                }
                ++n4;
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static void makeMultiPointZ(byte[] byArray, int n) {
        long l = IShapeFileImporter.readIntLE(byArray, 36);
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, (int)l, 40);
        if (iVecArray == null) {
            IG.err();
            return;
        }
        double[] dArray = IShapeFileImporter.readDoubles(byArray, (int)l, (int)(40L + l * 16L));
        if (dArray == null) {
            IG.err();
            return;
        }
        int n2 = 0;
        while ((long)n2 < l) {
            if (iVecArray[n2] != null) {
                iVecArray[n2].z = dArray[n2];
                IPoint iPoint = new IPoint(iVecArray[n2]);
                iPoint.name(String.valueOf(n));
            }
            ++n2;
        }
    }

    public static int makeMultiPointZ(InputStream inputStream, int n, int n2, ArrayList<IObject[]> arrayList) {
        int n3 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n3 += 32;
            long l = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, (int)l);
            n3 = (int)((long)n3 + l * 16L);
            if (iVecArray == null) {
                IG.err();
                return n3;
            }
            IShapeFileImporter.skip(inputStream, 16L);
            n3 += 16;
            double[] dArray = IShapeFileImporter.readDoubles(inputStream, (int)l);
            n3 = (int)((long)n3 + 8L * l);
            if (dArray == null) {
                IG.err();
                return n3;
            }
            ArrayList<IPoint> arrayList2 = new ArrayList<IPoint>();
            int n4 = 0;
            while ((long)n4 < l) {
                if (iVecArray[n4] != null && (constraint == null || constraint != null && constraint.validate(iVecArray[n4].x, iVecArray[n4].y, iVecArray[n4].z))) {
                    iVecArray[n4].z = dArray[n4];
                    IPoint iPoint = new IPoint(iVecArray[n4]);
                    iPoint.name(String.valueOf(n));
                    arrayList2.add(iPoint);
                }
                ++n4;
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static void makePolyline(byte[] byArray, int n) {
        long l = IShapeFileImporter.readIntLE(byArray, 36);
        long l2 = IShapeFileImporter.readIntLE(byArray, 40);
        int[] nArray = IShapeFileImporter.readIntegers(byArray, (int)l, 44);
        if (nArray == null) {
            IG.err();
            return;
        }
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, (int)l2, (int)(44L + 4L * l));
        if (iVecArray == null) {
            IG.err();
            return;
        }
        int n2 = 0;
        while ((long)n2 < l) {
            int n3 = 0;
            n3 = (long)nArray[n2] < l - 1L ? nArray[n2 + 1] - nArray[n2] : (int)l2 - nArray[n2];
            if (n3 > 0 && (long)(n3 + nArray[n2]) < l2) {
                IVecI[] iVecIArray = new IVec[n3];
                for (int i = 0; i < n3; ++i) {
                    iVecIArray[i] = iVecArray[nArray[n2] + i];
                }
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
            }
            ++n2;
        }
    }

    public static int makePolyline(InputStream inputStream, int n, int n2, ArrayList<IObject[]> arrayList) {
        int n3 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n3 += 32;
            long l = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            long l2 = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            int[] nArray = IShapeFileImporter.readIntegers(inputStream, (int)l);
            n3 = (int)((long)n3 + l * 4L);
            if (nArray == null) {
                IG.err();
                return n3;
            }
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, (int)l2);
            n3 = (int)((long)n3 + l2 * 16L);
            if (iVecArray == null) {
                IG.err();
                return n3;
            }
            ArrayList<ICurve> arrayList2 = new ArrayList<ICurve>();
            int n4 = 0;
            while ((long)n4 < l) {
                int n5 = 0;
                n5 = (long)n4 < l - 1L ? nArray[n4 + 1] - nArray[n4] : (int)l2 - nArray[n4];
                if (n5 > 0 && (long)(n5 + nArray[n4]) <= l2) {
                    IVecI[] iVecIArray = new IVec[n5];
                    for (int i = 0; i < n5; ++i) {
                        iVecIArray[i] = iVecArray[nArray[n4] + i];
                    }
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                }
                ++n4;
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static void makePolylineZ(byte[] byArray, int n) {
        long l = IShapeFileImporter.readIntLE(byArray, 36);
        long l2 = IShapeFileImporter.readIntLE(byArray, 40);
        int[] nArray = IShapeFileImporter.readIntegers(byArray, (int)l, 44);
        if (nArray == null) {
            IG.err();
            return;
        }
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, (int)l2, (int)(44L + 4L * l));
        if (iVecArray == null) {
            IG.err();
            return;
        }
        double[] dArray = IShapeFileImporter.readDoubles(byArray, (int)l2, (int)(44L + 4L * l + 16L * l2 + 16L));
        if (dArray == null) {
            IG.err();
            return;
        }
        int n2 = 0;
        while ((long)n2 < l2) {
            if (iVecArray[n2] != null) {
                iVecArray[n2].z = dArray[n2];
            }
            ++n2;
        }
        n2 = 0;
        while ((long)n2 < l) {
            int n3 = 0;
            n3 = (long)nArray[n2] < l - 1L ? nArray[n2 + 1] - nArray[n2] : (int)l2 - nArray[n2];
            if (n3 > 0 && (long)(n3 + nArray[n2]) < l2) {
                IVecI[] iVecIArray = new IVec[n3];
                for (int i = 0; i < n3; ++i) {
                    iVecIArray[i] = iVecArray[nArray[n2] + i];
                }
                ICurve iCurve = new ICurve(iVecIArray);
                iCurve.name(String.valueOf(n));
            }
            ++n2;
        }
    }

    public static int makePolylineZ(InputStream inputStream, int n, int n2, ArrayList<IObject[]> arrayList) {
        int n3 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n3 += 32;
            long l = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            long l2 = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            int[] nArray = IShapeFileImporter.readIntegers(inputStream, (int)l);
            n3 = (int)((long)n3 + 4L * l);
            if (nArray == null) {
                IG.err();
                return n3;
            }
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, (int)l2);
            n3 = (int)((long)n3 + 16L * l2);
            if (iVecArray == null) {
                IG.err();
                return n3;
            }
            IShapeFileImporter.skip(inputStream, 16L);
            n3 += 16;
            double[] dArray = IShapeFileImporter.readDoubles(inputStream, (int)l2);
            n3 = (int)((long)n3 + l2 * 8L);
            if (dArray == null) {
                IG.err();
                return n3;
            }
            int n4 = 0;
            while ((long)n4 < l2) {
                if (iVecArray[n4] != null) {
                    iVecArray[n4].z = dArray[n4];
                }
                ++n4;
            }
            ArrayList<ICurve> arrayList2 = new ArrayList<ICurve>();
            int n5 = 0;
            while ((long)n5 < l) {
                int n6 = 0;
                n6 = (long)n5 < l - 1L ? nArray[n5 + 1] - nArray[n5] : (int)l2 - nArray[n5];
                if (n6 > 0 && (long)(n6 + nArray[n5]) <= l2) {
                    IVecI[] iVecIArray = new IVec[n6];
                    for (int i = 0; i < n6; ++i) {
                        iVecIArray[i] = iVecArray[nArray[n5] + i];
                    }
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                    arrayList2.add(iCurve);
                }
                ++n5;
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static void makeMultiPatch(byte[] byArray, int n) {
        long l = IShapeFileImporter.readIntLE(byArray, 36);
        long l2 = IShapeFileImporter.readIntLE(byArray, 40);
        int[] nArray = IShapeFileImporter.readIntegers(byArray, (int)l, 44);
        if (nArray == null) {
            IG.err();
            return;
        }
        int[] nArray2 = IShapeFileImporter.readIntegers(byArray, (int)l, (int)(44L + l * 4L));
        if (nArray2 == null) {
            IG.err();
            return;
        }
        IVec[] iVecArray = IShapeFileImporter.readPoints(byArray, (int)l2, (int)(44L + 4L * l + 4L * l));
        if (iVecArray == null) {
            IG.err();
            return;
        }
        double[] dArray = IShapeFileImporter.readDoubles(byArray, (int)l2, (int)(44L + 4L * l + 4L * l + 16L * l2 + 16L));
        if (dArray == null) {
            IG.err();
            return;
        }
        int n2 = 0;
        while ((long)n2 < l2) {
            if (iVecArray[n2] != null) {
                iVecArray[n2].z = dArray[n2];
            }
            ++n2;
        }
        n2 = 0;
        while ((long)n2 < l) {
            int n3 = 0;
            n3 = (long)n2 < l - 1L ? nArray[n2 + 1] - nArray[n2] : (int)l2 - nArray[n2];
            if (n3 > 0 && (long)(n3 + nArray[n2]) <= l2) {
                IVecI[] iVecIArray = new IVec[n3];
                for (int i = 0; i < n3; ++i) {
                    iVecIArray[i] = iVecArray[nArray[n2] + i];
                }
                if (nArray2[n2] == 0) {
                    int n4;
                    IVecI[] iVecIArray2 = new IVec[n3 + 1];
                    int n5 = 0;
                    iVecIArray2[n5] = iVecIArray[0];
                    ++n5;
                    for (n4 = 1; n4 < n3; n4 += 2) {
                        iVecIArray2[n5] = iVecIArray[n4];
                        ++n5;
                    }
                    for (n4 = n3 % 2 == 0 ? n3 - 2 : n3 - 1; n4 > 0; n4 -= 2) {
                        iVecIArray2[n5] = iVecIArray[n4];
                    }
                    iVecIArray2[n3] = iVecIArray[0];
                    ICurve iCurve = new ICurve(iVecIArray2);
                    iCurve.name(String.valueOf(n));
                } else if (nArray2[n2] == 1) {
                    IVecI[] iVecIArray3 = new IVec[n3 + 1];
                    for (int i = 0; i < n3; ++i) {
                        iVecIArray3[i] = iVecIArray[i];
                    }
                    iVecIArray3[n3] = iVecIArray[0];
                    ICurve iCurve = new ICurve(iVecIArray3);
                    iCurve.name(String.valueOf(n));
                } else if (nArray2[n2] == 2) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                } else if (nArray2[n2] == 3) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                } else if (nArray2[n2] == 4) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                } else if (nArray2[n2] == 5) {
                    ICurve iCurve = new ICurve(iVecIArray);
                    iCurve.name(String.valueOf(n));
                } else {
                    IG.err("unknown part type " + nArray2[n2]);
                }
            }
            ++n2;
        }
    }

    public static int makeMultiPatch(InputStream inputStream, int n, int n2, ArrayList<IObject[]> arrayList) {
        int n3 = 0;
        try {
            IShapeFileImporter.skip(inputStream, 32L);
            n3 += 32;
            long l = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            long l2 = IShapeFileImporter.readIntLE(inputStream);
            n3 += 4;
            int[] nArray = IShapeFileImporter.readIntegers(inputStream, (int)l);
            n3 = (int)((long)n3 + l * 4L);
            if (nArray == null) {
                IG.err();
                return n3;
            }
            int[] nArray2 = IShapeFileImporter.readIntegers(inputStream, (int)l);
            n3 = (int)((long)n3 + l * 4L);
            if (nArray2 == null) {
                IG.err();
                return n3;
            }
            IVec[] iVecArray = IShapeFileImporter.readPoints(inputStream, (int)l2);
            n3 = (int)((long)n3 + l2 * 16L);
            if (iVecArray == null) {
                IG.err();
                return n3;
            }
            IShapeFileImporter.skip(inputStream, 16L);
            n3 += 16;
            double[] dArray = IShapeFileImporter.readDoubles(inputStream, (int)l2);
            n3 = (int)((long)n3 + l2 * 8L);
            if (dArray == null) {
                IG.err();
                return n3;
            }
            int n4 = 0;
            while ((long)n4 < l2) {
                if (iVecArray[n4] != null) {
                    iVecArray[n4].z = dArray[n4];
                }
                ++n4;
            }
            ArrayList<ICurve> arrayList2 = new ArrayList<ICurve>();
            int n5 = 0;
            while ((long)n5 < l) {
                int n6 = 0;
                n6 = (long)nArray[n5] < l - 1L ? nArray[n5 + 1] - nArray[n5] : (int)l2 - nArray[n5];
                if (n6 > 0 && (long)(n6 + nArray[n5]) < l2) {
                    IVecI[] iVecIArray = new IVec[n6];
                    for (int i = 0; i < n6; ++i) {
                        iVecIArray[i] = iVecArray[nArray[n5] + i];
                    }
                    if (nArray2[n5] == 0) {
                        int n7;
                        IVecI[] iVecIArray2 = new IVec[n6 + 1];
                        int n8 = 0;
                        iVecIArray2[n8] = iVecIArray[0];
                        ++n8;
                        for (n7 = 1; n7 < n6; n7 += 2) {
                            iVecIArray2[n8] = iVecIArray[n7];
                            ++n8;
                        }
                        for (n7 = n6 % 2 == 0 ? n6 - 2 : n6 - 1; n7 > 0; n7 -= 2) {
                            iVecIArray2[n8] = iVecIArray[n7];
                        }
                        iVecIArray2[n6] = iVecIArray[0];
                        ICurve iCurve = new ICurve(iVecIArray2);
                        iCurve.name(String.valueOf(n));
                        arrayList2.add(iCurve);
                    } else if (nArray2[n5] == 1) {
                        IVecI[] iVecIArray3 = new IVec[n6 + 1];
                        for (int i = 0; i < n6; ++i) {
                            iVecIArray3[i] = iVecIArray[i];
                        }
                        iVecIArray3[n6] = iVecIArray[0];
                        ICurve iCurve = new ICurve(iVecIArray3);
                        iCurve.name(String.valueOf(n));
                        arrayList2.add(iCurve);
                    } else if (nArray2[n5] == 2) {
                        ICurve iCurve = new ICurve(iVecIArray);
                        iCurve.name(String.valueOf(n));
                        arrayList2.add(iCurve);
                    } else if (nArray2[n5] == 3) {
                        ICurve iCurve = new ICurve(iVecIArray);
                        iCurve.name(String.valueOf(n));
                        arrayList2.add(iCurve);
                    } else if (nArray2[n5] == 4) {
                        ICurve iCurve = new ICurve(iVecIArray);
                        iCurve.name(String.valueOf(n));
                        arrayList2.add(iCurve);
                    } else if (nArray2[n5] == 5) {
                        ICurve iCurve = new ICurve(iVecIArray);
                        iCurve.name(String.valueOf(n));
                        arrayList2.add(iCurve);
                    } else {
                        IG.err("unknown part type " + nArray2[n5]);
                    }
                }
                ++n5;
            }
            arrayList.add(arrayList2.toArray(new IObject[arrayList2.size()]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n3;
    }

    public static String getFilePrefix(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    public static String getFileNameWithExtension(String string, String string2) {
        return IShapeFileImporter.getFilePrefix(string) + "." + string2;
    }

    public static File getFileWithExtension(File file, String string) {
        String string2 = IShapeFileImporter.getFilePrefix(file.getName());
        return new File(file.getParentFile(), string2 + "." + string);
    }

    public static ArrayList<IObject> read(File file, IServerI iServerI) {
        IObject iObject;
        int n;
        int n2;
        Object object;
        if (!file.exists()) {
            IOut.err("the input file doesn't exist : " + file.getPath());
            return null;
        }
        if (iServerI != null) {
            iServerI.server().unit(IUnit.Meter);
        } else {
            IG.unit(IUnit.Meter);
        }
        String string = IShapeFileImporter.getFilePrefix(file.getName());
        File file2 = new File(file.getParentFile(), string + ".dbf");
        File file3 = new File(file.getParentFile(), string + ".DBF");
        File file4 = new File(file.getParentFile(), string + ".Dbf");
        File file5 = null;
        if (file2.exists()) {
            file5 = file2;
        } else if (file3.exists()) {
            file5 = file3;
        } else if (file4.exists()) {
            file5 = file4;
        } else {
            IG.err("DBF file does not exist : " + file2.getAbsolutePath());
        }
        ArrayList<IObject[]> arrayList = null;
        try {
            arrayList = IShapeFileImporter.readSHP(new FileInputStream(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (file5 != null) {
            object = IShapeFileImporter.readDBF(file5, iServerI);
            if (((IEsri.Attributes[])object).length != arrayList.size()) {
                IG.err("Shape count (" + arrayList.size() + ") and DBF count (" + ((IEsri.Attributes[])object).length + ") does not match");
            }
            for (n2 = 0; n2 < ((IEsri.Attributes[])object).length && n2 < arrayList.size(); ++n2) {
                for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                    iObject = arrayList.get(n2)[n];
                    if (iObject == null) continue;
                    iObject.userData(new Object[]{object[n2]});
                }
            }
        }
        object = new ArrayList();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                iObject = arrayList.get(n2)[n];
                if (iObject == null) continue;
                ((ArrayList)object).add(iObject);
            }
        }
        return object;
    }

    public static ArrayList<IObject> read(InputStream inputStream, InputStream inputStream2, IServerI iServerI) {
        IObject iObject;
        int n;
        int n2;
        Object object;
        if (inputStream == null) {
            IG.err("no SHP file stream found");
        }
        ArrayList<IObject[]> arrayList = null;
        arrayList = IShapeFileImporter.readSHP(inputStream, iServerI);
        if (iServerI != null) {
            iServerI.server().unit(IUnit.Meter);
        } else {
            IG.unit(IUnit.Meter);
        }
        if (inputStream2 != null) {
            object = IShapeFileImporter.readDBF(inputStream2, iServerI);
            if (((IEsri.Attributes[])object).length != arrayList.size()) {
                IG.err("Shape count (" + arrayList.size() + ") and DBF count (" + ((IEsri.Attributes[])object).length + ") does not match");
            }
            for (n2 = 0; n2 < ((IEsri.Attributes[])object).length && n2 < arrayList.size(); ++n2) {
                for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                    iObject = arrayList.get(n2)[n];
                    if (iObject == null) continue;
                    iObject.userData(new Object[]{object[n2]});
                }
            }
        }
        object = new ArrayList();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            for (n = 0; arrayList.get(n2) != null && n < arrayList.get(n2).length; ++n) {
                iObject = arrayList.get(n2)[n];
                if (iObject == null) continue;
                ((ArrayList)object).add(iObject);
            }
        }
        return object;
    }

    public static ArrayList<IObject> read(String string, IServerI iServerI) {
        return IShapeFileImporter.read(new File(string), iServerI);
    }

    public static ArrayList<IObject[]> readSHP(File file, IServerI iServerI) {
        try {
            return IShapeFileImporter.readSHP(new FileInputStream(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<IObject[]> readSHP(String string, IServerI iServerI) {
        try {
            return IShapeFileImporter.readSHP(new FileInputStream(string), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<IObject[]> readSHP(InputStream inputStream, IServerI iServerI) {
        ArrayList<IObject[]> arrayList = new ArrayList<IObject[]>();
        IShapeFileImporter.readSHPHeader(inputStream);
        boolean bl = false;
        int n = 0;
        do {
            if (n % 100 == 0 && n > 0) {
                IOut.debug(20, n);
            }
            IOut.debug(20, "record " + n);
            bl = IShapeFileImporter.readSHPRecord(inputStream, false, arrayList);
            ++n;
        } while (bl);
        IOut.debug(20, "SHP import complete");
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            IShapeFileImporter.readSHP(fileInputStream, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static IEsri.Attributes[] readDBF(File file, IServerI iServerI) {
        try {
            return IShapeFileImporter.readDBF(new FileInputStream(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static IEsri.Attributes[] readDBF(String string, IServerI iServerI) {
        try {
            return IShapeFileImporter.readDBF(new FileInputStream(string), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static IEsri.Attributes[] readDBF(InputStream inputStream, IServerI iServerI) {
        IEsri.AttributeHeader attributeHeader = IShapeFileImporter.readDBFHeader(inputStream);
        int n = (int)attributeHeader.recordNum;
        long l = attributeHeader.recordLen;
        IEsri.Attributes[] attributesArray = new IEsri.Attributes[n];
        for (int i = 0; i < n; ++i) {
            attributesArray[i] = IShapeFileImporter.readDBFRecord(inputStream, attributeHeader);
            if (i % 100 != 0 || i <= 0) continue;
            IOut.debug(20, i + "/" + n);
        }
        IOut.debug(20, "DBF import complete");
        return attributesArray;
    }

    public static String stringWithoutSpace(byte[] byArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < byArray.length && (byArray[n2] == 32 || byArray[n2] == 0); ++n2) {
        }
        for (n = byArray.length - 1; n > n2 && (byArray[n] == 32 || byArray[n] == 0); --n) {
        }
        if (n2 > n) {
            return new String();
        }
        return new String(byArray, n2, n - n2 + 1);
    }

    public static IEsri.Attributes readDBFRecord(InputStream inputStream, IEsri.AttributeHeader attributeHeader) {
        IEsri.Attributes attributes = new IEsri.Attributes((int)attributeHeader.fieldNum);
        attributes.fields = attributeHeader.fields;
        try {
            int n = inputStream.read();
            int n2 = 0;
            while ((long)n2 < attributeHeader.fieldNum) {
                int n3 = attributeHeader.fields[n2].length;
                byte[] byArray = new byte[n3];
                inputStream.read(byArray, 0, n3);
                attributes.text[n2] = IShapeFileImporter.stringWithoutSpace(byArray);
                if (attributeHeader.fields[n2].type == 'N' || attributeHeader.fields[n2].type == 'F') {
                    if (attributes.text[n2].length() == 0) {
                        attributes.number[n2] = 0.0;
                    } else {
                        try {
                            attributes.number[n2] = Double.parseDouble(attributes.text[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            IG.err("record.text : \"" + attributes.text[n2] + "\"");
                        }
                    }
                } else if (attributeHeader.fields[n2].type == 'L') {
                    attributes.number[n2] = attributes.text[n2].equals("Y") || attributes.text[n2].equals("y") || attributes.text[n2].equals("T") || attributes.text[n2].equals("t") ? 1.0 : 0.0;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return attributes;
    }

    public static IEsri.AttributeHeader readDBFHeader(InputStream inputStream) {
        IEsri.AttributeHeader attributeHeader = new IEsri.AttributeHeader();
        try {
            long l;
            inputStream.skip(4L);
            attributeHeader.recordNum = IShapeFileImporter.readIntLE(inputStream);
            attributeHeader.firstDataPos = IShapeFileImporter.readShortLE(inputStream);
            attributeHeader.recordLen = IShapeFileImporter.readShortLE(inputStream);
            inputStream.skip(20L);
            attributeHeader.fieldNum = l = (attributeHeader.firstDataPos - 32L - 1L) / 32L;
            attributeHeader.fields = new IEsri.AttributeField[(int)l];
            int n = 0;
            int n2 = 0;
            while ((long)n2 < l) {
                String string;
                int n3;
                int n4;
                int n5;
                int n6;
                char c;
                attributeHeader.fields[n2] = new IEsri.AttributeField();
                byte[] byArray = new byte[10];
                inputStream.read(byArray, 0, 10);
                inputStream.skip(1L);
                attributeHeader.fields[n2].type = c = (char)inputStream.read();
                inputStream.skip(4L);
                attributeHeader.fields[n2].length = n6 = inputStream.read();
                n += n6;
                attributeHeader.fields[n2].fractionLength = n5 = inputStream.read();
                inputStream.skip(2L);
                attributeHeader.fields[n2].workspaceID = n4 = inputStream.read();
                inputStream.skip(11L);
                int n7 = byArray.length - 1;
                for (n3 = 0; n3 < byArray.length && byArray[n3] == 0; ++n3) {
                }
                while (n7 >= 0 && byArray[n7] == 0) {
                    --n7;
                }
                attributeHeader.fields[n2].name = string = new String(byArray, n3, n7 - n3 + 1);
                ++n2;
            }
            n2 = inputStream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return attributeHeader;
    }

    public static class GridConstraint
    extends Constraint {
        @Override
        public boolean validate(double d, double d2, double d3) {
            double d4 = 501002.66259577964;
            double d5 = 4793122.462032901;
            double d6 = 4.99785186;
            int n = (int)(Math.abs(d - d4) / d6 + 0.5);
            int n2 = (int)(Math.abs(d2 - d5) / d6 + 0.5);
            int n3 = 10;
            return n % n3 == 0 && n2 % n3 == 0;
        }
    }

    public static class Constraint {
        public boolean validate(double d, double d2, double d3) {
            return true;
        }
    }
}

