/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.ICurveGeo;
import igeo.IVec;
import igeo.IVec2;

public class ICurveCache {
    public ICurveGeo curve;
    public int resolution;
    public int deg;
    public IVec[] pts;
    public IVec2[] pts2;

    public ICurveCache(ICurveGeo iCurveGeo, int n) {
        this.curve = iCurveGeo;
        this.resolution = n;
        this.deg = this.curve.deg();
    }

    public ICurveCache(ICurveGeo iCurveGeo) {
        this(iCurveGeo, IConfig.curveCacheResolution);
    }

    public void init() {
        if (this.deg == 1) {
            this.pts = new IVec[this.curve.cpNum()];
            for (int i = 0; i < this.pts.length; ++i) {
                this.pts[i] = this.curve.cp(i).get();
            }
        } else {
            int n = this.curve.epNum();
            int n2 = (n - 1) * this.resolution + 1;
            this.pts = new IVec[n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < this.resolution; ++j) {
                    if (i >= n - 1 && j != 0) continue;
                    this.pts[i * this.resolution + j] = this.curve.pt(this.curve.u(i, (double)j / (double)this.resolution));
                }
            }
        }
    }

    public void init2() {
        if (this.deg == 1) {
            this.pts2 = new IVec2[this.curve.cpNum()];
            for (int i = 0; i < this.pts2.length; ++i) {
                this.pts2[i] = this.curve.cp(i).get().to2d();
            }
        } else {
            int n = this.curve.epNum();
            int n2 = (n - 1) * this.resolution + 1;
            this.pts2 = new IVec2[n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < this.resolution; ++j) {
                    if (i >= n - 1 && j != 0) continue;
                    this.pts2[i * this.resolution + j] = this.curve.pt(this.curve.u(i, (double)j / (double)this.resolution)).to2d();
                }
            }
        }
    }

    public double u(IVec iVec) {
        if (this.pts == null) {
            this.init();
        }
        int n = this.closest(iVec);
        if (this.deg == 1) {
            if (n == 0) {
                double d = iVec.ratioOnSegment(this.pts[n], this.pts[n + 1]);
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                return this.curve.u(n, d);
            }
            if (n == this.pts.length - 1) {
                double d = iVec.ratioOnSegment(this.pts[n - 1], this.pts[n]);
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                return this.curve.u(n - 1, d);
            }
            double d = iVec.ratioOnSegment(this.pts[n - 1], this.pts[n]);
            double d2 = iVec.ratioOnSegment(this.pts[n], this.pts[n + 1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 > 1.0) {
                d2 = 1.0;
            }
            double d3 = iVec.dist(this.pts[n - 1].sum(this.pts[n], d));
            double d4 = iVec.dist(this.pts[n].sum(this.pts[n + 1], d2));
            if (d3 <= d4) {
                return this.curve.u(n - 1, d);
            }
            return this.curve.u(n, d2);
        }
        if (this.resolution == 1) {
            if (n == 0) {
                return this.recursiveSearch(iVec, this.curve.u(n, 0.0), this.pts[n], this.curve.u(n + 1, 0.0), this.pts[n + 1], 0);
            }
            if (n == this.pts.length - 1) {
                return this.recursiveSearch(iVec, this.curve.u(n - 1, 0.0), this.pts[n - 1], this.curve.u(n, 0.0), this.pts[n], 0);
            }
            int n2 = this.closerIndexOnLine(iVec, n);
            return this.recursiveSearch(iVec, this.curve.u(n2, 0.0), this.pts[n2], this.curve.u(n2 + 1, 0.0), this.pts[n2 + 1], 0);
        }
        if (n == 0) {
            return this.recursiveSearch(iVec, this.curve.u(n, 0.0), this.pts[n], this.curve.u(n, 1.0 / (double)this.resolution), this.pts[n + 1], 0);
        }
        if (n == this.pts.length - 1) {
            int n3 = n / this.resolution;
            double d = (double)(n % this.resolution) / (double)this.resolution;
            return this.recursiveSearch(iVec, this.curve.u(n3, d - 1.0 / (double)this.resolution), this.pts[n - 1], this.curve.u(n3, d), this.pts[n], 0);
        }
        int n4 = this.closerIndexOnLine(iVec, n);
        int n5 = n4 / this.resolution;
        double d = (double)(n4 % this.resolution) / (double)this.resolution;
        return this.recursiveSearch(iVec, this.curve.u(n5, d), this.pts[n4], this.curve.u(n5, d + 1.0 / (double)this.resolution), this.pts[n4 + 1], 0);
    }

    public double u(IVec2 iVec2) {
        if (this.pts2 == null) {
            this.init2();
        }
        int n = this.closest(iVec2);
        if (this.deg == 1) {
            if (n == 0) {
                double d = iVec2.ratioOnSegment(this.pts2[n], this.pts2[n + 1]);
                return this.curve.u(n, d);
            }
            if (n == this.pts2.length - 1) {
                double d = iVec2.ratioOnSegment(this.pts2[n - 1], this.pts2[n]);
                return this.curve.u(n - 1, d);
            }
            double d = iVec2.ratioOnSegment(this.pts2[n - 1], this.pts2[n]);
            double d2 = iVec2.ratioOnSegment(this.pts2[n], this.pts2[n + 1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 > 1.0) {
                d2 = 1.0;
            }
            double d3 = iVec2.dist(this.pts2[n - 1].sum(this.pts2[n], d));
            double d4 = iVec2.dist(this.pts2[n].sum(this.pts2[n + 1], d2));
            if (d3 <= d4) {
                return this.curve.u(n - 1, d);
            }
            return this.curve.u(n, d2);
        }
        if (this.resolution == 1) {
            if (n == 0) {
                return this.recursiveSearch(iVec2, this.curve.u(n, 0.0), this.pts2[n], this.curve.u(n + 1, 0.0), this.pts2[n + 1], 0);
            }
            if (n == this.pts2.length - 1) {
                return this.recursiveSearch(iVec2, this.curve.u(n - 1, 0.0), this.pts2[n - 1], this.curve.u(n, 0.0), this.pts2[n], 0);
            }
            int n2 = this.closerIndexOnLine(iVec2, n);
            return this.recursiveSearch(iVec2, this.curve.u(n2, 0.0), this.pts2[n2], this.curve.u(n2 + 1, 0.0), this.pts2[n2 + 1], 0);
        }
        if (n == 0) {
            return this.recursiveSearch(iVec2, this.curve.u(n, 0.0), this.pts2[n], this.curve.u(n, 1.0 / (double)this.resolution), this.pts2[n + 1], 0);
        }
        if (n == this.pts2.length - 1) {
            int n3 = n / this.resolution;
            double d = (double)(n % this.resolution) / (double)this.resolution;
            return this.recursiveSearch(iVec2, this.curve.u(n3, d - 1.0 / (double)this.resolution), this.pts2[n - 1], this.curve.u(n3, d), this.pts2[n], 0);
        }
        int n4 = this.closerIndexOnLine(iVec2, n);
        int n5 = n4 / this.resolution;
        double d = (double)(n4 % this.resolution) / (double)this.resolution;
        return this.recursiveSearch(iVec2, this.curve.u(n5, d), this.pts2[n4], this.curve.u(n5, d + 1.0 / (double)this.resolution), this.pts2[n4 + 1], 0);
    }

    public int closerIndexOnLine(IVec iVec, int n) {
        double d;
        double d2 = iVec.distToSegment(this.pts[n - 1], this.pts[n]);
        if (d2 <= (d = iVec.distToSegment(this.pts[n], this.pts[n + 1]))) {
            return n - 1;
        }
        return n;
    }

    public int closerIndexOnLine(IVec2 iVec2, int n) {
        double d;
        double d2 = iVec2.distToSegment(this.pts2[n - 1], this.pts2[n]);
        if (d2 <= (d = iVec2.distToSegment(this.pts2[n], this.pts2[n + 1]))) {
            return n - 1;
        }
        return n;
    }

    public double recursiveSearch(IVec iVec, double d, IVec iVec2, double d2, IVec iVec3, int n) {
        if (iVec2 == null) {
            iVec2 = this.curve.pt(d);
        }
        if (iVec3 == null) {
            iVec3 = this.curve.pt(d2);
        }
        double d3 = iVec.dist(iVec2);
        double d4 = iVec.dist(iVec3);
        ++n;
        if (d3 <= d4) {
            if (d3 < IConfig.tolerance || iVec2.dist(iVec3) < IConfig.tolerance || n >= IConfig.cacheRecursionMaxDepth) {
                return d;
            }
            return this.recursiveSearch(iVec, d, iVec2, (d + d2) / 2.0, null, n);
        }
        if (d4 < IConfig.tolerance || iVec2.dist(iVec3) < IConfig.tolerance || n >= IConfig.cacheRecursionMaxDepth) {
            return d2;
        }
        return this.recursiveSearch(iVec, (d + d2) / 2.0, null, d2, iVec3, n);
    }

    public double recursiveSearch(IVec2 iVec2, double d, IVec2 iVec22, double d2, IVec2 iVec23, int n) {
        if (iVec22 == null) {
            iVec22 = this.curve.pt(d).to2d();
        }
        if (iVec23 == null) {
            iVec23 = this.curve.pt(d2).to2d();
        }
        double d3 = iVec2.dist(iVec22);
        double d4 = iVec2.dist(iVec23);
        ++n;
        if (d3 <= d4) {
            if (d3 < IConfig.tolerance || iVec22.dist(iVec23) < IConfig.tolerance || n >= IConfig.cacheRecursionMaxDepth) {
                return d;
            }
            return this.recursiveSearch(iVec2, d, iVec22, (d + d2) / 2.0, null, n);
        }
        if (d4 < IConfig.tolerance || iVec22.dist(iVec23) < IConfig.tolerance || n >= IConfig.cacheRecursionMaxDepth) {
            return d2;
        }
        return this.recursiveSearch(iVec2, (d + d2) / 2.0, null, d2, iVec23, n);
    }

    public int closest(IVec iVec) {
        int n = -1;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.pts.length; ++i) {
            d = iVec.dist(this.pts[i]);
            if (i != 0 && !(d < d2)) continue;
            d2 = d;
            n = i;
        }
        return n;
    }

    public int closest(IVec2 iVec2) {
        int n = -1;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.pts2.length; ++i) {
            d = iVec2.dist(this.pts2[i]);
            if (i != 0 && !(d < d2)) continue;
            d2 = d;
            n = i;
        }
        return n;
    }
}

