/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IConfig;
import igeo.IDoubleI;
import igeo.IDynamics;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IObject;
import igeo.IParticleGeo;
import igeo.IParticleOnSurfaceI;
import igeo.IPoint;
import igeo.IPointR;
import igeo.ISurface;
import igeo.ISurfaceI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVecI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IParticleOnSurfaceGeo
extends IParticleGeo
implements IParticleOnSurfaceI {
    public ISurfaceI surface;
    public IVec2 uvpos;
    public IVec2 uvvel;
    public IVec2 uvfrc;
    public IVec utan;
    public IVec vtan;
    public boolean ufixed = false;
    public boolean vfixed = false;

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI) {
        this(iSurfaceI, 0.0, 0.0);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2) {
        super(iSurfaceI.pt(d, d2).get());
        this.surface = iSurfaceI;
        this.uvpos = new IVec2(d, d2);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, double d3, double d4) {
        this(iSurfaceI, d, d2);
        this.uvvel = new IVec2(d3, d4);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, IVec iVec) {
        this(iSurfaceI, 0.0, 0.0, iVec);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, IVec iVec) {
        this(iSurfaceI, d, d2, 0.0, 0.0, iVec);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, double d3, double d4, IVec iVec) {
        super(iVec);
        iVec.set(iSurfaceI.pt(d, d2).get());
        this.surface = iSurfaceI;
        this.uvpos = new IVec2(d, d2);
        this.uvvel = new IVec2(d3, d4);
        this.uvfrc = new IVec2();
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, IObject iObject) {
        this(iSurfaceI, 0.0, 0.0, iObject);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, IObject iObject) {
        super(iSurfaceI.pt(d, d2).get(), iObject);
        this.surface = iSurfaceI;
        this.uvpos = new IVec2(d, d2);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, double d3, double d4, IObject iObject) {
        this(iSurfaceI, d, d2, iObject);
        this.uvvel = new IVec2(d3, d4);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, IVec iVec, IObject iObject) {
        this(iSurfaceI, 0.0, 0.0, iVec, iObject);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, IVec iVec, IObject iObject) {
        this(iSurfaceI, d, d2, 0.0, 0.0, iVec, iObject);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, double d3, double d4, IVec iVec, IObject iObject) {
        super(iVec, iObject);
        iVec.set(iSurfaceI.pt(d, d2).get());
        this.surface = iSurfaceI;
        this.uvpos = new IVec2(d, d2);
        this.uvvel = new IVec2(d3, d4);
        this.uvfrc = new IVec2();
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, IPoint iPoint) {
        this(iSurfaceI, d, d2, iPoint.pos, iPoint);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, double d3, double d4, IPoint iPoint) {
        this(iSurfaceI, d, d2, d3, d4, iPoint.pos, (IObject)iPoint);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, IPoint iPoint) {
        this(iSurfaceI, 0.0, 0.0, iPoint.pos, iPoint);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, IPointR iPointR) {
        this(iSurfaceI, 0.0, 0.0, iPointR.pos.get(), iPointR);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, IPointR iPointR) {
        this(iSurfaceI, d, d2, iPointR.pos.get(), iPointR);
    }

    public IParticleOnSurfaceGeo(ISurfaceI iSurfaceI, double d, double d2, double d3, double d4, IPointR iPointR) {
        this(iSurfaceI, d, d2, d3, d4, iPointR.pos.get(), (IObject)iPointR);
    }

    public IParticleOnSurfaceGeo(ISurface iSurface) {
        this((ISurfaceI)iSurface, 0.0, 0.0, (IObject)iSurface);
    }

    public IParticleOnSurfaceGeo(ISurface iSurface, double d, double d2) {
        this((ISurfaceI)iSurface, d, d2, (IObject)iSurface);
    }

    public IParticleOnSurfaceGeo(ISurface iSurface, double d, double d2, double d3, double d4) {
        this((ISurfaceI)iSurface, d, d2, d3, d4, iSurface);
    }

    public IParticleOnSurfaceGeo(ISurface iSurface, IVec iVec) {
        this((ISurfaceI)iSurface, 0.0, 0.0, iVec, iSurface);
    }

    public IParticleOnSurfaceGeo(ISurface iSurface, double d, double d2, IVec iVec) {
        this((ISurfaceI)iSurface, d, d2, iVec, iSurface);
    }

    public IParticleOnSurfaceGeo(ISurface iSurface, double d, double d2, double d3, double d4, IVec iVec) {
        this(iSurface, d, d2, d3, d4, iVec, (IObject)iSurface);
    }

    public IParticleOnSurfaceGeo(IParticleOnSurfaceGeo iParticleOnSurfaceGeo) {
        this(iParticleOnSurfaceGeo.surface, iParticleOnSurfaceGeo.uvpos.x, iParticleOnSurfaceGeo.uvpos.y, iParticleOnSurfaceGeo.pos.dup(), iParticleOnSurfaceGeo.parent());
    }

    public IParticleOnSurfaceGeo(IParticleOnSurfaceGeo iParticleOnSurfaceGeo, IVec iVec) {
        this(iParticleOnSurfaceGeo.surface, iParticleOnSurfaceGeo.uvpos.x, iParticleOnSurfaceGeo.uvpos.y, iVec, iParticleOnSurfaceGeo.parent());
    }

    public IParticleOnSurfaceGeo(IParticleOnSurfaceGeo iParticleOnSurfaceGeo, IObject iObject) {
        this(iParticleOnSurfaceGeo.surface, iParticleOnSurfaceGeo.uvpos.x, iParticleOnSurfaceGeo.uvpos.y, iParticleOnSurfaceGeo.pos.dup(), iObject);
    }

    public IParticleOnSurfaceGeo(IParticleOnSurfaceGeo iParticleOnSurfaceGeo, IVec iVec, IObject iObject) {
        this(iParticleOnSurfaceGeo.surface, iParticleOnSurfaceGeo.uvpos.x, iParticleOnSurfaceGeo.uvpos.y, iVec, iObject);
    }

    @Override
    public IParticleOnSurfaceGeo dup() {
        return new IParticleOnSurfaceGeo(this);
    }

    @Override
    public ISurfaceI surface() {
        return this.surface;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo fix() {
        super.fix();
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo unfix() {
        super.unfix();
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo skipUpdateOnce(boolean bl) {
        super.skipUpdateOnce(bl);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo mass(double d) {
        super.mass(d);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo position(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo pos(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo velocity(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo vel(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo force(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo frc(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo friction(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo fric(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo decay(double d) {
        return this.fric(d);
    }

    @Override
    public synchronized IParticleOnSurfaceGeo push(IVecI iVecI) {
        super.push(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo pull(IVecI iVecI) {
        super.pull(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo addForce(IVecI iVecI) {
        super.addForce(iVecI);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo reset() {
        super.reset();
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo resetForce() {
        super.resetForce();
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo uv(double d, double d2) {
        this.uvpos.set(d, d2);
        return this;
    }

    @Override
    public synchronized IVec2 uv() {
        return this.uvpos.cp();
    }

    @Override
    public synchronized IParticleOnSurfaceGeo uvvel(double d, double d2) {
        this.uvvel.set(d, d2);
        return this;
    }

    @Override
    public synchronized IVec2 uvvel() {
        return this.uvvel.cp();
    }

    @Override
    public synchronized IParticleOnSurfaceGeo uvfrc(double d, double d2) {
        this.uvfrc.set(d, d2);
        return this;
    }

    @Override
    public synchronized IVec2 uvfrc() {
        return this.uvfrc.cp();
    }

    @Override
    public synchronized IParticleOnSurfaceGeo addUVForce(double d, double d2) {
        return this.uvpush(d, d2);
    }

    @Override
    public synchronized IParticleOnSurfaceGeo resetUVForce() {
        return this.uvreset();
    }

    @Override
    public synchronized IParticleOnSurfaceGeo uvpush(double d, double d2) {
        this.uvfrc.add(d, d2);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo uvpull(double d, double d2) {
        this.uvfrc.sub(d, d2);
        return this;
    }

    @Override
    public synchronized IParticleOnSurfaceGeo uvreset() {
        this.uvfrc.zero();
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo fixU() {
        this.ufixed = true;
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo fixV() {
        this.vfixed = true;
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo unfixU() {
        this.ufixed = false;
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo unfixV() {
        this.vfixed = false;
        return this;
    }

    @Override
    public boolean uFixed() {
        return this.ufixed;
    }

    @Override
    public boolean vFixed() {
        return this.vfixed;
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
    }

    @Override
    public synchronized void preupdate() {
        if (this.fixed || this.surface == null) {
            return;
        }
        this.utan = this.surface.utan(this.uvpos).get();
        this.vtan = this.surface.vtan(this.uvpos).get();
        double[] dArray = this.frc.projectTo2Vec(this.utan, this.vtan);
        if (dArray != null) {
            this.uvfrc.add(dArray[0], dArray[1]);
            this.uvvel.add(this.uvfrc.mul(IConfig.updateRate / this.mass)).mul(1.0 - this.friction);
        }
        if (this.ufixed) {
            this.uvvel.x = 0.0;
        }
        if (this.vfixed) {
            this.uvvel.y = 0.0;
        }
        if (!IConfig.enablePostupdate || !IConfig.clearParticleForceInPostupdate) {
            this.frc.zero();
            this.uvfrc.zero();
        }
    }

    @Override
    public synchronized void update() {
        if (this.skipUpdateOnce) {
            this.skipUpdateOnce = false;
            return;
        }
        if (this.fixed || this.surface == null) {
            return;
        }
        if (this.uvpos.x + this.uvvel.x * IConfig.updateRate < 0.0) {
            if (this.surface.isUClosed()) {
                this.uvpos.x += this.uvvel.x * IConfig.updateRate;
                this.uvpos.x -= Math.floor(this.uvpos.x);
            } else {
                this.uvpos.x = 0.0;
                this.uvvel.x = 0.0;
            }
        } else if (this.uvpos.x + this.uvvel.x * IConfig.updateRate > 1.0) {
            if (this.surface.isUClosed()) {
                this.uvpos.x += this.uvvel.x * IConfig.updateRate;
                this.uvpos.x -= Math.floor(this.uvpos.x);
            } else {
                this.uvpos.x = 1.0;
                this.uvvel.x = 0.0;
            }
        } else {
            this.uvpos.x += this.uvvel.x * IConfig.updateRate;
        }
        if (this.uvpos.y + this.uvvel.y * IConfig.updateRate < 0.0) {
            if (this.surface.isVClosed()) {
                this.uvpos.y += this.uvvel.y * IConfig.updateRate;
                this.uvpos.y -= Math.floor(this.uvpos.y);
            } else {
                this.uvpos.y = 0.0;
                this.uvvel.y = 0.0;
            }
        } else if (this.uvpos.y + this.uvvel.y * IConfig.updateRate > 1.0) {
            if (this.surface.isVClosed()) {
                this.uvpos.y += this.uvvel.y * IConfig.updateRate;
                this.uvpos.y -= Math.floor(this.uvpos.y);
            } else {
                this.uvpos.y = 1.0;
                this.uvvel.y = 0.0;
            }
        } else {
            this.uvpos.y += this.uvvel.y * IConfig.updateRate;
        }
        this.pos.set(this.surface.pt(this.uvpos));
    }

    @Override
    public synchronized void postupdate() {
        if (IConfig.enablePostupdate && IConfig.clearParticleForceInPostupdate) {
            this.frc.zero();
            this.uvfrc.zero();
        }
    }

    @Override
    public IParticleOnSurfaceGeo x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo x(IVecI iVecI) {
        this.pos.x(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo y(IVecI iVecI) {
        this.pos.y(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo z(IVecI iVecI) {
        this.pos.z(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo x(IVec2I iVec2I) {
        this.pos.x(iVec2I);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo y(IVec2I iVec2I) {
        this.pos.y(iVec2I);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rev() {
        return this.neg();
    }

    @Override
    public IParticleOnSurfaceGeo flip() {
        return this.neg();
    }

    @Override
    public IParticleOnSurfaceGeo zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo add(double d, IVecI iVecI) {
        this.pos.add(d, iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        this.pos.add(iDoubleI, iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot2(double d) {
        this.pos.rot2(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot2(IDoubleI iDoubleI) {
        this.pos.rot2(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IParticleOnSurfaceGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IParticleOnSurfaceGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticleOnSurfaceGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IParticleOnSurfaceGeo cp() {
        return this.dup();
    }

    @Override
    public IParticleOnSurfaceGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IParticleOnSurfaceGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IParticleOnSurfaceGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }
}

