/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import com.sun.opengl.util.j2d.TextRenderer;
import igeo.IGraphicObject;
import igeo.IMatrix4;
import igeo.IText;
import igeo.IVec;
import igeo.gui.IGraphicMode;
import igeo.gui.IGraphics;
import igeo.gui.IGraphicsGL;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class ITextGraphicGL
extends IGraphicObject {
    public static final int defaultFontResolution = 80;
    public static final Font defaultFont = new Font("SansSerif", 0, 80);
    public static boolean shareRenderer = false;
    public static TextRenderer sharedRenderer;
    public TextRenderer renderer;
    public IText text;
    public String[] lines;
    public float textWidth;
    public float textHeight;
    public Font font;

    public ITextGraphicGL(IText iText) {
        super(iText);
        this.text = iText;
        this.font = this.text.font;
        if (this.font == null) {
            this.font = defaultFont;
        }
    }

    public boolean isDrawable(IGraphicMode iGraphicMode) {
        return iGraphicMode.isGL();
    }

    public void initText() {
        this.lines = this.lines();
        this.textWidth = (float)this.textWidth(this.lines);
        this.textHeight = (float)this.textHeight(this.lines);
    }

    public String[] lines() {
        if (this.text == null || this.text.text() == null) {
            return null;
        }
        return this.text.text().split("\n");
    }

    public double textWidth(String[] stringArray) {
        if (this.renderer == null) {
            if (shareRenderer) {
                if (sharedRenderer == null) {
                    sharedRenderer = new TextRenderer(this.font, true, true);
                }
                this.renderer = sharedRenderer;
            } else {
                this.renderer = new TextRenderer(this.font, true, true);
            }
        }
        if (stringArray == null) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Rectangle2D rectangle2D = this.renderer.getBounds(stringArray[i]);
                if (!(rectangle2D.getWidth() > d)) continue;
                d = rectangle2D.getWidth();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        double d2 = 1.0;
        try {
            d2 = this.renderer.getFont().getSize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d / d2;
    }

    public double textHeight(String[] stringArray) {
        if (stringArray == null) {
            return 0.0;
        }
        return stringArray.length;
    }

    public synchronized void draw(IGraphics iGraphics) {
        if (this.text.text() == null) {
            return;
        }
        if (iGraphics.type() == IGraphicMode.GraphicType.GL) {
            IGraphicsGL iGraphicsGL = (IGraphicsGL)iGraphics;
            if (iGraphicsGL.firstDraw() || this.renderer == null) {
                this.update();
            }
            float f = 0.0f;
            float f2 = 0.0f;
            if (this.text.isAlignLeft()) {
                f = 0.0f;
            } else if (this.text.isAlignCenter()) {
                f = this.textWidth / 2.0f;
            } else if (this.text.isAlignRight()) {
                f = this.textWidth;
            }
            if (this.text.isAlignBottom()) {
                f2 = -this.textHeight + 1.0f;
            } else if (this.text.isAlignMiddle()) {
                f2 = -this.textHeight / 2.0f + 1.0f;
            } else if (this.text.isAlignTop()) {
                f2 = 1.0f;
            }
            IMatrix4 iMatrix4 = IMatrix4.getTransform(this.text.uvec(), this.text.vvec(), this.text.uvec().cross(this.text.vvec()), this.text.pos());
            GL gL = iGraphicsGL.getGL();
            gL.glPushMatrix();
            gL.glMultMatrixd(iMatrix4.toArray(), 0);
            this.renderer.begin3DRendering();
            this.renderer.setColor(this.text.red(), this.text.green(), this.text.blue(), this.text.alpha());
            for (int i = 0; i < this.lines.length; ++i) {
                this.renderer.draw3D(this.lines[i], -f, -f2 - (float)i, 0.0f, 1.0f / (float)this.renderer.getFont().getSize());
            }
            this.renderer.end3DRendering();
            gL.glPopMatrix();
        }
    }

    public IVec corner(int n, int n2) {
        if (this.renderer == null) {
            this.initText();
        }
        if (this.text == null) {
            return null;
        }
        IVec iVec = this.text.pos().cp();
        if (n == 0) {
            if (this.text.isAlignCenter()) {
                iVec.add(this.text.uvec(), (double)(-this.textWidth / 2.0f));
            } else if (this.text.isAlignRight()) {
                iVec.add(this.text.uvec(), (double)(-this.textWidth));
            }
        } else if (this.text.isAlignLeft()) {
            iVec.add(this.text.uvec(), (double)this.textWidth);
        } else if (this.text.isAlignCenter()) {
            iVec.add(this.text.uvec(), (double)(this.textWidth / 2.0f));
        }
        if (n2 == 0) {
            if (this.text.isAlignTop()) {
                iVec.add(this.text.vvec(), (double)(-this.textHeight));
            } else if (this.text.isAlignMiddle()) {
                iVec.add(this.text.vvec(), (double)(-this.textHeight / 2.0f));
            }
        } else if (this.text.isAlignMiddle()) {
            iVec.add(this.text.vvec(), (double)(this.textHeight / 2.0f));
        } else if (this.text.isAlignBottom()) {
            iVec.add(this.text.vvec(), (double)this.textHeight);
        }
        return iVec;
    }

    public void update() {
        if (this.text.font == null && this.font != defaultFont) {
            this.font = defaultFont;
        } else if (this.text.font != null && this.font != this.text.font) {
            this.font = this.text.font;
        }
        if (shareRenderer) {
            if (sharedRenderer == null) {
                sharedRenderer = new TextRenderer(this.font, true, true);
            }
            this.renderer = sharedRenderer;
        } else {
            this.renderer = new TextRenderer(this.font, true, true);
        }
        this.initText();
        super.update();
    }
}

