/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.ICurve;
import igeo.IGeometry;
import igeo.IMatrix3;
import igeo.IMatrix4;
import igeo.IMesh;
import igeo.IOut;
import igeo.IVec;
import igeo.IVertex;
import java.util.ArrayList;

public class I3DXML {
    static final String materialReferenceFile = "CATMaterialRef.3dxml";
    static final String representationImageFile = "CATRepImage.3dxml";
    public String filename;
    public ArrayList<String> fileList;
    public ArrayList<Reference3D> references;
    public ArrayList<Instance3D> instances;
    public ArrayList<ReferenceRep> referenceReps;
    public ArrayList<InstanceRep> instanceReps;
    public ArrayList<IGeometry> objects;
    public ArrayList<RepresentationDocument> representationDocuments;

    public I3DXML(String string) {
        this.filename = string;
        this.fileList = new ArrayList();
        this.references = new ArrayList();
        this.instances = new ArrayList();
        this.referenceReps = new ArrayList();
        this.instanceReps = new ArrayList();
        this.representationDocuments = new ArrayList();
    }

    public void linkReferenceReps() {
        for (int i = 0; i < this.referenceReps.size(); ++i) {
            for (int j = 0; j < this.representationDocuments.size(); ++j) {
                if (!this.referenceReps.get((int)i).associatedFile.equals(this.representationDocuments.get((int)j).filename)) continue;
                this.referenceReps.get((int)i).representationDocument = this.representationDocuments.get(j);
            }
            if (this.referenceReps.get((int)i).representationDocument != null) continue;
            IOut.err("representation file \"" + this.referenceReps.get((int)i).associatedFile + "\" not found");
        }
    }

    public void linkInstances() {
        for (int i = 0; i < this.instances.size(); ++i) {
            this.instances.get(i).link(this);
        }
    }

    public void linkInstanceReps() {
        for (int i = 0; i < this.instanceReps.size(); ++i) {
            this.instanceReps.get(i).link(this);
        }
    }

    public void linkNodes() {
        this.linkInstances();
        this.linkInstanceReps();
        this.linkReferenceReps();
    }

    public ArrayList<IGeometry> instantiate() {
        if (this.references != null) {
            this.objects = this.references.get(0).instantiate(null);
            if (this.references.size() > 0) {
                return this.objects;
            }
        }
        return null;
    }

    public I3DXMLNode getNode(int n) {
        int n2;
        for (n2 = 0; n2 < this.references.size(); ++n2) {
            if (this.references.get((int)n2).id != n) continue;
            return this.references.get(n2);
        }
        for (n2 = 0; n2 < this.instances.size(); ++n2) {
            if (this.instances.get((int)n2).id != n) continue;
            return this.instances.get(n2);
        }
        for (n2 = 0; n2 < this.referenceReps.size(); ++n2) {
            if (this.referenceReps.get((int)n2).id != n) continue;
            return this.referenceReps.get(n2);
        }
        for (n2 = 0; n2 < this.instanceReps.size(); ++n2) {
            if (this.instanceReps.get((int)n2).id != n) continue;
            return this.instanceReps.get(n2);
        }
        IOut.err("no such node with id=" + n);
        return null;
    }

    public static class XMLRepresentationDocument
    extends RepresentationDocument {
        public VisualizationRepType root;
        public ArrayList<VisualizationRepType> representations = new ArrayList();

        XMLRepresentationDocument() {
        }

        @Override
        public ArrayList<IMesh> instantiatePolygon(IMatrix4 iMatrix4) {
            if (this.root != null) {
                return this.root.instantiatePolygon(iMatrix4);
            }
            return null;
        }

        @Override
        public ArrayList<ICurve> instantiatePolyline(IMatrix4 iMatrix4) {
            return null;
        }
    }

    public static class RepresentationDocument {
        public String filename;

        public ArrayList<IMesh> instantiatePolygon(IMatrix4 iMatrix4) {
            return null;
        }

        public ArrayList<ICurve> instantiatePolyline(IMatrix4 iMatrix4) {
            return null;
        }
    }

    public static class FaceGPType {
        public SurfaceAttributesType surfaceAttributes;
        public String triangles;
        public String strips;
        public String fans;
        public int[] triangleIndices;
        public int[][] stripIndices;
        public int[][] fanIndices;
        public IMesh mesh;

        public void setTriangles(String string) {
            try {
                String[] stringArray = string.split("\\s+");
                this.triangleIndices = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.triangleIndices[i] = Integer.parseInt(stringArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            IOut.p(this.triangleIndices.length + " triangles");
        }

        public void setStrips(String string) {
            try {
                String[] stringArray = string.split("\\s*,\\s*");
                int n = stringArray.length;
                this.stripIndices = new int[n][];
                for (int i = 0; i < n; ++i) {
                    String[] stringArray2 = stringArray[i].split("\\s+");
                    int n2 = stringArray2.length;
                    this.stripIndices[i] = new int[n2];
                    for (int j = 0; j < n2; ++j) {
                        this.stripIndices[i][j] = Integer.parseInt(stringArray2[j]);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            IOut.p(this.stripIndices.length + " strips");
        }

        public void setFans(String string) {
            try {
                String[] stringArray = string.split("\\s*,\\s*");
                int n = stringArray.length;
                this.fanIndices = new int[n][];
                for (int i = 0; i < n; ++i) {
                    String[] stringArray2 = stringArray[i].split("\\s+");
                    int n2 = stringArray2.length;
                    this.fanIndices[i] = new int[n2];
                    for (int j = 0; j < n2; ++j) {
                        this.fanIndices[i][j] = Integer.parseInt(stringArray2[j]);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            IOut.p(this.fanIndices.length + " fans");
        }

        public IMesh instantiatePolygon(VertexBufferType vertexBufferType) {
            int n;
            if (this.triangleIndices == null && this.stripIndices == null && this.fanIndices == null) {
                return null;
            }
            this.mesh = new IMesh();
            if (this.triangleIndices != null) {
                IVertex[] iVertexArray = new IVertex[this.triangleIndices.length];
                for (int i = 0; i < this.triangleIndices.length; ++i) {
                    iVertexArray[i] = vertexBufferType.getVertex(this.triangleIndices[i]);
                    if (iVertexArray[i] != null) continue;
                    IOut.err("vertex[" + this.triangleIndices[i] + "] doesn't exist for triangle indices");
                }
                this.mesh.addTriangles(iVertexArray);
            }
            if (this.stripIndices != null) {
                for (int i = 0; i < this.stripIndices.length; ++i) {
                    IVertex[] iVertexArray = new IVertex[this.stripIndices[i].length];
                    for (n = 0; n < this.stripIndices[i].length; ++n) {
                        iVertexArray[n] = vertexBufferType.getVertex(this.stripIndices[i][n]);
                        if (iVertexArray[n] != null) continue;
                        IOut.err("vertex[" + this.stripIndices[i][n] + "] doesn't exist for strip indices");
                    }
                    this.mesh.addTriangleStrip(iVertexArray);
                }
            }
            if (this.fanIndices != null) {
                for (int i = 0; i < this.fanIndices.length; ++i) {
                    IVertex[] iVertexArray = new IVertex[this.fanIndices[i].length];
                    for (n = 0; n < this.fanIndices[i].length; ++n) {
                        iVertexArray[n] = vertexBufferType.getVertex(this.fanIndices[i][n]);
                        if (iVertexArray[n] != null) continue;
                        IOut.err("vertex[" + this.fanIndices[i][n] + "] doesn't exist for fan indices");
                    }
                    this.mesh.addTriangleFan(iVertexArray);
                }
            }
            return this.mesh;
        }
    }

    public static class TextureCoordinatesBufferType {
        public String value;
        public int channel;
        public TextureDimensionType dimension;
        public double[][] textureXYZ;

        public TextureCoordinatesBufferType() {
        }

        public TextureCoordinatesBufferType(TextureCoordinatesBufferType textureCoordinatesBufferType) {
            if (textureCoordinatesBufferType.value != null) {
                this.value = new String(textureCoordinatesBufferType.value);
            }
            this.channel = textureCoordinatesBufferType.channel;
            this.dimension = textureCoordinatesBufferType.dimension;
            if (textureCoordinatesBufferType.textureXYZ != null) {
                this.textureXYZ = new double[textureCoordinatesBufferType.textureXYZ.length][];
                for (int i = 0; i < textureCoordinatesBufferType.textureXYZ.length; ++i) {
                    this.textureXYZ[i] = new double[textureCoordinatesBufferType.textureXYZ[i].length];
                    for (int j = 0; j < textureCoordinatesBufferType.textureXYZ[i].length; ++j) {
                        this.textureXYZ[i][j] = textureCoordinatesBufferType.textureXYZ[i][j];
                    }
                }
            }
        }

        public void setTextureCoordinates(String string) {
            int n = 0;
            if (this.dimension == TextureDimensionType._1D) {
                n = 1;
            } else if (this.dimension == TextureDimensionType._2D) {
                n = 2;
            } else if (this.dimension == TextureDimensionType._3D) {
                n = 3;
            }
            this.textureXYZ = VertexBufferType.parseXYZ(string, n);
        }

        public static enum TextureDimensionType {
            _1D,
            _2D,
            _3D;

        }
    }

    public static class ColorBufferType {
        public ColorBufferType format;
        public String value;

        public ColorBufferType() {
        }

        public ColorBufferType(ColorBufferType colorBufferType) {
            this.format = colorBufferType.format;
            if (colorBufferType.value != null) {
                this.value = new String(colorBufferType.value);
            }
        }

        public static enum ColorFormatType {
            RGB,
            RGBA;

        }
    }

    public static class VertexBufferType {
        public ArrayList<TextureCoordinatesBufferType> textureCoordinates = new ArrayList();
        public ColorBufferType diffuseColors;
        public ColorBufferType specularColors;
        public IVec[] normals;
        public IVertex[] vertices;

        public VertexBufferType() {
        }

        public VertexBufferType(VertexBufferType vertexBufferType) {
            int n;
            if (vertexBufferType.textureCoordinates != null) {
                for (n = 0; n < vertexBufferType.textureCoordinates.size(); ++n) {
                    this.textureCoordinates.add(new TextureCoordinatesBufferType(vertexBufferType.textureCoordinates.get(n)));
                }
            }
            if (vertexBufferType.diffuseColors != null) {
                this.diffuseColors = new ColorBufferType(vertexBufferType.diffuseColors);
            }
            if (vertexBufferType.specularColors != null) {
                this.specularColors = new ColorBufferType(vertexBufferType.specularColors);
            }
            if (vertexBufferType.normals != null) {
                this.normals = new IVec[vertexBufferType.normals.length];
                for (n = 0; n < vertexBufferType.normals.length; ++n) {
                    this.normals[n] = new IVec(vertexBufferType.normals[n]);
                }
            }
            if (vertexBufferType.vertices != null) {
                this.vertices = new IVertex[vertexBufferType.vertices.length];
                for (n = 0; n < vertexBufferType.vertices.length; ++n) {
                    this.vertices[n] = new IVertex(vertexBufferType.vertices[n]);
                }
            }
        }

        public void transform(IMatrix4 iMatrix4) {
            if (this.vertices == null || iMatrix4 == null) {
                return;
            }
            for (int i = 0; i < this.vertices.length; ++i) {
                this.vertices[i].transform(iMatrix4);
            }
        }

        static IVertex[] parseVertex(String string, int n) {
            String[] stringArray = string.split("\\s*,\\s*");
            int n2 = stringArray.length;
            IVertex[] iVertexArray = new IVertex[n2];
            for (int i = 0; i < n2; ++i) {
                String[] stringArray2 = stringArray[i].split("\\s+");
                if (stringArray2.length >= n) {
                    try {
                        double[] dArray = new double[n];
                        for (int j = 0; j < n; ++j) {
                            dArray[j] = Double.parseDouble(stringArray2[j]);
                        }
                        iVertexArray[i] = new IVertex(dArray[0], n >= 2 ? dArray[1] : 0.0, n >= 3 ? dArray[2] : 0.0);
                    }
                    catch (Exception exception) {
                        IOut.err("wrong format: " + stringArray[i]);
                        exception.printStackTrace();
                    }
                    continue;
                }
                IOut.err("wrong format: " + stringArray[i]);
            }
            return iVertexArray;
        }

        static IVec[] parseVector(String string, int n) {
            String[] stringArray = string.split("\\s*,\\s*");
            int n2 = stringArray.length;
            IVec[] iVecArray = new IVec[n2];
            for (int i = 0; i < n2; ++i) {
                String[] stringArray2 = stringArray[i].split("\\s+");
                if (stringArray2.length >= n) {
                    try {
                        double[] dArray = new double[n];
                        for (int j = 0; j < n; ++j) {
                            dArray[j] = Double.parseDouble(stringArray2[j]);
                        }
                        iVecArray[i] = new IVec(dArray[0], n >= 2 ? dArray[1] : 0.0, n >= 3 ? dArray[2] : 0.0);
                    }
                    catch (Exception exception) {
                        IOut.err("wrong format: " + stringArray[i]);
                        exception.printStackTrace();
                    }
                    continue;
                }
                IOut.err("wrong format: " + stringArray[i]);
            }
            return iVecArray;
        }

        static double[][] parseXYZ(String string, int n) {
            String[] stringArray = string.split("\\s*,\\s*");
            int n2 = stringArray.length;
            double[][] dArrayArray = new double[n2][];
            for (int i = 0; i < n2; ++i) {
                String[] stringArray2 = stringArray[i].split("\\s+");
                if (stringArray2.length >= n) {
                    try {
                        dArrayArray[i] = new double[n];
                        for (int j = 0; j < n; ++j) {
                            dArrayArray[i][j] = Double.parseDouble(stringArray2[j]);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        IOut.err("wrong format: " + stringArray[i]);
                        exception.printStackTrace();
                        continue;
                    }
                }
                IOut.err("wrong format: " + stringArray[i]);
            }
            return dArrayArray;
        }

        public void setPositions(String string) {
            this.vertices = VertexBufferType.parseVertex(string, 3);
            if (this.normals != null) {
                for (int i = 0; i < this.vertices.length && i < this.normals.length; ++i) {
                    this.vertices[i].setNormal(this.normals[i]);
                }
            }
        }

        public void setNormals(String string) {
            this.normals = VertexBufferType.parseVector(string, 3);
            if (this.vertices != null) {
                for (int i = 0; i < this.vertices.length && i < this.normals.length; ++i) {
                    this.vertices[i].setNormal(this.normals[i]);
                }
            }
        }

        public int getVertexNum() {
            if (this.vertices == null) {
                return 0;
            }
            return this.vertices.length;
        }

        public int getNormalNum() {
            if (this.normals == null) {
                return 0;
            }
            return this.normals.length;
        }

        public IVertex getVertex(int n) {
            if (n < 0 || n >= this.getVertexNum()) {
                return null;
            }
            return this.vertices[n];
        }

        public IVec getNormal(int n) {
            if (n < 0 || n >= this.getNormalNum()) {
                return null;
            }
            return this.normals[n];
        }
    }

    public static class PolylineGPType {
        public LineAttributesType lineAttributes;
        public String vertices;
    }

    public static class PolylineSetType {
        public LineAttributesType lineAttributes;
        public ArrayList<PolylineGPType> polyline = new ArrayList();
    }

    public static class FaceSetType {
        public SurfaceAttributesType surfaceAttributes;
        public ArrayList<FaceGPType> faces = new ArrayList();

        public ArrayList<IMesh> instantiatePolygon(VertexBufferType vertexBufferType) {
            ArrayList<IMesh> arrayList = new ArrayList<IMesh>();
            for (int i = 0; i < this.faces.size(); ++i) {
                IMesh iMesh = this.faces.get(i).instantiatePolygon(vertexBufferType);
                if (iMesh == null) continue;
                arrayList.add(iMesh);
            }
            return arrayList;
        }
    }

    public static class ColorType {
        public double red;
        public double blue;
        public double green;
        public double alpha;
    }

    public static class PolygonalLODType {
    }

    public static class MaterialApplicationType {
        public String id;
        public int mappingChannel;
        public MappingSideType mappingSide;
        public TextureBlendFunctionType blendType;

        public static enum TextureBlendFunctionType {
            REPLACE,
            ADD,
            ALPHA_TRANSPARENCY,
            LIGHTMAP,
            BURN,
            INVERT;

        }

        public static enum MappingSideType {
            FRONT,
            BACK,
            FRONT_AND_BACK;

        }
    }

    public static class PointAttributesType {
        public ColorType color;
        public PointSymbolType symbolType = PointSymbolType.DOT;

        public static enum PointSymbolType {
            CROSS,
            PLUS,
            CONCENTRIC,
            COINCIDENT,
            FULLCIRCLE,
            FULLSQUARE,
            STAR,
            DOT,
            SMALLDOT;

        }
    }

    public static class LineAttributesType {
        public ColorType color;
        public LineTypeType lineType = LineTypeType.SOLID;
        public double thickness;

        public static enum LineTypeType {
            SOLID,
            DOTTED,
            DASHED,
            DOT_DASHED,
            PHANTOM,
            SMALL_DOTTED,
            JIS_AXIS;

        }
    }

    public static class SurfaceAttributesType {
        public ColorType color;
        public ArrayList<MaterialApplicationType> materialApplication;
    }

    public static class PolygonalRepType
    extends VisualizationRepType {
        public SurfaceAttributesType surfaceAttributes;
        public LineAttributesType lineAttributes;
        public ArrayList<FaceSetType> faces = new ArrayList();
        public ArrayList<PolylineSetType> edges = new ArrayList();
        public VertexBufferType vertexBuffer;
        public ArrayList<PolygonalLODType> polygonalLOD = new ArrayList();
        public double accuracy;
        public boolean solid;

        public PolygonalRepType(int n) {
            super(n);
        }

        public PolygonalRepType() {
        }

        @Override
        public ArrayList<IMesh> instantiatePolygon(IMatrix4 iMatrix4) {
            if (this.faces != null && this.faces.size() > 0) {
                VertexBufferType vertexBufferType = new VertexBufferType(this.vertexBuffer);
                vertexBufferType.transform(iMatrix4);
                ArrayList<IMesh> arrayList = new ArrayList<IMesh>();
                for (int i = 0; i < this.faces.size(); ++i) {
                    ArrayList<IMesh> arrayList2 = this.faces.get(i).instantiatePolygon(vertexBufferType);
                    if (arrayList2 == null) continue;
                    arrayList.addAll(arrayList2);
                }
                return arrayList;
            }
            return null;
        }

        @Override
        public ArrayList<ICurve> instantiatePolyline(IMatrix4 iMatrix4) {
            return null;
        }
    }

    public static class BagRepType
    extends VisualizationRepType {
        public ArrayList<VisualizationRepType> rep = new ArrayList();

        public BagRepType() {
        }

        public BagRepType(int n) {
            super(n);
        }

        @Override
        public ArrayList<IMesh> instantiatePolygon(IMatrix4 iMatrix4) {
            if (this.rep != null && this.rep.size() > 0) {
                ArrayList<IMesh> arrayList = new ArrayList<IMesh>();
                for (int i = 0; i < this.rep.size(); ++i) {
                    ArrayList<IMesh> arrayList2 = this.rep.get(i).instantiatePolygon(iMatrix4);
                    if (arrayList2 == null) continue;
                    arrayList.addAll(arrayList2);
                }
                return arrayList;
            }
            return null;
        }

        @Override
        public ArrayList<ICurve> instantiatePolyline(IMatrix4 iMatrix4) {
            if (this.rep != null && this.rep.size() > 0) {
                ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
                for (int i = 0; i < this.rep.size(); ++i) {
                    ArrayList<ICurve> arrayList2 = this.rep.get(i).instantiatePolyline(iMatrix4);
                    if (arrayList2 == null) continue;
                    arrayList.addAll(arrayList2);
                }
                return arrayList;
            }
            return null;
        }
    }

    public static class VisualizationRepType {
        public int id;

        public VisualizationRepType(int n) {
            this.id = n;
        }

        public VisualizationRepType() {
            this.id = -1;
        }

        public ArrayList<IMesh> instantiatePolygon(IMatrix4 iMatrix4) {
            return null;
        }

        public ArrayList<ICurve> instantiatePolyline(IMatrix4 iMatrix4) {
            return null;
        }
    }

    public static class Matrix4x3 {
        public double[][] val = new double[4][3];

        public Matrix4x3() {
        }

        public Matrix4x3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
            this();
            this.val[0][0] = d;
            this.val[0][1] = d2;
            this.val[0][2] = d3;
            this.val[1][0] = d4;
            this.val[1][1] = d5;
            this.val[1][2] = d6;
            this.val[2][0] = d7;
            this.val[2][1] = d8;
            this.val[2][2] = d9;
            this.val[3][0] = d10;
            this.val[3][1] = d11;
            this.val[3][2] = d12;
        }

        public Matrix4x3(double[] dArray) {
            this();
            if (dArray != null && dArray.length >= 12) {
                this.val[0][0] = dArray[0];
                this.val[0][1] = dArray[1];
                this.val[0][2] = dArray[2];
                this.val[1][0] = dArray[3];
                this.val[1][1] = dArray[4];
                this.val[1][2] = dArray[5];
                this.val[2][0] = dArray[6];
                this.val[2][1] = dArray[7];
                this.val[2][2] = dArray[8];
                this.val[3][0] = dArray[9];
                this.val[3][1] = dArray[10];
                this.val[3][2] = dArray[11];
            }
        }

        public Matrix4x3(IMatrix3 iMatrix3, IVec iVec) {
            this(iMatrix3.val[0][0], iMatrix3.val[0][1], iMatrix3.val[0][2], iMatrix3.val[1][0], iMatrix3.val[1][1], iMatrix3.val[1][2], iMatrix3.val[2][0], iMatrix3.val[2][1], iMatrix3.val[2][2], iVec.x, iVec.y, iVec.z);
        }

        public String toString() {
            return String.valueOf(this.val[0][0]) + " " + String.valueOf(this.val[0][1]) + " " + String.valueOf(this.val[0][2]) + " \n" + String.valueOf(this.val[1][0]) + " " + String.valueOf(this.val[1][1]) + " " + String.valueOf(this.val[1][2]) + " \n" + String.valueOf(this.val[2][0]) + " " + String.valueOf(this.val[2][1]) + " " + String.valueOf(this.val[2][2]) + " \n" + String.valueOf(this.val[3][0]) + " " + String.valueOf(this.val[3][1]) + " " + String.valueOf(this.val[3][2]) + " \n";
        }

        public IMatrix4 getIMatrix4() {
            return new IMatrix4(this.val[0][0], this.val[1][0], this.val[2][0], this.val[3][0], this.val[0][1], this.val[1][1], this.val[2][1], this.val[3][1], this.val[0][2], this.val[1][2], this.val[2][2], this.val[3][2], 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static class InstanceRep
    extends I3DXMLNode {
        public int aggregatedBy;
        public int instanceOf;
        public I3DXMLNode aggregatedNode;
        public ReferenceRep referenceRep;

        public InstanceRep() {
        }

        public InstanceRep(int n) {
            super(n);
        }

        public InstanceRep(int n, String string) {
            super(n, string);
        }

        public void link(I3DXML i3DXML) {
            this.aggregatedNode = i3DXML.getNode(this.aggregatedBy);
            this.referenceRep = (ReferenceRep)i3DXML.getNode(this.instanceOf);
            if (this.aggregatedNode == null) {
                IOut.err("no aggregatedNode found");
            }
            if (this.referenceRep == null) {
                IOut.err("no reference found");
            }
            if (this.aggregatedNode instanceof Reference3D) {
                ((Reference3D)this.aggregatedNode).addComponent(this);
            }
            this.referenceRep.addInstance(this);
        }

        @Override
        public ArrayList<IGeometry> instantiate(IMatrix4 iMatrix4) {
            if (this.referenceRep != null) {
                return this.referenceRep.instantiate(iMatrix4);
            }
            return null;
        }
    }

    public static class ReferenceRep
    extends I3DXMLNode {
        public ArrayList<I3DXMLNode> instanceReps;
        public FormatType format;
        public String associatedFile;
        public String associatedURN;
        public RepresentationDocument representationDocument = null;

        public ReferenceRep() {
        }

        public ReferenceRep(int n) {
            super(n);
        }

        public ReferenceRep(int n, String string) {
            super(n, string);
        }

        public void addInstance(InstanceRep instanceRep) {
            if (this.instanceReps == null) {
                this.instanceReps = new ArrayList();
            }
            this.instanceReps.add(instanceRep);
        }

        public ArrayList<IMesh> instantiatePolygon(IMatrix4 iMatrix4) {
            if (this.representationDocument != null) {
                return this.representationDocument.instantiatePolygon(iMatrix4);
            }
            return null;
        }

        public ArrayList<ICurve> instantiatePolyline(IMatrix4 iMatrix4) {
            if (this.representationDocument != null) {
                return this.representationDocument.instantiatePolyline(iMatrix4);
            }
            return null;
        }

        @Override
        public ArrayList<IGeometry> instantiate(IMatrix4 iMatrix4) {
            int n;
            ArrayList<IMesh> arrayList = this.instantiatePolygon(iMatrix4);
            ArrayList<ICurve> arrayList2 = this.instantiatePolyline(iMatrix4);
            ArrayList<IGeometry> arrayList3 = new ArrayList<IGeometry>();
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    arrayList3.add(arrayList.get(n));
                }
            }
            if (arrayList2 != null) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    arrayList3.add(arrayList2.get(n));
                }
            }
            return arrayList3;
        }

        public static enum FormatType {
            UVR,
            TECHREP,
            TESSELLATED,
            BEHAVIORAL,
            OTHER;

        }
    }

    public static class Instance3D
    extends I3DXMLNode {
        public int aggregatedBy;
        public int instanceOf;
        public Matrix4x3 relativeMatrix;
        public I3DXMLNode aggregatedNode;
        public Reference3D reference;

        public Instance3D() {
        }

        public Instance3D(int n) {
            super(n);
        }

        public Instance3D(int n, String string) {
            super(n, string);
        }

        public void link(I3DXML i3DXML) {
            this.aggregatedNode = i3DXML.getNode(this.aggregatedBy);
            this.reference = (Reference3D)i3DXML.getNode(this.instanceOf);
            if (this.aggregatedNode == null) {
                IOut.err("no aggregatedNode found");
            }
            if (this.reference == null) {
                IOut.err("no reference found");
            }
            if (this.aggregatedNode instanceof Reference3D) {
                ((Reference3D)this.aggregatedNode).addComponent(this);
            }
            this.reference.addInstance(this);
        }

        @Override
        public ArrayList<IGeometry> instantiate(IMatrix4 iMatrix4) {
            if (this.reference != null) {
                Object object;
                Object object2;
                IMatrix4 iMatrix42 = null;
                if (iMatrix4 != null) {
                    if (this.relativeMatrix == null) {
                        iMatrix42 = iMatrix4.cp();
                    } else {
                        object2 = iMatrix4.getMatrix3();
                        IVec iVec = iMatrix4.getTranslateVector();
                        object = this.relativeMatrix.getIMatrix4();
                        IMatrix3 iMatrix3 = ((IMatrix4)object).getMatrix3();
                        IVec iVec2 = ((IMatrix4)object).getTranslateVector();
                        iVec.add(((IMatrix3)object2).mul(iVec2));
                        ((IMatrix3)object2).mul(iMatrix3);
                        iMatrix42 = new IMatrix4((IMatrix3)object2, iVec);
                    }
                } else {
                    iMatrix42 = this.relativeMatrix.getIMatrix4();
                }
                object2 = this.reference.instantiate(iMatrix42);
                if (this.name != null) {
                    for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                        object = ((IGeometry)((ArrayList)object2).get(i)).name();
                        object = object != null ? this.name + nameDelimiter + (String)object : this.name;
                        ((IGeometry)((ArrayList)object2).get(i)).name((String)object);
                    }
                }
                return object2;
            }
            return null;
        }
    }

    public static class Reference3D
    extends I3DXMLNode {
        public ArrayList<I3DXMLNode> components;
        public ArrayList<I3DXMLNode> instances;

        public Reference3D() {
        }

        public Reference3D(int n) {
            super(n);
        }

        public Reference3D(int n, String string) {
            super(n, string);
        }

        public void addInstance(Instance3D instance3D) {
            if (this.instances == null) {
                this.instances = new ArrayList();
            }
            this.instances.add(instance3D);
        }

        public void addComponent(I3DXMLNode i3DXMLNode) {
            if (this.components == null) {
                this.components = new ArrayList();
            }
            this.components.add(i3DXMLNode);
        }

        @Override
        public ArrayList<IGeometry> instantiate(IMatrix4 iMatrix4) {
            if (this.components != null) {
                ArrayList<IGeometry> arrayList = new ArrayList<IGeometry>();
                for (int i = 0; i < this.components.size(); ++i) {
                    ArrayList<IGeometry> arrayList2 = this.components.get(i).instantiate(iMatrix4);
                    if (arrayList2 == null) continue;
                    arrayList.addAll(arrayList2);
                }
                return arrayList;
            }
            return null;
        }
    }

    public static class I3DXMLNode {
        static String nameDelimiter = "/";
        public int id;
        public String name;

        public I3DXMLNode() {
        }

        public I3DXMLNode(int n) {
            this.id = n;
        }

        public I3DXMLNode(int n, String string) {
            this.id = n;
            this.name = string;
        }

        public ArrayList<IGeometry> instantiate(IMatrix4 iMatrix4) {
            return null;
        }
    }
}

