/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.IBrep;
import igeo.IColor;
import igeo.IComparator;
import igeo.IConfig;
import igeo.ICurveI;
import igeo.IFace;
import igeo.IG;
import igeo.IGeometry;
import igeo.IMeshI;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IPointR;
import igeo.IServerI;
import igeo.ISort;
import igeo.ISurfaceI;
import igeo.IText;
import igeo.ITransformable;
import igeo.ITrimCurveI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVecI;
import igeo.gui.IView;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

public class IAIExporter {
    public static boolean ignoreOutOfView = false;
    public static boolean enableScreenBoundaryIntersection = true;
    public static boolean enableViewBasedWeight = false;
    public static double viewBasedWeightScale = 100.0;
    public static double minViewBasedWeight = 0.01;
    public static double maxViewBasedWeight = 10.0;
    public static double minimumPoint = 1.0E-5f;
    public static double defaultLineWeight = 0.25;
    public static double defaultPointWeight = 0.5;
    public static boolean writeSubsurfaceAsMesh = false;
    public static boolean writeOutlineWhenMesh = false;
    public static double internalScaleFactor = 4.667;
    public static double internalXShift = -49.9;
    public static double internalYShift = -39.9;
    public static boolean fillClosedCurve = false;
    public static NumberFormat f;

    public static void initFormat() {
        f = NumberFormat.getInstance();
        if (f instanceof DecimalFormat) {
            ((DecimalFormat)f).setDecimalSeparatorAlwaysShown(false);
            ((DecimalFormat)f).setMaximumFractionDigits(50);
            ((DecimalFormat)f).setMinimumFractionDigits(0);
            ((DecimalFormat)f).setGroupingUsed(false);
        } else {
            IOut.err("Not DecimalFormat");
        }
    }

    public static void writeHeader(PrintStream printStream) {
        printStream.println("%!PS-Adobe-3.0");
        printStream.println("%%Creator: Java");
        printStream.println("%%BoundingBox: 0 0 1000 1000");
        printStream.println("%%DocumentProcessColors: Black");
        printStream.println("%%DocumentNeededResources: procset Adobe_packedarray 2.0 0");
        printStream.println("%%+ procset Adobe_cmykcolor 1.1 0");
        printStream.println("%%+ procset Adobe_cshow 1.1 0");
        printStream.println("%%+ procset Adobe_customcolor 1.0 0");
        printStream.println("%%+ procset Adobe_typography_AI3 1.0 0");
        printStream.println("%%+ procset Adobe_IllustratorA_AI3 1.0 0");
        printStream.println("%AI3_ColorUsage: Color");
        printStream.println("%AI3_DocumentPreview: None");
        printStream.println("%%Template:");
        printStream.println("%%PageOrigin:0 0");
        printStream.println("%%EndComments");
        printStream.println("%%BeginProlog");
        printStream.println("%%IncludeResource: procset Adobe_packedarray 2.0 0");
        printStream.println("Adobe_packedarray /initialize get exec");
        printStream.println("%%IncludeResource: procset Adobe_cmykcolor 1.1 0");
        printStream.println("%%IncludeResource: procset Adobe_cshow 1.1 0");
        printStream.println("%%IncludeResource: procset Adobe_customcolor 1.0 0");
        printStream.println("%%IncludeResource: procset Adobe_typography_AI3 1.0 0");
        printStream.println("%%IncludeResource: procset Adobe_IllustratorA_AI3 1.0 0");
        printStream.println("%%EndProlog");
        printStream.println("%%BeginSetup");
        printStream.println("Adobe_cmykcolor /initialize get exec");
        printStream.println("Adobe_cshow /initialize get exec");
        printStream.println("Adobe_customcolor /initialize get exec");
        printStream.println("Adobe_typography_AI3 /initialize get exec");
        printStream.println("Adobe_IllustratorA_AI3 /initialize get exec");
        printStream.println("%%EndSetup");
    }

    public static void convertCoordinates(IVec2 iVec2, double d, IView iView) {
        iVec2.y = (double)iView.screenHeight - iVec2.y;
        if (iView.isAxonometric()) {
            iVec2.x *= d * 72.0 / iView.getAxonometricRatio();
            iVec2.y *= d * 72.0 / iView.getAxonometricRatio();
        } else {
            iVec2.x *= d;
            iVec2.y *= d;
        }
        iVec2.x *= internalScaleFactor;
        iVec2.y *= internalScaleFactor;
        iVec2.x += internalXShift * 72.0;
        iVec2.y += internalYShift * 72.0;
    }

    public static void writeBezierCurvePaths(PrintStream printStream, ArrayList<ArrayList<IVec2>> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IAIExporter.writeBezierCurvePath(printStream, arrayList.get(i), bl && i == 0);
        }
    }

    public static void writeBezierCurvePath(PrintStream printStream, ArrayList<IVec2> arrayList, boolean bl) {
        if (arrayList.size() % 3 != 1) {
            IOut.err("wrong number of points " + arrayList.size());
        }
        for (int i = 0; i < (arrayList.size() - 1) / 3; ++i) {
            if (i == 0) {
                if (bl) {
                    printStream.print(f.format(arrayList.get((int)(i * 3)).x) + " " + f.format(arrayList.get((int)(i * 3)).y) + " ");
                    printStream.println("m");
                } else {
                    printStream.print("%%");
                    printStream.print(f.format(arrayList.get((int)(i * 3)).x) + " " + f.format(arrayList.get((int)(i * 3)).y) + " ");
                    printStream.println("m");
                }
            }
            printStream.print(f.format(arrayList.get((int)(i * 3 + 1)).x) + " " + f.format(arrayList.get((int)(i * 3 + 1)).y) + " ");
            printStream.print(f.format(arrayList.get((int)(i * 3 + 2)).x) + " " + f.format(arrayList.get((int)(i * 3 + 2)).y) + " ");
            printStream.print(f.format(arrayList.get((int)(i * 3 + 3)).x) + " " + f.format(arrayList.get((int)(i * 3 + 3)).y) + " ");
            if (i == (arrayList.size() - 1) / 3 - 1) {
                printStream.println("C");
                continue;
            }
            printStream.println("c");
        }
    }

    public static void writePolylinePaths(PrintStream printStream, ArrayList<ArrayList<IVec2>> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IAIExporter.writePolylinePath(printStream, arrayList.get(i), bl && i == 0);
        }
    }

    public static void writePolylinePath(PrintStream printStream, ArrayList<IVec2> arrayList, boolean bl) {
        for (int i = 0; i < arrayList.size(); ++i) {
            IVec2 iVec2 = arrayList.get(i);
            if (i == 0) {
                if (bl) {
                    printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                    printStream.println("m");
                    continue;
                }
                printStream.print("%%");
                printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                printStream.println("m");
                continue;
            }
            printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
            if (i == arrayList.size() - 1) {
                printStream.println("L");
                continue;
            }
            printStream.println("l");
        }
    }

    public static void writePolylinePath(PrintStream printStream, IVec2[] iVec2Array, boolean bl) {
        for (int i = 0; i < iVec2Array.length; ++i) {
            IVec2 iVec2 = iVec2Array[i];
            if (i == 0) {
                if (bl) {
                    printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                    printStream.println("m");
                    continue;
                }
                printStream.print("%%");
                printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                printStream.println("m");
                continue;
            }
            printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
            if (i == iVec2Array.length - 1) {
                printStream.println("L");
                continue;
            }
            printStream.println("l");
        }
    }

    public static void writeClosedPolylinePath(PrintStream printStream, IVec2[] iVec2Array, boolean bl) {
        for (int i = 0; i < iVec2Array.length; ++i) {
            IVec2 iVec2 = iVec2Array[i];
            if (i == 0) {
                if (bl) {
                    printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                    printStream.println("m");
                    continue;
                }
                printStream.print("%%");
                printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
                printStream.println("m");
                continue;
            }
            printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
            if (i == iVec2Array.length - 1) {
                printStream.println("l");
                printStream.print(f.format(iVec2Array[0].x) + " " + f.format(iVec2Array[0].y) + " ");
                printStream.println("l");
                continue;
            }
            printStream.println("l");
        }
    }

    public static void writePointPath(PrintStream printStream, IVec2 iVec2) {
        printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
        printStream.println("m");
        printStream.print(f.format(iVec2.x) + " " + f.format(iVec2.y) + " ");
        printStream.println("L");
    }

    public static ArrayList<ArrayList<IVec2>> createPolylinePointArrayList(IVec2[] iVec2Array) {
        ArrayList<ArrayList<IVec2>> arrayList = new ArrayList<ArrayList<IVec2>>();
        arrayList.add(new ArrayList());
        for (int i = 0; i < iVec2Array.length; ++i) {
            if (iVec2Array[i] != null) {
                arrayList.get(arrayList.size() - 1).add(iVec2Array[i]);
                continue;
            }
            if (arrayList.get(arrayList.size() - 1).size() <= 0) continue;
            arrayList.add(new ArrayList());
        }
        if (arrayList.size() > 1 && iVec2Array[0] != null && iVec2Array[iVec2Array.length - 1] != null) {
            ArrayList<IVec2> arrayList2 = arrayList.get(0);
            ArrayList<IVec2> arrayList3 = arrayList.get(arrayList.size() - 1);
            for (int i = 0; i < arrayList2.size(); ++i) {
                if (i == 0) {
                    if (arrayList2.get(0).eq(arrayList3.get(arrayList3.size() - 1), 0.0)) continue;
                    arrayList3.add(arrayList2.get(i));
                    continue;
                }
                arrayList3.add(arrayList2.get(i));
            }
            arrayList.remove(0);
        }
        return arrayList;
    }

    public static void writePaintStyle(PrintStream printStream, IColor iColor, IColor iColor2, double d, CapType capType, JoinType joinType) {
        printStream.println("0 A");
        if (iColor != null) {
            printStream.println("0 O");
        }
        if (iColor2 != null) {
            printStream.println("0 R");
        }
        double d2 = 1.0;
        if (iColor != null) {
            printStream.println(f.format((double)iColor.getRed() / 255.0) + " " + f.format((double)iColor.getGreen() / 255.0) + " " + f.format((double)iColor.getBlue() / 255.0) + " " + "Xa");
            d2 = (double)iColor.getAlpha() / 255.0;
        }
        if (iColor2 != null) {
            printStream.println(f.format((double)iColor2.getRed() / 255.0) + " " + f.format((double)iColor2.getGreen() / 255.0) + " " + f.format((double)iColor2.getBlue() / 255.0) + " " + "XA");
            if (iColor == null) {
                d2 = (double)iColor2.getAlpha() / 255.0;
            }
        }
        printStream.println("0 " + f.format(d2) + " 0 0 0 Xy");
        int n = 0;
        switch (capType) {
            case Butt: {
                n = 0;
                break;
            }
            case Round: {
                n = 1;
                break;
            }
            case Square: {
                n = 2;
            }
        }
        int n2 = 0;
        switch (joinType) {
            case Miter: {
                n2 = 0;
                break;
            }
            case Round: {
                n2 = 1;
                break;
            }
            case Bevel: {
                n2 = 2;
            }
        }
        printStream.println(n + " J " + n2 + " j " + f.format(d) + " w 4 M []0 d");
    }

    public static void writePaintStyle(PrintStream printStream, IColor iColor, IColor iColor2, double d) {
        printStream.println("0 A");
        if (iColor != null) {
            printStream.println("0 O");
        }
        if (iColor2 != null) {
            printStream.println("0 R");
        }
        double d2 = 1.0;
        if (iColor != null) {
            printStream.println(f.format((double)iColor.getRed() / 255.0) + " " + f.format((double)iColor.getGreen() / 255.0) + " " + f.format((double)iColor.getBlue() / 255.0) + " " + "Xa");
            d2 = (double)iColor.getAlpha() / 255.0;
        }
        if (iColor2 != null) {
            printStream.println(f.format((double)iColor2.getRed() / 255.0) + " " + f.format((double)iColor2.getGreen() / 255.0) + " " + f.format((double)iColor2.getBlue() / 255.0) + " " + "XA");
            if (iColor == null) {
                d2 = (double)iColor2.getAlpha() / 255.0;
            }
        }
        printStream.println("0 " + f.format(d2) + " 0 0 0 Xy");
        printStream.println("0 J 0 j " + f.format(d) + " w 4 M []0 d");
    }

    public static IVec[] createBezierPoints(ICurveI iCurveI) {
        int n;
        int n2 = iCurveI.epNum() * IConfig.segmentResolution;
        IVec[] iVecArray = new IVec[n2 * 3 - 2];
        IVec[] iVecArray2 = new IVec[n2];
        IVec[] iVecArray3 = new IVec[n2];
        for (n = 0; n < n2; ++n) {
            iVecArray2[n] = iCurveI.pt((double)n / (double)(n2 - 1)).get();
            iVecArray3[n] = iCurveI.tan((double)n / (double)(n2 - 1)).get();
            iVecArray3[n].div(n2 * 3);
        }
        for (n = 0; n < n2; ++n) {
            iVecArray[3 * n] = iVecArray2[n];
            if (n <= 0) continue;
            iVecArray[3 * n - 2] = iVecArray2[n - 1].sum(iVecArray3[n - 1]);
            iVecArray[3 * n - 1] = iVecArray2[n].dif(iVecArray3[n]);
        }
        return iVecArray;
    }

    public static ArrayList<ArrayList<IVec2>> convertTo2DPoints(ICurveI iCurveI, double d, IView iView) {
        int n;
        IVec2[] iVec2Array = null;
        boolean bl = false;
        if (iCurveI.deg() > 1 || iCurveI instanceof ITrimCurveI && !((ITrimCurveI)iCurveI).surface().isFlat()) {
            int n2;
            n = 0;
            IVec[] iVecArray = IAIExporter.createBezierPoints(iCurveI);
            int n3 = (iVecArray.length + 2) / 3;
            iVec2Array = new IVec2[n3 * 3 - 2];
            for (n2 = 0; n2 < n3; ++n2) {
                iVec2Array[3 * n2] = new IVec2();
                n = iView.convert((IVecI)iVecArray[3 * n2], iVec2Array[3 * n2]) ? 1 : 0;
                if (!ignoreOutOfView && n == 0 && !iView.isAxonometric()) {
                    iVec2Array[3 * n2] = null;
                }
                if (n2 <= 0) continue;
                iVec2Array[3 * n2 - 2] = new IVec2();
                iVec2Array[3 * n2 - 1] = new IVec2();
                n = iView.convert((IVecI)iVecArray[3 * n2 - 2], iVec2Array[3 * n2 - 2]) ? 1 : 0;
                if (!ignoreOutOfView && n == 0 && !iView.isAxonometric()) {
                    iVec2Array[3 * n2 - 2] = null;
                }
                n = iView.convert((IVecI)iVecArray[3 * n2 - 1], iVec2Array[3 * n2 - 1]) ? 1 : 0;
                if (!ignoreOutOfView && n == 0 && !iView.isAxonometric()) {
                    iVec2Array[3 * n2 - 1] = null;
                }
                if (!ignoreOutOfView && (iVec2Array[3 * n2 - 3] == null || iVec2Array[3 * n2 - 2] == null || iVec2Array[3 * n2 - 1] == null || iVec2Array[3 * n2] == null)) continue;
                bl = true;
            }
            if (enableScreenBoundaryIntersection && !ignoreOutOfView && !iView.isAxonometric()) {
                n2 = iVec2Array.length;
                IVec2[] iVec2Array2 = new IVec2[n2 - 1];
                boolean bl2 = false;
                for (int i = 0; i < n2 - 1; ++i) {
                    IVec2 iVec2;
                    IVec2 iVec22;
                    if (iVec2Array[i] == null && iVec2Array[(i + 1) % n2] != null) {
                        iVec22 = new IVec2();
                        iVec2 = new IVec2();
                        n = iView.convertLine((IVecI)iVecArray[i], (IVecI)iVecArray[(i + 1) % n2], iVec22, iVec2) ? 1 : 0;
                        if (n == 0) continue;
                        iVec2Array[i] = iVec22;
                        bl2 = true;
                        continue;
                    }
                    if (iVec2Array[i] == null || iVec2Array[(i + 1) % n2] != null || (n = (int)(iView.convertLine((IVecI)iVecArray[i], (IVecI)iVecArray[(i + 1) % n2], iVec22 = new IVec2(), iVec2 = new IVec2()) ? 1 : 0)) == 0) continue;
                    iVec2Array[i] = iVec2;
                    bl2 = true;
                }
                if (bl2) {
                    int n4;
                    ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
                    for (n4 = 0; n4 < n2; ++n4) {
                        arrayList.add(iVec2Array[n4]);
                    }
                    for (n4 = n2 - 2; n4 >= 0; --n4) {
                        if (iVec2Array2[n4] == null) continue;
                        arrayList.add(n4 + 1, iVec2Array2[n4]);
                    }
                    iVec2Array = arrayList.toArray(new IVec2[arrayList.size()]);
                    bl = true;
                }
            }
        } else if (iCurveI instanceof ITrimCurveI) {
            int n5;
            iVec2Array = new IVec2[iCurveI.cpNum()];
            n = 0;
            ITrimCurveI iTrimCurveI = (ITrimCurveI)iCurveI;
            for (n5 = 0; n5 < iVec2Array.length; ++n5) {
                iVec2Array[n5] = new IVec2();
                n = iView.convert(iTrimCurveI.surface().pt(iCurveI.cp(n5)), iVec2Array[n5]) ? 1 : 0;
                if (!ignoreOutOfView && n == 0 && !iView.isAxonometric()) {
                    iVec2Array[n5] = null;
                }
                if (!ignoreOutOfView && (n5 <= 0 || iVec2Array[n5 - 1] == null || iVec2Array[n5] == null)) continue;
                bl = true;
            }
            if (enableScreenBoundaryIntersection && !ignoreOutOfView && !iView.isAxonometric()) {
                n5 = iVec2Array.length;
                IVec2[] iVec2Array3 = new IVec2[n5 - 1];
                boolean bl3 = false;
                for (int i = 0; i < n5 - 1; ++i) {
                    IVec2 iVec2;
                    IVec2 iVec23;
                    if (iVec2Array[i] == null && iVec2Array[(i + 1) % n5] != null) {
                        iVec23 = new IVec2();
                        iVec2 = new IVec2();
                        n = iView.convertLine(iTrimCurveI.surface().pt(iCurveI.cp(i)), iTrimCurveI.surface().pt(iCurveI.cp((i + 1) % n5)), iVec23, iVec2) ? 1 : 0;
                        if (n == 0) continue;
                        iVec2Array3[i] = iVec23;
                        bl3 = true;
                        continue;
                    }
                    if (iVec2Array[i] == null || iVec2Array[(i + 1) % n5] != null) continue;
                    iVec23 = new IVec2();
                    iVec2 = new IVec2();
                    n = iView.convertLine(iTrimCurveI.surface().pt(iCurveI.cp(i)), iTrimCurveI.surface().pt(iCurveI.cp((i + 1) % n5)), iVec23, iVec2) ? 1 : 0;
                    if (n == 0) continue;
                    iVec2Array3[i] = iVec2;
                    bl3 = true;
                }
                if (bl3) {
                    int n6;
                    ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
                    for (n6 = 0; n6 < n5; ++n6) {
                        arrayList.add(iVec2Array[n6]);
                    }
                    for (n6 = n5 - 2; n6 >= 0; --n6) {
                        if (iVec2Array3[n6] == null) continue;
                        arrayList.add(n6 + 1, iVec2Array3[n6]);
                    }
                    iVec2Array = arrayList.toArray(new IVec2[arrayList.size()]);
                    bl = true;
                }
            }
        } else {
            int n7;
            iVec2Array = new IVec2[iCurveI.cpNum()];
            n = 0;
            for (n7 = 0; n7 < iVec2Array.length; ++n7) {
                iVec2Array[n7] = new IVec2();
                n = iView.convert(iCurveI.cp(n7), iVec2Array[n7]) ? 1 : 0;
                if (!ignoreOutOfView && n == 0 && !iView.isAxonometric()) {
                    iVec2Array[n7] = null;
                }
                if (!ignoreOutOfView && (n7 <= 0 || iVec2Array[n7 - 1] == null || iVec2Array[n7] == null)) continue;
                bl = true;
            }
            if (enableScreenBoundaryIntersection && !ignoreOutOfView && !iView.isAxonometric()) {
                n7 = iVec2Array.length;
                IVec2[] iVec2Array4 = new IVec2[n7 - 1];
                boolean bl4 = false;
                for (int i = 0; i < n7 - 1; ++i) {
                    IVec2 iVec2;
                    IVec2 iVec24;
                    if (iVec2Array[i] == null && iVec2Array[(i + 1) % n7] != null) {
                        iVec24 = new IVec2();
                        iVec2 = new IVec2();
                        n = iView.convertLine(iCurveI.cp(i), iCurveI.cp((i + 1) % n7), iVec24, iVec2) ? 1 : 0;
                        if (n == 0) continue;
                        iVec2Array4[i] = iVec24;
                        bl4 = true;
                        continue;
                    }
                    if (iVec2Array[i] == null || iVec2Array[(i + 1) % n7] != null) continue;
                    iVec24 = new IVec2();
                    iVec2 = new IVec2();
                    n = iView.convertLine(iCurveI.cp(i), iCurveI.cp((i + 1) % n7), iVec24, iVec2) ? 1 : 0;
                    if (n == 0) continue;
                    iVec2Array4[i] = iVec2;
                    bl4 = true;
                }
                if (bl4) {
                    int n8;
                    ArrayList<IVec2> arrayList = new ArrayList<IVec2>();
                    for (n8 = 0; n8 < n7; ++n8) {
                        arrayList.add(iVec2Array[n8]);
                    }
                    for (n8 = n7 - 2; n8 >= 0; --n8) {
                        if (iVec2Array4[n8] == null) continue;
                        arrayList.add(n8 + 1, iVec2Array4[n8]);
                    }
                    iVec2Array = arrayList.toArray(new IVec2[arrayList.size()]);
                    bl = true;
                }
            }
        }
        if (!bl) {
            return null;
        }
        for (n = 0; n < iVec2Array.length; ++n) {
            if (iVec2Array[n] == null) continue;
            IAIExporter.convertCoordinates(iVec2Array[n], d, iView);
        }
        return IAIExporter.createPolylinePointArrayList(iVec2Array);
    }

    public static double weightByView(IVecI iVecI, IView iView) {
        double d = viewBasedWeightScale / iVecI.dif(iView.getLocation()).dot(iView.frontDirection().unit());
        IG.p("view based weight = " + d);
        if (d < minViewBasedWeight) {
            return minViewBasedWeight;
        }
        if (d > maxViewBasedWeight) {
            return maxViewBasedWeight;
        }
        return d;
    }

    public static double weightByView(IVecI[] iVecIArray, IView iView) {
        if (iVecIArray.length == 0) {
            return minViewBasedWeight;
        }
        double d = 0.0;
        for (int i = 0; i < iVecIArray.length; ++i) {
            d += IAIExporter.weightByView(iVecIArray[i], iView);
        }
        return d / (double)iVecIArray.length;
    }

    public static IVec2 convertTo2DPoint(IVecI iVecI, double d, IView iView) {
        IVec2 iVec2 = new IVec2();
        boolean bl = false;
        boolean bl2 = iView.convert(iVecI, iVec2);
        if (!(ignoreOutOfView || bl2 || iView.isAxonometric())) {
            return null;
        }
        IAIExporter.convertCoordinates(iVec2, d, iView);
        return iVec2;
    }

    public static IVec2[] convertTo2DPoints(IVecI[] iVecIArray, double d, IView iView) {
        IVec2[] iVec2Array = new IVec2[iVecIArray.length];
        boolean bl = false;
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVec2Array[i] = new IVec2();
            boolean bl2 = iView.convert(iVecIArray[i], iVec2Array[i]);
            if (!(ignoreOutOfView || bl2 || iView.isAxonometric())) {
                return null;
            }
            IAIExporter.convertCoordinates(iVec2Array[i], d, iView);
        }
        return iVec2Array;
    }

    public static void writePoint(PrintStream printStream, IVecI iVecI, double d, IView iView) {
        IVec2 iVec2 = IAIExporter.convertTo2DPoint(iVecI, d, iView);
        if (iVec2 == null) {
            return;
        }
        double d2 = defaultPointWeight;
        if (enableViewBasedWeight) {
            d2 = IAIExporter.weightByView(iVecI, iView);
        }
        IColor iColor = null;
        if (iVecI instanceof IObject) {
            iColor = ((IObject)((Object)iVecI)).clr();
        }
        IAIExporter.writePaintStyle(printStream, null, iColor, d2, CapType.Round, JoinType.Round);
        IAIExporter.writePointPath(printStream, iVec2);
        printStream.println("S");
    }

    public static void writeNurbsCurve(PrintStream printStream, ICurveI iCurveI, double d, IView iView) {
        ArrayList<ArrayList<IVec2>> arrayList = IAIExporter.convertTo2DPoints(iCurveI, d, iView);
        if (arrayList == null) {
            return;
        }
        double d2 = defaultLineWeight;
        if (enableViewBasedWeight) {
            d2 = IAIExporter.weightByView(iCurveI.cps(), iView);
        }
        IColor iColor = new IColor(0.5);
        if (iCurveI instanceof IObject) {
            iColor = ((IObject)((Object)iCurveI)).clr();
        }
        if (fillClosedCurve && iCurveI.isClosed()) {
            IAIExporter.writePaintStyle(printStream, iColor, null, d2);
        } else {
            IAIExporter.writePaintStyle(printStream, null, iColor, d2);
        }
        if (iCurveI.deg() > 1 || iCurveI instanceof ITrimCurveI && !((ITrimCurveI)iCurveI).surface().isFlat()) {
            IAIExporter.writeBezierCurvePaths(printStream, arrayList, true);
        } else {
            IAIExporter.writePolylinePaths(printStream, arrayList, true);
        }
        if (fillClosedCurve && iCurveI.isClosed()) {
            printStream.println("f");
        } else {
            printStream.println("S");
        }
    }

    public static void startCompoundPath(PrintStream printStream) {
        printStream.println("*u");
    }

    public static void endCompoundPath(PrintStream printStream) {
        printStream.println("*U");
    }

    public static void writeTrimLoops(PrintStream printStream, ISurfaceI iSurfaceI, double d, IView iView) {
        IAIExporter.writeTrimLoops(printStream, iSurfaceI, d, null, null, iView);
    }

    public static void writeTrimLoops(PrintStream printStream, ISurfaceI iSurfaceI, double d, IColor iColor, IColor iColor2, IView iView) {
        for (int i = 0; iSurfaceI.hasOuterTrim() && i < iSurfaceI.outerTrimLoopNum(); ++i) {
            IAIExporter.writeTrimLoop(printStream, iSurfaceI.outerTrimLoop(i), d, iView);
            if (iColor != null && iColor2 != null) {
                printStream.println("b");
                continue;
            }
            if (iColor != null && iColor2 == null) {
                printStream.println("f");
                continue;
            }
            if (iColor == null && iColor2 != null) {
                printStream.println("s");
                continue;
            }
            printStream.println("n");
        }
    }

    public static void writeTrimLoop(PrintStream printStream, ITrimCurveI[] iTrimCurveIArray, double d, IView iView) {
        for (int i = 0; i < iTrimCurveIArray.length; ++i) {
            ITrimCurveI iTrimCurveI = iTrimCurveIArray[i];
            ArrayList<ArrayList<IVec2>> arrayList = IAIExporter.convertTo2DPoints(iTrimCurveI, d, iView);
            if (arrayList == null) continue;
            if (iTrimCurveI.deg() == 1 && iTrimCurveI.surface().isFlat()) {
                IAIExporter.writePolylinePaths(printStream, arrayList, i == 0);
                continue;
            }
            IAIExporter.writeBezierCurvePaths(printStream, arrayList, i == 0);
        }
    }

    public static void writePolygonMesh(PrintStream printStream, IMeshI iMeshI, double d, IView iView) {
        ArrayList<IFace> arrayList = new ArrayList<IFace>();
        for (int i = 0; i < iMeshI.faceNum(); ++i) {
            arrayList.add(iMeshI.face(i));
        }
        IAIExporter.sortFacesByView(arrayList, iView);
        double d2 = defaultLineWeight;
        IColor iColor = new IColor(0.5);
        if (iMeshI instanceof IObject) {
            iColor = ((IObject)((Object)iMeshI)).clr();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            IVec2[] iVec2Array;
            IFace iFace = arrayList.get(i);
            if (enableViewBasedWeight) {
                d2 = IAIExporter.weightByView(iFace.vertices, iView);
            }
            if ((iVec2Array = IAIExporter.convertTo2DPoints(iFace.vertices, d, iView)) == null) continue;
            IColor iColor2 = iFace.clr();
            if (iColor2 == null) {
                iColor2 = iColor;
            }
            IAIExporter.writePaintStyle(printStream, iColor2, null, d2);
            IAIExporter.writeClosedPolylinePath(printStream, iVec2Array, true);
            printStream.println("f");
        }
    }

    public static IVec[][] makeNurbsSurfaceOutline(ISurfaceI iSurfaceI) {
        IVec[][] iVecArray = new IVec[][]{IAIExporter.makeNurbsSurfaceUPath(iSurfaceI, 0.0), IAIExporter.makeNurbsSurfaceVPath(iSurfaceI, 1.0), IAIExporter.reverseArray(IAIExporter.makeNurbsSurfaceUPath(iSurfaceI, 1.0)), IAIExporter.reverseArray(IAIExporter.makeNurbsSurfaceVPath(iSurfaceI, 0.0))};
        return iVecArray;
    }

    public static IVec[] reverseArray(IVec[] iVecArray) {
        IVec[] iVecArray2 = new IVec[iVecArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            iVecArray2[iVecArray.length - 1 - i] = iVecArray[i];
        }
        return iVecArray2;
    }

    public static IVec[] makeNurbsSurfaceUPath(ISurfaceI iSurfaceI, double d) {
        int n;
        if (iSurfaceI.udeg() == 1) {
            int n2 = iSurfaceI.uepNum();
            IVec[] iVecArray = new IVec[n2];
            for (int i = 0; i < n2; ++i) {
                iVecArray[i] = iSurfaceI.pt((double)i / (double)(n2 - 1), d).get();
            }
            return iVecArray;
        }
        int n3 = iSurfaceI.uepNum() * IConfig.segmentResolution;
        IVec[] iVecArray = new IVec[n3 * 3 - 2];
        IVec[] iVecArray2 = new IVec[n3];
        IVec[] iVecArray3 = new IVec[n3];
        for (n = 0; n < n3; ++n) {
            iVecArray2[n] = iSurfaceI.pt((double)n / (double)(n3 - 1), d).get();
            iVecArray3[n] = iSurfaceI.utan((double)n / (double)(n3 - 1), d).get();
            iVecArray3[n].div(n3 * 3);
        }
        for (n = 0; n < n3; ++n) {
            iVecArray[3 * n] = iVecArray2[n];
            if (n <= 0) continue;
            iVecArray[3 * n - 2] = iVecArray2[n - 1].sum(iVecArray3[n - 1]);
            iVecArray[3 * n - 1] = iVecArray2[n].dif(iVecArray3[n]);
        }
        return iVecArray;
    }

    public static IVec[] makeNurbsSurfaceVPath(ISurfaceI iSurfaceI, double d) {
        int n;
        if (iSurfaceI.vdeg() == 1) {
            int n2 = iSurfaceI.vepNum();
            IVec[] iVecArray = new IVec[n2];
            for (int i = 0; i < n2; ++i) {
                iVecArray[i] = iSurfaceI.pt(d, (double)i / (double)(n2 - 1)).get();
            }
            return iVecArray;
        }
        int n3 = iSurfaceI.vepNum() * IConfig.segmentResolution;
        IVec[] iVecArray = new IVec[n3 * 3 - 2];
        IVec[] iVecArray2 = new IVec[n3];
        IVec[] iVecArray3 = new IVec[n3];
        for (n = 0; n < n3; ++n) {
            iVecArray2[n] = iSurfaceI.pt(d, (double)n / (double)(n3 - 1)).get();
            iVecArray3[n] = iSurfaceI.vtan(d, (double)n / (double)(n3 - 1)).get();
            iVecArray3[n].div(n3 * 3);
        }
        for (n = 0; n < n3; ++n) {
            iVecArray[3 * n] = iVecArray2[n];
            if (n <= 0) continue;
            iVecArray[3 * n - 2] = iVecArray2[n - 1].sum(iVecArray3[n - 1]);
            iVecArray[3 * n - 1] = iVecArray2[n].dif(iVecArray3[n]);
        }
        return iVecArray;
    }

    public static void writeNurbsSurface(PrintStream printStream, ISurfaceI iSurfaceI, double d, IView iView) {
        IColor iColor = null;
        iColor = iSurfaceI instanceof IObject ? ((IObject)((Object)iSurfaceI)).clr() : new IColor(0.5);
        IAIExporter.writeNurbsSurface(printStream, iSurfaceI, d, iColor, iView);
    }

    public static void writeNurbsSurface(PrintStream printStream, ISurfaceI iSurfaceI, double d, IColor iColor, IView iView) {
        if (iSurfaceI.hasTrim()) {
            IAIExporter.startLayer(printStream, "trimmed surface", 0, true);
        }
        IColor iColor2 = null;
        IColor iColor3 = null;
        if (iView.mode().isWireframe()) {
            iColor2 = iColor;
        }
        if (iView.mode().isFill()) {
            iColor3 = iView.mode().isTransparent() ? new IColor(iColor, IConfig.transparentModeAlpha) : iColor;
        }
        if (!iSurfaceI.hasTrim()) {
            IAIExporter.writeNurbsSurfaceOutline(printStream, iSurfaceI, d, iColor3, iColor2, iView);
        } else {
            IAIExporter.writePaintStyle(printStream, iColor3, iColor2, 0.0);
            IAIExporter.writeTrimLoops(printStream, iSurfaceI, d, iColor3, iColor2, iView);
            IAIExporter.endLayer(printStream);
        }
    }

    public static void writeNurbsSurfaceOutline(PrintStream printStream, ISurfaceI iSurfaceI, double d, IView iView) {
        IColor iColor = null;
        iColor = iSurfaceI instanceof IObject ? ((IObject)((Object)iSurfaceI)).clr() : new IColor(0.5);
        IAIExporter.writeNurbsSurfaceOutline(printStream, iSurfaceI, d, iColor, iColor, iView);
    }

    public static void writeNurbsSurfaceOutline(PrintStream printStream, ISurfaceI iSurfaceI, double d, IColor iColor, IColor iColor2, IView iView) {
        IAIExporter.writeNurbsSurfaceOutline(printStream, IAIExporter.makeNurbsSurfaceOutline(iSurfaceI), iSurfaceI.udeg(), iSurfaceI.vdeg(), iColor, iColor2, defaultLineWeight, d, iView);
    }

    public static void writeNurbsSurfaceOutline(PrintStream printStream, IVec[][] iVecArray, int n, int n2, IColor iColor, IColor iColor2, double d, double d2, IView iView) {
        int n3;
        int n4;
        IVec[][] iVecArray2 = iVecArray;
        IVec2[][] iVec2ArrayArray = new IVec2[iVecArray2.length][];
        for (n4 = 0; n4 < iVecArray2.length; ++n4) {
            iVec2ArrayArray[n4] = new IVec2[iVecArray2[n4].length];
            for (n3 = 0; n3 < iVecArray2[n4].length; ++n3) {
                iVec2ArrayArray[n4][n3] = new IVec2();
                boolean bl = iView.convert((IVecI)iVecArray2[n4][n3], iVec2ArrayArray[n4][n3]);
                if (!(ignoreOutOfView || bl || iView.isAxonometric())) {
                    return;
                }
                IAIExporter.convertCoordinates(iVec2ArrayArray[n4][n3], d2, iView);
            }
        }
        if (enableViewBasedWeight) {
            d = 0.0;
            for (n4 = 0; n4 < iVecArray2.length; ++n4) {
                d += IAIExporter.weightByView(iVecArray[n4], iView);
            }
            d /= (double)iVecArray2.length;
        }
        ArrayList arrayList = new ArrayList();
        for (n3 = 0; n3 < iVec2ArrayArray.length; ++n3) {
            ArrayList<IVec2> arrayList2 = new ArrayList<IVec2>();
            for (int i = 0; i < iVec2ArrayArray[n3].length; ++i) {
                arrayList2.add(iVec2ArrayArray[n3][i]);
            }
            arrayList.add(arrayList2);
        }
        IAIExporter.writePaintStyle(printStream, iColor, iColor2, d);
        if (n > 1) {
            IAIExporter.writeBezierCurvePath(printStream, (ArrayList)arrayList.get(0), true);
        } else {
            IAIExporter.writePolylinePath(printStream, (ArrayList)arrayList.get(0), true);
        }
        if (n2 > 1) {
            IAIExporter.writeBezierCurvePath(printStream, (ArrayList)arrayList.get(1), false);
        } else {
            IAIExporter.writePolylinePath(printStream, (ArrayList)arrayList.get(1), false);
        }
        if (n > 1) {
            IAIExporter.writeBezierCurvePath(printStream, (ArrayList)arrayList.get(2), false);
        } else {
            IAIExporter.writePolylinePath(printStream, (ArrayList)arrayList.get(2), false);
        }
        if (n2 > 1) {
            IAIExporter.writeBezierCurvePath(printStream, (ArrayList)arrayList.get(3), false);
        } else {
            IAIExporter.writePolylinePath(printStream, (ArrayList)arrayList.get(3), false);
        }
        if (iColor != null && iColor2 != null) {
            printStream.println("b");
        } else if (iColor != null && iColor2 == null) {
            printStream.println("f");
        } else if (iColor == null && iColor2 != null) {
            printStream.println("s");
        } else {
            printStream.println("n");
        }
    }

    public static String getRGBString(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n3 * n2 + n];
        int n5 = n4 >> 24 & 0xFF;
        int n6 = n4 >> 16 & 0xFF;
        int n7 = n4 >> 8 & 0xFF;
        int n8 = n4 & 0xFF;
        return IAIExporter.getByteString(n6) + IAIExporter.getByteString(n7) + IAIExporter.getByteString(n8);
    }

    public static String getByteString(int n) {
        int n2 = n >> 4 & 0xF;
        int n3 = n & 0xF;
        return String.valueOf(IAIExporter.getHex(n2)) + String.valueOf(IAIExporter.getHex(n3));
    }

    public static char getHex(int n) {
        if (n >= 0 && n <= 9) {
            return (char)(48 + n);
        }
        switch (n) {
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return '\u0000';
    }

    public static void startLayer(PrintStream printStream, String string, int n, boolean bl) {
        String string2 = "0";
        if (bl) {
            string2 = "1";
        }
        printStream.println("1 1 1 1 0 0 1 " + String.valueOf(n) + " 0 0 0 0 50 " + string2 + " Lb");
        printStream.println("(" + string + ") Ln");
    }

    public static void endLayer(PrintStream printStream) {
        printStream.println("LB");
    }

    public static void startMask(PrintStream printStream) {
        printStream.println("q");
    }

    public static void endMask(PrintStream printStream) {
        printStream.println("Q");
    }

    public static void startGroup(PrintStream printStream) {
        printStream.println("u");
    }

    public static void endGroup(PrintStream printStream) {
        printStream.println("U");
    }

    public static void writeFooter(PrintStream printStream) {
        printStream.println("%%PageTrailer");
        printStream.println("gsave annotatepage grestore showpage");
        printStream.println("%%Trailer");
        printStream.println("Adobe_IllustratorA_AI3 /terminate get exec");
        printStream.println("Adobe_typography_AI3 /terminate get exec");
        printStream.println("Adobe_customcolor /terminate get exec");
        printStream.println("Adobe_cshow /terminate get exec");
        printStream.println("Adobe_cmykcolor /terminate get exec");
        printStream.println("Adobe_packedarray /terminate get exec");
        printStream.println("%%EOF");
    }

    public static IVec2 getIntersection(IVec2 iVec2, IVec2 iVec22, IVec2 iVec23, IVec2 iVec24) {
        double d = (iVec22.y * (iVec23.x - iVec2.x) - iVec22.x * (iVec23.y - iVec2.y)) / (iVec22.x * iVec24.y - iVec24.x * iVec22.y);
        return new IVec2(d * iVec24.x + iVec23.x, d * iVec24.y + iVec23.y);
    }

    public static void writeText3D(PrintStream printStream, String string, IVec iVec, IVec iVec2, IVec iVec3, IColor iColor, double d, IView iView) {
        IVec2 iVec22 = new IVec2();
        IVec2 iVec23 = new IVec2();
        IVec2 iVec24 = new IVec2();
        if (!iView.convert((IVecI)iVec, iVec22)) {
            return;
        }
        if (!iView.convert((IVecI)iVec.cp().add(iVec2), iVec23)) {
            return;
        }
        if (!iView.convert((IVecI)iVec.cp().add(iVec3), iVec24)) {
            return;
        }
        IAIExporter.convertCoordinates(iVec22, d, iView);
        IAIExporter.convertCoordinates(iVec23, d, iView);
        IAIExporter.convertCoordinates(iVec24, d, iView);
        iVec23.sub(iVec22);
        iVec24.sub(iVec22);
        printStream.println("0 To");
        printStream.println(f.format(iVec23.x) + " " + f.format(iVec23.y) + " " + f.format(iVec24.x) + " " + f.format(iVec24.y) + " " + f.format(iVec22.x) + " " + f.format(iVec22.y) + " 0 Tp");
        printStream.println("0 Tv");
        printStream.println("TP");
        printStream.println("0 Tr");
        printStream.println(f.format(iColor.red()) + " " + f.format(iColor.green()) + " " + f.format(iColor.blue()) + " " + "Xa");
        printStream.println("/_ArialMT 1 0 0 Tf");
        printStream.println("100 100 Tz");
        printStream.println("0 Tt");
        printStream.println("0 TV");
        printStream.println("0 Tc");
        printStream.print("(");
        for (int i = 0; i < string.length(); ++i) {
            printStream.print("\\" + IAIExporter.getOctaString(string.charAt(i)));
        }
        printStream.println(") Tx 1 0 Tk");
        printStream.println("TO");
    }

    public static String getOctaString(char c) {
        int n = c % 8;
        int n2 = c / 8 % 8;
        int n3 = c / 64 % 8;
        return String.valueOf(n3) + String.valueOf(n2) + String.valueOf(n);
    }

    public static boolean write(File file, IServerI iServerI, double d) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        IAIExporter.write(printStream, iServerI.server().allObjects(), d, iServerI.server().ig.panel.currentPane().getView());
        printStream.close();
        return true;
    }

    public static ArrayList<IObject> sortObjectsByView(ArrayList<IObject> arrayList, IView iView) {
        ArrayList<IGeometry> arrayList2 = new ArrayList<IGeometry>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof IGeometry)) continue;
            arrayList2.add((IGeometry)arrayList.get(i));
        }
        ISort.sort(arrayList2, new IViewSort(iView));
        ArrayList<IObject> arrayList3 = new ArrayList<IObject>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList3.add((IObject)arrayList2.get(i));
        }
        return arrayList3;
    }

    public static ArrayList<IFace> sortFacesByView(ArrayList<IFace> arrayList, IView iView) {
        ISort.sort(arrayList, new IFaceViewSort(iView));
        return arrayList;
    }

    public static void write(PrintStream printStream, ArrayList<IObject> arrayList, double d, IView iView) {
        IAIExporter.initFormat();
        IAIExporter.writeHeader(printStream);
        IAIExporter.startLayer(printStream, "default", 0, false);
        arrayList = IAIExporter.sortObjectsByView(arrayList, iView);
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            ITransformable iTransformable;
            if (!arrayList.get(i).visible() || arrayList.get(i).clr().getAlpha() == 0) {
                IOut.debug(100, "object " + i + " not visible or alpha zero");
                continue;
            }
            if (i > 0 && i % 100 == 0) {
                IOut.debug(0, "exporting " + i + "/" + arrayList.size());
            }
            if (arrayList.get(i) instanceof ICurveI && !(arrayList.get(i) instanceof ITrimCurveI)) {
                iTransformable = (ICurveI)((Object)arrayList.get(i));
                IAIExporter.writeNurbsCurve(printStream, (ICurveI)iTransformable, d, iView);
                continue;
            }
            if (arrayList.get(i) instanceof IPoint) {
                iTransformable = (IPoint)arrayList.get(i);
                IAIExporter.writePoint(printStream, (IVecI)iTransformable, d, iView);
                continue;
            }
            if (arrayList.get(i) instanceof IPointR) {
                iTransformable = (IPointR)arrayList.get(i);
                IAIExporter.writePoint(printStream, (IVecI)iTransformable, d, iView);
                continue;
            }
            if (arrayList.get(i) instanceof ISurfaceI) {
                iTransformable = (ISurfaceI)((Object)arrayList.get(i));
                IAIExporter.writeNurbsSurface(printStream, (ISurfaceI)iTransformable, d, iView);
                continue;
            }
            if (arrayList.get(i) instanceof IMeshI) {
                iTransformable = (IMeshI)((Object)arrayList.get(i));
                IAIExporter.writePolygonMesh(printStream, (IMeshI)iTransformable, d, iView);
                continue;
            }
            if (arrayList.get(i) instanceof IBrep) {
                iTransformable = (IBrep)arrayList.get(i);
                for (int j = 0; j < ((IBrep)iTransformable).surfaceNum(); ++j) {
                    IAIExporter.writeNurbsSurface(printStream, ((IBrep)iTransformable).surface(j), d, ((IObject)((Object)iTransformable)).clr(), iView);
                }
                continue;
            }
            if (!(arrayList.get(i) instanceof IText)) continue;
            iTransformable = (IText)arrayList.get(i);
            IVec iVec = ((IText)iTransformable).pos().cp();
            if (((IText)iTransformable).isAlignCenter()) {
                iVec.add(((IText)iTransformable).uvec(), -0.5);
            } else if (((IText)iTransformable).isAlignRight()) {
                iVec.sub(((IText)iTransformable).uvec());
            }
            if (((IText)iTransformable).isAlignMiddle()) {
                iVec.add(((IText)iTransformable).vvec(), -0.5);
            } else if (((IText)iTransformable).isAlignTop()) {
                iVec.sub(((IText)iTransformable).vvec());
            }
            IAIExporter.writeText3D(printStream, ((IText)iTransformable).text(), iVec, ((IText)iTransformable).uvec(), ((IText)iTransformable).vvec(), ((IObject)((Object)iTransformable)).clr(), d, iView);
        }
        IAIExporter.endLayer(printStream);
        IAIExporter.writeFooter(printStream);
    }

    public static class IFaceViewSort
    implements IComparator<IFace> {
        public IView view;

        IFaceViewSort(IView iView) {
            this.view = iView;
        }

        @Override
        public int compare(IFace iFace, IFace iFace2) {
            IVec iVec = this.view.convert(iFace.center());
            IVec iVec2 = this.view.convert(iFace2.center());
            if (iVec.z < iVec2.z) {
                return 1;
            }
            if (iVec.z > iVec2.z) {
                return -1;
            }
            return 0;
        }
    }

    public static class IViewSort
    implements IComparator<IGeometry> {
        public IView view;

        IViewSort(IView iView) {
            this.view = iView;
        }

        @Override
        public int compare(IGeometry iGeometry, IGeometry iGeometry2) {
            boolean bl;
            IVec iVec = this.view.convert(iGeometry.center());
            IVec iVec2 = this.view.convert(iGeometry2.center());
            if (iVec.z < iVec2.z - 0.2) {
                return 1;
            }
            if (iVec.z > iVec2.z + 0.2) {
                return -1;
            }
            boolean bl2 = iGeometry instanceof ICurveI || iGeometry instanceof IText;
            boolean bl3 = bl = iGeometry2 instanceof ICurveI || iGeometry2 instanceof IText;
            if (bl2 && !bl) {
                return 1;
            }
            if (!bl2 && bl) {
                return -1;
            }
            if (iVec.z < iVec2.z) {
                return 1;
            }
            if (iVec.z > iVec2.z) {
                return -1;
            }
            return 0;
        }
    }

    public static enum JoinType {
        Miter,
        Round,
        Bevel;

    }

    public static enum CapType {
        Butt,
        Round,
        Square;

    }
}

