/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IFunction;
import igeo.IOut;

public class IPolynomialFunction
implements IFunction {
    public int degree;
    public double[] coeff;

    public IPolynomialFunction(int n) {
        this.degree = n;
        this.coeff = new double[this.degree + 1];
    }

    public IPolynomialFunction(int n, double[] dArray) {
        this.degree = n;
        this.coeff = dArray;
        if (this.coeff.length != this.degree + 1) {
            IOut.p("ERROR: length of coefficients is wrong");
        }
    }

    public IPolynomialFunction(IPolynomialFunction iPolynomialFunction) {
        this.degree = iPolynomialFunction.degree;
        this.coeff = new double[this.degree + 1];
        for (int i = 0; i <= this.degree; ++i) {
            this.coeff[i] = iPolynomialFunction.coeff[i];
        }
    }

    public IPolynomialFunction() {
    }

    public IPolynomialFunction(double[] dArray) {
        this.coeff = dArray;
        this.degree = this.coeff.length - 1;
    }

    public IPolynomialFunction dup() {
        return new IPolynomialFunction(this);
    }

    public void set(int n, double d) {
        this.coeff[n] = d;
    }

    public double eval(double d) {
        double d2 = this.coeff[0];
        for (int i = 1; i <= this.degree; ++i) {
            d2 += this.coeff[i] * Math.pow(d, i);
        }
        return d2;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public void mul(double d) {
        int n = 0;
        while (n <= this.degree) {
            int n2 = n++;
            this.coeff[n2] = this.coeff[n2] * d;
        }
    }

    public void mul(IPolynomialFunction iPolynomialFunction) {
        int n;
        int n2 = this.degree + iPolynomialFunction.degree;
        double[] dArray = new double[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n <= this.degree; ++n) {
            for (int i = 0; i <= iPolynomialFunction.degree; ++i) {
                int n3 = n + i;
                dArray[n3] = dArray[n3] + this.coeff[n] * iPolynomialFunction.coeff[i];
            }
        }
        this.degree = n2;
        this.coeff = dArray;
    }

    public void add(IPolynomialFunction iPolynomialFunction) {
        if (iPolynomialFunction.degree > this.degree) {
            this.degree = iPolynomialFunction.degree;
            double[] dArray = this.coeff;
            this.coeff = new double[iPolynomialFunction.degree + 1];
            for (int i = 0; i <= iPolynomialFunction.degree; ++i) {
                this.coeff[i] = i < dArray.length ? dArray[i] : 0.0;
            }
        }
        for (int i = 0; i <= iPolynomialFunction.degree; ++i) {
            int n = i;
            this.coeff[n] = this.coeff[n] + iPolynomialFunction.coeff[i];
        }
    }

    public void differentiate() {
        if (this.degree == 0) {
            double[] dArray = new double[]{0.0};
            this.coeff = dArray;
            this.degree = 0;
            return;
        }
        double[] dArray = new double[this.degree];
        for (int i = 0; i < this.degree; ++i) {
            dArray[i] = this.coeff[i + 1] * (double)(i + 1);
        }
        --this.degree;
        this.coeff = dArray;
    }

    public IPolynomialFunction power(int n) {
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            IPolynomialFunction iPolynomialFunction = new IPolynomialFunction(0);
            iPolynomialFunction.set(0, 1.0);
            return iPolynomialFunction;
        }
        IPolynomialFunction iPolynomialFunction = new IPolynomialFunction(this);
        for (int i = 0; i < n - 1; ++i) {
            iPolynomialFunction.mul(this);
        }
        return iPolynomialFunction;
    }

    public IPolynomialFunction substitute(IPolynomialFunction iPolynomialFunction) {
        IPolynomialFunction iPolynomialFunction2 = new IPolynomialFunction(this.degree * iPolynomialFunction.degree);
        for (int i = 0; i <= this.degree; ++i) {
            IPolynomialFunction iPolynomialFunction3 = iPolynomialFunction.power(this.degree - i);
            iPolynomialFunction3.mul(this.coeff[this.degree - i]);
            iPolynomialFunction2.add(iPolynomialFunction3);
        }
        return iPolynomialFunction2;
    }

    public String toString() {
        if (this.coeff == null) {
            return super.toString();
        }
        String string = "";
        for (int i = this.degree; i >= 0; --i) {
            if (this.coeff[i] != 0.0 && i < this.degree) {
                string = string + " ";
            }
            if (this.coeff[i] > 0.0 && i < this.degree) {
                string = string + "+";
            }
            if (this.coeff[i] == 0.0) continue;
            string = string + String.valueOf(this.coeff[i]);
            if (i > 0) {
                string = string + "x";
            }
            if (i <= 1) continue;
            string = string + "^" + String.valueOf(i);
        }
        return string;
    }
}

