/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBSplineBasisFunction;
import igeo.IBool;
import igeo.IConfig;
import igeo.ICurveGeo;
import igeo.ICurveI;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IEntityParameter;
import igeo.IG;
import igeo.IInteger;
import igeo.IIntegerI;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.INurbsGeo;
import igeo.IObject;
import igeo.IOut;
import igeo.ISurfaceCache;
import igeo.ISurfaceI;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.ITrimCache;
import igeo.ITrimCurve;
import igeo.ITrimCurveI;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;
import igeo.gui.IPolyline2D;
import igeo.gui.ITrimCurveGraphic;
import igeo.gui.ITrimLoopGraphic;
import java.util.ArrayList;

public class ISurfaceGeo
extends INurbsGeo
implements ISurfaceI,
IEntityParameter {
    public IVecI[][] controlPoints;
    public int udegree;
    public int vdegree;
    public double[] uknots;
    public double[] vknots;
    public double ustart;
    public double uend;
    public double vstart;
    public double vend;
    public boolean[][] defaultWeights;
    public IBSplineBasisFunction basisFunctionU;
    public IBSplineBasisFunction basisFunctionV;
    public IBSplineBasisFunction derivativeFunctionU;
    public IBSplineBasisFunction derivativeFunctionV;
    public ArrayList<ArrayList<ITrimCurve>> innerTrimLoop;
    public ArrayList<ArrayList<ITrimCurve>> outerTrimLoop;
    public boolean innerTrimClosed = false;
    public boolean outerTrimClosed = false;
    public ISurfaceCache uvSearchCache;
    public ITrimCache trimCache;

    public ISurfaceGeo() {
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        this.ustart = d;
        this.uend = d2;
        this.vstart = d3;
        this.vend = d4;
        if (d != 0.0 || d2 != 1.0) {
            ISurfaceGeo.normalizeKnots(dArray, d, d2);
        }
        if (d3 != 0.0 || d4 != 1.0) {
            ISurfaceGeo.normalizeKnots(dArray2, d3, d4);
        }
        this.init(iVecIArray, n, n2, dArray, dArray2);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        this.ustart = dArray[0];
        this.uend = dArray[dArray.length - 1];
        this.vstart = dArray2[0];
        this.vend = dArray2[dArray2.length - 1];
        if (dArray[0] != 0.0 || dArray[dArray.length - 1] != 1.0) {
            ISurfaceGeo.normalizeKnots(dArray, dArray[0], dArray[dArray.length - 1]);
        }
        if (dArray2[0] != 0.0 || dArray2[dArray2.length - 1] != 1.0) {
            ISurfaceGeo.normalizeKnots(dArray2, dArray2[0], dArray2[dArray2.length - 1]);
        }
        this.init(iVecIArray, n, n2, dArray, dArray2);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, ISurfaceGeo.createKnots(n, iVecIArray.length), ISurfaceGeo.createKnots(n2, iVecIArray[0].length));
    }

    public ISurfaceGeo(IVecI[][] iVecIArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, 1, 1, ISurfaceGeo.createKnots(1, iVecIArray.length), ISurfaceGeo.createKnots(1, iVecIArray[0].length));
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, bl, bl2);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, bl, dArray);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, n, n2, dArray, bl);
    }

    public ISurfaceGeo(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, 1, 1, bl, bl2);
    }

    public ISurfaceGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][] iVecIArray = new IVecI[2][2];
        iVecIArray[0][0] = iVecI;
        iVecIArray[1][0] = iVecI2;
        iVecIArray[1][1] = iVecI3;
        iVecIArray[0][1] = iVecI4;
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.init(iVecIArray, 1, 1, ISurfaceGeo.createKnots(1, 2), ISurfaceGeo.createKnots(1, 2));
    }

    public ISurfaceGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this(iVecI, iVecI2, iVecI3, iVecI);
    }

    public ISurfaceGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6), new IVec(d7, d8, d9), new IVec(d10, d11, d12));
    }

    public ISurfaceGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6), new IVec(d7, d8, d9));
    }

    public ISurfaceGeo(double[][][] dArray) {
        this(ISurfaceGeo.getPointsFromArray(dArray));
    }

    public ISurfaceGeo(double[][][] dArray, int n, int n2) {
        this((IVecI[][])ISurfaceGeo.getPointsFromArray(dArray), n, n2);
    }

    public ISurfaceGeo(double[][][] dArray, boolean bl, boolean bl2) {
        this((IVecI[][])ISurfaceGeo.getPointsFromArray(dArray), bl, bl2);
    }

    public ISurfaceGeo(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        this((IVecI[][])ISurfaceGeo.getPointsFromArray(dArray), n, n2, bl, bl2);
    }

    public ISurfaceGeo(ICurveI iCurveI) {
        int n;
        IVecI[] iVecIArray = new IVecI[iCurveI.num()];
        for (n = 0; n < iVecIArray.length; ++n) {
            iVecIArray[n] = iCurveI.cp(n);
        }
        n = iCurveI.deg();
        double[] dArray = new double[iCurveI.knotNum()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = iCurveI.knot(i);
        }
        this.initWithPlanarTrim(iVecIArray, n, dArray, !iCurveI.isClosed());
    }

    public ISurfaceGeo(ICurveI iCurveI, ICurveI[] iCurveIArray) {
        int n;
        int n2;
        IVecI[] iVecIArray = new IVecI[iCurveI.num()];
        for (n2 = 0; n2 < iVecIArray.length; ++n2) {
            iVecIArray[n2] = iCurveI.cp(n2);
        }
        n2 = iCurveI.deg();
        double[] dArray = new double[iCurveI.knotNum()];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = iCurveI.knot(n);
        }
        n = iCurveIArray.length;
        IVecI[][] iVecIArray2 = new IVecI[n][];
        int[] nArray = new int[n];
        double[][] dArrayArray = new double[n][];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n3;
            iVecIArray2[i] = new IVecI[iCurveIArray[i].num()];
            for (n3 = 0; n3 < iVecIArray2[i].length; ++n3) {
                iVecIArray2[i][n3] = iCurveIArray[i].cp(n3);
            }
            nArray[i] = iCurveIArray[i].deg();
            dArrayArray[i] = new double[iCurveIArray[i].knotNum()];
            for (n3 = 0; n3 < dArrayArray[i].length; ++n3) {
                dArrayArray[i][n3] = iCurveIArray[i].knot(n3);
            }
            blArray[i] = !iCurveIArray[i].isClosed();
        }
        this.initWithPlanarTrim(iVecIArray, n2, dArray, !iCurveI.isClosed(), iVecIArray2, nArray, dArrayArray, blArray);
    }

    public ISurfaceGeo(ICurveI[] iCurveIArray, ICurveI[][] iCurveIArray2) {
        int n;
        int n2;
        int n3 = iCurveIArray.length;
        IVecI[][] iVecIArray = new IVecI[n3][];
        int[] nArray = new int[n3];
        double[][] dArrayArray = new double[n3][];
        for (n2 = 0; n2 < n3; n2 += 1) {
            iVecIArray[n2] = new IVecI[iCurveIArray[n2].num()];
            for (n = 0; n < iVecIArray[n2].length; ++n) {
                iVecIArray[n2][n] = iCurveIArray[n2].cp(n);
            }
            nArray[n2] = iCurveIArray[n2].deg();
            dArrayArray[n2] = new double[iCurveIArray[n2].knotNum()];
            for (n = 0; n < dArrayArray[n2].length; ++n) {
                dArrayArray[n2][n] = iCurveIArray[n2].knot(n);
            }
        }
        n2 = !iVecIArray[0][0].eq(iVecIArray[iVecIArray.length - 1][iVecIArray[iVecIArray.length - 1].length - 1]) ? 1 : 0;
        n = iCurveIArray2.length;
        IVecI[][][] iVecIArray2 = new IVecI[n][][];
        int[][] nArrayArray = new int[n][];
        double[][][] dArrayArray2 = new double[n][][];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            iVecIArray2[i] = new IVecI[iCurveIArray2[i].length][];
            nArrayArray[i] = new int[iCurveIArray2[i].length];
            dArrayArray2[i] = new double[iCurveIArray2[i].length][];
            for (int j = 0; j < iCurveIArray2[i].length; ++j) {
                int n4;
                iVecIArray2[i][j] = new IVecI[iCurveIArray2[i][j].num()];
                for (n4 = 0; n4 < iVecIArray2[i][j].length; ++n4) {
                    iVecIArray2[i][j][n4] = iCurveIArray2[i][j].cp(n4);
                }
                nArrayArray[i][j] = iCurveIArray2[i][j].deg();
                dArrayArray2[i][j] = new double[iCurveIArray2[i][j].knotNum()];
                for (n4 = 0; n4 < dArrayArray2[i][j].length; ++n4) {
                    dArrayArray2[i][j][n4] = iCurveIArray2[i][j].knot(n4);
                }
            }
            blArray[i] = !iVecIArray2[i][0][0].eq(iVecIArray2[i][iVecIArray2[i].length - 1][iVecIArray2[i][iVecIArray2[i].length - 1].length - 1]);
        }
        this.initWithPlanarTrim(iVecIArray, nArray, dArrayArray, n2 != 0, iVecIArray2, nArrayArray, dArrayArray2, blArray);
    }

    public ISurfaceGeo(ICurveI iCurveI, ICurveI iCurveI2) {
        this(iCurveI, new ICurveI[]{iCurveI2});
    }

    public ISurfaceGeo(ICurveI[] iCurveIArray) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no trim curve is provided");
            return;
        }
        this.initWithPlanarTrims(iCurveIArray);
    }

    public ISurfaceGeo(IVecI[] iVecIArray) {
        IVecI[] iVecIArray2 = ISurfaceGeo.createClosedCP(iVecIArray, 1);
        this.initWithPlanarTrim(iVecIArray2, 1, ISurfaceGeo.createClosedKnots(1, iVecIArray2.length), false);
    }

    public ISurfaceGeo(IVecI[] iVecIArray, int n) {
        IVecI[] iVecIArray2 = ISurfaceGeo.createClosedCP(iVecIArray, n);
        double[] dArray = ISurfaceGeo.createClosedKnots(n, iVecIArray2.length);
        this.initWithPlanarTrim(iVecIArray2, n, dArray, false);
    }

    public ISurfaceGeo(IVecI[] iVecIArray, int n, double[] dArray) {
        ICurveGeo iCurveGeo = new ICurveGeo(iVecIArray, n, dArray);
        this.initWithPlanarTrim(iVecIArray, n, dArray, !iCurveGeo.isClosed());
    }

    public ISurfaceGeo(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        IVecI[] iVecIArray3 = ISurfaceGeo.createClosedCP(iVecIArray, 1);
        IVecI[] iVecIArray4 = ISurfaceGeo.createClosedCP(iVecIArray2, 1);
        this.initWithPlanarTrim(iVecIArray3, 1, ISurfaceGeo.createClosedKnots(1, iVecIArray3.length), false, new IVecI[][]{iVecIArray4}, new int[]{1}, new double[][]{ISurfaceGeo.createClosedKnots(1, iVecIArray4.length)}, new boolean[]{false});
    }

    public ISurfaceGeo(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        IVecI[] iVecIArray3 = ISurfaceGeo.createClosedCP(iVecIArray, n);
        double[] dArray = ISurfaceGeo.createClosedKnots(n, iVecIArray3.length);
        IVecI[] iVecIArray4 = ISurfaceGeo.createClosedCP(iVecIArray, n);
        double[] dArray2 = ISurfaceGeo.createClosedKnots(n, iVecIArray4.length);
        this.initWithPlanarTrim(iVecIArray3, n, dArray, false, new IVecI[][]{iVecIArray4}, new int[]{n2}, new double[][]{dArray2}, new boolean[]{false});
    }

    public ISurfaceGeo(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        ICurveGeo iCurveGeo = new ICurveGeo(iVecIArray, n, dArray);
        ICurveGeo iCurveGeo2 = new ICurveGeo(iVecIArray2, n2, dArray2);
        this.initWithPlanarTrim(iVecIArray, n, dArray, !iCurveGeo.isClosed(), new IVecI[][]{iVecIArray2}, new int[]{n2}, new double[][]{dArray2}, new boolean[]{!iCurveGeo2.isClosed()});
    }

    public ISurfaceGeo(IVecI[] iVecIArray, IVecI[][] iVecIArray2) {
        IVecI[] iVecIArray3 = ISurfaceGeo.createClosedCP(iVecIArray, 1);
        IVecI[][] iVecIArray4 = new IVecI[iVecIArray2.length][];
        int[] nArray = new int[iVecIArray2.length];
        double[][] dArrayArray = new double[iVecIArray2.length][];
        boolean[] blArray = new boolean[iVecIArray2.length];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            iVecIArray4[i] = ISurfaceGeo.createClosedCP(iVecIArray2[i], 1);
            dArrayArray[i] = ISurfaceGeo.createClosedKnots(1, iVecIArray4[i].length);
            nArray[i] = 1;
            blArray[i] = false;
        }
        this.initWithPlanarTrim(iVecIArray3, 1, ISurfaceGeo.createClosedKnots(1, iVecIArray3.length), false, iVecIArray4, nArray, dArrayArray, blArray);
    }

    public ISurfaceGeo(IVecI[] iVecIArray, int n, IVecI[][] iVecIArray2, int[] nArray) {
        IVecI[] iVecIArray3 = ISurfaceGeo.createClosedCP(iVecIArray, n);
        double[] dArray = ISurfaceGeo.createClosedKnots(n, iVecIArray3.length);
        IVecI[][] iVecIArray4 = new IVecI[iVecIArray2.length][];
        int[] nArray2 = new int[iVecIArray2.length];
        double[][] dArrayArray = new double[iVecIArray2.length][];
        boolean[] blArray = new boolean[iVecIArray2.length];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            iVecIArray4[i] = ISurfaceGeo.createClosedCP(iVecIArray2[i], nArray[i]);
            dArrayArray[i] = ISurfaceGeo.createClosedKnots(nArray[i], iVecIArray4[i].length);
            blArray[i] = false;
        }
        this.initWithPlanarTrim(iVecIArray3, n, dArray, false, iVecIArray4, nArray2, dArrayArray, blArray);
    }

    public ISurfaceGeo(IVecI[] iVecIArray, int n, double[] dArray, IVecI[][] iVecIArray2, int[] nArray, double[][] dArray2) {
        ICurveGeo iCurveGeo = new ICurveGeo(iVecIArray, n, dArray);
        boolean[] blArray = new boolean[iVecIArray2.length];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            ICurveGeo iCurveGeo2 = new ICurveGeo(iVecIArray2[i], nArray[i], dArray2[i]);
            blArray[i] = !iCurveGeo2.isClosed();
        }
        this.initWithPlanarTrim(iVecIArray, n, dArray, !iCurveGeo.isClosed(), iVecIArray2, nArray, dArray2, blArray);
    }

    public ISurfaceGeo(ISurfaceGeo iSurfaceGeo) {
        int n;
        int n2;
        this.controlPoints = new IVecI[iSurfaceGeo.controlPoints.length][iSurfaceGeo.controlPoints[0].length];
        for (n2 = 0; n2 < this.controlPoints.length; ++n2) {
            for (int i = 0; i < this.controlPoints[0].length; ++i) {
                this.controlPoints[n2][i] = iSurfaceGeo.controlPoints[n2][i].dup();
            }
        }
        this.uknots = new double[iSurfaceGeo.uknots.length];
        System.arraycopy(iSurfaceGeo.uknots, 0, this.uknots, 0, this.uknots.length);
        this.vknots = new double[iSurfaceGeo.vknots.length];
        System.arraycopy(iSurfaceGeo.vknots, 0, this.vknots, 0, this.vknots.length);
        this.udegree = iSurfaceGeo.udegree;
        this.vdegree = iSurfaceGeo.vdegree;
        this.ustart = iSurfaceGeo.ustart;
        this.uend = iSurfaceGeo.uend;
        this.vstart = iSurfaceGeo.vstart;
        this.vend = iSurfaceGeo.vend;
        this.init(this.controlPoints, this.udegree, this.vdegree, this.uknots, this.vknots);
        if (iSurfaceGeo.innerTrimLoop != null) {
            this.innerTrimLoop = new ArrayList();
            for (n2 = 0; n2 < iSurfaceGeo.innerTrimLoop.size(); ++n2) {
                ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
                for (n = 0; n < iSurfaceGeo.innerTrimLoop.get(n2).size(); ++n) {
                    arrayList.add(new ITrimCurve(iSurfaceGeo.innerTrimLoop.get(n2).get(n), this));
                }
                this.innerTrimLoop.add(arrayList);
            }
        }
        if (iSurfaceGeo.outerTrimLoop != null) {
            this.outerTrimLoop = new ArrayList();
            for (n2 = 0; n2 < iSurfaceGeo.outerTrimLoop.size(); ++n2) {
                ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
                for (n = 0; n < iSurfaceGeo.outerTrimLoop.get(n2).size(); ++n) {
                    arrayList.add(new ITrimCurve(iSurfaceGeo.outerTrimLoop.get(n2).get(n), this));
                }
                this.outerTrimLoop.add(arrayList);
            }
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        if (bl && bl2) {
            iVecIArray = ISurfaceGeo.createClosedCPInV(iVecIArray, n2);
            iVecIArray = ISurfaceGeo.createClosedCPInU(iVecIArray, n);
            this.init(iVecIArray, n, n2, ISurfaceGeo.createClosedKnots(n, iVecIArray.length), ISurfaceGeo.createClosedKnots(n2, iVecIArray[0].length));
        } else if (bl) {
            this.init(iVecIArray, n, n2, bl, ISurfaceGeo.createKnots(n2, iVecIArray[0].length));
        } else if (bl2) {
            this.init(iVecIArray, n, n2, ISurfaceGeo.createKnots(n, iVecIArray.length), bl2);
        } else {
            this.init(iVecIArray, n, n2, ISurfaceGeo.createKnots(n, iVecIArray.length), ISurfaceGeo.createKnots(n2, iVecIArray[0].length));
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        if (bl) {
            iVecIArray = ISurfaceGeo.createClosedCPInV(iVecIArray, n2);
            this.init(iVecIArray, n, n2, dArray, ISurfaceGeo.createClosedKnots(n2, iVecIArray[0].length));
        } else {
            this.init(iVecIArray, n, n2, dArray, ISurfaceGeo.createKnots(n2, iVecIArray[0].length));
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        if (bl) {
            iVecIArray = ISurfaceGeo.createClosedCPInU(iVecIArray, n);
            this.init(iVecIArray, n, n2, ISurfaceGeo.createClosedKnots(n, iVecIArray.length), dArray);
        } else {
            this.init(iVecIArray, n, n2, ISurfaceGeo.createKnots(n, iVecIArray.length), dArray);
        }
    }

    public void init(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        if (IConfig.checkValidControlPoint) {
            ISurfaceGeo.isValidCP(iVecIArray, n, n2, dArray, dArray2);
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ISurfaceGeo.checkDuplicatedCP(iVecIArray);
        } else if (IConfig.checkDuplicatedControlPointOnEdge) {
            ISurfaceGeo.checkDuplicatedCPOnEdge(iVecIArray);
        }
        this.controlPoints = iVecIArray;
        this.udegree = n;
        this.vdegree = n2;
        this.uknots = dArray;
        this.vknots = dArray2;
        this.basisFunctionU = new IBSplineBasisFunction(n, dArray);
        this.basisFunctionV = new IBSplineBasisFunction(n2, dArray2);
        this.defaultWeights = new boolean[iVecIArray.length][iVecIArray[0].length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray[0].length; ++j) {
                this.defaultWeights[i][j] = !(iVecIArray[i][j] instanceof IVec4I);
            }
        }
    }

    public void initWithPlanarTrim(IVecI[] iVecIArray, int n, double[] dArray, boolean bl) {
        IVec iVec = IVec.averageNormal(iVecIArray);
        IVec[] iVecArray = ISurfaceGeo.getPlanarUVVectors(iVecIArray);
        IVec iVec2 = iVecArray[0];
        IVec iVec3 = iVecArray[1];
        iVec2 = iVec.cross(iVec2).cross(iVec).unit();
        iVec3 = iVec.cross(iVec2).unit();
        IVec iVec4 = iVecIArray[0].get();
        IVecI[] iVecIArray2 = ISurfaceGeo.getPlanarUVPoints(iVecIArray, (IVecI)iVec4, iVec2, iVec3);
        double[][] dArray2 = ISurfaceGeo.getPlanarUVRange((IVec[])iVecIArray2);
        IVecI[][] iVecIArray3 = new IVec[2][2];
        iVecIArray3[0][0] = iVec4.dup().add(iVec2, dArray2[0][0]).add(iVec3, dArray2[1][0]);
        iVecIArray3[1][0] = iVec4.dup().add(iVec2, dArray2[0][1]).add(iVec3, dArray2[1][0]);
        iVecIArray3[0][1] = iVec4.dup().add(iVec2, dArray2[0][0]).add(iVec3, dArray2[1][1]);
        iVecIArray3[1][1] = iVec4.dup().add(iVec2, dArray2[0][1]).add(iVec3, dArray2[1][1]);
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        for (int i = 0; i < iVecIArray2.length; ++i) {
            iVecIArray2[i].x = (iVecIArray2[i].x - dArray2[0][0]) / (dArray2[0][1] - dArray2[0][0]);
            ((IVec)iVecIArray2[i]).y = (((IVec)iVecIArray2[i]).y - dArray2[1][0]) / (dArray2[1][1] - dArray2[1][0]);
        }
        this.init(iVecIArray3, 1, 1, ISurfaceGeo.createKnots(1, iVecIArray3.length), ISurfaceGeo.createKnots(1, iVecIArray3[0].length));
        if (!bl) {
            this.addOuterTrimLoop(new ITrimCurve(iVecIArray2, n, dArray, 0.0, 1.0));
        } else {
            this.addOuterTrimLoop(new ITrimCurve[]{new ITrimCurve(iVecIArray2, n, dArray, 0.0, 1.0), new ITrimCurve(iVecIArray2[iVecIArray2.length - 1], iVecIArray2[0])});
        }
    }

    public IVecI[] serializeMatrix(IVecI[][] iVecIArray) {
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        arrayList.add(iVecIArray[0][0]);
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                if (j == 0 && arrayList.size() > 0 && ((IVecI)arrayList.get(arrayList.size() - 1)).eq(iVecIArray[i][j])) continue;
                arrayList.add(iVecIArray[i][j]);
            }
        }
        return arrayList.toArray(new IVecI[arrayList.size()]);
    }

    public void initWithPlanarTrim(IVecI[][] iVecIArray, int[] nArray, double[][] dArray, boolean bl) {
        int n;
        IVecI[] iVecIArray2 = this.serializeMatrix(iVecIArray);
        IVec iVec = IVec.averageNormal(iVecIArray2);
        IVec[] iVecArray = ISurfaceGeo.getPlanarUVVectors(iVecIArray2);
        IVec iVec2 = iVecArray[0];
        IVec iVec3 = iVecArray[1];
        iVec2 = iVec.cross(iVec2).cross(iVec).unit();
        iVec3 = iVec.cross(iVec2).unit();
        IVec iVec4 = iVecIArray[0][0].get();
        IVec[][] iVecArray2 = ISurfaceGeo.getPlanarUVPoints(iVecIArray, (IVecI)iVec4, iVec2, iVec3);
        double[][] dArray2 = ISurfaceGeo.getPlanarUVRange(iVecArray2);
        IVecI[][] iVecIArray3 = new IVec[2][2];
        iVecIArray3[0][0] = iVec4.dup().add(iVec2, dArray2[0][0]).add(iVec3, dArray2[1][0]);
        iVecIArray3[1][0] = iVec4.dup().add(iVec2, dArray2[0][1]).add(iVec3, dArray2[1][0]);
        iVecIArray3[0][1] = iVec4.dup().add(iVec2, dArray2[0][0]).add(iVec3, dArray2[1][1]);
        iVecIArray3[1][1] = iVec4.dup().add(iVec2, dArray2[0][1]).add(iVec3, dArray2[1][1]);
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        for (int i = 0; i < iVecArray2.length; ++i) {
            for (n = 0; n < iVecArray2[i].length; ++n) {
                iVecArray2[i][n].x = (iVecArray2[i][n].x - dArray2[0][0]) / (dArray2[0][1] - dArray2[0][0]);
                iVecArray2[i][n].y = (iVecArray2[i][n].y - dArray2[1][0]) / (dArray2[1][1] - dArray2[1][0]);
            }
        }
        this.init(iVecIArray3, 1, 1, ISurfaceGeo.createKnots(1, iVecIArray3.length), ISurfaceGeo.createKnots(1, iVecIArray3[0].length));
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iVecArray2.length + (bl ? 1 : 0)];
        for (n = 0; n < iVecArray2.length; ++n) {
            iTrimCurveArray[n] = new ITrimCurve(iVecArray2[n], nArray[n], dArray[n], 0.0, 1.0);
        }
        if (bl) {
            iTrimCurveArray[iVecArray2.length] = new ITrimCurve(iVecArray2[iVecArray2.length - 1][iVecArray2[iVecArray2.length - 1].length - 1], iVecArray2[0][0]);
        }
        this.addOuterTrimLoop(iTrimCurveArray);
    }

    public void initWithPlanarTrim(IVecI[] iVecIArray, int n, double[] dArray, boolean bl, IVecI[][] iVecIArray2, int[] nArray, double[][] dArray2, boolean[] blArray) {
        this.initWithPlanarTrim(iVecIArray, n, dArray, bl);
        if (iVecIArray2 == null || nArray == null || dArray2 == null || blArray == null) {
            IOut.err("inner trim parameter is null");
            return;
        }
        if (iVecIArray2.length != nArray.length || iVecIArray2.length != dArray2.length || iVecIArray2.length != blArray.length) {
            IOut.err("inner trim parameter array length doesn't match");
            return;
        }
        IVec iVec = this.corner(0, 0).get();
        IVec iVec2 = this.corner(1, 0).diff(iVec);
        IVec iVec3 = this.corner(0, 1).diff(iVec);
        for (int i = 0; i < iVecIArray2.length; ++i) {
            IVecI[] iVecIArray3 = ISurfaceGeo.getPlanarUVPoints(iVecIArray2[i], (IVecI)iVec, iVec2, iVec3);
            if (!blArray[i]) {
                this.addInnerTrimLoop(new ITrimCurve(iVecIArray3, nArray[i], dArray2[i], 0.0, 1.0));
                continue;
            }
            this.addInnerTrimLoop(new ITrimCurve[]{new ITrimCurve(iVecIArray3, nArray[i], dArray2[i], 0.0, 1.0), new ITrimCurve(iVecIArray3[iVecIArray3.length - 1], iVecIArray3[0])});
        }
    }

    public void initWithPlanarTrim(IVecI[][] iVecIArray, int[] nArray, double[][] dArray, boolean bl, IVecI[][][] iVecIArray2, int[][] nArray2, double[][][] dArray2, boolean[] blArray) {
        this.initWithPlanarTrim(iVecIArray, nArray, dArray, bl);
        if (iVecIArray2 == null || nArray2 == null || dArray2 == null || blArray == null) {
            IOut.err("inner trim parameter is null");
            return;
        }
        if (iVecIArray2.length != nArray2.length || iVecIArray2.length != dArray2.length || iVecIArray2.length != blArray.length) {
            IOut.err("inner trim parameter array length doesn't match");
            return;
        }
        IVec iVec = this.corner(0, 0).get();
        IVec iVec2 = this.corner(1, 0).diff(iVec);
        IVec iVec3 = this.corner(0, 1).diff(iVec);
        for (int i = 0; i < iVecIArray2.length; ++i) {
            ITrimCurve[] iTrimCurveArray = new ITrimCurve[iVecIArray2[i].length + (blArray[i] ? 1 : 0)];
            IVec[][] iVecArrayArray = new IVec[iVecIArray2[i].length][];
            for (int j = 0; j < iVecIArray2[i].length; ++j) {
                iVecArrayArray[j] = ISurfaceGeo.getPlanarUVPoints(iVecIArray2[i][j], (IVecI)iVec, iVec2, iVec3);
                iTrimCurveArray[j] = new ITrimCurve(iVecArrayArray[j], nArray2[i][j], dArray2[i][j], 0.0, 1.0);
            }
            if (blArray[i]) {
                iTrimCurveArray[iVecIArray2[i].length] = new ITrimCurve(iVecArrayArray[iVecArrayArray.length - 1][iVecArrayArray[iVecArrayArray.length - 1].length - 1], iVecArrayArray[0][0]);
            }
            this.addInnerTrimLoop(iTrimCurveArray);
        }
    }

    public void initWithPlanarTrims(ICurveI[] iCurveIArray) {
        int n;
        int n2;
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        for (int i = 0; i < iCurveIArray.length; ++i) {
            for (int j = 0; j < iCurveIArray[i].num(); ++j) {
                if (arrayList.size() != 0 && ((IVecI)arrayList.get(arrayList.size() - 1)).eq(iCurveIArray[i].cp(j))) continue;
                arrayList.add(iCurveIArray[i].cp(j));
            }
        }
        IVecI[] iVecIArray = arrayList.toArray(new IVecI[arrayList.size()]);
        IVec iVec = IVec.averageNormal(iVecIArray);
        IVec[] iVecArray = ISurfaceGeo.getPlanarUVVectors(iVecIArray);
        IVec iVec2 = iVecArray[0];
        IVec iVec3 = iVecArray[1];
        iVec2 = iVec.cross(iVec2).cross(iVec).unit();
        iVec3 = iVec.cross(iVec2).unit();
        IVec iVec4 = iVecIArray[0].get();
        IVec[] iVecArray2 = ISurfaceGeo.getPlanarUVPoints(iVecIArray, (IVecI)iVec4, iVec2, iVec3);
        double[][] dArray = ISurfaceGeo.getPlanarUVRange(iVecArray2);
        IVecI[][] iVecIArray2 = new IVec[2][2];
        iVecIArray2[0][0] = iVec4.dup().add(iVec2, dArray[0][0]).add(iVec3, dArray[1][0]);
        iVecIArray2[1][0] = iVec4.dup().add(iVec2, dArray[0][1]).add(iVec3, dArray[1][0]);
        iVecIArray2[0][1] = iVec4.dup().add(iVec2, dArray[0][0]).add(iVec3, dArray[1][1]);
        iVecIArray2[1][1] = iVec4.dup().add(iVec2, dArray[0][1]).add(iVec3, dArray[1][1]);
        IVecI[][] iVecIArrayArray = new IVecI[iCurveIArray.length][];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iVecIArrayArray[i] = new IVecI[iCurveIArray[i].num()];
            for (n2 = 0; n2 < iCurveIArray[i].num(); ++n2) {
                iVecIArrayArray[i][n2] = iCurveIArray[i].cp(n2);
            }
        }
        IVec[][] iVecArrayArray = new IVec[iCurveIArray.length][];
        for (n2 = 0; n2 < iCurveIArray.length; ++n2) {
            iVecArrayArray[n2] = ISurfaceGeo.getPlanarUVPoints(iVecIArrayArray[n2], (IVecI)iVec4, iVec2, iVec3);
        }
        for (n2 = 0; n2 < iVecArrayArray.length; ++n2) {
            for (n = 0; n < iVecArrayArray[n2].length; ++n) {
                iVecArrayArray[n2][n].x = (iVecArrayArray[n2][n].x - dArray[0][0]) / (dArray[0][1] - dArray[0][0]);
                iVecArrayArray[n2][n].y = (iVecArrayArray[n2][n].y - dArray[1][0]) / (dArray[1][1] - dArray[1][0]);
            }
        }
        this.init(iVecIArray2, 1, 1, ISurfaceGeo.createKnots(1, iVecIArray2.length), ISurfaceGeo.createKnots(1, iVecIArray2[0].length));
        ArrayList<ITrimCurve> arrayList2 = new ArrayList<ITrimCurve>();
        for (n = 0; n < iCurveIArray.length; ++n) {
            double[] dArray2 = new double[iCurveIArray[n].knotNum()];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = iCurveIArray[n].knot(i);
            }
            ITrimCurve iTrimCurve = new ITrimCurve(iVecArrayArray[n], iCurveIArray[n].deg(), dArray2, 0.0, 1.0);
            if (n > 0 && !((ITrimCurve)arrayList2.get(arrayList2.size() - 1)).end2d().eq(iTrimCurve.start2d())) {
                ITrimCurve iTrimCurve2 = new ITrimCurve(((ITrimCurve)arrayList2.get(arrayList2.size() - 1)).end2d().to3d(), iTrimCurve.start2d().to3d());
                arrayList2.add(iTrimCurve2);
            }
            arrayList2.add(iTrimCurve);
        }
        if (arrayList2.size() > 1 && !((ITrimCurve)arrayList2.get(arrayList2.size() - 1)).end2d().eq(((ITrimCurve)arrayList2.get(0)).start2d())) {
            ITrimCurve iTrimCurve = new ITrimCurve(((ITrimCurve)arrayList2.get(arrayList2.size() - 1)).end2d().to3d(), ((ITrimCurve)arrayList2.get(0)).start2d().to3d());
            arrayList2.add(iTrimCurve);
        }
        this.addOuterTrimLoop(arrayList2.toArray(new ITrimCurve[arrayList2.size()]));
    }

    public boolean isValid() {
        return ISurfaceGeo.isValidCP(this.controlPoints, this.udegree, this.vdegree, this.uknots, this.vknots);
    }

    public static boolean isValidCP(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        if (iVecIArray == null) {
            IOut.err("control points are null");
            return false;
        }
        if (dArray == null) {
            IOut.err("uknots are null");
            return false;
        }
        if (dArray2 == null) {
            IOut.err("vknots are null");
            return false;
        }
        if (n <= 0) {
            IOut.err("invalid udeg (" + n + ")");
            return false;
        }
        if (n2 <= 0) {
            IOut.err("invalid vdeg (" + n2 + ")");
            return false;
        }
        int n3 = iVecIArray.length;
        int n4 = iVecIArray[0].length;
        for (int i = 1; i < n3; ++i) {
            if (iVecIArray[i].length == n4) continue;
            IOut.err("vnum(" + n4 + ") in control point array is inconsistent (" + iVecIArray[i].length + ")");
            return false;
        }
        if (n3 <= n) {
            IOut.err("too less control points in u direction (" + n3 + ") for u degree " + n + ". it needs minimum " + (n + 1));
            return false;
        }
        if (n4 <= n2) {
            IOut.err("too less control points in v direction (" + n4 + ") for v degree " + n2 + ". it needs minimum " + (n2 + 1));
            return false;
        }
        if (dArray.length != n + n3 + 1) {
            IOut.err("uknot array length is invalid. it needs to be " + (n + n3 + 1));
            return false;
        }
        if (dArray2.length != n2 + n4 + 1) {
            IOut.err("vknot array length is invalid. it needs to be " + (n2 + n4 + 1));
            return false;
        }
        if (!ISurfaceGeo.isValidCP(iVecIArray)) {
            return false;
        }
        if (!ISurfaceGeo.isValidKnots(dArray)) {
            IOut.err("uknot has invalid value");
            return false;
        }
        if (!ISurfaceGeo.isValidKnots(dArray2)) {
            IOut.err("uknot has invalid value");
            return false;
        }
        return true;
    }

    public static boolean isValidCP(IVecI[][] iVecIArray) {
        if (iVecIArray == null) {
            IOut.err("controlPoint is null");
            return false;
        }
        for (int i = 0; i < iVecIArray.length; ++i) {
            if (iVecIArray[i] == null) {
                IOut.err("controlPoint[" + i + "] is null");
                return false;
            }
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                if (iVecIArray[i][j] == null) {
                    IOut.err("controlPoint at " + i + "," + j + " is null");
                    return false;
                }
                if (iVecIArray[i][j].isValid()) continue;
                IOut.err("controlPoint at " + i + "," + j + " is invalid");
                return false;
            }
        }
        return true;
    }

    public static void checkDuplicatedCP(IVecI[][] iVecIArray) {
        int n = iVecIArray.length;
        int n2 = iVecIArray[0].length;
        int n3 = n * n2;
        for (int i = 0; i < n3; ++i) {
            for (int j = i + 1; j < n3; ++j) {
                if (iVecIArray[j / n2][j % n2] != iVecIArray[i / n2][i % n2]) continue;
                iVecIArray[j / n2][j % n2] = iVecIArray[i / n2][i % n2].dup();
            }
        }
    }

    public static void checkDuplicatedCP(IVecI[][] iVecIArray, IVecI[] iVecIArray2) {
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                for (int k = 0; k < iVecIArray2.length; ++k) {
                    if (iVecIArray2[k] != iVecIArray[i][j]) continue;
                    iVecIArray2[k] = iVecIArray2[k].dup();
                }
            }
        }
    }

    public static void checkDuplicatedCPOnEdge(IVecI[][] iVecIArray) {
        int n;
        int n2 = iVecIArray.length;
        int n3 = iVecIArray[0].length;
        for (n = 0; n < n2; ++n) {
            if (iVecIArray[n][0] != iVecIArray[n][n3 - 1]) continue;
            iVecIArray[n][n3 - 1] = iVecIArray[n][0].dup();
        }
        for (n = 0; n < n3; ++n) {
            if (iVecIArray[0][n] != iVecIArray[n2 - 1][n]) continue;
            iVecIArray[n2 - 1][n] = iVecIArray[0][n].dup();
        }
    }

    public static IVec[][] getPointsFromArray(double[][][] dArray) {
        IVec[][] iVecArray = new IVec[dArray.length][dArray[0].length];
        for (int i = 0; i < iVecArray.length; ++i) {
            for (int j = 0; j < iVecArray[0].length; ++j) {
                if (dArray[i][j].length == 4) {
                    iVecArray[i][j] = new IVec4(dArray[i][j][0], dArray[i][j][1], dArray[i][j][2], dArray[i][j][3]);
                    continue;
                }
                iVecArray[i][j] = new IVec();
                if (dArray[i][j].length >= 1) {
                    iVecArray[i][j].x = dArray[i][j][0];
                }
                if (dArray[i][j].length >= 2) {
                    iVecArray[i][j].y = dArray[i][j][1];
                }
                if (dArray[i][j].length < 3) continue;
                iVecArray[i][j].z = dArray[i][j][2];
            }
        }
        return iVecArray;
    }

    public static IVec[] getPlanarUVVectors(IVecI[] iVecIArray) {
        IVec iVec;
        int n;
        IVec iVec2 = null;
        IVec iVec3 = null;
        for (n = 0; n < iVecIArray.length - 1 && iVec2 == null; ++n) {
            iVec = iVecIArray[n + 1].get();
            if (iVec.eq(iVecIArray[n])) continue;
            iVec2 = iVec.diff(iVecIArray[n]);
        }
        while (n < iVecIArray.length - 1 && iVec3 == null) {
            iVec = iVecIArray[n + 1].get();
            if (!iVec.eq(iVecIArray[n]) && (iVec3 = iVec.diff(iVecIArray[n])).isParallel(iVec2)) {
                iVec3 = null;
            }
            ++n;
        }
        if (iVecIArray.length < 3) {
            IOut.err("too less trim points (" + iVecIArray.length + "). needs to be 3 or more");
            return null;
        }
        if (iVec3 == null) {
            IOut.err("trim curve has no width");
            iVec3 = iVec2.rot(IG.zaxis, 1.5707963267948966);
        }
        return new IVec[]{iVec2.unit(), iVec2.cross(iVec3).cross(iVec2).unit()};
    }

    public static IVec[] getPlanarUVPoints(IVecI[] iVecIArray, IVecI iVecI, IVec iVec, IVec iVec2) {
        IVec[] iVecArray = new IVec[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            IVec iVec3 = iVecIArray[i].get().diff(iVecI);
            double[] dArray = iVec3.projectTo2Vec(iVec, iVec2);
            iVecArray[i] = iVecIArray[i] instanceof IVec4I ? new IVec4(dArray[0], dArray[1], 0.0, ((IVec4I)iVecIArray[i]).w()) : new IVec(dArray[0], dArray[1], 0.0);
        }
        return iVecArray;
    }

    public static IVec[][] getPlanarUVPoints(IVecI[][] iVecIArray, IVecI iVecI, IVec iVec, IVec iVec2) {
        IVec[][] iVecArray = new IVec[iVecIArray.length][];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecArray[i] = new IVec[iVecIArray[i].length];
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                IVec iVec3 = iVecIArray[i][j].get().diff(iVecI);
                double[] dArray = iVec3.projectTo2Vec(iVec, iVec2);
                iVecArray[i][j] = iVecIArray[i][j] instanceof IVec4I ? new IVec4(dArray[0], dArray[1], 0.0, ((IVec4I)iVecIArray[i][j]).w()) : new IVec(dArray[0], dArray[1], 0.0);
            }
        }
        return iVecArray;
    }

    public static double[][] getPlanarUVRange(IVec[] iVecArray) {
        double d = iVecArray[0].x;
        double d2 = iVecArray[0].x;
        double d3 = iVecArray[0].y;
        double d4 = iVecArray[0].y;
        for (int i = 1; i < iVecArray.length; ++i) {
            if (iVecArray[i].x < d) {
                d = iVecArray[i].x;
            } else if (iVecArray[i].x > d2) {
                d2 = iVecArray[i].x;
            }
            if (iVecArray[i].y < d3) {
                d3 = iVecArray[i].y;
                continue;
            }
            if (!(iVecArray[i].y > d4)) continue;
            d4 = iVecArray[i].y;
        }
        return new double[][]{{d, d2}, {d3, d4}};
    }

    public static double[][] getPlanarUVRange(IVec[][] iVecArray) {
        double d = iVecArray[0][0].x;
        double d2 = iVecArray[0][0].x;
        double d3 = iVecArray[0][0].y;
        double d4 = iVecArray[0][0].y;
        for (int i = 0; i < iVecArray.length; ++i) {
            for (int j = 0; j < iVecArray[i].length; ++j) {
                if (i == 0 && j == 0) continue;
                if (iVecArray[i][j].x < d) {
                    d = iVecArray[i][j].x;
                } else if (iVecArray[i][j].x > d2) {
                    d2 = iVecArray[i][j].x;
                }
                if (iVecArray[i][j].y < d3) {
                    d3 = iVecArray[i][j].y;
                    continue;
                }
                if (!(iVecArray[i][j].y > d4)) continue;
                d4 = iVecArray[i][j].y;
            }
        }
        return new double[][]{{d, d2}, {d3, d4}};
    }

    public ISurfaceGeo get() {
        return this;
    }

    public ISurfaceGeo dup() {
        return new ISurfaceGeo(this);
    }

    public IVec pt(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.pt(iVec2.x, iVec2.y);
    }

    public IVec pt(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.pt(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec pt(double d, double d2) {
        IVec iVec = new IVec();
        this.pt(d, d2, iVec);
        return iVec;
    }

    public void pt(double d, double d2, IVec iVec) {
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double d3 = 0.0;
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j].get();
                double d4 = 1.0;
                if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j]) {
                    d4 = ((IVec4)iVec2).w;
                }
                iVec.x += iVec2.x * d4 * dArray[i] * dArray2[j];
                iVec.y += iVec2.y * d4 * dArray[i] * dArray2[j];
                iVec.z += iVec2.z * d4 * dArray[i] * dArray2[j];
                d3 += d4 * dArray[i] * dArray2[j];
            }
        }
        iVec.x /= d3;
        iVec.y /= d3;
        iVec.z /= d3;
    }

    public IVec pt(double d, double d2, double d3) {
        IVec iVec = new IVec();
        this.pt(d, d2, iVec);
        return iVec.add(this.nrml(d, d2).len(d3));
    }

    public IVec pt(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.pt(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x());
    }

    public IVec pt(IVec iVec) {
        return this.pt(iVec.x, iVec.y, iVec.z);
    }

    public IVec pt(IVecI iVecI) {
        IVec iVec = iVecI.get();
        return this.pt(iVec.x, iVec.y, iVec.z);
    }

    public IVec utan(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.utan(iVec2.x, iVec2.y);
    }

    public IVec utan(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.utan(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec utan(double d, double d2) {
        IVec iVec = new IVec();
        this.utan(d, d2, iVec);
        return iVec;
    }

    public void utan(double d, double d2, IVec iVec) {
        if (this.derivativeFunctionU == null) {
            this.derivativeFunctionU = new IBSplineBasisFunction(this.basisFunctionU);
            this.derivativeFunctionU.differentiate();
        }
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.derivativeFunctionU.eval(n, d);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j].get();
                double d3 = 1.0;
                if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j]) {
                    d3 = ((IVec4)iVec2).w;
                }
                iVec4.x += iVec2.x * d3 * dArray[i] * dArray2[j];
                iVec4.y += iVec2.y * d3 * dArray[i] * dArray2[j];
                iVec4.z += iVec2.z * d3 * dArray[i] * dArray2[j];
                iVec4.w += d3 * dArray[i] * dArray2[j];
                iVec42.x += iVec2.x * d3 * dArray3[i] * dArray2[j];
                iVec42.y += iVec2.y * d3 * dArray3[i] * dArray2[j];
                iVec42.z += iVec2.z * d3 * dArray3[i] * dArray2[j];
                iVec42.w += d3 * dArray3[i] * dArray2[j];
            }
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    public IVec vtan(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.vtan(iVec2.x, iVec2.y);
    }

    public IVec vtan(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.vtan(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec vtan(double d, double d2) {
        IVec iVec = new IVec();
        this.vtan(d, d2, iVec);
        return iVec;
    }

    public void vtan(double d, double d2, IVec iVec) {
        if (this.derivativeFunctionV == null) {
            this.derivativeFunctionV = new IBSplineBasisFunction(this.basisFunctionV);
            this.derivativeFunctionV.differentiate();
        }
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.derivativeFunctionV.eval(n2, d2);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j].get();
                double d3 = 1.0;
                if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j]) {
                    d3 = ((IVec4)iVec2).w;
                }
                iVec4.x += iVec2.x * d3 * dArray[i] * dArray2[j];
                iVec4.y += iVec2.y * d3 * dArray[i] * dArray2[j];
                iVec4.z += iVec2.z * d3 * dArray[i] * dArray2[j];
                iVec4.w += d3 * dArray[i] * dArray2[j];
                iVec42.x += iVec2.x * d3 * dArray[i] * dArray3[j];
                iVec42.y += iVec2.y * d3 * dArray[i] * dArray3[j];
                iVec42.z += iVec2.z * d3 * dArray[i] * dArray3[j];
                iVec42.w += d3 * dArray[i] * dArray3[j];
            }
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    public IVec nml(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.nml(iVec2.x, iVec2.y);
    }

    public IVec nml(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.nml(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec nml(double d, double d2) {
        IVec iVec = new IVec();
        this.nml(d, d2, iVec);
        return iVec;
    }

    public void nml(double d, double d2, IVec iVec) {
        IVec iVec2 = new IVec();
        this.utan(d, d2, iVec);
        this.vtan(d, d2, iVec2);
        if (iVec.len() > 0.0 && iVec2.len() > 0.0) {
            iVec.icross(iVec2);
        } else if (iVec.len() > 0.0) {
            if (d2 > 0.5) {
                this.utan(d, 0.0, iVec2);
                iVec.icross(iVec2).neg();
            } else {
                this.utan(d, 1.0, iVec2);
                iVec.icross(iVec2);
            }
        } else if (iVec2.len() > 0.0) {
            if (d > 0.5) {
                this.vtan(0.0, d2, iVec);
                iVec.icross(iVec2);
            } else {
                this.vtan(1.0, d2, iVec);
                iVec.icross(iVec2).neg();
            }
        } else {
            IOut.debug(10, "normal is zero");
        }
    }

    public IVec nrml(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.nml(iVec2.x, iVec2.y);
    }

    public IVec nrml(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.nml(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec nrml(double d, double d2) {
        IVec iVec = new IVec();
        this.nml(d, d2, iVec);
        return iVec;
    }

    public void nrml(double d, double d2, IVec iVec) {
        this.nml(d, d2, iVec);
    }

    public IVec normal(IVec2I iVec2I) {
        IVec2 iVec2 = iVec2I.get();
        return this.nml(iVec2.x, iVec2.y);
    }

    public IVec normal(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.nml(iDoubleI.x(), iDoubleI2.x());
    }

    public IVec normal(double d, double d2) {
        IVec iVec = new IVec();
        this.nml(d, d2, iVec);
        return iVec;
    }

    public void normal(double d, double d2, IVec iVec) {
        this.nml(d, d2, iVec);
    }

    public IVecI cp(int n, int n2) {
        return this.controlPoints[n][n2];
    }

    public IVecI cp(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.controlPoints[iIntegerI.x()][iIntegerI2.x()];
    }

    public IVecI[][] cps() {
        return this.controlPoints;
    }

    public IVec corner(int n, int n2) {
        if (n != 0) {
            n = 1;
        }
        if (n2 != 0) {
            n2 = 1;
        }
        return this.pt(n, n2);
    }

    public IVec corner(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.corner(iIntegerI.x(), iIntegerI2.x());
    }

    public IVec cornerCP(int n, int n2) {
        if (n != 0) {
            n = this.ucpNum() - 1;
        }
        if (n2 != 0) {
            n2 = this.vcpNum() - 1;
        }
        return this.controlPoints[n][n2].get();
    }

    public IVecI cornerCP(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        int n = 0;
        int n2 = 0;
        if (iIntegerI.x() != 0) {
            n = this.ucpNum() - 1;
        }
        if (iIntegerI2.x() != 0) {
            n2 = this.vcpNum() - 1;
        }
        return this.controlPoints[n][n2];
    }

    public ISurfaceGeo addUCP(IVecI[] iVecIArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (iVecIArray.length != this.vnum()) {
            IOut.err("vnum (" + this.vnum() + ") and point array size (" + iVecIArray.length + ") don't match.");
            return this;
        }
        for (n4 = 0; n4 < iVecIArray.length; ++n4) {
            if (iVecIArray[n4] != null && iVecIArray[n4].isValid()) continue;
            IOut.err("input pts[" + n4 + "] is invalid. not added");
            return this;
        }
        if (this.controlPoints.length == 2) {
            n4 = 1;
            for (n3 = 0; n3 < this.controlPoints[0].length && n4 != 0; ++n3) {
                if (this.controlPoints[0][n3].x() == this.controlPoints[1][n3].x() && this.controlPoints[0][n3].y() == this.controlPoints[1][n3].y() && this.controlPoints[0][n3].z() == this.controlPoints[1][n3].z()) continue;
                n4 = 0;
            }
            if (n4 != 0) {
                if (IConfig.checkDuplicatedControlPoint) {
                    ISurfaceGeo.checkDuplicatedCP(this.controlPoints, iVecIArray);
                }
                for (n3 = 0; n3 < this.controlPoints[0].length; ++n3) {
                    this.controlPoints[1][n3] = iVecIArray[n3];
                    this.defaultWeights[1][n3] = !(iVecIArray[n3] instanceof IVec4I);
                }
                return this;
            }
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ISurfaceGeo.checkDuplicatedCP(this.controlPoints, iVecIArray);
        }
        n4 = this.controlPoints.length;
        n3 = this.controlPoints[0].length;
        IVecI[][] iVecIArray2 = new IVecI[n4 + 1][n3];
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n3; ++i) {
                iVecIArray2[n2][i] = this.controlPoints[n2][i];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            iVecIArray2[n4][n2] = iVecIArray[n2];
        }
        double[] dArray = ISurfaceGeo.createKnots(this.udegree, n4 + 1);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.udegree, dArray);
        boolean[][] blArray = new boolean[n4 + 1][n3];
        for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n3; ++i) {
                blArray[n][i] = this.defaultWeights[n][i];
            }
        }
        for (n = 0; n < n3; ++n) {
            blArray[n4][n] = !(iVecIArray[n] instanceof IVec4I);
        }
        this.controlPoints = iVecIArray2;
        this.uknots = dArray;
        this.basisFunctionU = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        return this;
    }

    public ISurfaceGeo addVCP(IVecI[] iVecIArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (iVecIArray.length != this.unum()) {
            IOut.err("unum (" + this.unum() + ") and point array size (" + iVecIArray.length + ") don't match.");
            return this;
        }
        for (n4 = 0; n4 < iVecIArray.length; ++n4) {
            if (iVecIArray[n4] != null && iVecIArray[n4].isValid()) continue;
            IOut.err("input pts[" + n4 + "] is invalid. not added");
            return this;
        }
        if (this.controlPoints[0].length == 2) {
            n4 = 1;
            for (n3 = 0; n3 < this.controlPoints.length && n4 != 0; ++n3) {
                if (this.controlPoints[n3][0].x() == this.controlPoints[n3][1].x() && this.controlPoints[n3][0].y() == this.controlPoints[n3][1].y() && this.controlPoints[n3][0].z() == this.controlPoints[n3][1].z()) continue;
                n4 = 0;
            }
            if (n4 != 0) {
                if (IConfig.checkDuplicatedControlPoint) {
                    ISurfaceGeo.checkDuplicatedCP(this.controlPoints, iVecIArray);
                }
                for (n3 = 0; n3 < this.controlPoints.length; ++n3) {
                    this.controlPoints[n3][1] = iVecIArray[n3];
                    this.defaultWeights[n3][1] = !(iVecIArray[n3] instanceof IVec4I);
                }
                return this;
            }
        }
        if (IConfig.checkDuplicatedControlPoint) {
            ISurfaceGeo.checkDuplicatedCP(this.controlPoints, iVecIArray);
        }
        n4 = this.controlPoints.length;
        n3 = this.controlPoints[0].length;
        IVecI[][] iVecIArray2 = new IVecI[n4][n3 + 1];
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n3; ++i) {
                iVecIArray2[n2][i] = this.controlPoints[n2][i];
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            iVecIArray2[n2][n3] = iVecIArray[n2];
        }
        double[] dArray = ISurfaceGeo.createKnots(this.vdegree, n3 + 1);
        IBSplineBasisFunction iBSplineBasisFunction = new IBSplineBasisFunction(this.vdegree, dArray);
        boolean[][] blArray = new boolean[n4][n3 + 1];
        for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n3; ++i) {
                blArray[n][i] = this.defaultWeights[n][i];
            }
        }
        for (n = 0; n < n4; ++n) {
            blArray[n][n3] = !(iVecIArray[n] instanceof IVec4I);
        }
        this.controlPoints = iVecIArray2;
        this.vknots = dArray;
        this.basisFunctionV = iBSplineBasisFunction;
        this.defaultWeights = blArray;
        return this;
    }

    public IVec ep(int n, int n2) {
        return this.pt(this.uknots[n + this.udegree], this.vknots[n2 + this.vdegree]);
    }

    public IVec ep(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.pt(this.uknots[iIntegerI.x() + this.udegree], this.vknots[iIntegerI2.x() + this.vdegree]);
    }

    public IVec mid() {
        return this.pt(0.5, 0.5);
    }

    public IVec center() {
        int n;
        boolean bl;
        int n2 = this.ucpNum();
        int n3 = this.vcpNum();
        int n4 = n2;
        int n5 = n3;
        if (this.vknots[0] != 0.0 || this.vknots[this.vknots.length - 1] != 1.0) {
            bl = true;
            for (n = 0; n < n2 && bl; ++n) {
                if (this.cp(n, 0).eq(this.cp(n, n3 - this.vdeg()))) continue;
                bl = false;
            }
            if (bl) {
                n5 = n3 - this.vdeg();
            }
        } else {
            bl = true;
            for (n = 0; n <= n2 && bl; ++n) {
                if (this.pt((double)n / (double)n2, 0.0).eq(this.pt((double)n / (double)n2, 1.0))) continue;
                bl = false;
            }
            if (bl) {
                n5 = n3 - 1;
            }
        }
        if (this.uknots[0] != 0.0 || this.uknots[this.uknots.length - 1] != 1.0) {
            bl = true;
            for (n = 0; n < n3 && bl; ++n) {
                if (this.cp(0, n).eq(this.cp(n2 - this.udeg(), n))) continue;
                bl = false;
            }
            if (bl) {
                n4 = n2 - this.udeg();
            }
        } else {
            bl = true;
            for (n = 0; n <= n3 && bl; ++n) {
                if (this.pt(0.0, (double)n / (double)n3).eq(this.pt(1.0, (double)n / (double)n3))) continue;
                bl = false;
            }
            if (bl) {
                n4 = n2 - 1;
            }
        }
        IVec iVec = new IVec();
        for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n5; ++i) {
                iVec.add(this.cp(n, i));
            }
        }
        iVec.div(n4 * n5);
        return iVec;
    }

    public synchronized IVec2 uv(IVecI iVecI) {
        if (this.uvSearchCache == null) {
            this.uvSearchCache = new ISurfaceCache(this);
        }
        return this.uvSearchCache.uv(iVecI.get());
    }

    public synchronized IVec2 uv(IVec2I iVec2I) {
        if (this.uvSearchCache == null) {
            this.uvSearchCache = new ISurfaceCache(this);
        }
        return this.uvSearchCache.uv(iVec2I.get());
    }

    public IVec closePt(IVecI iVecI) {
        return this.pt(this.uv(iVecI));
    }

    public IVec closePt(IVec2I iVec2I) {
        return this.pt(this.uv(iVec2I));
    }

    public double dist(IVecI iVecI) {
        return this.closePt(iVecI).dist(iVecI);
    }

    public double dist(IVec2I iVec2I) {
        return this.closePt(iVec2I).to2d().dist(iVec2I);
    }

    public double uknot(int n) {
        return this.uknots[n];
    }

    public IDouble uknot(IIntegerI iIntegerI) {
        return new IDouble(this.uknots[iIntegerI.x()]);
    }

    public double vknot(int n) {
        return this.vknots[n];
    }

    public IDouble vknot(IIntegerI iIntegerI) {
        return new IDouble(this.vknots[iIntegerI.x()]);
    }

    public double[] uknots() {
        return this.uknots;
    }

    public double[] uknots(ISwitchE iSwitchE) {
        return this.uknots();
    }

    public IDouble[] uknots(ISwitchR iSwitchR) {
        IDouble[] iDoubleArray = new IDouble[this.uknots.length];
        for (int i = 0; i < this.uknots.length; ++i) {
            iDoubleArray[i] = new IDouble(this.uknots[i]);
        }
        return iDoubleArray;
    }

    public double[] vknots() {
        return this.vknots;
    }

    public double[] vknots(ISwitchE iSwitchE) {
        return this.vknots();
    }

    public IDouble[] vknots(ISwitchR iSwitchR) {
        IDouble[] iDoubleArray = new IDouble[this.vknots.length];
        for (int i = 0; i < this.vknots.length; ++i) {
            iDoubleArray[i] = new IDouble(this.vknots[i]);
        }
        return iDoubleArray;
    }

    public int uknotNum() {
        return this.uknots.length;
    }

    public int vknotNum() {
        return this.vknots.length;
    }

    public int uknotNum(ISwitchE iSwitchE) {
        return this.uknotNum();
    }

    public int vknotNum(ISwitchE iSwitchE) {
        return this.vknotNum();
    }

    public IInteger uknotNum(ISwitchR iSwitchR) {
        return new IInteger(this.uknotNum());
    }

    public IInteger vknotNum(ISwitchR iSwitchR) {
        return new IInteger(this.vknotNum());
    }

    public boolean isRational() {
        if (this.defaultWeights == null) {
            IOut.err("defaultWeights is null");
            return false;
        }
        for (int i = 0; i < this.defaultWeights.length; ++i) {
            for (int j = 0; j < this.defaultWeights[i].length; ++j) {
                if (this.defaultWeights[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRational(ISwitchE iSwitchE) {
        return this.isRational();
    }

    public IBool isRational(ISwitchR iSwitchR) {
        return new IBool(this.isRational());
    }

    public int udeg() {
        return this.udegree;
    }

    public int vdeg() {
        return this.vdegree;
    }

    public int udeg(ISwitchE iSwitchE) {
        return this.udeg();
    }

    public int vdeg(ISwitchE iSwitchE) {
        return this.vdeg();
    }

    public IInteger udeg(ISwitchR iSwitchR) {
        return new IInteger(this.udeg());
    }

    public IInteger vdeg(ISwitchR iSwitchR) {
        return new IInteger(this.vdeg());
    }

    public int unum() {
        return this.controlPoints.length;
    }

    public int vnum() {
        return this.controlPoints[0].length;
    }

    public int unum(ISwitchE iSwitchE) {
        return this.unum();
    }

    public int vnum(ISwitchE iSwitchE) {
        return this.vnum();
    }

    public IInteger unum(ISwitchR iSwitchR) {
        return new IInteger(this.unum());
    }

    public IInteger vnum(ISwitchR iSwitchR) {
        return new IInteger(this.vnum());
    }

    public int ucpNum() {
        return this.unum();
    }

    public int vcpNum() {
        return this.vnum();
    }

    public int ucpNum(ISwitchE iSwitchE) {
        return this.ucpNum();
    }

    public int vcpNum(ISwitchE iSwitchE) {
        return this.vcpNum();
    }

    public IInteger ucpNum(ISwitchR iSwitchR) {
        return new IInteger(this.ucpNum());
    }

    public IInteger vcpNum(ISwitchR iSwitchR) {
        return new IInteger(this.vcpNum());
    }

    public int uepNum() {
        return this.uknots.length - 2 * this.udegree;
    }

    public int vepNum() {
        return this.vknots.length - 2 * this.vdegree;
    }

    public int uepNum(ISwitchE iSwitchE) {
        return this.uepNum();
    }

    public int vepNum(ISwitchE iSwitchE) {
        return this.vepNum();
    }

    public IInteger uepNum(ISwitchR iSwitchR) {
        return new IInteger(this.uepNum());
    }

    public IInteger vepNum(ISwitchR iSwitchR) {
        return new IInteger(this.vepNum());
    }

    public double u(int n, double d) {
        if (d >= 0.0) {
            return this.uknots[n + this.udegree] + (this.uknots[n + this.udegree + 1] - this.uknots[n + this.udegree]) * d;
        }
        return this.uknots[n + this.udegree] + (this.uknots[n + this.udegree] - this.uknots[n + this.udegree - 1]) * d;
    }

    public IDouble u(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return new IDouble(this.u(iIntegerI.x(), iDoubleI.x()));
    }

    public double v(int n, double d) {
        if (d >= 0.0) {
            return this.vknots[n + this.vdegree] + (this.vknots[n + this.vdegree + 1] - this.vknots[n + this.vdegree]) * d;
        }
        return this.vknots[n + this.vdegree] + (this.vknots[n + this.vdegree] - this.vknots[n + this.vdegree - 1]) * d;
    }

    public IDouble v(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return new IDouble(this.v(iIntegerI.x(), iDoubleI.x()));
    }

    public double ustart() {
        return this.ustart;
    }

    public double uend() {
        return this.uend;
    }

    public double vstart() {
        return this.vstart;
    }

    public double vend() {
        return this.vend;
    }

    public double ustart(ISwitchE iSwitchE) {
        return this.ustart();
    }

    public double uend(ISwitchE iSwitchE) {
        return this.uend();
    }

    public double vstart(ISwitchE iSwitchE) {
        return this.vstart();
    }

    public double vend(ISwitchE iSwitchE) {
        return this.vend();
    }

    public IDouble ustart(ISwitchR iSwitchR) {
        return new IDouble(this.ustart());
    }

    public IDouble uend(ISwitchR iSwitchR) {
        return new IDouble(this.uend());
    }

    public IDouble vstart(ISwitchR iSwitchR) {
        return new IDouble(this.vstart());
    }

    public IDouble vend(ISwitchR iSwitchR) {
        return new IDouble(this.vend());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurfaceGeo revU() {
        Object object = IG.lock;
        synchronized (object) {
            int n;
            IVecI[][] iVecIArray = new IVecI[this.controlPoints.length][this.controlPoints[0].length];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                for (n = 0; n < this.controlPoints[i].length; ++n) {
                    iVecIArray[i][n] = this.controlPoints[this.controlPoints.length - 1 - i][n];
                }
            }
            double[] dArray = new double[this.uknots.length];
            for (n = 0; n < this.uknots.length; ++n) {
                dArray[n] = 1.0 - this.uknots[this.uknots.length - 1 - n];
            }
            boolean[][] blArray = new boolean[this.defaultWeights.length][this.defaultWeights[0].length];
            for (int i = 0; i < this.defaultWeights.length; ++i) {
                for (int j = 0; j < this.defaultWeights[i].length; ++j) {
                    blArray[i][j] = this.defaultWeights[this.defaultWeights.length - 1 - i][j];
                }
            }
            this.controlPoints = iVecIArray;
            this.uknots = dArray;
            this.defaultWeights = blArray;
            if (this.ustart != 0.0 || this.uend != 1.0) {
                double d = -this.uend;
                double d2 = -this.ustart;
                this.ustart = d;
                this.uend = d2;
            }
            this.basisFunctionU = new IBSplineBasisFunction(this.udegree, this.uknots);
            this.derivativeFunctionU = null;
            this.revTrimU();
        }
        return this;
    }

    public ISurfaceGeo revTrimU() {
        int n;
        ITrimCurve iTrimCurve;
        int n2;
        int n3;
        if (this.innerTrimLoop != null) {
            for (n3 = 0; n3 < this.innerTrimLoop.size(); ++n3) {
                for (n2 = 0; n2 < this.innerTrimLoop.get(n3).size(); ++n2) {
                    iTrimCurve = this.innerTrimLoop.get(n3).get(n2);
                    for (n = 0; n < iTrimCurve.cpNum(); ++n) {
                        iTrimCurve.cp(n).set(1.0 - iTrimCurve.cp(n).x(), iTrimCurve.cp(n).y(), iTrimCurve.cp(n).z());
                    }
                }
            }
        }
        if (this.outerTrimLoop != null) {
            for (n3 = 0; n3 < this.outerTrimLoop.size(); ++n3) {
                for (n2 = 0; n2 < this.outerTrimLoop.get(n3).size(); ++n2) {
                    iTrimCurve = this.outerTrimLoop.get(n3).get(n2);
                    for (n = 0; n < iTrimCurve.cpNum(); ++n) {
                        iTrimCurve.cp(n).set(1.0 - iTrimCurve.cp(n).x(), iTrimCurve.cp(n).y(), iTrimCurve.cp(n).z());
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurfaceGeo revV() {
        Object object = IG.lock;
        synchronized (object) {
            int n;
            IVecI[][] iVecIArray = new IVecI[this.controlPoints.length][this.controlPoints[0].length];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                for (n = 0; n < this.controlPoints[i].length; ++n) {
                    iVecIArray[i][n] = this.controlPoints[i][this.controlPoints[i].length - 1 - n];
                }
            }
            double[] dArray = new double[this.vknots.length];
            for (n = 0; n < this.vknots.length; ++n) {
                dArray[n] = 1.0 - this.vknots[this.vknots.length - 1 - n];
            }
            boolean[][] blArray = new boolean[this.defaultWeights.length][this.defaultWeights[0].length];
            for (int i = 0; i < this.defaultWeights.length; ++i) {
                for (int j = 0; j < this.defaultWeights[i].length; ++j) {
                    blArray[i][j] = this.defaultWeights[i][this.defaultWeights[i].length - 1 - j];
                }
            }
            this.controlPoints = iVecIArray;
            this.vknots = dArray;
            this.defaultWeights = blArray;
            if (this.vstart != 0.0 || this.vend != 1.0) {
                double d = -this.vend;
                double d2 = -this.vstart;
                this.vstart = d;
                this.vend = d2;
            }
            this.basisFunctionV = new IBSplineBasisFunction(this.vdegree, this.vknots);
            this.derivativeFunctionV = null;
            this.revTrimU();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurfaceGeo revUV() {
        Object object = IG.lock;
        synchronized (object) {
            double d;
            int n;
            IVecI[][] iVecIArray = new IVecI[this.controlPoints.length][this.controlPoints[0].length];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                for (n = 0; n < this.controlPoints[i].length; ++n) {
                    iVecIArray[i][n] = this.controlPoints[this.controlPoints.length - 1 - i][this.controlPoints[i].length - 1 - n];
                }
            }
            double[] dArray = new double[this.uknots.length];
            for (n = 0; n < this.uknots.length; ++n) {
                dArray[n] = 1.0 - this.uknots[this.uknots.length - 1 - n];
            }
            double[] dArray2 = new double[this.vknots.length];
            for (int i = 0; i < this.vknots.length; ++i) {
                dArray2[i] = 1.0 - this.vknots[this.vknots.length - 1 - i];
            }
            boolean[][] blArray = new boolean[this.defaultWeights.length][this.defaultWeights[0].length];
            for (int i = 0; i < this.defaultWeights.length; ++i) {
                for (int j = 0; j < this.defaultWeights[i].length; ++j) {
                    blArray[i][j] = this.defaultWeights[this.defaultWeights.length - 1 - i][this.defaultWeights[i].length - 1 - j];
                }
            }
            this.controlPoints = iVecIArray;
            this.uknots = dArray;
            this.vknots = dArray2;
            this.defaultWeights = blArray;
            if (this.ustart != 0.0 || this.uend != 1.0) {
                double d2 = -this.uend;
                d = -this.ustart;
                this.ustart = d2;
                this.uend = d;
            }
            if (this.vstart != 0.0 || this.vend != 1.0) {
                double d3 = -this.vend;
                d = -this.vstart;
                this.vstart = d3;
                this.vend = d;
            }
            this.basisFunctionU = new IBSplineBasisFunction(this.udegree, this.uknots);
            this.derivativeFunctionU = null;
            this.basisFunctionV = new IBSplineBasisFunction(this.vdegree, this.vknots);
            this.derivativeFunctionV = null;
        }
        return this;
    }

    public ISurfaceGeo revN() {
        return this.revV();
    }

    public ISurfaceGeo flipU() {
        return this.revU();
    }

    public ISurfaceGeo flipV() {
        return this.revV();
    }

    public ISurfaceGeo flipUV() {
        return this.revUV();
    }

    public ISurfaceGeo flipN() {
        return this.revN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurfaceGeo swapUV() {
        Object object = IG.lock;
        synchronized (object) {
            IVecI[][] iVecIArray = new IVecI[this.controlPoints[0].length][this.controlPoints.length];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                for (int j = 0; j < this.controlPoints[i].length; ++j) {
                    iVecIArray[j][i] = this.controlPoints[i][j];
                }
            }
            double[] dArray = this.vknots;
            double[] dArray2 = this.uknots;
            boolean[][] blArray = new boolean[this.defaultWeights[0].length][this.defaultWeights.length];
            for (int i = 0; i < this.defaultWeights.length; ++i) {
                for (int j = 0; j < this.defaultWeights[i].length; ++j) {
                    blArray[j][i] = this.defaultWeights[i][j];
                }
            }
            this.controlPoints = iVecIArray;
            this.uknots = dArray;
            this.vknots = dArray2;
            this.defaultWeights = blArray;
            double d = this.ustart;
            this.ustart = this.vstart;
            this.vstart = d;
            d = this.uend;
            this.uend = this.vend;
            this.vend = d;
            int n = this.udegree;
            this.udegree = this.vdegree;
            this.vdegree = n;
            IBSplineBasisFunction iBSplineBasisFunction = this.basisFunctionU;
            this.basisFunctionU = this.basisFunctionV;
            this.basisFunctionV = iBSplineBasisFunction;
            iBSplineBasisFunction = this.derivativeFunctionU;
            this.derivativeFunctionU = this.derivativeFunctionV;
            this.derivativeFunctionV = iBSplineBasisFunction;
        }
        return this;
    }

    public ISurfaceGeo clearInnerTrim() {
        for (int i = 0; this.innerTrimLoop != null && i < this.innerTrimLoop.size(); ++i) {
            ArrayList<ITrimCurve> arrayList = this.innerTrimLoop.get(i);
            arrayList.clear();
        }
        if (this.innerTrimLoop != null) {
            this.innerTrimLoop.clear();
        }
        return this;
    }

    public ISurfaceGeo clearOuterTrim() {
        for (int i = 0; this.outerTrimLoop != null && i < this.outerTrimLoop.size(); ++i) {
            ArrayList<ITrimCurve> arrayList = this.outerTrimLoop.get(i);
            arrayList.clear();
        }
        if (this.outerTrimLoop != null) {
            this.outerTrimLoop.clear();
        }
        return this;
    }

    public ISurfaceGeo clearTrim() {
        this.clearInnerTrim();
        this.clearOuterTrim();
        return this;
    }

    public static boolean isTrimLoopInsideBoundary(ITrimCurveI[] iTrimCurveIArray, double d, double d2, double d3, double d4) {
        boolean bl = false;
        for (int i = 0; i < iTrimCurveIArray.length; ++i) {
            if (ISurfaceGeo.isTrimCurveCPInsideBoundary(iTrimCurveIArray[i], d, d2, d3, d4)) continue;
            bl = true;
        }
        if (!bl) {
            return true;
        }
        ITrimLoopGraphic iTrimLoopGraphic = new ITrimLoopGraphic(iTrimCurveIArray, true, IConfig.trimSegmentResolution);
        IPolyline2D iPolyline2D = iTrimLoopGraphic.getPolyline2D();
        IVec2 iVec2 = iPolyline2D.getMinBoundary();
        IVec2 iVec22 = iPolyline2D.getMaxBoundary();
        if (iVec2.x < d || iVec2.y < d2 || iVec22.x > d3 || iVec22.y > d4) {
            IOut.err("trim curve is outside boundary : min = " + iVec2 + ", max = " + iVec22);
            return false;
        }
        return true;
    }

    public static boolean isTrimCurveInsideBoundary(ITrimCurveI iTrimCurveI, double d, double d2, double d3, double d4) {
        if (!ISurfaceGeo.isTrimCurveCPInsideBoundary(iTrimCurveI, d, d2, d3, d4)) {
            return false;
        }
        ITrimCurveGraphic iTrimCurveGraphic = new ITrimCurveGraphic(iTrimCurveI);
        iTrimCurveGraphic.setup2D(IConfig.trimSegmentResolution);
        IPolyline2D iPolyline2D = iTrimCurveGraphic.polyline2;
        IVec2 iVec2 = iPolyline2D.getMinBoundary();
        IVec2 iVec22 = iPolyline2D.getMaxBoundary();
        if (iVec2.x < d || iVec2.y < d2 || iVec22.x > d3 || iVec22.y > d4) {
            IOut.err("trim curve is outside boundary : min = " + iVec2 + ", max = " + iVec22);
            return false;
        }
        return true;
    }

    public static boolean isTrimCurveCPInsideBoundary(ITrimCurveI iTrimCurveI, double d, double d2, double d3, double d4) {
        for (int i = 0; i < iTrimCurveI.num(); ++i) {
            if (!(iTrimCurveI.cp((int)i).get().x < d || iTrimCurveI.cp((int)i).get().x > d3 || iTrimCurveI.cp((int)i).get().y < d2) && !(iTrimCurveI.cp((int)i).get().y > d4)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTrimLoopClosed(ITrimCurveI[] iTrimCurveIArray) {
        return iTrimCurveIArray[0].start2d().eq(iTrimCurveIArray[iTrimCurveIArray.length - 1].end2d());
    }

    public boolean checkTrimLoop(ITrimCurve[] iTrimCurveArray) {
        if (iTrimCurveArray == null) {
            IOut.err("trim loop is null");
            return false;
        }
        if (iTrimCurveArray.length == 0) {
            IOut.err("trim loop curve number is zero");
            return false;
        }
        if (!ISurfaceGeo.isTrimLoopInsideBoundary(iTrimCurveArray, 0.0, 0.0, 1.0, 1.0)) {
            IOut.err("trim loop is outside boundary of surface");
            return false;
        }
        if (!ISurfaceGeo.isTrimLoopClosed(iTrimCurveArray)) {
            IOut.err("trim loop is not closed");
            return false;
        }
        return true;
    }

    public boolean checkTrimLoop(ITrimCurve iTrimCurve) {
        if (iTrimCurve == null) {
            IOut.err("trim loop is null");
            return false;
        }
        if (!ISurfaceGeo.isTrimLoopInsideBoundary(new ITrimCurve[]{iTrimCurve}, 0.0, 0.0, 1.0, 1.0)) {
            IOut.err("trim loop is outside boundary of surface");
            return false;
        }
        if (!iTrimCurve.isClosed()) {
            IOut.err("trim loop is not closed");
            return false;
        }
        return true;
    }

    public boolean checkTrim(ITrimCurve iTrimCurve) {
        if (iTrimCurve == null) {
            IOut.err("trim loop is null");
            return false;
        }
        if (!ISurfaceGeo.isTrimCurveInsideBoundary(iTrimCurve, 0.0, 0.0, 1.0, 1.0)) {
            IOut.err("trim loop is outside boundary of surface");
            return false;
        }
        return true;
    }

    public ISurfaceGeo addDefaultOuterTrimLoop() {
        if (this.hasOuterTrim()) {
            IOut.err("the surface already has outer trim");
            return this;
        }
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[]{new ITrimCurve(new IVec(0.0, 0.0, 0.0), new IVec(1.0, 0.0, 0.0)), new ITrimCurve(new IVec(1.0, 0.0, 0.0), new IVec(1.0, 1.0, 0.0)), new ITrimCurve(new IVec(1.0, 1.0, 0.0), new IVec(0.0, 1.0, 0.0)), new ITrimCurve(new IVec(0.0, 1.0, 0.0), new IVec(0.0, 0.0, 0.0))};
        this.addOuterTrimLoop(iTrimCurveArray);
        return this;
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurveI[] iTrimCurveIArray) {
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iTrimCurveIArray.length];
        for (int i = 0; i < iTrimCurveIArray.length; ++i) {
            iTrimCurveArray[i] = iTrimCurveIArray[i].get();
        }
        return this.addInnerTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurve[] iTrimCurveArray) {
        for (int i = 0; iTrimCurveArray != null && i < iTrimCurveArray.length; ++i) {
            iTrimCurveArray[i].surface(this);
        }
        if (!this.checkTrimLoop(iTrimCurveArray)) {
            return this;
        }
        if (this.innerTrimLoop == null) {
            this.innerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        for (int i = 0; iTrimCurveArray != null && i < iTrimCurveArray.length; ++i) {
            arrayList.add(iTrimCurveArray[i]);
        }
        this.innerTrimLoop.add(arrayList);
        this.closeInnerTrim();
        return this;
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurveI iTrimCurveI) {
        return this.addInnerTrimLoop(iTrimCurveI.get());
    }

    public ISurfaceGeo addInnerTrimLoop(ITrimCurve iTrimCurve) {
        if (iTrimCurve != null) {
            iTrimCurve.surface(this);
        }
        if (!this.checkTrimLoop(iTrimCurve)) {
            return this;
        }
        if (this.innerTrimLoop == null) {
            this.innerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        if (!iTrimCurve.isClosed()) {
            IOut.err("trim loop is not closed");
        }
        arrayList.add(iTrimCurve);
        this.innerTrimLoop.add(arrayList);
        this.closeInnerTrim();
        return this;
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI[] iCurveIArray) {
        return this.addInnerTrimLoop(iCurveIArray, true);
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI[] iCurveIArray, boolean bl) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iCurveIArray.length];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iTrimCurveArray[i] = new ITrimCurve(iCurveIArray[i]).surface(this);
            if (!bl || !(iCurveIArray[i] instanceof IObject)) continue;
            ((IObject)((Object)iCurveIArray[i])).del();
        }
        return this.addInnerTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI iCurveI) {
        return this.addInnerTrimLoop(iCurveI, true);
    }

    public ISurfaceGeo addInnerTrimLoop(ICurveI iCurveI, boolean bl) {
        if (iCurveI == null) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve iTrimCurve = new ITrimCurve(iCurveI).surface(this);
        if (bl && iCurveI instanceof IObject) {
            ((IObject)((Object)iCurveI)).del();
        }
        return this.addInnerTrimLoop(iTrimCurve);
    }

    public ISurfaceGeo addInnerTrim(ITrimCurve iTrimCurve) {
        if (iTrimCurve != null) {
            iTrimCurve.surface(this);
        }
        if (!this.checkTrim(iTrimCurve)) {
            return this;
        }
        if (this.innerTrimLoop == null) {
            this.innerTrimLoop = new ArrayList();
            this.innerTrimLoop.add(new ArrayList());
        } else if (this.innerTrimClosed) {
            this.innerTrimLoop.add(new ArrayList());
            this.innerTrimClosed = false;
        }
        this.innerTrimLoop.get(this.innerTrimLoop.size() - 1).add(iTrimCurve);
        return this;
    }

    public ISurfaceGeo closeInnerTrim() {
        this.innerTrimClosed = true;
        return this;
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurveI[] iTrimCurveIArray) {
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iTrimCurveIArray.length];
        for (int i = 0; i < iTrimCurveIArray.length; ++i) {
            iTrimCurveArray[i] = iTrimCurveIArray[i].get();
        }
        return this.addOuterTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurve[] iTrimCurveArray) {
        for (int i = 0; iTrimCurveArray != null && i < iTrimCurveArray.length; ++i) {
            iTrimCurveArray[i].surface(this);
        }
        if (!this.checkTrimLoop(iTrimCurveArray)) {
            return this;
        }
        if (this.outerTrimLoop == null) {
            this.outerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        for (int i = 0; iTrimCurveArray != null && i < iTrimCurveArray.length; ++i) {
            arrayList.add(iTrimCurveArray[i]);
        }
        this.outerTrimLoop.add(arrayList);
        this.closeOuterTrim();
        return this;
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurveI iTrimCurveI) {
        return this.addOuterTrimLoop(iTrimCurveI.get());
    }

    public ISurfaceGeo addOuterTrimLoop(ITrimCurve iTrimCurve) {
        if (iTrimCurve != null) {
            iTrimCurve.surface(this);
        }
        if (!this.checkTrimLoop(iTrimCurve)) {
            return this;
        }
        if (this.outerTrimLoop == null) {
            this.outerTrimLoop = new ArrayList();
        }
        ArrayList<ITrimCurve> arrayList = new ArrayList<ITrimCurve>();
        if (!iTrimCurve.isClosed()) {
            IOut.err("trim loop is not closed");
        }
        arrayList.add(iTrimCurve);
        this.outerTrimLoop.add(arrayList);
        this.closeOuterTrim();
        return this;
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI[] iCurveIArray) {
        return this.addOuterTrimLoop(iCurveIArray, true);
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI[] iCurveIArray, boolean bl) {
        if (iCurveIArray == null || iCurveIArray.length == 0) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve[] iTrimCurveArray = new ITrimCurve[iCurveIArray.length];
        for (int i = 0; i < iCurveIArray.length; ++i) {
            iTrimCurveArray[i] = new ITrimCurve(iCurveIArray[i]).surface(this);
            if (!bl || !(iCurveIArray[i] instanceof IObject)) continue;
            ((IObject)((Object)iCurveIArray[i])).del();
        }
        return this.addOuterTrimLoop(iTrimCurveArray);
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI iCurveI) {
        return this.addOuterTrimLoop(iCurveI, true);
    }

    public ISurfaceGeo addOuterTrimLoop(ICurveI iCurveI, boolean bl) {
        if (iCurveI == null) {
            IOut.err("no trim input");
            return this;
        }
        ITrimCurve iTrimCurve = new ITrimCurve(iCurveI).surface(this);
        if (bl && iCurveI instanceof IObject) {
            ((IObject)((Object)iCurveI)).del();
        }
        return this.addOuterTrimLoop(iTrimCurve);
    }

    public ISurfaceGeo addOuterTrim(ITrimCurve iTrimCurve) {
        if (iTrimCurve != null) {
            iTrimCurve.surface(this);
        }
        if (!this.checkTrim(iTrimCurve)) {
            return this;
        }
        if (this.outerTrimLoop == null) {
            this.outerTrimLoop = new ArrayList();
            this.outerTrimLoop.add(new ArrayList());
        } else if (this.outerTrimClosed) {
            this.outerTrimLoop.add(new ArrayList());
            this.outerTrimClosed = false;
        }
        this.outerTrimLoop.get(this.outerTrimLoop.size() - 1).add(iTrimCurve);
        return this;
    }

    public ISurfaceGeo closeOuterTrim() {
        this.outerTrimClosed = true;
        return this;
    }

    public boolean hasTrim() {
        return this.hasInnerTrim() || this.hasOuterTrim();
    }

    public boolean hasInnerTrim() {
        return this.innerTrimLoop != null && this.innerTrimLoop.size() > 0;
    }

    public boolean hasOuterTrim() {
        return this.outerTrimLoop != null && this.outerTrimLoop.size() > 0;
    }

    public boolean hasTrim(ISwitchE iSwitchE) {
        return this.hasTrim();
    }

    public boolean hasInnerTrim(ISwitchE iSwitchE) {
        return this.hasInnerTrim();
    }

    public boolean hasOuterTrim(ISwitchE iSwitchE) {
        return this.hasOuterTrim();
    }

    public IBool hasTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasTrim());
    }

    public IBool hasInnerTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasInnerTrim());
    }

    public IBool hasOuterTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasOuterTrim());
    }

    public int innerTrimLoopNum() {
        if (this.innerTrimLoop == null) {
            return 0;
        }
        return this.innerTrimLoop.size();
    }

    public int outerTrimLoopNum() {
        if (this.outerTrimLoop == null) {
            return 0;
        }
        return this.outerTrimLoop.size();
    }

    public int innerTrimLoopNum(ISwitchE iSwitchE) {
        return this.innerTrimLoopNum();
    }

    public int outerTrimLoopNum(ISwitchE iSwitchE) {
        return this.outerTrimLoopNum();
    }

    public IInteger innerTrimLoopNum(ISwitchR iSwitchR) {
        return new IInteger(this.innerTrimLoopNum());
    }

    public IInteger outerTrimLoopNum(ISwitchR iSwitchR) {
        return new IInteger(this.outerTrimLoopNum());
    }

    public int innerTrimNum(int n) {
        if (this.innerTrimLoop == null) {
            return 0;
        }
        return this.innerTrimLoop.get(n).size();
    }

    public IInteger innerTrimNum(IIntegerI iIntegerI) {
        return new IInteger(this.innerTrimNum(iIntegerI.x()));
    }

    public int outerTrimNum(int n) {
        if (this.outerTrimLoop == null) {
            return 0;
        }
        return this.outerTrimLoop.get(n).size();
    }

    public IInteger outerTrimNum(IIntegerI iIntegerI) {
        return new IInteger(this.outerTrimNum(iIntegerI.x()));
    }

    public ITrimCurveI[] innerTrimLoop(int n) {
        return this.innerTrimLoop.get(n).toArray(new ITrimCurve[this.innerTrimLoop.get(n).size()]);
    }

    public ITrimCurveI[] innerTrimLoop(IIntegerI iIntegerI) {
        return this.innerTrimLoop(iIntegerI.x());
    }

    public ITrimCurveI[] outerTrimLoop(int n) {
        return this.outerTrimLoop.get(n).toArray(new ITrimCurve[this.outerTrimLoop.get(n).size()]);
    }

    public ITrimCurveI[] outerTrimLoop(IIntegerI iIntegerI) {
        return this.outerTrimLoop(iIntegerI.x());
    }

    public ITrimCurveI innerTrim(int n, int n2) {
        return this.innerTrimLoop.get(n).get(n2);
    }

    public ITrimCurveI innerTrim(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.innerTrim(iIntegerI.x(), iIntegerI2.x());
    }

    public ITrimCurveI outerTrim(int n, int n2) {
        return this.outerTrimLoop.get(n).get(n2);
    }

    public ITrimCurveI outerTrim(IIntegerI iIntegerI, IIntegerI iIntegerI2) {
        return this.outerTrim(iIntegerI.x(), iIntegerI2.x());
    }

    public boolean hasDefaultTrim() {
        if (this.outerTrimLoopNum() != 1) {
            return false;
        }
        IVec[] iVecArray = new IVec[4];
        if (this.outerTrimLoop.get(0).size() == 4) {
            for (int i = 0; i < this.outerTrimLoop.get(0).size(); ++i) {
                if (this.outerTrimLoop.get(0).get(i).deg() != 1 || this.outerTrimLoop.get(0).get(i).num() != 2) {
                    return false;
                }
                if (!this.outerTrimLoop.get(0).get(i).cp(1).get().eq(this.outerTrimLoop.get(0).get((i + 1) % 4).cp(0))) {
                    return false;
                }
                iVecArray[i] = this.outerTrimLoop.get(0).get(i).cp(0).get();
            }
        } else if (this.outerTrimLoop.get(0).size() == 1) {
            if (this.outerTrimLoop.get(0).get(0).deg() != 1 || this.outerTrimLoop.get(0).get(0).num() != 5) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                iVecArray[i] = this.outerTrimLoop.get(0).get(0).cp(i).get();
            }
        } else {
            return false;
        }
        return IVec.isArrayEqual(iVecArray, new IVec[]{new IVec(0.0, 0.0, 0.0), new IVec(1.0, 0.0, 0.0), new IVec(1.0, 1.0, 0.0), new IVec(0.0, 1.0, 0.0)}, true, true, 0.0);
    }

    public boolean hasDefaultTrim(ISwitchE iSwitchE) {
        return this.hasDefaultTrim();
    }

    public IBool hasDefaultTrim(ISwitchR iSwitchR) {
        return new IBool(this.hasDefaultTrim());
    }

    public boolean isFlat() {
        IVec iVec = this.corner(0, 0);
        IVec iVec2 = iVec.get().getNormal(this.corner(1, 0), this.corner(0, 1));
        if (!this.corner(1, 1).get().isOnPlane(iVec2, iVec)) {
            return false;
        }
        if (this.ucpNum() == 2 && this.vcpNum() == 2) {
            return true;
        }
        for (int i = 0; i < this.ucpNum(); ++i) {
            for (int j = 0; j < this.vcpNum(); ++j) {
                if (i == 0 && (j == 0 || j == this.vcpNum() - 1) || i == this.ucpNum() - 1 && (j == 0 || j == this.vcpNum() - 1) || this.cp(i, j).get().isOnPlane(iVec2, iVec)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isFlat(ISwitchE iSwitchE) {
        return this.isFlat();
    }

    public IBool isFlat(ISwitchR iSwitchR) {
        return new IBool(this.isFlat());
    }

    public boolean isUClosed() {
        int n = this.vcpNum();
        if (this.uknots[0] != 0.0 || this.uknots[this.uknots.length - 1] != 1.0) {
            for (int i = 0; i < n; ++i) {
                if (this.cp(0, i).eq(this.cp(this.ucpNum() - this.udegree, i))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i <= n; ++i) {
            if (this.pt(0.0, (double)i / (double)n).eq(this.pt(1.0, (double)i / (double)n))) continue;
            return false;
        }
        return true;
    }

    public boolean isUClosed(ISwitchE iSwitchE) {
        return this.isUClosed();
    }

    public IBool isUClosed(ISwitchR iSwitchR) {
        return new IBool(this.isUClosed());
    }

    public boolean isVClosed() {
        int n = this.ucpNum();
        if (this.vknots[0] != 0.0 || this.vknots[this.vknots.length - 1] != 1.0) {
            for (int i = 0; i < n; ++i) {
                if (this.cp(i, 0).eq(this.cp(i, this.vcpNum() - this.vdegree))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i <= n; ++i) {
            if (this.pt((double)i / (double)n, 0.0).eq(this.pt((double)i / (double)n, 1.0))) continue;
            return false;
        }
        return true;
    }

    public boolean isVClosed(ISwitchE iSwitchE) {
        return this.isVClosed();
    }

    public IBool isVClosed(ISwitchR iSwitchR) {
        return new IBool(this.isVClosed());
    }

    public boolean isInsideTrim(IVec2I iVec2I) {
        return this.isInsideTrim(iVec2I.get());
    }

    public boolean isInsideTrim(double d, double d2) {
        return this.isInsideTrim(new IVec2(d, d2));
    }

    public boolean isInsideTrim(IVec2 iVec2) {
        if (this.trimCache == null) {
            if (!this.hasTrim()) {
                return !(iVec2.x < 0.0 || iVec2.x > 1.0 || iVec2.y < 0.0) && !(iVec2.y > 1.0);
            }
            this.trimCache = new ITrimCache(this);
        }
        return this.trimCache.isInside(iVec2);
    }

    public synchronized ISurfaceGeo updateCache() {
        this.uvSearchCache = new ISurfaceCache(this);
        return this;
    }

    public ISurfaceGeo add(double d, double d2, double d3) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.add(d, d2, d3);
            }
        }
        return this;
    }

    public ISurfaceGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.add(iDoubleI, iDoubleI2, iDoubleI3);
            }
        }
        return this;
    }

    public ISurfaceGeo add(IVecI iVecI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.add(iVecI);
            }
        }
        return this;
    }

    public ISurfaceGeo sub(double d, double d2, double d3) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.sub(d, d2, d3);
            }
        }
        return this;
    }

    public ISurfaceGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.sub(iDoubleI, iDoubleI2, iDoubleI3);
            }
        }
        return this;
    }

    public ISurfaceGeo sub(IVecI iVecI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.sub(iVecI);
            }
        }
        return this;
    }

    public ISurfaceGeo mul(IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.mul(iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo mul(double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.mul(d);
            }
        }
        return this;
    }

    public ISurfaceGeo div(IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.div(iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo div(double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.div(d);
            }
        }
        return this;
    }

    public ISurfaceGeo neg() {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.neg();
            }
        }
        return this;
    }

    public ISurfaceGeo flip() {
        return this.neg();
    }

    public ISurfaceGeo add(IVecI iVecI, double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.add(iVecI, d);
            }
        }
        return this;
    }

    public ISurfaceGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.add(iVecI, iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    public ISurfaceGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    public ISurfaceGeo rot(IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.rot(iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo rot(double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.rot(d);
            }
        }
        return this;
    }

    public ISurfaceGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.rot(iVecI, iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo rot(IVecI iVecI, double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.rot(iVecI, d);
            }
        }
        return this;
    }

    public ISurfaceGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI3 : iVecIArray2 = iVecIArray[i]) {
                iVecI3.rot(iVecI, iVecI2, iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI3 : iVecIArray2 = iVecIArray[i]) {
                iVecI3.rot(iVecI, iVecI2, d);
            }
        }
        return this;
    }

    public ISurfaceGeo rot(IVecI iVecI, IVecI iVecI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI3 : iVecIArray2 = iVecIArray[i]) {
                iVecI3.rot(iVecI, iVecI2);
            }
        }
        return this;
    }

    public ISurfaceGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI4 : iVecIArray2 = iVecIArray[i]) {
                iVecI4.rot(iVecI, iVecI2, iVecI3);
            }
        }
        return this;
    }

    public ISurfaceGeo rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    public ISurfaceGeo rot2(double d) {
        return this.rot(d);
    }

    public ISurfaceGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.rot2(iVecI, iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo rot2(IVecI iVecI, double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.rot2(iVecI, d);
            }
        }
        return this;
    }

    public ISurfaceGeo rot2(IVecI iVecI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.rot2(iVecI);
            }
        }
        return this;
    }

    public ISurfaceGeo rot2(IVecI iVecI, IVecI iVecI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI3 : iVecIArray2 = iVecIArray[i]) {
                iVecI3.rot2(iVecI, iVecI2);
            }
        }
        return this;
    }

    public ISurfaceGeo scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    public ISurfaceGeo scale(double d) {
        return this.mul(d);
    }

    public ISurfaceGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.scale(iVecI, iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo scale(IVecI iVecI, double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.scale(iVecI, d);
            }
        }
        return this;
    }

    public ISurfaceGeo scale1d(IVecI iVecI, double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.scale1d(iVecI, d);
            }
        }
        return this;
    }

    public ISurfaceGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.scale1d(iVecI, iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI3 : iVecIArray2 = iVecIArray[i]) {
                iVecI3.scale1d(iVecI, iVecI2, d);
            }
        }
        return this;
    }

    public ISurfaceGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI3 : iVecIArray2 = iVecIArray[i]) {
                iVecI3.scale1d(iVecI, iVecI2, iDoubleI);
            }
        }
        return this;
    }

    public ISurfaceGeo ref(IVecI iVecI) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.ref(iVecI);
            }
        }
        return this;
    }

    public ISurfaceGeo ref(IVecI iVecI, IVecI iVecI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI3 : iVecIArray2 = iVecIArray[i]) {
                iVecI3.ref(iVecI, iVecI2);
            }
        }
        return this;
    }

    public ISurfaceGeo mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    public ISurfaceGeo mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI2);
    }

    public ISurfaceGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shear(d, d2, d3, d4, d5, d6);
            }
        }
        return this;
    }

    public ISurfaceGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
            }
        }
        return this;
    }

    public ISurfaceGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shear(iVecI, d, d2, d3, d4, d5, d6);
            }
        }
        return this;
    }

    public ISurfaceGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
            }
        }
        return this;
    }

    public ISurfaceGeo shearXY(double d, double d2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shearXY(d, d2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shearXY(iDoubleI, iDoubleI2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearXY(IVecI iVecI, double d, double d2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shearXY(iVecI, d, d2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shearXY(iVecI, iDoubleI, iDoubleI2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearYZ(double d, double d2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shearYZ(d, d2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shearYZ(iDoubleI, iDoubleI2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearYZ(IVecI iVecI, double d, double d2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shearYZ(iVecI, d, d2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shearYZ(iVecI, iDoubleI, iDoubleI2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearZX(double d, double d2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shearZX(d, d2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.shearZX(iDoubleI, iDoubleI2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearZX(IVecI iVecI, double d, double d2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shearZX(iVecI, d, d2);
            }
        }
        return this;
    }

    public ISurfaceGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI2 : iVecIArray2 = iVecIArray[i]) {
                iVecI2.shearZX(iVecI, iDoubleI, iDoubleI2);
            }
        }
        return this;
    }

    public ISurfaceGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public ISurfaceGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public ISurfaceGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    public ISurfaceGeo cp() {
        return this.dup();
    }

    public ISurfaceGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    public ISurfaceGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public ISurfaceGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    public ISurfaceGeo translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    public ISurfaceGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public ISurfaceGeo translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    public ISurfaceGeo transform(IMatrix3I iMatrix3I) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.transform(iMatrix3I);
            }
        }
        return this;
    }

    public ISurfaceGeo transform(IMatrix4I iMatrix4I) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI : iVecIArray2 = iVecIArray[i]) {
                iVecI.transform(iMatrix4I);
            }
        }
        return this;
    }

    public ISurfaceGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI4 : iVecIArray2 = iVecIArray[i]) {
                iVecI4.transform(iVecI, iVecI2, iVecI3);
            }
        }
        return this;
    }

    public ISurfaceGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[] iVecIArray2;
            for (IVecI iVecI5 : iVecIArray2 = iVecIArray[i]) {
                iVecI5.transform(iVecI, iVecI2, iVecI3, iVecI4);
            }
        }
        return this;
    }
}

