/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import igeo.IBounds;
import igeo.IConfig;
import igeo.IG;
import igeo.IOut;
import igeo.IServer;
import igeo.IServerI;
import igeo.gui.IComponent;
import igeo.gui.IFileFilter;
import igeo.gui.IGraphics;
import igeo.gui.IKeyEvent;
import igeo.gui.IMouseEvent;
import igeo.gui.IMouseWheelEvent;
import igeo.gui.IPane;
import igeo.gui.IPanelI;
import igeo.io.IAIExporter;
import igeo.io.IIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class IPanel
extends IComponent
implements IPanelI {
    public ArrayList<IPane> panes = new ArrayList();
    public IG ig;
    public IPane currentMousePane = null;
    public Container parentContainer;
    public IBounds bounds;
    public int serverStateCount = -1;
    public boolean startDynamicServer = true;
    public boolean firstDraw = true;
    public boolean skipAutoFocus = false;
    public boolean sizeChanged = false;

    public IPanel(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    public void setIG(IG iG) {
        this.ig = iG;
    }

    @Override
    public IG getIG() {
        return this.ig;
    }

    @Override
    public IServer server() {
        return this.ig.server();
    }

    @Override
    public void setParent(Container container) {
        this.parentContainer = container;
    }

    @Override
    public void addPane(IPane iPane) {
        this.panes.add(iPane);
        iPane.setPanel(this);
    }

    @Override
    public IPane pane(int n) {
        if (this.panes == null || n < 0 || n >= this.panes.size()) {
            return null;
        }
        return this.panes.get(n);
    }

    @Override
    public int paneNum() {
        if (this.panes == null) {
            return 0;
        }
        return this.panes.size();
    }

    @Override
    public void removePane(int n) {
        this.panes.remove(n);
    }

    @Override
    public void clearPane() {
        this.panes.clear();
    }

    @Override
    public void setVisible(boolean bl) {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).setVisible(bl);
        }
    }

    @Override
    public void focus() {
        for (int i = 0; i < this.panes.size(); ++i) {
            this.panes.get(i).focus();
        }
    }

    @Override
    public void setSize(int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        for (int i = 0; i < this.panes.size(); ++i) {
            int n5 = (int)(this.panes.get(i).getX() * (float)n / (float)n3);
            int n6 = (int)(this.panes.get(i).getY() * (float)n2 / (float)n4);
            int n7 = this.panes.get(i).getWidth() * n / n3;
            int n8 = this.panes.get(i).getHeight() * n2 / n4;
            this.panes.get(i).setBounds(n5, n6, n7, n8);
        }
        this.width = n;
        this.height = n2;
        this.sizeChanged = true;
    }

    @Override
    public void startDynamicServer() {
        if (this.ig != null && this.ig.dynamicServer() != null && (this.ig.dynamicServer().num() > 0 || this.ig.dynamicServer().addingNum() > 0)) {
            if (IConfig.syncDrawAndDynamics) {
                this.ig.dynamicServer().startWithoutThread();
            } else {
                this.ig.dynamicServer().start();
            }
            this.startDynamicServer = false;
        }
    }

    public void stopDynamicServer() {
        if (this.ig != null && this.ig.dynamicServer() != null) {
            this.ig.dynamicServer().stop();
            this.startDynamicServer = false;
        }
    }

    @Override
    public void skipAutoFocus() {
        this.skipAutoFocus = true;
    }

    @Override
    public void predraw(IGraphics iGraphics) {
        if (this.firstDraw) {
            if (this.ig != null && IConfig.autoFocusAtStart && !this.skipAutoFocus) {
                this.ig.focusView();
                this.skipAutoFocus = true;
            }
            this.firstDraw = false;
        }
        if (this.startDynamicServer) {
            this.startDynamicServer();
        }
        if (this.sizeChanged) {
            this.sizeChanged = false;
            iGraphics.firstDraw(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(IGraphics iGraphics) {
        this.predraw(iGraphics);
        for (int i = 0; i < this.panes.size(); ++i) {
            Object object = IG.lock;
            synchronized (object) {
                if (this.panes.get(i).isVisible()) {
                    this.panes.get(i).draw(iGraphics);
                }
                continue;
            }
        }
        this.postdraw(iGraphics);
    }

    @Override
    public void postdraw(IGraphics iGraphics) {
        if (IConfig.deleteGraphicObjectsAfterDraw && this.ig != null && this.ig.server().graphicServer() != null) {
            this.ig.server().graphicServer().clearObjects();
        }
        if (IConfig.syncDrawAndDynamics && !this.startDynamicServer && this.ig != null && this.ig.dynamicServer() != null) {
            this.ig.dynamicServer().step();
        }
        if (iGraphics.firstDraw()) {
            iGraphics.firstDraw(false);
        }
    }

    @Override
    public IPane getPaneAt(int n, int n2) {
        for (int i = this.panes.size() - 1; i >= 0; --i) {
            if (!this.panes.get(i).isVisible() || !this.panes.get(i).contains(n, n2)) continue;
            return this.panes.get(i);
        }
        return null;
    }

    public IPane getPaneAt(IMouseEvent iMouseEvent) {
        return this.getPaneAt(iMouseEvent.getX(), iMouseEvent.getY());
    }

    @Override
    public IPane currentPane() {
        if (this.currentMousePane != null) {
            return this.currentMousePane;
        }
        return this.panes.get(0);
    }

    @Override
    public void mousePressed(IMouseEvent iMouseEvent) {
        IPane iPane = this.getPaneAt(iMouseEvent);
        if (iPane != null) {
            this.currentMousePane = iPane;
            iPane.mousePressed(iMouseEvent);
        } else {
            IOut.err("no pane");
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed(new IMouseEvent(mouseEvent));
    }

    @Override
    public void mouseReleased(IMouseEvent iMouseEvent) {
        IPane iPane = null;
        if (this.currentMousePane != null) {
            this.currentMousePane.mouseReleased(iMouseEvent);
        } else {
            iPane = this.getPaneAt(iMouseEvent);
            if (iPane != null) {
                iPane.mouseReleased(iMouseEvent);
                this.currentMousePane = iPane;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseReleased(new IMouseEvent(mouseEvent));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseClicked(new IMouseEvent(mouseEvent));
    }

    @Override
    public void mouseClicked(IMouseEvent iMouseEvent) {
        IPane iPane = this.getPaneAt(iMouseEvent);
        if (iPane != null) {
            iPane.mouseClicked(iMouseEvent);
        }
        this.currentMousePane = iPane;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseMoved(new IMouseEvent(mouseEvent));
    }

    @Override
    public void mouseMoved(IMouseEvent iMouseEvent) {
        IPane iPane = this.getPaneAt(iMouseEvent);
        if (iPane != null) {
            iPane.mouseMoved(iMouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDragged(new IMouseEvent(mouseEvent));
    }

    @Override
    public void mouseDragged(IMouseEvent iMouseEvent) {
        IPane iPane = null;
        iPane = this.currentMousePane != null ? this.currentMousePane : this.getPaneAt(iMouseEvent);
        if (iPane != null) {
            iPane.mouseDragged(iMouseEvent);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseWheelMoved(new IMouseWheelEvent(mouseWheelEvent));
    }

    @Override
    public void mouseWheelMoved(IMouseWheelEvent iMouseWheelEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.mouseWheelMoved(iMouseWheelEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyPressed(new IKeyEvent(keyEvent));
    }

    @Override
    public void keyPressed(IKeyEvent iKeyEvent) {
        int n = iKeyEvent.getKeyCode();
        boolean bl = iKeyEvent.isShiftDown();
        boolean bl2 = iKeyEvent.isControlDown();
        if (iKeyEvent.isMetaDown()) {
            bl2 = true;
        }
        if (n == 70 && !bl2) {
            this.currentMousePane.focus();
        } else if (n == 83 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, true, false);
        } else if (n == 83 && bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(false, true, false);
        } else if (n == 87 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, false, false);
        } else if (n == 84 && !bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(true, true, true);
        } else if (n == 84 && bl && !bl2) {
            this.currentMousePane.getView().mode().setDrawMode(false, true, true);
        } else if ((n == 87 || n == 81) && bl2 && !bl) {
            if (!this.ig.isOnline()) {
                this.stopDynamicServer();
                System.exit(0);
            }
        } else if (n == 83 && bl2 && !bl) {
            this.saveDialog();
        } else if (n == 10 && !bl2 && !bl) {
            if (this.ig.isDynamicsRunning()) {
                this.ig.pauseDynamics();
            } else {
                this.ig.resumeDynamics();
            }
        }
        if (this.currentMousePane != null) {
            this.currentMousePane.keyPressed(iKeyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.keyReleased(new IKeyEvent(keyEvent));
    }

    @Override
    public void keyReleased(IKeyEvent iKeyEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.keyReleased(iKeyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.keyTyped(new IKeyEvent(keyEvent));
    }

    @Override
    public void keyTyped(IKeyEvent iKeyEvent) {
        if (this.currentMousePane != null) {
            this.currentMousePane.keyTyped(iKeyEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        int n = componentEvent.getComponent().getBounds().width;
        int n2 = componentEvent.getComponent().getBounds().height;
        this.setSize(n, n2);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (!this.ig.online) {
            System.exit(0);
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public IBounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds() {
        if (this.bounds == null) {
            this.bounds = new IBounds();
        }
        if (this.ig.server().stateCount() != this.serverStateCount) {
            if (this.ig.server.objectNum() > 0) {
                this.bounds.setObjects(this.ig.server());
                if (this.bounds.min != null && this.bounds.max != null) {
                    for (int i = 0; i < this.panes.size(); ++i) {
                        this.panes.get(i).navigator().setRatioByBounds(this.bounds);
                        this.panes.get(i).getView().setParametersByBounds(this.bounds);
                    }
                }
            }
            this.serverStateCount = this.ig.server().stateCount();
        }
    }

    @Override
    public void saveDialog() {
        String[][] stringArray;
        try {
            if (this.ig.basePath != null && !(stringArray = new File(this.ig.basePath)).isDirectory()) {
                IOut.debug(20, "creating directory" + stringArray.toString());
                if (!stringArray.mkdir()) {
                    IOut.err("failed to create directory: " + stringArray.toString());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringArray = new String[][]{{"png", "PNG", "Png"}, {"ai", "Ai", "AI"}, {"obj", "Obj", "OBJ"}, {"3dm", "3DM"}, {"3dm", "3DM"}};
        String[] stringArray2 = new String[]{"Surface textures as PNG (if there's any texture) (.png)", "Adobe Illustrator file (.ai)", "Wavefront OBJ file (.obj)", "Rhinoceros 3D file version 4 (.3dm)", "Rhinoceros 3D file version 5 (.3dm)"};
        FileAndFilterIndex fileAndFilterIndex = this.chooseFile(stringArray, stringArray2, "Save", true, this.ig.basePath, null);
        if (fileAndFilterIndex != null && fileAndFilterIndex.file != null) {
            if (IIO.getFileType(fileAndFilterIndex.file.getName()) == IIO.FileType.AI) {
                new AIScaleDialog(fileAndFilterIndex.file);
                return;
            }
            if (fileAndFilterIndex.filterIndex == 0) {
                IIO.saveRhino5(fileAndFilterIndex.file, (IServerI)this.ig);
            } else if (fileAndFilterIndex.filterIndex == 1) {
                IIO.saveRhino4(fileAndFilterIndex.file, (IServerI)this.ig);
            } else if (fileAndFilterIndex.filterIndex == 2) {
                IIO.saveOBJ(fileAndFilterIndex.file, (IServerI)this.ig);
            } else if (fileAndFilterIndex.filterIndex == 3) {
                IIO.saveAI(fileAndFilterIndex.file, (IServerI)this.ig);
            } else if (fileAndFilterIndex.filterIndex == 4) {
                IIO.saveTextures(fileAndFilterIndex.file, (IServerI)this.ig);
            }
        }
    }

    public FileAndFilterIndex chooseFile(String string, String string2, String string3, boolean bl, String string4, File file) {
        return this.chooseFile(IFileFilter.createCaseVariation(string), string2, string3, bl, string4, file);
    }

    public FileAndFilterIndex chooseFile(String[] stringArray, String string, String string2, boolean bl, String string3, File file) {
        String[][] stringArray2 = new String[][]{stringArray};
        String[] stringArray3 = new String[]{string};
        return this.chooseFile(stringArray2, stringArray3, string2, bl, string3, file);
    }

    public FileAndFilterIndex chooseFile(String[][] stringArray, String[] stringArray2, String string, boolean bl, String string2, File file) {
        File file2 = null;
        boolean bl2 = false;
        int n = -1;
        file2 = file;
        IFileFilter[] iFileFilterArray = new IFileFilter[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (stringArray[i][j].startsWith(".")) continue;
                stringArray[i][j] = "." + stringArray[i][j];
            }
            String string3 = "";
            if (stringArray2 != null && stringArray2.length > i && stringArray2[i] != null) {
                string3 = stringArray2[i];
            }
            iFileFilterArray[i] = new IFileFilter(stringArray[i], string3);
        }
        do {
            int n2;
            bl2 = false;
            JFileChooser jFileChooser = string2 == null ? new JFileChooser() : new JFileChooser(string2);
            for (n2 = iFileFilterArray.length - 1; n2 >= 0; --n2) {
                jFileChooser.addChoosableFileFilter(iFileFilterArray[n2]);
            }
            jFileChooser.setFileFilter(iFileFilterArray[iFileFilterArray.length - 1]);
            if (file2 != null) {
                jFileChooser.setCurrentDirectory(new File(file2.getParent()));
                jFileChooser.setSelectedFile(file2);
            }
            if ((n2 = jFileChooser.showDialog(null, string)) == 0) {
                int n3;
                file2 = jFileChooser.getSelectedFile();
                String string4 = file2.toString();
                boolean bl3 = false;
                FileFilter fileFilter = jFileChooser.getFileFilter();
                n = -1;
                for (n3 = 0; n3 < iFileFilterArray.length && n < 0; ++n3) {
                    if (fileFilter != iFileFilterArray[n3]) continue;
                    n = n3;
                }
                for (n3 = 0; n >= 0 && n3 < stringArray[n].length && !bl3; ++n3) {
                    if (!string4.endsWith(stringArray[n][n3])) continue;
                    bl3 = true;
                }
                if (n >= 0 && !bl3) {
                    string4 = string4.concat(stringArray[n][0]);
                    file2 = new File(string4);
                }
                if (bl) {
                    String string5;
                    int n4;
                    if (!file2.exists() || (n4 = JOptionPane.showConfirmDialog(null, string5 = "file is existing\ndo you want to overwrite it?")) == 0) continue;
                    if (n4 == 1) {
                        return null;
                    }
                    if (n4 == 2) {
                        bl2 = true;
                        continue;
                    }
                    return null;
                }
                if (file2.exists()) continue;
                IOut.err("file doesn't exist " + file2.toString());
                String string6 = "file doesn't exist: " + file2.toString();
                JOptionPane.showMessageDialog(null, string6);
                bl2 = true;
                continue;
            }
            file2 = null;
        } while (bl2);
        return new FileAndFilterIndex(file2, n);
    }

    static class FileAndFilterIndex {
        File file;
        int filterIndex;

        FileAndFilterIndex(File file, int n) {
            this.file = file;
            this.filterIndex = n;
        }
    }

    public class AIScaleDialog
    extends JDialog
    implements ActionListener {
        public JTextField scalefield;
        public JCheckBox fillClosedCurveBox;
        public File file;

        public AIScaleDialog(File file) {
            Object object;
            Object object2;
            this.file = file;
            this.getContentPane().setLayout(new GridLayout(3, 3));
            boolean bl = IPanel.this.currentPane().getView().isAxonometric();
            if (bl) {
                object2 = IPanel.this.server().unit().toString().toLowerCase();
                this.getContentPane().add(new JLabel(" scale: 1 " + (String)object2 + " = "));
                object = String.valueOf(IConfig.defaultAIExportScale);
                this.scalefield = new JTextField((String)object, 12);
            } else {
                this.getContentPane().add(new JLabel(" scale: 1 pixel = "));
                object2 = String.valueOf(IConfig.defaultAIExportPixelScale);
                this.scalefield = new JTextField((String)object2, 12);
            }
            this.getContentPane().add(this.scalefield);
            if (bl) {
                this.getContentPane().add(new JLabel("inch"));
            } else {
                this.getContentPane().add(new JLabel("pt"));
            }
            this.fillClosedCurveBox = new JCheckBox("");
            this.fillClosedCurveBox.setSelected(IAIExporter.fillClosedCurve);
            this.getContentPane().add(new JLabel("fill closed curves"));
            this.getContentPane().add(this.fillClosedCurveBox);
            this.getContentPane().add(new JLabel(""));
            object2 = new JButton("OK");
            ((AbstractButton)object2).addActionListener(this);
            this.getContentPane().add((Component)object2);
            object = new JButton("Cancel");
            ((AbstractButton)object).addActionListener(this);
            this.getContentPane().add((Component)object);
            this.setTitle("Set Scale");
            this.setSize(400, 135);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("OK")) {
                IAIExporter.fillClosedCurve = this.fillClosedCurveBox.isSelected();
                String string = this.scalefield.getText();
                try {
                    double d = Double.parseDouble(string);
                    IIO.saveAI(this.file, (IServerI)IPanel.this.ig, d);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.setVisible(false);
        }
    }
}

