/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBoidI;
import igeo.IDoubleI;
import igeo.IDynamics;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IParticleGeo;
import igeo.IVec;
import igeo.IVec2I;
import igeo.IVecI;
import java.util.ArrayList;

public class IBoidGeo
extends IParticleGeo
implements IBoidI {
    public double cohesionDist = 100.0;
    public double cohesionRatio = 5.0;
    public double cohesionLimit = -1.0;
    public double separationDist = 50.0;
    public double separationRatio = 5.0;
    public double separationLimit = -1.0;
    public double alignmentDist = 20.0;
    public double alignmentRatio = 5.0;
    public double alignmentLimit = -1.0;
    IVec cohesionForce = new IVec();
    IVec separationForce = new IVec();
    IVec alignmentForce = new IVec();
    public ArrayList<Class<? extends IBoidI>> targetClasses;

    public IBoidGeo() {
        this.initBoid();
    }

    public IBoidGeo(IVecI iVecI) {
        super(iVecI);
        this.initBoid();
    }

    public IBoidGeo(IVec iVec) {
        super(iVec);
        this.initBoid();
    }

    public IBoidGeo(IVecI iVecI, IVecI iVecI2) {
        super(iVecI, iVecI2);
        this.initBoid();
    }

    public IBoidGeo(IVec iVec, IVec iVec2) {
        super(iVec, iVec2);
        this.initBoid();
    }

    public IBoidGeo(double d, double d2, double d3) {
        super(d, d2, d3);
        this.initBoid();
    }

    public IBoidGeo(double d, double d2, double d3, double d4, double d5, double d6) {
        super(d, d2, d3, d4, d5, d6);
        this.initBoid();
    }

    public IBoidGeo(IBoidGeo iBoidGeo) {
        super(iBoidGeo);
        this.cohesionDist = iBoidGeo.cohesionDist;
        this.cohesionRatio = iBoidGeo.cohesionRatio;
        this.cohesionLimit = iBoidGeo.cohesionLimit;
        this.separationDist = iBoidGeo.separationDist;
        this.separationRatio = iBoidGeo.separationRatio;
        this.separationLimit = iBoidGeo.separationLimit;
        this.alignmentDist = iBoidGeo.alignmentDist;
        this.alignmentRatio = iBoidGeo.alignmentRatio;
        this.alignmentLimit = iBoidGeo.alignmentLimit;
        this.initBoid();
    }

    public void initBoid() {
        this.cohesionForce = new IVec();
        this.separationForce = new IVec();
        this.alignmentForce = new IVec();
    }

    @Override
    public double cohDist() {
        return this.cohesionDist;
    }

    @Override
    public double cohesionDist() {
        return this.cohDist();
    }

    @Override
    public IBoidGeo cohDist(double d) {
        this.cohesionDist = d;
        return this;
    }

    @Override
    public IBoidGeo cohesionDist(double d) {
        return this.cohDist(d);
    }

    @Override
    public double cohRatio() {
        return this.cohesionRatio;
    }

    @Override
    public double cohesionRatio() {
        return this.cohRatio();
    }

    @Override
    public IBoidGeo cohRatio(double d) {
        this.cohesionRatio = d;
        return this;
    }

    @Override
    public IBoidGeo cohesionRatio(double d) {
        return this.cohRatio(d);
    }

    @Override
    public double cohLimit() {
        return this.cohesionLimit;
    }

    @Override
    public double cohesionLimit() {
        return this.cohLimit();
    }

    @Override
    public IBoidGeo cohLimit(double d) {
        this.cohesionLimit = d;
        return this;
    }

    @Override
    public IBoidGeo cohesionLimit(double d) {
        return this.cohLimit(d);
    }

    @Override
    public IBoidGeo coh(double d, double d2) {
        this.cohesionRatio = d;
        this.cohesionDist = d2;
        return this;
    }

    @Override
    public IBoidGeo cohesion(double d, double d2) {
        return this.coh(d, d2);
    }

    @Override
    public double sepDist() {
        return this.separationDist;
    }

    @Override
    public double separationDist() {
        return this.sepDist();
    }

    @Override
    public IBoidGeo sepDist(double d) {
        this.separationDist = d;
        return this;
    }

    @Override
    public IBoidGeo separationDist(double d) {
        return this.sepDist(d);
    }

    @Override
    public double sepRatio() {
        return this.separationRatio;
    }

    @Override
    public double separationRatio() {
        return this.sepRatio();
    }

    @Override
    public IBoidGeo sepRatio(double d) {
        this.separationRatio = d;
        return this;
    }

    @Override
    public IBoidGeo separationRatio(double d) {
        return this.sepRatio(d);
    }

    @Override
    public double sepLimit() {
        return this.separationLimit;
    }

    @Override
    public double separationLimit() {
        return this.sepLimit();
    }

    @Override
    public IBoidGeo sepLimit(double d) {
        this.separationLimit = d;
        return this;
    }

    @Override
    public IBoidGeo separationLimit(double d) {
        return this.sepLimit(d);
    }

    @Override
    public IBoidGeo sep(double d, double d2) {
        this.separationRatio = d;
        this.separationDist = d2;
        return this;
    }

    @Override
    public IBoidGeo separation(double d, double d2) {
        return this.sep(d, d2);
    }

    @Override
    public double aliDist() {
        return this.alignmentDist;
    }

    @Override
    public double alignmentDist() {
        return this.aliDist();
    }

    @Override
    public IBoidGeo aliDist(double d) {
        this.alignmentDist = d;
        return this;
    }

    @Override
    public IBoidGeo alignmentDist(double d) {
        return this.aliDist(d);
    }

    @Override
    public double aliRatio() {
        return this.alignmentRatio;
    }

    @Override
    public double alignmentRatio() {
        return this.aliRatio();
    }

    @Override
    public IBoidGeo aliRatio(double d) {
        this.alignmentRatio = d;
        return this;
    }

    @Override
    public IBoidGeo alignmentRatio(double d) {
        return this.aliRatio(d);
    }

    @Override
    public double aliLimit() {
        return this.alignmentLimit;
    }

    @Override
    public double alignmentLimit() {
        return this.aliLimit();
    }

    @Override
    public IBoidGeo aliLimit(double d) {
        this.alignmentLimit = d;
        return this;
    }

    @Override
    public IBoidGeo alignmentLimit(double d) {
        return this.aliLimit(d);
    }

    @Override
    public IBoidGeo ali(double d, double d2) {
        this.alignmentRatio = d;
        this.alignmentDist = d2;
        return this;
    }

    @Override
    public IBoidGeo alignment(double d, double d2) {
        return this.ali(d, d2);
    }

    @Override
    public IBoidGeo parameter(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.param(d, d2, d3, d4, d5, d6);
    }

    @Override
    public IBoidGeo param(double d, double d2, double d3, double d4, double d5, double d6) {
        this.cohesionRatio = d;
        this.cohesionDist = d2;
        this.separationRatio = d3;
        this.separationDist = d4;
        this.alignmentRatio = d5;
        this.alignmentDist = d6;
        return this;
    }

    public IBoidGeo targetClass(Class<? extends IBoidI> clazz) {
        this.targetClasses = new ArrayList();
        this.targetClasses.add(clazz);
        return this;
    }

    public IBoidGeo target(Class<? extends IBoidI> clazz) {
        return this.targetClass(clazz);
    }

    public IBoidGeo targetClass(Class<? extends IBoidI> ... classArray) {
        this.targetClasses = new ArrayList();
        for (Class<? extends IBoidI> clazz : classArray) {
            this.targetClasses.add(clazz);
        }
        return this;
    }

    public IBoidGeo target(Class<? extends IBoidI> ... classArray) {
        return this.targetClass(classArray);
    }

    public boolean isTargetClass(Object object) {
        if (this.targetClasses == null) {
            return object instanceof IBoidI;
        }
        for (int i = 0; i < this.targetClasses.size(); ++i) {
            if (!this.targetClasses.get(i).isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isTarget(Object object) {
        return this.isTargetClass(object);
    }

    @Override
    public synchronized void interact(ArrayList<IDynamics> arrayList) {
        if (this.cohesionRatio == 0.0 && this.separationRatio == 0.0 && this.alignmentRatio == 0.0 || this.cohesionDist <= 0.0 && this.separationDist <= 0.0 && this.alignmentDist <= 0.0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.cohesionForce.zero();
        this.separationForce.zero();
        this.alignmentForce.zero();
        IDynamics iDynamics = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            iDynamics = arrayList.get(i);
            if ((this.targetClasses != null || !(iDynamics instanceof IBoidI)) && (this.targetClasses == null || !this.isTargetClass(iDynamics)) || iDynamics == this || iDynamics == this.parent) continue;
            IBoidI iBoidI = (IBoidI)((Object)iDynamics);
            IVec iVec = iBoidI.pos().dif(this.pos());
            double d = iVec.len();
            if (d < this.cohesionDist) {
                this.cohesionForce.add(iVec);
                ++n;
            }
            if (d < this.separationDist) {
                if (d == 0.0) {
                    if (this.vel().len() > 0.0) {
                        this.separationForce.add(this.vel().dup().len(this.separationDist));
                    } else {
                        this.separationForce.add(new IVec(this.separationDist, 0.0, 0.0));
                    }
                } else {
                    this.separationForce.add(iVec.len(d - this.separationDist));
                }
                ++n2;
            }
            if (!(d < this.alignmentDist)) continue;
            this.alignmentForce.add(iBoidI.vel());
            ++n3;
        }
        if (n > 0) {
            this.cohesionForce.mul(this.cohesionRatio / (double)n);
            if (this.cohesionLimit >= 0.0 && this.cohesionForce.len() > this.cohesionLimit) {
                this.cohesionForce.len(this.cohesionLimit);
            }
            this.push(this.cohesionForce);
        }
        if (n2 > 0) {
            this.separationForce.mul(this.separationRatio / (double)n2);
            if (this.separationLimit >= 0.0 && this.separationForce.len() > this.separationLimit) {
                this.separationForce.len(this.separationLimit);
            }
            this.push(this.separationForce);
        }
        if (n3 > 0) {
            this.alignmentForce.div(n3).sub(this.vel()).mul(this.alignmentRatio);
            if (this.alignmentLimit >= 0.0 && this.alignmentForce.len() > this.alignmentLimit) {
                this.alignmentForce.len(this.alignmentLimit);
            }
            this.push(this.alignmentForce);
        }
    }

    @Override
    public IBoidGeo fix() {
        super.fix();
        return this;
    }

    @Override
    public IBoidGeo unfix() {
        super.unfix();
        return this;
    }

    @Override
    public IBoidGeo skipUpdateOnce(boolean bl) {
        super.skipUpdateOnce(bl);
        return this;
    }

    @Override
    public IBoidGeo mass(double d) {
        super.mass(d);
        return this;
    }

    @Override
    public IBoidGeo position(IVecI iVecI) {
        super.position(iVecI);
        return this;
    }

    @Override
    public IBoidGeo pos(IVecI iVecI) {
        super.pos(iVecI);
        return this;
    }

    @Override
    public IBoidGeo velocity(IVecI iVecI) {
        super.velocity(iVecI);
        return this;
    }

    @Override
    public IBoidGeo vel(IVecI iVecI) {
        super.vel(iVecI);
        return this;
    }

    @Override
    public IBoidGeo force(IVecI iVecI) {
        super.force(iVecI);
        return this;
    }

    @Override
    public IBoidGeo frc(IVecI iVecI) {
        super.frc(iVecI);
        return this;
    }

    @Override
    public IBoidGeo friction(double d) {
        super.friction(d);
        return this;
    }

    @Override
    public IBoidGeo fric(double d) {
        super.fric(d);
        return this;
    }

    @Override
    public IBoidGeo decay(double d) {
        return this.fric(d);
    }

    @Override
    public IBoidGeo push(IVecI iVecI) {
        super.push(iVecI);
        return this;
    }

    @Override
    public IBoidGeo push(double d, double d2, double d3) {
        super.push(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo pull(IVecI iVecI) {
        super.pull(iVecI);
        return this;
    }

    @Override
    public IBoidGeo pull(double d, double d2, double d3) {
        super.pull(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo addForce(IVecI iVecI) {
        super.addForce(iVecI);
        return this;
    }

    @Override
    public IBoidGeo addForce(double d, double d2, double d3) {
        super.addForce(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo reset() {
        super.reset();
        return this;
    }

    @Override
    public IBoidGeo resetForce() {
        super.resetForce();
        return this;
    }

    @Override
    public IBoidGeo x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IBoidGeo y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IBoidGeo z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IBoidGeo x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo x(IVecI iVecI) {
        this.pos.x(iVecI);
        return this;
    }

    @Override
    public IBoidGeo y(IVecI iVecI) {
        this.pos.y(iVecI);
        return this;
    }

    @Override
    public IBoidGeo z(IVecI iVecI) {
        this.pos.z(iVecI);
        return this;
    }

    @Override
    public IBoidGeo x(IVec2I iVec2I) {
        this.pos.x(iVec2I);
        return this;
    }

    @Override
    public IBoidGeo y(IVec2I iVec2I) {
        this.pos.y(iVec2I);
        return this;
    }

    @Override
    public IBoidGeo dup() {
        return new IBoidGeo(this);
    }

    @Override
    public IBoidGeo set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IBoidGeo set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoidGeo add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoidGeo add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IBoidGeo sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoidGeo sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IBoidGeo mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IBoidGeo div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IBoidGeo neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IBoidGeo rev() {
        return this.neg();
    }

    @Override
    public IBoidGeo flip() {
        return this.neg();
    }

    @Override
    public IBoidGeo zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IBoidGeo add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IBoidGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo add(double d, IVecI iVecI) {
        this.pos.add(d, iVecI);
        return this;
    }

    @Override
    public IBoidGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        this.pos.add(iDoubleI, iVecI);
        return this;
    }

    @Override
    public IBoidGeo len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo len(double d) {
        this.pos.len(d);
        return this;
    }

    @Override
    public IBoidGeo unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public IBoidGeo rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IBoidGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IBoidGeo rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoidGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IBoidGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IBoidGeo rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoidGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IBoidGeo rot2(double d) {
        this.pos.rot2(d);
        return this;
    }

    @Override
    public IBoidGeo rot2(IDoubleI iDoubleI) {
        this.pos.rot2(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IBoidGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IBoidGeo rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoidGeo scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IBoidGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IBoidGeo scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoidGeo scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IBoidGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IBoidGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IBoidGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IBoidGeo scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IBoidGeo ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IBoidGeo ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoidGeo ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d5, d6, d4, d5, d6);
        return this;
    }

    @Override
    public IBoidGeo mirror(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IBoidGeo mirror(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo mirror(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IBoidGeo mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoidGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoidGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IBoidGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IBoidGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IBoidGeo shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IBoidGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoidGeo shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoidGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoidGeo shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IBoidGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoidGeo shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoidGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoidGeo shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IBoidGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoidGeo shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IBoidGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IBoidGeo translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IBoidGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IBoidGeo translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IBoidGeo transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IBoidGeo transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IBoidGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IBoidGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IBoidGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IBoidGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBoidGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IBoidGeo cp() {
        return this.dup();
    }

    @Override
    public IBoidGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IBoidGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IBoidGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }
}

