/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IMap;
import java.util.ArrayList;

public class IVStripeShiftMap
extends IMap {
    public ArrayList<Double> domains;
    public ArrayList<Double> shiftAmounts;
    public IMap origMap;

    public IVStripeShiftMap(IMap iMap) {
        this.origMap = iMap;
        this.domains = new ArrayList();
        this.shiftAmounts = new ArrayList();
    }

    public IVStripeShiftMap(IMap iMap, double d) {
        this.origMap = iMap;
        this.domains = new ArrayList();
        this.shiftAmounts = new ArrayList();
        this.addShift(0.0, d);
        this.addShift(1.0, d);
    }

    public void addShift(double d, double d2) {
        this.domains.add(d);
        this.shiftAmounts.add(d2);
    }

    @Override
    public double get(double d, double d2) {
        double d3 = this.getShift(d);
        if (d2 + d3 < 0.0) {
            return this.origMap.get(d, 0.0);
        }
        if (d2 + d3 > 1.0) {
            return this.origMap.get(d, 1.0);
        }
        return this.origMap.get(d, d2 + d3);
    }

    public double getShift(double d) {
        for (int i = 0; i < this.domains.size() - 1; ++i) {
            if (i == 0 && d <= this.domains.get(i)) {
                return 0.0;
            }
            if (d >= this.domains.get(i) && d < this.domains.get(i + 1)) {
                return this.shiftAmounts.get(i);
            }
            if (i != this.domains.size() - 2 || !(d >= this.domains.get(i + 1))) continue;
            return this.shiftAmounts.get(i + 1);
        }
        return 0.0;
    }
}

