/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAttribute;
import igeo.ICurveI;
import igeo.IDoubleI;
import igeo.IEdge;
import igeo.IFace;
import igeo.IIntegerI;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IMesh;
import igeo.IMeshGeo;
import igeo.IMeshType;
import igeo.IOut;
import igeo.IServerI;
import igeo.ISurfaceI;
import igeo.ITriangleWall;
import igeo.IVec;
import igeo.IVecI;
import igeo.IVertex;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICollidableMesh
extends IMesh {
    public ArrayList<ITriangleWall> collidables;

    public ICollidableMesh() {
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI) {
        super(iServerI);
        this.initCollidable();
    }

    public ICollidableMesh(IMeshGeo iMeshGeo) {
        super(iMeshGeo);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IMeshGeo iMeshGeo) {
        super(iServerI, iMeshGeo);
        this.initCollidable();
    }

    public ICollidableMesh(IMesh iMesh) {
        super(iMesh);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IMesh iMesh) {
        super(iServerI, iMesh);
        this.initCollidable();
    }

    public ICollidableMesh(ICollidableMesh iCollidableMesh) {
        super(iCollidableMesh);
        this.initCollidable(iCollidableMesh);
    }

    public ICollidableMesh(IServerI iServerI, ICollidableMesh iCollidableMesh) {
        super(iServerI, iCollidableMesh);
        this.initCollidable(iCollidableMesh);
    }

    public ICollidableMesh(IServerI iServerI, ICurveI[] iCurveIArray) {
        super(iServerI, iCurveIArray);
        this.initCollidable();
    }

    public ICollidableMesh(ICurveI[] iCurveIArray) {
        super(iCurveIArray);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, ISurfaceI[] iSurfaceIArray) {
        super(iServerI, iSurfaceIArray);
        this.initCollidable();
    }

    public ICollidableMesh(ISurfaceI[] iSurfaceIArray) {
        super(iSurfaceIArray);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVec[][] iVecArray) {
        super(iServerI, iVecArray);
        this.initCollidable();
    }

    public ICollidableMesh(IVec[][] iVecArray) {
        super(iVecArray);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVec[][] iVecArray, boolean bl) {
        super(iServerI, iVecArray, bl);
        this.initCollidable();
    }

    public ICollidableMesh(IVec[][] iVecArray, boolean bl) {
        super(iVecArray, bl);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVec[][] iVecArray, boolean bl, IMeshType iMeshType) {
        super(iServerI, iVecArray, bl, iMeshType);
        this.initCollidable();
    }

    public ICollidableMesh(IVec[][] iVecArray, boolean bl, IMeshType iMeshType) {
        super(iVecArray, bl, iMeshType);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVec[][] iVecArray, int n, int n2, boolean bl) {
        super(iServerI, iVecArray, n, n2, bl);
        this.initCollidable();
    }

    public ICollidableMesh(IVec[][] iVecArray, int n, int n2, boolean bl) {
        super(iVecArray, n, n2, bl);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVec[][] iVecArray, int n, int n2, boolean bl, IMeshType iMeshType) {
        super(iServerI, iVecArray, n, n2, bl, iMeshType);
        this.initCollidable();
    }

    public ICollidableMesh(IVec[][] iVecArray, int n, int n2, boolean bl, IMeshType iMeshType) {
        super(iVecArray, n, n2, bl, iMeshType);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        super(iServerI, arrayList, arrayList2, arrayList3);
        this.initCollidable();
    }

    public ICollidableMesh(ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        super(arrayList, arrayList2, arrayList3);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        super(iServerI, iVertexArray, iEdgeArray, iFaceArray);
        this.initCollidable();
    }

    public ICollidableMesh(IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        super(iVertexArray, iEdgeArray, iFaceArray);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVec[] iVecArray) {
        super(iServerI, iVecArray);
        this.initCollidable();
    }

    public ICollidableMesh(IVec[] iVecArray) {
        super(iVecArray);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVertex[] iVertexArray) {
        super(iServerI, iVertexArray);
        this.initCollidable();
    }

    public ICollidableMesh(IVertex[] iVertexArray) {
        super(iVertexArray);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        super(iServerI, iVertex, iVertex2, iVertex3);
        this.initCollidable();
    }

    public ICollidableMesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        super(iVertex, iVertex2, iVertex3);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        super(iServerI, iVertex, iVertex2, iVertex3, iVertex4);
        this.initCollidable();
    }

    public ICollidableMesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        super(iVertex, iVertex2, iVertex3, iVertex4);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super(iServerI, iVecI, iVecI2, iVecI3);
        this.initCollidable();
    }

    public ICollidableMesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super(iVecI, iVecI2, iVecI3);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super(iServerI, iVecI, iVecI2, iVecI3, iVecI4);
        this.initCollidable();
    }

    public ICollidableMesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super(iVecI, iVecI2, iVecI3, iVecI4);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super(iServerI, d, d2, d3, d4, d5, d6, d7, d8, d9);
        this.initCollidable();
    }

    public ICollidableMesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super(d, d2, d3, d4, d5, d6, d7, d8, d9);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        super(iServerI, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        this.initCollidable();
    }

    public ICollidableMesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        super(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        this.initCollidable();
    }

    public ICollidableMesh(IServerI iServerI, IFace[] iFaceArray) {
        super(iServerI, iFaceArray);
        this.initCollidable();
    }

    public ICollidableMesh(IFace[] iFaceArray) {
        super(iFaceArray);
        this.initCollidable();
    }

    @Override
    public synchronized ICollidableMesh dup() {
        return new ICollidableMesh(this);
    }

    public synchronized void initCollidable() {
        this.mesh.triangulateAll(true, new IMeshType());
        this.collidables = new ArrayList();
        for (int i = 0; i < this.mesh.faceNum(); ++i) {
            IFace iFace = this.mesh.face(i);
            if (iFace.vertexNum() != 3) {
                IOut.err("mesh face is not triangulated");
            }
            this.collidables.add(new ITriangleWall(iFace.vertex(0).pos(), iFace.vertex(1).pos(), iFace.vertex(2).pos()));
        }
    }

    public synchronized void initCollidable(ICollidableMesh iCollidableMesh) {
        this.collidables = new ArrayList();
        for (int i = 0; i < this.mesh.faceNum(); ++i) {
            IFace iFace = this.mesh.face(i);
            if (iFace.vertexNum() != 3) {
                IOut.err("mesh face is not triangulated");
            }
            ITriangleWall iTriangleWall = new ITriangleWall(iFace.vertex(0).pos(), iFace.vertex(1).pos(), iFace.vertex(2).pos());
            iTriangleWall.elasticity = iCollidableMesh.collidables.get((int)i).elasticity;
            iTriangleWall.friction = iCollidableMesh.collidables.get((int)i).friction;
            if (iCollidableMesh.collidables.get((int)i).targetClasses != null) {
                iTriangleWall.targetClasses = new ArrayList();
                for (int j = 0; j < iCollidableMesh.collidables.get((int)i).targetClasses.size(); ++j) {
                    iTriangleWall.targetClasses.add(iCollidableMesh.collidables.get((int)i).targetClasses.get(j));
                }
            }
            this.collidables.add(iTriangleWall);
        }
    }

    public ICollidableMesh fric(double d) {
        for (int i = 0; i < this.collidables.size(); ++i) {
            this.collidables.get(i).fric(d);
        }
        return this;
    }

    public ICollidableMesh friction(double d) {
        return this.fric(d);
    }

    public ICollidableMesh elast(double d) {
        for (int i = 0; i < this.collidables.size(); ++i) {
            this.collidables.get(i).elast(d);
        }
        return this;
    }

    public ICollidableMesh elasticity(double d) {
        return this.elast(d);
    }

    @Override
    public synchronized ICollidableMesh addFace(IFace iFace) {
        super.addFace(iFace);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addFace(IFace iFace, boolean bl, boolean bl2, boolean bl3) {
        super.addFace(iFace, bl, bl2, bl3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addTriangles(IVertex[] iVertexArray) {
        super.addTriangles(iVertexArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addTriangles(IVec[] iVecArray) {
        super.addTriangles(iVecArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addQuads(IVertex[] iVertexArray) {
        super.addQuads(iVertexArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addQuads(IVec[] iVecArray) {
        super.addQuads(iVecArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addPolygon(IVertex[] iVertexArray) {
        super.addPolygon(iVertexArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addPolygon(IVec[] iVecArray) {
        super.addPolygon(iVecArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addTriangleStrip(IVertex[] iVertexArray) {
        super.addTriangleStrip(iVertexArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addTriangleStrip(IVec[] iVecArray) {
        super.addTriangleStrip(iVecArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addQuadStrip(IVertex[] iVertexArray) {
        super.addQuadStrip(iVertexArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addQuadStrip(IVec[] iVecArray) {
        super.addQuadStrip(iVecArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addTriangleFan(IVertex[] iVertexArray) {
        super.addTriangleFan(iVertexArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh addTriangleFan(IVec[] iVecArray) {
        super.addTriangleFan(iVecArray);
        return this;
    }

    @Override
    public synchronized ICollidableMesh name(String string) {
        super.name(string);
        return this;
    }

    @Override
    public synchronized ICollidableMesh layer(ILayer iLayer) {
        super.layer(iLayer);
        return this;
    }

    @Override
    public synchronized ICollidableMesh layer(String string) {
        super.layer(string);
        return this;
    }

    @Override
    public synchronized ICollidableMesh attr(IAttribute iAttribute) {
        super.attr(iAttribute);
        return this;
    }

    @Override
    public synchronized ICollidableMesh hide() {
        super.hide();
        return this;
    }

    @Override
    public synchronized ICollidableMesh show() {
        super.show();
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(Color color) {
        super.clr(color);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(Color color, int n) {
        super.clr(color, n);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(int n) {
        super.clr(n);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(float f) {
        super.clr(f);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(double d) {
        super.clr(d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(int n, int n2) {
        super.clr(n, n2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(float f, float f2) {
        super.clr(f, f2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(double d, double d2) {
        super.clr(d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(Color color) {
        super.setColor(color);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(Color color, int n) {
        super.setColor(color, n);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(int n) {
        super.setColor(n);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(float f) {
        super.setColor(f);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(double d) {
        super.setColor(d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(int n, int n2) {
        super.setColor(n, n2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(float f, float f2) {
        super.setColor(f, f2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(double d, double d2) {
        super.setColor(d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(int n, int n2, int n3) {
        super.setColor(n, n2, n3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(float f, float f2, float f3) {
        super.setColor(f, f2, f3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(double d, double d2, double d3) {
        super.setColor(d, d2, d3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(int n, int n2, int n3, int n4) {
        super.setColor(n, n2, n3, n4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setColor(double d, double d2, double d3, double d4) {
        super.setColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setHSBColor(float f, float f2, float f3, float f4) {
        super.setHSBColor(f, f2, f3, f4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setHSBColor(double d, double d2, double d3, double d4) {
        super.setHSBColor(d, d2, d3, d4);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setHSBColor(float f, float f2, float f3) {
        super.setHSBColor(f, f2, f3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh setHSBColor(double d, double d2, double d3) {
        super.setHSBColor(d, d2, d3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh weight(double d) {
        super.weight(d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh weight(float f) {
        super.weight(f);
        return this;
    }

    @Override
    public synchronized ICollidableMesh close() {
        this.mesh.close();
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteVertex(int n) {
        super.deleteVertex(n);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteEdge(int n) {
        super.deleteEdge(n);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteFace(int n) {
        super.deleteFace(n);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteVertex(IIntegerI iIntegerI) {
        super.deleteVertex(iIntegerI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteEdge(IIntegerI iIntegerI) {
        super.deleteEdge(iIntegerI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteFace(IIntegerI iIntegerI) {
        super.deleteFace(iIntegerI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteVertex(IVertex iVertex) {
        super.deleteVertex(iVertex);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteEdge(IEdge iEdge) {
        super.deleteEdge(iEdge);
        return this;
    }

    @Override
    public synchronized ICollidableMesh deleteFace(IFace iFace) {
        super.deleteFace(iFace);
        return this;
    }

    @Override
    public synchronized ICollidableMesh add(double d, double d2, double d3) {
        super.add(d, d2, d3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh add(IVecI iVecI) {
        super.add(iVecI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh sub(double d, double d2, double d3) {
        super.sub(d, d2, d3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh sub(IVecI iVecI) {
        super.sub(iVecI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh mul(IDoubleI iDoubleI) {
        super.mul(iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh mul(double d) {
        super.mul(d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh div(IDoubleI iDoubleI) {
        super.div(iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh div(double d) {
        super.div(d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh neg() {
        super.neg();
        return this;
    }

    @Override
    public synchronized ICollidableMesh rev() {
        return this.neg();
    }

    @Override
    public synchronized ICollidableMesh flip() {
        return this.neg();
    }

    @Override
    public synchronized ICollidableMesh add(IVecI iVecI, double d) {
        super.add(iVecI, d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh add(IVecI iVecI, IDoubleI iDoubleI) {
        super.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public synchronized ICollidableMesh add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public synchronized ICollidableMesh rot(IDoubleI iDoubleI) {
        super.rot(iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot(double d) {
        super.rot(d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot(IVecI iVecI, double d) {
        super.rot(iVecI, d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        super.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot(IVecI iVecI, IVecI iVecI2, double d) {
        super.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot(IVecI iVecI, IVecI iVecI2) {
        super.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot2(IDoubleI iDoubleI) {
        super.rot2(iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot2(double d) {
        super.rot2(d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot2(IVecI iVecI, IDoubleI iDoubleI) {
        super.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot2(IVecI iVecI, double d) {
        super.rot2(iVecI, d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot2(IVecI iVecI) {
        super.rot2(iVecI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh rot2(IVecI iVecI, IVecI iVecI2) {
        super.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public synchronized ICollidableMesh scale(double d) {
        return this.mul(d);
    }

    @Override
    public synchronized ICollidableMesh scale(IVecI iVecI, IDoubleI iDoubleI) {
        super.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh scale(IVecI iVecI, double d) {
        super.scale(iVecI, d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh scale1d(IVecI iVecI, double d) {
        super.scale1d(iVecI, d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        super.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        super.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public synchronized ICollidableMesh scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        super.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh ref(IVecI iVecI) {
        super.ref(iVecI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh ref(IVecI iVecI, IVecI iVecI2) {
        super.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public synchronized ICollidableMesh mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public synchronized ICollidableMesh shear(double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        super.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        super.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearXY(double d, double d2) {
        super.shearXY(d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearXY(IVecI iVecI, double d, double d2) {
        super.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearYZ(double d, double d2) {
        super.shearYZ(d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearYZ(IVecI iVecI, double d, double d2) {
        super.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearZX(double d, double d2) {
        super.shearZX(d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearZX(IVecI iVecI, double d, double d2) {
        super.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        super.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public synchronized ICollidableMesh mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public synchronized ICollidableMesh mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public synchronized ICollidableMesh mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public synchronized ICollidableMesh cp() {
        return this.dup();
    }

    @Override
    public synchronized ICollidableMesh cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public synchronized ICollidableMesh cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public synchronized ICollidableMesh cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public synchronized ICollidableMesh translate(double d, double d2, double d3) {
        super.translate(d, d2, d3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        super.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh translate(IVecI iVecI) {
        super.translate(iVecI);
        return this;
    }

    @Override
    public synchronized ICollidableMesh transform(IMatrix3I iMatrix3I) {
        super.transform(iMatrix3I);
        return this;
    }

    @Override
    public synchronized ICollidableMesh transform(IMatrix4I iMatrix4I) {
        super.transform(iMatrix4I);
        return this;
    }

    @Override
    public synchronized ICollidableMesh transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        super.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public synchronized ICollidableMesh transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        super.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }
}

