/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IAgent;
import igeo.IAgentTracker;
import igeo.IBool;
import igeo.IBrep;
import igeo.IColor;
import igeo.ICurve;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IGeometry;
import igeo.ILayer;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.IMesh;
import igeo.IObject;
import igeo.IPoint;
import igeo.ISurface;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVecI;

public class IPointAgent
extends IAgent
implements IVecI {
    public IVec pos;
    public IPoint point;
    public IAgentTracker tracker;

    public IPointAgent() {
        this(new IVec());
        this.show();
    }

    public IPointAgent(double d, double d2, double d3) {
        this.pos = new IVec(d, d2, d3);
        this.show();
    }

    public IPointAgent(IVec iVec) {
        this.pos = iVec;
        this.show();
    }

    public IPointAgent(IVecI iVecI) {
        this.pos = iVecI.get();
        this.show();
    }

    public IPointAgent(IPointAgent iPointAgent) {
        this.pos = iPointAgent.pos.dup();
        this.show();
    }

    public IPointAgent(IGeometry ... iGeometryArray) {
        if (iGeometryArray == null || iGeometryArray.length == 0) {
            this.pos = new IVec();
            this.show();
        } else {
            IVec iVec = new IVec();
            for (int i = 0; i < iGeometryArray.length; ++i) {
                iVec.add(iGeometryArray[i].center());
            }
            iVec.div(iGeometryArray.length);
            this.pos = iVec;
            this.show();
            this.attach(iVec, iGeometryArray);
        }
        this.point.hide();
    }

    public IPointAgent(IVecI iVecI, IGeometry ... iGeometryArray) {
        this.pos = iVecI.get();
        this.show();
        this.attach(iVecI, iGeometryArray);
        this.point.hide();
    }

    public IVec position() {
        return this.pos();
    }

    public IPointAgent position(IVecI iVecI) {
        return this.pos(iVecI);
    }

    public IVec pos() {
        return this.pos;
    }

    public IPointAgent pos(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    public IPointAgent attach(IGeometry ... iGeometryArray) {
        if (this.tracker != null) {
            this.tracker.del();
        }
        this.tracker = new IAgentTracker(this, iGeometryArray);
        return this;
    }

    public IPointAgent attach(IVecI iVecI, IGeometry ... iGeometryArray) {
        if (this.tracker != null) {
            this.tracker.del();
        }
        this.tracker = new IAgentTracker(this, iVecI, iGeometryArray);
        return this;
    }

    public int geometryNum() {
        if (this.tracker == null) {
            return 0;
        }
        return this.tracker.geometryNum();
    }

    public IGeometry geometry() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.geometry();
    }

    public IGeometry geometry(int n) {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.geometry(n);
    }

    public IGeometry[] geometries() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.geometries();
    }

    public IPoint[] points() {
        if (this.tracker == null) {
            return new IPoint[]{this.point};
        }
        IPoint[] iPointArray = this.tracker.points();
        if (iPointArray == null || iPointArray.length == 0) {
            return new IPoint[]{this.point};
        }
        return iPointArray;
    }

    public IPoint point() {
        if (this.tracker == null) {
            return this.point;
        }
        IPoint iPoint = this.tracker.point();
        if (iPoint == null) {
            return this.point;
        }
        return iPoint;
    }

    public IPoint point(int n) {
        if (this.tracker == null) {
            return this.point;
        }
        IPoint iPoint = this.tracker.point(n);
        if (iPoint == null) {
            return this.point;
        }
        return iPoint;
    }

    public int pointNum() {
        if (this.tracker == null) {
            return 1;
        }
        int n = this.tracker.pointNum();
        if (n == 0) {
            return 1;
        }
        return n;
    }

    public ICurve[] curves() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.curves();
    }

    public ICurve curve() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.curve();
    }

    public ICurve curve(int n) {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.curve(n);
    }

    public int curveNum() {
        if (this.tracker == null) {
            return 0;
        }
        return this.tracker.curveNum();
    }

    public ISurface[] surfaces() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.surfaces();
    }

    public ISurface surface() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.surface();
    }

    public ISurface surface(int n) {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.surface(n);
    }

    public int surfaceNum() {
        if (this.tracker == null) {
            return 0;
        }
        return this.tracker.surfaceNum();
    }

    public IBrep[] breps() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.breps();
    }

    public IBrep brep() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.brep();
    }

    public IBrep brep(int n) {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.brep(n);
    }

    public int brepNum() {
        if (this.tracker == null) {
            return 0;
        }
        return this.tracker.brepNum();
    }

    public IMesh[] meshes() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.meshes();
    }

    public IMesh mesh() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.mesh();
    }

    public IMesh mesh(int n) {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.mesh(n);
    }

    public int meshNum() {
        if (this.tracker == null) {
            return 0;
        }
        return this.tracker.meshNum();
    }

    @Override
    public double x() {
        return this.pos.x();
    }

    @Override
    public double y() {
        return this.pos.y();
    }

    @Override
    public double z() {
        return this.pos.z();
    }

    @Override
    public IPointAgent x(double d) {
        this.pos.x(d);
        return this;
    }

    @Override
    public IPointAgent y(double d) {
        this.pos.y(d);
        return this;
    }

    @Override
    public IPointAgent z(double d) {
        this.pos.z(d);
        return this;
    }

    @Override
    public IPointAgent x(IDoubleI iDoubleI) {
        this.pos.x(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent y(IDoubleI iDoubleI) {
        this.pos.y(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent z(IDoubleI iDoubleI) {
        this.pos.z(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent x(IVecI iVecI) {
        this.pos.x(iVecI);
        return this;
    }

    @Override
    public IPointAgent y(IVecI iVecI) {
        this.pos.y(iVecI);
        return this;
    }

    @Override
    public IPointAgent z(IVecI iVecI) {
        this.pos.z(iVecI);
        return this;
    }

    @Override
    public IPointAgent x(IVec2I iVec2I) {
        this.pos.x(iVec2I);
        return this;
    }

    @Override
    public IPointAgent y(IVec2I iVec2I) {
        this.pos.y(iVec2I);
        return this;
    }

    @Override
    public double x(ISwitchE iSwitchE) {
        return this.pos.x(iSwitchE);
    }

    @Override
    public double y(ISwitchE iSwitchE) {
        return this.pos.y(iSwitchE);
    }

    @Override
    public double z(ISwitchE iSwitchE) {
        return this.pos.z(iSwitchE);
    }

    @Override
    public IDouble x(ISwitchR iSwitchR) {
        return this.pos.x(iSwitchR);
    }

    @Override
    public IDouble y(ISwitchR iSwitchR) {
        return this.pos.y(iSwitchR);
    }

    @Override
    public IDouble z(ISwitchR iSwitchR) {
        return this.pos.z(iSwitchR);
    }

    @Override
    public IVec get() {
        return this.pos.get();
    }

    @Override
    public IPointAgent dup() {
        return new IPointAgent(this);
    }

    @Override
    public IVec2 to2d() {
        return this.pos.to2d();
    }

    @Override
    public IVec2 to2d(IVecI iVecI) {
        return this.pos.to2d(iVecI);
    }

    @Override
    public IVec2 to2d(IVecI iVecI, IVecI iVecI2) {
        return this.pos.to2d(iVecI, iVecI2);
    }

    @Override
    public IVec2 to2d(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.pos.to2d(iVecI, iVecI2, iVecI3);
    }

    @Override
    public IVec4 to4d() {
        return this.pos.to4d();
    }

    @Override
    public IVec4 to4d(double d) {
        return this.pos.to4d(d);
    }

    @Override
    public IVec4 to4d(IDoubleI iDoubleI) {
        return this.pos.to4d(iDoubleI);
    }

    @Override
    public IDouble getX() {
        return this.pos.getX();
    }

    @Override
    public IDouble getY() {
        return this.pos.getY();
    }

    @Override
    public IDouble getZ() {
        return this.pos.getZ();
    }

    @Override
    public IPointAgent set(IVecI iVecI) {
        this.pos.set(iVecI);
        return this;
    }

    @Override
    public IPointAgent set(double d, double d2, double d3) {
        this.pos.set(d, d2, d3);
        return this;
    }

    @Override
    public IPointAgent set(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.set(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IPointAgent add(double d, double d2, double d3) {
        this.pos.add(d, d2, d3);
        return this;
    }

    @Override
    public IPointAgent add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.add(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IPointAgent add(IVecI iVecI) {
        this.pos.add(iVecI);
        return this;
    }

    @Override
    public IPointAgent sub(double d, double d2, double d3) {
        this.pos.sub(d, d2, d3);
        return this;
    }

    @Override
    public IPointAgent sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.sub(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IPointAgent sub(IVecI iVecI) {
        this.pos.sub(iVecI);
        return this;
    }

    @Override
    public IPointAgent mul(IDoubleI iDoubleI) {
        this.pos.mul(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent mul(double d) {
        this.pos.mul(d);
        return this;
    }

    @Override
    public IPointAgent div(IDoubleI iDoubleI) {
        this.pos.div(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent div(double d) {
        this.pos.div(d);
        return this;
    }

    @Override
    public IPointAgent neg() {
        this.pos.neg();
        return this;
    }

    @Override
    public IPointAgent rev() {
        return this.neg();
    }

    @Override
    public IPointAgent flip() {
        return this.neg();
    }

    @Override
    public IPointAgent zero() {
        this.pos.zero();
        return this;
    }

    @Override
    public IPointAgent add(IVecI iVecI, double d) {
        this.pos.add(iVecI, d);
        return this;
    }

    @Override
    public IPointAgent add(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.add(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IPointAgent add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IPointAgent add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public double dot(IVecI iVecI) {
        return this.pos.dot(iVecI);
    }

    @Override
    public double dot(double d, double d2, double d3) {
        return this.pos.dot(d, d2, d3);
    }

    @Override
    public double dot(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dot(iSwitchE, iVecI);
    }

    @Override
    public IDouble dot(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dot(iSwitchR, iVecI);
    }

    @Override
    public IVec cross(IVecI iVecI) {
        return this.pos.cross(iVecI);
    }

    @Override
    public IVec cross(double d, double d2, double d3) {
        return this.pos.cross(d, d2, d3);
    }

    @Override
    public double len() {
        return this.pos.len();
    }

    @Override
    public double len(ISwitchE iSwitchE) {
        return this.pos.len(iSwitchE);
    }

    @Override
    public IDouble len(ISwitchR iSwitchR) {
        return this.pos.len(iSwitchR);
    }

    @Override
    public double len2() {
        return this.pos.len2();
    }

    @Override
    public double len2(ISwitchE iSwitchE) {
        return this.pos.len2(iSwitchE);
    }

    @Override
    public IDouble len2(ISwitchR iSwitchR) {
        return this.pos.len2(iSwitchR);
    }

    @Override
    public IPointAgent len(IDoubleI iDoubleI) {
        this.pos.len(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent len(double d) {
        this.pos.len(d);
        return this;
    }

    @Override
    public IPointAgent unit() {
        this.pos.unit();
        return this;
    }

    @Override
    public double dist(IVecI iVecI) {
        return this.pos.dist(iVecI);
    }

    @Override
    public double dist(double d, double d2, double d3) {
        return this.pos.dist(d, d2, d3);
    }

    @Override
    public double dist(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist(iSwitchE, iVecI);
    }

    @Override
    public IDouble dist(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist(iSwitchR, iVecI);
    }

    @Override
    public double dist2(IVecI iVecI) {
        return this.pos.dist2(iVecI);
    }

    @Override
    public double dist2(double d, double d2, double d3) {
        return this.pos.dist2(d, d2, d3);
    }

    @Override
    public double dist2(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.dist2(iSwitchE, iVecI);
    }

    @Override
    public IDouble dist2(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.dist2(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI) {
        return this.pos.eq(iVecI);
    }

    @Override
    public boolean eq(double d, double d2, double d3) {
        return this.pos.eq(d, d2, d3);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eq(iSwitchE, iVecI);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eq(iSwitchR, iVecI);
    }

    @Override
    public boolean eq(IVecI iVecI, double d) {
        return this.pos.eq(iVecI, d);
    }

    @Override
    public boolean eq(double d, double d2, double d3, double d4) {
        return this.pos.eq(d, d2, d3, d4);
    }

    @Override
    public boolean eq(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eq(iSwitchE, iVecI, d);
    }

    @Override
    public IBool eq(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eq(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public boolean eqX(IVecI iVecI) {
        return this.pos.eqX(iVecI);
    }

    @Override
    public boolean eqY(IVecI iVecI) {
        return this.pos.eqY(iVecI);
    }

    @Override
    public boolean eqZ(IVecI iVecI) {
        return this.pos.eqZ(iVecI);
    }

    @Override
    public boolean eqX(double d) {
        return this.pos.eqX(d);
    }

    @Override
    public boolean eqY(double d) {
        return this.pos.eqY(d);
    }

    @Override
    public boolean eqZ(double d) {
        return this.pos.eqZ(d);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqX(iSwitchE, iVecI);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqY(iSwitchE, iVecI);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.eqZ(iSwitchE, iVecI);
    }

    @Override
    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqX(iSwitchR, iVecI);
    }

    @Override
    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqY(iSwitchR, iVecI);
    }

    @Override
    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.eqZ(iSwitchR, iVecI);
    }

    @Override
    public boolean eqX(IVecI iVecI, double d) {
        return this.pos.eqX(iVecI, d);
    }

    @Override
    public boolean eqY(IVecI iVecI, double d) {
        return this.pos.eqY(iVecI, d);
    }

    @Override
    public boolean eqZ(IVecI iVecI, double d) {
        return this.pos.eqZ(iVecI, d);
    }

    @Override
    public boolean eqX(double d, double d2) {
        return this.pos.eqX(d, d2);
    }

    @Override
    public boolean eqY(double d, double d2) {
        return this.pos.eqY(d, d2);
    }

    @Override
    public boolean eqZ(double d, double d2) {
        return this.pos.eqZ(d, d2);
    }

    @Override
    public boolean eqX(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqX(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqY(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqY(iSwitchE, iVecI, d);
    }

    @Override
    public boolean eqZ(ISwitchE iSwitchE, IVecI iVecI, double d) {
        return this.pos.eqZ(iSwitchE, iVecI, d);
    }

    @Override
    public IBool eqX(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqX(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBool eqY(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqY(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public IBool eqZ(ISwitchR iSwitchR, IVecI iVecI, IDoubleI iDoubleI) {
        return this.pos.eqZ(iSwitchR, iVecI, iDoubleI);
    }

    @Override
    public double angle(IVecI iVecI) {
        return this.pos.angle(iVecI);
    }

    @Override
    public double angle(double d, double d2, double d3) {
        return this.pos.angle(d, d2, d3);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI) {
        return this.pos.angle(iSwitchE, iVecI);
    }

    @Override
    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI) {
        return this.pos.angle(iSwitchR, iVecI);
    }

    @Override
    public double angle(IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iVecI, iVecI2);
    }

    @Override
    public double angle(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.angle(d, d2, d3, d4, d5, d6);
    }

    @Override
    public double angle(ISwitchE iSwitchE, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchE, iVecI, iVecI2);
    }

    @Override
    public IDouble angle(ISwitchR iSwitchR, IVecI iVecI, IVecI iVecI2) {
        return this.pos.angle(iSwitchR, iVecI, iVecI2);
    }

    @Override
    public IPointAgent rot(IDoubleI iDoubleI) {
        this.pos.rot(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent rot(double d) {
        this.pos.rot(d);
        return this;
    }

    @Override
    public IPointAgent rot(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IPointAgent rot(IVecI iVecI, double d) {
        this.pos.rot(iVecI, d);
        return this;
    }

    @Override
    public IPointAgent rot(double d, double d2, double d3, double d4) {
        this.pos.rot(d, d2, d3, d4);
        return this;
    }

    @Override
    public IPointAgent rot(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.rot(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IPointAgent rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.rot(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IPointAgent rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.rot(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IPointAgent rot(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot(iVecI, iVecI2);
        return this;
    }

    @Override
    public IPointAgent rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.rot(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IPointAgent rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IPointAgent rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IPointAgent rot2(IVecI iVecI, double d) {
        this.pos.rot2(iVecI, d);
        return this;
    }

    @Override
    public IPointAgent rot2(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.rot2(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IPointAgent rot2(double d, double d2, double d3) {
        this.pos.rot2(d, d2, d3);
        return this;
    }

    @Override
    public IPointAgent rot2(IVecI iVecI) {
        this.pos.rot2(iVecI);
        return this;
    }

    @Override
    public IPointAgent rot2(IVecI iVecI, IVecI iVecI2) {
        this.pos.rot2(iVecI, iVecI2);
        return this;
    }

    @Override
    public IPointAgent scale(IDoubleI iDoubleI) {
        this.pos.scale(iDoubleI);
        return this;
    }

    @Override
    public IPointAgent scale(double d) {
        this.pos.scale(d);
        return this;
    }

    @Override
    public IPointAgent scale(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IPointAgent scale(IVecI iVecI, double d) {
        this.pos.scale(iVecI, d);
        return this;
    }

    @Override
    public IPointAgent scale(double d, double d2, double d3, double d4) {
        this.pos.scale(d, d2, d3, d4);
        return this;
    }

    @Override
    public IPointAgent scale1d(IVecI iVecI, double d) {
        this.pos.scale1d(iVecI, d);
        return this;
    }

    @Override
    public IPointAgent scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iDoubleI);
        return this;
    }

    @Override
    public IPointAgent scale1d(double d, double d2, double d3, double d4) {
        this.pos.scale1d(d, d2, d3, d4);
        return this;
    }

    @Override
    public IPointAgent scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        this.pos.scale1d(iVecI, iVecI2, d);
        return this;
    }

    @Override
    public IPointAgent scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this.pos.scale1d(iVecI, iVecI2, iDoubleI);
        return this;
    }

    @Override
    public IPointAgent scale1d(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.pos.scale1d(d, d2, d3, d4, d5, d6, d7);
        return this;
    }

    @Override
    public IPointAgent ref(IVecI iVecI) {
        this.pos.ref(iVecI);
        return this;
    }

    @Override
    public IPointAgent ref(double d, double d2, double d3) {
        this.pos.ref(d, d2, d3);
        return this;
    }

    @Override
    public IPointAgent ref(IVecI iVecI, IVecI iVecI2) {
        this.pos.ref(iVecI, iVecI2);
        return this;
    }

    @Override
    public IPointAgent ref(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.ref(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IPointAgent mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public IPointAgent mirror(double d, double d2, double d3) {
        return this.ref(d, d2, d3);
    }

    @Override
    public IPointAgent mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI, iVecI2);
    }

    @Override
    public IPointAgent mirror(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.ref(d, d2, d3, d4, d5, d6);
    }

    @Override
    public IPointAgent shear(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IPointAgent shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IPointAgent shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        this.pos.shear(iVecI, d, d2, d3, d4, d5, d6);
        return this;
    }

    @Override
    public IPointAgent shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        this.pos.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
        return this;
    }

    @Override
    public IPointAgent shearXY(double d, double d2) {
        this.pos.shearXY(d, d2);
        return this;
    }

    @Override
    public IPointAgent shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IPointAgent shearXY(IVecI iVecI, double d, double d2) {
        this.pos.shearXY(iVecI, d, d2);
        return this;
    }

    @Override
    public IPointAgent shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearXY(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IPointAgent shearYZ(double d, double d2) {
        this.pos.shearYZ(d, d2);
        return this;
    }

    @Override
    public IPointAgent shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IPointAgent shearYZ(IVecI iVecI, double d, double d2) {
        this.pos.shearYZ(iVecI, d, d2);
        return this;
    }

    @Override
    public IPointAgent shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearYZ(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IPointAgent shearZX(double d, double d2) {
        this.pos.shearZX(d, d2);
        return this;
    }

    @Override
    public IPointAgent shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IPointAgent shearZX(IVecI iVecI, double d, double d2) {
        this.pos.shearZX(iVecI, d, d2);
        return this;
    }

    @Override
    public IPointAgent shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this.pos.shearZX(iVecI, iDoubleI, iDoubleI2);
        return this;
    }

    @Override
    public IPointAgent translate(double d, double d2, double d3) {
        this.pos.translate(d, d2, d3);
        return this;
    }

    @Override
    public IPointAgent translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        this.pos.translate(iDoubleI, iDoubleI2, iDoubleI3);
        return this;
    }

    @Override
    public IPointAgent translate(IVecI iVecI) {
        this.pos.translate(iVecI);
        return this;
    }

    @Override
    public IPointAgent transform(IMatrix3I iMatrix3I) {
        this.pos.transform(iMatrix3I);
        return this;
    }

    @Override
    public IPointAgent transform(IMatrix4I iMatrix4I) {
        this.pos.transform(iMatrix4I);
        return this;
    }

    @Override
    public IPointAgent transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this.pos.transform(iVecI, iVecI2, iVecI3);
        return this;
    }

    @Override
    public IPointAgent transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        this.pos.transform(iVecI, iVecI2, iVecI3, iVecI4);
        return this;
    }

    @Override
    public IPointAgent mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IPointAgent mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IPointAgent mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IPointAgent cp() {
        return this.dup();
    }

    @Override
    public IPointAgent cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IPointAgent cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IPointAgent cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVec dif(IVecI iVecI) {
        return this.pos.dif(iVecI);
    }

    @Override
    public IVec dif(double d, double d2, double d3) {
        return this.pos.dif(d, d2, d3);
    }

    @Override
    public IVec diff(IVecI iVecI) {
        return this.dif(iVecI);
    }

    @Override
    public IVec diff(double d, double d2, double d3) {
        return this.dif(d, d2, d3);
    }

    @Override
    public IVec mid(IVecI iVecI) {
        return this.pos.mid(iVecI);
    }

    @Override
    public IVec mid(double d, double d2, double d3) {
        return this.pos.mid(d, d2, d3);
    }

    @Override
    public IVec sum(IVecI iVecI) {
        return this.pos.sum(iVecI);
    }

    @Override
    public IVec sum(double d, double d2, double d3) {
        return this.pos.sum(d, d2, d3);
    }

    @Override
    public IVec sum(IVecI ... iVecIArray) {
        return this.pos.sum(iVecIArray);
    }

    @Override
    public IVec bisect(IVecI iVecI) {
        return this.pos.bisect(iVecI);
    }

    @Override
    public IVec bisect(double d, double d2, double d3) {
        return this.pos.bisect(d, d2, d3);
    }

    @Override
    public IVec sum(IVecI iVecI, double d, double d2) {
        return this.pos.sum(iVecI, d, d2);
    }

    @Override
    public IVec sum(IVecI iVecI, double d) {
        return this.pos.sum(iVecI, d);
    }

    @Override
    public IVec sum(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return this.sum(iVecI, iDoubleI, iDoubleI2);
    }

    @Override
    public IVec sum(IVecI iVecI, IDoubleI iDoubleI) {
        return this.sum(iVecI, iDoubleI);
    }

    @Override
    public IVec nml(IVecI iVecI) {
        return this.pos.nml(iVecI);
    }

    @Override
    public IVec nml(double d, double d2, double d3) {
        return this.pos.nml(d, d2, d3);
    }

    @Override
    public IVec nml(IVecI iVecI, IVecI iVecI2) {
        return this.pos.nml(iVecI, iVecI2);
    }

    @Override
    public IVec nml(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.pos.nml(d, d2, d3, d4, d5, d6);
    }

    @Override
    public boolean isValid() {
        if (this.pos == null) {
            return false;
        }
        return this.pos.isValid();
    }

    public String toString() {
        if (this.pos == null) {
            return super.toString();
        }
        return this.pos.toString();
    }

    public IPointAgent setSize(double d) {
        return this.size(d);
    }

    public IPointAgent size(double d) {
        this.point.size(d);
        return this;
    }

    public double getSize() {
        return this.point.size();
    }

    public double size() {
        return this.point.size();
    }

    @Override
    public IPointAgent name(String string) {
        super.name(string);
        this.point.name(string);
        return this;
    }

    @Override
    public IPointAgent layer(ILayer iLayer) {
        super.layer(iLayer);
        this.point.layer(iLayer);
        return this;
    }

    @Override
    public IPointAgent show() {
        if (this.point == null) {
            this.point = new IPoint(this.pos).clr(super.clr());
        } else {
            this.point.show();
        }
        if (this.tracker != null) {
            this.tracker.show();
        }
        super.show();
        return this;
    }

    @Override
    public IPointAgent hide() {
        if (this.point != null) {
            this.point.hide();
        }
        if (this.tracker != null) {
            this.tracker.hide();
        }
        super.hide();
        return this;
    }

    public IPointAgent showPoint() {
        if (this.point == null) {
            this.point = new IPoint(this.pos).clr(super.clr());
        } else {
            this.point.show();
        }
        super.show();
        return this;
    }

    public IPointAgent hidePoint() {
        if (this.point != null) {
            this.point.hide();
        }
        return this;
    }

    public IPointAgent showGeometry() {
        if (this.tracker != null) {
            this.tracker.show();
        }
        return this;
    }

    public IPointAgent hideGeometry() {
        if (this.tracker != null) {
            this.tracker.hide();
        }
        return this;
    }

    @Override
    public void del() {
        if (this.tracker != null) {
            this.tracker.del();
        }
        this.point.del();
        super.del();
    }

    @Override
    public void del(boolean bl) {
        if (bl) {
            if (this.tracker != null) {
                this.tracker.del();
            }
            this.point.del();
        }
        super.del();
    }

    @Override
    public IPointAgent clr(IColor iColor) {
        super.clr(iColor);
        this.point.clr(iColor);
        if (this.tracker != null) {
            this.tracker.clr(iColor);
        }
        return this;
    }

    @Override
    public IPointAgent clr(IColor iColor, int n) {
        super.clr(iColor, n);
        this.point.clr(iColor, n);
        if (this.tracker != null) {
            this.tracker.clr(iColor, n);
        }
        return this;
    }

    @Override
    public IPointAgent clr(IColor iColor, float f) {
        super.clr(iColor, f);
        this.point.clr(iColor, f);
        if (this.tracker != null) {
            this.tracker.clr(iColor, f);
        }
        return this;
    }

    @Override
    public IPointAgent clr(IColor iColor, double d) {
        super.clr(iColor, d);
        this.point.clr(iColor, d);
        if (this.tracker != null) {
            this.tracker.clr(iColor, d);
        }
        return this;
    }

    @Override
    public IPointAgent clr(IObject iObject) {
        super.clr(iObject);
        return this;
    }

    @Override
    public IPointAgent clr(int n) {
        super.clr(n);
        this.point.clr(n);
        if (this.tracker != null) {
            this.tracker.clr(n);
        }
        return this;
    }

    @Override
    public IPointAgent clr(float f) {
        super.clr(f);
        this.point.clr(f);
        if (this.tracker != null) {
            this.tracker.clr(f);
        }
        return this;
    }

    @Override
    public IPointAgent clr(double d) {
        super.clr(d);
        this.point.clr(d);
        if (this.tracker != null) {
            this.tracker.clr(d);
        }
        return this;
    }

    @Override
    public IPointAgent clr(int n, int n2) {
        super.clr(n, n2);
        this.point.clr(n, n2);
        if (this.tracker != null) {
            this.tracker.clr(n, n2);
        }
        return this;
    }

    @Override
    public IPointAgent clr(float f, float f2) {
        super.clr(f, f2);
        this.point.clr(f, f2);
        if (this.tracker != null) {
            this.tracker.clr(f, f2);
        }
        return this;
    }

    @Override
    public IPointAgent clr(double d, double d2) {
        super.clr(d, d2);
        this.point.clr(d, d2);
        if (this.tracker != null) {
            this.tracker.clr(d, d2);
        }
        return this;
    }

    @Override
    public IPointAgent clr(int n, int n2, int n3) {
        super.clr(n, n2, n3);
        this.point.clr(n, n2, n3);
        if (this.tracker != null) {
            this.tracker.clr(n, n2, n3);
        }
        return this;
    }

    @Override
    public IPointAgent clr(float f, float f2, float f3) {
        super.clr(f, f2, f3);
        this.point.clr(f, f2, f3);
        if (this.tracker != null) {
            this.tracker.clr(f, f2, f3);
        }
        return this;
    }

    @Override
    public IPointAgent clr(double d, double d2, double d3) {
        super.clr(d, d2, d3);
        this.point.clr(d, d2, d3);
        if (this.tracker != null) {
            this.tracker.clr(d, d2, d3);
        }
        return this;
    }

    @Override
    public IPointAgent clr(int n, int n2, int n3, int n4) {
        super.clr(n, n2, n3, n4);
        this.point.clr(n, n2, n3, n4);
        if (this.tracker != null) {
            this.tracker.clr(n, n2, n3, n4);
        }
        return this;
    }

    @Override
    public IPointAgent clr(float f, float f2, float f3, float f4) {
        super.clr(f, f2, f3, f4);
        this.point.clr(f, f2, f3, f4);
        if (this.tracker != null) {
            this.tracker.clr(f, f2, f3, f4);
        }
        return this;
    }

    @Override
    public IPointAgent clr(double d, double d2, double d3, double d4) {
        super.clr(d, d2, d3, d4);
        this.point.clr(d, d2, d3, d4);
        if (this.tracker != null) {
            this.tracker.clr(d, d2, d3, d4);
        }
        return this;
    }

    @Override
    public IPointAgent hsb(float f, float f2, float f3, float f4) {
        super.hsb(f, f2, f3, f4);
        this.point.hsb(f, f2, f3, f4);
        if (this.tracker != null) {
            this.tracker.hsb(f, f2, f3, f4);
        }
        return this;
    }

    @Override
    public IPointAgent hsb(double d, double d2, double d3, double d4) {
        super.hsb(d, d2, d3, d4);
        this.point.hsb(d, d2, d3, d4);
        if (this.tracker != null) {
            this.tracker.hsb(d, d2, d3, d4);
        }
        return this;
    }

    @Override
    public IPointAgent hsb(float f, float f2, float f3) {
        super.hsb(f, f2, f3);
        this.point.hsb(f, f2, f3);
        if (this.tracker != null) {
            this.tracker.clr(f, f2, f3);
        }
        return this;
    }

    @Override
    public IPointAgent hsb(double d, double d2, double d3) {
        super.hsb(d, d2, d3);
        this.point.hsb(d, d2, d3);
        if (this.tracker != null) {
            this.tracker.clr(d, d2, d3);
        }
        return this;
    }

    @Override
    public IPointAgent setColor(IColor iColor) {
        return this.clr(iColor);
    }

    @Override
    public IPointAgent setColor(IColor iColor, int n) {
        return this.clr(iColor, n);
    }

    @Override
    public IPointAgent setColor(IColor iColor, float f) {
        return this.clr(iColor, f);
    }

    @Override
    public IPointAgent setColor(IColor iColor, double d) {
        return this.clr(iColor, d);
    }

    @Override
    public IPointAgent setColor(int n) {
        return this.clr(n);
    }

    @Override
    public IPointAgent setColor(float f) {
        return this.clr(f);
    }

    @Override
    public IPointAgent setColor(double d) {
        return this.clr(d);
    }

    @Override
    public IPointAgent setColor(int n, int n2) {
        return this.clr(n, n2);
    }

    @Override
    public IPointAgent setColor(float f, float f2) {
        return this.clr(f, f2);
    }

    @Override
    public IPointAgent setColor(double d, double d2) {
        return this.clr(d, d2);
    }

    @Override
    public IPointAgent setColor(int n, int n2, int n3) {
        return this.clr(n, n2, n3);
    }

    @Override
    public IPointAgent setColor(float f, float f2, float f3) {
        return this.clr(f, f2, f3);
    }

    @Override
    public IPointAgent setColor(double d, double d2, double d3) {
        return this.clr(d, d2, d3);
    }

    @Override
    public IPointAgent setColor(int n, int n2, int n3, int n4) {
        return this.clr(n, n2, n3, n4);
    }

    @Override
    public IPointAgent setColor(float f, float f2, float f3, float f4) {
        return this.clr(f, f2, f3, f4);
    }

    @Override
    public IPointAgent setColor(double d, double d2, double d3, double d4) {
        return this.clr(d, d2, d3, d4);
    }

    @Override
    public IPointAgent setHSBColor(float f, float f2, float f3, float f4) {
        return this.hsb(f, f2, f3, f4);
    }

    @Override
    public IPointAgent setHSBColor(double d, double d2, double d3, double d4) {
        return this.hsb(d, d2, d3, d4);
    }

    @Override
    public IPointAgent setHSBColor(float f, float f2, float f3) {
        return this.hsb(f, f2, f3);
    }

    @Override
    public IPointAgent setHSBColor(double d, double d2, double d3) {
        return this.hsb(d, d2, d3);
    }

    @Override
    public IPointAgent weight(double d) {
        super.weight(d);
        this.point.weight(d);
        return this;
    }

    @Override
    public IPointAgent weight(float f) {
        super.weight(f);
        this.point.weight(f);
        return this;
    }
}

