/*
 * Decompiled with CFR 0.152.
 */
package igeo.gui;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import igeo.IG;
import igeo.IOut;
import igeo.gui.ITextureGraphicGL;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.opengl.GL;
import javax.media.opengl.GLProfile;

public class ITextureGraphicGL2
implements ITextureGraphicGL {
    public Texture texture;
    public int textureID;
    public GL gl;

    public ITextureGraphicGL2(String string) {
        this.init(string, null);
    }

    public ITextureGraphicGL2(String string, GL gL) {
        this.init(string, gL);
    }

    public ITextureGraphicGL2(BufferedImage bufferedImage, GL gL) {
        this.init(bufferedImage, gL);
    }

    @Override
    public void init(String string, GL gL) {
        if (this.texture != null && gL != null) {
            this.texture.destroy(gL);
        }
        this.texture = ITextureGraphicGL2.getTexture(string);
        if (this.texture != null) {
            this.textureID = this.texture.getTextureObject();
        }
        this.gl = gL;
    }

    @Override
    public void init(BufferedImage bufferedImage, GL gL) {
        if (this.texture != null) {
            this.texture.destroy(gL);
        }
        this.texture = ITextureGraphicGL2.getTexture(bufferedImage, gL);
        if (this.texture != null) {
            this.textureID = this.texture.getTextureObject();
        }
        this.gl = gL;
    }

    @Override
    public int id() {
        return this.textureID;
    }

    public static Texture getTexture(BufferedImage bufferedImage, GL gL) {
        try {
            return AWTTextureIO.newTexture((GLProfile)gL.getGLProfile(), (BufferedImage)bufferedImage, (boolean)true);
        }
        catch (Exception exception) {
            IG.err("error generating texture");
            exception.printStackTrace();
            return null;
        }
    }

    public static Texture getTexture(String string) {
        IG iG = IG.cur();
        if (iG != null) {
            String string2 = null;
            int n = string.lastIndexOf(".");
            if (n >= 0) {
                string2 = string.substring(n + 1);
            }
            InputStream inputStream = null;
            try {
                inputStream = iG.inputWrapper != null ? iG.inputWrapper.getStream(string) : new FileInputStream(string);
                if (inputStream != null) {
                    return TextureIO.newTexture((InputStream)inputStream, (boolean)true, (String)string2);
                }
                IOut.err("input stream could not be instantiated");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            IOut.err("no IG instance found");
        }
        return null;
    }

    @Override
    public int width() {
        return this.texture.getWidth();
    }

    @Override
    public int height() {
        return this.texture.getHeight();
    }

    @Override
    public void destroy(GL gL) {
        if (this.texture != null) {
            this.texture.destroy(gL);
        }
        this.gl = gL;
    }

    @Override
    public void destroy() {
        if (this.texture != null && this.gl != null) {
            this.texture.destroy(this.gl);
        }
    }
}

