/*
 * Decompiled with CFR 0.152.
 */
package igeo.io;

import igeo.ICurve;
import igeo.IEdge;
import igeo.IFace;
import igeo.IG;
import igeo.IMesh;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IServerI;
import igeo.ISurface;
import igeo.ITrimCurve;
import igeo.IVec;
import igeo.IVec4;
import igeo.IVecI;
import igeo.IVertex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class IObjFileImporter {
    public static final boolean ignoreLayers = false;

    public static String readwoBS(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string != null) {
            String string2;
            while (string.endsWith("\\") && (string2 = bufferedReader.readLine()) != null) {
                string = string.substring(0, string.length() - 1);
                string = string + string2;
            }
        }
        return string;
    }

    public static String skipUntil(BufferedReader bufferedReader, String string, String string2) throws IOException {
        if (string != null && string.startsWith(string2)) {
            return string;
        }
        while ((string = IObjFileImporter.readwoBS(bufferedReader)) != null && !string.startsWith(string2)) {
        }
        return string;
    }

    public static String skipUntilOr(BufferedReader bufferedReader, String string, String string2, String string3) throws IOException {
        if (string != null && (string.startsWith(string2) || string.startsWith(string3))) {
            return string;
        }
        while ((string = IObjFileImporter.readwoBS(bufferedReader)) != null && !string.startsWith(string2) && !string.startsWith(string3)) {
        }
        return string;
    }

    public static ArrayList<Entity> init(IServerI iServerI, ArrayList<IObject> arrayList) {
        ArrayList<Entity> arrayList2 = new ArrayList<Entity>();
        arrayList2.add(new Comment());
        arrayList2.add(new GeometricVertex());
        arrayList2.add(new TextureVertex());
        arrayList2.add(new VertexNormal());
        arrayList2.add(new ParameterSpaceVertex());
        arrayList2.add(new CurveType());
        arrayList2.add(new Degree());
        arrayList2.add(new BasisMatrix());
        arrayList2.add(new StepSize());
        arrayList2.add(new Point());
        arrayList2.add(new Line());
        arrayList2.add(new Face());
        arrayList2.add(new Curve());
        arrayList2.add(new Curve2D());
        arrayList2.add(new Surface());
        arrayList2.add(new Parameter());
        arrayList2.add(new OuterTrimmingLoop());
        arrayList2.add(new InnerTrimmingLoop());
        arrayList2.add(new SpecialCurve());
        arrayList2.add(new SpecialPoint());
        arrayList2.add(new EndStatement());
        arrayList2.add(new Connect());
        arrayList2.add(new GroupName());
        arrayList2.add(new SmoothingGroup());
        arrayList2.add(new MergingGroup());
        arrayList2.add(new ObjectName());
        arrayList2.add(new BevelInterpolation());
        arrayList2.add(new ColorInterpolation());
        arrayList2.add(new DissolveInterpolation());
        arrayList2.add(new LevelOfDetail());
        arrayList2.add(new MaterialName());
        arrayList2.add(new MaterialLibrary());
        arrayList2.add(new ShadowCasting());
        arrayList2.add(new RayTracing());
        arrayList2.add(new CurveApproximationTechnique());
        arrayList2.add(new SurfaceApproximationTechnique());
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList2.get(i).setAllEntities(arrayList2);
            arrayList2.get(i).setObjectContainer(arrayList);
            arrayList2.get(i).setServer(iServerI);
        }
        return arrayList2;
    }

    public static ArrayList<IObject> read(File file, IServerI iServerI) {
        try {
            return IObjFileImporter.read(new FileReader(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<IObject> read(InputStream inputStream, IServerI iServerI) {
        return IObjFileImporter.read(new InputStreamReader(inputStream), iServerI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<IObject> read(Reader reader, IServerI iServerI) {
        BufferedReader bufferedReader = null;
        ArrayList<IObject> arrayList = new ArrayList<IObject>();
        ArrayList<Entity> arrayList2 = IObjFileImporter.init(iServerI, arrayList);
        Face face = null;
        for (int i = 0; i < arrayList2.size() && face == null; ++i) {
            if (!(arrayList2.get(i) instanceof Face)) continue;
            face = (Face)arrayList2.get(i);
        }
        try {
            bufferedReader = new BufferedReader(reader);
            GroupName.Data data = null;
            ParametricGeometryData parametricGeometryData = null;
            MaterialName.Data data2 = null;
            Object object = IG.lock;
            synchronized (object) {
                String string;
                while ((string = IObjFileImporter.readwoBS(bufferedReader)) != null) {
                    Entity entity = null;
                    for (int i = 0; i < arrayList2.size() && entity == null; ++i) {
                        Entity entity2 = arrayList2.get(i);
                        if (!string.split(" +")[0].equals(entity2.getLabel())) continue;
                        entity = entity2;
                    }
                    if (entity == null) continue;
                    entity.read(string);
                    if (entity instanceof GroupName) {
                        data = (GroupName.Data)entity.getLatestData();
                    } else if (entity instanceof Curve) {
                        parametricGeometryData = (ParametricGeometryData)entity.getLatestData();
                    } else if (entity instanceof Curve2D) {
                        parametricGeometryData = (ParametricGeometryData)entity.getLatestData();
                    } else if (entity instanceof Surface) {
                        parametricGeometryData = (ParametricGeometryData)entity.getLatestData();
                    } else if (entity instanceof CurveType) {
                        parametricGeometryData = null;
                    } else if (entity instanceof EndStatement) {
                        if (parametricGeometryData != null) {
                            if (!(parametricGeometryData instanceof Curve2D.Data)) {
                                if (data != null) {
                                    parametricGeometryData.setGroup(data);
                                }
                                parametricGeometryData.instantiate();
                                parametricGeometryData = null;
                            }
                        } else {
                            IOut.err("no correspondent statement to end statement");
                        }
                    } else if (entity instanceof Degree) {
                        if (parametricGeometryData != null) {
                            parametricGeometryData.setDegree((Degree.Data)entity.getLatestData());
                        }
                    } else if (entity instanceof Parameter) {
                        parametricGeometryData.setKnots((Parameter.Data)entity.getLatestData());
                    } else if (entity instanceof InnerTrimmingLoop && parametricGeometryData instanceof Surface.Data) {
                        ((Surface.Data)parametricGeometryData).setInnerTrimmingLoop((InnerTrimmingLoop.Data)entity.getLatestData());
                    } else if (entity instanceof OuterTrimmingLoop && parametricGeometryData instanceof Surface.Data) {
                        ((Surface.Data)parametricGeometryData).setOuterTrimmingLoop((OuterTrimmingLoop.Data)entity.getLatestData());
                    } else if (entity instanceof MaterialLibrary) {
                        ((MaterialLibrary.Data)((MaterialLibrary)entity).getLatestData()).read();
                    } else if (entity instanceof MaterialName) {
                        data2 = (MaterialName.Data)((MaterialName)entity).getLatestData();
                    }
                    if (entity == face || !face.creatingMesh()) continue;
                    if (data != null) {
                        face.setGroup(data);
                    }
                    face.resetMesh();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        IOut.debug(0, "reading complete");
        return arrayList;
    }

    public static ArrayList<Material.Data> readMTL(File file, IServerI iServerI) {
        try {
            return IObjFileImporter.readMTL(new FileReader(file), iServerI);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static ArrayList<Material.Data> readMTL(InputStream inputStream, IServerI iServerI) {
        return IObjFileImporter.readMTL(new InputStreamReader(inputStream), iServerI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Material.Data> readMTL(Reader reader, IServerI iServerI) {
        BufferedReader bufferedReader = null;
        ArrayList<IObject> arrayList = new ArrayList<IObject>();
        ArrayList<Entity> arrayList2 = IObjFileImporter.init(iServerI, arrayList);
        Face face = null;
        for (int i = 0; i < arrayList2.size() && face == null; ++i) {
            if (!(arrayList2.get(i) instanceof Face)) continue;
            face = (Face)arrayList2.get(i);
        }
        try {
            bufferedReader = new BufferedReader(reader);
            GroupName.Data data = null;
            ParametricGeometryData parametricGeometryData = null;
            MaterialName.Data data2 = null;
            Object object = IG.lock;
            synchronized (object) {
                String string;
                while ((string = IObjFileImporter.readwoBS(bufferedReader)) != null) {
                    Entity entity = null;
                    for (int i = 0; i < arrayList2.size() && entity == null; ++i) {
                        Entity entity2 = arrayList2.get(i);
                        if (!string.split(" +")[0].equals(entity2.getLabel())) continue;
                        entity = entity2;
                    }
                    if (entity == null) continue;
                    entity.read(string);
                    if (entity instanceof GroupName) {
                        data = (GroupName.Data)entity.getLatestData();
                    } else if (entity instanceof Curve) {
                        parametricGeometryData = (ParametricGeometryData)entity.getLatestData();
                    } else if (entity instanceof Curve2D) {
                        parametricGeometryData = (ParametricGeometryData)entity.getLatestData();
                    } else if (entity instanceof Surface) {
                        parametricGeometryData = (ParametricGeometryData)entity.getLatestData();
                    } else if (entity instanceof CurveType) {
                        parametricGeometryData = null;
                    } else if (entity instanceof EndStatement) {
                        if (parametricGeometryData != null) {
                            if (!(parametricGeometryData instanceof Curve2D.Data)) {
                                if (data != null) {
                                    parametricGeometryData.setGroup(data);
                                }
                                parametricGeometryData.instantiate();
                                parametricGeometryData = null;
                            }
                        } else {
                            IOut.err("no correspondent statement to end statement");
                        }
                    } else if (entity instanceof Degree) {
                        if (parametricGeometryData != null) {
                            parametricGeometryData.setDegree((Degree.Data)entity.getLatestData());
                        }
                    } else if (entity instanceof Parameter) {
                        parametricGeometryData.setKnots((Parameter.Data)entity.getLatestData());
                    } else if (entity instanceof InnerTrimmingLoop && parametricGeometryData instanceof Surface.Data) {
                        ((Surface.Data)parametricGeometryData).setInnerTrimmingLoop((InnerTrimmingLoop.Data)entity.getLatestData());
                    } else if (entity instanceof OuterTrimmingLoop && parametricGeometryData instanceof Surface.Data) {
                        ((Surface.Data)parametricGeometryData).setOuterTrimmingLoop((OuterTrimmingLoop.Data)entity.getLatestData());
                    } else if (entity instanceof MaterialLibrary) {
                        ((MaterialLibrary.Data)((MaterialLibrary)entity).getLatestData()).read();
                    } else if (entity instanceof MaterialName) {
                        data2 = (MaterialName.Data)((MaterialName)entity).getLatestData();
                    }
                    if (entity == face || !face.creatingMesh()) continue;
                    if (data != null) {
                        face.setGroup(data);
                    }
                    face.resetMesh();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        IOut.debug(0, "reading complete");
        return null;
    }

    public static class TextureMap
    extends Entity {
        @Override
        public String getLabel() {
            return "map_Ka";
        }

        public class Data
        extends EntityData {
            public String filename;
        }
    }

    public static class Transparency2
    extends Transparency {
        @Override
        public String getLabel() {
            return "d";
        }
    }

    public static class Transparency
    extends Entity {
        @Override
        public String getLabel() {
            return "Tr";
        }

        public class Data
        extends EntityData {
            public double transparency;
        }
    }

    public static class Shininess
    extends Entity {
        @Override
        public String getLabel() {
            return "Ns";
        }

        public class Data
        extends EntityData {
            public double shininess;
        }
    }

    public static class IlluminationMode
    extends Entity {
        @Override
        public String getLabel() {
            return "illum";
        }

        public class Data
        extends EntityData {
            public int mode;
        }
    }

    public static class SpecularColor
    extends Entity {
        @Override
        public String getLabel() {
            return "Ks";
        }

        public class Data
        extends EntityData {
            public double r;
            public double g;
            public double b;
        }
    }

    public static class DiffuseColor
    extends Entity {
        @Override
        public String getLabel() {
            return "Kd";
        }

        public class Data
        extends EntityData {
            public double r;
            public double g;
            public double b;
        }
    }

    public static class AmbientColor
    extends Entity {
        @Override
        public String getLabel() {
            return "Ka";
        }

        public class Data
        extends EntityData {
            public double r;
            public double g;
            public double b;
        }
    }

    public static class Material
    extends Entity {
        @Override
        public String getLabel() {
            return "newmtl";
        }

        public class Data
        extends EntityData {
            public String name;
            public AmbientColor.Data ambient;
            public DiffuseColor.Data diffuse;
            public SpecularColor.Data specular;
            public IlluminationMode.Data illuminationMode;
            public Shininess.Data shininess;
            public Transparency.Data transparency;
            public TextureMap.Data textureMap;
        }
    }

    public static class SurfaceApproximationTechnique
    extends Entity {
        @Override
        public String getLabel() {
            return "stech";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class CurveApproximationTechnique
    extends Entity {
        @Override
        public String getLabel() {
            return "ctech";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class RayTracing
    extends Entity {
        @Override
        public String getLabel() {
            return "trace_obj";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class ShadowCasting
    extends Entity {
        @Override
        public String getLabel() {
            return "shadow_obj";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class MaterialLibrary
    extends Entity {
        @Override
        public String getLabel() {
            return "mtllib";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            Data data = new Data();
            data.setMaterialFileName(stringArray[1]);
            return data;
        }

        public class Data
        extends EntityData {
            public String materialFileName;

            public void setMaterialFileName(String string) {
                this.materialFileName = string;
            }

            public void read() {
            }
        }
    }

    public static class MaterialName
    extends Entity {
        @Override
        public String getLabel() {
            return "usemtl";
        }

        @Override
        public EntityData parse(String string) {
            Data data = new Data();
            String[] stringArray = string.split(" +", 2);
            data.setMaterialName(stringArray[1]);
            return data;
        }

        public class Data
        extends EntityData {
            public String materialName;

            public void setMaterialName(String string) {
                this.materialName = string;
            }
        }
    }

    public static class LevelOfDetail
    extends Entity {
        @Override
        public String getLabel() {
            return "lod";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class DissolveInterpolation
    extends Entity {
        @Override
        public String getLabel() {
            return "d_interp";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class ColorInterpolation
    extends Entity {
        @Override
        public String getLabel() {
            return "c_interp";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class BevelInterpolation
    extends Entity {
        @Override
        public String getLabel() {
            return "bevel";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class ObjectName
    extends Entity {
        @Override
        public String getLabel() {
            return "o";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            Data data = new Data();
            data.name = stringArray[1];
            return data;
        }

        public class Data
        extends EntityData {
            public String name;
        }
    }

    public static class MergingGroup
    extends Entity {
        @Override
        public String getLabel() {
            return "mg";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class SmoothingGroup
    extends Entity {
        @Override
        public String getLabel() {
            return "s";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class GroupName
    extends Entity {
        @Override
        public String getLabel() {
            return "g";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            Data data = new Data();
            data.setName(stringArray[1]);
            return data;
        }

        public class Data
        extends EntityData {
            public void setName(String string) {
            }

            public void add(IObject iObject) {
            }
        }
    }

    public static class Connect
    extends Entity {
        public Curve2D curve2D = null;
        public Surface surface = null;

        @Override
        public String getLabel() {
            return "con";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            int n;
            if (this.curve2D == null) {
                for (n = 0; n < this.entities.size() && this.curve2D == null; ++n) {
                    if (!(this.entities.get(n) instanceof Curve2D)) continue;
                    this.curve2D = (Curve2D)this.entities.get(n);
                }
            }
            if (this.surface == null) {
                for (n = 0; n < this.entities.size() && this.surface == null; ++n) {
                    if (!(this.entities.get(n) instanceof Surface)) continue;
                    this.surface = (Surface)this.entities.get(n);
                }
            }
            Data data = new Data();
            try {
                int n2 = Integer.parseInt(stringArray[1]);
                data.surf1 = (Surface.Data)this.surface.getData(n2);
                data.startParameter1 = Double.parseDouble(stringArray[2]);
                data.endParameter1 = Double.parseDouble(stringArray[3]);
                int n3 = Integer.parseInt(stringArray[4]);
                data.curv1 = (Curve2D.Data)this.curve2D.getData(n3);
                int n4 = Integer.parseInt(stringArray[5]);
                data.surf2 = (Surface.Data)this.surface.getData(n4);
                data.startParameter2 = Double.parseDouble(stringArray[6]);
                data.endParameter2 = Double.parseDouble(stringArray[7]);
                int n5 = Integer.parseInt(stringArray[8]);
                data.curv2 = (Curve2D.Data)this.curve2D.getData(n5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends EntityData {
            public Surface.Data surf1;
            public Surface.Data surf2;
            public Curve2D.Data curv1;
            public Curve2D.Data curv2;
            public double startParameter1;
            public double startParameter2;
            public double endParameter1;
            public double endParameter2;
        }
    }

    public static class EndStatement
    extends Entity {
        @Override
        public String getLabel() {
            return "end";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class SpecialPoint
    extends Entity {
        @Override
        public String getLabel() {
            return "sp";
        }

        public class Data
        extends EntityData {
            public ArrayList<ParameterSpaceVertex.Data> parameterSpaceVertices = new ArrayList();
        }
    }

    public static class SpecialCurve
    extends Entity {
        public Curve2D curve2D = null;

        @Override
        public String getLabel() {
            return "scrv";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (this.curve2D == null) {
                for (int i = 0; i < this.entities.size() && this.curve2D == null; ++i) {
                    if (!(this.entities.get(i) instanceof Curve2D)) continue;
                    this.curve2D = (Curve2D)this.entities.get(i);
                }
            }
            Data data = new Data();
            for (int i = 1; i < stringArray.length; i += 3) {
                try {
                    data.startParameters.add(Double.valueOf(stringArray[i]));
                    data.endParameters.add(Double.valueOf(stringArray[i + 1]));
                    int n = Integer.parseInt(stringArray[i + 2]);
                    Curve2D.Data data2 = (Curve2D.Data)this.curve2D.getData(n);
                    data.curve2d.add(data2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return data;
        }

        public class Data
        extends EntityData {
            public ArrayList<Double> startParameters = new ArrayList();
            public ArrayList<Double> endParameters = new ArrayList();
            public ArrayList<Curve2D.Data> curve2d = new ArrayList();
        }
    }

    public static class InnerTrimmingLoop
    extends Entity {
        public Curve2D curve2D = null;

        @Override
        public String getLabel() {
            return "hole";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (this.curve2D == null) {
                for (int i = 0; i < this.entities.size() && this.curve2D == null; ++i) {
                    if (!(this.entities.get(i) instanceof Curve2D)) continue;
                    this.curve2D = (Curve2D)this.entities.get(i);
                }
            }
            Data data = new Data();
            for (int i = 1; i < stringArray.length; i += 3) {
                try {
                    data.startParameters.add(Double.valueOf(stringArray[i]));
                    data.endParameters.add(Double.valueOf(stringArray[i + 1]));
                    int n = Integer.parseInt(stringArray[i + 2]);
                    Curve2D.Data data2 = (Curve2D.Data)this.curve2D.getData(n);
                    data.curve2d.add(data2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return data;
        }

        public class Data
        extends EntityData {
            public ArrayList<Double> startParameters = new ArrayList();
            public ArrayList<Double> endParameters = new ArrayList();
            public ArrayList<Curve2D.Data> curve2d = new ArrayList();
            public ISurface surface = null;

            public void setSurface(ISurface iSurface) {
                this.surface = iSurface;
            }

            public void instantiate() {
                for (int i = 0; i < this.curve2d.size(); ++i) {
                    Curve2D.Data data = this.curve2d.get(i);
                    data.setSurface(this.surface);
                    data.setParameterRange(this.startParameters.get(i), this.endParameters.get(i));
                    data.instantiate();
                    this.surface.surface.addInnerTrim(data.getCurve());
                }
                this.surface.surface.closeInnerTrim();
            }
        }
    }

    public static class OuterTrimmingLoop
    extends Entity {
        public Curve2D curve2D = null;

        @Override
        public String getLabel() {
            return "trim";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (this.curve2D == null) {
                for (int i = 0; i < this.entities.size() && this.curve2D == null; ++i) {
                    if (!(this.entities.get(i) instanceof Curve2D)) continue;
                    this.curve2D = (Curve2D)this.entities.get(i);
                }
            }
            Data data = new Data();
            for (int i = 1; i < stringArray.length; i += 3) {
                try {
                    data.startParameters.add(Double.valueOf(stringArray[i]));
                    data.endParameters.add(Double.valueOf(stringArray[i + 1]));
                    int n = Integer.parseInt(stringArray[i + 2]);
                    Curve2D.Data data2 = (Curve2D.Data)this.curve2D.getData(n);
                    data.curve2d.add(data2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return data;
        }

        public class Data
        extends EntityData {
            public ArrayList<Double> startParameters = new ArrayList();
            public ArrayList<Double> endParameters = new ArrayList();
            public ArrayList<Curve2D.Data> curve2d = new ArrayList();
            public ISurface surface = null;

            public void setSurface(ISurface iSurface) {
                this.surface = iSurface;
            }

            public void instantiate() {
                for (int i = 0; i < this.curve2d.size(); ++i) {
                    Curve2D.Data data = this.curve2d.get(i);
                    data.setSurface(this.surface);
                    data.setParameterRange(this.startParameters.get(i), this.endParameters.get(i));
                    data.instantiate();
                    this.surface.surface.addOuterTrim(data.getCurve());
                }
                this.surface.surface.closeOuterTrim();
            }
        }
    }

    public static class Parameter
    extends Entity {
        @Override
        public String getLabel() {
            return "parm";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            Data data = new Data();
            if (stringArray[1].equals("u")) {
                data.u_v = true;
            } else if (stringArray[1].equals("v")) {
                data.u_v = false;
            }
            for (int i = 2; i < stringArray.length; ++i) {
                try {
                    data.parameters.add(Double.valueOf(stringArray[i]));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return data;
        }

        public class Data
        extends EntityData {
            public boolean u_v = true;
            public ArrayList<Double> parameters = new ArrayList();

            public boolean isU() {
                return this.u_v;
            }

            public boolean isV() {
                return !this.u_v;
            }

            public int size() {
                return this.parameters.size();
            }

            public double[] getArray() {
                double[] dArray = new double[this.parameters.size()];
                for (int i = 0; i < this.parameters.size(); ++i) {
                    dArray[i] = this.parameters.get(i);
                }
                return dArray;
            }
        }
    }

    public static class Surface
    extends Entity {
        public GeometricVertex geometryVertex = null;
        public TextureVertex textureVertex = null;
        public VertexNormal vertexNormal = null;
        public Degree degree = null;

        @Override
        public String getLabel() {
            return "surf";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            int n;
            if (this.geometryVertex == null) {
                for (n = 0; n < this.entities.size() && this.geometryVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof GeometricVertex)) continue;
                    this.geometryVertex = (GeometricVertex)this.entities.get(n);
                }
            }
            if (this.textureVertex == null) {
                for (n = 0; n < this.entities.size() && this.textureVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof TextureVertex)) continue;
                    this.textureVertex = (TextureVertex)this.entities.get(n);
                }
            }
            if (this.vertexNormal == null) {
                for (n = 0; n < this.entities.size() && this.vertexNormal == null; ++n) {
                    if (!(this.entities.get(n) instanceof VertexNormal)) continue;
                    this.vertexNormal = (VertexNormal)this.entities.get(n);
                }
            }
            if (this.degree == null) {
                for (n = 0; n < this.entities.size() && this.degree == null; ++n) {
                    if (!(this.entities.get(n) instanceof Degree)) continue;
                    this.degree = (Degree)this.entities.get(n);
                }
            }
            Data data = new Data();
            try {
                data.u0 = Double.parseDouble(stringArray[1]);
                data.u1 = Double.parseDouble(stringArray[2]);
                data.v0 = Double.parseDouble(stringArray[3]);
                data.v1 = Double.parseDouble(stringArray[4]);
                for (int i = 5; i < stringArray.length; ++i) {
                    EntityData entityData;
                    int n2;
                    String[] stringArray2 = stringArray[i].split("/");
                    int n3 = Integer.parseInt(stringArray2[0]);
                    GeometricVertex.Data data2 = (GeometricVertex.Data)this.geometryVertex.getData(n3);
                    data.vertices.add(data2);
                    if (stringArray2.length > 1 && stringArray2[1].length() > 0) {
                        n2 = Integer.parseInt(stringArray2[1]);
                        entityData = (TextureVertex.Data)this.textureVertex.getData(n2);
                        data.textureVertices.add((TextureVertex.Data)entityData);
                    }
                    if (stringArray2.length <= 2 || stringArray2[2].length() <= 0) continue;
                    n2 = Integer.parseInt(stringArray2[2]);
                    entityData = (VertexNormal.Data)this.vertexNormal.getData(n2);
                    data.vertexNormals.add((VertexNormal.Data)entityData);
                }
                data.degree = (Degree.Data)this.degree.getLatestData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends ParametricGeometryData {
            public double u0;
            public double u1;
            public double v0;
            public double v1;
            public ArrayList<GeometricVertex.Data> vertices = new ArrayList();
            public ArrayList<TextureVertex.Data> textureVertices = new ArrayList();
            public ArrayList<VertexNormal.Data> vertexNormals = new ArrayList();
            public Degree.Data degree;
            public Parameter.Data uknots;
            public Parameter.Data vknots;
            public ArrayList<OuterTrimmingLoop.Data> outerTrimmingLoops = new ArrayList();
            public ArrayList<InnerTrimmingLoop.Data> innerTrimmingLoops = new ArrayList();

            @Override
            public void setDegree(Degree.Data data) {
                this.degree = data;
            }

            @Override
            public void setKnots(Parameter.Data data) {
                if (data.isU()) {
                    this.uknots = data;
                } else if (data.isV()) {
                    this.vknots = data;
                } else {
                    IOut.err("invalid parameter data");
                }
            }

            public void setOuterTrimmingLoop(OuterTrimmingLoop.Data data) {
                this.outerTrimmingLoops.add(data);
            }

            public void setInnerTrimmingLoop(InnerTrimmingLoop.Data data) {
                this.innerTrimmingLoops.add(data);
            }

            @Override
            public void instantiate() {
                EntityData entityData;
                int n;
                int n2 = this.uknots.size() - this.degree.udegree - 1;
                int n3 = this.vknots.size() - this.degree.vdegree - 1;
                IVecI[][] iVecIArray = new IVec[n2][n3];
                for (int i = 0; i < this.vertices.size(); ++i) {
                    GeometricVertex.Data data = this.vertices.get(i);
                    iVecIArray[i % n2][i / n2] = data.w != 1.0 ? new IVec4(data.x, data.y, data.z, data.w) : new IVec(data.x, data.y, data.z);
                }
                ISurface iSurface = new ISurface(Surface.this.server, iVecIArray, this.degree.udegree, this.degree.vdegree, this.uknots.getArray(), this.vknots.getArray(), this.u0, this.u1, this.v0, this.v1);
                for (n = 0; n < this.outerTrimmingLoops.size(); ++n) {
                    entityData = this.outerTrimmingLoops.get(n);
                    ((OuterTrimmingLoop.Data)entityData).setSurface(iSurface);
                    ((OuterTrimmingLoop.Data)entityData).instantiate();
                }
                for (n = 0; n < this.innerTrimmingLoops.size(); ++n) {
                    entityData = this.innerTrimmingLoops.get(n);
                    ((InnerTrimmingLoop.Data)entityData).setSurface(iSurface);
                    ((InnerTrimmingLoop.Data)entityData).instantiate();
                }
                Surface.this.objects.add(iSurface);
                this.addToGroup(iSurface);
            }
        }
    }

    public static class Curve2D
    extends Entity {
        public ParameterSpaceVertex parameterSpaceVertex = null;
        public Degree degree = null;

        @Override
        public String getLabel() {
            return "curv2";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            int n;
            if (this.parameterSpaceVertex == null) {
                for (n = 0; n < this.entities.size() && this.parameterSpaceVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof ParameterSpaceVertex)) continue;
                    this.parameterSpaceVertex = (ParameterSpaceVertex)this.entities.get(n);
                }
            }
            if (this.degree == null) {
                for (n = 0; n < this.entities.size() && this.degree == null; ++n) {
                    if (!(this.entities.get(n) instanceof Degree)) continue;
                    this.degree = (Degree)this.entities.get(n);
                }
            }
            Data data = new Data();
            try {
                for (int i = 1; i < stringArray.length; ++i) {
                    int n2 = Integer.parseInt(stringArray[i]);
                    ParameterSpaceVertex.Data data2 = (ParameterSpaceVertex.Data)this.parameterSpaceVertex.getData(n2);
                    data.parameterSpaceVertices.add(data2);
                }
                data.degree = (Degree.Data)this.degree.getLatestData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends ParametricGeometryData {
            public ArrayList<ParameterSpaceVertex.Data> parameterSpaceVertices = new ArrayList();
            public Degree.Data degree;
            public Parameter.Data knots;
            public double u0 = 0.0;
            public double u1 = 0.0;
            public ISurface surface = null;
            public ITrimCurve curve = null;

            @Override
            public void setDegree(Degree.Data data) {
                this.degree = data;
            }

            @Override
            public void setKnots(Parameter.Data data) {
                this.knots = data;
            }

            public void setParameterRange(double d, double d2) {
                this.u0 = d;
                this.u1 = d2;
            }

            public void setSurface(ISurface iSurface) {
                this.surface = iSurface;
            }

            public ITrimCurve getCurve() {
                return this.curve;
            }

            @Override
            public void instantiate() {
                IVecI[] iVecIArray = new IVec[this.parameterSpaceVertices.size()];
                for (int i = 0; i < this.parameterSpaceVertices.size(); ++i) {
                    ParameterSpaceVertex.Data data = this.parameterSpaceVertices.get(i);
                    iVecIArray[i] = data.w != 1.0 ? new IVec4(data.u, data.v, 0.0, data.w) : new IVec(data.u, data.v, 0.0);
                }
                this.curve = new ITrimCurve(iVecIArray, this.degree.udegree, this.knots.getArray(), this.u0, this.u1);
                this.curve.normalizeControlPoints(this.surface);
            }
        }
    }

    public static class Curve
    extends Entity {
        public GeometricVertex geometryVertex = null;
        public Degree degree = null;

        @Override
        public String getLabel() {
            return "curv";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            int n;
            if (this.geometryVertex == null) {
                for (n = 0; n < this.entities.size() && this.geometryVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof GeometricVertex)) continue;
                    this.geometryVertex = (GeometricVertex)this.entities.get(n);
                }
            }
            if (this.degree == null) {
                for (n = 0; n < this.entities.size() && this.degree == null; ++n) {
                    if (!(this.entities.get(n) instanceof Degree)) continue;
                    this.degree = (Degree)this.entities.get(n);
                }
            }
            Data data = new Data();
            try {
                data.u0 = Double.parseDouble(stringArray[1]);
                data.u1 = Double.parseDouble(stringArray[2]);
                for (int i = 3; i < stringArray.length; ++i) {
                    int n2 = Integer.parseInt(stringArray[i]);
                    GeometricVertex.Data data2 = (GeometricVertex.Data)this.geometryVertex.getData(n2);
                    data.vertices.add(data2);
                }
                data.degree = (Degree.Data)this.degree.getLatestData();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends ParametricGeometryData {
            public double u0;
            public double u1;
            public ArrayList<GeometricVertex.Data> vertices = new ArrayList();
            public Degree.Data degree;
            public Parameter.Data knots;

            @Override
            public void setDegree(Degree.Data data) {
                this.degree = data;
            }

            @Override
            public void setKnots(Parameter.Data data) {
                this.knots = data;
            }

            @Override
            public void instantiate() {
                IVecI[] iVecIArray = new IVec[this.vertices.size()];
                for (int i = 0; i < this.vertices.size(); ++i) {
                    GeometricVertex.Data data = this.vertices.get(i);
                    iVecIArray[i] = data.w != 1.0 ? new IVec4(data.x, data.y, data.z, data.w) : new IVec(data.x, data.y, data.z);
                }
                ICurve iCurve = new ICurve(Curve.this.server, iVecIArray, this.degree.udegree, this.knots.getArray(), this.u0, this.u1);
                Curve.this.objects.add(iCurve);
                this.addToGroup(iCurve);
            }
        }
    }

    public static class Face
    extends Entity {
        public GeometricVertex geometryVertex = null;
        public TextureVertex textureVertex = null;
        public VertexNormal vertexNormal = null;
        public boolean newface = true;
        public IMesh mesh;
        public GroupName.Data group = null;

        public void setGroup(GroupName.Data data) {
            this.group = data;
        }

        public void addToGroup(IObject iObject) {
            if (this.group != null) {
                this.group.add(iObject);
            }
        }

        @Override
        public String getLabel() {
            return "f";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            int n;
            if (this.geometryVertex == null) {
                for (n = 0; n < this.entities.size() && this.geometryVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof GeometricVertex)) continue;
                    this.geometryVertex = (GeometricVertex)this.entities.get(n);
                }
            }
            if (this.textureVertex == null) {
                for (n = 0; n < this.entities.size() && this.textureVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof TextureVertex)) continue;
                    this.textureVertex = (TextureVertex)this.entities.get(n);
                }
            }
            if (this.vertexNormal == null) {
                for (n = 0; n < this.entities.size() && this.vertexNormal == null; ++n) {
                    if (!(this.entities.get(n) instanceof VertexNormal)) continue;
                    this.vertexNormal = (VertexNormal)this.entities.get(n);
                }
            }
            if (this.newface) {
                this.mesh = new IMesh(this.server);
                this.newface = false;
            }
            Data data = new Data();
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("/");
                try {
                    EntityData entityData;
                    int n2;
                    int n3 = Integer.parseInt(stringArray2[0]);
                    GeometricVertex.Data data2 = (GeometricVertex.Data)this.geometryVertex.getData(n3);
                    data.vertices.add(data2);
                    if (stringArray2.length > 1 && stringArray2[1].length() > 0) {
                        n2 = Integer.parseInt(stringArray2[1]);
                        entityData = (TextureVertex.Data)this.textureVertex.getData(n2);
                        data.textureVertices.add((TextureVertex.Data)entityData);
                    }
                    if (stringArray2.length <= 2 || stringArray2[2].length() <= 0) continue;
                    n2 = Integer.parseInt(stringArray2[2]);
                    entityData = (VertexNormal.Data)this.vertexNormal.getData(n2);
                    data.vertexNormals.add((VertexNormal.Data)entityData);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            IFace iFace = data.instantiate();
            this.mesh.addFace(iFace);
            return data;
        }

        public void resetMesh() {
            this.newface = true;
            if (this.mesh != null) {
                this.addToGroup(this.mesh);
            }
            this.mesh = null;
        }

        public boolean creatingMesh() {
            return !this.newface;
        }

        public class Data
        extends EntityData {
            public ArrayList<GeometricVertex.Data> vertices = new ArrayList();
            public ArrayList<TextureVertex.Data> textureVertices = new ArrayList();
            public ArrayList<VertexNormal.Data> vertexNormals = new ArrayList();

            public IFace instantiate() {
                int n = this.vertices.size();
                GeometricVertex.Data[] dataArray = new GeometricVertex.Data[n];
                TextureVertex.Data[] dataArray2 = new TextureVertex.Data[n];
                VertexNormal.Data[] dataArray3 = new VertexNormal.Data[n];
                for (int i = 0; i < this.vertices.size(); ++i) {
                    dataArray[i] = this.vertices.get(i);
                    dataArray2[i] = null;
                    dataArray3[i] = null;
                    if (this.textureVertices.size() == this.vertices.size()) {
                        dataArray2[i] = this.textureVertices.get(i);
                    }
                    if (this.vertexNormals.size() != this.vertices.size()) continue;
                    dataArray3[i] = this.vertexNormals.get(i);
                }
                IFace iFace = null;
                IVertex[] iVertexArray = new IVertex[n];
                for (int i = 0; i < n; ++i) {
                    iVertexArray[i] = dataArray[i].getVertex();
                    if (dataArray2[i] != null) {
                        iVertexArray[i].texture(dataArray2[i].getVertex().to2d());
                    }
                    if (dataArray3[i] == null) continue;
                    iVertexArray[i].setNormal(dataArray3[i].getVertex());
                }
                IEdge[] iEdgeArray = new IEdge[n];
                for (int i = 0; i < n; ++i) {
                    iEdgeArray[i] = iVertexArray[i].createEdgeTo(iVertexArray[(i + 1) % n]);
                }
                iFace = new IFace(iEdgeArray);
                return iFace;
            }
        }
    }

    public static class Line
    extends Entity {
        public GeometricVertex geometryVertex = null;
        public TextureVertex textureVertex = null;

        @Override
        public String getLabel() {
            return "l";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            int n;
            if (this.geometryVertex == null) {
                for (n = 0; n < this.entities.size() && this.geometryVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof GeometricVertex)) continue;
                    this.geometryVertex = (GeometricVertex)this.entities.get(n);
                }
            }
            if (this.textureVertex == null) {
                for (n = 0; n < this.entities.size() && this.textureVertex == null; ++n) {
                    if (!(this.entities.get(n) instanceof TextureVertex)) continue;
                    this.textureVertex = (TextureVertex)this.entities.get(n);
                }
            }
            Data data = new Data();
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("/");
                try {
                    int n2 = Integer.parseInt(stringArray2[0]);
                    GeometricVertex.Data data2 = (GeometricVertex.Data)this.geometryVertex.getData(n2);
                    data.vertices.add(data2);
                    if (stringArray2.length <= 1) continue;
                    int n3 = Integer.parseInt(stringArray2[1]);
                    TextureVertex.Data data3 = (TextureVertex.Data)this.textureVertex.getData(n3);
                    data.textureVertices.add(data3);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            data.instantiate();
            return data;
        }

        public class Data
        extends EntityData {
            public ArrayList<GeometricVertex.Data> vertices = new ArrayList();
            public ArrayList<TextureVertex.Data> textureVertices = new ArrayList();

            public void instantiate() {
            }
        }
    }

    public static class Point
    extends Entity {
        public GeometricVertex geometryVertex = null;

        @Override
        public String getLabel() {
            return "p";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (this.geometryVertex == null) {
                for (int i = 0; i < this.entities.size() && this.geometryVertex == null; ++i) {
                    if (!(this.entities.get(i) instanceof GeometricVertex)) continue;
                    this.geometryVertex = (GeometricVertex)this.entities.get(i);
                }
            }
            Data data = new Data();
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    int n = Integer.parseInt(stringArray[i]);
                    GeometricVertex.Data data2 = (GeometricVertex.Data)this.geometryVertex.getData(n);
                    data.vertices.add(data2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            data.instantiate();
            return data;
        }

        public class Data
        extends ParametricGeometryData {
            public ArrayList<GeometricVertex.Data> vertices = new ArrayList();

            @Override
            public void instantiate() {
                for (int i = 0; i < this.vertices.size(); ++i) {
                    GeometricVertex.Data data = this.vertices.get(i);
                    IPoint iPoint = new IPoint(Point.this.server, data.x, data.y, data.z);
                    Point.this.objects.add(iPoint);
                    this.addToGroup(iPoint);
                }
            }
        }
    }

    public static class StepSize
    extends Entity {
        @Override
        public String getLabel() {
            return "step";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class BasisMatrix
    extends Entity {
        @Override
        public String getLabel() {
            return "bmat";
        }

        public class Data
        extends EntityData {
        }
    }

    public static class Degree
    extends Entity {
        @Override
        public String getLabel() {
            return "deg";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (stringArray.length != 2 && stringArray.length != 3) {
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + " ";
                }
                IOut.err("wrong number of arguments; args.length=" + stringArray.length + ": " + string);
                return null;
            }
            Data data = new Data();
            try {
                data.udegree = Integer.parseInt(stringArray[1]);
                data.vdegree = stringArray.length == 3 ? Integer.parseInt(stringArray[2]) : -1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends EntityData {
            public int udegree;
            public int vdegree = -1;
        }
    }

    public static class CurveType
    extends Entity {
        @Override
        public String getLabel() {
            return "cstype";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (stringArray.length != 2 && stringArray.length != 3) {
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + " ";
                }
                IOut.err("wrong number of arguments; args.length=" + stringArray.length + ": " + string);
                return null;
            }
            Data data = new Data();
            if (stringArray.length == 3) {
                if (stringArray[1].equals("rat")) {
                    data.rational = true;
                }
                data.type = stringArray[2];
            } else {
                data.type = stringArray[1];
            }
            return data;
        }

        public class Data
        extends ParametricGeometryData {
            public String type;
            public boolean rational = false;

            @Override
            public void setDegree(Degree.Data data) {
            }

            @Override
            public void setKnots(Parameter.Data data) {
            }

            @Override
            public void instantiate() {
            }
        }
    }

    public static class ParameterSpaceVertex
    extends Entity {
        @Override
        public String getLabel() {
            return "vp";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (stringArray.length != 3 && stringArray.length != 4) {
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + " ";
                }
                IOut.err("wrong number of arguments; args.length=" + stringArray.length + ": " + string);
                return null;
            }
            Data data = new Data();
            try {
                data.u = Double.parseDouble(stringArray[1]);
                data.v = Double.parseDouble(stringArray[2]);
                data.w = stringArray.length == 4 ? Double.parseDouble(stringArray[3]) : 1.0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends EntityData {
            public double u;
            public double v;
            public double w = 1.0;
        }
    }

    public static class VertexNormal
    extends Entity {
        @Override
        public String getLabel() {
            return "vn";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (stringArray.length != 4) {
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + " ";
                }
                IOut.err("wrong number of arguments; args.length=" + stringArray.length + ": " + string);
                return null;
            }
            Data data = new Data();
            try {
                data.x = Double.parseDouble(stringArray[1]);
                data.y = Double.parseDouble(stringArray[2]);
                data.z = Double.parseDouble(stringArray[3]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends EntityData {
            public double x;
            public double y;
            public double z;

            public IVec getVertex() {
                return new IVec(this.x, this.y, this.z);
            }
        }
    }

    public static class TextureVertex
    extends Entity {
        @Override
        public String getLabel() {
            return "vt";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (stringArray.length != 3 && stringArray.length != 4) {
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + " ";
                }
                IOut.err("wrong number of arguments; args.length=" + stringArray.length + ": " + string);
                return null;
            }
            Data data = new Data();
            try {
                data.u = Double.parseDouble(stringArray[1]);
                data.v = Double.parseDouble(stringArray[2]);
                data.w = stringArray.length == 4 ? Double.parseDouble(stringArray[3]) : 1.0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends EntityData {
            public double u;
            public double v;
            public double w = 1.0;

            public IVec getVertex() {
                return new IVec(this.u, this.v, this.w);
            }
        }
    }

    public static class GeometricVertex
    extends Entity {
        @Override
        public String getLabel() {
            return "v";
        }

        @Override
        public EntityData parse(String[] stringArray) {
            if (stringArray.length != 4 && stringArray.length != 5) {
                String string = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i] + " ";
                }
                IOut.err("wrong number of arguments (" + stringArray.length + " )" + string);
                return null;
            }
            Data data = new Data();
            try {
                data.x = Double.parseDouble(stringArray[1]);
                data.y = Double.parseDouble(stringArray[2]);
                data.z = Double.parseDouble(stringArray[3]);
                data.w = stringArray.length == 5 ? Double.parseDouble(stringArray[4]) : 1.0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return data;
        }

        public class Data
        extends EntityData {
            public double x;
            public double y;
            public double z;
            public double w = 1.0;
            public IVertex vertex = null;

            public IVertex getVertex() {
                if (this.vertex == null) {
                    this.vertex = new IVertex(this.x, this.y, this.z);
                }
                return this.vertex;
            }
        }
    }

    public static class Comment
    extends Entity {
        @Override
        public String getLabel() {
            return "#";
        }
    }

    public static class ParametricGeometryData
    extends EntityData {
        public GroupName.Data group = null;

        public void setDegree(Degree.Data data) {
        }

        public void setKnots(Parameter.Data data) {
        }

        public void instantiate() {
        }

        public void setGroup(GroupName.Data data) {
            this.group = data;
        }

        public void addToGroup(IObject iObject) {
            if (this.group != null) {
                this.group.add(iObject);
            }
        }
    }

    public static class EntityData {
    }

    public static class Entity {
        public ArrayList<EntityData> data = new ArrayList();
        public ArrayList<Entity> entities;
        public ArrayList<IObject> objects;
        public IServerI server;

        public String getLabel() {
            return null;
        }

        public EntityData getData(int n) {
            if (n > 0) {
                --n;
            } else if (n < 0) {
                n = this.data.size() + n;
            }
            return this.data.get(n);
        }

        public void read(String string) {
            this.add(this.parse(string));
        }

        public EntityData parse(String string) {
            return this.parse(string.split(" +"));
        }

        public EntityData parse(String[] stringArray) {
            return null;
        }

        public void add(EntityData entityData) {
            this.data.add(entityData);
        }

        public EntityData getLatestData() {
            return this.data.get(this.data.size() - 1);
        }

        public void setAllEntities(ArrayList<Entity> arrayList) {
            this.entities = arrayList;
        }

        public void setObjectContainer(ArrayList<IObject> arrayList) {
            this.objects = arrayList;
        }

        public void setServer(IServerI iServerI) {
            this.server = iServerI;
        }
    }
}

