/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.ICurveGeo;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IVec;
import igeo.IVec4;
import igeo.IVecI;

public class ICircleGeo
extends ICurveGeo {
    public IVecI center;
    public IVecI normal;
    public IDoubleI xradius;
    public IDoubleI yradius;

    public static int circleDeg() {
        return 2;
    }

    public static double[] circleKnots() {
        return new double[]{0.0, 0.0, 0.0, 0.25, 0.25, 0.5, 0.5, 0.75, 0.75, 1.0, 1.0, 1.0};
    }

    public static IVec4[] circleCP(IVec iVec, double d) {
        return ICircleGeo.circleCP(iVec, IVec.zaxis, null, d, d);
    }

    public static IVec4[] circleCP(IVec iVec, IVec iVec2, double d) {
        return ICircleGeo.circleCP(iVec, iVec2, null, d, d);
    }

    public static IVec4[] circleCP(IVec iVec, IVec iVec2, IVec iVec3, double d) {
        return ICircleGeo.circleCP(iVec, iVec2, iVec3, d, d);
    }

    public static IVec4[] circleCP(IVec iVec, IVec iVec2, IVec iVec3, double d, double d2) {
        if (iVec3 == null) {
            iVec3 = IVec.zaxis;
        }
        if (iVec2.cross(iVec3).len2() == 0.0) {
            iVec3 = iVec3.cross(IVec.zaxis).len2() == 0.0 ? IVec.xaxis : IVec.zaxis;
        }
        IVec iVec4 = iVec2.cross(iVec3);
        IVec iVec5 = iVec4.cross(iVec2);
        iVec5.len(d);
        iVec4.len(d2);
        IVec4[] iVec4Array = new IVec4[9];
        for (int i = 0; i < iVec4Array.length - 1; ++i) {
            iVec4Array[i] = iVec.to4d();
        }
        double d3 = Math.sqrt(2.0) / 2.0;
        iVec4Array[0].add(iVec5);
        iVec4Array[1].add((IVec)iVec5).add((IVec)iVec4).w = d3;
        iVec4Array[2].add(iVec4);
        iVec4Array[3].sub((IVec)iVec5).add((IVec)iVec4).w = d3;
        iVec4Array[4].sub(iVec5);
        iVec4Array[5].sub((IVec)iVec5).sub((IVec)iVec4).w = d3;
        iVec4Array[6].sub(iVec4);
        iVec4Array[7].add((IVec)iVec5).sub((IVec)iVec4).w = d3;
        iVec4Array[8] = iVec4Array[0].dup();
        return iVec4Array;
    }

    public static IVec4[] ovalCP(IVec iVec, IVec iVec2, IVec iVec3) {
        IVec4[] iVec4Array = new IVec4[9];
        for (int i = 0; i < iVec4Array.length - 1; ++i) {
            iVec4Array[i] = iVec.to4d();
        }
        double d = Math.sqrt(2.0) / 2.0;
        iVec4Array[0].add(iVec2);
        iVec4Array[1].add((IVec)iVec2).add((IVec)iVec3).w = d;
        iVec4Array[2].add(iVec3);
        iVec4Array[3].sub((IVec)iVec2).add((IVec)iVec3).w = d;
        iVec4Array[4].sub(iVec2);
        iVec4Array[5].sub((IVec)iVec2).sub((IVec)iVec3).w = d;
        iVec4Array[6].sub(iVec3);
        iVec4Array[7].add((IVec)iVec2).sub((IVec)iVec3).w = d;
        iVec4Array[8] = iVec4Array[0].dup();
        return iVec4Array;
    }

    public static IVec[] circleCPApprox(IVec iVec, IVec iVec2, IVec iVec3, double d, double d2) {
        if (iVec3 == null) {
            iVec3 = IVec.zaxis;
        }
        if (iVec2.cross(iVec3).len2() == 0.0) {
            iVec3 = iVec3.cross(IVec.zaxis).len2() == 0.0 ? IVec.xaxis : IVec.zaxis;
        }
        IVec iVec4 = iVec2.cross(iVec3);
        IVec iVec5 = iVec4.cross(iVec2);
        iVec5.len(d);
        iVec4.len(d2);
        IVec[] iVecArray = new IVec[10];
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            iVecArray[i] = iVec.dup();
        }
        double d3 = Math.sqrt(2.0) - 1.0;
        iVecArray[0].add(iVec5);
        iVecArray[1].add(iVec5).add(iVec4.dup().mul(d3));
        iVecArray[2].add(iVec4).add(iVec5.dup().mul(d3));
        iVecArray[3].add(iVec4).sub(iVec5.dup().mul(d3));
        iVecArray[4].sub(iVec5).add(iVec4.dup().mul(d3));
        iVecArray[5].sub(iVec5).sub(iVec4.dup().mul(d3));
        iVecArray[6].sub(iVec4).sub(iVec5.dup().mul(d3));
        iVecArray[7].sub(iVec4).add(iVec5.dup().mul(d3));
        iVecArray[8].add(iVec5).sub(iVec4.dup().mul(d3));
        iVecArray[9] = iVecArray[0].dup();
        return iVecArray;
    }

    public static IVec[] ovalCPApprox(IVec iVec, IVec iVec2, IVec iVec3) {
        IVec[] iVecArray = new IVec[10];
        double d = Math.sqrt(2.0) - 1.0;
        for (int i = 0; i < iVecArray.length - 1; ++i) {
            iVecArray[i] = iVec.dup();
        }
        iVecArray[0].add(iVec2);
        iVecArray[1].add(iVec2).add(iVec3.dup().mul(d));
        iVecArray[2].add(iVec3).add(iVec2.dup().mul(d));
        iVecArray[3].add(iVec3).sub(iVec2.dup().mul(d));
        iVecArray[4].sub(iVec2).add(iVec3.dup().mul(d));
        iVecArray[5].sub(iVec2).sub(iVec3.dup().mul(d));
        iVecArray[6].sub(iVec3).sub(iVec2.dup().mul(d));
        iVecArray[7].sub(iVec3).add(iVec2.dup().mul(d));
        iVecArray[8].add(iVec2).sub(iVec3.dup().mul(d));
        iVecArray[9] = iVecArray[0].dup();
        return iVecArray;
    }

    public static ICircleGeo circumcircle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        IVec iVec = IVec.circumcenter(iVecI.get(), iVecI2.get(), iVecI3.get());
        double d = iVec.dist(iVecI);
        IVec iVec2 = iVecI.get().nml(iVecI2, iVecI3);
        return new ICircleGeo((IVecI)iVec, (IVecI)iVec2, d);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        this(iVecI, iVecI2, iDoubleI, iDoubleI, false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, double d) {
        this(iVecI, iVecI2, (IDoubleI)new IDouble(d), false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this(iVecI, iVecI2, iDoubleI, iDoubleI2, false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        this(iVecI, iVecI2, new IDouble(d), (IDoubleI)new IDouble(d2), false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        this(iVecI, iVecI2, iVecI3, (IDoubleI)new IDouble(d), false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        this(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI, false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2) {
        this(iVecI, iVecI2, iVecI3, new IDouble(d), new IDouble(d2), false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        this(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI2, false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        this(iVecI, iVecI2, iVecI3, false);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, boolean bl) {
        this(iVecI, iVecI2, iDoubleI, iDoubleI, bl);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, double d, boolean bl) {
        this(iVecI, iVecI2, (IDoubleI)new IDouble(d), bl);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, double d, double d2, boolean bl) {
        this(iVecI, iVecI2, new IDouble(d), (IDoubleI)new IDouble(d2), bl);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        this.center = iVecI;
        this.normal = iVecI2;
        this.xradius = iDoubleI;
        this.yradius = iDoubleI2;
        if (bl) {
            this.initApprox();
        } else {
            this.init();
        }
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, boolean bl) {
        this(iVecI, iVecI2, iVecI3, (IDoubleI)new IDouble(d), bl);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, boolean bl) {
        this(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI, bl);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2, boolean bl) {
        this(iVecI, iVecI2, iVecI3, new IDouble(d), new IDouble(d2), bl);
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        if (bl) {
            IVecI[] iVecIArray = ICircleGeo.circleCPApprox(iVecI.get(), iVecI2.get(), iVecI3.get(), iDoubleI.x(), iDoubleI2.x());
            super.init(iVecIArray, ICircleGeo.circleDeg());
        } else {
            IVecI[] iVecIArray = ICircleGeo.circleCP(iVecI.get(), iVecI2.get(), null, iDoubleI.x(), iDoubleI2.x());
            super.init(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleKnots());
        }
        this.center = iVecI;
        this.normal = iVecI2;
        this.xradius = iDoubleI;
        this.yradius = iDoubleI2;
    }

    public ICircleGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        if (bl) {
            IVecI[] iVecIArray = ICircleGeo.ovalCPApprox(iVecI.get(), iVecI2.get(), iVecI3.get());
            super.init(iVecIArray, ICircleGeo.circleDeg());
        } else {
            IVecI[] iVecIArray = ICircleGeo.ovalCP(iVecI.get(), iVecI2.get(), iVecI3.get());
            super.init(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleKnots());
        }
        this.center = iVecI;
        this.normal = this.normal;
        this.xradius = this.xradius;
        this.yradius = this.yradius;
    }

    public void init() {
        IVecI[] iVecIArray = ICircleGeo.circleCP(this.center.get(), this.normal.get(), null, this.xradius.x(), this.yradius.x());
        super.init(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleKnots());
    }

    public void initApprox() {
        IVecI[] iVecIArray = ICircleGeo.circleCPApprox(this.center.get(), this.normal.get(), null, this.xradius.x(), this.yradius.x());
        super.init(iVecIArray, ICircleGeo.circleDeg());
    }

    public ICircleGeo update(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        this.center = iVecI;
        this.normal = iVecI2;
        this.xradius = iDoubleI;
        this.yradius = iDoubleI2;
        if (bl) {
            IVecI[] iVecIArray = ICircleGeo.circleCPApprox(iVecI.get(), iVecI2.get(), null, iDoubleI.x(), iDoubleI2.x());
            if (iVecIArray.length == this.cpNum()) {
                this.cps(iVecIArray);
            } else {
                super.init(iVecIArray, ICircleGeo.circleDeg());
            }
        } else {
            IVecI[] iVecIArray = ICircleGeo.circleCP(iVecI.get(), iVecI2.get(), null, iDoubleI.x(), iDoubleI2.x());
            if (iVecIArray.length == this.cpNum()) {
                this.cps(iVecIArray);
            } else {
                super.init(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleKnots());
            }
        }
        return this;
    }

    public ICircleGeo update(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        if (bl) {
            IVecI[] iVecIArray = ICircleGeo.circleCPApprox(iVecI.get(), iVecI2.get(), iVecI3.get(), iDoubleI.x(), iDoubleI2.x());
            if (iVecIArray.length == this.cpNum()) {
                this.cps(iVecIArray);
            } else {
                super.init(iVecIArray, ICircleGeo.circleDeg());
            }
        } else {
            IVecI[] iVecIArray = ICircleGeo.circleCP(iVecI.get(), iVecI2.get(), null, iDoubleI.x(), iDoubleI2.x());
            if (iVecIArray.length == this.cpNum()) {
                this.cps(iVecIArray);
            } else {
                super.init(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleKnots());
            }
        }
        return this;
    }

    public ICircleGeo update(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        if (bl) {
            IVecI[] iVecIArray = ICircleGeo.ovalCPApprox(iVecI.get(), iVecI2.get(), iVecI3.get());
            if (iVecIArray.length == this.cpNum()) {
                this.cps(iVecIArray);
            } else {
                super.init(iVecIArray, ICircleGeo.circleDeg());
            }
        } else {
            IVecI[] iVecIArray = ICircleGeo.ovalCP(iVecI.get(), iVecI2.get(), iVecI3.get());
            if (iVecIArray.length == this.cpNum()) {
                this.cps(iVecIArray);
            } else {
                super.init(iVecIArray, ICircleGeo.circleDeg(), ICircleGeo.circleKnots());
            }
        }
        return this;
    }

    public ICircleGeo cps(IVecI[] iVecIArray) {
        for (int i = 0; i < this.cpNum() && i < iVecIArray.length; ++i) {
            this.cp(i).set(iVecIArray[i]);
        }
        return this;
    }

    @Override
    public IVec center() {
        return this.center.get();
    }

    public ICircleGeo center(IVecI iVecI) {
        this.update(iVecI, this.normal, this.xradius, this.yradius, false);
        return this;
    }

    public IVec nml() {
        return this.normal.get();
    }

    public ICircleGeo nml(IVec iVec) {
        this.update(this.center, this.normal, this.xradius, this.yradius, false);
        return this;
    }

    public double radius() {
        return this.xradius.x();
    }

    public ICircleGeo radius(double d) {
        IDouble iDouble = new IDouble(d);
        this.update(this.center, this.normal, iDouble, iDouble, false);
        return this;
    }

    public ICircleGeo radius(IDoubleI iDoubleI) {
        this.update(this.center, this.normal, iDoubleI, iDoubleI, false);
        return this;
    }

    public double xradius() {
        return this.xradius.x();
    }

    public ICircleGeo xradius(double d) {
        this.update(this.center, this.normal, new IDouble(d), this.yradius, false);
        return this;
    }

    public ICircleGeo xradius(IDoubleI iDoubleI) {
        this.update(this.center, this.normal, iDoubleI, this.yradius, false);
        return this;
    }

    public double yradius() {
        return this.xradius.x();
    }

    public ICircleGeo yradius(double d) {
        this.update(this.center, this.normal, this.xradius, new IDouble(d), false);
        return this;
    }

    public ICircleGeo yradius(IDoubleI iDoubleI) {
        this.update(this.center, this.normal, this.xradius, iDoubleI, false);
        return this;
    }
}

