/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IDouble;
import igeo.IParameterObject;
import igeo.IServerI;
import igeo.IVecI;

public class INurbsGeo
extends IParameterObject {
    INurbsGeo() {
    }

    INurbsGeo(IServerI iServerI) {
        if (iServerI != null) {
            this.createObject(iServerI);
        }
    }

    public static void normalizeKnots(double[] dArray, double d, double d2) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n2] = dArray[n2] - d;
            int n3 = n++;
            dArray[n3] = dArray[n3] / (d2 - d);
        }
    }

    public static double[] createKnots(int n, int n2, boolean bl) {
        if (bl) {
            return INurbsGeo.createClosedKnots(n, n2);
        }
        return INurbsGeo.createKnots(n, n2);
    }

    public static double[] createKnots(int n, int n2) {
        int n3;
        double[] dArray = new double[n + n2 + 1];
        double d = 1.0 / (double)(n2 - n);
        for (n3 = 0; n3 <= n; ++n3) {
            dArray[n3] = 0.0;
        }
        int n4 = 1;
        while (n3 < n2) {
            dArray[n3] = (double)n4 * d;
            ++n3;
            ++n4;
        }
        while (n3 <= n + n2) {
            dArray[n3] = 1.0;
            ++n3;
        }
        return dArray;
    }

    public static double[] createClosedKnots(int n, int n2) {
        double[] dArray = new double[n + n2 + 1];
        double d = 1.0 / (double)(n2 - n);
        int n3 = 0;
        int n4 = -n;
        while (n3 <= n + n2) {
            dArray[n3] = (double)n4 * d;
            ++n3;
            ++n4;
        }
        return dArray;
    }

    public static IVecI[] createClosedCP(IVecI[] iVecIArray, int n) {
        int n2 = (n - 1) / 2;
        int n3 = n / 2 + 1;
        int n4 = iVecIArray.length;
        if (iVecIArray[0] == iVecIArray[iVecIArray.length - 1] || iVecIArray[0].eq(iVecIArray[iVecIArray.length - 1])) {
            if (iVecIArray[0] == iVecIArray[iVecIArray.length - 1]) {
                iVecIArray[iVecIArray.length - 1] = iVecIArray[0].dup();
            }
            if (n == 1) {
                return iVecIArray;
            }
            --n4;
        }
        IVecI[] iVecIArray2 = new IVecI[n4 + n];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            iVecIArray2[i] = i < n2 ? iVecIArray[(i - n2 + n4) % n4].dup() : (i < iVecIArray2.length - n3 ? iVecIArray[i - n2] : iVecIArray[(i - (iVecIArray2.length - n3)) % n4].dup());
        }
        return iVecIArray2;
    }

    public static IVecI[][] createClosedCPInU(IVecI[][] iVecIArray, int n) {
        int n2;
        int n3 = (n - 1) / 2;
        int n4 = n / 2 + 1;
        int n5 = iVecIArray.length;
        int n6 = iVecIArray[0].length;
        boolean bl = true;
        for (n2 = 0; n2 < n6 && bl; ++n2) {
            if (iVecIArray[0][n2] == iVecIArray[n5 - 1][n2] || iVecIArray[0][n2].eq(iVecIArray[n5 - 1][n2])) continue;
            bl = false;
        }
        if (bl) {
            if (n == 1) {
                for (n2 = 0; n2 < n6; ++n2) {
                    if (iVecIArray[0][n2] != iVecIArray[n5 - 1][n2]) continue;
                    iVecIArray[n5 - 1][n2] = iVecIArray[0][n2].dup();
                }
                return iVecIArray;
            }
            --n5;
        }
        IVecI[][] iVecIArray2 = new IVecI[n5 + n][n6];
        for (int i = 0; i < iVecIArray2.length; ++i) {
            for (int j = 0; j < n6; ++j) {
                iVecIArray2[i][j] = i < n3 ? iVecIArray[(i - n3 + n5) % n5][j].dup() : (i < iVecIArray2.length - n4 ? iVecIArray[i - n3][j] : iVecIArray[(i - (iVecIArray2.length - n4)) % n5][j].dup());
            }
        }
        return iVecIArray2;
    }

    public static IVecI[][] createClosedCPInV(IVecI[][] iVecIArray, int n) {
        int n2;
        int n3 = (n - 1) / 2;
        int n4 = n / 2 + 1;
        int n5 = iVecIArray.length;
        int n6 = iVecIArray[0].length;
        boolean bl = true;
        for (n2 = 0; n2 < n5 && bl; ++n2) {
            if (iVecIArray[n2][0] == iVecIArray[n2][n6 - 1] || iVecIArray[n2][0].eq(iVecIArray[n2][n6 - 1])) continue;
            bl = false;
        }
        if (bl) {
            if (n == 1) {
                for (n2 = 0; n2 < n5; ++n2) {
                    if (iVecIArray[n2][0] != iVecIArray[n2][n6 - 1]) continue;
                    iVecIArray[n2][n6 - 1] = iVecIArray[n2][0].dup();
                }
                return iVecIArray;
            }
            --n6;
        }
        IVecI[][] iVecIArray2 = new IVecI[n5][n6 + n];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < iVecIArray2[i].length; ++j) {
                iVecIArray2[i][j] = j < n3 ? iVecIArray[i][(j - n3 + n6) % n6].dup() : (j < iVecIArray2[i].length - n4 ? iVecIArray[i][j - n3] : iVecIArray[i][(j - (iVecIArray2[i].length - n4)) % n6].dup());
            }
        }
        return iVecIArray2;
    }

    public static boolean isUClosed(IVecI[][][] iVecIArray) {
        int n = iVecIArray.length;
        int n2 = iVecIArray[0].length;
        int n3 = iVecIArray[0][0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (iVecIArray[0][i][j] == iVecIArray[n - 1][i][j] || iVecIArray[0][i][j].eq(iVecIArray[n - 1][i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isVClosed(IVecI[][][] iVecIArray) {
        int n = iVecIArray.length;
        int n2 = iVecIArray[0].length;
        int n3 = iVecIArray[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (iVecIArray[i][0][j] == iVecIArray[i][n2 - 1][j] || iVecIArray[i][0][j].eq(iVecIArray[i][n2 - 1][j])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isWClosed(IVecI[][][] iVecIArray) {
        int n = iVecIArray.length;
        int n2 = iVecIArray[0].length;
        int n3 = iVecIArray[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (iVecIArray[i][j][0] == iVecIArray[i][j][n3 - 1] || iVecIArray[i][j][0].eq(iVecIArray[i][j][n3 - 1])) continue;
                return false;
            }
        }
        return true;
    }

    public static IVecI[][][] createClosedCPInU(IVecI[][][] iVecIArray, int n) {
        int n2 = (n - 1) / 2;
        int n3 = n / 2 + 1;
        int n4 = iVecIArray.length;
        int n5 = iVecIArray[0].length;
        int n6 = iVecIArray[0][0].length;
        if (INurbsGeo.isUClosed(iVecIArray)) {
            if (n == 1) {
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        if (iVecIArray[0][i][j] != iVecIArray[n4 - 1][i][j]) continue;
                        iVecIArray[n4 - 1][i][j] = iVecIArray[0][i][j].dup();
                    }
                }
                return iVecIArray;
            }
            --n4;
        }
        int n7 = n4 + n;
        IVecI[][][] iVecIArray2 = new IVecI[n7][n5][n6];
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n6; ++k) {
                    iVecIArray2[i][j][k] = i < n2 ? iVecIArray[(i - n2 + n4) % n4][j][k].dup() : (i < n7 - n3 ? iVecIArray[i - n2][j][k] : iVecIArray[(i - (n7 - n3)) % n4][j][k].dup());
                }
            }
        }
        return iVecIArray2;
    }

    public static IVecI[][][] createClosedCPInV(IVecI[][][] iVecIArray, int n) {
        int n2 = (n - 1) / 2;
        int n3 = n / 2 + 1;
        int n4 = iVecIArray.length;
        int n5 = iVecIArray[0].length;
        int n6 = iVecIArray[0][0].length;
        if (INurbsGeo.isVClosed(iVecIArray)) {
            if (n == 1) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        if (iVecIArray[i][0][j] != iVecIArray[i][n5 - 1][j]) continue;
                        iVecIArray[i][n5 - 1][j] = iVecIArray[i][0][j].dup();
                    }
                }
                return iVecIArray;
            }
            --n5;
        }
        int n7 = n5 + n;
        IVecI[][][] iVecIArray2 = new IVecI[n4][n7][n6];
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = 0; k < n6; ++k) {
                    iVecIArray2[j][i][k] = i < n2 ? iVecIArray[j][(i - n2 + n5) % n5][k].dup() : (i < n7 - n3 ? iVecIArray[j][i - n2][k] : iVecIArray[j][(i - (n7 - n3)) % n5][k].dup());
                }
            }
        }
        return iVecIArray2;
    }

    public static IVecI[][][] createClosedCPInW(IVecI[][][] iVecIArray, int n) {
        int n2 = (n - 1) / 2;
        int n3 = n / 2 + 1;
        int n4 = iVecIArray.length;
        int n5 = iVecIArray[0].length;
        int n6 = iVecIArray[0][0].length;
        if (INurbsGeo.isWClosed(iVecIArray)) {
            if (n == 1) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        if (iVecIArray[i][j][0] != iVecIArray[i][j][n6 - 1]) continue;
                        iVecIArray[i][j][n6 - 1] = iVecIArray[i][j][0].dup();
                    }
                }
                return iVecIArray;
            }
            --n5;
        }
        int n7 = n6 + n;
        IVecI[][][] iVecIArray2 = new IVecI[n4][n5][n7];
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n4; ++k) {
                    iVecIArray2[k][j][i] = i < n2 ? iVecIArray[k][j][(i - n2 + n6) % n6].dup() : (i < n7 - n3 ? iVecIArray[k][j][i - n2] : iVecIArray[k][j][(i - (n7 - n3)) % n6].dup());
                }
            }
        }
        return iVecIArray2;
    }

    public static boolean isValidKnots(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (IDouble.isValid(dArray[i])) continue;
            return false;
        }
        return true;
    }

    public static double[] invertKnots(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = 1.0 - dArray[dArray.length - 1 - i];
        }
        return dArray2;
    }
}

