/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBSplineBasisFunction;
import igeo.IBool;
import igeo.IConfig;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IEntityParameter;
import igeo.IInteger;
import igeo.IIntegerI;
import igeo.IMatrix3I;
import igeo.IMatrix4I;
import igeo.INurbsGeo;
import igeo.IOut;
import igeo.ISwitchE;
import igeo.ISwitchR;
import igeo.IVec;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;
import igeo.IVolumeI;
import java.util.ArrayList;

public class IVolumeGeo
extends INurbsGeo
implements IVolumeI,
IEntityParameter {
    public IVecI[][][] controlPoints;
    public int udegree;
    public int vdegree;
    public int wdegree;
    public double[] uknots;
    public double[] vknots;
    public double[] wknots;
    public double ustart;
    public double uend;
    public double vstart;
    public double vend;
    public double wstart;
    public double wend;
    public boolean[][][] defaultWeights;
    public IBSplineBasisFunction basisFunctionU;
    public IBSplineBasisFunction basisFunctionV;
    public IBSplineBasisFunction basisFunctionW;
    public IBSplineBasisFunction derivativeFunctionU;
    public IBSplineBasisFunction derivativeFunctionV;
    public IBSplineBasisFunction derivativeFunctionW;

    public IVolumeGeo() {
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, double d, double d2, double d3, double d4, double d5, double d6) {
        this.ustart = d;
        this.uend = d2;
        this.vstart = d3;
        this.vend = d4;
        this.wstart = d5;
        this.wend = d6;
        if (d != 0.0 || d2 != 1.0) {
            IVolumeGeo.normalizeKnots(dArray, d, d2);
        }
        if (d3 != 0.0 || d4 != 1.0) {
            IVolumeGeo.normalizeKnots(dArray2, d3, d4);
        }
        if (d5 != 0.0 || d6 != 1.0) {
            IVolumeGeo.normalizeKnots(dArray3, d5, d6);
        }
        this.init(iVecIArray, n, n2, n3, dArray, dArray2, dArray3);
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        this.ustart = dArray[0];
        this.uend = dArray[dArray.length - 1];
        this.vstart = dArray2[0];
        this.vend = dArray2[dArray2.length - 1];
        this.wstart = dArray3[0];
        this.wend = dArray3[dArray3.length - 1];
        if (dArray[0] != 0.0 || dArray[dArray.length - 1] != 1.0) {
            IVolumeGeo.normalizeKnots(dArray, dArray[0], dArray[dArray.length - 1]);
        }
        if (dArray2[0] != 0.0 || dArray2[dArray2.length - 1] != 1.0) {
            IVolumeGeo.normalizeKnots(dArray2, dArray2[0], dArray2[dArray2.length - 1]);
        }
        if (dArray3[0] != 0.0 || dArray3[dArray3.length - 1] != 1.0) {
            IVolumeGeo.normalizeKnots(dArray3, dArray3[0], dArray3[dArray2.length - 1]);
        }
        this.init(iVecIArray, n, n2, n3, dArray, dArray2, dArray3);
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, int n, int n2, int n3) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, n, n2, n3, IVolumeGeo.createKnots(n, iVecIArray.length), IVolumeGeo.createKnots(n2, iVecIArray[0].length), IVolumeGeo.createKnots(n3, iVecIArray[0][0].length));
    }

    public IVolumeGeo(IVecI[][][] iVecIArray) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, 1, 1, 1, IVolumeGeo.createKnots(1, iVecIArray.length), IVolumeGeo.createKnots(1, iVecIArray[0].length), IVolumeGeo.createKnots(1, iVecIArray[0][0].length));
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, n, n2, n3, bl, bl2, bl3);
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, int n, int n2, int n3, boolean bl, double[] dArray, double[] dArray2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, n, n2, n3, bl, dArray, dArray2);
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, boolean bl, double[] dArray2) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, n, n2, n3, dArray, bl, dArray2);
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, double[] dArray2, boolean bl) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, n, n2, n3, dArray, dArray2, bl);
    }

    public IVolumeGeo(IVecI[][][] iVecIArray, boolean bl, boolean bl2, boolean bl3) {
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, 1, 1, 1, bl, bl2, bl3);
    }

    public IVolumeGeo(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6, IVecI iVecI7, IVecI iVecI8) {
        IVecI[][][] iVecIArray = new IVecI[2][2][2];
        iVecIArray[0][0][0] = iVecI;
        iVecIArray[1][0][0] = iVecI2;
        iVecIArray[0][1][0] = iVecI3;
        iVecIArray[1][1][0] = iVecI4;
        iVecIArray[0][0][1] = iVecI5;
        iVecIArray[1][0][1] = iVecI6;
        iVecIArray[0][1][1] = iVecI7;
        iVecIArray[1][1][1] = iVecI8;
        this.ustart = 0.0;
        this.uend = 1.0;
        this.vstart = 0.0;
        this.vend = 1.0;
        this.wstart = 0.0;
        this.wend = 1.0;
        this.init(iVecIArray, 1, 1, 1, IVolumeGeo.createKnots(1, 2), IVolumeGeo.createKnots(1, 2), IVolumeGeo.createKnots(1, 2));
    }

    public IVolumeGeo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20, double d21, double d22, double d23, double d24) {
        this(new IVec(d, d2, d3), new IVec(d4, d5, d6), new IVec(d7, d8, d9), new IVec(d10, d11, d12), new IVec(d13, d14, d15), new IVec(d16, d17, d18), new IVec(d19, d20, d21), new IVec(d22, d23, d24));
    }

    public IVolumeGeo(double[][][][] dArray) {
        this(IVolumeGeo.getPointsFromArray(dArray));
    }

    public IVolumeGeo(double[][][][] dArray, int n, int n2, int n3) {
        this((IVecI[][][])IVolumeGeo.getPointsFromArray(dArray), n, n2, n3);
    }

    public IVolumeGeo(double[][][][] dArray, boolean bl, boolean bl2, boolean bl3) {
        this((IVecI[][][])IVolumeGeo.getPointsFromArray(dArray), bl, bl2, bl3);
    }

    public IVolumeGeo(double[][][][] dArray, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this((IVecI[][][])IVolumeGeo.getPointsFromArray(dArray), n, n2, n3, bl, bl2, bl3);
    }

    public IVolumeGeo(IVolumeGeo iVolumeGeo) {
        this.controlPoints = new IVecI[iVolumeGeo.controlPoints.length][iVolumeGeo.controlPoints[0].length][iVolumeGeo.controlPoints[0][0].length];
        for (int i = 0; i < this.controlPoints.length; ++i) {
            for (int j = 0; j < this.controlPoints[0].length; ++j) {
                for (int k = 0; k < this.controlPoints[0][0].length; ++k) {
                    this.controlPoints[i][j][k] = iVolumeGeo.controlPoints[i][j][k].dup();
                }
            }
        }
        this.uknots = new double[iVolumeGeo.uknots.length];
        System.arraycopy(iVolumeGeo.uknots, 0, this.uknots, 0, this.uknots.length);
        this.vknots = new double[iVolumeGeo.vknots.length];
        System.arraycopy(iVolumeGeo.vknots, 0, this.vknots, 0, this.vknots.length);
        this.wknots = new double[iVolumeGeo.wknots.length];
        System.arraycopy(iVolumeGeo.wknots, 0, this.wknots, 0, this.wknots.length);
        this.udegree = iVolumeGeo.udegree;
        this.vdegree = iVolumeGeo.vdegree;
        this.wdegree = iVolumeGeo.wdegree;
        this.ustart = iVolumeGeo.ustart;
        this.uend = iVolumeGeo.uend;
        this.vstart = iVolumeGeo.vstart;
        this.vend = iVolumeGeo.vend;
        this.wstart = iVolumeGeo.wstart;
        this.wend = iVolumeGeo.wend;
        this.init(this.controlPoints, this.udegree, this.vdegree, this.vdegree, this.uknots, this.vknots, this.wknots);
    }

    public void init(IVecI[][][] iVecIArray, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl2) {
                if (bl3) {
                    iVecIArray = IVolumeGeo.createClosedCPInW(iVecIArray, n3);
                    iVecIArray = IVolumeGeo.createClosedCPInV(iVecIArray, n2);
                    iVecIArray = IVolumeGeo.createClosedCPInU(iVecIArray, n);
                    this.init(iVecIArray, n, n2, n3, IVolumeGeo.createClosedKnots(n, iVecIArray.length), IVolumeGeo.createClosedKnots(n2, iVecIArray[0].length), IVolumeGeo.createClosedKnots(n3, iVecIArray[0][0].length));
                } else {
                    iVecIArray = IVolumeGeo.createClosedCPInV(iVecIArray, n2);
                    iVecIArray = IVolumeGeo.createClosedCPInU(iVecIArray, n);
                    this.init(iVecIArray, n, n2, n3, IVolumeGeo.createClosedKnots(n, iVecIArray.length), IVolumeGeo.createClosedKnots(n2, iVecIArray[0].length), IVolumeGeo.createKnots(n3, iVecIArray[0][0].length));
                }
            } else if (bl3) {
                iVecIArray = IVolumeGeo.createClosedCPInU(iVecIArray, n);
                iVecIArray = IVolumeGeo.createClosedCPInW(iVecIArray, n3);
                this.init(iVecIArray, n, n2, n3, IVolumeGeo.createClosedKnots(n, iVecIArray.length), IVolumeGeo.createKnots(n2, iVecIArray[0].length), IVolumeGeo.createClosedKnots(n3, iVecIArray[0][0].length));
            } else {
                iVecIArray = IVolumeGeo.createClosedCPInU(iVecIArray, n);
                this.init(iVecIArray, n, n2, n3, IVolumeGeo.createClosedKnots(n, iVecIArray.length), IVolumeGeo.createKnots(n2, iVecIArray[0].length), IVolumeGeo.createKnots(n3, iVecIArray[0][0].length));
            }
        } else if (bl2) {
            if (bl3) {
                iVecIArray = IVolumeGeo.createClosedCPInW(iVecIArray, n3);
                iVecIArray = IVolumeGeo.createClosedCPInV(iVecIArray, n2);
                this.init(iVecIArray, n, n2, n3, IVolumeGeo.createKnots(n, iVecIArray.length), IVolumeGeo.createClosedKnots(n2, iVecIArray[0].length), IVolumeGeo.createClosedKnots(n3, iVecIArray[0][0].length));
            } else {
                iVecIArray = IVolumeGeo.createClosedCPInV(iVecIArray, n2);
                this.init(iVecIArray, n, n2, n3, IVolumeGeo.createKnots(n, iVecIArray.length), IVolumeGeo.createClosedKnots(n2, iVecIArray[0].length), IVolumeGeo.createKnots(n3, iVecIArray[0][0].length));
            }
        } else if (bl3) {
            iVecIArray = IVolumeGeo.createClosedCPInW(iVecIArray, n3);
            this.init(iVecIArray, n, n2, n3, IVolumeGeo.createKnots(n, iVecIArray.length), IVolumeGeo.createKnots(n2, iVecIArray[0].length), IVolumeGeo.createClosedKnots(n3, iVecIArray[0][0].length));
        } else {
            this.init(iVecIArray, n, n2, n3, IVolumeGeo.createKnots(n, iVecIArray.length), IVolumeGeo.createKnots(n2, iVecIArray[0].length), IVolumeGeo.createKnots(n3, iVecIArray[0][0].length));
        }
    }

    public void init(IVecI[][][] iVecIArray, int n, int n2, int n3, boolean bl, double[] dArray, double[] dArray2) {
        if (bl) {
            iVecIArray = IVolumeGeo.createClosedCPInU(iVecIArray, n);
            this.init(iVecIArray, n, n2, n3, IVolumeGeo.createClosedKnots(n, iVecIArray.length), dArray, dArray2);
        } else {
            this.init(iVecIArray, n, n2, n3, IVolumeGeo.createKnots(n, iVecIArray.length), dArray, dArray2);
        }
    }

    public void init(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, boolean bl, double[] dArray2) {
        if (bl) {
            iVecIArray = IVolumeGeo.createClosedCPInV(iVecIArray, n2);
            this.init(iVecIArray, n, n2, n3, dArray, IVolumeGeo.createClosedKnots(n2, iVecIArray[0].length), dArray2);
        } else {
            this.init(iVecIArray, n, n2, n3, dArray, IVolumeGeo.createKnots(n2, iVecIArray[0].length), dArray2);
        }
    }

    public void init(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, double[] dArray2, boolean bl) {
        if (bl) {
            iVecIArray = IVolumeGeo.createClosedCPInW(iVecIArray, n3);
            this.init(iVecIArray, n, n2, n3, dArray, dArray2, IVolumeGeo.createClosedKnots(n3, iVecIArray[0][0].length));
        } else {
            this.init(iVecIArray, n, n2, n3, dArray, dArray2, IVolumeGeo.createKnots(n3, iVecIArray[0][0].length));
        }
    }

    public void init(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        if (IConfig.checkValidControlPoint) {
            IVolumeGeo.isValidCP(iVecIArray, n, n2, n3, dArray, dArray2, dArray3);
        }
        if (IConfig.checkDuplicatedControlPoint) {
            IVolumeGeo.checkDuplicatedCP(iVecIArray);
        } else if (IConfig.checkDuplicatedControlPointOnEdge) {
            IVolumeGeo.checkDuplicatedCPOnFace(iVecIArray);
        }
        this.controlPoints = iVecIArray;
        this.udegree = n;
        this.vdegree = n2;
        this.wdegree = n3;
        this.uknots = dArray;
        this.vknots = dArray2;
        this.wknots = dArray3;
        this.basisFunctionU = new IBSplineBasisFunction(n, dArray);
        this.basisFunctionV = new IBSplineBasisFunction(n2, dArray2);
        this.basisFunctionW = new IBSplineBasisFunction(n3, dArray3);
        this.defaultWeights = new boolean[iVecIArray.length][iVecIArray[0].length][iVecIArray[0][0].length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray[0].length; ++j) {
                for (int k = 0; k < iVecIArray[0][0].length; ++k) {
                    this.defaultWeights[i][j][k] = !(iVecIArray[i][j][k] instanceof IVec4I);
                }
            }
        }
    }

    public IVecI[] serializeMatrix(IVecI[][][] iVecIArray) {
        ArrayList<IVecI> arrayList = new ArrayList<IVecI>();
        arrayList.add(iVecIArray[0][0][0]);
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                for (int k = 0; k < iVecIArray[i][j].length; ++k) {
                    arrayList.add(iVecIArray[i][j][k]);
                }
            }
        }
        return arrayList.toArray(new IVecI[arrayList.size()]);
    }

    @Override
    public boolean isValid() {
        return IVolumeGeo.isValidCP(this.controlPoints, this.udegree, this.vdegree, this.wdegree, this.uknots, this.vknots, this.wknots);
    }

    public static boolean isValidCP(IVecI[][][] iVecIArray, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3) {
        if (iVecIArray == null) {
            IOut.err("control points are null");
            return false;
        }
        if (dArray == null) {
            IOut.err("uknots are null");
            return false;
        }
        if (dArray2 == null) {
            IOut.err("vknots are null");
            return false;
        }
        if (n <= 0) {
            IOut.err("invalid udeg (" + n + ")");
            return false;
        }
        if (n2 <= 0) {
            IOut.err("invalid vdeg (" + n2 + ")");
            return false;
        }
        int n4 = iVecIArray.length;
        int n5 = iVecIArray[0].length;
        int n6 = iVecIArray[0][0].length;
        for (int i = 1; i < n4; ++i) {
            if (iVecIArray[i].length != n5) {
                IOut.err("vnum(" + n5 + ") in control point array is inconsistent (" + iVecIArray[i].length + ")");
                return false;
            }
            for (int j = 1; j < n5; ++j) {
                if (iVecIArray[i][j].length == n6) continue;
                IOut.err("wnum(" + n6 + ") in control point array is inconsistent (" + iVecIArray[i][j].length + ")");
                return false;
            }
        }
        if (n4 <= n) {
            IOut.err("too less control points in u direction (" + n4 + ") for u degree " + n + ". it needs minimum " + (n + 1));
            return false;
        }
        if (n5 <= n2) {
            IOut.err("too less control points in v direction (" + n5 + ") for v degree " + n2 + ". it needs minimum " + (n2 + 1));
            return false;
        }
        if (n6 <= n3) {
            IOut.err("too less control points in w direction (" + n6 + ") for w degree " + n3 + ". it needs minimum " + (n3 + 1));
            return false;
        }
        if (dArray.length != n + n4 + 1) {
            IOut.err("uknot array length is invalid. it needs to be " + (n + n4 + 1));
            return false;
        }
        if (dArray2.length != n2 + n5 + 1) {
            IOut.err("vknot array length is invalid. it needs to be " + (n2 + n5 + 1));
            return false;
        }
        if (dArray3.length != n3 + n6 + 1) {
            IOut.err("wknot array length is invalid. it needs to be " + (n3 + n6 + 1));
            return false;
        }
        if (!IVolumeGeo.isValidCP(iVecIArray)) {
            return false;
        }
        if (!IVolumeGeo.isValidKnots(dArray)) {
            IOut.err("uknot has invalid value");
            return false;
        }
        if (!IVolumeGeo.isValidKnots(dArray2)) {
            IOut.err("vknot has invalid value");
            return false;
        }
        if (!IVolumeGeo.isValidKnots(dArray3)) {
            IOut.err("wknot has invalid value");
            return false;
        }
        return true;
    }

    public static boolean isValidCP(IVecI[][][] iVecIArray) {
        if (iVecIArray == null) {
            IOut.err("controlPoint is null");
            return false;
        }
        for (int i = 0; i < iVecIArray.length; ++i) {
            if (iVecIArray[i] == null) {
                IOut.err("controlPoint[" + i + "] is null");
                return false;
            }
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                if (iVecIArray[i][j] == null) {
                    IOut.err("controlPoint[" + i + "][" + j + "] is null");
                    return false;
                }
                for (int k = 0; k < iVecIArray[i][j].length; ++k) {
                    if (iVecIArray[i][j][k] == null) {
                        IOut.err("controlPoint at " + i + "," + j + "," + k + " is null");
                        return false;
                    }
                    if (iVecIArray[i][j][k].isValid()) continue;
                    IOut.err("controlPoint at " + i + "," + j + "," + k + " is invalid");
                    return false;
                }
            }
        }
        return true;
    }

    public static void checkDuplicatedCP(IVecI[][][] iVecIArray) {
        int n = iVecIArray.length;
        int n2 = iVecIArray[0].length;
        int n3 = iVecIArray[0][0].length;
        int n4 = n * n2 * n3;
        for (int i = 0; i < n4; ++i) {
            for (int j = i + 1; j < n4; ++j) {
                if (iVecIArray[j / (n2 * n3)][j / n3 % n2][j % n3] != iVecIArray[i / (n2 * n3)][i / n3 % n2][i % n3]) continue;
                iVecIArray[j / (n2 * n3)][j / n3 % n2][j % n3] = iVecIArray[i / (n2 * n3)][i / n3 % n2][i % n3].dup();
            }
        }
    }

    public static void checkDuplicatedCP(IVecI[][][] iVecIArray, IVecI[] iVecIArray2) {
        for (int i = 0; i < iVecIArray.length; ++i) {
            for (int j = 0; j < iVecIArray[i].length; ++j) {
                for (int k = 0; k < iVecIArray[i][j].length; ++k) {
                    for (int i2 = 0; i2 < iVecIArray2.length; ++i2) {
                        if (iVecIArray2[i2] != iVecIArray[i][j][k]) continue;
                        iVecIArray2[i2] = iVecIArray2[i2].dup();
                    }
                }
            }
        }
    }

    public static void checkDuplicatedCPOnFace(IVecI[][][] iVecIArray) {
        int n;
        int n2;
        int n3 = iVecIArray.length;
        int n4 = iVecIArray[0].length;
        int n5 = iVecIArray[0][0].length;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (iVecIArray[n2][n][0] != iVecIArray[n2][n][n5 - 1]) continue;
                iVecIArray[n2][n][n5 - 1] = iVecIArray[n2][n][0].dup();
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n5; ++n) {
                if (iVecIArray[0][n2][n] != iVecIArray[n3 - 1][n2][n]) continue;
                iVecIArray[n3 - 1][n2][n] = iVecIArray[0][n2][n].dup();
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n3; ++n) {
                if (iVecIArray[n][0][n2] != iVecIArray[n][n4 - 1][n2]) continue;
                iVecIArray[n][n4 - 1][n2] = iVecIArray[n][0][n2].dup();
            }
        }
    }

    public static IVec[][][] getPointsFromArray(double[][][][] dArray) {
        IVec[][][] iVecArray = new IVec[dArray.length][dArray[0].length][dArray[0][0].length];
        for (int i = 0; i < iVecArray.length; ++i) {
            for (int j = 0; j < iVecArray[0].length; ++j) {
                for (int k = 0; k < iVecArray[0][0].length; ++k) {
                    if (dArray[i][j][k].length == 4) {
                        iVecArray[i][j][k] = new IVec4(dArray[i][j][k][0], dArray[i][j][k][1], dArray[i][j][k][2], dArray[i][j][k][3]);
                        continue;
                    }
                    iVecArray[i][j][k] = new IVec();
                    if (dArray[i][j][k].length >= 1) {
                        iVecArray[i][j][k].x = dArray[i][j][k][0];
                    }
                    if (dArray[i][j][k].length >= 2) {
                        iVecArray[i][j][k].y = dArray[i][j][k][1];
                    }
                    if (dArray[i][j][k].length < 3) continue;
                    iVecArray[i][j][k].z = dArray[i][j][k][2];
                }
            }
        }
        return iVecArray;
    }

    @Override
    public IVolumeGeo get() {
        return this;
    }

    @Override
    public IVolumeGeo dup() {
        return new IVolumeGeo(this);
    }

    @Override
    public IVec pt(IVecI iVecI) {
        IVec iVec = iVecI.get();
        return this.pt(iVec.x, iVec.y, iVec.z);
    }

    @Override
    public IVec pt(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.pt(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x());
    }

    @Override
    public IVec pt(double d, double d2, double d3) {
        IVec iVec = new IVec();
        this.pt(d, d2, d3, iVec);
        return iVec;
    }

    public void pt(double d, double d2, double d3, IVec iVec) {
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        int n3 = this.basisFunctionW.index(d3);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.basisFunctionW.eval(n3, d3);
        double d4 = 0.0;
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                for (int k = 0; k <= this.wdegree; ++k) {
                    IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k].get();
                    double d5 = 1.0;
                    if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k]) {
                        d5 = ((IVec4)iVec2).w;
                    }
                    iVec.x += iVec2.x * d5 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec.y += iVec2.y * d5 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec.z += iVec2.z * d5 * dArray[i] * dArray2[j] * dArray3[k];
                    d4 += d5 * dArray[i] * dArray2[j] * dArray3[k];
                }
            }
        }
        iVec.x /= d4;
        iVec.y /= d4;
        iVec.z /= d4;
    }

    public IVec pt(IVec iVec) {
        return this.pt(iVec.x, iVec.y, iVec.z);
    }

    @Override
    public IVec utan(IVecI iVecI) {
        IVec iVec = iVecI.get();
        return this.utan(iVec.x, iVec.y, iVec.z);
    }

    @Override
    public IVec utan(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.utan(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x());
    }

    @Override
    public IVec utan(double d, double d2, double d3) {
        IVec iVec = new IVec();
        this.utan(d, d2, d3, iVec);
        return iVec;
    }

    public void utan(double d, double d2, double d3, IVec iVec) {
        if (this.derivativeFunctionU == null) {
            this.derivativeFunctionU = new IBSplineBasisFunction(this.basisFunctionU);
            this.derivativeFunctionU.differentiate();
        }
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        int n3 = this.basisFunctionW.index(d3);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.basisFunctionW.eval(n3, d3);
        double[] dArray4 = this.derivativeFunctionU.eval(n, d);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                for (int k = 0; k <= this.wdegree; ++k) {
                    IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k].get();
                    double d4 = 1.0;
                    if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k]) {
                        d4 = ((IVec4)iVec2).w;
                    }
                    iVec4.x += iVec2.x * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.y += iVec2.y * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.z += iVec2.z * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.w += d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec42.x += iVec2.x * d4 * dArray4[i] * dArray2[j] * dArray3[k];
                    iVec42.y += iVec2.y * d4 * dArray4[i] * dArray2[j] * dArray3[k];
                    iVec42.z += iVec2.z * d4 * dArray4[i] * dArray2[j] * dArray3[k];
                    iVec42.w += d4 * dArray4[i] * dArray2[j] * dArray3[k];
                }
            }
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    @Override
    public IVec vtan(IVecI iVecI) {
        IVec iVec = iVecI.get();
        return this.vtan(iVec.x, iVec.y, iVec.z);
    }

    @Override
    public IVec vtan(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.vtan(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x());
    }

    @Override
    public IVec vtan(double d, double d2, double d3) {
        IVec iVec = new IVec();
        this.vtan(d, d2, d3, iVec);
        return iVec;
    }

    public void vtan(double d, double d2, double d3, IVec iVec) {
        if (this.derivativeFunctionV == null) {
            this.derivativeFunctionV = new IBSplineBasisFunction(this.basisFunctionV);
            this.derivativeFunctionV.differentiate();
        }
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        int n3 = this.basisFunctionW.index(d3);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.basisFunctionW.eval(n3, d3);
        double[] dArray4 = this.derivativeFunctionV.eval(n2, d2);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                for (int k = 0; k <= this.wdegree; ++k) {
                    IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k].get();
                    double d4 = 1.0;
                    if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k]) {
                        d4 = ((IVec4)iVec2).w;
                    }
                    iVec4.x += iVec2.x * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.y += iVec2.y * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.z += iVec2.z * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.w += d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec42.x += iVec2.x * d4 * dArray[i] * dArray4[j] * dArray3[k];
                    iVec42.y += iVec2.y * d4 * dArray[i] * dArray4[j] * dArray3[k];
                    iVec42.z += iVec2.z * d4 * dArray[i] * dArray4[j] * dArray3[k];
                    iVec42.w += d4 * dArray[i] * dArray4[j] * dArray3[k];
                }
            }
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    @Override
    public IVec wtan(IVecI iVecI) {
        IVec iVec = iVecI.get();
        return this.wtan(iVec.x, iVec.y, iVec.z);
    }

    @Override
    public IVec wtan(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.wtan(iDoubleI.x(), iDoubleI2.x(), iDoubleI3.x());
    }

    @Override
    public IVec wtan(double d, double d2, double d3) {
        IVec iVec = new IVec();
        this.wtan(d, d2, d3, iVec);
        return iVec;
    }

    public void wtan(double d, double d2, double d3, IVec iVec) {
        if (this.derivativeFunctionW == null) {
            this.derivativeFunctionW = new IBSplineBasisFunction(this.basisFunctionW);
            this.derivativeFunctionW.differentiate();
        }
        int n = this.basisFunctionU.index(d);
        int n2 = this.basisFunctionV.index(d2);
        int n3 = this.basisFunctionW.index(d3);
        double[] dArray = this.basisFunctionU.eval(n, d);
        double[] dArray2 = this.basisFunctionV.eval(n2, d2);
        double[] dArray3 = this.basisFunctionW.eval(n3, d3);
        double[] dArray4 = this.derivativeFunctionW.eval(n3, d3);
        IVec4 iVec4 = new IVec4();
        IVec4 iVec42 = new IVec4();
        for (int i = 0; i <= this.udegree; ++i) {
            for (int j = 0; j <= this.vdegree; ++j) {
                for (int k = 0; k <= this.wdegree; ++k) {
                    IVec iVec2 = this.controlPoints[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k].get();
                    double d4 = 1.0;
                    if (!this.defaultWeights[n - this.udegree + i][n2 - this.vdegree + j][n3 - this.wdegree + k]) {
                        d4 = ((IVec4)iVec2).w;
                    }
                    iVec4.x += iVec2.x * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.y += iVec2.y * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.z += iVec2.z * d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec4.w += d4 * dArray[i] * dArray2[j] * dArray3[k];
                    iVec42.x += iVec2.x * d4 * dArray[i] * dArray2[j] * dArray4[k];
                    iVec42.y += iVec2.y * d4 * dArray[i] * dArray2[j] * dArray4[k];
                    iVec42.z += iVec2.z * d4 * dArray[i] * dArray2[j] * dArray4[k];
                    iVec42.w += d4 * dArray[i] * dArray2[j] * dArray4[k];
                }
            }
        }
        iVec4.x *= iVec42.w;
        iVec4.y *= iVec42.w;
        iVec4.z *= iVec42.w;
        iVec42.x *= iVec4.w;
        iVec42.y *= iVec4.w;
        iVec42.z *= iVec4.w;
        iVec4.w *= iVec4.w;
        iVec.x = (iVec42.x - iVec4.x) / iVec4.w;
        iVec.y = (iVec42.y - iVec4.y) / iVec4.w;
        iVec.z = (iVec42.z - iVec4.z) / iVec4.w;
    }

    @Override
    public IVecI cp(int n, int n2, int n3) {
        return this.controlPoints[n][n2][n3];
    }

    @Override
    public IVecI cp(IIntegerI iIntegerI, IIntegerI iIntegerI2, IIntegerI iIntegerI3) {
        return this.controlPoints[iIntegerI.x()][iIntegerI2.x()][iIntegerI3.x()];
    }

    @Override
    public IVecI[][][] cps() {
        return this.controlPoints;
    }

    @Override
    public IVec corner(int n, int n2, int n3) {
        if (n != 0) {
            n = 1;
        }
        if (n2 != 0) {
            n2 = 1;
        }
        if (n3 != 0) {
            n3 = 1;
        }
        return this.pt(n, n2, n3);
    }

    @Override
    public IVec corner(IIntegerI iIntegerI, IIntegerI iIntegerI2, IIntegerI iIntegerI3) {
        return this.corner(iIntegerI.x(), iIntegerI2.x(), iIntegerI3.x());
    }

    @Override
    public IVec cornerCP(int n, int n2, int n3) {
        if (n != 0) {
            n = this.ucpNum() - 1;
        }
        if (n2 != 0) {
            n2 = this.vcpNum() - 1;
        }
        if (n3 != 0) {
            n3 = this.wcpNum() - 1;
        }
        return this.controlPoints[n][n2][n3].get();
    }

    @Override
    public IVecI cornerCP(IIntegerI iIntegerI, IIntegerI iIntegerI2, IIntegerI iIntegerI3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (iIntegerI.x() != 0) {
            n = this.ucpNum() - 1;
        }
        if (iIntegerI2.x() != 0) {
            n2 = this.vcpNum() - 1;
        }
        if (iIntegerI3.x() != 0) {
            n3 = this.vcpNum() - 1;
        }
        return this.controlPoints[n][n2][n3];
    }

    @Override
    public IVec ep(int n, int n2, int n3) {
        return this.pt(this.uknots[n + this.udegree], this.vknots[n2 + this.vdegree], this.wknots[n3 + this.wdegree]);
    }

    @Override
    public IVec ep(IIntegerI iIntegerI, IIntegerI iIntegerI2, IIntegerI iIntegerI3) {
        return this.pt(this.uknots[iIntegerI.x() + this.udegree], this.vknots[iIntegerI2.x() + this.vdegree], this.wknots[iIntegerI3.x() + this.wdegree]);
    }

    @Override
    public IVec mid() {
        return this.pt(0.5, 0.5, 0.5);
    }

    @Override
    public IVec center() {
        int n = this.ucpNum();
        int n2 = this.vcpNum();
        int n3 = this.wcpNum();
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        if (this.wknots[0] != 0.0 || this.wknots[this.wknots.length - 1] != 1.0) {
            if (this.isWClosed()) {
                n6 = n3 - this.wdeg();
            }
        } else if (this.isWClosed()) {
            n6 = n3 - 1;
        }
        if (this.vknots[0] != 0.0 || this.vknots[this.vknots.length - 1] != 1.0) {
            if (this.isVClosed()) {
                n5 = n2 - this.vdeg();
            }
        } else if (this.isVClosed()) {
            n5 = n2 - 1;
        }
        if (this.uknots[0] != 0.0 || this.uknots[this.uknots.length - 1] != 1.0) {
            if (this.isUClosed()) {
                n4 = n - this.udeg();
            }
        } else if (this.isUClosed()) {
            n4 = n - 1;
        }
        IVec iVec = new IVec();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                for (int k = 0; k < n6; ++k) {
                    iVec.add(this.cp(i, j, k));
                }
            }
        }
        iVec.div(n4 * n5 * n6);
        return iVec;
    }

    @Override
    public double uknot(int n) {
        return this.uknots[n];
    }

    @Override
    public IDouble uknot(IIntegerI iIntegerI) {
        return new IDouble(this.uknots[iIntegerI.x()]);
    }

    @Override
    public double vknot(int n) {
        return this.vknots[n];
    }

    @Override
    public IDouble vknot(IIntegerI iIntegerI) {
        return new IDouble(this.vknots[iIntegerI.x()]);
    }

    @Override
    public double wknot(int n) {
        return this.wknots[n];
    }

    @Override
    public IDouble wknot(IIntegerI iIntegerI) {
        return new IDouble(this.wknots[iIntegerI.x()]);
    }

    @Override
    public double[] uknots() {
        return this.uknots;
    }

    @Override
    public double[] uknots(ISwitchE iSwitchE) {
        return this.uknots();
    }

    public IDouble[] uknots(ISwitchR iSwitchR) {
        IDouble[] iDoubleArray = new IDouble[this.uknots.length];
        for (int i = 0; i < this.uknots.length; ++i) {
            iDoubleArray[i] = new IDouble(this.uknots[i]);
        }
        return iDoubleArray;
    }

    @Override
    public double[] vknots() {
        return this.vknots;
    }

    @Override
    public double[] vknots(ISwitchE iSwitchE) {
        return this.vknots();
    }

    public IDouble[] vknots(ISwitchR iSwitchR) {
        IDouble[] iDoubleArray = new IDouble[this.vknots.length];
        for (int i = 0; i < this.vknots.length; ++i) {
            iDoubleArray[i] = new IDouble(this.vknots[i]);
        }
        return iDoubleArray;
    }

    @Override
    public double[] wknots() {
        return this.wknots;
    }

    @Override
    public double[] wknots(ISwitchE iSwitchE) {
        return this.wknots();
    }

    public IDouble[] wknots(ISwitchR iSwitchR) {
        IDouble[] iDoubleArray = new IDouble[this.wknots.length];
        for (int i = 0; i < this.wknots.length; ++i) {
            iDoubleArray[i] = new IDouble(this.wknots[i]);
        }
        return iDoubleArray;
    }

    @Override
    public int uknotNum() {
        return this.uknots.length;
    }

    @Override
    public int vknotNum() {
        return this.vknots.length;
    }

    @Override
    public int wknotNum() {
        return this.wknots.length;
    }

    @Override
    public int uknotNum(ISwitchE iSwitchE) {
        return this.uknotNum();
    }

    @Override
    public int vknotNum(ISwitchE iSwitchE) {
        return this.vknotNum();
    }

    @Override
    public int wknotNum(ISwitchE iSwitchE) {
        return this.wknotNum();
    }

    @Override
    public IInteger uknotNum(ISwitchR iSwitchR) {
        return new IInteger(this.uknotNum());
    }

    @Override
    public IInteger vknotNum(ISwitchR iSwitchR) {
        return new IInteger(this.vknotNum());
    }

    @Override
    public IInteger wknotNum(ISwitchR iSwitchR) {
        return new IInteger(this.wknotNum());
    }

    @Override
    public boolean isRational() {
        if (this.defaultWeights == null) {
            IOut.err("defaultWeights is null");
            return false;
        }
        for (int i = 0; i < this.defaultWeights.length; ++i) {
            for (int j = 0; j < this.defaultWeights[i].length; ++j) {
                for (int k = 0; k < this.defaultWeights[i][j].length; ++k) {
                    if (this.defaultWeights[i][j][k]) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isRational(ISwitchE iSwitchE) {
        return this.isRational();
    }

    @Override
    public IBool isRational(ISwitchR iSwitchR) {
        return new IBool(this.isRational());
    }

    @Override
    public int udeg() {
        return this.udegree;
    }

    @Override
    public int vdeg() {
        return this.vdegree;
    }

    @Override
    public int wdeg() {
        return this.wdegree;
    }

    @Override
    public int udeg(ISwitchE iSwitchE) {
        return this.udeg();
    }

    @Override
    public int vdeg(ISwitchE iSwitchE) {
        return this.vdeg();
    }

    @Override
    public int wdeg(ISwitchE iSwitchE) {
        return this.wdeg();
    }

    @Override
    public IInteger udeg(ISwitchR iSwitchR) {
        return new IInteger(this.udeg());
    }

    @Override
    public IInteger vdeg(ISwitchR iSwitchR) {
        return new IInteger(this.vdeg());
    }

    @Override
    public IInteger wdeg(ISwitchR iSwitchR) {
        return new IInteger(this.wdeg());
    }

    @Override
    public int unum() {
        return this.controlPoints.length;
    }

    @Override
    public int vnum() {
        return this.controlPoints[0].length;
    }

    @Override
    public int wnum() {
        return this.controlPoints[0][0].length;
    }

    @Override
    public int unum(ISwitchE iSwitchE) {
        return this.unum();
    }

    @Override
    public int vnum(ISwitchE iSwitchE) {
        return this.vnum();
    }

    @Override
    public int wnum(ISwitchE iSwitchE) {
        return this.wnum();
    }

    @Override
    public IInteger unum(ISwitchR iSwitchR) {
        return new IInteger(this.unum());
    }

    @Override
    public IInteger vnum(ISwitchR iSwitchR) {
        return new IInteger(this.vnum());
    }

    @Override
    public IInteger wnum(ISwitchR iSwitchR) {
        return new IInteger(this.wnum());
    }

    @Override
    public int ucpNum() {
        return this.unum();
    }

    @Override
    public int vcpNum() {
        return this.vnum();
    }

    @Override
    public int wcpNum() {
        return this.wnum();
    }

    @Override
    public int ucpNum(ISwitchE iSwitchE) {
        return this.ucpNum();
    }

    @Override
    public int vcpNum(ISwitchE iSwitchE) {
        return this.vcpNum();
    }

    @Override
    public int wcpNum(ISwitchE iSwitchE) {
        return this.wcpNum();
    }

    @Override
    public IInteger ucpNum(ISwitchR iSwitchR) {
        return new IInteger(this.ucpNum());
    }

    @Override
    public IInteger vcpNum(ISwitchR iSwitchR) {
        return new IInteger(this.vcpNum());
    }

    @Override
    public IInteger wcpNum(ISwitchR iSwitchR) {
        return new IInteger(this.wcpNum());
    }

    @Override
    public int uepNum() {
        return this.uknots.length - 2 * this.udegree;
    }

    @Override
    public int vepNum() {
        return this.vknots.length - 2 * this.vdegree;
    }

    @Override
    public int wepNum() {
        return this.wknots.length - 2 * this.wdegree;
    }

    @Override
    public int uepNum(ISwitchE iSwitchE) {
        return this.uepNum();
    }

    @Override
    public int vepNum(ISwitchE iSwitchE) {
        return this.vepNum();
    }

    @Override
    public int wepNum(ISwitchE iSwitchE) {
        return this.wepNum();
    }

    @Override
    public IInteger uepNum(ISwitchR iSwitchR) {
        return new IInteger(this.uepNum());
    }

    @Override
    public IInteger vepNum(ISwitchR iSwitchR) {
        return new IInteger(this.vepNum());
    }

    @Override
    public IInteger wepNum(ISwitchR iSwitchR) {
        return new IInteger(this.wepNum());
    }

    @Override
    public double u(int n, double d) {
        if (d >= 0.0) {
            return this.uknots[n + this.udegree] + (this.uknots[n + this.udegree + 1] - this.uknots[n + this.udegree]) * d;
        }
        return this.uknots[n + this.udegree] + (this.uknots[n + this.udegree] - this.uknots[n + this.udegree - 1]) * d;
    }

    @Override
    public IDouble u(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return new IDouble(this.u(iIntegerI.x(), iDoubleI.x()));
    }

    @Override
    public double v(int n, double d) {
        if (d >= 0.0) {
            return this.vknots[n + this.vdegree] + (this.vknots[n + this.vdegree + 1] - this.vknots[n + this.vdegree]) * d;
        }
        return this.vknots[n + this.vdegree] + (this.vknots[n + this.vdegree] - this.vknots[n + this.vdegree - 1]) * d;
    }

    @Override
    public IDouble v(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return new IDouble(this.v(iIntegerI.x(), iDoubleI.x()));
    }

    @Override
    public double w(int n, double d) {
        if (d >= 0.0) {
            return this.wknots[n + this.wdegree] + (this.wknots[n + this.wdegree + 1] - this.wknots[n + this.wdegree]) * d;
        }
        return this.wknots[n + this.wdegree] + (this.wknots[n + this.wdegree] - this.wknots[n + this.wdegree - 1]) * d;
    }

    @Override
    public IDouble w(IIntegerI iIntegerI, IDoubleI iDoubleI) {
        return new IDouble(this.w(iIntegerI.x(), iDoubleI.x()));
    }

    @Override
    public double ustart() {
        return this.ustart;
    }

    @Override
    public double uend() {
        return this.uend;
    }

    @Override
    public double vstart() {
        return this.vstart;
    }

    @Override
    public double vend() {
        return this.vend;
    }

    @Override
    public double wstart() {
        return this.wstart;
    }

    @Override
    public double wend() {
        return this.wend;
    }

    @Override
    public double ustart(ISwitchE iSwitchE) {
        return this.ustart();
    }

    @Override
    public double uend(ISwitchE iSwitchE) {
        return this.uend();
    }

    @Override
    public double vstart(ISwitchE iSwitchE) {
        return this.vstart();
    }

    @Override
    public double vend(ISwitchE iSwitchE) {
        return this.vend();
    }

    @Override
    public double wstart(ISwitchE iSwitchE) {
        return this.wstart();
    }

    @Override
    public double wend(ISwitchE iSwitchE) {
        return this.wend();
    }

    @Override
    public IDouble ustart(ISwitchR iSwitchR) {
        return new IDouble(this.ustart());
    }

    @Override
    public IDouble uend(ISwitchR iSwitchR) {
        return new IDouble(this.uend());
    }

    @Override
    public IDouble vstart(ISwitchR iSwitchR) {
        return new IDouble(this.vstart());
    }

    @Override
    public IDouble vend(ISwitchR iSwitchR) {
        return new IDouble(this.vend());
    }

    @Override
    public IDouble wstart(ISwitchR iSwitchR) {
        return new IDouble(this.wstart());
    }

    @Override
    public IDouble wend(ISwitchR iSwitchR) {
        return new IDouble(this.wend());
    }

    @Override
    public boolean isUClosed() {
        int n = this.vcpNum();
        int n2 = this.wcpNum();
        if (this.uknots[0] != 0.0 || this.uknots[this.uknots.length - 1] != 1.0) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (this.cp(0, i, j).eq(this.cp(this.ucpNum() - this.udegree, i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                if (this.pt(0.0, (double)i / (double)n, (double)j / (double)n2).eq(this.pt(1.0, (double)i / (double)n, (double)j / (double)n2))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isUClosed(ISwitchE iSwitchE) {
        return this.isUClosed();
    }

    @Override
    public IBool isUClosed(ISwitchR iSwitchR) {
        return new IBool(this.isUClosed());
    }

    @Override
    public boolean isVClosed() {
        int n = this.ucpNum();
        int n2 = this.wcpNum();
        if (this.vknots[0] != 0.0 || this.vknots[this.vknots.length - 1] != 1.0) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (this.cp(i, 0, j).eq(this.cp(i, this.vcpNum() - this.vdegree, j))) continue;
                    return false;
                }
            }
            return true;
        }
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                if (this.pt((double)i / (double)n, 0.0, (double)j / (double)n2).eq(this.pt((double)i / (double)n, 1.0, (double)j / (double)n2))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isVClosed(ISwitchE iSwitchE) {
        return this.isVClosed();
    }

    @Override
    public IBool isVClosed(ISwitchR iSwitchR) {
        return new IBool(this.isVClosed());
    }

    @Override
    public boolean isWClosed() {
        int n = this.ucpNum();
        int n2 = this.vcpNum();
        if (this.wknots[0] != 0.0 || this.wknots[this.wknots.length - 1] != 1.0) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (this.cp(i, j, 0).eq(this.cp(i, j, this.wcpNum() - this.wdegree))) continue;
                    return false;
                }
            }
            return true;
        }
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= n2; ++j) {
                if (this.pt((double)i / (double)n, (double)j / (double)n2, 0.0).eq(this.pt((double)i / (double)n, (double)j / (double)n2, 1.0))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWClosed(ISwitchE iSwitchE) {
        return this.isWClosed();
    }

    @Override
    public IBool isWClosed(ISwitchR iSwitchR) {
        return new IBool(this.isWClosed());
    }

    @Override
    public IVolumeGeo add(double d, double d2, double d3) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.add(d, d2, d3);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo add(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.add(iDoubleI, iDoubleI2, iDoubleI3);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo add(IVecI iVecI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.add(iVecI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo sub(double d, double d2, double d3) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.sub(d, d2, d3);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo sub(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.sub(iDoubleI, iDoubleI2, iDoubleI3);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo sub(IVecI iVecI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.sub(iVecI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo mul(IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.mul(iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo mul(double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.mul(d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo div(IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.div(iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo div(double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.div(d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo neg() {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.neg();
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo flip() {
        return this.neg();
    }

    @Override
    public IVolumeGeo add(IVecI iVecI, double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.add(iVecI, d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo add(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.add(iVecI, iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo add(double d, IVecI iVecI) {
        return this.add(iVecI, d);
    }

    @Override
    public IVolumeGeo add(IDoubleI iDoubleI, IVecI iVecI) {
        return this.add(iVecI, iDoubleI);
    }

    @Override
    public IVolumeGeo rot(IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.rot(iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot(double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.rot(d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.rot(iVecI, iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot(IVecI iVecI, double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.rot(iVecI, d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI3 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI3.rot(iVecI, iVecI2, iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot(IVecI iVecI, IVecI iVecI2, double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI3 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI3.rot(iVecI, iVecI2, d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot(IVecI iVecI, IVecI iVecI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI3 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI3.rot(iVecI, iVecI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI4 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI4.rot(iVecI, iVecI2, iVecI3);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot2(IDoubleI iDoubleI) {
        return this.rot(iDoubleI);
    }

    @Override
    public IVolumeGeo rot2(double d) {
        return this.rot(d);
    }

    @Override
    public IVolumeGeo rot2(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.rot2(iVecI, iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot2(IVecI iVecI, double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.rot2(iVecI, d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot2(IVecI iVecI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.rot2(iVecI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo rot2(IVecI iVecI, IVecI iVecI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI3 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI3.rot2(iVecI, iVecI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo scale(IDoubleI iDoubleI) {
        return this.mul(iDoubleI);
    }

    @Override
    public IVolumeGeo scale(double d) {
        return this.mul(d);
    }

    @Override
    public IVolumeGeo scale(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.scale(iVecI, iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo scale(IVecI iVecI, double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.scale(iVecI, d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo scale1d(IVecI iVecI, double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.scale1d(iVecI, d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo scale1d(IVecI iVecI, IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.scale1d(iVecI, iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo scale1d(IVecI iVecI, IVecI iVecI2, double d) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI3 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI3.scale1d(iVecI, iVecI2, d);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo scale1d(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI3 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI3.scale1d(iVecI, iVecI2, iDoubleI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo ref(IVecI iVecI) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.ref(iVecI);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo ref(IVecI iVecI, IVecI iVecI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI3 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI3.ref(iVecI, iVecI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo mirror(IVecI iVecI) {
        return this.ref(iVecI);
    }

    @Override
    public IVolumeGeo mirror(IVecI iVecI, IVecI iVecI2) {
        return this.ref(iVecI2);
    }

    @Override
    public IVolumeGeo shear(double d, double d2, double d3, double d4, double d5, double d6) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shear(d, d2, d3, d4, d5, d6);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shear(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shear(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shear(IVecI iVecI, double d, double d2, double d3, double d4, double d5, double d6) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shear(iVecI, d, d2, d3, d4, d5, d6);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shear(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI iDoubleI5, IDoubleI iDoubleI6) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shear(iVecI, iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleI5, iDoubleI6);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearXY(double d, double d2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shearXY(d, d2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearXY(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shearXY(iDoubleI, iDoubleI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearXY(IVecI iVecI, double d, double d2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shearXY(iVecI, d, d2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearXY(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shearXY(iVecI, iDoubleI, iDoubleI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearYZ(double d, double d2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shearYZ(d, d2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearYZ(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shearYZ(iDoubleI, iDoubleI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearYZ(IVecI iVecI, double d, double d2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shearYZ(iVecI, d, d2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearYZ(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shearYZ(iVecI, iDoubleI, iDoubleI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearZX(double d, double d2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shearZX(d, d2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearZX(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.shearZX(iDoubleI, iDoubleI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearZX(IVecI iVecI, double d, double d2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shearZX(iVecI, d, d2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo shearZX(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI2 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI2.shearZX(iVecI, iDoubleI, iDoubleI2);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo mv(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVolumeGeo mv(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVolumeGeo mv(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVolumeGeo cp() {
        return this.dup();
    }

    @Override
    public IVolumeGeo cp(double d, double d2, double d3) {
        return this.dup().add(d, d2, d3);
    }

    @Override
    public IVolumeGeo cp(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.dup().add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVolumeGeo cp(IVecI iVecI) {
        return this.dup().add(iVecI);
    }

    @Override
    public IVolumeGeo translate(double d, double d2, double d3) {
        return this.add(d, d2, d3);
    }

    @Override
    public IVolumeGeo translate(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return this.add(iDoubleI, iDoubleI2, iDoubleI3);
    }

    @Override
    public IVolumeGeo translate(IVecI iVecI) {
        return this.add(iVecI);
    }

    @Override
    public IVolumeGeo transform(IMatrix3I iMatrix3I) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.transform(iMatrix3I);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo transform(IMatrix4I iMatrix4I) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI : iVecIArray4 = iVecIArray3[j]) {
                    iVecI.transform(iMatrix4I);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI4 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI4.transform(iVecI, iVecI2, iVecI3);
                }
            }
        }
        return this;
    }

    @Override
    public IVolumeGeo transform(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        IVecI[][][] iVecIArray = this.controlPoints;
        int n = iVecIArray.length;
        for (int i = 0; i < n; ++i) {
            IVecI[][] iVecIArray2;
            IVecI[][] iVecIArray3 = iVecIArray2 = iVecIArray[i];
            int n2 = iVecIArray3.length;
            for (int j = 0; j < n2; ++j) {
                IVecI[] iVecIArray4;
                for (IVecI iVecI5 : iVecIArray4 = iVecIArray3[j]) {
                    iVecI5.transform(iVecI, iVecI2, iVecI3, iVecI4);
                }
            }
        }
        return this;
    }
}

