/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IArc;
import igeo.IBoolI;
import igeo.IBox;
import igeo.IBrep;
import igeo.ICircle;
import igeo.IColor;
import igeo.IConfig;
import igeo.ICurve;
import igeo.ICurveCreator;
import igeo.ICurveI;
import igeo.ICylinder;
import igeo.IDouble;
import igeo.IDoubleI;
import igeo.IDynamicServer;
import igeo.IEdge;
import igeo.IFace;
import igeo.IGeometry;
import igeo.IGraphicObject;
import igeo.ILayer;
import igeo.IMesh;
import igeo.IMeshCreator;
import igeo.IMeshGeo;
import igeo.IMeshType;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IPolycurve;
import igeo.IPrintWrapper;
import igeo.IRand;
import igeo.IServer;
import igeo.IServerI;
import igeo.ISphere;
import igeo.ISurface;
import igeo.ISurfaceCreator;
import igeo.ISurfaceI;
import igeo.IText;
import igeo.IUnit;
import igeo.IVec;
import igeo.IVec2;
import igeo.IVec2I;
import igeo.IVec4;
import igeo.IVec4I;
import igeo.IVecI;
import igeo.IVertex;
import igeo.gui.IGraphicMode;
import igeo.gui.IGridPanel;
import igeo.gui.IPane;
import igeo.gui.IPanelI;
import igeo.gui.IScreenTogglePanel;
import igeo.gui.IView;
import igeo.io.IIO;
import igeo.io.IInputWrapper;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class IG
implements IServerI {
    public static final Object lock = new Object();
    public static final String GL1 = "igeo.p.PIGraphicsGL1";
    public static final String GL2 = "igeo.p.PIGraphicsGL2";
    public static final String GL3 = "igeo.p.PIGraphicsGL3";
    public static final String GL = "igeo.p.PIGraphicsGL3";
    public static final String P3D = "igeo.p.PIGraphics3D";
    public static final String P3 = "igeo.p.PIGraphics3D";
    public static final String P = "igeo.p.PIGraphics3D";
    protected static ArrayList<IG> iglist = null;
    protected static int currentId = -1;
    public static final IVec xaxis = IVec.xaxis;
    public static final IVec yaxis = IVec.yaxis;
    public static final IVec zaxis = IVec.zaxis;
    public static final IVec origin = IVec.origin;
    public static final IVec x = IVec.xaxis;
    public static final IVec y = IVec.yaxis;
    public static final IVec z = IVec.zaxis;
    public static final IVec o = IVec.origin;
    public IServer server;
    public IPanelI panel = null;
    public String inputFile;
    public String outputFile;
    public String basePath = null;
    public IInputWrapper inputWrapper = null;
    public boolean online = false;

    public static int majorVersion() {
        return 0;
    }

    public static int minorVersion() {
        return 9;
    }

    public static int buildVersion() {
        return 5;
    }

    public static int revisionVersion() {
        return 0;
    }

    public static Calendar versionDate() {
        return new GregorianCalendar(2025, 3, 15);
    }

    public static String version() {
        return String.valueOf(IG.majorVersion()) + "." + String.valueOf(IG.minorVersion()) + "." + String.valueOf(IG.buildVersion()) + "." + String.valueOf(IG.revisionVersion());
    }

    public static IG init() {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG();
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG init(IPanelI iPanelI) {
        if (iglist == null) {
            iglist = new ArrayList();
        }
        IG iG = new IG(iPanelI);
        iglist.add(iG);
        currentId = iglist.size() - 1;
        return iG;
    }

    public static IG current() {
        return IG.cur();
    }

    public static IG cur() {
        if (iglist == null || currentId < 0 || currentId >= iglist.size()) {
            return null;
        }
        return iglist.get(currentId);
    }

    public static IG defaultThread() {
        return IG.cur();
    }

    public static IDynamicServer dynamicThread() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.dynamicServer();
    }

    public static IDynamicServer updateThread() {
        return IG.dynamicThread();
    }

    public static void setCurrent(IG iG) {
        int n = iglist.indexOf(iG);
        if (n >= 0 && n < iglist.size()) {
            currentId = n;
        } else {
            iglist.add(iG);
            currentId = iglist.size() - 1;
        }
        ICurveCreator.server(iG);
        ISurfaceCreator.server(iG);
        IMeshCreator.server(iG);
    }

    public static void setCurrent(IPanelI iPanelI) {
        for (int i = 0; i < iglist.size(); ++i) {
            if (IG.iglist.get((int)i).panel != iPanelI) continue;
            currentId = i;
            ICurveCreator.server(iglist.get(i));
            ISurfaceCreator.server(iglist.get(i));
            return;
        }
        IOut.err("no IG instance found for " + iPanelI);
    }

    public static IG getIG(IPanelI iPanelI) {
        for (IG iG : iglist) {
            if (iG.panel != iPanelI) continue;
            return iG;
        }
        return null;
    }

    public static IObject[] open(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        ArrayList<IObject> arrayList = iG.openFile(string);
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new IObject[arrayList.size()]);
    }

    public static boolean save(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveFile(string);
    }

    public static boolean saveRhino(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveRhinoFile(string);
    }

    public static boolean saveRhino4(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveRhino4File(string);
    }

    public static boolean saveRhino5(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveRhino5File(string);
    }

    public static boolean saveOBJ(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveOBJFile(string);
    }

    public static boolean saveAI(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveAIFile(string);
    }

    public static boolean saveTextures(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return false;
        }
        return iG.saveTextureFiles(string);
    }

    public static void duration(int n) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setDuration(n);
        }
    }

    public static int duration() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getDuration();
    }

    public static void time(int n) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setTime(n);
        }
    }

    public static int time() {
        IG iG = IG.cur();
        return iG == null ? -1 : iG.getTime();
    }

    public static void pause() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.pauseDynamics();
        }
    }

    public static void resume() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.resumeDynamics();
        }
    }

    public static boolean isRunning() {
        IG iG = IG.cur();
        if (iG != null) {
            return iG.isDynamicsRunning();
        }
        return false;
    }

    public static void start() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.startDynamics();
        }
    }

    public static void stop() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.stopDynamics();
        }
    }

    public static void updateRate(double d) {
        IConfig.updateRate = d;
    }

    public static void updateSpeed(double d) {
        IG.updateRate(d);
    }

    public static void rate(double d) {
        IG.updateRate(d);
    }

    public static void speed(double d) {
        IG.updateRate(d);
    }

    public static double updateRate() {
        return IConfig.updateRate;
    }

    public static double updateSpeed() {
        return IG.updateRate();
    }

    public static double rate() {
        return IG.updateRate();
    }

    public static double speed() {
        return IG.updateRate();
    }

    public static IUnit unit() {
        IG iG = IG.cur();
        if (iG != null) {
            return iG.server().unit();
        }
        return null;
    }

    public static void unit(IUnit iUnit) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.server().unit(iUnit);
        }
    }

    public static void unit(IUnit.Type type) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.server().unit(type);
        }
    }

    public static void unit(String string) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.server().unit(string);
        }
    }

    public static void outputFile(String string) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setOutputFile(string);
        }
    }

    public static String outputFile() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getOutputFile();
    }

    public static void inputFile(String string) {
        IG iG = IG.cur();
        if (iG != null) {
            iG.setInputFile(string);
        }
    }

    public static String inputFile() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getInputFile();
    }

    public static IPoint[] points() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getPoints();
    }

    public static IPoint[] pts() {
        return IG.points();
    }

    public static ICurve[] curves() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getCurves();
    }

    public static ICurve[] crvs() {
        return IG.curves();
    }

    public static IPolycurve[] polycurves() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getPolycurves();
    }

    public static ISurface[] surfaces() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getSurfaces();
    }

    public static ISurface[] srfs() {
        return IG.surfaces();
    }

    public static IMesh[] meshes() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getMeshes();
    }

    public static IBrep[] breps() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getBreps();
    }

    public static IText[] texts() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getTexts();
    }

    public static IGeometry[] geometries() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getGeometries();
    }

    public static IGeometry[] geos() {
        return IG.geometries();
    }

    public static IObject[] objects(Class clazz) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObjects(clazz);
    }

    public static IObject[] objs(Class clazz) {
        return IG.objects();
    }

    public static IObject[] objects() {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObjects();
    }

    public static IObject[] objs() {
        return IG.objects();
    }

    public static IPoint point(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getPoint(n);
    }

    public static IPoint pt(int n) {
        return IG.point(n);
    }

    public static ICurve curve(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getCurve(n);
    }

    public static ICurve crv(int n) {
        return IG.curve(n);
    }

    public static IPolycurve polycurve(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getPolycurve(n);
    }

    public static ISurface surface(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getSurface(n);
    }

    public static ISurface srf(int n) {
        return IG.surface(n);
    }

    public static IMesh mesh(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getMesh(n);
    }

    public static IBrep brep(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getBrep(n);
    }

    public static IText text(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getText(n);
    }

    public static IGeometry geometry(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getGeometry(n);
    }

    public static IGeometry geo(int n) {
        return IG.geometry(n);
    }

    public static IObject object(Class clazz, int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObject(clazz, n);
    }

    public static IObject obj(Class clazz, int n) {
        return IG.object(clazz, n);
    }

    public static IObject object(int n) {
        IG iG = IG.cur();
        return iG == null ? null : iG.getObject(n);
    }

    public static IObject obj(int n) {
        return IG.object(n);
    }

    public static int pointNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getPointNum();
    }

    public static int ptNum() {
        return IG.pointNum();
    }

    public static int curveNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getCurveNum();
    }

    public static int crvNum() {
        return IG.curveNum();
    }

    public static int polycurveNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getPolycurveNum();
    }

    public static int surfaceNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getSurfaceNum();
    }

    public static int srfNum() {
        return IG.surfaceNum();
    }

    public static int meshNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getMeshNum();
    }

    public static int brepNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getBrepNum();
    }

    public static int textNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getTextNum();
    }

    public static int geometryNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getGeometryNum();
    }

    public static int geoNum() {
        return IG.geometryNum();
    }

    public static int objectNum(Class clazz) {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getObjectNum(clazz);
    }

    public static int objNum(Class clazz) {
        return IG.objectNum(clazz);
    }

    public static int objectNum() {
        IG iG = IG.cur();
        return iG == null ? 0 : iG.getObjectNum();
    }

    public static int objNum() {
        return IG.objectNum();
    }

    public static void del(IObject iObject) {
        iObject.del();
    }

    public static void del(IObject[] iObjectArray) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            if (iObjectArray[i] == null) continue;
            iObjectArray[i].del();
        }
    }

    public static void del(ArrayList<IObject> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) == null) continue;
            arrayList.get(i).del();
        }
    }

    public static void del(Class clazz) {
        IObject[] iObjectArray = IG.objects(clazz);
        IG.del(iObjectArray);
    }

    public static void delAll() {
        IG.clear();
    }

    public static void clear() {
        IG iG = IG.cur();
        if (iG != null) {
            iG.clearServer();
        }
    }

    public static ILayer layer(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getLayer(string);
    }

    public static ILayer layer(int n) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getLayer(n);
    }

    public static ILayer[] layers() {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        return iG.getAllLayers();
    }

    public static void delLayer(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.deleteLayer(string);
    }

    public static void delLayer(ILayer iLayer) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.deleteLayer(iLayer);
    }

    public static int layerNum() {
        IG iG = IG.cur();
        if (iG == null) {
            return 0;
        }
        return iG.getLayerNum();
    }

    public static void focus() {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.focusView();
    }

    public static boolean isGL() {
        IG iG = IG.cur();
        if (iG == null) {
            IOut.err("no IG found");
            return true;
        }
        if (iG.server().graphicServer() == null) {
            IOut.err("no graphic server found");
            return true;
        }
        return iG.server().graphicServer().isGL();
    }

    public static void graphicMode(IGraphicMode iGraphicMode) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.server().setGraphicMode(iGraphicMode);
    }

    public static void wireframe() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.J2D;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, false, true, false));
    }

    public static void wire() {
        IG.wireframe();
    }

    public static void fill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.J2D;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, false));
    }

    public static void fillWithWireframe() {
        IG.wireframeFill();
    }

    public static void fillWireframe() {
        IG.wireframeFill();
    }

    public static void fillWire() {
        IG.wireframeFill();
    }

    public static void wireframeFill() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.J2D;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, false));
    }

    public static void wireFill() {
        IG.wireframeFill();
    }

    public static void transparentFill() {
        IG.transparent();
    }

    public static void transFill() {
        IG.transparent();
    }

    public static void transparent() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.J2D;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, false, true));
    }

    public static void trans() {
        IG.transparent();
    }

    public static void transparentFillWithWireframe() {
        IG.wireframeTransparent();
    }

    public static void transparentWireframe() {
        IG.wireframeTransparent();
    }

    public static void wireframeTransparent() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.J2D;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, true, true, true));
    }

    public static void wireTrans() {
        IG.wireframeTransparent();
    }

    public static void transWire() {
        IG.wireframeTransparent();
    }

    public static void noGraphic() {
        IGraphicMode.GraphicType graphicType = IGraphicMode.GraphicType.J2D;
        if (IG.isGL()) {
            graphicType = IGraphicMode.GraphicType.GL;
        }
        IG.graphicMode(new IGraphicMode(graphicType, false, false, false));
    }

    public static IView view(int n) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        if (iG == null || iG.panel == null || iG.panel.paneNum() > 0 || iG.panel.paneNum() <= n || n < 0) {
            return null;
        }
        if (iG.panel instanceof IScreenTogglePanel) {
            ((IScreenTogglePanel)iG.panel).enableFullScreen(iG.panel.pane(n));
        }
        return iG.panel.pane(n).getView();
    }

    public static IPane gridPane(int n, int n2) {
        IG iG = IG.cur();
        if (iG == null) {
            return null;
        }
        if (iG.panel != null && iG.panel instanceof IGridPanel) {
            IGridPanel iGridPanel = (IGridPanel)iG.panel;
            if (n >= 0 && n < iGridPanel.gridPanes.length && n2 >= 0 && n2 < iGridPanel.gridPanes[n].length) {
                IPane iPane = iGridPanel.gridPanes[n][n2];
                iGridPanel.enableFullScreen(iPane);
                return iPane;
            }
            if (iGridPanel.gridPanes.length > 0 && iGridPanel.gridPanes[0].length > 0) {
                IPane iPane = iGridPanel.gridPanes[0][0];
                iGridPanel.enableFullScreen(0);
                return iPane;
            }
        }
        return null;
    }

    public static void disableFullScreen() {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        if (iG.panel != null && iG.panel instanceof IGridPanel) {
            IGridPanel iGridPanel = (IGridPanel)iG.panel;
            iGridPanel.disableFullScreen();
        }
    }

    public static IPane topPane() {
        return IG.gridPane(0, 0);
    }

    public static IPane bottomPane() {
        return IG.topPane();
    }

    public static IPane perspectivePane() {
        return IG.gridPane(1, 0);
    }

    public static IPane axonometricPane() {
        return IG.perspectivePane();
    }

    public static IPane frontPane() {
        return IG.gridPane(0, 1);
    }

    public static IPane backPane() {
        return IG.frontPane();
    }

    public static IPane rightPane() {
        return IG.gridPane(1, 1);
    }

    public static IPane leftPane() {
        return IG.rightPane();
    }

    public static void top() {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop();
            iPane.focus();
        }
    }

    public static void top(double d, double d2) {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop(d, d2);
        }
    }

    public static void top(double d, double d2, double d3) {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop(d, d2, d3);
        }
    }

    public static void top(double d, double d2, double d3, double d4) {
        IPane iPane = IG.topPane();
        if (iPane != null) {
            iPane.getView().setTop(d, d2, d3, d4);
        }
    }

    public static void topView() {
        IG.top();
    }

    public static void topView(double d, double d2) {
        IG.top(d, d2);
    }

    public static void topView(double d, double d2, double d3) {
        IG.top(d, d2, d3);
    }

    public static void topView(double d, double d2, double d3, double d4) {
        IG.top(d, d2, d3, d4);
    }

    public static IVec topPos() {
        return IG.getViewPos(IG.topPane());
    }

    public static IVec topDir() {
        return IG.getViewDir(IG.topPane());
    }

    public static IVec topTarget() {
        return IG.getViewTarget(IG.topPane());
    }

    public static double topYaw() {
        return IG.getViewYaw(IG.topPane());
    }

    public static double topPitch() {
        return IG.getViewPitch(IG.topPane());
    }

    public static double topRoll() {
        return IG.getViewPitch(IG.topPane());
    }

    public static void bottom() {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom();
            iPane.focus();
        }
    }

    public static void bottom(double d, double d2) {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom(d, d2);
        }
    }

    public static void bottom(double d, double d2, double d3) {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom(d, d2, d3);
        }
    }

    public static void bottom(double d, double d2, double d3, double d4) {
        IPane iPane = IG.bottomPane();
        if (iPane != null) {
            iPane.getView().setBottom(d, d2, d3, d4);
        }
    }

    public static void bottomView() {
        IG.bottom();
    }

    public static void bottomView(double d, double d2) {
        IG.bottom(d, d2);
    }

    public static void bottomView(double d, double d2, double d3) {
        IG.bottom(d, d2, d3);
    }

    public static void bottomView(double d, double d2, double d3, double d4) {
        IG.bottom(d, d2, d3, d4);
    }

    public static IVec bottomPos() {
        return IG.getViewPos(IG.bottomPane());
    }

    public static IVec bottomDir() {
        return IG.getViewDir(IG.bottomPane());
    }

    public static IVec bottomTarget() {
        return IG.getViewTarget(IG.bottomPane());
    }

    public static double bottomYaw() {
        return IG.getViewYaw(IG.bottomPane());
    }

    public static double bottomPitch() {
        return IG.getViewPitch(IG.bottomPane());
    }

    public static double bottomRoll() {
        return IG.getViewPitch(IG.bottomPane());
    }

    public static void perspective() {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective();
            iPane.focus();
        }
    }

    public static void perspective(double d, double d2, double d3) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3);
        }
    }

    public static void perspective(double d, double d2, double d3, double d4, double d5) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3, d4, d5);
        }
    }

    public static void perspective(IVecI iVecI, IVecI iVecI2) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(iVecI, iVecI2);
        }
    }

    public static void perspectiveView() {
        IG.perspective();
    }

    public static void perspectiveView(double d, double d2, double d3) {
        IG.perspective(d, d2, d3);
    }

    public static void perspectiveView(double d, double d2, double d3, double d4, double d5) {
        IG.perspective(d, d2, d3, d4, d5);
    }

    public static void perspectiveView(IVecI iVecI, IVecI iVecI2) {
        IG.perspective(iVecI, iVecI2);
    }

    public static void pers() {
        IG.perspective();
    }

    public static void pers(double d, double d2, double d3) {
        IG.perspective(d, d2, d3);
    }

    public static void pers(double d, double d2, double d3, double d4, double d5) {
        IG.perspective(d, d2, d3, d4, d5);
    }

    public static void pers(IVecI iVecI, IVecI iVecI2) {
        IG.perspective(iVecI, iVecI2);
    }

    public static void perspective(double d) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d);
        }
    }

    public static void perspective(double d, double d2, double d3, double d4) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3, d4);
        }
    }

    public static void perspective(double d, double d2, double d3, double d4, double d5, double d6) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(d, d2, d3, d4, d5, d6);
        }
    }

    public static void perspective(IVecI iVecI, IVecI iVecI2, double d) {
        IPane iPane = IG.perspectivePane();
        if (iPane != null) {
            iPane.getView().setPerspective(iVecI, iVecI2, d);
        }
    }

    public static void perspectiveView(double d) {
        IG.perspective(d);
    }

    public static void perspectiveView(double d, double d2, double d3, double d4) {
        IG.perspective(d, d2, d3, d4);
    }

    public static void perspectiveView(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.perspective(d, d2, d3, d4, d5, d6);
    }

    public static void perspectiveView(IVecI iVecI, IVecI iVecI2, double d) {
        IG.perspective(iVecI, iVecI2, d);
    }

    public static void pers(double d) {
        IG.perspective(d);
    }

    public static void pers(double d, double d2, double d3, double d4) {
        IG.perspective(d, d2, d3, d4);
    }

    public static void pers(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.perspective(d, d2, d3, d4, d5, d6);
    }

    public static void pers(IVecI iVecI, IVecI iVecI2, double d) {
        IG.perspective(iVecI, iVecI2, d);
    }

    public static IVec getViewPos(IPane iPane) {
        if (iPane == null) {
            IG.err("no pane found");
            return new IVec();
        }
        IView iView = iPane.getView();
        if (iView == null) {
            IG.err("no view found");
            return new IVec();
        }
        return iView.location();
    }

    public static IVec getViewDir(IPane iPane) {
        if (iPane == null) {
            IG.err("no pane found");
            return new IVec();
        }
        IView iView = iPane.getView();
        if (iView == null) {
            IG.err("no view found");
            return new IVec();
        }
        return iView.frontDirection();
    }

    public static IVec getViewTarget(IPane iPane) {
        if (iPane == null) {
            IG.err("no pane found");
            return new IVec();
        }
        IView iView = iPane.getView();
        if (iView == null) {
            IG.err("no view found");
            return new IVec();
        }
        return iView.target();
    }

    public static double getViewYaw(IPane iPane) {
        if (iPane == null) {
            IG.err("no pane found");
            return 0.0;
        }
        IView iView = iPane.getView();
        if (iView == null) {
            IG.err("no view found");
            return 0.0;
        }
        return iView.getYaw();
    }

    public static double getViewPitch(IPane iPane) {
        if (iPane == null) {
            IG.err("no pane found");
            return 0.0;
        }
        IView iView = iPane.getView();
        if (iView == null) {
            IG.err("no view found");
            return 0.0;
        }
        return iView.getPitch();
    }

    public static double getViewRoll(IPane iPane) {
        if (iPane == null) {
            IG.err("no pane found");
            return 0.0;
        }
        IView iView = iPane.getView();
        if (iView == null) {
            IG.err("no view found");
            return 0.0;
        }
        return iView.getRoll();
    }

    public static IVec persPos() {
        return IG.getViewPos(IG.perspectivePane());
    }

    public static IVec persDir() {
        return IG.getViewDir(IG.perspectivePane());
    }

    public static IVec persTarget() {
        return IG.getViewTarget(IG.perspectivePane());
    }

    public static double persYaw() {
        return IG.getViewYaw(IG.perspectivePane());
    }

    public static double persPitch() {
        return IG.getViewPitch(IG.perspectivePane());
    }

    public static double persRoll() {
        return IG.getViewPitch(IG.perspectivePane());
    }

    public static void axonometric() {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric();
            iPane.focus();
        }
    }

    public static void axonometric(double d, double d2, double d3) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3);
        }
    }

    public static void axonometric(double d, double d2, double d3, double d4) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3, d4);
        }
    }

    public static void axonometric(double d, double d2, double d3, double d4, double d5) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3, d4, d5);
        }
    }

    public static void axonometric(double d, double d2, double d3, double d4, double d5, double d6) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(d, d2, d3, d4, d5, d6);
        }
    }

    public static void axonometric(IVecI iVecI, IVecI iVecI2) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(iVecI, iVecI2);
        }
    }

    public static void axonometric(IVecI iVecI, IVecI iVecI2, double d) {
        IPane iPane = IG.axonometricPane();
        if (iPane != null) {
            iPane.getView().setAxonometric(iVecI, iVecI2, d);
        }
    }

    public static void axonometricView() {
        IG.axonometric();
    }

    public static void axonometricView(double d, double d2, double d3) {
        IG.axonometric(d, d2, d3);
    }

    public static void axonometricView(double d, double d2, double d3, double d4) {
        IG.axonometric(d, d2, d3, d4);
    }

    public static void axonometricView(double d, double d2, double d3, double d4, double d5) {
        IG.axonometric(d, d2, d3, d4, d5);
    }

    public static void axonometricView(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.axonometric(d, d2, d3, d4, d5, d6);
    }

    public static void axonometricView(IVecI iVecI, IVecI iVecI2) {
        IG.axonometric(iVecI, iVecI2);
    }

    public static void axonometricView(IVecI iVecI, IVecI iVecI2, double d) {
        IG.axonometric(iVecI, iVecI2, d);
    }

    public static void axon() {
        IG.axonometric();
    }

    public static void axon(double d, double d2, double d3) {
        IG.axonometric(d, d2, d3);
    }

    public static void axon(double d, double d2, double d3, double d4) {
        IG.axonometric(d, d2, d3, d4);
    }

    public static void axon(double d, double d2, double d3, double d4, double d5) {
        IG.axonometric(d, d2, d3, d4, d5);
    }

    public static void axon(double d, double d2, double d3, double d4, double d5, double d6) {
        IG.axonometric(d, d2, d3, d4, d5, d6);
    }

    public static void axon(IVecI iVecI, IVecI iVecI2) {
        IG.axonometric(iVecI, iVecI2);
    }

    public static void axon(IVecI iVecI, IVecI iVecI2, double d) {
        IG.axonometric(iVecI, iVecI2, d);
    }

    public static IVec axonPos() {
        return IG.getViewPos(IG.axonometricPane());
    }

    public static IVec axonDir() {
        return IG.getViewDir(IG.axonometricPane());
    }

    public static IVec axonTarget() {
        return IG.getViewTarget(IG.axonometricPane());
    }

    public static double axonYaw() {
        return IG.getViewYaw(IG.axonometricPane());
    }

    public static double axonPitch() {
        return IG.getViewPitch(IG.axonometricPane());
    }

    public static double axonRoll() {
        return IG.getViewPitch(IG.axonometricPane());
    }

    public static void front() {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront();
            iPane.focus();
        }
    }

    public static void front(double d, double d2) {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront(d, d2);
        }
    }

    public static void front(double d, double d2, double d3) {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront(d, d2, d3);
        }
    }

    public static void front(double d, double d2, double d3, double d4) {
        IPane iPane = IG.frontPane();
        if (iPane != null) {
            iPane.getView().setFront(d, d2, d3, d4);
        }
    }

    public static void frontView() {
        IG.front();
    }

    public static void frontView(double d, double d2) {
        IG.front(d, d2);
    }

    public static void frontView(double d, double d2, double d3) {
        IG.front(d, d2, d3);
    }

    public static void frontView(double d, double d2, double d3, double d4) {
        IG.front(d, d2, d3, d4);
    }

    public static IVec frontPos() {
        return IG.getViewPos(IG.frontPane());
    }

    public static IVec frontDir() {
        return IG.getViewDir(IG.frontPane());
    }

    public static IVec frontTarget() {
        return IG.getViewTarget(IG.frontPane());
    }

    public static double frontYaw() {
        return IG.getViewYaw(IG.frontPane());
    }

    public static double frontPitch() {
        return IG.getViewPitch(IG.frontPane());
    }

    public static double frontRoll() {
        return IG.getViewPitch(IG.frontPane());
    }

    public static void back() {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack();
            iPane.focus();
        }
    }

    public static void back(double d, double d2) {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack(d, d2);
        }
    }

    public static void back(double d, double d2, double d3) {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack(d, d2, d3);
        }
    }

    public static void back(double d, double d2, double d3, double d4) {
        IPane iPane = IG.backPane();
        if (iPane != null) {
            iPane.getView().setBack(d, d2, d3, d4);
        }
    }

    public static void backView() {
        IG.back();
    }

    public static void backView(double d, double d2) {
        IG.back(d, d2);
    }

    public static void backView(double d, double d2, double d3) {
        IG.back(d, d2, d3);
    }

    public static void backView(double d, double d2, double d3, double d4) {
        IG.back(d, d2, d3, d4);
    }

    public static IVec backPos() {
        return IG.getViewPos(IG.backPane());
    }

    public static IVec backDir() {
        return IG.getViewDir(IG.backPane());
    }

    public static IVec backTarget() {
        return IG.getViewTarget(IG.backPane());
    }

    public static double backYaw() {
        return IG.getViewYaw(IG.backPane());
    }

    public static double backPitch() {
        return IG.getViewPitch(IG.backPane());
    }

    public static double backRoll() {
        return IG.getViewPitch(IG.backPane());
    }

    public static void right() {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight();
            iPane.focus();
        }
    }

    public static void right(double d, double d2) {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight(d, d2);
        }
    }

    public static void right(double d, double d2, double d3) {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight(d, d2, d3);
        }
    }

    public static void right(double d, double d2, double d3, double d4) {
        IPane iPane = IG.rightPane();
        if (iPane != null) {
            iPane.getView().setRight(d, d2, d3, d4);
        }
    }

    public static void rightView() {
        IG.right();
    }

    public static void rightView(double d, double d2) {
        IG.right(d, d2);
    }

    public static void rightView(double d, double d2, double d3) {
        IG.right(d, d2, d3);
    }

    public static void rightView(double d, double d2, double d3, double d4) {
        IG.right(d, d2, d3, d4);
    }

    public static IVec rightPos() {
        return IG.getViewPos(IG.rightPane());
    }

    public static IVec rightDir() {
        return IG.getViewDir(IG.rightPane());
    }

    public static IVec rightTarget() {
        return IG.getViewTarget(IG.rightPane());
    }

    public static double rightYaw() {
        return IG.getViewYaw(IG.rightPane());
    }

    public static double rightPitch() {
        return IG.getViewPitch(IG.rightPane());
    }

    public static double rightRoll() {
        return IG.getViewPitch(IG.rightPane());
    }

    public static void left() {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft();
            iPane.focus();
        }
    }

    public static void left(double d, double d2) {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft(d, d2);
        }
    }

    public static void left(double d, double d2, double d3) {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft(d, d2, d3);
        }
    }

    public static void left(double d, double d2, double d3, double d4) {
        IPane iPane = IG.leftPane();
        if (iPane != null) {
            iPane.getView().setLeft(d, d2, d3, d4);
        }
    }

    public static void leftView() {
        IG.left();
    }

    public static void leftView(double d, double d2) {
        IG.left(d, d2);
    }

    public static void leftView(double d, double d2, double d3) {
        IG.left(d, d2, d3);
    }

    public static void leftView(double d, double d2, double d3, double d4) {
        IG.left(d, d2, d3, d4);
    }

    public static IVec leftPos() {
        return IG.getViewPos(IG.leftPane());
    }

    public static IVec leftDir() {
        return IG.getViewDir(IG.leftPane());
    }

    public static IVec leftTarget() {
        return IG.getViewTarget(IG.leftPane());
    }

    public static double leftYaw() {
        return IG.getViewYaw(IG.leftPane());
    }

    public static double leftPitch() {
        return IG.getViewPitch(IG.leftPane());
    }

    public static double leftRoll() {
        return IG.getViewPitch(IG.leftPane());
    }

    public static void bg(IColor iColor, IColor iColor2, IColor iColor3, IColor iColor4) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.server().bg(iColor, iColor2, iColor3, iColor4);
    }

    public static void background(IColor iColor, IColor iColor2, IColor iColor3, IColor iColor4) {
        IG.bg(iColor, iColor2, iColor3, iColor4);
    }

    public static void bg(Color color, Color color2, Color color3, Color color4) {
        IG.bg(new IColor(color), new IColor(color2), new IColor(color3), new IColor(color4));
    }

    public static void background(Color color, Color color2, Color color3, Color color4) {
        IG.bg(color, color2, color3, color4);
    }

    public static void bg(Color color) {
        IG.bg(color, color, color, color);
    }

    public static void background(Color color) {
        IG.bg(color);
    }

    public static void bg(String string) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        iG.server().bg(string);
    }

    public static void background(String string) {
        IG.bg(string);
    }

    public static void defaultBG() {
        IG.blueBG();
    }

    public static void blueBG() {
        IG.bg(IConfig.bgColor1, IConfig.bgColor2, IConfig.bgColor3, IConfig.bgColor4);
    }

    public static void lightBG() {
        IG.bg(1.0, 1.0, 0.9, 0.8);
    }

    public static void darkBG() {
        IG.bg(0.15, 0.15, 0.05, 0.0);
    }

    public static void whiteBG() {
        IG.bg(1.0);
    }

    public static void blackBG() {
        IG.bg(0.0);
    }

    public static void bg(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        IG.bg(IGraphicObject.getColor(n, n2, n3), IGraphicObject.getColor(n4, n5, n6), IGraphicObject.getColor(n7, n8, n9), IGraphicObject.getColor(n10, n11, n12));
    }

    public static void background(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        IG.bg(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n12, n11);
    }

    public static void bg(int n, int n2, int n3) {
        IG.bg(IGraphicObject.getColor(n, n2, n3));
    }

    public static void background(int n, int n2, int n3) {
        IG.bg(n, n2, n3);
    }

    public static void bg(int n, int n2, int n3, int n4) {
        IG.bg(IGraphicObject.getColor(n), IGraphicObject.getColor(n2), IGraphicObject.getColor(n3), IGraphicObject.getColor(n4));
    }

    public static void background(int n, int n2, int n3, int n4) {
        IG.bg(n, n2, n3, n4);
    }

    public static void bg(int n) {
        IG.bg(IGraphicObject.getColor(n));
    }

    public static void background(int n) {
        IG.bg(n);
    }

    public static void bg(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        IG.bg(IGraphicObject.getColor(f, f2, f3), IGraphicObject.getColor(f4, f5, f6), IGraphicObject.getColor(f7, f8, f9), IGraphicObject.getColor(f10, f11, f12));
    }

    public static void background(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        IG.bg(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f12, f11);
    }

    public static void bg(float f, float f2, float f3) {
        IG.bg(IGraphicObject.getColor(f, f2, f3));
    }

    public static void background(float f, float f2, float f3) {
        IG.bg(f, f2, f3);
    }

    public static void bg(float f, float f2, float f3, float f4) {
        IG.bg(IGraphicObject.getColor(f), IGraphicObject.getColor(f2), IGraphicObject.getColor(f3), IGraphicObject.getColor(f4));
    }

    public static void background(float f, float f2, float f3, float f4) {
        IG.bg(f, f2, f3, f4);
    }

    public static void bg(float f) {
        IG.bg(IGraphicObject.getColor(f));
    }

    public static void background(float f) {
        IG.bg(f);
    }

    public static void bg(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        IG.bg(IGraphicObject.getColor((float)d, (float)d2, (float)d3), IGraphicObject.getColor((float)d4, (float)d5, (float)d6), IGraphicObject.getColor((float)d7, (float)d8, (float)d9), IGraphicObject.getColor((float)d10, (float)d11, (float)d12));
    }

    public static void background(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        IG.bg(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d12, d11);
    }

    public static void bg(double d, double d2, double d3) {
        IG.bg(IGraphicObject.getColor((float)d, (float)d2, (float)d3));
    }

    public static void background(double d, double d2, double d3) {
        IG.bg(d, d2, d3);
    }

    public static void bg(double d, double d2, double d3, double d4) {
        IG.bg(IGraphicObject.getColor((float)d), IGraphicObject.getColor((float)d2), IGraphicObject.getColor((float)d3), IGraphicObject.getColor((float)d4));
    }

    public static void background(double d, double d2, double d3, double d4) {
        IG.bg(d, d2, d3, d4);
    }

    public static void bg(double d) {
        IG.bg(IGraphicObject.getColor((float)d));
    }

    public static void background(double d) {
        IG.bg(d);
    }

    public static void p(Object object) {
        IOut.printlnWithOffset(object, 1);
    }

    public static void p() {
        IOut.printlnWithOffset(1);
    }

    public static void print(Object object) {
        IOut.print(object);
    }

    public static void enabePrintPrefix() {
        IOut.enablePrefix();
    }

    public static void disablePrintPrefix() {
        IOut.disablePrefix();
    }

    public static void err(Object object) {
        IOut.errWithOffset(object, 1);
    }

    public static void err() {
        IOut.errWithOffset(1);
    }

    public static void error(Object object) {
        IOut.error(object);
    }

    public static void enabeErrorPrefix() {
        IOut.enablePrefix();
    }

    public static void disableErrorPrefix() {
        IOut.disablePrefix();
    }

    public static void debugLevel(int n) {
        IOut.debugLevel(n);
    }

    public static void debug(int n) {
        IG.debugLevel(n);
    }

    public static void debug() {
        IG.debugLevel(-1);
    }

    public static int debugLevel() {
        return IOut.debugLevel();
    }

    public static void showTime() {
        IG.showTime(true);
    }

    public static void showTime(boolean bl) {
        IG iG = IG.cur();
        if (iG == null) {
            return;
        }
        if (iG.dynamicServer() == null) {
            return;
        }
        iG.dynamicServer().showTime(bl);
    }

    public static void setPrint(IPrintWrapper iPrintWrapper) {
        IOut.setPrint(iPrintWrapper);
    }

    public static void setPrint(IPrintWrapper iPrintWrapper, IPrintWrapper iPrintWrapper2) {
        IOut.setPrint(iPrintWrapper, iPrintWrapper2);
    }

    public static void setPrint(IPrintWrapper iPrintWrapper, IPrintWrapper iPrintWrapper2, IPrintWrapper iPrintWrapper3) {
        IOut.setPrint(iPrintWrapper, iPrintWrapper2, iPrintWrapper3);
    }

    public static void setPrintStream(PrintStream printStream) {
        IOut.ps = printStream;
        IOut.err = printStream;
        IOut.debug = printStream;
    }

    public static void setPrintStream(PrintStream printStream, PrintStream printStream2) {
        IOut.ps = printStream;
        IOut.err = printStream2;
        IOut.debug = printStream;
    }

    public static void setPrintStream(PrintStream printStream, PrintStream printStream2, PrintStream printStream3) {
        IOut.ps = printStream;
        IOut.err = printStream2;
        IOut.debug = printStream3;
    }

    public IG() {
        this(null);
    }

    public IG(IPanelI iPanelI) {
        this.server = new IServer(this, iPanelI);
        if (iPanelI != null) {
            this.panel = iPanelI;
            iPanelI.setIG(this);
        }
    }

    public ArrayList<IObject> openFile(String string) {
        ArrayList<IObject> arrayList = null;
        if (this.inputWrapper != null) {
            arrayList = IIO.open(string, (IServerI)this, this.inputWrapper);
        } else {
            File file = new File(string);
            if (!file.isAbsolute() && this.basePath != null) {
                string = this.basePath + File.separator + string;
            }
            arrayList = IIO.open(string, (IServerI)this);
        }
        this.server.updateState();
        this.inputFile = string;
        return arrayList;
    }

    public String formatOutputFilePath(String string) {
        File file = new File(string);
        if (!file.isAbsolute() && this.basePath != null) {
            string = this.basePath + File.separator + string;
            File file2 = new File(this.basePath);
            if (!file2.isDirectory()) {
                IOut.debug(20, "creating directory" + file2.toString());
                if (!file2.mkdir()) {
                    IOut.err("failed to create directory: " + file2.toString());
                }
            }
        }
        return string;
    }

    public boolean saveFile(String string) {
        string = this.formatOutputFilePath(string);
        return IIO.save(string, (IServerI)this);
    }

    public boolean saveRhinoFile(String string) {
        string = this.formatOutputFilePath(string);
        return IIO.saveRhino(string, (IServerI)this);
    }

    public boolean saveRhino4File(String string) {
        string = this.formatOutputFilePath(string);
        return IIO.saveRhino4(string, (IServerI)this);
    }

    public boolean saveRhino5File(String string) {
        string = this.formatOutputFilePath(string);
        return IIO.saveRhino5(string, (IServerI)this);
    }

    public boolean saveOBJFile(String string) {
        string = this.formatOutputFilePath(string);
        return IIO.saveOBJ(string, (IServerI)this);
    }

    public boolean saveAIFile(String string) {
        string = this.formatOutputFilePath(string);
        return IIO.saveAI(string, (IServerI)this);
    }

    public boolean saveTextureFiles(String string) {
        string = this.formatOutputFilePath(string);
        return IIO.saveTextures(string, (IServerI)this);
    }

    public boolean save() {
        if (this.outputFile == null) {
            IOut.err("output filename is not set. not saved");
            return false;
        }
        return this.saveFile(this.outputFile);
    }

    public void setInputFile(String string) {
        this.inputFile = string;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String setBasePath(String string) {
        this.basePath = string;
        return this.basePath;
    }

    public void setOnline(boolean bl) {
        this.online = bl;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setInputWrapper(IInputWrapper iInputWrapper) {
        this.inputWrapper = iInputWrapper;
    }

    public ILayer getLayer(String string) {
        return this.server.getLayer(string);
    }

    public ILayer getLayer(int n) {
        return this.server.getLayer(n);
    }

    public ILayer[] getAllLayers() {
        return this.server.getAllLayers();
    }

    public void deleteLayer(String string) {
        this.server.deleteLayer(string);
    }

    public void deleteLayer(ILayer iLayer) {
        this.server.deleteLayer(iLayer);
    }

    public int getLayerNum() {
        return this.server.layerNum();
    }

    public IPoint[] getPoints() {
        return this.server.points();
    }

    public ICurve[] getCurves() {
        return this.server.curves();
    }

    public IPolycurve[] getPolycurves() {
        return this.server.polycurves();
    }

    public ISurface[] getSurfaces() {
        return this.server.surfaces();
    }

    public IMesh[] getMeshes() {
        return this.server.meshes();
    }

    public IBrep[] getBreps() {
        return this.server.breps();
    }

    public IText[] getTexts() {
        return this.server.texts();
    }

    public IGeometry[] getGeometries() {
        return this.server.geometries();
    }

    public IObject[] getObjects(Class clazz) {
        return this.server.objects(clazz);
    }

    public IObject[] getObjects() {
        return this.server.objects();
    }

    public IPoint getPoint(int n) {
        return this.server.point(n);
    }

    public ICurve getCurve(int n) {
        return this.server.curve(n);
    }

    public IPolycurve getPolycurve(int n) {
        return this.server.polycurve(n);
    }

    public ISurface getSurface(int n) {
        return this.server.surface(n);
    }

    public IMesh getMesh(int n) {
        return this.server.mesh(n);
    }

    public IBrep getBrep(int n) {
        return this.server.brep(n);
    }

    public IText getText(int n) {
        return this.server.text(n);
    }

    public IGeometry getGeometry(int n) {
        return this.server.geometry(n);
    }

    public IObject getObject(Class clazz, int n) {
        return this.server.object(clazz, n);
    }

    public IObject getObject(int n) {
        return this.server.object(n);
    }

    public int getPointNum() {
        return this.server.pointNum();
    }

    public int getCurveNum() {
        return this.server.curveNum();
    }

    public int getPolycurveNum() {
        return this.server.polycurveNum();
    }

    public int getSurfaceNum() {
        return this.server.surfaceNum();
    }

    public int getMeshNum() {
        return this.server.meshNum();
    }

    public int getBrepNum() {
        return this.server.brepNum();
    }

    public int getTextNum() {
        return this.server.textNum();
    }

    public int getGeometryNum() {
        return this.server.geometryNum();
    }

    public int getObjectNum(Class clazz) {
        return this.server.objectNum(clazz);
    }

    public int getObjectNum() {
        return this.server.objectNum();
    }

    public void focusView() {
        if (this.panel != null) {
            this.panel.focus();
        }
    }

    @Override
    public IServer server() {
        return this.server;
    }

    public IDynamicServer dynamicServer() {
        return this.server.dynamicServer();
    }

    public void setDuration(int n) {
        this.server.duration(n);
    }

    public int getDuration() {
        return this.server.duration();
    }

    public void setTime(int n) {
        this.server.time(n);
    }

    public int getTime() {
        return this.server.time();
    }

    public void pauseDynamics() {
        this.server.pause();
    }

    public void resumeDynamics() {
        this.server.resume();
    }

    public boolean isDynamicsRunning() {
        return this.server.isRunning();
    }

    public void startDynamics() {
        this.server.start();
    }

    public void stopDynamics() {
        this.server.stop();
    }

    public void clearServer() {
        this.server.clear();
    }

    public static IPoint point(IVecI iVecI) {
        return IG.pt(iVecI);
    }

    public static IPoint point(IVec iVec) {
        return IG.pt(iVec);
    }

    public static IPoint point(double d, double d2, double d3) {
        return IG.pt(d, d2, d3);
    }

    public static IPoint point(double d, double d2) {
        return IG.pt(d, d2);
    }

    public static IPoint pt(IVecI iVecI) {
        return new IPoint(iVecI);
    }

    public static IPoint pt(IVec iVec) {
        return new IPoint(iVec);
    }

    public static IPoint pt(double d, double d2, double d3) {
        return new IPoint(d, d2, d3);
    }

    public static IPoint pt(double d, double d2) {
        return new IPoint(d, d2);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return ICurveCreator.curve(iVecIArray, n, dArray, d, d2);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, double[] dArray) {
        return ICurveCreator.curve(iVecIArray, n, dArray);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n) {
        return ICurveCreator.curve(iVecIArray, n);
    }

    public static ICurve curve(IVecI[] iVecIArray) {
        return ICurveCreator.curve(iVecIArray);
    }

    public static ICurve curve(IVecI[] iVecIArray, int n, boolean bl) {
        return ICurveCreator.curve(iVecIArray, n, bl);
    }

    public static ICurve curve(IVecI[] iVecIArray, boolean bl) {
        return ICurveCreator.curve(iVecIArray, bl);
    }

    public static ICurve curve(IVecI iVecI, IVecI iVecI2) {
        return ICurveCreator.curve(iVecI, iVecI2);
    }

    public static ICurve curve(IVecI iVecI) {
        return ICurveCreator.curve(iVecI);
    }

    public static ICurve curve(double d, double d2, double d3, double d4, double d5, double d6) {
        return ICurveCreator.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve curve(double[][] dArray) {
        return ICurveCreator.curve(dArray);
    }

    public static ICurve curve(double[][] dArray, int n) {
        return ICurveCreator.curve(dArray, n);
    }

    public static ICurve curve(double[][] dArray, boolean bl) {
        return ICurveCreator.curve(dArray, bl);
    }

    public static ICurve curve(double[][] dArray, int n, boolean bl) {
        return ICurveCreator.curve(dArray, n, bl);
    }

    public static ICurve curve(ICurveI iCurveI) {
        return ICurveCreator.curve(iCurveI);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return IG.curve(iVecIArray, n, dArray, d, d2);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, double[] dArray) {
        return IG.curve(iVecIArray, n, dArray);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n) {
        return IG.curve(iVecIArray, n);
    }

    public static ICurve crv(IVecI[] iVecIArray) {
        return IG.curve(iVecIArray);
    }

    public static ICurve crv(IVecI[] iVecIArray, int n, boolean bl) {
        return IG.curve(iVecIArray, n, bl);
    }

    public static ICurve crv(IVecI[] iVecIArray, boolean bl) {
        return IG.curve(iVecIArray, bl);
    }

    public static ICurve crv(IVecI iVecI, IVecI iVecI2) {
        return IG.curve(iVecI, iVecI2);
    }

    public static ICurve crv(IVecI iVecI) {
        return IG.curve(iVecI);
    }

    public static ICurve crv(double d, double d2, double d3, double d4, double d5, double d6) {
        return IG.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve crv(double[][] dArray) {
        return IG.curve(dArray);
    }

    public static ICurve crv(double[][] dArray, int n) {
        return IG.curve(dArray, n);
    }

    public static ICurve crv(double[][] dArray, boolean bl) {
        return IG.curve(dArray, bl);
    }

    public static ICurve crv(double[][] dArray, int n, boolean bl) {
        return IG.curve(dArray, n, bl);
    }

    public static ICurve crv(ICurveI iCurveI) {
        return IG.curve(iCurveI);
    }

    public static ICurve line(IVecI iVecI, IVecI iVecI2) {
        return IG.curve(iVecI, iVecI2);
    }

    public static ICurve line(IVecI iVecI) {
        return IG.curve(iVecI);
    }

    public static ICurve line(double d, double d2, double d3, double d4, double d5, double d6) {
        return IG.curve(d, d2, d3, d4, d5, d6);
    }

    public static ICurve rect(IVecI iVecI, double d, double d2) {
        return ICurveCreator.rect(iVecI, d, d2);
    }

    public static ICurve rect(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.rect(iVecI, iVecI2, iVecI3);
    }

    public static ICurve rect(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.rect(d, d2, d3, d4, d5);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d) {
        return ICurveCreator.circle(iVecI, iVecI2, d);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, double d) {
        return ICurveCreator.circle(iVecI, d);
    }

    public static ICircle circle(double d, double d2, double d3, double d4) {
        return ICurveCreator.circle(d, d2, d3, d4);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ICurveCreator.circle(iVecI, iVecI2, d, d2);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, double d, double d2) {
        return ICurveCreator.circle(iVecI, d, d2);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.circle(d, d2, d3, d4, d5);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, d2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI2);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, d, bl);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, d, bl);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, boolean bl) {
        return ICurveCreator.circle(d, d2, d3, d4, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(IVecI iVecI, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(double d, double d2, double d3, double d4, double d5, boolean bl) {
        return ICurveCreator.circle(d, d2, d3, d4, d5, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, d, d2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI, IDoubleI iDoubleI2, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, iDoubleI, iDoubleI2, bl);
    }

    public static ICircle circle(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        return ICurveCreator.circle(iVecI, iVecI2, iVecI3, bl);
    }

    public static ICircle ellipse(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ICurveCreator.ellipse(iVecI, iVecI2, iVecI3);
    }

    public static ICircle ellipse(IVecI iVecI, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ICurveCreator.ellipse(iVecI, iDoubleI, iDoubleI2);
    }

    public static ICircle ellipse(IVecI iVecI, double d, double d2) {
        return ICurveCreator.ellipse(iVecI, d, d2);
    }

    public static ICircle ellipse(double d, double d2, double d3, double d4, double d5) {
        return ICurveCreator.ellipse(d, d2, d3, d4, d5);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, d);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IDoubleI iDoubleI) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iDoubleI);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, double d) {
        return ICurveCreator.arc(iVecI, iVecI2, d);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ICurveCreator.arc(iVecI, iVecI2, iDoubleI);
    }

    public static IArc arc(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return ICurveCreator.arc(d, d2, d3, d4, d5, d6, d7);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IBoolI iBoolI) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iBoolI);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, boolean bl) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, bl);
    }

    public static IArc arc(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5) {
        return ICurveCreator.arc(iVecI, iVecI2, iVecI3, iVecI4, iVecI5);
    }

    public static ICurve offset(ICurveI iCurveI, double d, IVecI iVecI) {
        return ICurveCreator.offset(iCurveI, d, iVecI);
    }

    public static ICurve offset(ICurveI iCurveI, IDoubleI iDoubleI, IVecI iVecI) {
        return ICurveCreator.offset(iCurveI, iDoubleI, iVecI);
    }

    public static ICurve offset(ICurveI iCurveI, double d) {
        return ICurveCreator.offset(iCurveI, d);
    }

    public static ICurve offset(ICurveI iCurveI, IDoubleI iDoubleI) {
        return ICurveCreator.offset(iCurveI, iDoubleI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d) {
        return IVec.offset(iVecArray, d);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, boolean bl) {
        return IVec.offset(iVecArray, d, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d) {
        return IVec.offset(iVecIArray, d);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, boolean bl) {
        return IVec.offset(iVecIArray, d, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return IVec.offset(iVecIArray, iDoubleI);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, boolean bl) {
        return IVec.offset(iVecIArray, iDoubleI, bl);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI) {
        return IVec.offset(iVecArray, d, iVecI);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecArray, d, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI) {
        return IVec.offset(iVecIArray, d, iVecI);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecIArray, d, iVecI, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI) {
        return IVec.offset(iVecIArray, iDoubleI, iVecI);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI iVecI, boolean bl) {
        return IVec.offset(iVecIArray, iDoubleI, iVecI, bl);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI[] iVecIArray) {
        return IVec.offset(iVecArray, d, iVecIArray);
    }

    public static IVec[] offset(IVec[] iVecArray, double d, IVecI[] iVecIArray, boolean bl) {
        return IVec.offset(iVecArray, d, iVecIArray, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI[] iVecIArray2) {
        return IVec.offset(iVecIArray, d, iVecIArray2);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, double d, IVecI[] iVecIArray2, boolean bl) {
        return IVec.offset(iVecIArray, d, iVecIArray2, bl);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI[] iVecIArray2) {
        return IVec.offset(iVecIArray, iDoubleI, iVecIArray2);
    }

    public static IVecI[] offset(IVecI[] iVecIArray, IDoubleI iDoubleI, IVecI[] iVecIArray2, boolean bl) {
        return IVec.offset(iVecIArray, iDoubleI, iVecIArray2, bl);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, dArray2, d, d2, d3, d4);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, dArray2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2);
    }

    public static ISurface surface(IVecI[][] iVecIArray) {
        return ISurfaceCreator.surface(iVecIArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, bl, dArray);
    }

    public static ISurface surface(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        return ISurfaceCreator.surface(iVecIArray, n, n2, dArray, bl);
    }

    public static ISurface surface(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(iVecIArray, bl, bl2);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return ISurfaceCreator.surface(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static ISurface surface(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ISurfaceCreator.surface(iVecI, iVecI2, iVecI3);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return ISurfaceCreator.surface(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static ISurface surface(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return ISurfaceCreator.surface(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static ISurface surface(double[][][] dArray) {
        return ISurfaceCreator.surface(dArray);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2) {
        return ISurfaceCreator.surface(dArray, n, n2);
    }

    public static ISurface surface(double[][][] dArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(dArray, bl, bl2);
    }

    public static ISurface surface(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.surface(dArray, n, n2, bl, bl2);
    }

    public static ISurface surface(ISurfaceI iSurfaceI) {
        return ISurfaceCreator.surface(iSurfaceI);
    }

    public static ISurface surface(ICurveI iCurveI) {
        return ISurfaceCreator.surface(iCurveI);
    }

    public static ISurface surface(ICurveI iCurveI, ICurveI[] iCurveIArray) {
        return ISurfaceCreator.surface(iCurveI, iCurveIArray);
    }

    public static ISurface surface(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.surface(iCurveI, iCurveI2);
    }

    public static ISurface surface(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.surface(iCurveIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray) {
        return ISurfaceCreator.surface(iVecIArray);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.surface(iVecIArray, n);
    }

    public static ISurface surface(IVecI[] iVecIArray, int n, double[] dArray) {
        return ISurfaceCreator.surface(iVecIArray, n, dArray);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        return IG.surface(iVecIArray, n, n2, dArray, dArray2, d, d2, d3, d4);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, double[] dArray, double[] dArray2) {
        return IG.surface(iVecIArray, n, n2, dArray, dArray2);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2) {
        return IG.surface(iVecIArray, n, n2);
    }

    public static ISurface srf(IVecI[][] iVecIArray) {
        return IG.surface(iVecIArray);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return IG.surface(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, boolean bl, double[] dArray) {
        return IG.surface(iVecIArray, n, n2, bl, dArray);
    }

    public static ISurface srf(IVecI[][] iVecIArray, int n, int n2, double[] dArray, boolean bl) {
        return IG.surface(iVecIArray, n, n2, dArray, bl);
    }

    public static ISurface srf(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return IG.surface(iVecIArray, bl, bl2);
    }

    public static ISurface srf(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IG.surface(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static ISurface srf(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return IG.surface(iVecI, iVecI2, iVecI3);
    }

    public static ISurface srf(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return IG.surface(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static ISurface srf(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return IG.surface(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static ISurface srf(double[][][] dArray) {
        return IG.surface(dArray);
    }

    public static ISurface srf(double[][][] dArray, int n, int n2) {
        return IG.surface(dArray, n, n2);
    }

    public static ISurface srf(double[][][] dArray, boolean bl, boolean bl2) {
        return IG.surface(dArray, bl, bl2);
    }

    public static ISurface srf(double[][][] dArray, int n, int n2, boolean bl, boolean bl2) {
        return IG.surface(dArray, n, n2, bl, bl2);
    }

    public static ISurface srf(ISurfaceI iSurfaceI) {
        return IG.surface(iSurfaceI);
    }

    public static ISurface srf(ICurveI iCurveI) {
        return IG.surface(iCurveI);
    }

    public static ISurface srf(ICurveI iCurveI, ICurveI[] iCurveIArray) {
        return IG.surface(iCurveI, iCurveIArray);
    }

    public static ISurface srf(ICurveI iCurveI, ICurveI iCurveI2) {
        return IG.surface(iCurveI, iCurveI2);
    }

    public static ISurface srf(ICurveI[] iCurveIArray) {
        return IG.surface(iCurveIArray);
    }

    public static ISurface srf(IVecI[] iVecIArray) {
        return IG.surface(iVecIArray);
    }

    public static ISurface srf(IVecI[] iVecIArray, int n) {
        return IG.surface(iVecIArray, n);
    }

    public static ISurface srf(IVecI[] iVecIArray, int n, double[] dArray) {
        return IG.surface(iVecIArray, n, dArray);
    }

    public static IBox box(double d, double d2, double d3, double d4) {
        return ISurfaceCreator.box(d, d2, d3, d4);
    }

    public static IBox box(double d, double d2, double d3, double d4, double d5, double d6) {
        return ISurfaceCreator.box(d, d2, d3, d4, d5, d6);
    }

    public static IBox box(IVecI iVecI, double d) {
        return ISurfaceCreator.box(iVecI, d);
    }

    public static IBox box(IVecI iVecI, double d, double d2, double d3) {
        return ISurfaceCreator.box(iVecI, d, d2, d3);
    }

    public static IBox box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return ISurfaceCreator.box(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IBox box(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6, IVecI iVecI7, IVecI iVecI8) {
        return ISurfaceCreator.box(iVecI, iVecI2, iVecI3, iVecI4, iVecI5, iVecI6, iVecI7, iVecI8);
    }

    public static IBox box(IVecI[][][] iVecIArray) {
        return ISurfaceCreator.box(iVecIArray);
    }

    public static ISphere sphere(double d, double d2, double d3, double d4) {
        return ISurfaceCreator.sphere(d, d2, d3, d4);
    }

    public static ISphere sphere(IVecI iVecI, double d) {
        return ISurfaceCreator.sphere(iVecI, d);
    }

    public static ISphere sphere(IVecI iVecI, IDoubleI iDoubleI) {
        return ISurfaceCreator.sphere(iVecI, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, d);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, iDoubleI);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, d, d2);
    }

    public static ICylinder cylinder(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return ISurfaceCreator.cylinder(iVecI, iVecI2, iDoubleI, iDoubleI2);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.cone(iVecI, iVecI2, d);
    }

    public static ICylinder cone(IVecI iVecI, IVecI iVecI2, IDoubleI iDoubleI) {
        return ISurfaceCreator.cone(iVecI, iVecI2, iDoubleI);
    }

    public static ISurface plane(IVecI iVecI, double d, double d2) {
        return ISurfaceCreator.plane(iVecI, d, d2);
    }

    public static ISurface plane(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return ISurfaceCreator.plane(iVecI, iVecI2, iVecI3);
    }

    public static ISurface plane(double d, double d2, double d3, double d4, double d5) {
        return ISurfaceCreator.plane((IVecI)new IVec(d, d2, d3), d4, d5);
    }

    public static ISurface extrude(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.extrude(iVecIArray, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, d);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iVecI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iCurve);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, ICurve iCurve) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iCurve);
    }

    public static ISurface extrude(ICurveI iCurveI, IVecI iVecI) {
        return ISurfaceCreator.extrude(iCurveI, iVecI);
    }

    public static ISurface extrude(ICurveI iCurveI, double d) {
        return ISurfaceCreator.extrude(iCurveI, d);
    }

    public static ISurface extrude(ICurveI iCurveI, IDoubleI iDoubleI) {
        return ISurfaceCreator.extrude(iCurveI, iDoubleI);
    }

    public static ISurface extrude(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.extrude(iVecIArray, iVecIArray2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.extrude(iVecIArray, n, iVecIArray2, n2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.extrude(iVecIArray, n, bl, iVecIArray2, n2, bl2);
    }

    public static ISurface extrude(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.extrude(iVecIArray, n, dArray, iVecIArray2, n2, dArray2);
    }

    public static ISurface extrude(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.extrude(iCurveI, iCurveI2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecI2, iVecIArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecI2, iVecIArray2, n2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, boolean bl2) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecI2, iVecIArray2, n2, bl2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iCurveI);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, boolean bl, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI) {
        return ISurfaceCreator.sweep(iVecIArray, n, bl, iVecI, iVecI2, iCurveI);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray, n);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray, int n, boolean bl) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iVecIArray, n, bl);
    }

    public static ISurface sweep(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iCurveI2);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iCurveI2);
    }

    public static ISurface sweep(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2, ICurveI iCurveI2) {
        return ISurfaceCreator.sweep(iCurveI, iVecI, iVecI2, iCurveI2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecI, iVecIArray2, n2, dArray2);
    }

    public static ISurface sweep(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI, IVecI iVecI2, IVecI[] iVecIArray2, int n2, double[] dArray2) {
        return ISurfaceCreator.sweep(iVecIArray, n, dArray, iVecI, iVecI2, iVecIArray2, n2, dArray2);
    }

    public static ISurface pipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.pipe(iVecI, iVecI2, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, bl, d);
    }

    public static ISurface pipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.pipe(iCurveI, d);
    }

    public static ISurface pipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.pipe(iVecIArray, n, dArray, d);
    }

    public static ISurface squarePipe(IVecI iVecI, IVecI iVecI2, double d) {
        return ISurfaceCreator.squarePipe(iVecI, iVecI2, d);
    }

    public static ISurface squarePipe(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d) {
        return ISurfaceCreator.squarePipe(iVecI, iVecI2, iVecI3, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, boolean bl, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, bl, d);
    }

    public static ISurface squarePipe(ICurveI iCurveI, double d) {
        return ISurfaceCreator.squarePipe(iCurveI, d);
    }

    public static ISurface squarePipe(IVecI[] iVecIArray, int n, double[] dArray, double d) {
        return ISurfaceCreator.squarePipe(iVecIArray, n, dArray, d);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, d, d2);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, iVecI3, d, d2);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecI, iVecI2, iVecI3, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, boolean bl, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, bl, d, d2, d3, d4);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d2);
    }

    public static ISurface rectPipe(ICurveI iCurveI, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iCurveI, d, d2, d3, d4);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d2);
    }

    public static ISurface rectPipe(IVecI[] iVecIArray, int n, double[] dArray, double d, double d2, double d3, double d4) {
        return ISurfaceCreator.rectPipe(iVecIArray, n, dArray, d, d2, d3, d4);
    }

    public static ISurface loft(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loft(iCurveIArray);
    }

    public static ISurface loft(ICurveI iCurveI, ICurveI iCurveI2) {
        return ISurfaceCreator.loft(iCurveI, iCurveI2);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loft(iCurveIArray, n);
    }

    public static ISurface loft(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loft(iCurveIArray, n, bl);
    }

    public static ISurface loft(IVecI[][] iVecIArray) {
        return ISurfaceCreator.loft(iVecIArray);
    }

    public static ISurface loft(IVecI[][] iVecIArray, boolean bl, boolean bl2) {
        return ISurfaceCreator.loft(iVecIArray, bl, bl2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2) {
        return ISurfaceCreator.loft(iVecIArray, n, n2);
    }

    public static ISurface loft(IVecI[][] iVecIArray, int n, int n2, boolean bl, boolean bl2) {
        return ISurfaceCreator.loft(iVecIArray, n, n2, bl, bl2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, n);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, int n, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, n, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, bl);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, n, n2);
    }

    public static ISurface loft(IVecI[] iVecIArray, IVecI[] iVecIArray2, IVecI[] iVecIArray3, int n, int n2, boolean bl) {
        return ISurfaceCreator.loft(iVecIArray, iVecIArray2, iVecIArray3, n, n2, bl);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftX(iCurveIArray);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftX(iCurveIArray, n);
    }

    public static ISurface loftX(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftX(iCurveIArray, n, bl);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftY(iCurveIArray);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftY(iCurveIArray, n);
    }

    public static ISurface loftY(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftY(iCurveIArray, n, bl);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray) {
        return ISurfaceCreator.loftZ(iCurveIArray);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n) {
        return ISurfaceCreator.loftZ(iCurveIArray, n);
    }

    public static ISurface loftZ(ICurveI[] iCurveIArray, int n, boolean bl) {
        return ISurfaceCreator.loftZ(iCurveIArray, n, bl);
    }

    public static ICurve flatten(ICurveI iCurveI, IVecI iVecI, IVecI iVecI2) {
        return ICurveCreator.flatten(iCurveI, iVecI, iVecI2);
    }

    public static ICurve flatten(ICurveI iCurveI, IVecI iVecI) {
        return ICurveCreator.flatten(iCurveI, iVecI);
    }

    public static ICurve flatten(ICurveI iCurveI) {
        return ICurveCreator.flatten(iCurveI);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI, IVecI iVecI2) {
        return ISurfaceCreator.flatten(iSurfaceI, iVecI, iVecI2);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI, IVecI iVecI) {
        return ISurfaceCreator.flatten(iSurfaceI, iVecI);
    }

    public static ISurface flatten(ISurfaceI iSurfaceI) {
        return ISurfaceCreator.flatten(iSurfaceI);
    }

    public static IBrep cap(ISurfaceI iSurfaceI) {
        return ISurfaceCreator.cap(iSurfaceI);
    }

    public static ISurface profileSurface(IVecI[] iVecIArray, int n, double[] dArray) {
        return ISurfaceCreator.profileSurface(iVecIArray, n, dArray);
    }

    public static ISurface profileSurface(ICurveI iCurveI) {
        return ISurfaceCreator.profileSurface(iCurveI);
    }

    public static ISurface radialSurface(IVecI[] iVecIArray, int n, double[] dArray) {
        return ISurfaceCreator.radialSurface(iVecIArray, n, dArray);
    }

    public static ISurface radialSurface(ICurveI iCurveI) {
        return ISurfaceCreator.radialSurface(iCurveI);
    }

    public static ISurface pointLoft(IVecI[] iVecIArray, int n, double[] dArray, IVecI iVecI) {
        return ISurfaceCreator.pointLoft(iVecIArray, n, dArray, iVecI);
    }

    public static ISurface pointLoft(ICurveI iCurveI, IVecI iVecI) {
        return ISurfaceCreator.pointLoft(iCurveI, iVecI);
    }

    public static void meshType(IMeshType iMeshType) {
        IMeshCreator.meshType(iMeshType);
    }

    public static IMeshType meshType() {
        return IMeshCreator.meshType();
    }

    public static IMesh mesh() {
        return IMeshCreator.mesh();
    }

    public static IMesh mesh(IMeshGeo iMeshGeo) {
        return IMeshCreator.mesh(iMeshGeo);
    }

    public static IMesh mesh(IMesh iMesh) {
        return IMeshCreator.mesh(iMesh);
    }

    public static IMesh mesh(ArrayList<ICurveI> arrayList) {
        return IMeshCreator.mesh(arrayList);
    }

    public static IMesh mesh(ICurveI[] iCurveIArray) {
        return IMeshCreator.mesh(iCurveIArray);
    }

    public static IMesh mesh(IVec[][] iVecArray) {
        return IMeshCreator.mesh(iVecArray);
    }

    public static IMesh mesh(IVec[][] iVecArray, boolean bl) {
        return IMeshCreator.mesh(iVecArray, bl);
    }

    public static IMesh mesh(IVec[][] iVecArray, int n, int n2, boolean bl) {
        return IMeshCreator.mesh(iVecArray, bl);
    }

    public static IMesh mesh(ArrayList<IVertex> arrayList, ArrayList<IEdge> arrayList2, ArrayList<IFace> arrayList3) {
        return IMeshCreator.mesh(arrayList, arrayList2, arrayList3);
    }

    public static IMesh mesh(IVertex[] iVertexArray, IEdge[] iEdgeArray, IFace[] iFaceArray) {
        return IMeshCreator.mesh(iVertexArray, iEdgeArray, iFaceArray);
    }

    public static IMesh mesh(IVec[] iVecArray) {
        return IMeshCreator.mesh(iVecArray);
    }

    public static IMesh mesh(IVertex[] iVertexArray) {
        return IMeshCreator.mesh(iVertexArray);
    }

    public static IMesh mesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3) {
        return IMeshCreator.mesh(iVertex, iVertex2, iVertex3);
    }

    public static IMesh mesh(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        return IMeshCreator.mesh(iVertex, iVertex2, iVertex3, iVertex4);
    }

    public static IMesh mesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return IMeshCreator.mesh(iVecI, iVecI2, iVecI3);
    }

    public static IMesh mesh(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IMeshCreator.mesh(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IMesh mesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return IMeshCreator.mesh(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public static IMesh mesh(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return IMeshCreator.mesh(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
    }

    public static IMesh mesh(IFace[] iFaceArray) {
        return IMeshCreator.mesh(iFaceArray);
    }

    public static IMesh meshFromTriangles(IVecI[][] iVecIArray) {
        return IMeshCreator.meshFromTriangles(iVecIArray);
    }

    public static IMesh meshBox(double d, double d2, double d3, double d4) {
        return IMeshCreator.box(d, d2, d3, d4);
    }

    public static IMesh meshBox(double d, double d2, double d3, double d4, double d5, double d6) {
        return IMeshCreator.box(d, d2, d3, d4, d5, d6);
    }

    public static IMesh meshBox(IVecI iVecI, double d) {
        return IMeshCreator.box(iVecI, d);
    }

    public static IMesh meshBox(IVecI iVecI, double d, double d2, double d3) {
        return IMeshCreator.box(iVecI, d, d2, d3);
    }

    public static IMesh meshBox(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IMeshCreator.box(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IMesh meshBox(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4, IVecI iVecI5, IVecI iVecI6, IVecI iVecI7, IVecI iVecI8) {
        return IMeshCreator.box(iVecI, iVecI2, iVecI3, iVecI4, iVecI5, iVecI6, iVecI7, iVecI8);
    }

    public static IMesh meshBox(IVecI[][][] iVecIArray) {
        return IMeshCreator.box(iVecIArray);
    }

    public static IMesh meshBox(IVertex[][][] iVertexArray) {
        return IMeshCreator.box(iVertexArray);
    }

    public static IMesh meshTetrahedron(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IMeshCreator.tetrahedron(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IMesh meshTetrahedron(IVecI[] iVecIArray) {
        return IMeshCreator.tetrahedron(iVecIArray);
    }

    public static IMesh meshTetrahedron(IVertex iVertex, IVertex iVertex2, IVertex iVertex3, IVertex iVertex4) {
        return IMeshCreator.tetrahedron(iVertex, iVertex2, iVertex3, iVertex4);
    }

    public static IMesh meshTetrahedron(IVertex[] iVertexArray) {
        return IMeshCreator.tetrahedron(iVertexArray);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, int n) {
        return IMeshCreator.sphere(iVecI, iVecI2, iVecI3, n);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return IMeshCreator.sphere(iVecI, iVecI2, iVecI3);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2, int n) {
        return IMeshCreator.sphere(iVecI, iVecI2, n);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2) {
        return IMeshCreator.sphere(iVecI, iVecI2);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2, double d, int n) {
        return IMeshCreator.sphere(iVecI, iVecI2, d, n);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2, double d, double d2, int n) {
        return IMeshCreator.sphere(iVecI, iVecI2, d, d2, n);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.sphere(iVecI, iVecI2, d);
    }

    public static IMesh meshSphere(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.sphere(iVecI, iVecI2, d, d2);
    }

    public static IMesh meshSphere(IVecI iVecI, double d, int n) {
        return IMeshCreator.sphere(iVecI, d, n);
    }

    public static IMesh meshSphere(IVecI iVecI, double d) {
        return IMeshCreator.sphere(iVecI, d);
    }

    public static IMesh meshSphere(IVecI iVecI, double d, double d2, int n) {
        return IMeshCreator.sphere(iVecI, d, d2, n);
    }

    public static IMesh meshSphere(IVecI iVecI, double d, double d2) {
        return IMeshCreator.sphere(iVecI, d, d2);
    }

    public static IMesh meshRectStick(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IMeshCreator.rectStick(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IMesh meshRectStick(IVecI iVecI, IVecI iVecI2, double d, double d2, IVecI iVecI3) {
        return IMeshCreator.rectStick(iVecI, iVecI2, d, d2, iVecI3);
    }

    public static IMesh meshRectStick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.rectStick(iVecI, iVecI2, d, d2);
    }

    public static IMesh meshSquareStick(IVecI iVecI, IVecI iVecI2, double d, IVecI iVecI3) {
        return IMeshCreator.squareStick(iVecI, iVecI2, d, iVecI3);
    }

    public static IMesh meshSquareStick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.squareStick(iVecI, iVecI2, d);
    }

    public static IMesh meshPolygonStick(IVecI iVecI, IVecI iVecI2, double d, int n) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, n);
    }

    public static IMesh meshPolygonStick(IVecI iVecI, IVecI iVecI2, double d, int n, IVecI iVecI3) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, n, iVecI3);
    }

    public static IMesh meshPolygonStick(IVecI iVecI, IVecI iVecI2, double d, double d2, int n) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d2, n);
    }

    public static IMesh meshPolygonStick(IVecI iVecI, IVecI iVecI2, double d, double d2, int n, IVecI iVecI3) {
        return IMeshCreator.polygonStick(iVecI, iVecI2, d, d2, n, iVecI3);
    }

    public static IMesh meshPolygonStick(ICurveI iCurveI, double d, int n, int n2) {
        return IMeshCreator.polygonStick(iCurveI, d, n, n2);
    }

    public static IMesh meshPolygonStick(ICurveI iCurveI, double d, int n) {
        return IMeshCreator.polygonStick(iCurveI, d, n);
    }

    public static IMesh meshStick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.stick(iVecI, iVecI2, d);
    }

    public static IMesh meshStick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.stick(iVecI, iVecI2, d, d2);
    }

    public static IMesh meshStick(ICurveI iCurveI, double d, int n) {
        return IMeshCreator.roundStick(iCurveI, d, n);
    }

    public static IMesh meshStick(ICurveI iCurveI, double d) {
        return IMeshCreator.roundStick(iCurveI, d);
    }

    public static IMesh meshRoundStick(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.roundStick(iVecI, iVecI2, d);
    }

    public static IMesh meshRoundStick(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.roundStick(iVecI, iVecI2, d, d2);
    }

    public static IMesh meshRoundStick(ICurveI iCurveI, double d, int n) {
        return IMeshCreator.roundStick(iCurveI, d, n);
    }

    public static IMesh meshRoundStick(ICurveI iCurveI, double d) {
        return IMeshCreator.roundStick(iCurveI, d);
    }

    public static IMesh meshSquareStick(ICurveI iCurveI, double d, int n) {
        return IMeshCreator.squareStick(iCurveI, d, n);
    }

    public static IMesh meshSquareStick(ICurveI iCurveI, double d) {
        return IMeshCreator.squareStick(iCurveI, d);
    }

    public static IMesh meshRectPipe(IVecI iVecI, IVecI iVecI2, IVecI iVecI3, IVecI iVecI4) {
        return IMeshCreator.rectPipe(iVecI, iVecI2, iVecI3, iVecI4);
    }

    public static IMesh meshRectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2, IVecI iVecI3) {
        return IMeshCreator.rectPipe(iVecI, iVecI2, d, d2, iVecI3);
    }

    public static IMesh meshRectPipe(IVecI iVecI, IVecI iVecI2, double d, double d2) {
        return IMeshCreator.rectPipe(iVecI, iVecI2, d, d2);
    }

    public static IMesh meshSquarePipe(IVecI iVecI, IVecI iVecI2, double d, IVecI iVecI3) {
        return IMeshCreator.squarePipe(iVecI, iVecI2, d, iVecI3);
    }

    public static IMesh meshSquarePipe(IVecI iVecI, IVecI iVecI2, double d) {
        return IMeshCreator.squarePipe(iVecI, iVecI2, d);
    }

    public static IVec vec() {
        return IG.v();
    }

    public static IVec vec(double d, double d2, double d3) {
        return IG.v(d, d2, d3);
    }

    public static IVec vec(double d, double d2) {
        return IG.v(d, d2);
    }

    public static IVec vec(IVec iVec) {
        return IG.v(iVec);
    }

    public static IVec vec(IVecI iVecI) {
        return IG.v(iVecI);
    }

    public static IVec vec(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public static IVec vec(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v(iDoubleI, iDoubleI2);
    }

    public static IVec vec(IVec2I iVec2I) {
        return IG.v(iVec2I);
    }

    public static IVec v() {
        return new IVec();
    }

    public static IVec v(double d, double d2, double d3) {
        return new IVec(d, d2, d3);
    }

    public static IVec v(double d, double d2) {
        return new IVec(d, d2);
    }

    public static IVec v(IVec iVec) {
        return new IVec(iVec);
    }

    public static IVec v(IVecI iVecI) {
        return new IVec(iVecI);
    }

    public static IVec v(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return new IVec(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public static IVec v(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec(iDoubleI, iDoubleI2, new IDouble(0.0));
    }

    public static IVec v(IVec2I iVec2I) {
        return new IVec(iVec2I);
    }

    public static IVec vector() {
        return IG.v();
    }

    public static IVec vector(double d, double d2, double d3) {
        return IG.v(d, d2, d3);
    }

    public static IVec vector(double d, double d2) {
        return IG.v(d, d2);
    }

    public static IVec vector(IVec iVec) {
        return IG.v(iVec);
    }

    public static IVec vector(IVecI iVecI) {
        return IG.v(iVecI);
    }

    public static IVec vector(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3);
    }

    public static IVec vector(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v(iDoubleI, iDoubleI2);
    }

    public static IVec vector(IVec2I iVec2I) {
        return IG.v(iVec2I);
    }

    public static IVec4 vec4() {
        return IG.v4();
    }

    public static IVec4 vec4(double d, double d2, double d3, double d4) {
        return IG.v4(d, d2, d3, d4);
    }

    public static IVec4 vec4(IVec iVec, double d) {
        return IG.v4(iVec, d);
    }

    public static IVec4 vec4(IVec4 iVec4) {
        return IG.v4(iVec4);
    }

    public static IVec4 vec4(IVecI iVecI) {
        return IG.v4(iVecI);
    }

    public static IVec4 vec4(IVecI iVecI, double d) {
        return IG.v4(iVecI, d);
    }

    public static IVec4 vec4(IVecI iVecI, IDoubleI iDoubleI) {
        return IG.v4(iVecI, iDoubleI);
    }

    public static IVec4 vec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public static IVec4 v4() {
        return new IVec4();
    }

    public static IVec4 v4(double d, double d2, double d3, double d4) {
        return new IVec4(d, d2, d3, d4);
    }

    public static IVec4 v4(IVec iVec, double d) {
        return new IVec4(iVec, d);
    }

    public static IVec4 v4(IVec4 iVec4) {
        return new IVec4(iVec4);
    }

    public static IVec4 v4(IVecI iVecI) {
        return new IVec4(iVecI);
    }

    public static IVec4 v4(IVecI iVecI, double d) {
        return new IVec4(iVecI, d);
    }

    public static IVec4 v4(IVecI iVecI, IDoubleI iDoubleI) {
        return new IVec4(iVecI, iDoubleI);
    }

    public static IVec4 v4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        return new IVec4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public static IVec4 vector4() {
        return IG.v4();
    }

    public static IVec4 vector4(double d, double d2, double d3, double d4) {
        return IG.v4(d, d2, d3, d4);
    }

    public static IVec4 vector4(IVec iVec, double d) {
        return IG.v4(iVec, d);
    }

    public static IVec4 vector4(IVec4 iVec4) {
        return IG.v4(iVec4);
    }

    public static IVec4 vector4(IVecI iVecI) {
        return IG.v4(iVecI);
    }

    public static IVec4 vector4(IVecI iVecI, double d) {
        return IG.v4(iVecI, d);
    }

    public static IVec4 vector4(IVecI iVecI, IDoubleI iDoubleI) {
        return IG.v4(iVecI, iDoubleI);
    }

    public static IVec4 vector4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
    }

    public static IVec2 vec2() {
        return IG.v2();
    }

    public static IVec2 vec2(double d, double d2) {
        return IG.v2(d, d2);
    }

    public static IVec2 vec2(IVec2 iVec2) {
        return IG.v2(iVec2);
    }

    public static IVec2 vec2(IVecI iVecI) {
        return IG.v2(iVecI);
    }

    public static IVec2 vec2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v2(iDoubleI, iDoubleI2);
    }

    public static IVec2 v2() {
        return new IVec2();
    }

    public static IVec2 v2(double d, double d2) {
        return new IVec2(d, d2);
    }

    public static IVec2 v2(IVec2 iVec2) {
        return new IVec2(iVec2);
    }

    public static IVec2 v2(IVecI iVecI) {
        return new IVec2(iVecI);
    }

    public static IVec2 v2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return new IVec2(iDoubleI, iDoubleI2);
    }

    public static IVec2 vector2() {
        return IG.v2();
    }

    public static IVec2 vector2(double d, double d2) {
        return IG.v2(d, d2);
    }

    public static IVec2 vector2(IVec2 iVec2) {
        return IG.v2(iVec2);
    }

    public static IVec2 vector2(IVecI iVecI) {
        return IG.v2(iVecI);
    }

    public static IVec2 vector2(IDoubleI iDoubleI, IDoubleI iDoubleI2) {
        return IG.v2(iDoubleI, iDoubleI2);
    }

    public static IVec[] vec(double d, double d2, double d3, double ... dArray) {
        return IG.v(d, d2, d3, dArray);
    }

    public static IVec[] vec(IVec ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[] vec(IVecI ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[] vec(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI ... iDoubleIArray) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3, iDoubleIArray);
    }

    public static IVec[] vec(IVec2I ... iVec2IArray) {
        return IG.v(iVec2IArray);
    }

    public static IVec[][] vec(IVec[] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][] vec(IVecI[] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[][][] vec(IVec[][] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][][] vec(IVecI[][] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[] v(double d, double d2, double d3, double ... dArray) {
        int n = dArray.length / 3 + 1;
        if (dArray.length % 3 > 0) {
            ++n;
        }
        IVec[] iVecArray = new IVec[n];
        iVecArray[0] = new IVec(d, d2, d3);
        for (int i = 1; i < n; ++i) {
            iVecArray[i] = new IVec(dArray[(i - 1) * 3], (i - 1) * 3 + 1 < dArray.length ? dArray[(i - 1) * 3 + 1] : 0.0, (i - 1) * 3 + 2 < dArray.length ? dArray[(i - 1) * 3 + 2] : 0.0);
        }
        return iVecArray;
    }

    public static IVec[] v(IVec ... iVecArray) {
        return iVecArray;
    }

    public static IVecI[] v(IVecI ... iVecIArray) {
        return iVecIArray;
    }

    public static IVec[] v(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI ... iDoubleIArray) {
        int n = iDoubleIArray.length / 3 + 1;
        if (iDoubleIArray.length % 3 > 0) {
            ++n;
        }
        IVec[] iVecArray = new IVec[n];
        iVecArray[0] = new IVec(iDoubleI, iDoubleI2, iDoubleI3);
        for (int i = 1; i < n; ++i) {
            iVecArray[i] = new IVec(iDoubleIArray[(i - 1) * 3], (i - 1) * 3 + 1 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 3 + 1] : new IDouble(0.0), (i - 1) * 3 + 2 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 3 + 2] : new IDouble(0.0));
        }
        return iVecArray;
    }

    public static IVec[] v(IVec2I ... iVec2IArray) {
        if (iVec2IArray == null) {
            return null;
        }
        IVec[] iVecArray = new IVec[iVec2IArray.length];
        for (int i = 0; i < iVec2IArray.length; ++i) {
            iVecArray[i] = new IVec(iVec2IArray[i]);
        }
        return iVecArray;
    }

    public static IVec[][] v(IVec[] ... iVecArray) {
        return iVecArray;
    }

    public static IVecI[][] v(IVecI[] ... iVecIArray) {
        return iVecIArray;
    }

    public static IVec[][][] v(IVec[][] ... iVecArray) {
        return iVecArray;
    }

    public static IVecI[][][] v(IVecI[][] ... iVecIArray) {
        return iVecIArray;
    }

    public static IVec[] vector(double d, double d2, double d3, double ... dArray) {
        return IG.v(d, d2, d3, dArray);
    }

    public static IVec[] vector(IVec ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[] vector(IVecI ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[] vector(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI ... iDoubleIArray) {
        return IG.v(iDoubleI, iDoubleI2, iDoubleI3, iDoubleIArray);
    }

    public static IVec[] vector(IVec2I ... iVec2IArray) {
        return IG.v(iVec2IArray);
    }

    public static IVec[][] vector(IVec[] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][] vector(IVecI[] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec[][][] vector(IVec[][] ... iVecArray) {
        return IG.v(iVecArray);
    }

    public static IVecI[][][] vector(IVecI[][] ... iVecIArray) {
        return IG.v(iVecIArray);
    }

    public static IVec4[] vec4(double d, double d2, double d3, double d4, double ... dArray) {
        return IG.v4(d, d2, d3, d4, dArray);
    }

    public static IVec4[] vec4(IVec4 ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[] vec4(IVec4I ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[] vec4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI ... iDoubleIArray) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleIArray);
    }

    public static IVec4[][] vec4(IVec4[] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][] vec4(IVec4I[] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[][][] vec4(IVec4[][] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][][] vec4(IVec4I[][] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[] v4(double d, double d2, double d3, double d4, double ... dArray) {
        int n = dArray.length / 4 + 1;
        if (dArray.length % 4 > 0) {
            ++n;
        }
        IVec4[] iVec4Array = new IVec4[n];
        iVec4Array[0] = new IVec4(d, d2, d3, d4);
        for (int i = 1; i < n; ++i) {
            iVec4Array[i] = new IVec4(dArray[(i - 1) * 4], (i - 1) * 4 + 1 < dArray.length ? dArray[(i - 1) * 4 + 1] : 0.0, (i - 1) * 4 + 2 < dArray.length ? dArray[(i - 1) * 4 + 2] : 0.0, (i - 1) * 4 + 3 < dArray.length ? dArray[(i - 1) * 4 + 3] : 0.0);
        }
        return iVec4Array;
    }

    public static IVec4[] v4(IVec4 ... iVec4Array) {
        return iVec4Array;
    }

    public static IVec4I[] v4(IVec4I ... iVec4IArray) {
        return iVec4IArray;
    }

    public static IVec4[] v4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI ... iDoubleIArray) {
        int n = iDoubleIArray.length / 4 + 1;
        if (iDoubleIArray.length % 4 > 0) {
            ++n;
        }
        IVec4[] iVec4Array = new IVec4[n];
        iVec4Array[0] = new IVec4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4);
        for (int i = 1; i < n; ++i) {
            iVec4Array[i] = new IVec4(iDoubleIArray[(i - 1) * 4], (i - 1) * 4 + 1 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 4 + 1] : new IDouble(0.0), (i - 1) * 4 + 2 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 4 + 2] : new IDouble(0.0), (i - 1) * 4 + 3 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 4 + 3] : new IDouble(0.0));
        }
        return iVec4Array;
    }

    public static IVec4[][] v4(IVec4[] ... iVec4Array) {
        return iVec4Array;
    }

    public static IVec4I[][] v4(IVec4I[] ... iVec4IArray) {
        return iVec4IArray;
    }

    public static IVec4[][][] v4(IVec4[][] ... iVec4Array) {
        return iVec4Array;
    }

    public static IVec4I[][][] v4(IVec4I[][] ... iVec4IArray) {
        return iVec4IArray;
    }

    public static IVec4[] vector4(double d, double d2, double d3, double d4, double ... dArray) {
        return IG.v4(d, d2, d3, d4, dArray);
    }

    public static IVec4[] vector4(IVec4 ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[] vector4(IVec4I ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[] vector4(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI iDoubleI3, IDoubleI iDoubleI4, IDoubleI ... iDoubleIArray) {
        return IG.v4(iDoubleI, iDoubleI2, iDoubleI3, iDoubleI4, iDoubleIArray);
    }

    public static IVec4[][] vector4(IVec4[] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][] vector4(IVec4I[] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec4[][][] vector4(IVec4[][] ... iVec4Array) {
        return IG.v4(iVec4Array);
    }

    public static IVec4I[][][] vector4(IVec4I[][] ... iVec4IArray) {
        return IG.v4(iVec4IArray);
    }

    public static IVec2[] vec2(double d, double d2, double ... dArray) {
        return IG.v2(d, d2, dArray);
    }

    public static IVec2[] vec2(IVec2 ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[] vec2(IVec2I ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[] vec2(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI ... iDoubleIArray) {
        return IG.v2(iDoubleI, iDoubleI2, iDoubleIArray);
    }

    public static IVec2I[] vec2(IVecI ... iVecIArray) {
        return IG.v2(iVecIArray);
    }

    public static IVec2[] vec2(IVec ... iVecArray) {
        return IG.v2(iVecArray);
    }

    public static IVec2[][] vec2(IVec2[] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][] vec2(IVec2I[] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[][][] vec2(IVec2[][] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][][] vec2(IVec2I[][] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[] v2(double d, double d2, double ... dArray) {
        int n = dArray.length / 2 + 1;
        if (dArray.length % 2 > 0) {
            ++n;
        }
        IVec2[] iVec2Array = new IVec2[n];
        iVec2Array[0] = new IVec2(d, d2);
        for (int i = 1; i < n; ++i) {
            iVec2Array[i] = new IVec2(dArray[(i - 1) * 2], (i - 1) * 2 + 1 < dArray.length ? dArray[(i - 1) * 2 + 1] : 0.0);
        }
        return iVec2Array;
    }

    public static IVec2[] v2(IVec2 ... iVec2Array) {
        return iVec2Array;
    }

    public static IVec2I[] v2(IVec2I ... iVec2IArray) {
        return iVec2IArray;
    }

    public static IVec2[] v2(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI ... iDoubleIArray) {
        int n = iDoubleIArray.length / 2 + 1;
        if (iDoubleIArray.length % 2 > 0) {
            ++n;
        }
        IVec2[] iVec2Array = new IVec2[n];
        iVec2Array[0] = new IVec2(iDoubleI, iDoubleI2);
        for (int i = 1; i < n; ++i) {
            iVec2Array[i] = new IVec2(iDoubleIArray[(i - 1) * 2], (i - 1) * 2 + 1 < iDoubleIArray.length ? iDoubleIArray[(i - 1) * 2 + 1] : new IDouble(0.0));
        }
        return iVec2Array;
    }

    public static IVec2[] v2(IVec ... iVecArray) {
        IVec2[] iVec2Array = new IVec2[iVecArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            iVec2Array[i] = iVecArray[i].to2d();
        }
        return iVec2Array;
    }

    public static IVec2I[] v2(IVecI ... iVecIArray) {
        IVec2I[] iVec2IArray = new IVec2I[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVec2IArray[i] = iVecIArray[i].to2d();
        }
        return iVec2IArray;
    }

    public static IVec2[][] v2(IVec2[] ... iVec2Array) {
        return iVec2Array;
    }

    public static IVec2I[][] v2(IVec2I[] ... iVec2IArray) {
        return iVec2IArray;
    }

    public static IVec2[][][] v2(IVec2[][] ... iVec2Array) {
        return iVec2Array;
    }

    public static IVec2I[][][] v2(IVec2I[][] ... iVec2IArray) {
        return iVec2IArray;
    }

    public static IVec2[] vector2(double d, double d2, double ... dArray) {
        return IG.v2(d, d2, dArray);
    }

    public static IVec2[] vector2(IVec2 ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[] vector2(IVec2I ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[] vector2(IDoubleI iDoubleI, IDoubleI iDoubleI2, IDoubleI ... iDoubleIArray) {
        return IG.v2(iDoubleI, iDoubleI2, iDoubleIArray);
    }

    public static IVec2[][] vector2(IVec2[] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][] vector2(IVec2I[] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static IVec2[][][] vector2(IVec2[][] ... iVec2Array) {
        return IG.v2(iVec2Array);
    }

    public static IVec2I[][][] vector2(IVec2I[][] ... iVec2IArray) {
        return IG.v2(iVec2IArray);
    }

    public static <T> T[] array(T ... TArray) {
        return IG.a(TArray);
    }

    public static <T> T[] array(int n, T ... TArray) {
        return IG.a(n, TArray);
    }

    public static <T> T[][] array2(int n, int n2, T ... TArray) {
        return IG.a2(n, n2, TArray);
    }

    public static <T> T[][] array2(int n, T ... TArray) {
        return IG.a2(n, TArray);
    }

    public static <T> T[][][] array3(int n, int n2, int n3, T ... TArray) {
        return IG.a3(n, n2, n3, TArray);
    }

    public static <T> T[][][] array3(int n, int n2, T ... TArray) {
        return IG.a3(n, n2, TArray);
    }

    public static <T> T[] arr(T ... TArray) {
        return IG.a(TArray);
    }

    public static <T> T[] arr(int n, T ... TArray) {
        return IG.a(n, TArray);
    }

    public static <T> T[][] arr2(int n, int n2, T ... TArray) {
        return IG.a2(n, n2, TArray);
    }

    public static <T> T[][] arr2(int n, T ... TArray) {
        return IG.a2(n, TArray);
    }

    public static <T> T[][][] arr3(int n, int n2, int n3, T ... TArray) {
        return IG.a3(n, n2, n3, TArray);
    }

    public static <T> T[][][] arr3(int n, int n2, T ... TArray) {
        return IG.a3(n, n2, TArray);
    }

    public static <T> T[] a(T ... TArray) {
        return TArray;
    }

    public static <T> T[] a(int n, T ... TArray) {
        if (TArray == null) {
            return null;
        }
        if (TArray.length != n) {
            IOut.err("length1*length2 doesn't match with number of values");
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray[0].getClass(), n);
        for (int i = 0; i < n && i < TArray.length; ++i) {
            objectArray[i] = TArray[i];
        }
        return TArray;
    }

    public static <T> T[][] a2(int n, int n2, T ... TArray) {
        int n3;
        if (TArray == null) {
            return null;
        }
        if (TArray.length != n * n2) {
            IOut.err("length1*length2 doesn't match with number of values");
        }
        Object[][] objectArray = (Object[][])Array.newInstance(TArray.getClass(), n);
        for (n3 = 0; n3 < n; ++n3) {
            objectArray[n3] = (Object[])Array.newInstance(TArray[0].getClass(), n2);
        }
        n3 = 0;
        for (int i = 0; i < n && n3 < TArray.length; ++i) {
            for (int j = 0; j < n2 && n3 < TArray.length; ++j) {
                objectArray[i][j] = TArray[n3++];
            }
        }
        return objectArray;
    }

    public static <T> T[][] a2(int n, T ... TArray) {
        if (TArray == null) {
            return null;
        }
        int n2 = TArray.length / n;
        if (TArray.length != n2 * n) {
            IOut.err("length2 doesn't match with number of values");
        }
        if (n2 == 0) {
            n2 = 1;
        }
        return IG.array2(n2, n, TArray);
    }

    public static <T> T[][][] a3(int n, int n2, int n3, T ... TArray) {
        int n4;
        int n5;
        if (TArray == null) {
            return null;
        }
        if (TArray.length != n * n2 * n3) {
            IOut.err("length1*length2*length3 doesn't match with number of values");
        }
        Object[][][] objectArray = (Object[][][])Array.newInstance(((Object[][])Array.newInstance(TArray.getClass(), 0)).getClass(), n);
        for (n5 = 0; n5 < n; ++n5) {
            objectArray[n5] = (Object[][])Array.newInstance(TArray.getClass(), n2);
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                objectArray[n5][n4] = (Object[])Array.newInstance(TArray[0].getClass(), n3);
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < n && n5 < TArray.length; ++n4) {
            for (int i = 0; i < n2 && n5 < TArray.length; ++i) {
                for (int j = 0; j < n3 && n5 < TArray.length; ++j) {
                    objectArray[n4][i][j] = TArray[n5++];
                }
            }
        }
        return objectArray;
    }

    public static <T> T[][][] a3(int n, int n2, T ... TArray) {
        if (TArray == null) {
            return null;
        }
        int n3 = TArray.length / (n * n2);
        if (TArray.length != n3 * n * n2) {
            IOut.err("length2*length3 doesn't match with number of values");
        }
        if (n3 == 0) {
            n3 = 1;
        }
        return IG.array3(n3, n, n2, TArray);
    }

    public static IVecI[] cp(IVecI ... iVecIArray) {
        if (iVecIArray == null) {
            return null;
        }
        IVecI[] iVecIArray2 = new IVecI[iVecIArray.length];
        for (int i = 0; i < iVecIArray.length; ++i) {
            iVecIArray2[i] = iVecIArray[i].cp();
        }
        return iVecIArray2;
    }

    public static IVec[] cp(IVec ... iVecArray) {
        if (iVecArray == null) {
            return null;
        }
        IVec[] iVecArray2 = new IVec[iVecArray.length];
        for (int i = 0; i < iVecArray.length; ++i) {
            iVecArray2[i] = iVecArray[i].cp();
        }
        return iVecArray2;
    }

    public static IVec2I[] cp(IVec2I ... iVec2IArray) {
        if (iVec2IArray == null) {
            return null;
        }
        IVec2I[] iVec2IArray2 = new IVec2I[iVec2IArray.length];
        for (int i = 0; i < iVec2IArray.length; ++i) {
            iVec2IArray2[i] = iVec2IArray[i].cp();
        }
        return iVec2IArray2;
    }

    public static IVec2[] cp(IVec2 ... iVec2Array) {
        if (iVec2Array == null) {
            return null;
        }
        IVec2[] iVec2Array2 = new IVec2[iVec2Array.length];
        for (int i = 0; i < iVec2Array.length; ++i) {
            iVec2Array2[i] = iVec2Array[i].cp();
        }
        return iVec2Array2;
    }

    public static IVec4[] cp(IVec4 ... iVec4Array) {
        if (iVec4Array == null) {
            return null;
        }
        IVec4[] iVec4Array2 = new IVec4[iVec4Array.length];
        for (int i = 0; i < iVec4Array.length; ++i) {
            iVec4Array2[i] = iVec4Array[i].cp();
        }
        return iVec4Array2;
    }

    public static IVecI[] copy(IVecI ... iVecIArray) {
        return IG.cp(iVecIArray);
    }

    public static IVec[] copy(IVec ... iVecArray) {
        return IG.cp(iVecArray);
    }

    public static IVec2I[] copy(IVec2I ... iVec2IArray) {
        return IG.cp(iVec2IArray);
    }

    public static IVec2[] copy(IVec2 ... iVec2Array) {
        return IG.cp(iVec2Array);
    }

    public static IVec4[] copy(IVec4 ... iVec4Array) {
        return IG.cp(iVec4Array);
    }

    public static boolean eq(double d, double d2) {
        return Math.abs(d - d2) <= IConfig.tolerance;
    }

    public static boolean eq(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    public static void initRand(int n) {
        IRand.init(n);
    }

    public static void initRandByTime() {
        IRand.initByTime();
    }

    public static void initRand() {
        IG.initRandByTime();
    }

    public static void seed(int n) {
        IG.initRand(n);
    }

    public static void seedByTime() {
        IG.initRandByTime();
    }

    public static void seedRand() {
        IG.initRandByTime();
    }

    public static double rand() {
        return IRand.get();
    }

    public static double rand(double d) {
        return IRand.get(d);
    }

    public static double rand(double d, double d2) {
        return IRand.get(d, d2);
    }

    public static float rand(float f) {
        return IRand.getf(f);
    }

    public static float rand(float f, float f2) {
        return IRand.getf(f, f2);
    }

    public static int rand(int n) {
        return IRand.geti(n);
    }

    public static int rand(int n, int n2) {
        return IRand.geti(n, n2);
    }

    public static IVec randPt() {
        return IRand.pt();
    }

    public static IVec randPt(double d) {
        return IRand.pt(d);
    }

    public static IVec randPt(double d, double d2) {
        return IRand.pt(d, d2);
    }

    public static IVec randPt(double d, double d2, double d3) {
        return IRand.pt(d, d2, d3);
    }

    public static IVec randPt(double d, double d2, double d3, double d4) {
        return IRand.pt(d, d2, d3, d4);
    }

    public static IVec randPt(double d, double d2, double d3, double d4, double d5, double d6) {
        return IRand.pt(d, d2, d3, d4, d5, d6);
    }

    public static IVec randDir() {
        return IRand.dir();
    }

    public static IVec randDir(double d) {
        return IRand.dir(d);
    }

    public static IVec randDir(IVecI iVecI) {
        return IRand.dir(iVecI);
    }

    public static IVec randDir(IVecI iVecI, double d) {
        return IRand.dir(iVecI, d);
    }

    public static IColor randClr() {
        return IRand.clr();
    }

    public static IColor randClr(float f) {
        return IRand.clr(f);
    }

    public static IColor randClr(int n) {
        return IRand.clr(n);
    }

    public static IColor randColor() {
        return IG.randClr();
    }

    public static IColor randColor(float f) {
        return IG.randClr(f);
    }

    public static IColor randColor(int n) {
        return IG.randClr(n);
    }

    public static IColor randGray() {
        return IRand.gray();
    }

    public static IColor randGray(float f) {
        return IRand.gray(f);
    }

    public static IColor randGray(int n) {
        return IRand.gray(n);
    }

    public static <T> T rand(T[] TArray) {
        return IRand.get(TArray);
    }

    public static <T> T rand(List<T> list) {
        return IRand.get(list);
    }

    public static boolean randPercent(double d) {
        return IG.pct(d);
    }

    public static boolean randPct(double d) {
        return IG.pct(d);
    }

    public static boolean percent(double d) {
        return IG.pct(d);
    }

    public static boolean pct(double d) {
        return IRand.pct(d);
    }

    public static IObject clr(IObject iObject, IColor iColor) {
        iObject.clr(iColor);
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, IColor iColor) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].clr(iColor);
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, IColor iColor) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).clr(iColor);
        }
        return arrayList;
    }

    public static IObject clr(IObject iObject, IColor iColor, int n) {
        iObject.clr(iColor, n);
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, IColor iColor, int n) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].clr(iColor, n);
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, IColor iColor, int n) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).clr(iColor, n);
        }
        return arrayList;
    }

    public static IObject clr(IObject iObject, IColor iColor, float f) {
        iObject.clr(iColor, f);
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, IColor iColor, float f) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].clr(iColor, f);
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, IColor iColor, float f) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).clr(iColor, f);
        }
        return arrayList;
    }

    public static IObject clr(IObject iObject, IColor iColor, double d) {
        iObject.clr(iColor, d);
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, IColor iColor, double d) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].clr(iColor, d);
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, IColor iColor, double d) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).clr(iColor, d);
        }
        return arrayList;
    }

    public static IObject clr(IObject iObject, Color color) {
        iObject.clr(color);
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, Color color) {
        return IG.clr(iObjectArray, new IColor(color));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, Color color) {
        return IG.clr(arrayList, new IColor(color));
    }

    public static IObject clr(IObject iObject, Color color, int n) {
        iObject.clr(new IColor(color, n));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, Color color, int n) {
        return IG.clr(iObjectArray, new IColor(color, n));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, Color color, int n) {
        return IG.clr(arrayList, new IColor(color, n));
    }

    public static IObject clr(IObject iObject, Color color, float f) {
        iObject.clr(new IColor(color, f));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, Color color, float f) {
        return IG.clr(iObjectArray, new IColor(color, f));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, Color color, float f) {
        return IG.clr(arrayList, new IColor(color, f));
    }

    public static IObject clr(IObject iObject, Color color, double d) {
        iObject.clr(new IColor(color, d));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, Color color, double d) {
        return IG.clr(iObjectArray, new IColor(color, d));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, Color color, double d) {
        return IG.clr(arrayList, new IColor(color, d));
    }

    public static IObject clr(IObject iObject, int n) {
        iObject.clr(new IColor(n));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, int n) {
        return IG.clr(iObjectArray, new IColor(n));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, int n) {
        return IG.clr(arrayList, new IColor(n));
    }

    public static IObject clr(IObject iObject, float f) {
        iObject.clr(new IColor(f));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, float f) {
        return IG.clr(iObjectArray, new IColor(f));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, float f) {
        return IG.clr(arrayList, new IColor(f));
    }

    public static IObject clr(IObject iObject, double d) {
        iObject.clr(new IColor(d));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, double d) {
        return IG.clr(iObjectArray, new IColor(d));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, double d) {
        return IG.clr(arrayList, new IColor(d));
    }

    public static IObject clr(IObject iObject, int n, int n2) {
        iObject.clr(new IColor(n, n2));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, int n, int n2) {
        return IG.clr(iObjectArray, new IColor(n, n2));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, int n, int n2) {
        return IG.clr(arrayList, new IColor(n, n2));
    }

    public static IObject clr(IObject iObject, float f, float f2) {
        iObject.clr(new IColor(f, f2));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, float f, float f2) {
        return IG.clr(iObjectArray, new IColor(f, f2));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, float f, float f2) {
        return IG.clr(arrayList, new IColor(f, f2));
    }

    public static IObject clr(IObject iObject, double d, double d2) {
        iObject.clr(new IColor(d, d2));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, double d, double d2) {
        return IG.clr(iObjectArray, new IColor(d, d2));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, double d, double d2) {
        return IG.clr(arrayList, new IColor(d, d2));
    }

    public static IObject clr(IObject iObject, int n, int n2, int n3) {
        iObject.clr(new IColor(n, n2, n3));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, int n, int n2, int n3) {
        return IG.clr(iObjectArray, new IColor(n, n2, n3));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, int n, int n2, int n3) {
        return IG.clr(arrayList, new IColor(n, n2, n3));
    }

    public static IObject clr(IObject iObject, double d, double d2, double d3) {
        iObject.clr(new IColor(d, d2, d3));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, double d, double d2, double d3) {
        return IG.clr(iObjectArray, new IColor(d, d2, d3));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, double d, double d2, double d3) {
        return IG.clr(arrayList, new IColor(d, d2, d3));
    }

    public static IObject clr(IObject iObject, float f, float f2, float f3) {
        iObject.clr(new IColor(f, f2, f3));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, float f, float f2, float f3) {
        return IG.clr(iObjectArray, new IColor(f, f2, f3));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, float f, float f2, float f3) {
        return IG.clr(arrayList, new IColor(f, f2, f3));
    }

    public static IObject clr(IObject iObject, int n, int n2, int n3, int n4) {
        iObject.clr(new IColor(n, n2, n3, n4));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, int n, int n2, int n3, int n4) {
        return IG.clr(iObjectArray, new IColor(n, n2, n3, n4));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, int n, int n2, int n3, int n4) {
        return IG.clr(arrayList, new IColor(n, n2, n3, n4));
    }

    public static IObject clr(IObject iObject, double d, double d2, double d3, double d4) {
        iObject.clr(new IColor(d, d2, d3, d4));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, double d, double d2, double d3, double d4) {
        return IG.clr(iObjectArray, new IColor(d, d2, d3, d4));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, double d, double d2, double d3, double d4) {
        return IG.clr(arrayList, new IColor(d, d2, d3, d4));
    }

    public static IObject clr(IObject iObject, float f, float f2, float f3, float f4) {
        iObject.clr(new IColor(f, f2, f3, f4));
        return iObject;
    }

    public static IObject[] clr(IObject[] iObjectArray, float f, float f2, float f3, float f4) {
        return IG.clr(iObjectArray, new IColor(f, f2, f3, f4));
    }

    public static ArrayList<IObject> clr(ArrayList<IObject> arrayList, float f, float f2, float f3, float f4) {
        return IG.clr(arrayList, new IColor(f, f2, f3, f4));
    }

    public static IObject hsb(IObject iObject, float f, float f2, float f3, float f4) {
        iObject.clr(IColor.hsb(f, f2, f3, f4));
        return iObject;
    }

    public static IObject[] hsb(IObject[] iObjectArray, float f, float f2, float f3, float f4) {
        return IG.clr(iObjectArray, IColor.hsb(f, f2, f3, f4));
    }

    public static ArrayList<IObject> hsb(ArrayList<IObject> arrayList, float f, float f2, float f3, float f4) {
        return IG.clr(arrayList, IColor.hsb(f, f2, f3, f4));
    }

    public static IObject hsb(IObject iObject, double d, double d2, double d3, double d4) {
        iObject.clr(IColor.hsb(d, d2, d3, d4));
        return iObject;
    }

    public static IObject[] hsb(IObject[] iObjectArray, double d, double d2, double d3, double d4) {
        return IG.clr(iObjectArray, IColor.hsb(d, d2, d3, d4));
    }

    public static ArrayList<IObject> hsb(ArrayList<IObject> arrayList, double d, double d2, double d3, double d4) {
        return IG.clr(arrayList, IColor.hsb(d, d2, d3, d4));
    }

    public static IObject hsb(IObject iObject, float f, float f2, float f3) {
        iObject.clr(IColor.hsb(f, f2, f3));
        return iObject;
    }

    public static IObject[] hsb(IObject[] iObjectArray, float f, float f2, float f3) {
        return IG.clr(iObjectArray, IColor.hsb(f, f2, f3));
    }

    public static ArrayList<IObject> hsb(ArrayList<IObject> arrayList, float f, float f2, float f3) {
        return IG.clr(arrayList, IColor.hsb(f, f2, f3));
    }

    public static IObject hsb(IObject iObject, double d, double d2, double d3) {
        iObject.clr(IColor.hsb(d, d2, d3));
        return iObject;
    }

    public static IObject[] hsb(IObject[] iObjectArray, double d, double d2, double d3) {
        return IG.clr(iObjectArray, IColor.hsb(d, d2, d3));
    }

    public static ArrayList<IObject> hsb(ArrayList<IObject> arrayList, double d, double d2, double d3) {
        return IG.clr(arrayList, IColor.hsb(d, d2, d3));
    }

    public static IObject weight(IObject iObject, double d) {
        iObject.weight(d);
        return iObject;
    }

    public static IObject[] weight(IObject[] iObjectArray, double d) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].weight(d);
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> weight(ArrayList<IObject> arrayList, double d) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).weight(d);
        }
        return arrayList;
    }

    public static IObject weight(IObject iObject, float f) {
        iObject.weight(f);
        return iObject;
    }

    public static IObject[] weight(IObject[] iObjectArray, float f) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].weight(f);
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> weight(ArrayList<IObject> arrayList, float f) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).weight(f);
        }
        return arrayList;
    }

    public static IObject hide(IObject iObject) {
        iObject.hide();
        return iObject;
    }

    public static IObject[] hide(IObject[] iObjectArray) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].hide();
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> hide(ArrayList<IObject> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).hide();
        }
        return arrayList;
    }

    public static IObject show(IObject iObject) {
        iObject.show();
        return iObject;
    }

    public static IObject[] show(IObject[] iObjectArray) {
        for (int i = 0; i < iObjectArray.length; ++i) {
            iObjectArray[i].show();
        }
        return iObjectArray;
    }

    public static ArrayList<IObject> show(ArrayList<IObject> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).show();
        }
        return arrayList;
    }
}

