/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IImageMap;
import igeo.gui.IImageLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.PixelGrabber;

public class IImageSequenceMap
extends IImageMap {
    public Image[] images;
    public int[][][] colorMaps;
    int imageIndex = 0;

    public IImageSequenceMap(String[] stringArray) {
        super(stringArray[0]);
        this.initMap(stringArray);
    }

    public IImageSequenceMap(Image[] imageArray) {
        super(imageArray[0]);
        this.initMap(imageArray);
    }

    public IImageSequenceMap(String[] stringArray, Component component) {
        super(stringArray[0], component);
        this.initMap(stringArray, component);
    }

    public void initMap(String[] stringArray) {
        Image[] imageArray = new Image[stringArray.length];
        for (int i = 0; i < imageArray.length; ++i) {
            imageArray[i] = IImageLoader.getImage(stringArray[i]);
        }
        this.initMap(imageArray);
    }

    public void initMap(String[] stringArray, Component component) {
        Image[] imageArray = new Image[stringArray.length];
        for (int i = 0; i < imageArray.length; ++i) {
            imageArray[i] = IImageLoader.getImage(stringArray[i], component);
        }
        this.initMap(imageArray);
    }

    public void initMap(Image[] imageArray) {
        this.images = imageArray;
        this.colorMaps = new int[this.images.length][][];
        for (int i = 0; i < this.images.length; ++i) {
            this.width = imageArray[i].getWidth(IImageLoader.observer);
            this.height = imageArray[i].getHeight(IImageLoader.observer);
            int[] nArray = new int[this.width * this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(imageArray[i], 0, 0, -1, -1, nArray, 0, this.width);
            if (pixelGrabber != null) {
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.colorMaps[i] = new int[this.width][this.height];
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    this.colorMaps[i][k][j] = nArray[this.width * j + k];
                }
            }
        }
    }

    public IImageSequenceMap next() {
        ++this.imageIndex;
        if (this.imageIndex >= this.images.length) {
            this.imageIndex = 0;
        }
        return this;
    }

    public Color getColor(double d, double d2) {
        return this.clr(d, d2);
    }

    public Color clr(double d, double d2) {
        if (this.interpolation) {
            int n = (int)((double)(this.width - 1) * d);
            int n2 = (int)((double)(this.height - 1) * d2);
            if (n < 0) {
                n = 0;
            } else if (n >= this.width) {
                n = this.width - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= this.height) {
                n2 = this.height - 1;
            }
            double d3 = (double)n / (double)(this.width - 1) - d;
            double d4 = (double)n2 / (double)(this.height - 1) - d2;
            if (d3 == 0.0 || n == this.width - 1) {
                if (d4 == 0.0 || n2 == this.height - 1) {
                    return IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n][n2]);
                }
                Color color = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n][n2]);
                Color color2 = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n][n2 + 1]);
                int n3 = (int)((double)color.getRed() * (1.0 - d4) + (double)color2.getRed() * d4);
                int n4 = (int)((double)color.getGreen() * (1.0 - d4) + (double)color2.getGreen() * d4);
                int n5 = (int)((double)color.getBlue() * (1.0 - d4) + (double)color2.getBlue() * d4);
                int n6 = (int)((double)color.getAlpha() * (1.0 - d4) + (double)color2.getAlpha() * d4);
                if (n3 < 0) {
                    n3 = 0;
                } else if (n3 > 255) {
                    n3 = 255;
                }
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > 255) {
                    n4 = 255;
                }
                if (n5 < 0) {
                    n5 = 0;
                } else if (n5 > 255) {
                    n5 = 255;
                }
                if (n6 < 0) {
                    n6 = 0;
                } else if (n6 > 255) {
                    n6 = 255;
                }
                return new Color(n3, n4, n5, n6);
            }
            if (d4 == 0.0 || n2 == this.height - 1) {
                Color color = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n][n2]);
                Color color3 = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n + 1][n2]);
                int n7 = (int)((double)color.getRed() * (1.0 - d3) + (double)color3.getRed() * d3);
                int n8 = (int)((double)color.getGreen() * (1.0 - d3) + (double)color3.getGreen() * d3);
                int n9 = (int)((double)color.getBlue() * (1.0 - d3) + (double)color3.getBlue() * d3);
                int n10 = (int)((double)color.getAlpha() * (1.0 - d3) + (double)color3.getAlpha() * d3);
                if (n7 < 0) {
                    n7 = 0;
                } else if (n7 > 255) {
                    n7 = 255;
                }
                if (n8 < 0) {
                    n8 = 0;
                } else if (n8 > 255) {
                    n8 = 255;
                }
                if (n9 < 0) {
                    n9 = 0;
                } else if (n9 > 255) {
                    n9 = 255;
                }
                if (n10 < 0) {
                    n10 = 0;
                } else if (n10 > 255) {
                    n10 = 255;
                }
                return new Color(n7, n8, n9, n10);
            }
            Color color = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n][n2]);
            Color color4 = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n + 1][n2]);
            Color color5 = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n][n2 + 1]);
            Color color6 = IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n + 1][n2 + 1]);
            int n11 = (int)(((double)color.getRed() * (1.0 - d3) + (double)color4.getRed() * d3) * (1.0 - d4) + ((double)color5.getRed() * (1.0 - d3) + (double)color6.getRed() * d3) * d4);
            int n12 = (int)(((double)color.getGreen() * (1.0 - d3) + (double)color4.getGreen() * d3) * (1.0 - d4) + ((double)color5.getGreen() * (1.0 - d3) + (double)color6.getGreen() * d3) * d4);
            int n13 = (int)(((double)color.getBlue() * (1.0 - d3) + (double)color4.getBlue() * d3) * (1.0 - d4) + ((double)color5.getBlue() * (1.0 - d3) + (double)color6.getBlue() * d3) * d4);
            int n14 = (int)(((double)color.getAlpha() * (1.0 - d3) + (double)color4.getAlpha() * d3) * (1.0 - d4) + ((double)color5.getAlpha() * (1.0 - d3) + (double)color6.getAlpha() * d3) * d4);
            if (n11 < 0) {
                n11 = 0;
            } else if (n11 > 255) {
                n11 = 255;
            }
            if (n12 < 0) {
                n12 = 0;
            } else if (n12 > 255) {
                n12 = 255;
            }
            if (n13 < 0) {
                n13 = 0;
            } else if (n13 > 255) {
                n13 = 255;
            }
            if (n14 < 0) {
                n14 = 0;
            } else if (n14 > 255) {
                n14 = 255;
            }
            return new Color(n11, n12, n13, n14);
        }
        int n = (int)((double)(this.width - 1) * d + 0.5);
        int n15 = (int)((double)(this.height - 1) * d2 + 0.5);
        if (n < 0) {
            n = 0;
        } else if (n >= this.width) {
            n = this.width - 1;
        }
        if (n15 < 0) {
            n15 = 0;
        } else if (n15 >= this.height) {
            n15 = this.height - 1;
        }
        return IImageSequenceMap.getColor(this.colorMaps[this.imageIndex][n][n15]);
    }
}

