/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.I3DFieldI;
import igeo.IConfig;
import igeo.IFieldGeo;
import igeo.IObject;
import igeo.IVec;
import igeo.IVecI;

public class IPointFieldGeo
extends IFieldGeo
implements I3DFieldI {
    public IVecI pos;
    public IVecI dir;

    public IPointFieldGeo(IVecI iVecI, IVecI iVecI2) {
        this.pos = iVecI;
        this.dir = iVecI2;
    }

    public IVecI getForce(IVecI iVecI, IVecI iVecI2) {
        return this.dir.dup();
    }

    public IVecI getForce(IVecI iVecI, IVecI iVecI2, IVecI iVecI3) {
        return this.getForce(iVecI, iVecI3);
    }

    public IVecI get(IVecI iVecI) {
        return this.get(iVecI, null);
    }

    public IVecI get(IVecI iVecI, IVecI iVecI2) {
        double d = this.intensity;
        if (this.pos != null) {
            double d2;
            if (this.decay == IFieldGeo.Decay.Linear) {
                d2 = this.pos.dist(iVecI);
                if (d2 >= this.threshold) {
                    return new IVec();
                }
                if (this.threshold > 0.0) {
                    d *= (this.threshold - d2) / this.threshold;
                }
            } else if (this.decay == IFieldGeo.Decay.Gaussian) {
                d2 = this.pos.dist(iVecI);
                if (this.threshold > 0.0) {
                    d *= Math.exp(-2.0 * d2 * d2 / (this.threshold * this.threshold));
                }
            } else if (this.decay == IFieldGeo.Decay.Custom && this.customDecay != null) {
                d2 = this.pos.dist(iVecI);
                d = this.customDecay.decay(this.intensity, d2, this.threshold);
            }
        }
        IVecI iVecI3 = this.getForce(iVecI, iVecI2, this.pos);
        if (this.bidirectional && iVecI3.get().dot(iVecI2) < 0.0) {
            d = -d;
        }
        if (this.constantIntensity) {
            double d3 = iVecI3.len();
            if (d3 < IConfig.tolerance) {
                return iVecI3.zero();
            }
            return iVecI3.len(d);
        }
        return iVecI3.mul(d);
    }

    public IVec pos() {
        return this.pos.get();
    }

    public IVec dir() {
        return this.dir.get();
    }

    public IPointFieldGeo noDecay() {
        super.noDecay();
        return this;
    }

    public IPointFieldGeo linearDecay(double d) {
        super.linearDecay(d);
        return this;
    }

    public IPointFieldGeo linear(double d) {
        super.linear(d);
        return this;
    }

    public IPointFieldGeo gaussianDecay(double d) {
        super.gaussianDecay(d);
        return this;
    }

    public IPointFieldGeo gaussian(double d) {
        super.gaussian(d);
        return this;
    }

    public IPointFieldGeo gauss(double d) {
        super.gauss(d);
        return this;
    }

    public IPointFieldGeo threshold(double d) {
        super.threshold(d);
        return this;
    }

    public IPointFieldGeo intensity(double d) {
        super.intensity(d);
        return this;
    }

    public void del() {
        if (this.pos != null && this.pos instanceof IObject) {
            ((IObject)((Object)this.pos)).del();
        }
        if (this.dir != null && this.dir instanceof IObject) {
            ((IObject)((Object)this.dir)).del();
        }
    }
}

