/*
 * Decompiled with CFR 0.152.
 */
package igeo;

import igeo.IBrep;
import igeo.IColor;
import igeo.ICurve;
import igeo.IDynamicServer;
import igeo.IG;
import igeo.IGeometry;
import igeo.IGraphicServer;
import igeo.ILayer;
import igeo.IMesh;
import igeo.IObject;
import igeo.IOut;
import igeo.IPoint;
import igeo.IPolycurve;
import igeo.IServerI;
import igeo.ISurface;
import igeo.IText;
import igeo.IUnit;
import igeo.gui.IGraphicMode;
import igeo.gui.IPanelI;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IServer
implements IServerI {
    public ArrayList<IObject> objects;
    public ArrayList<ILayer> layers;
    public IGraphicServer graphicServer;
    public IDynamicServer dynamicServer;
    public IG ig;
    public int stateCount = 0;
    public IUnit unit;

    public IServer(IG iG, IPanelI iPanelI) {
        this.ig = iG;
        this.objects = new ArrayList();
        if (iPanelI != null) {
            this.graphicServer = new IGraphicServer(this, iPanelI);
        }
        this.dynamicServer = new IDynamicServer(this);
        this.layers = new ArrayList();
        this.unit = new IUnit();
    }

    @Override
    public IServer server() {
        return this;
    }

    public IDynamicServer dynamicServer() {
        return this.dynamicServer;
    }

    public IGraphicServer graphicServer() {
        return this.graphicServer;
    }

    public IUnit unit() {
        return this.unit;
    }

    public void unit(IUnit iUnit) {
        this.unit = iUnit;
    }

    public void unit(IUnit.Type type) {
        this.unit = new IUnit(type);
    }

    public void unit(String string) {
        this.unit = new IUnit(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IObject iObject) {
        IG iG = this.ig;
        synchronized (iG) {
            if (!this.objects.contains(iObject)) {
                this.objects.add(iObject);
            }
            iObject.server = this;
            if (iObject instanceof ILayer) {
                this.layers.add((ILayer)iObject);
            }
            if (iObject.dynamicsNum() > 0) {
                this.dynamicServer.add(iObject);
            }
            this.updateState();
        }
    }

    public boolean isGraphicMode() {
        return this.graphicServer != null;
    }

    public void setGraphicMode(IGraphicMode iGraphicMode) {
        if (this.graphicServer != null) {
            this.graphicServer.setMode(iGraphicMode);
        } else {
            IOut.err("graphicServer is null");
        }
    }

    public void bg(IColor iColor, IColor iColor2, IColor iColor3, IColor iColor4) {
        if (this.graphicServer != null) {
            this.graphicServer.background(iColor, iColor2, iColor3, iColor4);
        } else {
            IOut.err("graphicServer is null");
        }
    }

    public void background(IColor iColor, IColor iColor2, IColor iColor3, IColor iColor4) {
        this.bg(iColor, iColor2, iColor3, iColor4);
    }

    public void bg(String string) {
        if (this.graphicServer != null) {
            this.graphicServer.background(string);
        } else {
            IOut.err("graphicServer is null");
        }
    }

    public void background(String string) {
        this.bg(string);
    }

    public ArrayList<IObject> getAllObjects() {
        return this.allObjects();
    }

    public ArrayList<IObject> allObjects() {
        return this.objects;
    }

    public IObject getObject(int n) {
        return this.object(n);
    }

    public IObject object(int n) {
        if (n < 0 || n >= this.objects.size()) {
            return null;
        }
        return this.objects.get(n);
    }

    public int objectNum() {
        return this.objects.size();
    }

    public int getObjectNum() {
        return this.objectNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        if (n < 0 || n >= this.objects.size()) {
            return;
        }
        IG iG = this.ig;
        synchronized (iG) {
            int n2;
            IObject iObject;
            if (this.graphicServer != null && this.objects.get((int)n).graphics != null) {
                iObject = this.objects.get(n);
                for (n2 = 0; n2 < iObject.graphics.size(); ++n2) {
                    this.graphicServer.remove(iObject.graphics.get(n2));
                }
            }
            if (this.objects.get((int)n).dynamics != null) {
                iObject = this.objects.get(n);
                for (n2 = 0; n2 < iObject.dynamics.size(); ++n2) {
                    this.dynamicServer.remove(iObject.dynamics.get(n2));
                }
            }
            this.objects.remove(n);
            this.updateState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IObject iObject) {
        IG iG = this.ig;
        synchronized (iG) {
            int n;
            if (this.graphicServer != null && iObject.graphics != null) {
                for (n = 0; n < iObject.graphics.size(); ++n) {
                    this.graphicServer.remove(iObject.graphics.get(n));
                }
            }
            if (iObject.dynamics != null) {
                for (n = 0; n < iObject.dynamics.size(); ++n) {
                    this.dynamicServer.remove(iObject.dynamics.get(n));
                }
            }
            if (iObject.attribute != null && iObject.attribute.layer != null) {
                iObject.attribute.layer.remove(iObject);
            }
            this.objects.remove(iObject);
            if (iObject instanceof ILayer) {
                this.layers.remove(iObject);
            }
            this.updateState();
        }
    }

    public void clear() {
        this.objects.clear();
        if (this.graphicServer != null) {
            this.graphicServer.clearObjects();
        }
        if (this.dynamicServer != null) {
            this.dynamicServer.clear();
        }
        this.layers.clear();
        this.updateState();
    }

    public int stateCount() {
        return this.stateCount;
    }

    public void updateState() {
        ++this.stateCount;
    }

    public void duration(int n) {
        this.dynamicServer.duration(n);
    }

    public int duration() {
        return this.dynamicServer.duration();
    }

    public void time(int n) {
        this.dynamicServer.time(n);
    }

    public int time() {
        return this.dynamicServer.time();
    }

    public void pause() {
        this.dynamicServer.pause();
    }

    public void resume() {
        this.dynamicServer.resume();
    }

    public boolean isRunning() {
        return this.dynamicServer.isRunning();
    }

    public void start() {
        this.dynamicServer.start();
    }

    public void stop() {
        this.dynamicServer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPoint[] points() {
        ArrayList<IPoint> arrayList = new ArrayList<IPoint>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPoint)) continue;
                arrayList.add((IPoint)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IPoint[arrayList.size()]);
    }

    public IPoint[] getPoints() {
        return this.points();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICurve[] curves() {
        ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ICurve)) continue;
                arrayList.add((ICurve)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ICurve[arrayList.size()]);
    }

    public ICurve[] getCurves() {
        return this.curves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPolycurve[] polycurves() {
        ArrayList<IPolycurve> arrayList = new ArrayList<IPolycurve>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPolycurve)) continue;
                arrayList.add((IPolycurve)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IPolycurve[arrayList.size()]);
    }

    public IPolycurve[] getPolycurves() {
        return this.polycurves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurface[] surfaces() {
        ArrayList<ISurface> arrayList = new ArrayList<ISurface>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ISurface)) continue;
                arrayList.add((ISurface)this.objects.get(i));
            }
        }
        return arrayList.toArray(new ISurface[arrayList.size()]);
    }

    public ISurface[] getSurfaces() {
        return this.surfaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMesh[] meshes() {
        ArrayList<IMesh> arrayList = new ArrayList<IMesh>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IMesh)) continue;
                arrayList.add((IMesh)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IMesh[arrayList.size()]);
    }

    public IMesh[] getMeshes() {
        return this.meshes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBrep[] breps() {
        ArrayList<IBrep> arrayList = new ArrayList<IBrep>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IBrep)) continue;
                arrayList.add((IBrep)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IBrep[arrayList.size()]);
    }

    public IBrep[] getBreps() {
        return this.breps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IText[] texts() {
        ArrayList<IText> arrayList = new ArrayList<IText>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IText)) continue;
                arrayList.add((IText)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IText[arrayList.size()]);
    }

    public IText[] getTexts() {
        return this.texts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGeometry[] geometries() {
        ArrayList<IGeometry> arrayList = new ArrayList<IGeometry>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IGeometry)) continue;
                arrayList.add((IGeometry)this.objects.get(i));
            }
        }
        return arrayList.toArray(new IGeometry[arrayList.size()]);
    }

    public IGeometry[] getGeometries() {
        return this.breps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObject[] objects(Class clazz) {
        ArrayList<IObject> arrayList = new ArrayList<IObject>();
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!clazz.isInstance(this.objects.get(i))) continue;
                arrayList.add(this.objects.get(i));
            }
        }
        return arrayList.toArray(new IObject[arrayList.size()]);
    }

    public IObject[] getObjects(Class clazz) {
        return this.objects(clazz);
    }

    public IObject[] objects() {
        return this.objects.toArray(new IObject[this.objects.size()]);
    }

    public IObject[] getObjects() {
        return this.objects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPoint point(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPoint) || n != n2++) continue;
                return (IPoint)this.objects.get(i);
            }
        }
        return null;
    }

    public IPoint getPoint(int n) {
        return this.point(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICurve curve(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ICurve) || n != n2++) continue;
                return (ICurve)this.objects.get(i);
            }
        }
        return null;
    }

    public ICurve getCurve(int n) {
        return this.curve(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPolycurve polycurve(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPolycurve) || n != n2++) continue;
                return (IPolycurve)this.objects.get(i);
            }
        }
        return null;
    }

    public IPolycurve getPolycurve(int n) {
        return this.polycurve(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISurface surface(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ISurface) || n != n2++) continue;
                return (ISurface)this.objects.get(i);
            }
        }
        return null;
    }

    public ISurface getSurface(int n) {
        return this.surface(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMesh mesh(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IMesh) || n != n2++) continue;
                return (IMesh)this.objects.get(i);
            }
        }
        return null;
    }

    public IMesh getMesh(int n) {
        return this.mesh(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBrep brep(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IBrep) || n != n2++) continue;
                return (IBrep)this.objects.get(i);
            }
        }
        return null;
    }

    public IBrep getBrep(int n) {
        return this.brep(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IText text(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IText) || n != n2++) continue;
                return (IText)this.objects.get(i);
            }
        }
        return null;
    }

    public IText getText(int n) {
        return this.text(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGeometry geometry(int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IGeometry) || n != n2++) continue;
                return (IGeometry)this.objects.get(i);
            }
        }
        return null;
    }

    public IGeometry getGeometry(int n) {
        return this.geometry(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObject object(Class clazz, int n) {
        int n2 = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!clazz.isInstance(this.objects.get(i)) || n != n2++) continue;
                return this.objects.get(i);
            }
        }
        return null;
    }

    public IObject getObject(Class clazz, int n) {
        return this.object(clazz, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pointNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPoint)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getPointNum() {
        return this.pointNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int curveNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ICurve)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getCurveNum() {
        return this.curveNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int polycurveNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IPolycurve)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getPolycurveNum() {
        return this.polycurveNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int surfaceNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof ISurface)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getSurfaceNum() {
        return this.surfaceNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int meshNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IMesh)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getMeshNum() {
        return this.meshNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int brepNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IBrep)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getBrepNum() {
        return this.brepNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int textNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IText)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getTextNum() {
        return this.textNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int geometryNum() {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!(this.objects.get(i) instanceof IGeometry)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getGeometryNum() {
        return this.geometryNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int objectNum(Class clazz) {
        int n = 0;
        IG iG = this.ig;
        synchronized (iG) {
            for (int i = 0; i < this.objects.size(); ++i) {
                if (!clazz.isInstance(this.objects.get(i))) continue;
                ++n;
            }
        }
        return n;
    }

    public int getObjectNum(Class clazz) {
        return this.objectNum(clazz);
    }

    public int layerNum() {
        return this.layers.size();
    }

    public ILayer layer(int n) {
        return this.layers.get(n);
    }

    public ILayer getLayer(int n) {
        return this.layer(n);
    }

    public ILayer[] layers() {
        return this.layers.toArray(new ILayer[this.layers.size()]);
    }

    public ILayer[] getAllLayers() {
        return this.layers();
    }

    public ILayer getLayer(String string) {
        return this.layer(string);
    }

    public ILayer layer(String string) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!this.layers.get(i).name().equals(string)) continue;
            return this.layers.get(i);
        }
        return new ILayer((IServerI)this, string);
    }

    public void deleteLayer(String string) {
        ILayer iLayer = null;
        for (int i = 0; i < this.layers.size() && iLayer == null; ++i) {
            if (!this.layers.get(i).name().equals(string)) continue;
            iLayer = this.layers.get(i);
        }
        if (iLayer != null) {
            this.remove(iLayer);
        }
    }

    public void deleteLayer(int n) {
        this.remove(this.layers.get(n));
    }

    public void deleteLayer(ILayer iLayer) {
        this.remove(iLayer);
    }
}

